# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetContentLibraryItemResult',
    'AwaitableGetContentLibraryItemResult',
    'get_content_library_item',
    'get_content_library_item_output',
]

@pulumi.output_type
class GetContentLibraryItemResult:
    """
    A collection of values returned by getContentLibraryItem.
    """
    def __init__(__self__, id=None, library_id=None, name=None, type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if library_id and not isinstance(library_id, str):
            raise TypeError("Expected argument 'library_id' to be a str")
        pulumi.set(__self__, "library_id", library_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="libraryId")
    def library_id(self) -> builtins.str:
        return pulumi.get(self, "library_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        return pulumi.get(self, "type")


class AwaitableGetContentLibraryItemResult(GetContentLibraryItemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContentLibraryItemResult(
            id=self.id,
            library_id=self.library_id,
            name=self.name,
            type=self.type)


def get_content_library_item(library_id: Optional[builtins.str] = None,
                             name: Optional[builtins.str] = None,
                             type: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContentLibraryItemResult:
    """
    The `ContentLibraryItem` data source can be used to discover the ID
    of a content library item.

    > **NOTE:** This resource requires vCenter and is not available on direct ESXi
    host connections.


    :param builtins.str library_id: The ID of the content library in which the item
           exists.
    :param builtins.str name: The name of the content library item.
    :param builtins.str type: The type for the content library item. One of `ovf`,
           `vm-template`, or `iso`
    """
    __args__ = dict()
    __args__['libraryId'] = library_id
    __args__['name'] = name
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vsphere:index/getContentLibraryItem:getContentLibraryItem', __args__, opts=opts, typ=GetContentLibraryItemResult).value

    return AwaitableGetContentLibraryItemResult(
        id=pulumi.get(__ret__, 'id'),
        library_id=pulumi.get(__ret__, 'library_id'),
        name=pulumi.get(__ret__, 'name'),
        type=pulumi.get(__ret__, 'type'))
def get_content_library_item_output(library_id: Optional[pulumi.Input[builtins.str]] = None,
                                    name: Optional[pulumi.Input[builtins.str]] = None,
                                    type: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContentLibraryItemResult]:
    """
    The `ContentLibraryItem` data source can be used to discover the ID
    of a content library item.

    > **NOTE:** This resource requires vCenter and is not available on direct ESXi
    host connections.


    :param builtins.str library_id: The ID of the content library in which the item
           exists.
    :param builtins.str name: The name of the content library item.
    :param builtins.str type: The type for the content library item. One of `ovf`,
           `vm-template`, or `iso`
    """
    __args__ = dict()
    __args__['libraryId'] = library_id
    __args__['name'] = name
    __args__['type'] = type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vsphere:index/getContentLibraryItem:getContentLibraryItem', __args__, opts=opts, typ=GetContentLibraryItemResult)
    return __ret__.apply(lambda __response__: GetContentLibraryItemResult(
        id=pulumi.get(__response__, 'id'),
        library_id=pulumi.get(__response__, 'library_id'),
        name=pulumi.get(__response__, 'name'),
        type=pulumi.get(__response__, 'type')))
