# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDatastoreResult',
    'AwaitableGetDatastoreResult',
    'get_datastore',
    'get_datastore_output',
]

@pulumi.output_type
class GetDatastoreResult:
    """
    A collection of values returned by getDatastore.
    """
    def __init__(__self__, datacenter_id=None, id=None, name=None, stats=None):
        if datacenter_id and not isinstance(datacenter_id, str):
            raise TypeError("Expected argument 'datacenter_id' to be a str")
        pulumi.set(__self__, "datacenter_id", datacenter_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if stats and not isinstance(stats, dict):
            raise TypeError("Expected argument 'stats' to be a dict")
        pulumi.set(__self__, "stats", stats)

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "datacenter_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def stats(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The disk space usage statistics for the specific datastore. The
        total datastore capacity is represented as `capacity` and the free remaining
        disk is represented as `free`.
        """
        return pulumi.get(self, "stats")


class AwaitableGetDatastoreResult(GetDatastoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatastoreResult(
            datacenter_id=self.datacenter_id,
            id=self.id,
            name=self.name,
            stats=self.stats)


def get_datastore(datacenter_id: Optional[builtins.str] = None,
                  name: Optional[builtins.str] = None,
                  stats: Optional[Mapping[str, builtins.str]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatastoreResult:
    """
    The `get_datastore` data source can be used to discover the ID of a
    vSphere datastore object. This can then be used with resources or data sources
    that require a datastore. For example, to create virtual machines in using the
    `VirtualMachine` resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    datastore = vsphere.get_datastore(name="datastore-01",
        datacenter_id=datacenter.id)
    ```


    :param builtins.str datacenter_id: The managed object reference ID
           of the datacenter the datastore is located in. This can be omitted if the
           search path used in `name` is an absolute path. For default datacenters, use
           the `id` attribute from an empty `Datacenter` data source.
    :param builtins.str name: The name of the datastore. This can be a name or path.
    :param Mapping[str, builtins.str] stats: The disk space usage statistics for the specific datastore. The
           total datastore capacity is represented as `capacity` and the free remaining
           disk is represented as `free`.
    """
    __args__ = dict()
    __args__['datacenterId'] = datacenter_id
    __args__['name'] = name
    __args__['stats'] = stats
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vsphere:index/getDatastore:getDatastore', __args__, opts=opts, typ=GetDatastoreResult).value

    return AwaitableGetDatastoreResult(
        datacenter_id=pulumi.get(__ret__, 'datacenter_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        stats=pulumi.get(__ret__, 'stats'))
def get_datastore_output(datacenter_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         name: Optional[pulumi.Input[builtins.str]] = None,
                         stats: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatastoreResult]:
    """
    The `get_datastore` data source can be used to discover the ID of a
    vSphere datastore object. This can then be used with resources or data sources
    that require a datastore. For example, to create virtual machines in using the
    `VirtualMachine` resource.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    datastore = vsphere.get_datastore(name="datastore-01",
        datacenter_id=datacenter.id)
    ```


    :param builtins.str datacenter_id: The managed object reference ID
           of the datacenter the datastore is located in. This can be omitted if the
           search path used in `name` is an absolute path. For default datacenters, use
           the `id` attribute from an empty `Datacenter` data source.
    :param builtins.str name: The name of the datastore. This can be a name or path.
    :param Mapping[str, builtins.str] stats: The disk space usage statistics for the specific datastore. The
           total datastore capacity is represented as `capacity` and the free remaining
           disk is represented as `free`.
    """
    __args__ = dict()
    __args__['datacenterId'] = datacenter_id
    __args__['name'] = name
    __args__['stats'] = stats
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vsphere:index/getDatastore:getDatastore', __args__, opts=opts, typ=GetDatastoreResult)
    return __ret__.apply(lambda __response__: GetDatastoreResult(
        datacenter_id=pulumi.get(__response__, 'datacenter_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        stats=pulumi.get(__response__, 'stats')))
