# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetFolderResult',
    'AwaitableGetFolderResult',
    'get_folder',
    'get_folder_output',
]

@pulumi.output_type
class GetFolderResult:
    """
    A collection of values returned by getFolder.
    """
    def __init__(__self__, id=None, path=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        return pulumi.get(self, "path")


class AwaitableGetFolderResult(GetFolderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFolderResult(
            id=self.id,
            path=self.path)


def get_folder(path: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFolderResult:
    """
    The `Folder` data source can be used to get the general attributes of a
    vSphere inventory folder. The data source supports creating folders of the 5
    major types - datacenter folders, host and cluster folders, virtual machine
    folders, storage folders, and network folders.

    Paths are absolute and must include the datacenter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter_folder_folder = vsphere.Folder("datacenter_folder",
        path="example-datacenter-folder",
        type="datacenter")
    datacenter_folder = vsphere.get_folder_output(path=datacenter_folder_folder.path.apply(lambda path: f"/{path}"))
    datacenter_datacenter = vsphere.Datacenter("datacenter",
        name="example-datacenter",
        folder=datacenter_folder.path,
        opts = pulumi.ResourceOptions(depends_on=[datacenter_folder]))
    datacenter = vsphere.get_datacenter_output(name=datacenter_datacenter.name)
    vm_folder_folder = vsphere.Folder("vm_folder",
        path="example-vm-folder",
        type="vm",
        datacenter_id=datacenter.id)
    datastore_folder_folder = vsphere.Folder("datastore_folder",
        path="example-datastore-folder",
        type="datastore",
        datacenter_id=datacenter.id)
    network_folder_folder = vsphere.Folder("network_folder",
        path="example-network-folder",
        type="network",
        datacenter_id=datacenter.id)
    host_folder_folder = vsphere.Folder("host_folder",
        path="example-host-folder",
        type="host",
        datacenter_id=datacenter.id)
    vm_folder = vsphere.get_folder_output(path=pulumi.Output.all(
        datacenterFolderFolderPath=datacenter_folder_folder.path,
        name=datacenter_datacenter.name,
        vmFolderFolderPath=vm_folder_folder.path
    ).apply(lambda resolved_outputs: f"/{resolved_outputs['datacenterFolderFolderPath']}/{resolved_outputs['name']}/vm/{resolved_outputs['vmFolderFolderPath']}")
    )
    datastore_folder = vsphere.get_folder_output(path=pulumi.Output.all(
        datacenterFolderFolderPath=datacenter_folder_folder.path,
        name=datacenter_datacenter.name,
        datastoreFolderFolderPath=datastore_folder_folder.path
    ).apply(lambda resolved_outputs: f"/{resolved_outputs['datacenterFolderFolderPath']}/{resolved_outputs['name']}/datastore/{resolved_outputs['datastoreFolderFolderPath']}")
    )
    network_folder = vsphere.get_folder_output(path=pulumi.Output.all(
        datacenterFolderFolderPath=datacenter_folder_folder.path,
        name=datacenter_datacenter.name,
        networkFolderFolderPath=network_folder_folder.path
    ).apply(lambda resolved_outputs: f"/{resolved_outputs['datacenterFolderFolderPath']}/{resolved_outputs['name']}/network/{resolved_outputs['networkFolderFolderPath']}")
    )
    host_folder = vsphere.get_folder_output(path=pulumi.Output.all(
        datacenterFolderFolderPath=datacenter_folder_folder.path,
        name=datacenter_datacenter.name,
        hostFolderFolderPath=host_folder_folder.path
    ).apply(lambda resolved_outputs: f"/{resolved_outputs['datacenterFolderFolderPath']}/{resolved_outputs['name']}/host/{resolved_outputs['hostFolderFolderPath']}")
    )
    pulumi.export("vmFolderId", vm_folder.id)
    pulumi.export("datastoreFolderId", datastore_folder.id)
    pulumi.export("networkFolderId", network_folder.id)
    pulumi.export("hostFolderId", host_folder.id)
    pulumi.export("datacenterId", datacenter.id)
    pulumi.export("datacenterFolderPath", datacenter_folder_folder.path)
    ```


    :param builtins.str path: The absolute path of the folder. For example, given a
           default datacenter of `default-dc`, a folder of type `vm`, and a folder name
           of `example-vm-folder`, the resulting `path` would be
           `/default-dc/vm/example-vm-folder`.
           
           For nested datacenters, include the full hierarchy in the path. For example, if datacenter
           `default-dc` is inside folder `parent-folder`, the path to a VM folder would be
           `/parent-folder/default-dc/vm/example-vm-folder`.
           
           The valid folder types to be used in a `path` are: `vm`, `host`, `datacenter`, `datastore`, or `network`.
           
           Always include a leading slash in the `path`.
    """
    __args__ = dict()
    __args__['path'] = path
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vsphere:index/getFolder:getFolder', __args__, opts=opts, typ=GetFolderResult).value

    return AwaitableGetFolderResult(
        id=pulumi.get(__ret__, 'id'),
        path=pulumi.get(__ret__, 'path'))
def get_folder_output(path: Optional[pulumi.Input[builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFolderResult]:
    """
    The `Folder` data source can be used to get the general attributes of a
    vSphere inventory folder. The data source supports creating folders of the 5
    major types - datacenter folders, host and cluster folders, virtual machine
    folders, storage folders, and network folders.

    Paths are absolute and must include the datacenter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter_folder_folder = vsphere.Folder("datacenter_folder",
        path="example-datacenter-folder",
        type="datacenter")
    datacenter_folder = vsphere.get_folder_output(path=datacenter_folder_folder.path.apply(lambda path: f"/{path}"))
    datacenter_datacenter = vsphere.Datacenter("datacenter",
        name="example-datacenter",
        folder=datacenter_folder.path,
        opts = pulumi.ResourceOptions(depends_on=[datacenter_folder]))
    datacenter = vsphere.get_datacenter_output(name=datacenter_datacenter.name)
    vm_folder_folder = vsphere.Folder("vm_folder",
        path="example-vm-folder",
        type="vm",
        datacenter_id=datacenter.id)
    datastore_folder_folder = vsphere.Folder("datastore_folder",
        path="example-datastore-folder",
        type="datastore",
        datacenter_id=datacenter.id)
    network_folder_folder = vsphere.Folder("network_folder",
        path="example-network-folder",
        type="network",
        datacenter_id=datacenter.id)
    host_folder_folder = vsphere.Folder("host_folder",
        path="example-host-folder",
        type="host",
        datacenter_id=datacenter.id)
    vm_folder = vsphere.get_folder_output(path=pulumi.Output.all(
        datacenterFolderFolderPath=datacenter_folder_folder.path,
        name=datacenter_datacenter.name,
        vmFolderFolderPath=vm_folder_folder.path
    ).apply(lambda resolved_outputs: f"/{resolved_outputs['datacenterFolderFolderPath']}/{resolved_outputs['name']}/vm/{resolved_outputs['vmFolderFolderPath']}")
    )
    datastore_folder = vsphere.get_folder_output(path=pulumi.Output.all(
        datacenterFolderFolderPath=datacenter_folder_folder.path,
        name=datacenter_datacenter.name,
        datastoreFolderFolderPath=datastore_folder_folder.path
    ).apply(lambda resolved_outputs: f"/{resolved_outputs['datacenterFolderFolderPath']}/{resolved_outputs['name']}/datastore/{resolved_outputs['datastoreFolderFolderPath']}")
    )
    network_folder = vsphere.get_folder_output(path=pulumi.Output.all(
        datacenterFolderFolderPath=datacenter_folder_folder.path,
        name=datacenter_datacenter.name,
        networkFolderFolderPath=network_folder_folder.path
    ).apply(lambda resolved_outputs: f"/{resolved_outputs['datacenterFolderFolderPath']}/{resolved_outputs['name']}/network/{resolved_outputs['networkFolderFolderPath']}")
    )
    host_folder = vsphere.get_folder_output(path=pulumi.Output.all(
        datacenterFolderFolderPath=datacenter_folder_folder.path,
        name=datacenter_datacenter.name,
        hostFolderFolderPath=host_folder_folder.path
    ).apply(lambda resolved_outputs: f"/{resolved_outputs['datacenterFolderFolderPath']}/{resolved_outputs['name']}/host/{resolved_outputs['hostFolderFolderPath']}")
    )
    pulumi.export("vmFolderId", vm_folder.id)
    pulumi.export("datastoreFolderId", datastore_folder.id)
    pulumi.export("networkFolderId", network_folder.id)
    pulumi.export("hostFolderId", host_folder.id)
    pulumi.export("datacenterId", datacenter.id)
    pulumi.export("datacenterFolderPath", datacenter_folder_folder.path)
    ```


    :param builtins.str path: The absolute path of the folder. For example, given a
           default datacenter of `default-dc`, a folder of type `vm`, and a folder name
           of `example-vm-folder`, the resulting `path` would be
           `/default-dc/vm/example-vm-folder`.
           
           For nested datacenters, include the full hierarchy in the path. For example, if datacenter
           `default-dc` is inside folder `parent-folder`, the path to a VM folder would be
           `/parent-folder/default-dc/vm/example-vm-folder`.
           
           The valid folder types to be used in a `path` are: `vm`, `host`, `datacenter`, `datastore`, or `network`.
           
           Always include a leading slash in the `path`.
    """
    __args__ = dict()
    __args__['path'] = path
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vsphere:index/getFolder:getFolder', __args__, opts=opts, typ=GetFolderResult)
    return __ret__.apply(lambda __response__: GetFolderResult(
        id=pulumi.get(__response__, 'id'),
        path=pulumi.get(__response__, 'path')))
