# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetHostResult',
    'AwaitableGetHostResult',
    'get_host',
    'get_host_output',
]

@pulumi.output_type
class GetHostResult:
    """
    A collection of values returned by getHost.
    """
    def __init__(__self__, datacenter_id=None, id=None, name=None, resource_pool_id=None):
        if datacenter_id and not isinstance(datacenter_id, str):
            raise TypeError("Expected argument 'datacenter_id' to be a str")
        pulumi.set(__self__, "datacenter_id", datacenter_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_pool_id and not isinstance(resource_pool_id, str):
            raise TypeError("Expected argument 'resource_pool_id' to be a str")
        pulumi.set(__self__, "resource_pool_id", resource_pool_id)

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> builtins.str:
        return pulumi.get(self, "datacenter_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourcePoolId")
    def resource_pool_id(self) -> builtins.str:
        """
        The managed object ID of the ESXi
        host's root resource pool.
        """
        return pulumi.get(self, "resource_pool_id")


class AwaitableGetHostResult(GetHostResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostResult(
            datacenter_id=self.datacenter_id,
            id=self.id,
            name=self.name,
            resource_pool_id=self.resource_pool_id)


def get_host(datacenter_id: Optional[builtins.str] = None,
             name: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostResult:
    """
    The `Host` data source can be used to discover the ID of an ESXi host.
    This can then be used with resources or data sources that require an ESX
    host's managed object reference ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    host = vsphere.get_host(name="esxi-01.example.com",
        datacenter_id=datacenter.id)
    ```


    :param builtins.str datacenter_id: The managed object reference ID
           of a vSphere datacenter object.
    :param builtins.str name: The name of the ESXI host. This can be a name or path.
           Can be omitted if there is only one host in your inventory.
           
           > **NOTE:** When used against an ESXi host directly, this data source _always_
           returns the ESXi host's object ID, regardless of what is entered into `name`.
    """
    __args__ = dict()
    __args__['datacenterId'] = datacenter_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vsphere:index/getHost:getHost', __args__, opts=opts, typ=GetHostResult).value

    return AwaitableGetHostResult(
        datacenter_id=pulumi.get(__ret__, 'datacenter_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        resource_pool_id=pulumi.get(__ret__, 'resource_pool_id'))
def get_host_output(datacenter_id: Optional[pulumi.Input[builtins.str]] = None,
                    name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHostResult]:
    """
    The `Host` data source can be used to discover the ID of an ESXi host.
    This can then be used with resources or data sources that require an ESX
    host's managed object reference ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    host = vsphere.get_host(name="esxi-01.example.com",
        datacenter_id=datacenter.id)
    ```


    :param builtins.str datacenter_id: The managed object reference ID
           of a vSphere datacenter object.
    :param builtins.str name: The name of the ESXI host. This can be a name or path.
           Can be omitted if there is only one host in your inventory.
           
           > **NOTE:** When used against an ESXi host directly, this data source _always_
           returns the ESXi host's object ID, regardless of what is entered into `name`.
    """
    __args__ = dict()
    __args__['datacenterId'] = datacenter_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vsphere:index/getHost:getHost', __args__, opts=opts, typ=GetHostResult)
    return __ret__.apply(lambda __response__: GetHostResult(
        datacenter_id=pulumi.get(__response__, 'datacenter_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        resource_pool_id=pulumi.get(__response__, 'resource_pool_id')))
