# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVirtualMachineResult',
    'AwaitableGetVirtualMachineResult',
    'get_virtual_machine',
    'get_virtual_machine_output',
]

@pulumi.output_type
class GetVirtualMachineResult:
    """
    A collection of values returned by getVirtualMachine.
    """
    def __init__(__self__, alternate_guest_name=None, annotation=None, boot_delay=None, boot_retry_delay=None, boot_retry_enabled=None, change_version=None, cpu_hot_add_enabled=None, cpu_hot_remove_enabled=None, cpu_limit=None, cpu_performance_counters_enabled=None, cpu_reservation=None, cpu_share_count=None, cpu_share_level=None, datacenter_id=None, default_ip_address=None, disks=None, efi_secure_boot_enabled=None, enable_disk_uuid=None, enable_logging=None, ept_rvi_mode=None, extra_config=None, extra_config_reboot_required=None, firmware=None, folder=None, guest_id=None, guest_ip_addresses=None, hardware_version=None, hv_mode=None, id=None, ide_controller_scan_count=None, instance_uuid=None, latency_sensitivity=None, memory=None, memory_hot_add_enabled=None, memory_limit=None, memory_reservation=None, memory_reservation_locked_to_max=None, memory_share_count=None, memory_share_level=None, moid=None, name=None, nested_hv_enabled=None, network_interface_types=None, network_interfaces=None, num_cores_per_socket=None, num_cpus=None, nvme_controller_scan_count=None, replace_trigger=None, run_tools_scripts_after_power_on=None, run_tools_scripts_after_resume=None, run_tools_scripts_before_guest_reboot=None, run_tools_scripts_before_guest_shutdown=None, run_tools_scripts_before_guest_standby=None, sata_controller_scan_count=None, scsi_bus_sharing=None, scsi_controller_scan_count=None, scsi_type=None, storage_policy_id=None, swap_placement_policy=None, sync_time_with_host=None, sync_time_with_host_periodically=None, tools_upgrade_policy=None, uuid=None, vapp=None, vapp_transports=None, vbs_enabled=None, vtpm=None, vvtd_enabled=None):
        if alternate_guest_name and not isinstance(alternate_guest_name, str):
            raise TypeError("Expected argument 'alternate_guest_name' to be a str")
        pulumi.set(__self__, "alternate_guest_name", alternate_guest_name)
        if annotation and not isinstance(annotation, str):
            raise TypeError("Expected argument 'annotation' to be a str")
        pulumi.set(__self__, "annotation", annotation)
        if boot_delay and not isinstance(boot_delay, int):
            raise TypeError("Expected argument 'boot_delay' to be a int")
        pulumi.set(__self__, "boot_delay", boot_delay)
        if boot_retry_delay and not isinstance(boot_retry_delay, int):
            raise TypeError("Expected argument 'boot_retry_delay' to be a int")
        pulumi.set(__self__, "boot_retry_delay", boot_retry_delay)
        if boot_retry_enabled and not isinstance(boot_retry_enabled, bool):
            raise TypeError("Expected argument 'boot_retry_enabled' to be a bool")
        pulumi.set(__self__, "boot_retry_enabled", boot_retry_enabled)
        if change_version and not isinstance(change_version, str):
            raise TypeError("Expected argument 'change_version' to be a str")
        pulumi.set(__self__, "change_version", change_version)
        if cpu_hot_add_enabled and not isinstance(cpu_hot_add_enabled, bool):
            raise TypeError("Expected argument 'cpu_hot_add_enabled' to be a bool")
        pulumi.set(__self__, "cpu_hot_add_enabled", cpu_hot_add_enabled)
        if cpu_hot_remove_enabled and not isinstance(cpu_hot_remove_enabled, bool):
            raise TypeError("Expected argument 'cpu_hot_remove_enabled' to be a bool")
        pulumi.set(__self__, "cpu_hot_remove_enabled", cpu_hot_remove_enabled)
        if cpu_limit and not isinstance(cpu_limit, int):
            raise TypeError("Expected argument 'cpu_limit' to be a int")
        pulumi.set(__self__, "cpu_limit", cpu_limit)
        if cpu_performance_counters_enabled and not isinstance(cpu_performance_counters_enabled, bool):
            raise TypeError("Expected argument 'cpu_performance_counters_enabled' to be a bool")
        pulumi.set(__self__, "cpu_performance_counters_enabled", cpu_performance_counters_enabled)
        if cpu_reservation and not isinstance(cpu_reservation, int):
            raise TypeError("Expected argument 'cpu_reservation' to be a int")
        pulumi.set(__self__, "cpu_reservation", cpu_reservation)
        if cpu_share_count and not isinstance(cpu_share_count, int):
            raise TypeError("Expected argument 'cpu_share_count' to be a int")
        pulumi.set(__self__, "cpu_share_count", cpu_share_count)
        if cpu_share_level and not isinstance(cpu_share_level, str):
            raise TypeError("Expected argument 'cpu_share_level' to be a str")
        pulumi.set(__self__, "cpu_share_level", cpu_share_level)
        if datacenter_id and not isinstance(datacenter_id, str):
            raise TypeError("Expected argument 'datacenter_id' to be a str")
        pulumi.set(__self__, "datacenter_id", datacenter_id)
        if default_ip_address and not isinstance(default_ip_address, str):
            raise TypeError("Expected argument 'default_ip_address' to be a str")
        pulumi.set(__self__, "default_ip_address", default_ip_address)
        if disks and not isinstance(disks, list):
            raise TypeError("Expected argument 'disks' to be a list")
        pulumi.set(__self__, "disks", disks)
        if efi_secure_boot_enabled and not isinstance(efi_secure_boot_enabled, bool):
            raise TypeError("Expected argument 'efi_secure_boot_enabled' to be a bool")
        pulumi.set(__self__, "efi_secure_boot_enabled", efi_secure_boot_enabled)
        if enable_disk_uuid and not isinstance(enable_disk_uuid, bool):
            raise TypeError("Expected argument 'enable_disk_uuid' to be a bool")
        pulumi.set(__self__, "enable_disk_uuid", enable_disk_uuid)
        if enable_logging and not isinstance(enable_logging, bool):
            raise TypeError("Expected argument 'enable_logging' to be a bool")
        pulumi.set(__self__, "enable_logging", enable_logging)
        if ept_rvi_mode and not isinstance(ept_rvi_mode, str):
            raise TypeError("Expected argument 'ept_rvi_mode' to be a str")
        pulumi.set(__self__, "ept_rvi_mode", ept_rvi_mode)
        if extra_config and not isinstance(extra_config, dict):
            raise TypeError("Expected argument 'extra_config' to be a dict")
        pulumi.set(__self__, "extra_config", extra_config)
        if extra_config_reboot_required and not isinstance(extra_config_reboot_required, bool):
            raise TypeError("Expected argument 'extra_config_reboot_required' to be a bool")
        pulumi.set(__self__, "extra_config_reboot_required", extra_config_reboot_required)
        if firmware and not isinstance(firmware, str):
            raise TypeError("Expected argument 'firmware' to be a str")
        pulumi.set(__self__, "firmware", firmware)
        if folder and not isinstance(folder, str):
            raise TypeError("Expected argument 'folder' to be a str")
        pulumi.set(__self__, "folder", folder)
        if guest_id and not isinstance(guest_id, str):
            raise TypeError("Expected argument 'guest_id' to be a str")
        pulumi.set(__self__, "guest_id", guest_id)
        if guest_ip_addresses and not isinstance(guest_ip_addresses, list):
            raise TypeError("Expected argument 'guest_ip_addresses' to be a list")
        pulumi.set(__self__, "guest_ip_addresses", guest_ip_addresses)
        if hardware_version and not isinstance(hardware_version, int):
            raise TypeError("Expected argument 'hardware_version' to be a int")
        pulumi.set(__self__, "hardware_version", hardware_version)
        if hv_mode and not isinstance(hv_mode, str):
            raise TypeError("Expected argument 'hv_mode' to be a str")
        pulumi.set(__self__, "hv_mode", hv_mode)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ide_controller_scan_count and not isinstance(ide_controller_scan_count, int):
            raise TypeError("Expected argument 'ide_controller_scan_count' to be a int")
        pulumi.set(__self__, "ide_controller_scan_count", ide_controller_scan_count)
        if instance_uuid and not isinstance(instance_uuid, str):
            raise TypeError("Expected argument 'instance_uuid' to be a str")
        pulumi.set(__self__, "instance_uuid", instance_uuid)
        if latency_sensitivity and not isinstance(latency_sensitivity, str):
            raise TypeError("Expected argument 'latency_sensitivity' to be a str")
        pulumi.set(__self__, "latency_sensitivity", latency_sensitivity)
        if memory and not isinstance(memory, int):
            raise TypeError("Expected argument 'memory' to be a int")
        pulumi.set(__self__, "memory", memory)
        if memory_hot_add_enabled and not isinstance(memory_hot_add_enabled, bool):
            raise TypeError("Expected argument 'memory_hot_add_enabled' to be a bool")
        pulumi.set(__self__, "memory_hot_add_enabled", memory_hot_add_enabled)
        if memory_limit and not isinstance(memory_limit, int):
            raise TypeError("Expected argument 'memory_limit' to be a int")
        pulumi.set(__self__, "memory_limit", memory_limit)
        if memory_reservation and not isinstance(memory_reservation, int):
            raise TypeError("Expected argument 'memory_reservation' to be a int")
        pulumi.set(__self__, "memory_reservation", memory_reservation)
        if memory_reservation_locked_to_max and not isinstance(memory_reservation_locked_to_max, bool):
            raise TypeError("Expected argument 'memory_reservation_locked_to_max' to be a bool")
        pulumi.set(__self__, "memory_reservation_locked_to_max", memory_reservation_locked_to_max)
        if memory_share_count and not isinstance(memory_share_count, int):
            raise TypeError("Expected argument 'memory_share_count' to be a int")
        pulumi.set(__self__, "memory_share_count", memory_share_count)
        if memory_share_level and not isinstance(memory_share_level, str):
            raise TypeError("Expected argument 'memory_share_level' to be a str")
        pulumi.set(__self__, "memory_share_level", memory_share_level)
        if moid and not isinstance(moid, str):
            raise TypeError("Expected argument 'moid' to be a str")
        pulumi.set(__self__, "moid", moid)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nested_hv_enabled and not isinstance(nested_hv_enabled, bool):
            raise TypeError("Expected argument 'nested_hv_enabled' to be a bool")
        pulumi.set(__self__, "nested_hv_enabled", nested_hv_enabled)
        if network_interface_types and not isinstance(network_interface_types, list):
            raise TypeError("Expected argument 'network_interface_types' to be a list")
        pulumi.set(__self__, "network_interface_types", network_interface_types)
        if network_interfaces and not isinstance(network_interfaces, list):
            raise TypeError("Expected argument 'network_interfaces' to be a list")
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        if num_cores_per_socket and not isinstance(num_cores_per_socket, int):
            raise TypeError("Expected argument 'num_cores_per_socket' to be a int")
        pulumi.set(__self__, "num_cores_per_socket", num_cores_per_socket)
        if num_cpus and not isinstance(num_cpus, int):
            raise TypeError("Expected argument 'num_cpus' to be a int")
        pulumi.set(__self__, "num_cpus", num_cpus)
        if nvme_controller_scan_count and not isinstance(nvme_controller_scan_count, int):
            raise TypeError("Expected argument 'nvme_controller_scan_count' to be a int")
        pulumi.set(__self__, "nvme_controller_scan_count", nvme_controller_scan_count)
        if replace_trigger and not isinstance(replace_trigger, str):
            raise TypeError("Expected argument 'replace_trigger' to be a str")
        pulumi.set(__self__, "replace_trigger", replace_trigger)
        if run_tools_scripts_after_power_on and not isinstance(run_tools_scripts_after_power_on, bool):
            raise TypeError("Expected argument 'run_tools_scripts_after_power_on' to be a bool")
        pulumi.set(__self__, "run_tools_scripts_after_power_on", run_tools_scripts_after_power_on)
        if run_tools_scripts_after_resume and not isinstance(run_tools_scripts_after_resume, bool):
            raise TypeError("Expected argument 'run_tools_scripts_after_resume' to be a bool")
        pulumi.set(__self__, "run_tools_scripts_after_resume", run_tools_scripts_after_resume)
        if run_tools_scripts_before_guest_reboot and not isinstance(run_tools_scripts_before_guest_reboot, bool):
            raise TypeError("Expected argument 'run_tools_scripts_before_guest_reboot' to be a bool")
        pulumi.set(__self__, "run_tools_scripts_before_guest_reboot", run_tools_scripts_before_guest_reboot)
        if run_tools_scripts_before_guest_shutdown and not isinstance(run_tools_scripts_before_guest_shutdown, bool):
            raise TypeError("Expected argument 'run_tools_scripts_before_guest_shutdown' to be a bool")
        pulumi.set(__self__, "run_tools_scripts_before_guest_shutdown", run_tools_scripts_before_guest_shutdown)
        if run_tools_scripts_before_guest_standby and not isinstance(run_tools_scripts_before_guest_standby, bool):
            raise TypeError("Expected argument 'run_tools_scripts_before_guest_standby' to be a bool")
        pulumi.set(__self__, "run_tools_scripts_before_guest_standby", run_tools_scripts_before_guest_standby)
        if sata_controller_scan_count and not isinstance(sata_controller_scan_count, int):
            raise TypeError("Expected argument 'sata_controller_scan_count' to be a int")
        pulumi.set(__self__, "sata_controller_scan_count", sata_controller_scan_count)
        if scsi_bus_sharing and not isinstance(scsi_bus_sharing, str):
            raise TypeError("Expected argument 'scsi_bus_sharing' to be a str")
        pulumi.set(__self__, "scsi_bus_sharing", scsi_bus_sharing)
        if scsi_controller_scan_count and not isinstance(scsi_controller_scan_count, int):
            raise TypeError("Expected argument 'scsi_controller_scan_count' to be a int")
        pulumi.set(__self__, "scsi_controller_scan_count", scsi_controller_scan_count)
        if scsi_type and not isinstance(scsi_type, str):
            raise TypeError("Expected argument 'scsi_type' to be a str")
        pulumi.set(__self__, "scsi_type", scsi_type)
        if storage_policy_id and not isinstance(storage_policy_id, str):
            raise TypeError("Expected argument 'storage_policy_id' to be a str")
        pulumi.set(__self__, "storage_policy_id", storage_policy_id)
        if swap_placement_policy and not isinstance(swap_placement_policy, str):
            raise TypeError("Expected argument 'swap_placement_policy' to be a str")
        pulumi.set(__self__, "swap_placement_policy", swap_placement_policy)
        if sync_time_with_host and not isinstance(sync_time_with_host, bool):
            raise TypeError("Expected argument 'sync_time_with_host' to be a bool")
        pulumi.set(__self__, "sync_time_with_host", sync_time_with_host)
        if sync_time_with_host_periodically and not isinstance(sync_time_with_host_periodically, bool):
            raise TypeError("Expected argument 'sync_time_with_host_periodically' to be a bool")
        pulumi.set(__self__, "sync_time_with_host_periodically", sync_time_with_host_periodically)
        if tools_upgrade_policy and not isinstance(tools_upgrade_policy, str):
            raise TypeError("Expected argument 'tools_upgrade_policy' to be a str")
        pulumi.set(__self__, "tools_upgrade_policy", tools_upgrade_policy)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)
        if vapp and not isinstance(vapp, dict):
            raise TypeError("Expected argument 'vapp' to be a dict")
        pulumi.set(__self__, "vapp", vapp)
        if vapp_transports and not isinstance(vapp_transports, list):
            raise TypeError("Expected argument 'vapp_transports' to be a list")
        pulumi.set(__self__, "vapp_transports", vapp_transports)
        if vbs_enabled and not isinstance(vbs_enabled, bool):
            raise TypeError("Expected argument 'vbs_enabled' to be a bool")
        pulumi.set(__self__, "vbs_enabled", vbs_enabled)
        if vtpm and not isinstance(vtpm, bool):
            raise TypeError("Expected argument 'vtpm' to be a bool")
        pulumi.set(__self__, "vtpm", vtpm)
        if vvtd_enabled and not isinstance(vvtd_enabled, bool):
            raise TypeError("Expected argument 'vvtd_enabled' to be a bool")
        pulumi.set(__self__, "vvtd_enabled", vvtd_enabled)

    @property
    @pulumi.getter(name="alternateGuestName")
    def alternate_guest_name(self) -> Optional[builtins.str]:
        """
        The alternate guest name of the virtual machine when
        `guest_id` is a non-specific operating system, like `otherGuest` or
        `otherGuest64`.
        """
        return pulumi.get(self, "alternate_guest_name")

    @property
    @pulumi.getter
    def annotation(self) -> builtins.str:
        """
        The user-provided description of this virtual machine.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter(name="bootDelay")
    def boot_delay(self) -> Optional[builtins.int]:
        return pulumi.get(self, "boot_delay")

    @property
    @pulumi.getter(name="bootRetryDelay")
    def boot_retry_delay(self) -> Optional[builtins.int]:
        return pulumi.get(self, "boot_retry_delay")

    @property
    @pulumi.getter(name="bootRetryEnabled")
    def boot_retry_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "boot_retry_enabled")

    @property
    @pulumi.getter(name="changeVersion")
    def change_version(self) -> builtins.str:
        return pulumi.get(self, "change_version")

    @property
    @pulumi.getter(name="cpuHotAddEnabled")
    def cpu_hot_add_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "cpu_hot_add_enabled")

    @property
    @pulumi.getter(name="cpuHotRemoveEnabled")
    def cpu_hot_remove_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "cpu_hot_remove_enabled")

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[builtins.int]:
        return pulumi.get(self, "cpu_limit")

    @property
    @pulumi.getter(name="cpuPerformanceCountersEnabled")
    def cpu_performance_counters_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "cpu_performance_counters_enabled")

    @property
    @pulumi.getter(name="cpuReservation")
    def cpu_reservation(self) -> Optional[builtins.int]:
        return pulumi.get(self, "cpu_reservation")

    @property
    @pulumi.getter(name="cpuShareCount")
    def cpu_share_count(self) -> builtins.int:
        return pulumi.get(self, "cpu_share_count")

    @property
    @pulumi.getter(name="cpuShareLevel")
    def cpu_share_level(self) -> Optional[builtins.str]:
        return pulumi.get(self, "cpu_share_level")

    @property
    @pulumi.getter(name="datacenterId")
    def datacenter_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "datacenter_id")

    @property
    @pulumi.getter(name="defaultIpAddress")
    def default_ip_address(self) -> builtins.str:
        """
        Whenever possible, this is the first IPv4 address that
        is reachable through the default gateway configured on the machine, then the
        first reachable IPv6 address, and then the first general discovered address if
        neither exist. If VMware Tools is not running on the virtual machine, or if
        the VM is powered off, this value will be blank.
        """
        return pulumi.get(self, "default_ip_address")

    @property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.GetVirtualMachineDiskResult']:
        """
        Information about each of the disks on this virtual machine or
        template. These are sorted by bus and unit number so that they can be applied
        to a `VirtualMachine` resource in the order the resource expects
        while cloning. This is useful for discovering certain disk settings while
        performing a linked clone, as all settings that are output by this data source
        must be the same on the destination virtual machine as the source. Only the
        first number of controllers defined by `scsi_controller_scan_count` are
        scanned for disks. The sub-attributes are:
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="efiSecureBootEnabled")
    def efi_secure_boot_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "efi_secure_boot_enabled")

    @property
    @pulumi.getter(name="enableDiskUuid")
    def enable_disk_uuid(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enable_disk_uuid")

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "enable_logging")

    @property
    @pulumi.getter(name="eptRviMode")
    def ept_rvi_mode(self) -> builtins.str:
        return pulumi.get(self, "ept_rvi_mode")

    @property
    @pulumi.getter(name="extraConfig")
    def extra_config(self) -> Optional[Mapping[str, builtins.str]]:
        return pulumi.get(self, "extra_config")

    @property
    @pulumi.getter(name="extraConfigRebootRequired")
    def extra_config_reboot_required(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "extra_config_reboot_required")

    @property
    @pulumi.getter
    def firmware(self) -> Optional[builtins.str]:
        """
        The firmware type for this virtual machine. Can be `bios` or
        `efi`.
        """
        return pulumi.get(self, "firmware")

    @property
    @pulumi.getter
    def folder(self) -> Optional[builtins.str]:
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter(name="guestId")
    def guest_id(self) -> builtins.str:
        """
        The guest ID of the virtual machine or template.
        """
        return pulumi.get(self, "guest_id")

    @property
    @pulumi.getter(name="guestIpAddresses")
    def guest_ip_addresses(self) -> Sequence[builtins.str]:
        """
        A list of IP addresses as reported by VMware Tools.
        """
        return pulumi.get(self, "guest_ip_addresses")

    @property
    @pulumi.getter(name="hardwareVersion")
    def hardware_version(self) -> builtins.int:
        """
        The hardware version number on this virtual machine.
        """
        return pulumi.get(self, "hardware_version")

    @property
    @pulumi.getter(name="hvMode")
    def hv_mode(self) -> builtins.str:
        return pulumi.get(self, "hv_mode")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ideControllerScanCount")
    def ide_controller_scan_count(self) -> Optional[builtins.int]:
        return pulumi.get(self, "ide_controller_scan_count")

    @property
    @pulumi.getter(name="instanceUuid")
    def instance_uuid(self) -> builtins.str:
        """
        The instance UUID of the virtual machine or template.
        """
        return pulumi.get(self, "instance_uuid")

    @property
    @pulumi.getter(name="latencySensitivity")
    def latency_sensitivity(self) -> Optional[builtins.str]:
        return pulumi.get(self, "latency_sensitivity")

    @property
    @pulumi.getter
    def memory(self) -> Optional[builtins.int]:
        """
        The size of the virtual machine's memory, in MB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="memoryHotAddEnabled")
    def memory_hot_add_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "memory_hot_add_enabled")

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[builtins.int]:
        return pulumi.get(self, "memory_limit")

    @property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[builtins.int]:
        return pulumi.get(self, "memory_reservation")

    @property
    @pulumi.getter(name="memoryReservationLockedToMax")
    def memory_reservation_locked_to_max(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "memory_reservation_locked_to_max")

    @property
    @pulumi.getter(name="memoryShareCount")
    def memory_share_count(self) -> builtins.int:
        return pulumi.get(self, "memory_share_count")

    @property
    @pulumi.getter(name="memoryShareLevel")
    def memory_share_level(self) -> Optional[builtins.str]:
        return pulumi.get(self, "memory_share_level")

    @property
    @pulumi.getter
    def moid(self) -> builtins.str:
        return pulumi.get(self, "moid")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nestedHvEnabled")
    def nested_hv_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "nested_hv_enabled")

    @property
    @pulumi.getter(name="networkInterfaceTypes")
    def network_interface_types(self) -> Sequence[builtins.str]:
        """
        The network interface types for each network
        interface found on the virtual machine, in device bus order. Will be one of
        `e1000`, `e1000e`, `pcnet32`, `sriov`, `vmxnet2`, `vmxnet3vrdma`, or
        `vmxnet3`.
        """
        return pulumi.get(self, "network_interface_types")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.GetVirtualMachineNetworkInterfaceResult']:
        """
        Information about each of the network interfaces on
        this virtual machine or template. These are sorted by device bus order so that
        they can be applied to a `VirtualMachine` resource in the order the
        resource expects while cloning. This is useful for discovering certain network
        interface settings while performing a linked clone, as all settings that are
        output by this data source must be the same on the destination virtual machine
        as the source. The sub-attributes are:
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="numCoresPerSocket")
    def num_cores_per_socket(self) -> Optional[builtins.int]:
        """
        The number of cores per socket for this virtual
        machine.
        """
        return pulumi.get(self, "num_cores_per_socket")

    @property
    @pulumi.getter(name="numCpus")
    def num_cpus(self) -> Optional[builtins.int]:
        """
        The total number of virtual processor cores assigned to this
        virtual machine.
        """
        return pulumi.get(self, "num_cpus")

    @property
    @pulumi.getter(name="nvmeControllerScanCount")
    def nvme_controller_scan_count(self) -> Optional[builtins.int]:
        return pulumi.get(self, "nvme_controller_scan_count")

    @property
    @pulumi.getter(name="replaceTrigger")
    def replace_trigger(self) -> Optional[builtins.str]:
        return pulumi.get(self, "replace_trigger")

    @property
    @pulumi.getter(name="runToolsScriptsAfterPowerOn")
    def run_tools_scripts_after_power_on(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "run_tools_scripts_after_power_on")

    @property
    @pulumi.getter(name="runToolsScriptsAfterResume")
    def run_tools_scripts_after_resume(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "run_tools_scripts_after_resume")

    @property
    @pulumi.getter(name="runToolsScriptsBeforeGuestReboot")
    def run_tools_scripts_before_guest_reboot(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "run_tools_scripts_before_guest_reboot")

    @property
    @pulumi.getter(name="runToolsScriptsBeforeGuestShutdown")
    def run_tools_scripts_before_guest_shutdown(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "run_tools_scripts_before_guest_shutdown")

    @property
    @pulumi.getter(name="runToolsScriptsBeforeGuestStandby")
    def run_tools_scripts_before_guest_standby(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "run_tools_scripts_before_guest_standby")

    @property
    @pulumi.getter(name="sataControllerScanCount")
    def sata_controller_scan_count(self) -> Optional[builtins.int]:
        return pulumi.get(self, "sata_controller_scan_count")

    @property
    @pulumi.getter(name="scsiBusSharing")
    def scsi_bus_sharing(self) -> builtins.str:
        """
        Mode for sharing the SCSI bus. The modes are
        physicalSharing, virtualSharing, and noSharing. Only the first number of
        controllers defined by `scsi_controller_scan_count` are scanned.
        """
        return pulumi.get(self, "scsi_bus_sharing")

    @property
    @pulumi.getter(name="scsiControllerScanCount")
    def scsi_controller_scan_count(self) -> Optional[builtins.int]:
        return pulumi.get(self, "scsi_controller_scan_count")

    @property
    @pulumi.getter(name="scsiType")
    def scsi_type(self) -> builtins.str:
        """
        The common type of all SCSI controllers on this virtual machine.
        Will be one of `lsilogic` (LSI Logic Parallel), `lsilogic-sas` (LSI Logic
        SAS), `pvscsi` (VMware Paravirtual), `buslogic` (BusLogic), or `mixed` when
        there are multiple controller types. Only the first number of controllers
        defined by `scsi_controller_scan_count` are scanned.
        """
        return pulumi.get(self, "scsi_type")

    @property
    @pulumi.getter(name="storagePolicyId")
    def storage_policy_id(self) -> builtins.str:
        return pulumi.get(self, "storage_policy_id")

    @property
    @pulumi.getter(name="swapPlacementPolicy")
    def swap_placement_policy(self) -> Optional[builtins.str]:
        return pulumi.get(self, "swap_placement_policy")

    @property
    @pulumi.getter(name="syncTimeWithHost")
    def sync_time_with_host(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "sync_time_with_host")

    @property
    @pulumi.getter(name="syncTimeWithHostPeriodically")
    def sync_time_with_host_periodically(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "sync_time_with_host_periodically")

    @property
    @pulumi.getter(name="toolsUpgradePolicy")
    def tools_upgrade_policy(self) -> Optional[builtins.str]:
        return pulumi.get(self, "tools_upgrade_policy")

    @property
    @pulumi.getter
    def uuid(self) -> builtins.str:
        return pulumi.get(self, "uuid")

    @property
    @pulumi.getter
    def vapp(self) -> Optional['outputs.GetVirtualMachineVappResult']:
        return pulumi.get(self, "vapp")

    @property
    @pulumi.getter(name="vappTransports")
    def vapp_transports(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "vapp_transports")

    @property
    @pulumi.getter(name="vbsEnabled")
    def vbs_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "vbs_enabled")

    @property
    @pulumi.getter
    def vtpm(self) -> builtins.bool:
        """
        Indicates whether a virtual Trusted Platform Module (TPM) device is present on the virtual machine.
        """
        return pulumi.get(self, "vtpm")

    @property
    @pulumi.getter(name="vvtdEnabled")
    def vvtd_enabled(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "vvtd_enabled")


class AwaitableGetVirtualMachineResult(GetVirtualMachineResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualMachineResult(
            alternate_guest_name=self.alternate_guest_name,
            annotation=self.annotation,
            boot_delay=self.boot_delay,
            boot_retry_delay=self.boot_retry_delay,
            boot_retry_enabled=self.boot_retry_enabled,
            change_version=self.change_version,
            cpu_hot_add_enabled=self.cpu_hot_add_enabled,
            cpu_hot_remove_enabled=self.cpu_hot_remove_enabled,
            cpu_limit=self.cpu_limit,
            cpu_performance_counters_enabled=self.cpu_performance_counters_enabled,
            cpu_reservation=self.cpu_reservation,
            cpu_share_count=self.cpu_share_count,
            cpu_share_level=self.cpu_share_level,
            datacenter_id=self.datacenter_id,
            default_ip_address=self.default_ip_address,
            disks=self.disks,
            efi_secure_boot_enabled=self.efi_secure_boot_enabled,
            enable_disk_uuid=self.enable_disk_uuid,
            enable_logging=self.enable_logging,
            ept_rvi_mode=self.ept_rvi_mode,
            extra_config=self.extra_config,
            extra_config_reboot_required=self.extra_config_reboot_required,
            firmware=self.firmware,
            folder=self.folder,
            guest_id=self.guest_id,
            guest_ip_addresses=self.guest_ip_addresses,
            hardware_version=self.hardware_version,
            hv_mode=self.hv_mode,
            id=self.id,
            ide_controller_scan_count=self.ide_controller_scan_count,
            instance_uuid=self.instance_uuid,
            latency_sensitivity=self.latency_sensitivity,
            memory=self.memory,
            memory_hot_add_enabled=self.memory_hot_add_enabled,
            memory_limit=self.memory_limit,
            memory_reservation=self.memory_reservation,
            memory_reservation_locked_to_max=self.memory_reservation_locked_to_max,
            memory_share_count=self.memory_share_count,
            memory_share_level=self.memory_share_level,
            moid=self.moid,
            name=self.name,
            nested_hv_enabled=self.nested_hv_enabled,
            network_interface_types=self.network_interface_types,
            network_interfaces=self.network_interfaces,
            num_cores_per_socket=self.num_cores_per_socket,
            num_cpus=self.num_cpus,
            nvme_controller_scan_count=self.nvme_controller_scan_count,
            replace_trigger=self.replace_trigger,
            run_tools_scripts_after_power_on=self.run_tools_scripts_after_power_on,
            run_tools_scripts_after_resume=self.run_tools_scripts_after_resume,
            run_tools_scripts_before_guest_reboot=self.run_tools_scripts_before_guest_reboot,
            run_tools_scripts_before_guest_shutdown=self.run_tools_scripts_before_guest_shutdown,
            run_tools_scripts_before_guest_standby=self.run_tools_scripts_before_guest_standby,
            sata_controller_scan_count=self.sata_controller_scan_count,
            scsi_bus_sharing=self.scsi_bus_sharing,
            scsi_controller_scan_count=self.scsi_controller_scan_count,
            scsi_type=self.scsi_type,
            storage_policy_id=self.storage_policy_id,
            swap_placement_policy=self.swap_placement_policy,
            sync_time_with_host=self.sync_time_with_host,
            sync_time_with_host_periodically=self.sync_time_with_host_periodically,
            tools_upgrade_policy=self.tools_upgrade_policy,
            uuid=self.uuid,
            vapp=self.vapp,
            vapp_transports=self.vapp_transports,
            vbs_enabled=self.vbs_enabled,
            vtpm=self.vtpm,
            vvtd_enabled=self.vvtd_enabled)


def get_virtual_machine(alternate_guest_name: Optional[builtins.str] = None,
                        annotation: Optional[builtins.str] = None,
                        boot_delay: Optional[builtins.int] = None,
                        boot_retry_delay: Optional[builtins.int] = None,
                        boot_retry_enabled: Optional[builtins.bool] = None,
                        cpu_hot_add_enabled: Optional[builtins.bool] = None,
                        cpu_hot_remove_enabled: Optional[builtins.bool] = None,
                        cpu_limit: Optional[builtins.int] = None,
                        cpu_performance_counters_enabled: Optional[builtins.bool] = None,
                        cpu_reservation: Optional[builtins.int] = None,
                        cpu_share_count: Optional[builtins.int] = None,
                        cpu_share_level: Optional[builtins.str] = None,
                        datacenter_id: Optional[builtins.str] = None,
                        efi_secure_boot_enabled: Optional[builtins.bool] = None,
                        enable_disk_uuid: Optional[builtins.bool] = None,
                        enable_logging: Optional[builtins.bool] = None,
                        ept_rvi_mode: Optional[builtins.str] = None,
                        extra_config: Optional[Mapping[str, builtins.str]] = None,
                        extra_config_reboot_required: Optional[builtins.bool] = None,
                        firmware: Optional[builtins.str] = None,
                        folder: Optional[builtins.str] = None,
                        guest_id: Optional[builtins.str] = None,
                        hardware_version: Optional[builtins.int] = None,
                        hv_mode: Optional[builtins.str] = None,
                        ide_controller_scan_count: Optional[builtins.int] = None,
                        latency_sensitivity: Optional[builtins.str] = None,
                        memory: Optional[builtins.int] = None,
                        memory_hot_add_enabled: Optional[builtins.bool] = None,
                        memory_limit: Optional[builtins.int] = None,
                        memory_reservation: Optional[builtins.int] = None,
                        memory_reservation_locked_to_max: Optional[builtins.bool] = None,
                        memory_share_count: Optional[builtins.int] = None,
                        memory_share_level: Optional[builtins.str] = None,
                        moid: Optional[builtins.str] = None,
                        name: Optional[builtins.str] = None,
                        nested_hv_enabled: Optional[builtins.bool] = None,
                        num_cores_per_socket: Optional[builtins.int] = None,
                        num_cpus: Optional[builtins.int] = None,
                        nvme_controller_scan_count: Optional[builtins.int] = None,
                        replace_trigger: Optional[builtins.str] = None,
                        run_tools_scripts_after_power_on: Optional[builtins.bool] = None,
                        run_tools_scripts_after_resume: Optional[builtins.bool] = None,
                        run_tools_scripts_before_guest_reboot: Optional[builtins.bool] = None,
                        run_tools_scripts_before_guest_shutdown: Optional[builtins.bool] = None,
                        run_tools_scripts_before_guest_standby: Optional[builtins.bool] = None,
                        sata_controller_scan_count: Optional[builtins.int] = None,
                        scsi_controller_scan_count: Optional[builtins.int] = None,
                        storage_policy_id: Optional[builtins.str] = None,
                        swap_placement_policy: Optional[builtins.str] = None,
                        sync_time_with_host: Optional[builtins.bool] = None,
                        sync_time_with_host_periodically: Optional[builtins.bool] = None,
                        tools_upgrade_policy: Optional[builtins.str] = None,
                        uuid: Optional[builtins.str] = None,
                        vapp: Optional[Union['GetVirtualMachineVappArgs', 'GetVirtualMachineVappArgsDict']] = None,
                        vbs_enabled: Optional[builtins.bool] = None,
                        vvtd_enabled: Optional[builtins.bool] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualMachineResult:
    """
    The `VirtualMachine` data source can be used to find the UUID of an
    existing virtual machine or template. The most common purpose is for finding
    the UUID of a template to be used as the source for cloning to a new
    `VirtualMachine` resource. It also
    reads the guest ID so that can be supplied as well.

    ## Example Usage

    In the following example, a virtual machine template is returned by its unique
    name within the `Datacenter`.

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    template = vsphere.get_virtual_machine(name="ubuntu-server-template",
        datacenter_id=datacenter.id)
    ```

    In the following example, each virtual machine template is returned by its
    unique full path within the `Datacenter`.

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    production_template = vsphere.get_virtual_machine(name="production/templates/ubuntu-server-template",
        datacenter_id=datacenter.id)
    development_template = vsphere.get_virtual_machine(name="development/templates/ubuntu-server-template",
        datacenter_id=datacenter.id)
    ```


    :param builtins.str alternate_guest_name: The alternate guest name of the virtual machine when
           `guest_id` is a non-specific operating system, like `otherGuest` or
           `otherGuest64`.
    :param builtins.str annotation: The user-provided description of this virtual machine.
    :param builtins.str datacenter_id: The managed object reference
           ID of the datacenter the virtual machine is located in.
           This can be omitted if the search path used in `name` is an absolute path.
           For default datacenters, use the `id` attribute from an empty
           `Datacenter` data source.
    :param builtins.str firmware: The firmware type for this virtual machine. Can be `bios` or
           `efi`.
    :param builtins.str folder: The name of the virtual machine folder where the virtual machine is located. The `name` argument is limited to 80 characters. If the `name` argument includes the full path to the virtual machine and exceeds the 80 characters limit, the `folder` folder argument can be used.
    :param builtins.str guest_id: The guest ID of the virtual machine or template.
    :param builtins.int hardware_version: The hardware version number on this virtual machine.
    :param builtins.int memory: The size of the virtual machine's memory, in MB.
    :param builtins.str name: The name of the virtual machine. This can be a name or
           the full path relative to the datacenter. This is required if a UUID lookup
           is not performed.
    :param builtins.int num_cores_per_socket: The number of cores per socket for this virtual
           machine.
    :param builtins.int num_cpus: The total number of virtual processor cores assigned to this
           virtual machine.
    :param builtins.int nvme_controller_scan_count: The number of NVMe controllers to
           scan for disk attributes and controller types on. Default: `1`.
           
           > **NOTE:** For best results, ensure that all the disks on any templates you
           use with this data source reside on the primary controller, and leave this
           value at the default. See the `VirtualMachine`
           resource documentation for the significance of this setting, specifically the
           additional requirements and notes for cloning section.
    :param builtins.int scsi_controller_scan_count: The number of SCSI controllers to
           scan for disk attributes and controller types on. Default: `1`.
    :param builtins.str uuid: Specify this field for a UUID lookup, `name` and `datacenter_id`
           are not required if this is specified.
    """
    __args__ = dict()
    __args__['alternateGuestName'] = alternate_guest_name
    __args__['annotation'] = annotation
    __args__['bootDelay'] = boot_delay
    __args__['bootRetryDelay'] = boot_retry_delay
    __args__['bootRetryEnabled'] = boot_retry_enabled
    __args__['cpuHotAddEnabled'] = cpu_hot_add_enabled
    __args__['cpuHotRemoveEnabled'] = cpu_hot_remove_enabled
    __args__['cpuLimit'] = cpu_limit
    __args__['cpuPerformanceCountersEnabled'] = cpu_performance_counters_enabled
    __args__['cpuReservation'] = cpu_reservation
    __args__['cpuShareCount'] = cpu_share_count
    __args__['cpuShareLevel'] = cpu_share_level
    __args__['datacenterId'] = datacenter_id
    __args__['efiSecureBootEnabled'] = efi_secure_boot_enabled
    __args__['enableDiskUuid'] = enable_disk_uuid
    __args__['enableLogging'] = enable_logging
    __args__['eptRviMode'] = ept_rvi_mode
    __args__['extraConfig'] = extra_config
    __args__['extraConfigRebootRequired'] = extra_config_reboot_required
    __args__['firmware'] = firmware
    __args__['folder'] = folder
    __args__['guestId'] = guest_id
    __args__['hardwareVersion'] = hardware_version
    __args__['hvMode'] = hv_mode
    __args__['ideControllerScanCount'] = ide_controller_scan_count
    __args__['latencySensitivity'] = latency_sensitivity
    __args__['memory'] = memory
    __args__['memoryHotAddEnabled'] = memory_hot_add_enabled
    __args__['memoryLimit'] = memory_limit
    __args__['memoryReservation'] = memory_reservation
    __args__['memoryReservationLockedToMax'] = memory_reservation_locked_to_max
    __args__['memoryShareCount'] = memory_share_count
    __args__['memoryShareLevel'] = memory_share_level
    __args__['moid'] = moid
    __args__['name'] = name
    __args__['nestedHvEnabled'] = nested_hv_enabled
    __args__['numCoresPerSocket'] = num_cores_per_socket
    __args__['numCpus'] = num_cpus
    __args__['nvmeControllerScanCount'] = nvme_controller_scan_count
    __args__['replaceTrigger'] = replace_trigger
    __args__['runToolsScriptsAfterPowerOn'] = run_tools_scripts_after_power_on
    __args__['runToolsScriptsAfterResume'] = run_tools_scripts_after_resume
    __args__['runToolsScriptsBeforeGuestReboot'] = run_tools_scripts_before_guest_reboot
    __args__['runToolsScriptsBeforeGuestShutdown'] = run_tools_scripts_before_guest_shutdown
    __args__['runToolsScriptsBeforeGuestStandby'] = run_tools_scripts_before_guest_standby
    __args__['sataControllerScanCount'] = sata_controller_scan_count
    __args__['scsiControllerScanCount'] = scsi_controller_scan_count
    __args__['storagePolicyId'] = storage_policy_id
    __args__['swapPlacementPolicy'] = swap_placement_policy
    __args__['syncTimeWithHost'] = sync_time_with_host
    __args__['syncTimeWithHostPeriodically'] = sync_time_with_host_periodically
    __args__['toolsUpgradePolicy'] = tools_upgrade_policy
    __args__['uuid'] = uuid
    __args__['vapp'] = vapp
    __args__['vbsEnabled'] = vbs_enabled
    __args__['vvtdEnabled'] = vvtd_enabled
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vsphere:index/getVirtualMachine:getVirtualMachine', __args__, opts=opts, typ=GetVirtualMachineResult).value

    return AwaitableGetVirtualMachineResult(
        alternate_guest_name=pulumi.get(__ret__, 'alternate_guest_name'),
        annotation=pulumi.get(__ret__, 'annotation'),
        boot_delay=pulumi.get(__ret__, 'boot_delay'),
        boot_retry_delay=pulumi.get(__ret__, 'boot_retry_delay'),
        boot_retry_enabled=pulumi.get(__ret__, 'boot_retry_enabled'),
        change_version=pulumi.get(__ret__, 'change_version'),
        cpu_hot_add_enabled=pulumi.get(__ret__, 'cpu_hot_add_enabled'),
        cpu_hot_remove_enabled=pulumi.get(__ret__, 'cpu_hot_remove_enabled'),
        cpu_limit=pulumi.get(__ret__, 'cpu_limit'),
        cpu_performance_counters_enabled=pulumi.get(__ret__, 'cpu_performance_counters_enabled'),
        cpu_reservation=pulumi.get(__ret__, 'cpu_reservation'),
        cpu_share_count=pulumi.get(__ret__, 'cpu_share_count'),
        cpu_share_level=pulumi.get(__ret__, 'cpu_share_level'),
        datacenter_id=pulumi.get(__ret__, 'datacenter_id'),
        default_ip_address=pulumi.get(__ret__, 'default_ip_address'),
        disks=pulumi.get(__ret__, 'disks'),
        efi_secure_boot_enabled=pulumi.get(__ret__, 'efi_secure_boot_enabled'),
        enable_disk_uuid=pulumi.get(__ret__, 'enable_disk_uuid'),
        enable_logging=pulumi.get(__ret__, 'enable_logging'),
        ept_rvi_mode=pulumi.get(__ret__, 'ept_rvi_mode'),
        extra_config=pulumi.get(__ret__, 'extra_config'),
        extra_config_reboot_required=pulumi.get(__ret__, 'extra_config_reboot_required'),
        firmware=pulumi.get(__ret__, 'firmware'),
        folder=pulumi.get(__ret__, 'folder'),
        guest_id=pulumi.get(__ret__, 'guest_id'),
        guest_ip_addresses=pulumi.get(__ret__, 'guest_ip_addresses'),
        hardware_version=pulumi.get(__ret__, 'hardware_version'),
        hv_mode=pulumi.get(__ret__, 'hv_mode'),
        id=pulumi.get(__ret__, 'id'),
        ide_controller_scan_count=pulumi.get(__ret__, 'ide_controller_scan_count'),
        instance_uuid=pulumi.get(__ret__, 'instance_uuid'),
        latency_sensitivity=pulumi.get(__ret__, 'latency_sensitivity'),
        memory=pulumi.get(__ret__, 'memory'),
        memory_hot_add_enabled=pulumi.get(__ret__, 'memory_hot_add_enabled'),
        memory_limit=pulumi.get(__ret__, 'memory_limit'),
        memory_reservation=pulumi.get(__ret__, 'memory_reservation'),
        memory_reservation_locked_to_max=pulumi.get(__ret__, 'memory_reservation_locked_to_max'),
        memory_share_count=pulumi.get(__ret__, 'memory_share_count'),
        memory_share_level=pulumi.get(__ret__, 'memory_share_level'),
        moid=pulumi.get(__ret__, 'moid'),
        name=pulumi.get(__ret__, 'name'),
        nested_hv_enabled=pulumi.get(__ret__, 'nested_hv_enabled'),
        network_interface_types=pulumi.get(__ret__, 'network_interface_types'),
        network_interfaces=pulumi.get(__ret__, 'network_interfaces'),
        num_cores_per_socket=pulumi.get(__ret__, 'num_cores_per_socket'),
        num_cpus=pulumi.get(__ret__, 'num_cpus'),
        nvme_controller_scan_count=pulumi.get(__ret__, 'nvme_controller_scan_count'),
        replace_trigger=pulumi.get(__ret__, 'replace_trigger'),
        run_tools_scripts_after_power_on=pulumi.get(__ret__, 'run_tools_scripts_after_power_on'),
        run_tools_scripts_after_resume=pulumi.get(__ret__, 'run_tools_scripts_after_resume'),
        run_tools_scripts_before_guest_reboot=pulumi.get(__ret__, 'run_tools_scripts_before_guest_reboot'),
        run_tools_scripts_before_guest_shutdown=pulumi.get(__ret__, 'run_tools_scripts_before_guest_shutdown'),
        run_tools_scripts_before_guest_standby=pulumi.get(__ret__, 'run_tools_scripts_before_guest_standby'),
        sata_controller_scan_count=pulumi.get(__ret__, 'sata_controller_scan_count'),
        scsi_bus_sharing=pulumi.get(__ret__, 'scsi_bus_sharing'),
        scsi_controller_scan_count=pulumi.get(__ret__, 'scsi_controller_scan_count'),
        scsi_type=pulumi.get(__ret__, 'scsi_type'),
        storage_policy_id=pulumi.get(__ret__, 'storage_policy_id'),
        swap_placement_policy=pulumi.get(__ret__, 'swap_placement_policy'),
        sync_time_with_host=pulumi.get(__ret__, 'sync_time_with_host'),
        sync_time_with_host_periodically=pulumi.get(__ret__, 'sync_time_with_host_periodically'),
        tools_upgrade_policy=pulumi.get(__ret__, 'tools_upgrade_policy'),
        uuid=pulumi.get(__ret__, 'uuid'),
        vapp=pulumi.get(__ret__, 'vapp'),
        vapp_transports=pulumi.get(__ret__, 'vapp_transports'),
        vbs_enabled=pulumi.get(__ret__, 'vbs_enabled'),
        vtpm=pulumi.get(__ret__, 'vtpm'),
        vvtd_enabled=pulumi.get(__ret__, 'vvtd_enabled'))
def get_virtual_machine_output(alternate_guest_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               annotation: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               boot_delay: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               boot_retry_delay: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               boot_retry_enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               cpu_hot_add_enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               cpu_hot_remove_enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               cpu_limit: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               cpu_performance_counters_enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               cpu_reservation: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               cpu_share_count: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               cpu_share_level: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               datacenter_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               efi_secure_boot_enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               enable_disk_uuid: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               enable_logging: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               ept_rvi_mode: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               extra_config: Optional[pulumi.Input[Optional[Mapping[str, builtins.str]]]] = None,
                               extra_config_reboot_required: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               firmware: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               folder: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               guest_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               hardware_version: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               hv_mode: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               ide_controller_scan_count: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               latency_sensitivity: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               memory: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               memory_hot_add_enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               memory_limit: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               memory_reservation: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               memory_reservation_locked_to_max: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               memory_share_count: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               memory_share_level: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               moid: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               nested_hv_enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               num_cores_per_socket: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               num_cpus: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               nvme_controller_scan_count: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               replace_trigger: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               run_tools_scripts_after_power_on: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               run_tools_scripts_after_resume: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               run_tools_scripts_before_guest_reboot: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               run_tools_scripts_before_guest_shutdown: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               run_tools_scripts_before_guest_standby: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               sata_controller_scan_count: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               scsi_controller_scan_count: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                               storage_policy_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               swap_placement_policy: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               sync_time_with_host: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               sync_time_with_host_periodically: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               tools_upgrade_policy: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               uuid: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                               vapp: Optional[pulumi.Input[Optional[Union['GetVirtualMachineVappArgs', 'GetVirtualMachineVappArgsDict']]]] = None,
                               vbs_enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               vvtd_enabled: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualMachineResult]:
    """
    The `VirtualMachine` data source can be used to find the UUID of an
    existing virtual machine or template. The most common purpose is for finding
    the UUID of a template to be used as the source for cloning to a new
    `VirtualMachine` resource. It also
    reads the guest ID so that can be supplied as well.

    ## Example Usage

    In the following example, a virtual machine template is returned by its unique
    name within the `Datacenter`.

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    template = vsphere.get_virtual_machine(name="ubuntu-server-template",
        datacenter_id=datacenter.id)
    ```

    In the following example, each virtual machine template is returned by its
    unique full path within the `Datacenter`.

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    production_template = vsphere.get_virtual_machine(name="production/templates/ubuntu-server-template",
        datacenter_id=datacenter.id)
    development_template = vsphere.get_virtual_machine(name="development/templates/ubuntu-server-template",
        datacenter_id=datacenter.id)
    ```


    :param builtins.str alternate_guest_name: The alternate guest name of the virtual machine when
           `guest_id` is a non-specific operating system, like `otherGuest` or
           `otherGuest64`.
    :param builtins.str annotation: The user-provided description of this virtual machine.
    :param builtins.str datacenter_id: The managed object reference
           ID of the datacenter the virtual machine is located in.
           This can be omitted if the search path used in `name` is an absolute path.
           For default datacenters, use the `id` attribute from an empty
           `Datacenter` data source.
    :param builtins.str firmware: The firmware type for this virtual machine. Can be `bios` or
           `efi`.
    :param builtins.str folder: The name of the virtual machine folder where the virtual machine is located. The `name` argument is limited to 80 characters. If the `name` argument includes the full path to the virtual machine and exceeds the 80 characters limit, the `folder` folder argument can be used.
    :param builtins.str guest_id: The guest ID of the virtual machine or template.
    :param builtins.int hardware_version: The hardware version number on this virtual machine.
    :param builtins.int memory: The size of the virtual machine's memory, in MB.
    :param builtins.str name: The name of the virtual machine. This can be a name or
           the full path relative to the datacenter. This is required if a UUID lookup
           is not performed.
    :param builtins.int num_cores_per_socket: The number of cores per socket for this virtual
           machine.
    :param builtins.int num_cpus: The total number of virtual processor cores assigned to this
           virtual machine.
    :param builtins.int nvme_controller_scan_count: The number of NVMe controllers to
           scan for disk attributes and controller types on. Default: `1`.
           
           > **NOTE:** For best results, ensure that all the disks on any templates you
           use with this data source reside on the primary controller, and leave this
           value at the default. See the `VirtualMachine`
           resource documentation for the significance of this setting, specifically the
           additional requirements and notes for cloning section.
    :param builtins.int scsi_controller_scan_count: The number of SCSI controllers to
           scan for disk attributes and controller types on. Default: `1`.
    :param builtins.str uuid: Specify this field for a UUID lookup, `name` and `datacenter_id`
           are not required if this is specified.
    """
    __args__ = dict()
    __args__['alternateGuestName'] = alternate_guest_name
    __args__['annotation'] = annotation
    __args__['bootDelay'] = boot_delay
    __args__['bootRetryDelay'] = boot_retry_delay
    __args__['bootRetryEnabled'] = boot_retry_enabled
    __args__['cpuHotAddEnabled'] = cpu_hot_add_enabled
    __args__['cpuHotRemoveEnabled'] = cpu_hot_remove_enabled
    __args__['cpuLimit'] = cpu_limit
    __args__['cpuPerformanceCountersEnabled'] = cpu_performance_counters_enabled
    __args__['cpuReservation'] = cpu_reservation
    __args__['cpuShareCount'] = cpu_share_count
    __args__['cpuShareLevel'] = cpu_share_level
    __args__['datacenterId'] = datacenter_id
    __args__['efiSecureBootEnabled'] = efi_secure_boot_enabled
    __args__['enableDiskUuid'] = enable_disk_uuid
    __args__['enableLogging'] = enable_logging
    __args__['eptRviMode'] = ept_rvi_mode
    __args__['extraConfig'] = extra_config
    __args__['extraConfigRebootRequired'] = extra_config_reboot_required
    __args__['firmware'] = firmware
    __args__['folder'] = folder
    __args__['guestId'] = guest_id
    __args__['hardwareVersion'] = hardware_version
    __args__['hvMode'] = hv_mode
    __args__['ideControllerScanCount'] = ide_controller_scan_count
    __args__['latencySensitivity'] = latency_sensitivity
    __args__['memory'] = memory
    __args__['memoryHotAddEnabled'] = memory_hot_add_enabled
    __args__['memoryLimit'] = memory_limit
    __args__['memoryReservation'] = memory_reservation
    __args__['memoryReservationLockedToMax'] = memory_reservation_locked_to_max
    __args__['memoryShareCount'] = memory_share_count
    __args__['memoryShareLevel'] = memory_share_level
    __args__['moid'] = moid
    __args__['name'] = name
    __args__['nestedHvEnabled'] = nested_hv_enabled
    __args__['numCoresPerSocket'] = num_cores_per_socket
    __args__['numCpus'] = num_cpus
    __args__['nvmeControllerScanCount'] = nvme_controller_scan_count
    __args__['replaceTrigger'] = replace_trigger
    __args__['runToolsScriptsAfterPowerOn'] = run_tools_scripts_after_power_on
    __args__['runToolsScriptsAfterResume'] = run_tools_scripts_after_resume
    __args__['runToolsScriptsBeforeGuestReboot'] = run_tools_scripts_before_guest_reboot
    __args__['runToolsScriptsBeforeGuestShutdown'] = run_tools_scripts_before_guest_shutdown
    __args__['runToolsScriptsBeforeGuestStandby'] = run_tools_scripts_before_guest_standby
    __args__['sataControllerScanCount'] = sata_controller_scan_count
    __args__['scsiControllerScanCount'] = scsi_controller_scan_count
    __args__['storagePolicyId'] = storage_policy_id
    __args__['swapPlacementPolicy'] = swap_placement_policy
    __args__['syncTimeWithHost'] = sync_time_with_host
    __args__['syncTimeWithHostPeriodically'] = sync_time_with_host_periodically
    __args__['toolsUpgradePolicy'] = tools_upgrade_policy
    __args__['uuid'] = uuid
    __args__['vapp'] = vapp
    __args__['vbsEnabled'] = vbs_enabled
    __args__['vvtdEnabled'] = vvtd_enabled
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vsphere:index/getVirtualMachine:getVirtualMachine', __args__, opts=opts, typ=GetVirtualMachineResult)
    return __ret__.apply(lambda __response__: GetVirtualMachineResult(
        alternate_guest_name=pulumi.get(__response__, 'alternate_guest_name'),
        annotation=pulumi.get(__response__, 'annotation'),
        boot_delay=pulumi.get(__response__, 'boot_delay'),
        boot_retry_delay=pulumi.get(__response__, 'boot_retry_delay'),
        boot_retry_enabled=pulumi.get(__response__, 'boot_retry_enabled'),
        change_version=pulumi.get(__response__, 'change_version'),
        cpu_hot_add_enabled=pulumi.get(__response__, 'cpu_hot_add_enabled'),
        cpu_hot_remove_enabled=pulumi.get(__response__, 'cpu_hot_remove_enabled'),
        cpu_limit=pulumi.get(__response__, 'cpu_limit'),
        cpu_performance_counters_enabled=pulumi.get(__response__, 'cpu_performance_counters_enabled'),
        cpu_reservation=pulumi.get(__response__, 'cpu_reservation'),
        cpu_share_count=pulumi.get(__response__, 'cpu_share_count'),
        cpu_share_level=pulumi.get(__response__, 'cpu_share_level'),
        datacenter_id=pulumi.get(__response__, 'datacenter_id'),
        default_ip_address=pulumi.get(__response__, 'default_ip_address'),
        disks=pulumi.get(__response__, 'disks'),
        efi_secure_boot_enabled=pulumi.get(__response__, 'efi_secure_boot_enabled'),
        enable_disk_uuid=pulumi.get(__response__, 'enable_disk_uuid'),
        enable_logging=pulumi.get(__response__, 'enable_logging'),
        ept_rvi_mode=pulumi.get(__response__, 'ept_rvi_mode'),
        extra_config=pulumi.get(__response__, 'extra_config'),
        extra_config_reboot_required=pulumi.get(__response__, 'extra_config_reboot_required'),
        firmware=pulumi.get(__response__, 'firmware'),
        folder=pulumi.get(__response__, 'folder'),
        guest_id=pulumi.get(__response__, 'guest_id'),
        guest_ip_addresses=pulumi.get(__response__, 'guest_ip_addresses'),
        hardware_version=pulumi.get(__response__, 'hardware_version'),
        hv_mode=pulumi.get(__response__, 'hv_mode'),
        id=pulumi.get(__response__, 'id'),
        ide_controller_scan_count=pulumi.get(__response__, 'ide_controller_scan_count'),
        instance_uuid=pulumi.get(__response__, 'instance_uuid'),
        latency_sensitivity=pulumi.get(__response__, 'latency_sensitivity'),
        memory=pulumi.get(__response__, 'memory'),
        memory_hot_add_enabled=pulumi.get(__response__, 'memory_hot_add_enabled'),
        memory_limit=pulumi.get(__response__, 'memory_limit'),
        memory_reservation=pulumi.get(__response__, 'memory_reservation'),
        memory_reservation_locked_to_max=pulumi.get(__response__, 'memory_reservation_locked_to_max'),
        memory_share_count=pulumi.get(__response__, 'memory_share_count'),
        memory_share_level=pulumi.get(__response__, 'memory_share_level'),
        moid=pulumi.get(__response__, 'moid'),
        name=pulumi.get(__response__, 'name'),
        nested_hv_enabled=pulumi.get(__response__, 'nested_hv_enabled'),
        network_interface_types=pulumi.get(__response__, 'network_interface_types'),
        network_interfaces=pulumi.get(__response__, 'network_interfaces'),
        num_cores_per_socket=pulumi.get(__response__, 'num_cores_per_socket'),
        num_cpus=pulumi.get(__response__, 'num_cpus'),
        nvme_controller_scan_count=pulumi.get(__response__, 'nvme_controller_scan_count'),
        replace_trigger=pulumi.get(__response__, 'replace_trigger'),
        run_tools_scripts_after_power_on=pulumi.get(__response__, 'run_tools_scripts_after_power_on'),
        run_tools_scripts_after_resume=pulumi.get(__response__, 'run_tools_scripts_after_resume'),
        run_tools_scripts_before_guest_reboot=pulumi.get(__response__, 'run_tools_scripts_before_guest_reboot'),
        run_tools_scripts_before_guest_shutdown=pulumi.get(__response__, 'run_tools_scripts_before_guest_shutdown'),
        run_tools_scripts_before_guest_standby=pulumi.get(__response__, 'run_tools_scripts_before_guest_standby'),
        sata_controller_scan_count=pulumi.get(__response__, 'sata_controller_scan_count'),
        scsi_bus_sharing=pulumi.get(__response__, 'scsi_bus_sharing'),
        scsi_controller_scan_count=pulumi.get(__response__, 'scsi_controller_scan_count'),
        scsi_type=pulumi.get(__response__, 'scsi_type'),
        storage_policy_id=pulumi.get(__response__, 'storage_policy_id'),
        swap_placement_policy=pulumi.get(__response__, 'swap_placement_policy'),
        sync_time_with_host=pulumi.get(__response__, 'sync_time_with_host'),
        sync_time_with_host_periodically=pulumi.get(__response__, 'sync_time_with_host_periodically'),
        tools_upgrade_policy=pulumi.get(__response__, 'tools_upgrade_policy'),
        uuid=pulumi.get(__response__, 'uuid'),
        vapp=pulumi.get(__response__, 'vapp'),
        vapp_transports=pulumi.get(__response__, 'vapp_transports'),
        vbs_enabled=pulumi.get(__response__, 'vbs_enabled'),
        vtpm=pulumi.get(__response__, 'vtpm'),
        vvtd_enabled=pulumi.get(__response__, 'vvtd_enabled')))
