# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['HaVmOverrideArgs', 'HaVmOverride']

@pulumi.input_type
class HaVmOverrideArgs:
    def __init__(__self__, *,
                 compute_cluster_id: pulumi.Input[builtins.str],
                 virtual_machine_id: pulumi.Input[builtins.str],
                 ha_datastore_apd_recovery_action: Optional[pulumi.Input[builtins.str]] = None,
                 ha_datastore_apd_response: Optional[pulumi.Input[builtins.str]] = None,
                 ha_datastore_apd_response_delay: Optional[pulumi.Input[builtins.int]] = None,
                 ha_datastore_pdl_response: Optional[pulumi.Input[builtins.str]] = None,
                 ha_host_isolation_response: Optional[pulumi.Input[builtins.str]] = None,
                 ha_vm_failure_interval: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_maximum_failure_window: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_maximum_resets: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_minimum_uptime: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_monitoring: Optional[pulumi.Input[builtins.str]] = None,
                 ha_vm_monitoring_use_cluster_defaults: Optional[pulumi.Input[builtins.bool]] = None,
                 ha_vm_restart_priority: Optional[pulumi.Input[builtins.str]] = None,
                 ha_vm_restart_timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a HaVmOverride resource.
        :param pulumi.Input[builtins.str] compute_cluster_id: The managed object ID of the cluster.
        :param pulumi.Input[builtins.str] virtual_machine_id: The managed object ID of the virtual machine.
        :param pulumi.Input[builtins.str] ha_datastore_apd_recovery_action: Controls the action to take on this virtual machine if an APD status on an affected datastore clears in the middle of an
               APD event. Can be one of useClusterDefault, none or reset.
        :param pulumi.Input[builtins.str] ha_datastore_apd_response: Controls the action to take on this virtual machine when the cluster has detected loss to all paths to a relevant
               datastore. Can be one of clusterDefault, disabled, warning, restartConservative, or restartAggressive.
        :param pulumi.Input[builtins.int] ha_datastore_apd_response_delay: Controls the delay in seconds to wait after an APD timeout event to execute the response action defined in
               ha_datastore_apd_response. Specify -1 to use the cluster setting.
        :param pulumi.Input[builtins.str] ha_datastore_pdl_response: Controls the action to take on this virtual machine when the cluster has detected a permanent device loss to a relevant
               datastore. Can be one of clusterDefault, disabled, warning, or restartAggressive.
        :param pulumi.Input[builtins.str] ha_host_isolation_response: The action to take on this virtual machine when a host is isolated from the rest of the cluster. Can be one of
               clusterIsolationResponse, none, powerOff, or shutdown.
        :param pulumi.Input[builtins.int] ha_vm_failure_interval: If a heartbeat from this virtual machine is not received within this configured interval, the virtual machine is marked
               as failed. The value is in seconds.
        :param pulumi.Input[builtins.int] ha_vm_maximum_failure_window: The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
               attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
               time is allotted.
        :param pulumi.Input[builtins.int] ha_vm_maximum_resets: The maximum number of resets that HA will perform to this virtual machine when responding to a failure event.
        :param pulumi.Input[builtins.int] ha_vm_minimum_uptime: The time, in seconds, that HA waits after powering on this virtual machine before monitoring for heartbeats.
        :param pulumi.Input[builtins.str] ha_vm_monitoring: The type of virtual machine monitoring to use for this virtual machine. Can be one of vmMonitoringDisabled,
               vmMonitoringOnly, or vmAndAppMonitoring.
        :param pulumi.Input[builtins.bool] ha_vm_monitoring_use_cluster_defaults: Determines whether or not the cluster's default settings or the VM override settings specified in this resource are used
               for virtual machine monitoring. The default is true (use cluster defaults) - set to false to have overrides take effect.
        :param pulumi.Input[builtins.str] ha_vm_restart_priority: The restart priority for this virtual machine when vSphere detects a host failure. Can be one of clusterRestartPriority,
               lowest, low, medium, high, or highest.
        :param pulumi.Input[builtins.int] ha_vm_restart_timeout: The maximum time, in seconds, that vSphere HA will wait for the virtual machine to be ready. Use -1 to use the cluster
               default.
        """
        pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if ha_datastore_apd_recovery_action is not None:
            pulumi.set(__self__, "ha_datastore_apd_recovery_action", ha_datastore_apd_recovery_action)
        if ha_datastore_apd_response is not None:
            pulumi.set(__self__, "ha_datastore_apd_response", ha_datastore_apd_response)
        if ha_datastore_apd_response_delay is not None:
            pulumi.set(__self__, "ha_datastore_apd_response_delay", ha_datastore_apd_response_delay)
        if ha_datastore_pdl_response is not None:
            pulumi.set(__self__, "ha_datastore_pdl_response", ha_datastore_pdl_response)
        if ha_host_isolation_response is not None:
            pulumi.set(__self__, "ha_host_isolation_response", ha_host_isolation_response)
        if ha_vm_failure_interval is not None:
            pulumi.set(__self__, "ha_vm_failure_interval", ha_vm_failure_interval)
        if ha_vm_maximum_failure_window is not None:
            pulumi.set(__self__, "ha_vm_maximum_failure_window", ha_vm_maximum_failure_window)
        if ha_vm_maximum_resets is not None:
            pulumi.set(__self__, "ha_vm_maximum_resets", ha_vm_maximum_resets)
        if ha_vm_minimum_uptime is not None:
            pulumi.set(__self__, "ha_vm_minimum_uptime", ha_vm_minimum_uptime)
        if ha_vm_monitoring is not None:
            pulumi.set(__self__, "ha_vm_monitoring", ha_vm_monitoring)
        if ha_vm_monitoring_use_cluster_defaults is not None:
            pulumi.set(__self__, "ha_vm_monitoring_use_cluster_defaults", ha_vm_monitoring_use_cluster_defaults)
        if ha_vm_restart_priority is not None:
            pulumi.set(__self__, "ha_vm_restart_priority", ha_vm_restart_priority)
        if ha_vm_restart_timeout is not None:
            pulumi.set(__self__, "ha_vm_restart_timeout", ha_vm_restart_timeout)

    @property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        The managed object ID of the cluster.
        """
        return pulumi.get(self, "compute_cluster_id")

    @compute_cluster_id.setter
    def compute_cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compute_cluster_id", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Input[builtins.str]:
        """
        The managed object ID of the virtual machine.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "virtual_machine_id", value)

    @property
    @pulumi.getter(name="haDatastoreApdRecoveryAction")
    def ha_datastore_apd_recovery_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls the action to take on this virtual machine if an APD status on an affected datastore clears in the middle of an
        APD event. Can be one of useClusterDefault, none or reset.
        """
        return pulumi.get(self, "ha_datastore_apd_recovery_action")

    @ha_datastore_apd_recovery_action.setter
    def ha_datastore_apd_recovery_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ha_datastore_apd_recovery_action", value)

    @property
    @pulumi.getter(name="haDatastoreApdResponse")
    def ha_datastore_apd_response(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls the action to take on this virtual machine when the cluster has detected loss to all paths to a relevant
        datastore. Can be one of clusterDefault, disabled, warning, restartConservative, or restartAggressive.
        """
        return pulumi.get(self, "ha_datastore_apd_response")

    @ha_datastore_apd_response.setter
    def ha_datastore_apd_response(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ha_datastore_apd_response", value)

    @property
    @pulumi.getter(name="haDatastoreApdResponseDelay")
    def ha_datastore_apd_response_delay(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Controls the delay in seconds to wait after an APD timeout event to execute the response action defined in
        ha_datastore_apd_response. Specify -1 to use the cluster setting.
        """
        return pulumi.get(self, "ha_datastore_apd_response_delay")

    @ha_datastore_apd_response_delay.setter
    def ha_datastore_apd_response_delay(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ha_datastore_apd_response_delay", value)

    @property
    @pulumi.getter(name="haDatastorePdlResponse")
    def ha_datastore_pdl_response(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls the action to take on this virtual machine when the cluster has detected a permanent device loss to a relevant
        datastore. Can be one of clusterDefault, disabled, warning, or restartAggressive.
        """
        return pulumi.get(self, "ha_datastore_pdl_response")

    @ha_datastore_pdl_response.setter
    def ha_datastore_pdl_response(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ha_datastore_pdl_response", value)

    @property
    @pulumi.getter(name="haHostIsolationResponse")
    def ha_host_isolation_response(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take on this virtual machine when a host is isolated from the rest of the cluster. Can be one of
        clusterIsolationResponse, none, powerOff, or shutdown.
        """
        return pulumi.get(self, "ha_host_isolation_response")

    @ha_host_isolation_response.setter
    def ha_host_isolation_response(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ha_host_isolation_response", value)

    @property
    @pulumi.getter(name="haVmFailureInterval")
    def ha_vm_failure_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        If a heartbeat from this virtual machine is not received within this configured interval, the virtual machine is marked
        as failed. The value is in seconds.
        """
        return pulumi.get(self, "ha_vm_failure_interval")

    @ha_vm_failure_interval.setter
    def ha_vm_failure_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ha_vm_failure_interval", value)

    @property
    @pulumi.getter(name="haVmMaximumFailureWindow")
    def ha_vm_maximum_failure_window(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
        attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
        time is allotted.
        """
        return pulumi.get(self, "ha_vm_maximum_failure_window")

    @ha_vm_maximum_failure_window.setter
    def ha_vm_maximum_failure_window(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ha_vm_maximum_failure_window", value)

    @property
    @pulumi.getter(name="haVmMaximumResets")
    def ha_vm_maximum_resets(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of resets that HA will perform to this virtual machine when responding to a failure event.
        """
        return pulumi.get(self, "ha_vm_maximum_resets")

    @ha_vm_maximum_resets.setter
    def ha_vm_maximum_resets(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ha_vm_maximum_resets", value)

    @property
    @pulumi.getter(name="haVmMinimumUptime")
    def ha_vm_minimum_uptime(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The time, in seconds, that HA waits after powering on this virtual machine before monitoring for heartbeats.
        """
        return pulumi.get(self, "ha_vm_minimum_uptime")

    @ha_vm_minimum_uptime.setter
    def ha_vm_minimum_uptime(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ha_vm_minimum_uptime", value)

    @property
    @pulumi.getter(name="haVmMonitoring")
    def ha_vm_monitoring(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of virtual machine monitoring to use for this virtual machine. Can be one of vmMonitoringDisabled,
        vmMonitoringOnly, or vmAndAppMonitoring.
        """
        return pulumi.get(self, "ha_vm_monitoring")

    @ha_vm_monitoring.setter
    def ha_vm_monitoring(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ha_vm_monitoring", value)

    @property
    @pulumi.getter(name="haVmMonitoringUseClusterDefaults")
    def ha_vm_monitoring_use_cluster_defaults(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines whether or not the cluster's default settings or the VM override settings specified in this resource are used
        for virtual machine monitoring. The default is true (use cluster defaults) - set to false to have overrides take effect.
        """
        return pulumi.get(self, "ha_vm_monitoring_use_cluster_defaults")

    @ha_vm_monitoring_use_cluster_defaults.setter
    def ha_vm_monitoring_use_cluster_defaults(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ha_vm_monitoring_use_cluster_defaults", value)

    @property
    @pulumi.getter(name="haVmRestartPriority")
    def ha_vm_restart_priority(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The restart priority for this virtual machine when vSphere detects a host failure. Can be one of clusterRestartPriority,
        lowest, low, medium, high, or highest.
        """
        return pulumi.get(self, "ha_vm_restart_priority")

    @ha_vm_restart_priority.setter
    def ha_vm_restart_priority(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ha_vm_restart_priority", value)

    @property
    @pulumi.getter(name="haVmRestartTimeout")
    def ha_vm_restart_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum time, in seconds, that vSphere HA will wait for the virtual machine to be ready. Use -1 to use the cluster
        default.
        """
        return pulumi.get(self, "ha_vm_restart_timeout")

    @ha_vm_restart_timeout.setter
    def ha_vm_restart_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ha_vm_restart_timeout", value)


@pulumi.input_type
class _HaVmOverrideState:
    def __init__(__self__, *,
                 compute_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 ha_datastore_apd_recovery_action: Optional[pulumi.Input[builtins.str]] = None,
                 ha_datastore_apd_response: Optional[pulumi.Input[builtins.str]] = None,
                 ha_datastore_apd_response_delay: Optional[pulumi.Input[builtins.int]] = None,
                 ha_datastore_pdl_response: Optional[pulumi.Input[builtins.str]] = None,
                 ha_host_isolation_response: Optional[pulumi.Input[builtins.str]] = None,
                 ha_vm_failure_interval: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_maximum_failure_window: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_maximum_resets: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_minimum_uptime: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_monitoring: Optional[pulumi.Input[builtins.str]] = None,
                 ha_vm_monitoring_use_cluster_defaults: Optional[pulumi.Input[builtins.bool]] = None,
                 ha_vm_restart_priority: Optional[pulumi.Input[builtins.str]] = None,
                 ha_vm_restart_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering HaVmOverride resources.
        :param pulumi.Input[builtins.str] compute_cluster_id: The managed object ID of the cluster.
        :param pulumi.Input[builtins.str] ha_datastore_apd_recovery_action: Controls the action to take on this virtual machine if an APD status on an affected datastore clears in the middle of an
               APD event. Can be one of useClusterDefault, none or reset.
        :param pulumi.Input[builtins.str] ha_datastore_apd_response: Controls the action to take on this virtual machine when the cluster has detected loss to all paths to a relevant
               datastore. Can be one of clusterDefault, disabled, warning, restartConservative, or restartAggressive.
        :param pulumi.Input[builtins.int] ha_datastore_apd_response_delay: Controls the delay in seconds to wait after an APD timeout event to execute the response action defined in
               ha_datastore_apd_response. Specify -1 to use the cluster setting.
        :param pulumi.Input[builtins.str] ha_datastore_pdl_response: Controls the action to take on this virtual machine when the cluster has detected a permanent device loss to a relevant
               datastore. Can be one of clusterDefault, disabled, warning, or restartAggressive.
        :param pulumi.Input[builtins.str] ha_host_isolation_response: The action to take on this virtual machine when a host is isolated from the rest of the cluster. Can be one of
               clusterIsolationResponse, none, powerOff, or shutdown.
        :param pulumi.Input[builtins.int] ha_vm_failure_interval: If a heartbeat from this virtual machine is not received within this configured interval, the virtual machine is marked
               as failed. The value is in seconds.
        :param pulumi.Input[builtins.int] ha_vm_maximum_failure_window: The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
               attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
               time is allotted.
        :param pulumi.Input[builtins.int] ha_vm_maximum_resets: The maximum number of resets that HA will perform to this virtual machine when responding to a failure event.
        :param pulumi.Input[builtins.int] ha_vm_minimum_uptime: The time, in seconds, that HA waits after powering on this virtual machine before monitoring for heartbeats.
        :param pulumi.Input[builtins.str] ha_vm_monitoring: The type of virtual machine monitoring to use for this virtual machine. Can be one of vmMonitoringDisabled,
               vmMonitoringOnly, or vmAndAppMonitoring.
        :param pulumi.Input[builtins.bool] ha_vm_monitoring_use_cluster_defaults: Determines whether or not the cluster's default settings or the VM override settings specified in this resource are used
               for virtual machine monitoring. The default is true (use cluster defaults) - set to false to have overrides take effect.
        :param pulumi.Input[builtins.str] ha_vm_restart_priority: The restart priority for this virtual machine when vSphere detects a host failure. Can be one of clusterRestartPriority,
               lowest, low, medium, high, or highest.
        :param pulumi.Input[builtins.int] ha_vm_restart_timeout: The maximum time, in seconds, that vSphere HA will wait for the virtual machine to be ready. Use -1 to use the cluster
               default.
        :param pulumi.Input[builtins.str] virtual_machine_id: The managed object ID of the virtual machine.
        """
        if compute_cluster_id is not None:
            pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        if ha_datastore_apd_recovery_action is not None:
            pulumi.set(__self__, "ha_datastore_apd_recovery_action", ha_datastore_apd_recovery_action)
        if ha_datastore_apd_response is not None:
            pulumi.set(__self__, "ha_datastore_apd_response", ha_datastore_apd_response)
        if ha_datastore_apd_response_delay is not None:
            pulumi.set(__self__, "ha_datastore_apd_response_delay", ha_datastore_apd_response_delay)
        if ha_datastore_pdl_response is not None:
            pulumi.set(__self__, "ha_datastore_pdl_response", ha_datastore_pdl_response)
        if ha_host_isolation_response is not None:
            pulumi.set(__self__, "ha_host_isolation_response", ha_host_isolation_response)
        if ha_vm_failure_interval is not None:
            pulumi.set(__self__, "ha_vm_failure_interval", ha_vm_failure_interval)
        if ha_vm_maximum_failure_window is not None:
            pulumi.set(__self__, "ha_vm_maximum_failure_window", ha_vm_maximum_failure_window)
        if ha_vm_maximum_resets is not None:
            pulumi.set(__self__, "ha_vm_maximum_resets", ha_vm_maximum_resets)
        if ha_vm_minimum_uptime is not None:
            pulumi.set(__self__, "ha_vm_minimum_uptime", ha_vm_minimum_uptime)
        if ha_vm_monitoring is not None:
            pulumi.set(__self__, "ha_vm_monitoring", ha_vm_monitoring)
        if ha_vm_monitoring_use_cluster_defaults is not None:
            pulumi.set(__self__, "ha_vm_monitoring_use_cluster_defaults", ha_vm_monitoring_use_cluster_defaults)
        if ha_vm_restart_priority is not None:
            pulumi.set(__self__, "ha_vm_restart_priority", ha_vm_restart_priority)
        if ha_vm_restart_timeout is not None:
            pulumi.set(__self__, "ha_vm_restart_timeout", ha_vm_restart_timeout)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The managed object ID of the cluster.
        """
        return pulumi.get(self, "compute_cluster_id")

    @compute_cluster_id.setter
    def compute_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_cluster_id", value)

    @property
    @pulumi.getter(name="haDatastoreApdRecoveryAction")
    def ha_datastore_apd_recovery_action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls the action to take on this virtual machine if an APD status on an affected datastore clears in the middle of an
        APD event. Can be one of useClusterDefault, none or reset.
        """
        return pulumi.get(self, "ha_datastore_apd_recovery_action")

    @ha_datastore_apd_recovery_action.setter
    def ha_datastore_apd_recovery_action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ha_datastore_apd_recovery_action", value)

    @property
    @pulumi.getter(name="haDatastoreApdResponse")
    def ha_datastore_apd_response(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls the action to take on this virtual machine when the cluster has detected loss to all paths to a relevant
        datastore. Can be one of clusterDefault, disabled, warning, restartConservative, or restartAggressive.
        """
        return pulumi.get(self, "ha_datastore_apd_response")

    @ha_datastore_apd_response.setter
    def ha_datastore_apd_response(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ha_datastore_apd_response", value)

    @property
    @pulumi.getter(name="haDatastoreApdResponseDelay")
    def ha_datastore_apd_response_delay(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Controls the delay in seconds to wait after an APD timeout event to execute the response action defined in
        ha_datastore_apd_response. Specify -1 to use the cluster setting.
        """
        return pulumi.get(self, "ha_datastore_apd_response_delay")

    @ha_datastore_apd_response_delay.setter
    def ha_datastore_apd_response_delay(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ha_datastore_apd_response_delay", value)

    @property
    @pulumi.getter(name="haDatastorePdlResponse")
    def ha_datastore_pdl_response(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Controls the action to take on this virtual machine when the cluster has detected a permanent device loss to a relevant
        datastore. Can be one of clusterDefault, disabled, warning, or restartAggressive.
        """
        return pulumi.get(self, "ha_datastore_pdl_response")

    @ha_datastore_pdl_response.setter
    def ha_datastore_pdl_response(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ha_datastore_pdl_response", value)

    @property
    @pulumi.getter(name="haHostIsolationResponse")
    def ha_host_isolation_response(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The action to take on this virtual machine when a host is isolated from the rest of the cluster. Can be one of
        clusterIsolationResponse, none, powerOff, or shutdown.
        """
        return pulumi.get(self, "ha_host_isolation_response")

    @ha_host_isolation_response.setter
    def ha_host_isolation_response(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ha_host_isolation_response", value)

    @property
    @pulumi.getter(name="haVmFailureInterval")
    def ha_vm_failure_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        If a heartbeat from this virtual machine is not received within this configured interval, the virtual machine is marked
        as failed. The value is in seconds.
        """
        return pulumi.get(self, "ha_vm_failure_interval")

    @ha_vm_failure_interval.setter
    def ha_vm_failure_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ha_vm_failure_interval", value)

    @property
    @pulumi.getter(name="haVmMaximumFailureWindow")
    def ha_vm_maximum_failure_window(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
        attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
        time is allotted.
        """
        return pulumi.get(self, "ha_vm_maximum_failure_window")

    @ha_vm_maximum_failure_window.setter
    def ha_vm_maximum_failure_window(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ha_vm_maximum_failure_window", value)

    @property
    @pulumi.getter(name="haVmMaximumResets")
    def ha_vm_maximum_resets(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum number of resets that HA will perform to this virtual machine when responding to a failure event.
        """
        return pulumi.get(self, "ha_vm_maximum_resets")

    @ha_vm_maximum_resets.setter
    def ha_vm_maximum_resets(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ha_vm_maximum_resets", value)

    @property
    @pulumi.getter(name="haVmMinimumUptime")
    def ha_vm_minimum_uptime(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The time, in seconds, that HA waits after powering on this virtual machine before monitoring for heartbeats.
        """
        return pulumi.get(self, "ha_vm_minimum_uptime")

    @ha_vm_minimum_uptime.setter
    def ha_vm_minimum_uptime(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ha_vm_minimum_uptime", value)

    @property
    @pulumi.getter(name="haVmMonitoring")
    def ha_vm_monitoring(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of virtual machine monitoring to use for this virtual machine. Can be one of vmMonitoringDisabled,
        vmMonitoringOnly, or vmAndAppMonitoring.
        """
        return pulumi.get(self, "ha_vm_monitoring")

    @ha_vm_monitoring.setter
    def ha_vm_monitoring(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ha_vm_monitoring", value)

    @property
    @pulumi.getter(name="haVmMonitoringUseClusterDefaults")
    def ha_vm_monitoring_use_cluster_defaults(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines whether or not the cluster's default settings or the VM override settings specified in this resource are used
        for virtual machine monitoring. The default is true (use cluster defaults) - set to false to have overrides take effect.
        """
        return pulumi.get(self, "ha_vm_monitoring_use_cluster_defaults")

    @ha_vm_monitoring_use_cluster_defaults.setter
    def ha_vm_monitoring_use_cluster_defaults(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ha_vm_monitoring_use_cluster_defaults", value)

    @property
    @pulumi.getter(name="haVmRestartPriority")
    def ha_vm_restart_priority(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The restart priority for this virtual machine when vSphere detects a host failure. Can be one of clusterRestartPriority,
        lowest, low, medium, high, or highest.
        """
        return pulumi.get(self, "ha_vm_restart_priority")

    @ha_vm_restart_priority.setter
    def ha_vm_restart_priority(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ha_vm_restart_priority", value)

    @property
    @pulumi.getter(name="haVmRestartTimeout")
    def ha_vm_restart_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum time, in seconds, that vSphere HA will wait for the virtual machine to be ready. Use -1 to use the cluster
        default.
        """
        return pulumi.get(self, "ha_vm_restart_timeout")

    @ha_vm_restart_timeout.setter
    def ha_vm_restart_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ha_vm_restart_timeout", value)

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The managed object ID of the virtual machine.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_machine_id", value)


@pulumi.type_token("vsphere:index/haVmOverride:HaVmOverride")
class HaVmOverride(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 ha_datastore_apd_recovery_action: Optional[pulumi.Input[builtins.str]] = None,
                 ha_datastore_apd_response: Optional[pulumi.Input[builtins.str]] = None,
                 ha_datastore_apd_response_delay: Optional[pulumi.Input[builtins.int]] = None,
                 ha_datastore_pdl_response: Optional[pulumi.Input[builtins.str]] = None,
                 ha_host_isolation_response: Optional[pulumi.Input[builtins.str]] = None,
                 ha_vm_failure_interval: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_maximum_failure_window: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_maximum_resets: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_minimum_uptime: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_monitoring: Optional[pulumi.Input[builtins.str]] = None,
                 ha_vm_monitoring_use_cluster_defaults: Optional[pulumi.Input[builtins.bool]] = None,
                 ha_vm_restart_priority: Optional[pulumi.Input[builtins.str]] = None,
                 ha_vm_restart_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The `HaVmOverride` resource can be used to add an override for
        vSphere HA settings on a cluster for a specific virtual machine. With this
        resource, one can control specific HA settings so that they are different than
        the cluster default, accommodating the needs of that specific virtual machine,
        while not affecting the rest of the cluster.

        For more information on vSphere HA, see [this page][ref-vsphere-ha-clusters].

        [ref-vsphere-ha-clusters]: https://techdocs.broadcom.com/us/en/vmware-cis/vsphere/vsphere/8-0/vsphere-availability.html

        > **NOTE:** This resource requires vCenter and is not available on direct ESXi
        connections.

        ## Example Usage

        The example below creates a virtual machine in a cluster using the
        `VirtualMachine` resource, creating the
        virtual machine in the cluster looked up by the
        `ComputeCluster` data source.

        Considering a scenario where this virtual machine is of high value to the
        application or organization for which it does its work, it's been determined in
        the event of a host failure, that this should be one of the first virtual
        machines to be started by vSphere HA during recovery. Hence, it
        `ha_vm_restart_priority` has been set to `highest`,
        which, assuming that the default restart priority is `medium` and no other
        virtual machine has been assigned the `highest` priority, will mean that this
        VM will be started before any other virtual machine in the event of host
        failure.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        datastore = vsphere.get_datastore(name="datastore1",
            datacenter_id=datacenter.id)
        cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        network = vsphere.get_network(name="network1",
            datacenter_id=datacenter.id)
        vm = vsphere.VirtualMachine("vm",
            name="test",
            resource_pool_id=cluster.resource_pool_id,
            datastore_id=datastore.id,
            num_cpus=2,
            memory=2048,
            guest_id="otherLinux64Guest",
            network_interfaces=[{
                "network_id": network.id,
            }],
            disks=[{
                "label": "disk0",
                "size": 20,
            }])
        ha_vm_override = vsphere.HaVmOverride("ha_vm_override",
            compute_cluster_id=cluster.id,
            virtual_machine_id=vm.id,
            ha_vm_restart_priority="highest")
        ```

        ## Import

        An existing override can be imported into this resource by

        supplying both the path to the cluster, and the path to the virtual machine, to

        `pulumi import`. If no override exists, an error will be given.  An example

        is below:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/haVmOverride:HaVmOverride ha_vm_override \\
        ```

          '{"compute_cluster_path": "/dc1/host/cluster1", \\

          "virtual_machine_path": "/dc1/vm/srv1"}'

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compute_cluster_id: The managed object ID of the cluster.
        :param pulumi.Input[builtins.str] ha_datastore_apd_recovery_action: Controls the action to take on this virtual machine if an APD status on an affected datastore clears in the middle of an
               APD event. Can be one of useClusterDefault, none or reset.
        :param pulumi.Input[builtins.str] ha_datastore_apd_response: Controls the action to take on this virtual machine when the cluster has detected loss to all paths to a relevant
               datastore. Can be one of clusterDefault, disabled, warning, restartConservative, or restartAggressive.
        :param pulumi.Input[builtins.int] ha_datastore_apd_response_delay: Controls the delay in seconds to wait after an APD timeout event to execute the response action defined in
               ha_datastore_apd_response. Specify -1 to use the cluster setting.
        :param pulumi.Input[builtins.str] ha_datastore_pdl_response: Controls the action to take on this virtual machine when the cluster has detected a permanent device loss to a relevant
               datastore. Can be one of clusterDefault, disabled, warning, or restartAggressive.
        :param pulumi.Input[builtins.str] ha_host_isolation_response: The action to take on this virtual machine when a host is isolated from the rest of the cluster. Can be one of
               clusterIsolationResponse, none, powerOff, or shutdown.
        :param pulumi.Input[builtins.int] ha_vm_failure_interval: If a heartbeat from this virtual machine is not received within this configured interval, the virtual machine is marked
               as failed. The value is in seconds.
        :param pulumi.Input[builtins.int] ha_vm_maximum_failure_window: The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
               attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
               time is allotted.
        :param pulumi.Input[builtins.int] ha_vm_maximum_resets: The maximum number of resets that HA will perform to this virtual machine when responding to a failure event.
        :param pulumi.Input[builtins.int] ha_vm_minimum_uptime: The time, in seconds, that HA waits after powering on this virtual machine before monitoring for heartbeats.
        :param pulumi.Input[builtins.str] ha_vm_monitoring: The type of virtual machine monitoring to use for this virtual machine. Can be one of vmMonitoringDisabled,
               vmMonitoringOnly, or vmAndAppMonitoring.
        :param pulumi.Input[builtins.bool] ha_vm_monitoring_use_cluster_defaults: Determines whether or not the cluster's default settings or the VM override settings specified in this resource are used
               for virtual machine monitoring. The default is true (use cluster defaults) - set to false to have overrides take effect.
        :param pulumi.Input[builtins.str] ha_vm_restart_priority: The restart priority for this virtual machine when vSphere detects a host failure. Can be one of clusterRestartPriority,
               lowest, low, medium, high, or highest.
        :param pulumi.Input[builtins.int] ha_vm_restart_timeout: The maximum time, in seconds, that vSphere HA will wait for the virtual machine to be ready. Use -1 to use the cluster
               default.
        :param pulumi.Input[builtins.str] virtual_machine_id: The managed object ID of the virtual machine.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HaVmOverrideArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `HaVmOverride` resource can be used to add an override for
        vSphere HA settings on a cluster for a specific virtual machine. With this
        resource, one can control specific HA settings so that they are different than
        the cluster default, accommodating the needs of that specific virtual machine,
        while not affecting the rest of the cluster.

        For more information on vSphere HA, see [this page][ref-vsphere-ha-clusters].

        [ref-vsphere-ha-clusters]: https://techdocs.broadcom.com/us/en/vmware-cis/vsphere/vsphere/8-0/vsphere-availability.html

        > **NOTE:** This resource requires vCenter and is not available on direct ESXi
        connections.

        ## Example Usage

        The example below creates a virtual machine in a cluster using the
        `VirtualMachine` resource, creating the
        virtual machine in the cluster looked up by the
        `ComputeCluster` data source.

        Considering a scenario where this virtual machine is of high value to the
        application or organization for which it does its work, it's been determined in
        the event of a host failure, that this should be one of the first virtual
        machines to be started by vSphere HA during recovery. Hence, it
        `ha_vm_restart_priority` has been set to `highest`,
        which, assuming that the default restart priority is `medium` and no other
        virtual machine has been assigned the `highest` priority, will mean that this
        VM will be started before any other virtual machine in the event of host
        failure.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        datastore = vsphere.get_datastore(name="datastore1",
            datacenter_id=datacenter.id)
        cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        network = vsphere.get_network(name="network1",
            datacenter_id=datacenter.id)
        vm = vsphere.VirtualMachine("vm",
            name="test",
            resource_pool_id=cluster.resource_pool_id,
            datastore_id=datastore.id,
            num_cpus=2,
            memory=2048,
            guest_id="otherLinux64Guest",
            network_interfaces=[{
                "network_id": network.id,
            }],
            disks=[{
                "label": "disk0",
                "size": 20,
            }])
        ha_vm_override = vsphere.HaVmOverride("ha_vm_override",
            compute_cluster_id=cluster.id,
            virtual_machine_id=vm.id,
            ha_vm_restart_priority="highest")
        ```

        ## Import

        An existing override can be imported into this resource by

        supplying both the path to the cluster, and the path to the virtual machine, to

        `pulumi import`. If no override exists, an error will be given.  An example

        is below:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/haVmOverride:HaVmOverride ha_vm_override \\
        ```

          '{"compute_cluster_path": "/dc1/host/cluster1", \\

          "virtual_machine_path": "/dc1/vm/srv1"}'

        :param str resource_name: The name of the resource.
        :param HaVmOverrideArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HaVmOverrideArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compute_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 ha_datastore_apd_recovery_action: Optional[pulumi.Input[builtins.str]] = None,
                 ha_datastore_apd_response: Optional[pulumi.Input[builtins.str]] = None,
                 ha_datastore_apd_response_delay: Optional[pulumi.Input[builtins.int]] = None,
                 ha_datastore_pdl_response: Optional[pulumi.Input[builtins.str]] = None,
                 ha_host_isolation_response: Optional[pulumi.Input[builtins.str]] = None,
                 ha_vm_failure_interval: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_maximum_failure_window: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_maximum_resets: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_minimum_uptime: Optional[pulumi.Input[builtins.int]] = None,
                 ha_vm_monitoring: Optional[pulumi.Input[builtins.str]] = None,
                 ha_vm_monitoring_use_cluster_defaults: Optional[pulumi.Input[builtins.bool]] = None,
                 ha_vm_restart_priority: Optional[pulumi.Input[builtins.str]] = None,
                 ha_vm_restart_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HaVmOverrideArgs.__new__(HaVmOverrideArgs)

            if compute_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'compute_cluster_id'")
            __props__.__dict__["compute_cluster_id"] = compute_cluster_id
            __props__.__dict__["ha_datastore_apd_recovery_action"] = ha_datastore_apd_recovery_action
            __props__.__dict__["ha_datastore_apd_response"] = ha_datastore_apd_response
            __props__.__dict__["ha_datastore_apd_response_delay"] = ha_datastore_apd_response_delay
            __props__.__dict__["ha_datastore_pdl_response"] = ha_datastore_pdl_response
            __props__.__dict__["ha_host_isolation_response"] = ha_host_isolation_response
            __props__.__dict__["ha_vm_failure_interval"] = ha_vm_failure_interval
            __props__.__dict__["ha_vm_maximum_failure_window"] = ha_vm_maximum_failure_window
            __props__.__dict__["ha_vm_maximum_resets"] = ha_vm_maximum_resets
            __props__.__dict__["ha_vm_minimum_uptime"] = ha_vm_minimum_uptime
            __props__.__dict__["ha_vm_monitoring"] = ha_vm_monitoring
            __props__.__dict__["ha_vm_monitoring_use_cluster_defaults"] = ha_vm_monitoring_use_cluster_defaults
            __props__.__dict__["ha_vm_restart_priority"] = ha_vm_restart_priority
            __props__.__dict__["ha_vm_restart_timeout"] = ha_vm_restart_timeout
            if virtual_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_id'")
            __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        super(HaVmOverride, __self__).__init__(
            'vsphere:index/haVmOverride:HaVmOverride',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compute_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            ha_datastore_apd_recovery_action: Optional[pulumi.Input[builtins.str]] = None,
            ha_datastore_apd_response: Optional[pulumi.Input[builtins.str]] = None,
            ha_datastore_apd_response_delay: Optional[pulumi.Input[builtins.int]] = None,
            ha_datastore_pdl_response: Optional[pulumi.Input[builtins.str]] = None,
            ha_host_isolation_response: Optional[pulumi.Input[builtins.str]] = None,
            ha_vm_failure_interval: Optional[pulumi.Input[builtins.int]] = None,
            ha_vm_maximum_failure_window: Optional[pulumi.Input[builtins.int]] = None,
            ha_vm_maximum_resets: Optional[pulumi.Input[builtins.int]] = None,
            ha_vm_minimum_uptime: Optional[pulumi.Input[builtins.int]] = None,
            ha_vm_monitoring: Optional[pulumi.Input[builtins.str]] = None,
            ha_vm_monitoring_use_cluster_defaults: Optional[pulumi.Input[builtins.bool]] = None,
            ha_vm_restart_priority: Optional[pulumi.Input[builtins.str]] = None,
            ha_vm_restart_timeout: Optional[pulumi.Input[builtins.int]] = None,
            virtual_machine_id: Optional[pulumi.Input[builtins.str]] = None) -> 'HaVmOverride':
        """
        Get an existing HaVmOverride resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compute_cluster_id: The managed object ID of the cluster.
        :param pulumi.Input[builtins.str] ha_datastore_apd_recovery_action: Controls the action to take on this virtual machine if an APD status on an affected datastore clears in the middle of an
               APD event. Can be one of useClusterDefault, none or reset.
        :param pulumi.Input[builtins.str] ha_datastore_apd_response: Controls the action to take on this virtual machine when the cluster has detected loss to all paths to a relevant
               datastore. Can be one of clusterDefault, disabled, warning, restartConservative, or restartAggressive.
        :param pulumi.Input[builtins.int] ha_datastore_apd_response_delay: Controls the delay in seconds to wait after an APD timeout event to execute the response action defined in
               ha_datastore_apd_response. Specify -1 to use the cluster setting.
        :param pulumi.Input[builtins.str] ha_datastore_pdl_response: Controls the action to take on this virtual machine when the cluster has detected a permanent device loss to a relevant
               datastore. Can be one of clusterDefault, disabled, warning, or restartAggressive.
        :param pulumi.Input[builtins.str] ha_host_isolation_response: The action to take on this virtual machine when a host is isolated from the rest of the cluster. Can be one of
               clusterIsolationResponse, none, powerOff, or shutdown.
        :param pulumi.Input[builtins.int] ha_vm_failure_interval: If a heartbeat from this virtual machine is not received within this configured interval, the virtual machine is marked
               as failed. The value is in seconds.
        :param pulumi.Input[builtins.int] ha_vm_maximum_failure_window: The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
               attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
               time is allotted.
        :param pulumi.Input[builtins.int] ha_vm_maximum_resets: The maximum number of resets that HA will perform to this virtual machine when responding to a failure event.
        :param pulumi.Input[builtins.int] ha_vm_minimum_uptime: The time, in seconds, that HA waits after powering on this virtual machine before monitoring for heartbeats.
        :param pulumi.Input[builtins.str] ha_vm_monitoring: The type of virtual machine monitoring to use for this virtual machine. Can be one of vmMonitoringDisabled,
               vmMonitoringOnly, or vmAndAppMonitoring.
        :param pulumi.Input[builtins.bool] ha_vm_monitoring_use_cluster_defaults: Determines whether or not the cluster's default settings or the VM override settings specified in this resource are used
               for virtual machine monitoring. The default is true (use cluster defaults) - set to false to have overrides take effect.
        :param pulumi.Input[builtins.str] ha_vm_restart_priority: The restart priority for this virtual machine when vSphere detects a host failure. Can be one of clusterRestartPriority,
               lowest, low, medium, high, or highest.
        :param pulumi.Input[builtins.int] ha_vm_restart_timeout: The maximum time, in seconds, that vSphere HA will wait for the virtual machine to be ready. Use -1 to use the cluster
               default.
        :param pulumi.Input[builtins.str] virtual_machine_id: The managed object ID of the virtual machine.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HaVmOverrideState.__new__(_HaVmOverrideState)

        __props__.__dict__["compute_cluster_id"] = compute_cluster_id
        __props__.__dict__["ha_datastore_apd_recovery_action"] = ha_datastore_apd_recovery_action
        __props__.__dict__["ha_datastore_apd_response"] = ha_datastore_apd_response
        __props__.__dict__["ha_datastore_apd_response_delay"] = ha_datastore_apd_response_delay
        __props__.__dict__["ha_datastore_pdl_response"] = ha_datastore_pdl_response
        __props__.__dict__["ha_host_isolation_response"] = ha_host_isolation_response
        __props__.__dict__["ha_vm_failure_interval"] = ha_vm_failure_interval
        __props__.__dict__["ha_vm_maximum_failure_window"] = ha_vm_maximum_failure_window
        __props__.__dict__["ha_vm_maximum_resets"] = ha_vm_maximum_resets
        __props__.__dict__["ha_vm_minimum_uptime"] = ha_vm_minimum_uptime
        __props__.__dict__["ha_vm_monitoring"] = ha_vm_monitoring
        __props__.__dict__["ha_vm_monitoring_use_cluster_defaults"] = ha_vm_monitoring_use_cluster_defaults
        __props__.__dict__["ha_vm_restart_priority"] = ha_vm_restart_priority
        __props__.__dict__["ha_vm_restart_timeout"] = ha_vm_restart_timeout
        __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        return HaVmOverride(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The managed object ID of the cluster.
        """
        return pulumi.get(self, "compute_cluster_id")

    @property
    @pulumi.getter(name="haDatastoreApdRecoveryAction")
    def ha_datastore_apd_recovery_action(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Controls the action to take on this virtual machine if an APD status on an affected datastore clears in the middle of an
        APD event. Can be one of useClusterDefault, none or reset.
        """
        return pulumi.get(self, "ha_datastore_apd_recovery_action")

    @property
    @pulumi.getter(name="haDatastoreApdResponse")
    def ha_datastore_apd_response(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Controls the action to take on this virtual machine when the cluster has detected loss to all paths to a relevant
        datastore. Can be one of clusterDefault, disabled, warning, restartConservative, or restartAggressive.
        """
        return pulumi.get(self, "ha_datastore_apd_response")

    @property
    @pulumi.getter(name="haDatastoreApdResponseDelay")
    def ha_datastore_apd_response_delay(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Controls the delay in seconds to wait after an APD timeout event to execute the response action defined in
        ha_datastore_apd_response. Specify -1 to use the cluster setting.
        """
        return pulumi.get(self, "ha_datastore_apd_response_delay")

    @property
    @pulumi.getter(name="haDatastorePdlResponse")
    def ha_datastore_pdl_response(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Controls the action to take on this virtual machine when the cluster has detected a permanent device loss to a relevant
        datastore. Can be one of clusterDefault, disabled, warning, or restartAggressive.
        """
        return pulumi.get(self, "ha_datastore_pdl_response")

    @property
    @pulumi.getter(name="haHostIsolationResponse")
    def ha_host_isolation_response(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The action to take on this virtual machine when a host is isolated from the rest of the cluster. Can be one of
        clusterIsolationResponse, none, powerOff, or shutdown.
        """
        return pulumi.get(self, "ha_host_isolation_response")

    @property
    @pulumi.getter(name="haVmFailureInterval")
    def ha_vm_failure_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        If a heartbeat from this virtual machine is not received within this configured interval, the virtual machine is marked
        as failed. The value is in seconds.
        """
        return pulumi.get(self, "ha_vm_failure_interval")

    @property
    @pulumi.getter(name="haVmMaximumFailureWindow")
    def ha_vm_maximum_failure_window(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The length of the reset window in which ha_vm_maximum_resets can operate. When this window expires, no more resets are
        attempted regardless of the setting configured in ha_vm_maximum_resets. -1 means no window, meaning an unlimited reset
        time is allotted.
        """
        return pulumi.get(self, "ha_vm_maximum_failure_window")

    @property
    @pulumi.getter(name="haVmMaximumResets")
    def ha_vm_maximum_resets(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum number of resets that HA will perform to this virtual machine when responding to a failure event.
        """
        return pulumi.get(self, "ha_vm_maximum_resets")

    @property
    @pulumi.getter(name="haVmMinimumUptime")
    def ha_vm_minimum_uptime(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The time, in seconds, that HA waits after powering on this virtual machine before monitoring for heartbeats.
        """
        return pulumi.get(self, "ha_vm_minimum_uptime")

    @property
    @pulumi.getter(name="haVmMonitoring")
    def ha_vm_monitoring(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of virtual machine monitoring to use for this virtual machine. Can be one of vmMonitoringDisabled,
        vmMonitoringOnly, or vmAndAppMonitoring.
        """
        return pulumi.get(self, "ha_vm_monitoring")

    @property
    @pulumi.getter(name="haVmMonitoringUseClusterDefaults")
    def ha_vm_monitoring_use_cluster_defaults(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Determines whether or not the cluster's default settings or the VM override settings specified in this resource are used
        for virtual machine monitoring. The default is true (use cluster defaults) - set to false to have overrides take effect.
        """
        return pulumi.get(self, "ha_vm_monitoring_use_cluster_defaults")

    @property
    @pulumi.getter(name="haVmRestartPriority")
    def ha_vm_restart_priority(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The restart priority for this virtual machine when vSphere detects a host failure. Can be one of clusterRestartPriority,
        lowest, low, medium, high, or highest.
        """
        return pulumi.get(self, "ha_vm_restart_priority")

    @property
    @pulumi.getter(name="haVmRestartTimeout")
    def ha_vm_restart_timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum time, in seconds, that vSphere HA will wait for the virtual machine to be ready. Use -1 to use the cluster
        default.
        """
        return pulumi.get(self, "ha_vm_restart_timeout")

    @property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Output[builtins.str]:
        """
        The managed object ID of the virtual machine.
        """
        return pulumi.get(self, "virtual_machine_id")

