# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HostArgs', 'Host']

@pulumi.input_type
class HostArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str],
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_managed: Optional[pulumi.Input[builtins.bool]] = None,
                 connected: Optional[pulumi.Input[builtins.bool]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datacenter: Optional[pulumi.Input[builtins.str]] = None,
                 force: Optional[pulumi.Input[builtins.bool]] = None,
                 license: Optional[pulumi.Input[builtins.str]] = None,
                 lockdown: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance: Optional[pulumi.Input[builtins.bool]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['HostServiceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 thumbprint: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Host resource.
        :param pulumi.Input[builtins.str] hostname: FQDN or IP address of the host to be added.
        :param pulumi.Input[builtins.str] password: Password that will be used by vSphere to authenticate
               to the host.
        :param pulumi.Input[builtins.str] username: Username that will be used by vSphere to authenticate
               to the host.
        :param pulumi.Input[builtins.str] cluster: The ID of the Compute Cluster this host should
               be added to. This should not be set if `datacenter` is set. Conflicts with:
               `cluster_managed`.
        :param pulumi.Input[builtins.bool] cluster_managed: Can be set to `true` if compute cluster
               membership will be managed through the `compute_cluster` resource rather
               than the`host` resource. Conflicts with: `cluster`.
        :param pulumi.Input[builtins.bool] connected: If set to false then the host will be disconnected.
               Default is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: A map of custom attribute IDs and string
               values to apply to the resource. Please refer to the
               `vsphere_custom_attributes` resource for more information on applying
               tags to resources.
               
               > **NOTE:** Custom attributes are not supported on direct ESXi host
               connections and require vCenter Server.
               
               [docs-host-thumbprint-data-source]: /docs/providers/vsphere/d/host_thumbprint.html
        :param pulumi.Input[builtins.str] datacenter: The ID of the datacenter this host should
               be added to. This should not be set if `cluster` is set.
        :param pulumi.Input[builtins.bool] force: If set to `true` then it will force the host to be added,
               even if the host is already connected to a different vCenter Server instance.
               Default is `false`.
        :param pulumi.Input[builtins.str] license: The license key that will be applied to the host.
               The license key is expected to be present in vSphere.
        :param pulumi.Input[builtins.str] lockdown: Set the lockdown state of the host. Valid options are
               `disabled`, `normal`, and `strict`. Default is `disabled`.
        :param pulumi.Input[builtins.bool] maintenance: Set the management state of the host.
               Default is `false`.
        :param pulumi.Input[Sequence[pulumi.Input['HostServiceArgs']]] services: Set Services on host, the settings to be set are based on service being set as part of import.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource. Please
               refer to the `Tag` resource for more information on applying
               tags to resources.
               
               > **NOTE:** Tagging support is not supported on direct ESXi host
               connections and require vCenter Server.
        :param pulumi.Input[builtins.str] thumbprint: Host's certificate SHA-1 thumbprint. If not set the
               CA that signed the host's certificate should be trusted. If the CA is not
               trusted and no thumbprint is set then the operation will fail. See data source
               [`get_host_thumbprint`][docs-host-thumbprint-data-source].
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if cluster_managed is not None:
            pulumi.set(__self__, "cluster_managed", cluster_managed)
        if connected is not None:
            pulumi.set(__self__, "connected", connected)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if lockdown is not None:
            pulumi.set(__self__, "lockdown", lockdown)
        if maintenance is not None:
            pulumi.set(__self__, "maintenance", maintenance)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        FQDN or IP address of the host to be added.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        Password that will be used by vSphere to authenticate
        to the host.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        Username that will be used by vSphere to authenticate
        to the host.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Compute Cluster this host should
        be added to. This should not be set if `datacenter` is set. Conflicts with:
        `cluster_managed`.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="clusterManaged")
    def cluster_managed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Can be set to `true` if compute cluster
        membership will be managed through the `compute_cluster` resource rather
        than the`host` resource. Conflicts with: `cluster`.
        """
        return pulumi.get(self, "cluster_managed")

    @cluster_managed.setter
    def cluster_managed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cluster_managed", value)

    @property
    @pulumi.getter
    def connected(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to false then the host will be disconnected.
        Default is `false`.
        """
        return pulumi.get(self, "connected")

    @connected.setter
    def connected(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "connected", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of custom attribute IDs and string
        values to apply to the resource. Please refer to the
        `vsphere_custom_attributes` resource for more information on applying
        tags to resources.

        > **NOTE:** Custom attributes are not supported on direct ESXi host
        connections and require vCenter Server.

        [docs-host-thumbprint-data-source]: /docs/providers/vsphere/d/host_thumbprint.html
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the datacenter this host should
        be added to. This should not be set if `cluster` is set.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "datacenter", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true` then it will force the host to be added,
        even if the host is already connected to a different vCenter Server instance.
        Default is `false`.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The license key that will be applied to the host.
        The license key is expected to be present in vSphere.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license", value)

    @property
    @pulumi.getter
    def lockdown(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the lockdown state of the host. Valid options are
        `disabled`, `normal`, and `strict`. Default is `disabled`.
        """
        return pulumi.get(self, "lockdown")

    @lockdown.setter
    def lockdown(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lockdown", value)

    @property
    @pulumi.getter
    def maintenance(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set the management state of the host.
        Default is `false`.
        """
        return pulumi.get(self, "maintenance")

    @maintenance.setter
    def maintenance(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "maintenance", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostServiceArgs']]]]:
        """
        Set Services on host, the settings to be set are based on service being set as part of import.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of any tags to attach to this resource. Please
        refer to the `Tag` resource for more information on applying
        tags to resources.

        > **NOTE:** Tagging support is not supported on direct ESXi host
        connections and require vCenter Server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Host's certificate SHA-1 thumbprint. If not set the
        CA that signed the host's certificate should be trusted. If the CA is not
        trusted and no thumbprint is set then the operation will fail. See data source
        [`get_host_thumbprint`][docs-host-thumbprint-data-source].
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class _HostState:
    def __init__(__self__, *,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_managed: Optional[pulumi.Input[builtins.bool]] = None,
                 connected: Optional[pulumi.Input[builtins.bool]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datacenter: Optional[pulumi.Input[builtins.str]] = None,
                 force: Optional[pulumi.Input[builtins.bool]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 license: Optional[pulumi.Input[builtins.str]] = None,
                 lockdown: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance: Optional[pulumi.Input[builtins.bool]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['HostServiceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 thumbprint: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Host resources.
        :param pulumi.Input[builtins.str] cluster: The ID of the Compute Cluster this host should
               be added to. This should not be set if `datacenter` is set. Conflicts with:
               `cluster_managed`.
        :param pulumi.Input[builtins.bool] cluster_managed: Can be set to `true` if compute cluster
               membership will be managed through the `compute_cluster` resource rather
               than the`host` resource. Conflicts with: `cluster`.
        :param pulumi.Input[builtins.bool] connected: If set to false then the host will be disconnected.
               Default is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: A map of custom attribute IDs and string
               values to apply to the resource. Please refer to the
               `vsphere_custom_attributes` resource for more information on applying
               tags to resources.
               
               > **NOTE:** Custom attributes are not supported on direct ESXi host
               connections and require vCenter Server.
               
               [docs-host-thumbprint-data-source]: /docs/providers/vsphere/d/host_thumbprint.html
        :param pulumi.Input[builtins.str] datacenter: The ID of the datacenter this host should
               be added to. This should not be set if `cluster` is set.
        :param pulumi.Input[builtins.bool] force: If set to `true` then it will force the host to be added,
               even if the host is already connected to a different vCenter Server instance.
               Default is `false`.
        :param pulumi.Input[builtins.str] hostname: FQDN or IP address of the host to be added.
        :param pulumi.Input[builtins.str] license: The license key that will be applied to the host.
               The license key is expected to be present in vSphere.
        :param pulumi.Input[builtins.str] lockdown: Set the lockdown state of the host. Valid options are
               `disabled`, `normal`, and `strict`. Default is `disabled`.
        :param pulumi.Input[builtins.bool] maintenance: Set the management state of the host.
               Default is `false`.
        :param pulumi.Input[builtins.str] password: Password that will be used by vSphere to authenticate
               to the host.
        :param pulumi.Input[Sequence[pulumi.Input['HostServiceArgs']]] services: Set Services on host, the settings to be set are based on service being set as part of import.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource. Please
               refer to the `Tag` resource for more information on applying
               tags to resources.
               
               > **NOTE:** Tagging support is not supported on direct ESXi host
               connections and require vCenter Server.
        :param pulumi.Input[builtins.str] thumbprint: Host's certificate SHA-1 thumbprint. If not set the
               CA that signed the host's certificate should be trusted. If the CA is not
               trusted and no thumbprint is set then the operation will fail. See data source
               [`get_host_thumbprint`][docs-host-thumbprint-data-source].
        :param pulumi.Input[builtins.str] username: Username that will be used by vSphere to authenticate
               to the host.
        """
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if cluster_managed is not None:
            pulumi.set(__self__, "cluster_managed", cluster_managed)
        if connected is not None:
            pulumi.set(__self__, "connected", connected)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if lockdown is not None:
            pulumi.set(__self__, "lockdown", lockdown)
        if maintenance is not None:
            pulumi.set(__self__, "maintenance", maintenance)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the Compute Cluster this host should
        be added to. This should not be set if `datacenter` is set. Conflicts with:
        `cluster_managed`.
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter(name="clusterManaged")
    def cluster_managed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Can be set to `true` if compute cluster
        membership will be managed through the `compute_cluster` resource rather
        than the`host` resource. Conflicts with: `cluster`.
        """
        return pulumi.get(self, "cluster_managed")

    @cluster_managed.setter
    def cluster_managed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cluster_managed", value)

    @property
    @pulumi.getter
    def connected(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to false then the host will be disconnected.
        Default is `false`.
        """
        return pulumi.get(self, "connected")

    @connected.setter
    def connected(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "connected", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of custom attribute IDs and string
        values to apply to the resource. Please refer to the
        `vsphere_custom_attributes` resource for more information on applying
        tags to resources.

        > **NOTE:** Custom attributes are not supported on direct ESXi host
        connections and require vCenter Server.

        [docs-host-thumbprint-data-source]: /docs/providers/vsphere/d/host_thumbprint.html
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the datacenter this host should
        be added to. This should not be set if `cluster` is set.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "datacenter", value)

    @property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true` then it will force the host to be added,
        even if the host is already connected to a different vCenter Server instance.
        Default is `false`.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "force", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        FQDN or IP address of the host to be added.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The license key that will be applied to the host.
        The license key is expected to be present in vSphere.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license", value)

    @property
    @pulumi.getter
    def lockdown(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the lockdown state of the host. Valid options are
        `disabled`, `normal`, and `strict`. Default is `disabled`.
        """
        return pulumi.get(self, "lockdown")

    @lockdown.setter
    def lockdown(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lockdown", value)

    @property
    @pulumi.getter
    def maintenance(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set the management state of the host.
        Default is `false`.
        """
        return pulumi.get(self, "maintenance")

    @maintenance.setter
    def maintenance(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "maintenance", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password that will be used by vSphere to authenticate
        to the host.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostServiceArgs']]]]:
        """
        Set Services on host, the settings to be set are based on service being set as part of import.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of any tags to attach to this resource. Please
        refer to the `Tag` resource for more information on applying
        tags to resources.

        > **NOTE:** Tagging support is not supported on direct ESXi host
        connections and require vCenter Server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Host's certificate SHA-1 thumbprint. If not set the
        CA that signed the host's certificate should be trusted. If the CA is not
        trusted and no thumbprint is set then the operation will fail. See data source
        [`get_host_thumbprint`][docs-host-thumbprint-data-source].
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "thumbprint", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username that will be used by vSphere to authenticate
        to the host.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("vsphere:index/host:Host")
class Host(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_managed: Optional[pulumi.Input[builtins.bool]] = None,
                 connected: Optional[pulumi.Input[builtins.bool]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datacenter: Optional[pulumi.Input[builtins.str]] = None,
                 force: Optional[pulumi.Input[builtins.bool]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 license: Optional[pulumi.Input[builtins.str]] = None,
                 lockdown: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance: Optional[pulumi.Input[builtins.bool]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HostServiceArgs', 'HostServiceArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 thumbprint: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Provides a VMware vSphere host resource. This represents an ESXi host that
        can be used either as a member of a cluster or as a standalone host.

        ## Example Usage

        ### Create a standalone host

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        thumbprint = vsphere.get_host_thumbprint(address="esxi-01.example.com",
            insecure=True)
        esx_01 = vsphere.Host("esx-01",
            hostname="esxi-01.example.com",
            username="root",
            password="password",
            license="00000-00000-00000-00000-00000",
            thumbprint=thumbprint.id,
            datacenter=datacenter.id)
        ```

        ### Create host in a compute cluster

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        thumbprint = vsphere.get_host_thumbprint(address="esxi-01.example.com",
            insecure=True)
        esx_01 = vsphere.Host("esx-01",
            hostname="esxi-01.example.com",
            username="root",
            password="password",
            license="00000-00000-00000-00000-00000",
            thumbprint=thumbprint.id,
            cluster=cluster.id,
            services=[{
                "ntpd": {
                    "enabled": True,
                    "policy": "on",
                    "ntp_servers": ["pool.ntp.org"],
                },
            }])
        ```

        ## Import

        An existing host can be imported into this resource by supplying

        the host's ID.

        [docs-import]: /docs/import/index.html

        Obtain the host's ID using the data source. For example:

        hcl

        data "vsphere_datacenter" "datacenter" {

          name = "dc-01"

        }

        data "vsphere_host" "host" {

          name          = "esxi-01.example.com"

          datacenter_id = data.vsphere_datacenter.datacenter.id

        }

        output "host_id" {

          value = data.vsphere_host.host.id

        }

        Next, create a resource configuration, For example:

        hcl

        data "vsphere_datacenter" "datacenter" {

          name = "dc-01"

        }

        data "vsphere_host_thumbprint" "thumbprint" {

          address  = "esxi-01.example.com"

          insecure = true

        }

        resource "vsphere_host" "esx-01" {

          hostname   = "esxi-01.example.com"

          username   = "root"

          password   = "password"

          thumbprint = data.vsphere_host_thumbprint.thumbprint.id

          datacenter = data.vsphere_datacenter.datacenter.id

        }

        hcl

        resource "vsphere_host" "esx-01" {

          hostname   = "esxi-01.example.com"

          username   = "root"

          password   = "password"

          license    = "00000-00000-00000-00000-00000"

          thumbprint = data.vsphere_host_thumbprint.thumbprint.id

          cluster    = data.vsphere_compute_cluster.cluster.id

          services {

            ntpd {
            
              enabled     = true
            
              policy      = "on"
            
              ntp_servers = ["pool.ntp.org"]
            
            }

          }

        }

        ```sh
        $ pulumi import vsphere:index/host:Host esx-01 host-123
        ```

        The above would import the host `esxi-01.example.com` with the host ID `host-123`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster: The ID of the Compute Cluster this host should
               be added to. This should not be set if `datacenter` is set. Conflicts with:
               `cluster_managed`.
        :param pulumi.Input[builtins.bool] cluster_managed: Can be set to `true` if compute cluster
               membership will be managed through the `compute_cluster` resource rather
               than the`host` resource. Conflicts with: `cluster`.
        :param pulumi.Input[builtins.bool] connected: If set to false then the host will be disconnected.
               Default is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: A map of custom attribute IDs and string
               values to apply to the resource. Please refer to the
               `vsphere_custom_attributes` resource for more information on applying
               tags to resources.
               
               > **NOTE:** Custom attributes are not supported on direct ESXi host
               connections and require vCenter Server.
               
               [docs-host-thumbprint-data-source]: /docs/providers/vsphere/d/host_thumbprint.html
        :param pulumi.Input[builtins.str] datacenter: The ID of the datacenter this host should
               be added to. This should not be set if `cluster` is set.
        :param pulumi.Input[builtins.bool] force: If set to `true` then it will force the host to be added,
               even if the host is already connected to a different vCenter Server instance.
               Default is `false`.
        :param pulumi.Input[builtins.str] hostname: FQDN or IP address of the host to be added.
        :param pulumi.Input[builtins.str] license: The license key that will be applied to the host.
               The license key is expected to be present in vSphere.
        :param pulumi.Input[builtins.str] lockdown: Set the lockdown state of the host. Valid options are
               `disabled`, `normal`, and `strict`. Default is `disabled`.
        :param pulumi.Input[builtins.bool] maintenance: Set the management state of the host.
               Default is `false`.
        :param pulumi.Input[builtins.str] password: Password that will be used by vSphere to authenticate
               to the host.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HostServiceArgs', 'HostServiceArgsDict']]]] services: Set Services on host, the settings to be set are based on service being set as part of import.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource. Please
               refer to the `Tag` resource for more information on applying
               tags to resources.
               
               > **NOTE:** Tagging support is not supported on direct ESXi host
               connections and require vCenter Server.
        :param pulumi.Input[builtins.str] thumbprint: Host's certificate SHA-1 thumbprint. If not set the
               CA that signed the host's certificate should be trusted. If the CA is not
               trusted and no thumbprint is set then the operation will fail. See data source
               [`get_host_thumbprint`][docs-host-thumbprint-data-source].
        :param pulumi.Input[builtins.str] username: Username that will be used by vSphere to authenticate
               to the host.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VMware vSphere host resource. This represents an ESXi host that
        can be used either as a member of a cluster or as a standalone host.

        ## Example Usage

        ### Create a standalone host

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        thumbprint = vsphere.get_host_thumbprint(address="esxi-01.example.com",
            insecure=True)
        esx_01 = vsphere.Host("esx-01",
            hostname="esxi-01.example.com",
            username="root",
            password="password",
            license="00000-00000-00000-00000-00000",
            thumbprint=thumbprint.id,
            datacenter=datacenter.id)
        ```

        ### Create host in a compute cluster

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        thumbprint = vsphere.get_host_thumbprint(address="esxi-01.example.com",
            insecure=True)
        esx_01 = vsphere.Host("esx-01",
            hostname="esxi-01.example.com",
            username="root",
            password="password",
            license="00000-00000-00000-00000-00000",
            thumbprint=thumbprint.id,
            cluster=cluster.id,
            services=[{
                "ntpd": {
                    "enabled": True,
                    "policy": "on",
                    "ntp_servers": ["pool.ntp.org"],
                },
            }])
        ```

        ## Import

        An existing host can be imported into this resource by supplying

        the host's ID.

        [docs-import]: /docs/import/index.html

        Obtain the host's ID using the data source. For example:

        hcl

        data "vsphere_datacenter" "datacenter" {

          name = "dc-01"

        }

        data "vsphere_host" "host" {

          name          = "esxi-01.example.com"

          datacenter_id = data.vsphere_datacenter.datacenter.id

        }

        output "host_id" {

          value = data.vsphere_host.host.id

        }

        Next, create a resource configuration, For example:

        hcl

        data "vsphere_datacenter" "datacenter" {

          name = "dc-01"

        }

        data "vsphere_host_thumbprint" "thumbprint" {

          address  = "esxi-01.example.com"

          insecure = true

        }

        resource "vsphere_host" "esx-01" {

          hostname   = "esxi-01.example.com"

          username   = "root"

          password   = "password"

          thumbprint = data.vsphere_host_thumbprint.thumbprint.id

          datacenter = data.vsphere_datacenter.datacenter.id

        }

        hcl

        resource "vsphere_host" "esx-01" {

          hostname   = "esxi-01.example.com"

          username   = "root"

          password   = "password"

          license    = "00000-00000-00000-00000-00000"

          thumbprint = data.vsphere_host_thumbprint.thumbprint.id

          cluster    = data.vsphere_compute_cluster.cluster.id

          services {

            ntpd {
            
              enabled     = true
            
              policy      = "on"
            
              ntp_servers = ["pool.ntp.org"]
            
            }

          }

        }

        ```sh
        $ pulumi import vsphere:index/host:Host esx-01 host-123
        ```

        The above would import the host `esxi-01.example.com` with the host ID `host-123`.

        :param str resource_name: The name of the resource.
        :param HostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_managed: Optional[pulumi.Input[builtins.bool]] = None,
                 connected: Optional[pulumi.Input[builtins.bool]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datacenter: Optional[pulumi.Input[builtins.str]] = None,
                 force: Optional[pulumi.Input[builtins.bool]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 license: Optional[pulumi.Input[builtins.str]] = None,
                 lockdown: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance: Optional[pulumi.Input[builtins.bool]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HostServiceArgs', 'HostServiceArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 thumbprint: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostArgs.__new__(HostArgs)

            __props__.__dict__["cluster"] = cluster
            __props__.__dict__["cluster_managed"] = cluster_managed
            __props__.__dict__["connected"] = connected
            __props__.__dict__["custom_attributes"] = custom_attributes
            __props__.__dict__["datacenter"] = datacenter
            __props__.__dict__["force"] = force
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["license"] = license
            __props__.__dict__["lockdown"] = lockdown
            __props__.__dict__["maintenance"] = maintenance
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["services"] = services
            __props__.__dict__["tags"] = tags
            __props__.__dict__["thumbprint"] = thumbprint
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Host, __self__).__init__(
            'vsphere:index/host:Host',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster: Optional[pulumi.Input[builtins.str]] = None,
            cluster_managed: Optional[pulumi.Input[builtins.bool]] = None,
            connected: Optional[pulumi.Input[builtins.bool]] = None,
            custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            datacenter: Optional[pulumi.Input[builtins.str]] = None,
            force: Optional[pulumi.Input[builtins.bool]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            license: Optional[pulumi.Input[builtins.str]] = None,
            lockdown: Optional[pulumi.Input[builtins.str]] = None,
            maintenance: Optional[pulumi.Input[builtins.bool]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HostServiceArgs', 'HostServiceArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            thumbprint: Optional[pulumi.Input[builtins.str]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None) -> 'Host':
        """
        Get an existing Host resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cluster: The ID of the Compute Cluster this host should
               be added to. This should not be set if `datacenter` is set. Conflicts with:
               `cluster_managed`.
        :param pulumi.Input[builtins.bool] cluster_managed: Can be set to `true` if compute cluster
               membership will be managed through the `compute_cluster` resource rather
               than the`host` resource. Conflicts with: `cluster`.
        :param pulumi.Input[builtins.bool] connected: If set to false then the host will be disconnected.
               Default is `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: A map of custom attribute IDs and string
               values to apply to the resource. Please refer to the
               `vsphere_custom_attributes` resource for more information on applying
               tags to resources.
               
               > **NOTE:** Custom attributes are not supported on direct ESXi host
               connections and require vCenter Server.
               
               [docs-host-thumbprint-data-source]: /docs/providers/vsphere/d/host_thumbprint.html
        :param pulumi.Input[builtins.str] datacenter: The ID of the datacenter this host should
               be added to. This should not be set if `cluster` is set.
        :param pulumi.Input[builtins.bool] force: If set to `true` then it will force the host to be added,
               even if the host is already connected to a different vCenter Server instance.
               Default is `false`.
        :param pulumi.Input[builtins.str] hostname: FQDN or IP address of the host to be added.
        :param pulumi.Input[builtins.str] license: The license key that will be applied to the host.
               The license key is expected to be present in vSphere.
        :param pulumi.Input[builtins.str] lockdown: Set the lockdown state of the host. Valid options are
               `disabled`, `normal`, and `strict`. Default is `disabled`.
        :param pulumi.Input[builtins.bool] maintenance: Set the management state of the host.
               Default is `false`.
        :param pulumi.Input[builtins.str] password: Password that will be used by vSphere to authenticate
               to the host.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HostServiceArgs', 'HostServiceArgsDict']]]] services: Set Services on host, the settings to be set are based on service being set as part of import.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource. Please
               refer to the `Tag` resource for more information on applying
               tags to resources.
               
               > **NOTE:** Tagging support is not supported on direct ESXi host
               connections and require vCenter Server.
        :param pulumi.Input[builtins.str] thumbprint: Host's certificate SHA-1 thumbprint. If not set the
               CA that signed the host's certificate should be trusted. If the CA is not
               trusted and no thumbprint is set then the operation will fail. See data source
               [`get_host_thumbprint`][docs-host-thumbprint-data-source].
        :param pulumi.Input[builtins.str] username: Username that will be used by vSphere to authenticate
               to the host.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostState.__new__(_HostState)

        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["cluster_managed"] = cluster_managed
        __props__.__dict__["connected"] = connected
        __props__.__dict__["custom_attributes"] = custom_attributes
        __props__.__dict__["datacenter"] = datacenter
        __props__.__dict__["force"] = force
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["license"] = license
        __props__.__dict__["lockdown"] = lockdown
        __props__.__dict__["maintenance"] = maintenance
        __props__.__dict__["password"] = password
        __props__.__dict__["services"] = services
        __props__.__dict__["tags"] = tags
        __props__.__dict__["thumbprint"] = thumbprint
        __props__.__dict__["username"] = username
        return Host(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the Compute Cluster this host should
        be added to. This should not be set if `datacenter` is set. Conflicts with:
        `cluster_managed`.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="clusterManaged")
    def cluster_managed(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Can be set to `true` if compute cluster
        membership will be managed through the `compute_cluster` resource rather
        than the`host` resource. Conflicts with: `cluster`.
        """
        return pulumi.get(self, "cluster_managed")

    @property
    @pulumi.getter
    def connected(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to false then the host will be disconnected.
        Default is `false`.
        """
        return pulumi.get(self, "connected")

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of custom attribute IDs and string
        values to apply to the resource. Please refer to the
        `vsphere_custom_attributes` resource for more information on applying
        tags to resources.

        > **NOTE:** Custom attributes are not supported on direct ESXi host
        connections and require vCenter Server.

        [docs-host-thumbprint-data-source]: /docs/providers/vsphere/d/host_thumbprint.html
        """
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter
    def datacenter(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the datacenter this host should
        be added to. This should not be set if `cluster` is set.
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to `true` then it will force the host to be added,
        even if the host is already connected to a different vCenter Server instance.
        Default is `false`.
        """
        return pulumi.get(self, "force")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[builtins.str]:
        """
        FQDN or IP address of the host to be added.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def license(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The license key that will be applied to the host.
        The license key is expected to be present in vSphere.
        """
        return pulumi.get(self, "license")

    @property
    @pulumi.getter
    def lockdown(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set the lockdown state of the host. Valid options are
        `disabled`, `normal`, and `strict`. Default is `disabled`.
        """
        return pulumi.get(self, "lockdown")

    @property
    @pulumi.getter
    def maintenance(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Set the management state of the host.
        Default is `false`.
        """
        return pulumi.get(self, "maintenance")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        Password that will be used by vSphere to authenticate
        to the host.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def services(self) -> pulumi.Output[Optional[Sequence['outputs.HostService']]]:
        """
        Set Services on host, the settings to be set are based on service being set as part of import.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The IDs of any tags to attach to this resource. Please
        refer to the `Tag` resource for more information on applying
        tags to resources.

        > **NOTE:** Tagging support is not supported on direct ESXi host
        connections and require vCenter Server.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Host's certificate SHA-1 thumbprint. If not set the
        CA that signed the host's certificate should be trusted. If the CA is not
        trusted and no thumbprint is set then the operation will fail. See data source
        [`get_host_thumbprint`][docs-host-thumbprint-data-source].
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        Username that will be used by vSphere to authenticate
        to the host.
        """
        return pulumi.get(self, "username")

