# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HostPortGroupArgs', 'HostPortGroup']

@pulumi.input_type
class HostPortGroupArgs:
    def __init__(__self__, *,
                 host_system_id: pulumi.Input[builtins.str],
                 virtual_switch_name: pulumi.Input[builtins.str],
                 active_nics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allow_forged_transmits: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_mac_changes: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_promiscuous: Optional[pulumi.Input[builtins.bool]] = None,
                 check_beacon: Optional[pulumi.Input[builtins.bool]] = None,
                 failback: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notify_switches: Optional[pulumi.Input[builtins.bool]] = None,
                 shaping_average_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
                 shaping_burst_size: Optional[pulumi.Input[builtins.int]] = None,
                 shaping_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 shaping_peak_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
                 standby_nics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 teaming_policy: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a HostPortGroup resource.
        :param pulumi.Input[builtins.str] host_system_id: The managed object ID of
               the host to set the port group up on. Forces a new resource if changed.
        :param pulumi.Input[builtins.str] virtual_switch_name: The name of the virtual switch to bind
               this port group to. Forces a new resource if changed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] active_nics: List of active network adapters used for load balancing.
        :param pulumi.Input[builtins.bool] allow_forged_transmits: Controls whether or not the virtual network adapter is allowed to send network traffic with a different MAC address than
               that of its own.
        :param pulumi.Input[builtins.bool] allow_mac_changes: Controls whether or not the Media Access Control (MAC) address can be changed.
        :param pulumi.Input[builtins.bool] allow_promiscuous: Enable promiscuous mode on the network. This flag indicates whether or not all traffic is seen on a given port.
        :param pulumi.Input[builtins.bool] check_beacon: Enable beacon probing. Requires that the vSwitch has been configured to use a beacon. If disabled, link status is used
               only.
        :param pulumi.Input[builtins.bool] failback: If true, the teaming policy will re-activate failed interfaces higher in precedence when they come back up.
        :param pulumi.Input[builtins.str] name: The name of the port group.  Forces a new resource if
               changed.
        :param pulumi.Input[builtins.bool] notify_switches: If true, the teaming policy will notify the broadcast network of a NIC failover, triggering cache updates.
        :param pulumi.Input[builtins.int] shaping_average_bandwidth: The average bandwidth in bits per second if traffic shaping is enabled.
        :param pulumi.Input[builtins.int] shaping_burst_size: The maximum burst size allowed in bytes if traffic shaping is enabled.
        :param pulumi.Input[builtins.bool] shaping_enabled: Enable traffic shaping on this virtual switch or port group.
        :param pulumi.Input[builtins.int] shaping_peak_bandwidth: The peak bandwidth during bursts in bits per second if traffic shaping is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] standby_nics: List of standby network adapters used for failover.
        :param pulumi.Input[builtins.str] teaming_policy: The network adapter teaming policy. Can be one of loadbalance_ip, loadbalance_srcmac, loadbalance_srcid, or
               failover_explicit.
        :param pulumi.Input[builtins.int] vlan_id: The VLAN ID/trunk mode for this port group.  An ID of
               `0` denotes no tagging, an ID of `1`-`4094` tags with the specific ID, and an
               ID of `4095` enables trunk mode, allowing the guest to manage its own
               tagging. Default: `0`.
        """
        pulumi.set(__self__, "host_system_id", host_system_id)
        pulumi.set(__self__, "virtual_switch_name", virtual_switch_name)
        if active_nics is not None:
            pulumi.set(__self__, "active_nics", active_nics)
        if allow_forged_transmits is not None:
            pulumi.set(__self__, "allow_forged_transmits", allow_forged_transmits)
        if allow_mac_changes is not None:
            pulumi.set(__self__, "allow_mac_changes", allow_mac_changes)
        if allow_promiscuous is not None:
            pulumi.set(__self__, "allow_promiscuous", allow_promiscuous)
        if check_beacon is not None:
            pulumi.set(__self__, "check_beacon", check_beacon)
        if failback is not None:
            pulumi.set(__self__, "failback", failback)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notify_switches is not None:
            pulumi.set(__self__, "notify_switches", notify_switches)
        if shaping_average_bandwidth is not None:
            pulumi.set(__self__, "shaping_average_bandwidth", shaping_average_bandwidth)
        if shaping_burst_size is not None:
            pulumi.set(__self__, "shaping_burst_size", shaping_burst_size)
        if shaping_enabled is not None:
            pulumi.set(__self__, "shaping_enabled", shaping_enabled)
        if shaping_peak_bandwidth is not None:
            pulumi.set(__self__, "shaping_peak_bandwidth", shaping_peak_bandwidth)
        if standby_nics is not None:
            pulumi.set(__self__, "standby_nics", standby_nics)
        if teaming_policy is not None:
            pulumi.set(__self__, "teaming_policy", teaming_policy)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="hostSystemId")
    def host_system_id(self) -> pulumi.Input[builtins.str]:
        """
        The managed object ID of
        the host to set the port group up on. Forces a new resource if changed.
        """
        return pulumi.get(self, "host_system_id")

    @host_system_id.setter
    def host_system_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host_system_id", value)

    @property
    @pulumi.getter(name="virtualSwitchName")
    def virtual_switch_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the virtual switch to bind
        this port group to. Forces a new resource if changed.
        """
        return pulumi.get(self, "virtual_switch_name")

    @virtual_switch_name.setter
    def virtual_switch_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "virtual_switch_name", value)

    @property
    @pulumi.getter(name="activeNics")
    def active_nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of active network adapters used for load balancing.
        """
        return pulumi.get(self, "active_nics")

    @active_nics.setter
    def active_nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "active_nics", value)

    @property
    @pulumi.getter(name="allowForgedTransmits")
    def allow_forged_transmits(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls whether or not the virtual network adapter is allowed to send network traffic with a different MAC address than
        that of its own.
        """
        return pulumi.get(self, "allow_forged_transmits")

    @allow_forged_transmits.setter
    def allow_forged_transmits(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_forged_transmits", value)

    @property
    @pulumi.getter(name="allowMacChanges")
    def allow_mac_changes(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls whether or not the Media Access Control (MAC) address can be changed.
        """
        return pulumi.get(self, "allow_mac_changes")

    @allow_mac_changes.setter
    def allow_mac_changes(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_mac_changes", value)

    @property
    @pulumi.getter(name="allowPromiscuous")
    def allow_promiscuous(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable promiscuous mode on the network. This flag indicates whether or not all traffic is seen on a given port.
        """
        return pulumi.get(self, "allow_promiscuous")

    @allow_promiscuous.setter
    def allow_promiscuous(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_promiscuous", value)

    @property
    @pulumi.getter(name="checkBeacon")
    def check_beacon(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable beacon probing. Requires that the vSwitch has been configured to use a beacon. If disabled, link status is used
        only.
        """
        return pulumi.get(self, "check_beacon")

    @check_beacon.setter
    def check_beacon(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "check_beacon", value)

    @property
    @pulumi.getter
    def failback(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the teaming policy will re-activate failed interfaces higher in precedence when they come back up.
        """
        return pulumi.get(self, "failback")

    @failback.setter
    def failback(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "failback", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the port group.  Forces a new resource if
        changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notifySwitches")
    def notify_switches(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the teaming policy will notify the broadcast network of a NIC failover, triggering cache updates.
        """
        return pulumi.get(self, "notify_switches")

    @notify_switches.setter
    def notify_switches(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "notify_switches", value)

    @property
    @pulumi.getter(name="shapingAverageBandwidth")
    def shaping_average_bandwidth(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The average bandwidth in bits per second if traffic shaping is enabled.
        """
        return pulumi.get(self, "shaping_average_bandwidth")

    @shaping_average_bandwidth.setter
    def shaping_average_bandwidth(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "shaping_average_bandwidth", value)

    @property
    @pulumi.getter(name="shapingBurstSize")
    def shaping_burst_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum burst size allowed in bytes if traffic shaping is enabled.
        """
        return pulumi.get(self, "shaping_burst_size")

    @shaping_burst_size.setter
    def shaping_burst_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "shaping_burst_size", value)

    @property
    @pulumi.getter(name="shapingEnabled")
    def shaping_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable traffic shaping on this virtual switch or port group.
        """
        return pulumi.get(self, "shaping_enabled")

    @shaping_enabled.setter
    def shaping_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shaping_enabled", value)

    @property
    @pulumi.getter(name="shapingPeakBandwidth")
    def shaping_peak_bandwidth(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The peak bandwidth during bursts in bits per second if traffic shaping is enabled.
        """
        return pulumi.get(self, "shaping_peak_bandwidth")

    @shaping_peak_bandwidth.setter
    def shaping_peak_bandwidth(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "shaping_peak_bandwidth", value)

    @property
    @pulumi.getter(name="standbyNics")
    def standby_nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of standby network adapters used for failover.
        """
        return pulumi.get(self, "standby_nics")

    @standby_nics.setter
    def standby_nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "standby_nics", value)

    @property
    @pulumi.getter(name="teamingPolicy")
    def teaming_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network adapter teaming policy. Can be one of loadbalance_ip, loadbalance_srcmac, loadbalance_srcid, or
        failover_explicit.
        """
        return pulumi.get(self, "teaming_policy")

    @teaming_policy.setter
    def teaming_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "teaming_policy", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The VLAN ID/trunk mode for this port group.  An ID of
        `0` denotes no tagging, an ID of `1`-`4094` tags with the specific ID, and an
        ID of `4095` enables trunk mode, allowing the guest to manage its own
        tagging. Default: `0`.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vlan_id", value)


@pulumi.input_type
class _HostPortGroupState:
    def __init__(__self__, *,
                 active_nics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allow_forged_transmits: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_mac_changes: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_promiscuous: Optional[pulumi.Input[builtins.bool]] = None,
                 check_beacon: Optional[pulumi.Input[builtins.bool]] = None,
                 computed_policy: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 failback: Optional[pulumi.Input[builtins.bool]] = None,
                 host_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notify_switches: Optional[pulumi.Input[builtins.bool]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['HostPortGroupPortArgs']]]] = None,
                 shaping_average_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
                 shaping_burst_size: Optional[pulumi.Input[builtins.int]] = None,
                 shaping_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 shaping_peak_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
                 standby_nics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 teaming_policy: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_switch_name: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering HostPortGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] active_nics: List of active network adapters used for load balancing.
        :param pulumi.Input[builtins.bool] allow_forged_transmits: Controls whether or not the virtual network adapter is allowed to send network traffic with a different MAC address than
               that of its own.
        :param pulumi.Input[builtins.bool] allow_mac_changes: Controls whether or not the Media Access Control (MAC) address can be changed.
        :param pulumi.Input[builtins.bool] allow_promiscuous: Enable promiscuous mode on the network. This flag indicates whether or not all traffic is seen on a given port.
        :param pulumi.Input[builtins.bool] check_beacon: Enable beacon probing. Requires that the vSwitch has been configured to use a beacon. If disabled, link status is used
               only.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] computed_policy: A map with a full set of the policy
               options computed from defaults and overrides,
               explaining the effective policy for this port group.
        :param pulumi.Input[builtins.bool] failback: If true, the teaming policy will re-activate failed interfaces higher in precedence when they come back up.
        :param pulumi.Input[builtins.str] host_system_id: The managed object ID of
               the host to set the port group up on. Forces a new resource if changed.
        :param pulumi.Input[builtins.str] key: The key for this port group as returned from the vSphere API.
        :param pulumi.Input[builtins.str] name: The name of the port group.  Forces a new resource if
               changed.
        :param pulumi.Input[builtins.bool] notify_switches: If true, the teaming policy will notify the broadcast network of a NIC failover, triggering cache updates.
        :param pulumi.Input[Sequence[pulumi.Input['HostPortGroupPortArgs']]] ports: A list of ports that currently exist and are used on this port group.
        :param pulumi.Input[builtins.int] shaping_average_bandwidth: The average bandwidth in bits per second if traffic shaping is enabled.
        :param pulumi.Input[builtins.int] shaping_burst_size: The maximum burst size allowed in bytes if traffic shaping is enabled.
        :param pulumi.Input[builtins.bool] shaping_enabled: Enable traffic shaping on this virtual switch or port group.
        :param pulumi.Input[builtins.int] shaping_peak_bandwidth: The peak bandwidth during bursts in bits per second if traffic shaping is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] standby_nics: List of standby network adapters used for failover.
        :param pulumi.Input[builtins.str] teaming_policy: The network adapter teaming policy. Can be one of loadbalance_ip, loadbalance_srcmac, loadbalance_srcid, or
               failover_explicit.
        :param pulumi.Input[builtins.str] virtual_switch_name: The name of the virtual switch to bind
               this port group to. Forces a new resource if changed.
        :param pulumi.Input[builtins.int] vlan_id: The VLAN ID/trunk mode for this port group.  An ID of
               `0` denotes no tagging, an ID of `1`-`4094` tags with the specific ID, and an
               ID of `4095` enables trunk mode, allowing the guest to manage its own
               tagging. Default: `0`.
        """
        if active_nics is not None:
            pulumi.set(__self__, "active_nics", active_nics)
        if allow_forged_transmits is not None:
            pulumi.set(__self__, "allow_forged_transmits", allow_forged_transmits)
        if allow_mac_changes is not None:
            pulumi.set(__self__, "allow_mac_changes", allow_mac_changes)
        if allow_promiscuous is not None:
            pulumi.set(__self__, "allow_promiscuous", allow_promiscuous)
        if check_beacon is not None:
            pulumi.set(__self__, "check_beacon", check_beacon)
        if computed_policy is not None:
            pulumi.set(__self__, "computed_policy", computed_policy)
        if failback is not None:
            pulumi.set(__self__, "failback", failback)
        if host_system_id is not None:
            pulumi.set(__self__, "host_system_id", host_system_id)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notify_switches is not None:
            pulumi.set(__self__, "notify_switches", notify_switches)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if shaping_average_bandwidth is not None:
            pulumi.set(__self__, "shaping_average_bandwidth", shaping_average_bandwidth)
        if shaping_burst_size is not None:
            pulumi.set(__self__, "shaping_burst_size", shaping_burst_size)
        if shaping_enabled is not None:
            pulumi.set(__self__, "shaping_enabled", shaping_enabled)
        if shaping_peak_bandwidth is not None:
            pulumi.set(__self__, "shaping_peak_bandwidth", shaping_peak_bandwidth)
        if standby_nics is not None:
            pulumi.set(__self__, "standby_nics", standby_nics)
        if teaming_policy is not None:
            pulumi.set(__self__, "teaming_policy", teaming_policy)
        if virtual_switch_name is not None:
            pulumi.set(__self__, "virtual_switch_name", virtual_switch_name)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="activeNics")
    def active_nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of active network adapters used for load balancing.
        """
        return pulumi.get(self, "active_nics")

    @active_nics.setter
    def active_nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "active_nics", value)

    @property
    @pulumi.getter(name="allowForgedTransmits")
    def allow_forged_transmits(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls whether or not the virtual network adapter is allowed to send network traffic with a different MAC address than
        that of its own.
        """
        return pulumi.get(self, "allow_forged_transmits")

    @allow_forged_transmits.setter
    def allow_forged_transmits(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_forged_transmits", value)

    @property
    @pulumi.getter(name="allowMacChanges")
    def allow_mac_changes(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls whether or not the Media Access Control (MAC) address can be changed.
        """
        return pulumi.get(self, "allow_mac_changes")

    @allow_mac_changes.setter
    def allow_mac_changes(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_mac_changes", value)

    @property
    @pulumi.getter(name="allowPromiscuous")
    def allow_promiscuous(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable promiscuous mode on the network. This flag indicates whether or not all traffic is seen on a given port.
        """
        return pulumi.get(self, "allow_promiscuous")

    @allow_promiscuous.setter
    def allow_promiscuous(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_promiscuous", value)

    @property
    @pulumi.getter(name="checkBeacon")
    def check_beacon(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable beacon probing. Requires that the vSwitch has been configured to use a beacon. If disabled, link status is used
        only.
        """
        return pulumi.get(self, "check_beacon")

    @check_beacon.setter
    def check_beacon(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "check_beacon", value)

    @property
    @pulumi.getter(name="computedPolicy")
    def computed_policy(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map with a full set of the policy
        options computed from defaults and overrides,
        explaining the effective policy for this port group.
        """
        return pulumi.get(self, "computed_policy")

    @computed_policy.setter
    def computed_policy(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "computed_policy", value)

    @property
    @pulumi.getter
    def failback(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the teaming policy will re-activate failed interfaces higher in precedence when they come back up.
        """
        return pulumi.get(self, "failback")

    @failback.setter
    def failback(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "failback", value)

    @property
    @pulumi.getter(name="hostSystemId")
    def host_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The managed object ID of
        the host to set the port group up on. Forces a new resource if changed.
        """
        return pulumi.get(self, "host_system_id")

    @host_system_id.setter
    def host_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_system_id", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key for this port group as returned from the vSphere API.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the port group.  Forces a new resource if
        changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notifySwitches")
    def notify_switches(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the teaming policy will notify the broadcast network of a NIC failover, triggering cache updates.
        """
        return pulumi.get(self, "notify_switches")

    @notify_switches.setter
    def notify_switches(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "notify_switches", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostPortGroupPortArgs']]]]:
        """
        A list of ports that currently exist and are used on this port group.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostPortGroupPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="shapingAverageBandwidth")
    def shaping_average_bandwidth(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The average bandwidth in bits per second if traffic shaping is enabled.
        """
        return pulumi.get(self, "shaping_average_bandwidth")

    @shaping_average_bandwidth.setter
    def shaping_average_bandwidth(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "shaping_average_bandwidth", value)

    @property
    @pulumi.getter(name="shapingBurstSize")
    def shaping_burst_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum burst size allowed in bytes if traffic shaping is enabled.
        """
        return pulumi.get(self, "shaping_burst_size")

    @shaping_burst_size.setter
    def shaping_burst_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "shaping_burst_size", value)

    @property
    @pulumi.getter(name="shapingEnabled")
    def shaping_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable traffic shaping on this virtual switch or port group.
        """
        return pulumi.get(self, "shaping_enabled")

    @shaping_enabled.setter
    def shaping_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shaping_enabled", value)

    @property
    @pulumi.getter(name="shapingPeakBandwidth")
    def shaping_peak_bandwidth(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The peak bandwidth during bursts in bits per second if traffic shaping is enabled.
        """
        return pulumi.get(self, "shaping_peak_bandwidth")

    @shaping_peak_bandwidth.setter
    def shaping_peak_bandwidth(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "shaping_peak_bandwidth", value)

    @property
    @pulumi.getter(name="standbyNics")
    def standby_nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of standby network adapters used for failover.
        """
        return pulumi.get(self, "standby_nics")

    @standby_nics.setter
    def standby_nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "standby_nics", value)

    @property
    @pulumi.getter(name="teamingPolicy")
    def teaming_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network adapter teaming policy. Can be one of loadbalance_ip, loadbalance_srcmac, loadbalance_srcid, or
        failover_explicit.
        """
        return pulumi.get(self, "teaming_policy")

    @teaming_policy.setter
    def teaming_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "teaming_policy", value)

    @property
    @pulumi.getter(name="virtualSwitchName")
    def virtual_switch_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the virtual switch to bind
        this port group to. Forces a new resource if changed.
        """
        return pulumi.get(self, "virtual_switch_name")

    @virtual_switch_name.setter
    def virtual_switch_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "virtual_switch_name", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The VLAN ID/trunk mode for this port group.  An ID of
        `0` denotes no tagging, an ID of `1`-`4094` tags with the specific ID, and an
        ID of `4095` enables trunk mode, allowing the guest to manage its own
        tagging. Default: `0`.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vlan_id", value)


@pulumi.type_token("vsphere:index/hostPortGroup:HostPortGroup")
class HostPortGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_nics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allow_forged_transmits: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_mac_changes: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_promiscuous: Optional[pulumi.Input[builtins.bool]] = None,
                 check_beacon: Optional[pulumi.Input[builtins.bool]] = None,
                 failback: Optional[pulumi.Input[builtins.bool]] = None,
                 host_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notify_switches: Optional[pulumi.Input[builtins.bool]] = None,
                 shaping_average_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
                 shaping_burst_size: Optional[pulumi.Input[builtins.int]] = None,
                 shaping_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 shaping_peak_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
                 standby_nics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 teaming_policy: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_switch_name: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        The `HostPortGroup` resource can be used to manage port groups on
        ESXi hosts. These port groups are connected to standard switches, which
        can be managed by the `HostVirtualSwitch`
        resource.

        For an overview on vSphere networking concepts, see [the product documentation][ref-vsphere-net-concepts].

        [ref-vsphere-net-concepts]: https://techdocs.broadcom.com/us/en/vmware-cis/vsphere/vsphere/8-0/vsphere-networking-8-0/introduction-to-vsphere-networking.html

        ## Example Usage

        **Create a Virtual Switch and Bind a Port Group:**

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        host = vsphere.get_host(name="esxi-01.example.com",
            datacenter_id=datacenter.id)
        host_virtual_switch = vsphere.HostVirtualSwitch("host_virtual_switch",
            name="switch-01",
            host_system_id=host.id,
            network_adapters=[
                "vmnic0",
                "vmnic1",
            ],
            active_nics=["vmnic0"],
            standby_nics=["vmnic1"])
        pg = vsphere.HostPortGroup("pg",
            name="portgroup-01",
            host_system_id=host.id,
            virtual_switch_name=host_virtual_switch.name)
        ```

        **Create a Port Group with a VLAN and ab Override:**

        This example sets the trunk mode VLAN (`4095`, which passes through all tags)
        and sets
        `allow_promiscuous`
        to ensure that all traffic is seen on the port. The setting overrides
        the implicit default of `false` set on the standard switch.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        host = vsphere.get_host(name="esxi-01.example.com",
            datacenter_id=datacenter.id)
        host_virtual_switch = vsphere.HostVirtualSwitch("host_virtual_switch",
            name="switch-01",
            host_system_id=host.id,
            network_adapters=[
                "vmnic0",
                "vmnic1",
            ],
            active_nics=["vmnic0"],
            standby_nics=["vmnic1"])
        pg = vsphere.HostPortGroup("pg",
            name="portgroup-01",
            host_system_id=host.id,
            virtual_switch_name=host_virtual_switch.name,
            vlan_id=4095,
            allow_promiscuous=True)
        ```

        ## Import

        An existing host port group can be imported into this resource

        using the host port group's ID. An example is below:

        ```sh
        $ pulumi import vsphere:index/hostPortGroup:HostPortGroup management tf-HostPortGroup:host-123:management
        ```

        The above would import the `management` host port group from host with ID `host-123`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] active_nics: List of active network adapters used for load balancing.
        :param pulumi.Input[builtins.bool] allow_forged_transmits: Controls whether or not the virtual network adapter is allowed to send network traffic with a different MAC address than
               that of its own.
        :param pulumi.Input[builtins.bool] allow_mac_changes: Controls whether or not the Media Access Control (MAC) address can be changed.
        :param pulumi.Input[builtins.bool] allow_promiscuous: Enable promiscuous mode on the network. This flag indicates whether or not all traffic is seen on a given port.
        :param pulumi.Input[builtins.bool] check_beacon: Enable beacon probing. Requires that the vSwitch has been configured to use a beacon. If disabled, link status is used
               only.
        :param pulumi.Input[builtins.bool] failback: If true, the teaming policy will re-activate failed interfaces higher in precedence when they come back up.
        :param pulumi.Input[builtins.str] host_system_id: The managed object ID of
               the host to set the port group up on. Forces a new resource if changed.
        :param pulumi.Input[builtins.str] name: The name of the port group.  Forces a new resource if
               changed.
        :param pulumi.Input[builtins.bool] notify_switches: If true, the teaming policy will notify the broadcast network of a NIC failover, triggering cache updates.
        :param pulumi.Input[builtins.int] shaping_average_bandwidth: The average bandwidth in bits per second if traffic shaping is enabled.
        :param pulumi.Input[builtins.int] shaping_burst_size: The maximum burst size allowed in bytes if traffic shaping is enabled.
        :param pulumi.Input[builtins.bool] shaping_enabled: Enable traffic shaping on this virtual switch or port group.
        :param pulumi.Input[builtins.int] shaping_peak_bandwidth: The peak bandwidth during bursts in bits per second if traffic shaping is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] standby_nics: List of standby network adapters used for failover.
        :param pulumi.Input[builtins.str] teaming_policy: The network adapter teaming policy. Can be one of loadbalance_ip, loadbalance_srcmac, loadbalance_srcid, or
               failover_explicit.
        :param pulumi.Input[builtins.str] virtual_switch_name: The name of the virtual switch to bind
               this port group to. Forces a new resource if changed.
        :param pulumi.Input[builtins.int] vlan_id: The VLAN ID/trunk mode for this port group.  An ID of
               `0` denotes no tagging, an ID of `1`-`4094` tags with the specific ID, and an
               ID of `4095` enables trunk mode, allowing the guest to manage its own
               tagging. Default: `0`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostPortGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `HostPortGroup` resource can be used to manage port groups on
        ESXi hosts. These port groups are connected to standard switches, which
        can be managed by the `HostVirtualSwitch`
        resource.

        For an overview on vSphere networking concepts, see [the product documentation][ref-vsphere-net-concepts].

        [ref-vsphere-net-concepts]: https://techdocs.broadcom.com/us/en/vmware-cis/vsphere/vsphere/8-0/vsphere-networking-8-0/introduction-to-vsphere-networking.html

        ## Example Usage

        **Create a Virtual Switch and Bind a Port Group:**

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        host = vsphere.get_host(name="esxi-01.example.com",
            datacenter_id=datacenter.id)
        host_virtual_switch = vsphere.HostVirtualSwitch("host_virtual_switch",
            name="switch-01",
            host_system_id=host.id,
            network_adapters=[
                "vmnic0",
                "vmnic1",
            ],
            active_nics=["vmnic0"],
            standby_nics=["vmnic1"])
        pg = vsphere.HostPortGroup("pg",
            name="portgroup-01",
            host_system_id=host.id,
            virtual_switch_name=host_virtual_switch.name)
        ```

        **Create a Port Group with a VLAN and ab Override:**

        This example sets the trunk mode VLAN (`4095`, which passes through all tags)
        and sets
        `allow_promiscuous`
        to ensure that all traffic is seen on the port. The setting overrides
        the implicit default of `false` set on the standard switch.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        host = vsphere.get_host(name="esxi-01.example.com",
            datacenter_id=datacenter.id)
        host_virtual_switch = vsphere.HostVirtualSwitch("host_virtual_switch",
            name="switch-01",
            host_system_id=host.id,
            network_adapters=[
                "vmnic0",
                "vmnic1",
            ],
            active_nics=["vmnic0"],
            standby_nics=["vmnic1"])
        pg = vsphere.HostPortGroup("pg",
            name="portgroup-01",
            host_system_id=host.id,
            virtual_switch_name=host_virtual_switch.name,
            vlan_id=4095,
            allow_promiscuous=True)
        ```

        ## Import

        An existing host port group can be imported into this resource

        using the host port group's ID. An example is below:

        ```sh
        $ pulumi import vsphere:index/hostPortGroup:HostPortGroup management tf-HostPortGroup:host-123:management
        ```

        The above would import the `management` host port group from host with ID `host-123`.

        :param str resource_name: The name of the resource.
        :param HostPortGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostPortGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active_nics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 allow_forged_transmits: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_mac_changes: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_promiscuous: Optional[pulumi.Input[builtins.bool]] = None,
                 check_beacon: Optional[pulumi.Input[builtins.bool]] = None,
                 failback: Optional[pulumi.Input[builtins.bool]] = None,
                 host_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notify_switches: Optional[pulumi.Input[builtins.bool]] = None,
                 shaping_average_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
                 shaping_burst_size: Optional[pulumi.Input[builtins.int]] = None,
                 shaping_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 shaping_peak_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
                 standby_nics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 teaming_policy: Optional[pulumi.Input[builtins.str]] = None,
                 virtual_switch_name: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostPortGroupArgs.__new__(HostPortGroupArgs)

            __props__.__dict__["active_nics"] = active_nics
            __props__.__dict__["allow_forged_transmits"] = allow_forged_transmits
            __props__.__dict__["allow_mac_changes"] = allow_mac_changes
            __props__.__dict__["allow_promiscuous"] = allow_promiscuous
            __props__.__dict__["check_beacon"] = check_beacon
            __props__.__dict__["failback"] = failback
            if host_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_system_id'")
            __props__.__dict__["host_system_id"] = host_system_id
            __props__.__dict__["name"] = name
            __props__.__dict__["notify_switches"] = notify_switches
            __props__.__dict__["shaping_average_bandwidth"] = shaping_average_bandwidth
            __props__.__dict__["shaping_burst_size"] = shaping_burst_size
            __props__.__dict__["shaping_enabled"] = shaping_enabled
            __props__.__dict__["shaping_peak_bandwidth"] = shaping_peak_bandwidth
            __props__.__dict__["standby_nics"] = standby_nics
            __props__.__dict__["teaming_policy"] = teaming_policy
            if virtual_switch_name is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_switch_name'")
            __props__.__dict__["virtual_switch_name"] = virtual_switch_name
            __props__.__dict__["vlan_id"] = vlan_id
            __props__.__dict__["computed_policy"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["ports"] = None
        super(HostPortGroup, __self__).__init__(
            'vsphere:index/hostPortGroup:HostPortGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_nics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            allow_forged_transmits: Optional[pulumi.Input[builtins.bool]] = None,
            allow_mac_changes: Optional[pulumi.Input[builtins.bool]] = None,
            allow_promiscuous: Optional[pulumi.Input[builtins.bool]] = None,
            check_beacon: Optional[pulumi.Input[builtins.bool]] = None,
            computed_policy: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            failback: Optional[pulumi.Input[builtins.bool]] = None,
            host_system_id: Optional[pulumi.Input[builtins.str]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            notify_switches: Optional[pulumi.Input[builtins.bool]] = None,
            ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HostPortGroupPortArgs', 'HostPortGroupPortArgsDict']]]]] = None,
            shaping_average_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
            shaping_burst_size: Optional[pulumi.Input[builtins.int]] = None,
            shaping_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            shaping_peak_bandwidth: Optional[pulumi.Input[builtins.int]] = None,
            standby_nics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            teaming_policy: Optional[pulumi.Input[builtins.str]] = None,
            virtual_switch_name: Optional[pulumi.Input[builtins.str]] = None,
            vlan_id: Optional[pulumi.Input[builtins.int]] = None) -> 'HostPortGroup':
        """
        Get an existing HostPortGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] active_nics: List of active network adapters used for load balancing.
        :param pulumi.Input[builtins.bool] allow_forged_transmits: Controls whether or not the virtual network adapter is allowed to send network traffic with a different MAC address than
               that of its own.
        :param pulumi.Input[builtins.bool] allow_mac_changes: Controls whether or not the Media Access Control (MAC) address can be changed.
        :param pulumi.Input[builtins.bool] allow_promiscuous: Enable promiscuous mode on the network. This flag indicates whether or not all traffic is seen on a given port.
        :param pulumi.Input[builtins.bool] check_beacon: Enable beacon probing. Requires that the vSwitch has been configured to use a beacon. If disabled, link status is used
               only.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] computed_policy: A map with a full set of the policy
               options computed from defaults and overrides,
               explaining the effective policy for this port group.
        :param pulumi.Input[builtins.bool] failback: If true, the teaming policy will re-activate failed interfaces higher in precedence when they come back up.
        :param pulumi.Input[builtins.str] host_system_id: The managed object ID of
               the host to set the port group up on. Forces a new resource if changed.
        :param pulumi.Input[builtins.str] key: The key for this port group as returned from the vSphere API.
        :param pulumi.Input[builtins.str] name: The name of the port group.  Forces a new resource if
               changed.
        :param pulumi.Input[builtins.bool] notify_switches: If true, the teaming policy will notify the broadcast network of a NIC failover, triggering cache updates.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HostPortGroupPortArgs', 'HostPortGroupPortArgsDict']]]] ports: A list of ports that currently exist and are used on this port group.
        :param pulumi.Input[builtins.int] shaping_average_bandwidth: The average bandwidth in bits per second if traffic shaping is enabled.
        :param pulumi.Input[builtins.int] shaping_burst_size: The maximum burst size allowed in bytes if traffic shaping is enabled.
        :param pulumi.Input[builtins.bool] shaping_enabled: Enable traffic shaping on this virtual switch or port group.
        :param pulumi.Input[builtins.int] shaping_peak_bandwidth: The peak bandwidth during bursts in bits per second if traffic shaping is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] standby_nics: List of standby network adapters used for failover.
        :param pulumi.Input[builtins.str] teaming_policy: The network adapter teaming policy. Can be one of loadbalance_ip, loadbalance_srcmac, loadbalance_srcid, or
               failover_explicit.
        :param pulumi.Input[builtins.str] virtual_switch_name: The name of the virtual switch to bind
               this port group to. Forces a new resource if changed.
        :param pulumi.Input[builtins.int] vlan_id: The VLAN ID/trunk mode for this port group.  An ID of
               `0` denotes no tagging, an ID of `1`-`4094` tags with the specific ID, and an
               ID of `4095` enables trunk mode, allowing the guest to manage its own
               tagging. Default: `0`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostPortGroupState.__new__(_HostPortGroupState)

        __props__.__dict__["active_nics"] = active_nics
        __props__.__dict__["allow_forged_transmits"] = allow_forged_transmits
        __props__.__dict__["allow_mac_changes"] = allow_mac_changes
        __props__.__dict__["allow_promiscuous"] = allow_promiscuous
        __props__.__dict__["check_beacon"] = check_beacon
        __props__.__dict__["computed_policy"] = computed_policy
        __props__.__dict__["failback"] = failback
        __props__.__dict__["host_system_id"] = host_system_id
        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["notify_switches"] = notify_switches
        __props__.__dict__["ports"] = ports
        __props__.__dict__["shaping_average_bandwidth"] = shaping_average_bandwidth
        __props__.__dict__["shaping_burst_size"] = shaping_burst_size
        __props__.__dict__["shaping_enabled"] = shaping_enabled
        __props__.__dict__["shaping_peak_bandwidth"] = shaping_peak_bandwidth
        __props__.__dict__["standby_nics"] = standby_nics
        __props__.__dict__["teaming_policy"] = teaming_policy
        __props__.__dict__["virtual_switch_name"] = virtual_switch_name
        __props__.__dict__["vlan_id"] = vlan_id
        return HostPortGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeNics")
    def active_nics(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of active network adapters used for load balancing.
        """
        return pulumi.get(self, "active_nics")

    @property
    @pulumi.getter(name="allowForgedTransmits")
    def allow_forged_transmits(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Controls whether or not the virtual network adapter is allowed to send network traffic with a different MAC address than
        that of its own.
        """
        return pulumi.get(self, "allow_forged_transmits")

    @property
    @pulumi.getter(name="allowMacChanges")
    def allow_mac_changes(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Controls whether or not the Media Access Control (MAC) address can be changed.
        """
        return pulumi.get(self, "allow_mac_changes")

    @property
    @pulumi.getter(name="allowPromiscuous")
    def allow_promiscuous(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable promiscuous mode on the network. This flag indicates whether or not all traffic is seen on a given port.
        """
        return pulumi.get(self, "allow_promiscuous")

    @property
    @pulumi.getter(name="checkBeacon")
    def check_beacon(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable beacon probing. Requires that the vSwitch has been configured to use a beacon. If disabled, link status is used
        only.
        """
        return pulumi.get(self, "check_beacon")

    @property
    @pulumi.getter(name="computedPolicy")
    def computed_policy(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        A map with a full set of the policy
        options computed from defaults and overrides,
        explaining the effective policy for this port group.
        """
        return pulumi.get(self, "computed_policy")

    @property
    @pulumi.getter
    def failback(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, the teaming policy will re-activate failed interfaces higher in precedence when they come back up.
        """
        return pulumi.get(self, "failback")

    @property
    @pulumi.getter(name="hostSystemId")
    def host_system_id(self) -> pulumi.Output[builtins.str]:
        """
        The managed object ID of
        the host to set the port group up on. Forces a new resource if changed.
        """
        return pulumi.get(self, "host_system_id")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        The key for this port group as returned from the vSphere API.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the port group.  Forces a new resource if
        changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notifySwitches")
    def notify_switches(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, the teaming policy will notify the broadcast network of a NIC failover, triggering cache updates.
        """
        return pulumi.get(self, "notify_switches")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[Sequence['outputs.HostPortGroupPort']]:
        """
        A list of ports that currently exist and are used on this port group.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="shapingAverageBandwidth")
    def shaping_average_bandwidth(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The average bandwidth in bits per second if traffic shaping is enabled.
        """
        return pulumi.get(self, "shaping_average_bandwidth")

    @property
    @pulumi.getter(name="shapingBurstSize")
    def shaping_burst_size(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The maximum burst size allowed in bytes if traffic shaping is enabled.
        """
        return pulumi.get(self, "shaping_burst_size")

    @property
    @pulumi.getter(name="shapingEnabled")
    def shaping_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable traffic shaping on this virtual switch or port group.
        """
        return pulumi.get(self, "shaping_enabled")

    @property
    @pulumi.getter(name="shapingPeakBandwidth")
    def shaping_peak_bandwidth(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The peak bandwidth during bursts in bits per second if traffic shaping is enabled.
        """
        return pulumi.get(self, "shaping_peak_bandwidth")

    @property
    @pulumi.getter(name="standbyNics")
    def standby_nics(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of standby network adapters used for failover.
        """
        return pulumi.get(self, "standby_nics")

    @property
    @pulumi.getter(name="teamingPolicy")
    def teaming_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The network adapter teaming policy. Can be one of loadbalance_ip, loadbalance_srcmac, loadbalance_srcid, or
        failover_explicit.
        """
        return pulumi.get(self, "teaming_policy")

    @property
    @pulumi.getter(name="virtualSwitchName")
    def virtual_switch_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the virtual switch to bind
        this port group to. Forces a new resource if changed.
        """
        return pulumi.get(self, "virtual_switch_name")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The VLAN ID/trunk mode for this port group.  An ID of
        `0` denotes no tagging, an ID of `1`-`4094` tags with the specific ID, and an
        ID of `4095` enables trunk mode, allowing the guest to manage its own
        tagging. Default: `0`.
        """
        return pulumi.get(self, "vlan_id")

