# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VappContainerArgs', 'VappContainer']

@pulumi.input_type
class VappContainerArgs:
    def __init__(__self__, *,
                 parent_resource_pool_id: pulumi.Input[builtins.str],
                 cpu_expandable: Optional[pulumi.Input[builtins.bool]] = None,
                 cpu_limit: Optional[pulumi.Input[builtins.int]] = None,
                 cpu_reservation: Optional[pulumi.Input[builtins.int]] = None,
                 cpu_share_level: Optional[pulumi.Input[builtins.str]] = None,
                 cpu_shares: Optional[pulumi.Input[builtins.int]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 memory_expandable: Optional[pulumi.Input[builtins.bool]] = None,
                 memory_limit: Optional[pulumi.Input[builtins.int]] = None,
                 memory_reservation: Optional[pulumi.Input[builtins.int]] = None,
                 memory_share_level: Optional[pulumi.Input[builtins.str]] = None,
                 memory_shares: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_folder_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a VappContainer resource.
        :param pulumi.Input[builtins.str] parent_resource_pool_id: The managed object ID
               of the parent resource pool. This can be the root resource pool for a cluster
               or standalone host, or a resource pool itself. When moving a vApp container
               from one parent resource pool to another, both must share a common root
               resource pool or the move will fail.
        :param pulumi.Input[builtins.bool] cpu_expandable: Determines if the reservation on a vApp
               container can grow beyond the specified value if the parent resource pool has
               unreserved resources. Default: `true`
        :param pulumi.Input[builtins.int] cpu_limit: The CPU utilization of a vApp container will not
               exceed this limit, even if there are available resources. Set to `-1` for
               unlimited.
               Default: `-1`
        :param pulumi.Input[builtins.int] cpu_reservation: Amount of CPU (MHz) that is guaranteed
               available to the vApp container. Default: `0`
        :param pulumi.Input[builtins.str] cpu_share_level: The CPU allocation level. The level is a
               simplified view of shares. Levels map to a pre-determined set of numeric
               values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
               `low`, `normal`, or `high` are specified values in `cpu_shares` will be
               ignored.  Default: `normal`
        :param pulumi.Input[builtins.int] cpu_shares: The number of shares allocated for CPU. Used to
               determine resource allocation in case of resource contention. If this is set,
               `cpu_share_level` must be `custom`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: A list of custom attributes to set on this resource.
        :param pulumi.Input[builtins.bool] memory_expandable: Determines if the reservation on a vApp
               container can grow beyond the specified value if the parent resource pool has
               unreserved resources. Default: `true`
        :param pulumi.Input[builtins.int] memory_limit: The CPU utilization of a vApp container will not
               exceed this limit, even if there are available resources. Set to `-1` for
               unlimited. Default: `-1`
        :param pulumi.Input[builtins.int] memory_reservation: Amount of CPU (MHz) that is guaranteed
               available to the vApp container. Default: `0`
        :param pulumi.Input[builtins.str] memory_share_level: The CPU allocation level. The level is a
               simplified view of shares. Levels map to a pre-determined set of numeric
               values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
               `low`, `normal`, or `high` are specified values in `memory_shares` will be
               ignored.  Default: `normal`
        :param pulumi.Input[builtins.int] memory_shares: The number of shares allocated for CPU. Used to
               determine resource allocation in case of resource contention. If this is set,
               `memory_share_level` must be `custom`.
        :param pulumi.Input[builtins.str] name: The name of the vApp container.
        :param pulumi.Input[builtins.str] parent_folder_id: The managed object ID of
               the vApp container's parent folder.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource.
        """
        pulumi.set(__self__, "parent_resource_pool_id", parent_resource_pool_id)
        if cpu_expandable is not None:
            pulumi.set(__self__, "cpu_expandable", cpu_expandable)
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if cpu_reservation is not None:
            pulumi.set(__self__, "cpu_reservation", cpu_reservation)
        if cpu_share_level is not None:
            pulumi.set(__self__, "cpu_share_level", cpu_share_level)
        if cpu_shares is not None:
            pulumi.set(__self__, "cpu_shares", cpu_shares)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if memory_expandable is not None:
            pulumi.set(__self__, "memory_expandable", memory_expandable)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if memory_reservation is not None:
            pulumi.set(__self__, "memory_reservation", memory_reservation)
        if memory_share_level is not None:
            pulumi.set(__self__, "memory_share_level", memory_share_level)
        if memory_shares is not None:
            pulumi.set(__self__, "memory_shares", memory_shares)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_folder_id is not None:
            pulumi.set(__self__, "parent_folder_id", parent_folder_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="parentResourcePoolId")
    def parent_resource_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        The managed object ID
        of the parent resource pool. This can be the root resource pool for a cluster
        or standalone host, or a resource pool itself. When moving a vApp container
        from one parent resource pool to another, both must share a common root
        resource pool or the move will fail.
        """
        return pulumi.get(self, "parent_resource_pool_id")

    @parent_resource_pool_id.setter
    def parent_resource_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent_resource_pool_id", value)

    @property
    @pulumi.getter(name="cpuExpandable")
    def cpu_expandable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if the reservation on a vApp
        container can grow beyond the specified value if the parent resource pool has
        unreserved resources. Default: `true`
        """
        return pulumi.get(self, "cpu_expandable")

    @cpu_expandable.setter
    def cpu_expandable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cpu_expandable", value)

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The CPU utilization of a vApp container will not
        exceed this limit, even if there are available resources. Set to `-1` for
        unlimited.
        Default: `-1`
        """
        return pulumi.get(self, "cpu_limit")

    @cpu_limit.setter
    def cpu_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cpu_limit", value)

    @property
    @pulumi.getter(name="cpuReservation")
    def cpu_reservation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of CPU (MHz) that is guaranteed
        available to the vApp container. Default: `0`
        """
        return pulumi.get(self, "cpu_reservation")

    @cpu_reservation.setter
    def cpu_reservation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cpu_reservation", value)

    @property
    @pulumi.getter(name="cpuShareLevel")
    def cpu_share_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CPU allocation level. The level is a
        simplified view of shares. Levels map to a pre-determined set of numeric
        values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
        `low`, `normal`, or `high` are specified values in `cpu_shares` will be
        ignored.  Default: `normal`
        """
        return pulumi.get(self, "cpu_share_level")

    @cpu_share_level.setter
    def cpu_share_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpu_share_level", value)

    @property
    @pulumi.getter(name="cpuShares")
    def cpu_shares(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of shares allocated for CPU. Used to
        determine resource allocation in case of resource contention. If this is set,
        `cpu_share_level` must be `custom`.
        """
        return pulumi.get(self, "cpu_shares")

    @cpu_shares.setter
    def cpu_shares(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cpu_shares", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A list of custom attributes to set on this resource.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="memoryExpandable")
    def memory_expandable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if the reservation on a vApp
        container can grow beyond the specified value if the parent resource pool has
        unreserved resources. Default: `true`
        """
        return pulumi.get(self, "memory_expandable")

    @memory_expandable.setter
    def memory_expandable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "memory_expandable", value)

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The CPU utilization of a vApp container will not
        exceed this limit, even if there are available resources. Set to `-1` for
        unlimited. Default: `-1`
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_limit", value)

    @property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of CPU (MHz) that is guaranteed
        available to the vApp container. Default: `0`
        """
        return pulumi.get(self, "memory_reservation")

    @memory_reservation.setter
    def memory_reservation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_reservation", value)

    @property
    @pulumi.getter(name="memoryShareLevel")
    def memory_share_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CPU allocation level. The level is a
        simplified view of shares. Levels map to a pre-determined set of numeric
        values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
        `low`, `normal`, or `high` are specified values in `memory_shares` will be
        ignored.  Default: `normal`
        """
        return pulumi.get(self, "memory_share_level")

    @memory_share_level.setter
    def memory_share_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "memory_share_level", value)

    @property
    @pulumi.getter(name="memoryShares")
    def memory_shares(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of shares allocated for CPU. Used to
        determine resource allocation in case of resource contention. If this is set,
        `memory_share_level` must be `custom`.
        """
        return pulumi.get(self, "memory_shares")

    @memory_shares.setter
    def memory_shares(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_shares", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the vApp container.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentFolderId")
    def parent_folder_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The managed object ID of
        the vApp container's parent folder.
        """
        return pulumi.get(self, "parent_folder_id")

    @parent_folder_id.setter
    def parent_folder_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_folder_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of any tags to attach to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VappContainerState:
    def __init__(__self__, *,
                 cpu_expandable: Optional[pulumi.Input[builtins.bool]] = None,
                 cpu_limit: Optional[pulumi.Input[builtins.int]] = None,
                 cpu_reservation: Optional[pulumi.Input[builtins.int]] = None,
                 cpu_share_level: Optional[pulumi.Input[builtins.str]] = None,
                 cpu_shares: Optional[pulumi.Input[builtins.int]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 memory_expandable: Optional[pulumi.Input[builtins.bool]] = None,
                 memory_limit: Optional[pulumi.Input[builtins.int]] = None,
                 memory_reservation: Optional[pulumi.Input[builtins.int]] = None,
                 memory_share_level: Optional[pulumi.Input[builtins.str]] = None,
                 memory_shares: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_folder_id: Optional[pulumi.Input[builtins.str]] = None,
                 parent_resource_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering VappContainer resources.
        :param pulumi.Input[builtins.bool] cpu_expandable: Determines if the reservation on a vApp
               container can grow beyond the specified value if the parent resource pool has
               unreserved resources. Default: `true`
        :param pulumi.Input[builtins.int] cpu_limit: The CPU utilization of a vApp container will not
               exceed this limit, even if there are available resources. Set to `-1` for
               unlimited.
               Default: `-1`
        :param pulumi.Input[builtins.int] cpu_reservation: Amount of CPU (MHz) that is guaranteed
               available to the vApp container. Default: `0`
        :param pulumi.Input[builtins.str] cpu_share_level: The CPU allocation level. The level is a
               simplified view of shares. Levels map to a pre-determined set of numeric
               values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
               `low`, `normal`, or `high` are specified values in `cpu_shares` will be
               ignored.  Default: `normal`
        :param pulumi.Input[builtins.int] cpu_shares: The number of shares allocated for CPU. Used to
               determine resource allocation in case of resource contention. If this is set,
               `cpu_share_level` must be `custom`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: A list of custom attributes to set on this resource.
        :param pulumi.Input[builtins.bool] memory_expandable: Determines if the reservation on a vApp
               container can grow beyond the specified value if the parent resource pool has
               unreserved resources. Default: `true`
        :param pulumi.Input[builtins.int] memory_limit: The CPU utilization of a vApp container will not
               exceed this limit, even if there are available resources. Set to `-1` for
               unlimited. Default: `-1`
        :param pulumi.Input[builtins.int] memory_reservation: Amount of CPU (MHz) that is guaranteed
               available to the vApp container. Default: `0`
        :param pulumi.Input[builtins.str] memory_share_level: The CPU allocation level. The level is a
               simplified view of shares. Levels map to a pre-determined set of numeric
               values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
               `low`, `normal`, or `high` are specified values in `memory_shares` will be
               ignored.  Default: `normal`
        :param pulumi.Input[builtins.int] memory_shares: The number of shares allocated for CPU. Used to
               determine resource allocation in case of resource contention. If this is set,
               `memory_share_level` must be `custom`.
        :param pulumi.Input[builtins.str] name: The name of the vApp container.
        :param pulumi.Input[builtins.str] parent_folder_id: The managed object ID of
               the vApp container's parent folder.
        :param pulumi.Input[builtins.str] parent_resource_pool_id: The managed object ID
               of the parent resource pool. This can be the root resource pool for a cluster
               or standalone host, or a resource pool itself. When moving a vApp container
               from one parent resource pool to another, both must share a common root
               resource pool or the move will fail.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource.
        """
        if cpu_expandable is not None:
            pulumi.set(__self__, "cpu_expandable", cpu_expandable)
        if cpu_limit is not None:
            pulumi.set(__self__, "cpu_limit", cpu_limit)
        if cpu_reservation is not None:
            pulumi.set(__self__, "cpu_reservation", cpu_reservation)
        if cpu_share_level is not None:
            pulumi.set(__self__, "cpu_share_level", cpu_share_level)
        if cpu_shares is not None:
            pulumi.set(__self__, "cpu_shares", cpu_shares)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if memory_expandable is not None:
            pulumi.set(__self__, "memory_expandable", memory_expandable)
        if memory_limit is not None:
            pulumi.set(__self__, "memory_limit", memory_limit)
        if memory_reservation is not None:
            pulumi.set(__self__, "memory_reservation", memory_reservation)
        if memory_share_level is not None:
            pulumi.set(__self__, "memory_share_level", memory_share_level)
        if memory_shares is not None:
            pulumi.set(__self__, "memory_shares", memory_shares)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_folder_id is not None:
            pulumi.set(__self__, "parent_folder_id", parent_folder_id)
        if parent_resource_pool_id is not None:
            pulumi.set(__self__, "parent_resource_pool_id", parent_resource_pool_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cpuExpandable")
    def cpu_expandable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if the reservation on a vApp
        container can grow beyond the specified value if the parent resource pool has
        unreserved resources. Default: `true`
        """
        return pulumi.get(self, "cpu_expandable")

    @cpu_expandable.setter
    def cpu_expandable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "cpu_expandable", value)

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The CPU utilization of a vApp container will not
        exceed this limit, even if there are available resources. Set to `-1` for
        unlimited.
        Default: `-1`
        """
        return pulumi.get(self, "cpu_limit")

    @cpu_limit.setter
    def cpu_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cpu_limit", value)

    @property
    @pulumi.getter(name="cpuReservation")
    def cpu_reservation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of CPU (MHz) that is guaranteed
        available to the vApp container. Default: `0`
        """
        return pulumi.get(self, "cpu_reservation")

    @cpu_reservation.setter
    def cpu_reservation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cpu_reservation", value)

    @property
    @pulumi.getter(name="cpuShareLevel")
    def cpu_share_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CPU allocation level. The level is a
        simplified view of shares. Levels map to a pre-determined set of numeric
        values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
        `low`, `normal`, or `high` are specified values in `cpu_shares` will be
        ignored.  Default: `normal`
        """
        return pulumi.get(self, "cpu_share_level")

    @cpu_share_level.setter
    def cpu_share_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpu_share_level", value)

    @property
    @pulumi.getter(name="cpuShares")
    def cpu_shares(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of shares allocated for CPU. Used to
        determine resource allocation in case of resource contention. If this is set,
        `cpu_share_level` must be `custom`.
        """
        return pulumi.get(self, "cpu_shares")

    @cpu_shares.setter
    def cpu_shares(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cpu_shares", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A list of custom attributes to set on this resource.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="memoryExpandable")
    def memory_expandable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Determines if the reservation on a vApp
        container can grow beyond the specified value if the parent resource pool has
        unreserved resources. Default: `true`
        """
        return pulumi.get(self, "memory_expandable")

    @memory_expandable.setter
    def memory_expandable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "memory_expandable", value)

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The CPU utilization of a vApp container will not
        exceed this limit, even if there are available resources. Set to `-1` for
        unlimited. Default: `-1`
        """
        return pulumi.get(self, "memory_limit")

    @memory_limit.setter
    def memory_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_limit", value)

    @property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Amount of CPU (MHz) that is guaranteed
        available to the vApp container. Default: `0`
        """
        return pulumi.get(self, "memory_reservation")

    @memory_reservation.setter
    def memory_reservation(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_reservation", value)

    @property
    @pulumi.getter(name="memoryShareLevel")
    def memory_share_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CPU allocation level. The level is a
        simplified view of shares. Levels map to a pre-determined set of numeric
        values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
        `low`, `normal`, or `high` are specified values in `memory_shares` will be
        ignored.  Default: `normal`
        """
        return pulumi.get(self, "memory_share_level")

    @memory_share_level.setter
    def memory_share_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "memory_share_level", value)

    @property
    @pulumi.getter(name="memoryShares")
    def memory_shares(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of shares allocated for CPU. Used to
        determine resource allocation in case of resource contention. If this is set,
        `memory_share_level` must be `custom`.
        """
        return pulumi.get(self, "memory_shares")

    @memory_shares.setter
    def memory_shares(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "memory_shares", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the vApp container.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="parentFolderId")
    def parent_folder_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The managed object ID of
        the vApp container's parent folder.
        """
        return pulumi.get(self, "parent_folder_id")

    @parent_folder_id.setter
    def parent_folder_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_folder_id", value)

    @property
    @pulumi.getter(name="parentResourcePoolId")
    def parent_resource_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The managed object ID
        of the parent resource pool. This can be the root resource pool for a cluster
        or standalone host, or a resource pool itself. When moving a vApp container
        from one parent resource pool to another, both must share a common root
        resource pool or the move will fail.
        """
        return pulumi.get(self, "parent_resource_pool_id")

    @parent_resource_pool_id.setter
    def parent_resource_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_resource_pool_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of any tags to attach to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("vsphere:index/vappContainer:VappContainer")
class VappContainer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cpu_expandable: Optional[pulumi.Input[builtins.bool]] = None,
                 cpu_limit: Optional[pulumi.Input[builtins.int]] = None,
                 cpu_reservation: Optional[pulumi.Input[builtins.int]] = None,
                 cpu_share_level: Optional[pulumi.Input[builtins.str]] = None,
                 cpu_shares: Optional[pulumi.Input[builtins.int]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 memory_expandable: Optional[pulumi.Input[builtins.bool]] = None,
                 memory_limit: Optional[pulumi.Input[builtins.int]] = None,
                 memory_reservation: Optional[pulumi.Input[builtins.int]] = None,
                 memory_share_level: Optional[pulumi.Input[builtins.str]] = None,
                 memory_shares: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_folder_id: Optional[pulumi.Input[builtins.str]] = None,
                 parent_resource_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        The `VappContainer` resource can be used to create and manage
        vApps.

        For more information on vSphere vApps, see the VMware vSphere [product documentation][ref-vsphere-vapp].

        [ref-vsphere-vapp]: https://techdocs.broadcom.com/us/en/vmware-cis/vsphere/vsphere/8-0/vsphere-virtual-machine-administration-guide-8-0/managing-multi-tiered-applications-with-vsphere-vapp-in-the-vsphere-web-clientvsphere-vm-admin.html

        ## Basic Example

        The example below sets up a vSphere vApp container in a compute cluster which uses
        the default settings for CPU and memory reservations, shares, and limits. The compute cluster
        needs to already exist in vSphere.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        compute_cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        vapp_container = vsphere.VappContainer("vapp_container",
            name="vapp-01",
            parent_resource_pool_id=compute_cluster.resource_pool_id)
        ```

        ### Example with a Virtual Machine

        The example below builds off the basic example, but includes a virtual machine
        in the new vApp container. To accomplish this, the `resource_pool_id` of the
        virtual machine is set to the `id` of the vApp container.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        compute_cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        datastore = vsphere.get_datastore(name="datastore-01",
            datacenter_id=datacenter.id)
        network = vsphere.get_network(name="VM Network",
            datacenter_id=datacenter.id)
        vapp_container = vsphere.VappContainer("vapp_container",
            name="vapp-01",
            parent_resource_pool_id=compute_cluster.resource_pool_id)
        vm = vsphere.VirtualMachine("vm",
            name="foo",
            resource_pool_id=vapp_container_vsphere_vapp_container["id"],
            datastore_id=datastore.id,
            num_cpus=1,
            memory=1024,
            guest_id="ubuntu64Guest",
            network_interfaces=[{
                "network_id": network.id,
            }],
            disks=[{
                "label": "disk0",
                "size": 20,
            }])
        ```

        ## Import

        An existing vApp container can be imported into this resource via

        the path to the vApp container, using the following command:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        Example:

        ```sh
        $ pulumi import vsphere:index/vappContainer:VappContainer vapp_container /dc-01/host/cluster-01/Resources/resource-pool-01/vapp-01
        ```

        The example above would import the vApp container named `vapp-01` that is

        located in the resource pool `resource-pool-01` that is part of the host cluster

        `cluster-01` in the `dc-01` datacenter.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] cpu_expandable: Determines if the reservation on a vApp
               container can grow beyond the specified value if the parent resource pool has
               unreserved resources. Default: `true`
        :param pulumi.Input[builtins.int] cpu_limit: The CPU utilization of a vApp container will not
               exceed this limit, even if there are available resources. Set to `-1` for
               unlimited.
               Default: `-1`
        :param pulumi.Input[builtins.int] cpu_reservation: Amount of CPU (MHz) that is guaranteed
               available to the vApp container. Default: `0`
        :param pulumi.Input[builtins.str] cpu_share_level: The CPU allocation level. The level is a
               simplified view of shares. Levels map to a pre-determined set of numeric
               values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
               `low`, `normal`, or `high` are specified values in `cpu_shares` will be
               ignored.  Default: `normal`
        :param pulumi.Input[builtins.int] cpu_shares: The number of shares allocated for CPU. Used to
               determine resource allocation in case of resource contention. If this is set,
               `cpu_share_level` must be `custom`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: A list of custom attributes to set on this resource.
        :param pulumi.Input[builtins.bool] memory_expandable: Determines if the reservation on a vApp
               container can grow beyond the specified value if the parent resource pool has
               unreserved resources. Default: `true`
        :param pulumi.Input[builtins.int] memory_limit: The CPU utilization of a vApp container will not
               exceed this limit, even if there are available resources. Set to `-1` for
               unlimited. Default: `-1`
        :param pulumi.Input[builtins.int] memory_reservation: Amount of CPU (MHz) that is guaranteed
               available to the vApp container. Default: `0`
        :param pulumi.Input[builtins.str] memory_share_level: The CPU allocation level. The level is a
               simplified view of shares. Levels map to a pre-determined set of numeric
               values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
               `low`, `normal`, or `high` are specified values in `memory_shares` will be
               ignored.  Default: `normal`
        :param pulumi.Input[builtins.int] memory_shares: The number of shares allocated for CPU. Used to
               determine resource allocation in case of resource contention. If this is set,
               `memory_share_level` must be `custom`.
        :param pulumi.Input[builtins.str] name: The name of the vApp container.
        :param pulumi.Input[builtins.str] parent_folder_id: The managed object ID of
               the vApp container's parent folder.
        :param pulumi.Input[builtins.str] parent_resource_pool_id: The managed object ID
               of the parent resource pool. This can be the root resource pool for a cluster
               or standalone host, or a resource pool itself. When moving a vApp container
               from one parent resource pool to another, both must share a common root
               resource pool or the move will fail.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VappContainerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `VappContainer` resource can be used to create and manage
        vApps.

        For more information on vSphere vApps, see the VMware vSphere [product documentation][ref-vsphere-vapp].

        [ref-vsphere-vapp]: https://techdocs.broadcom.com/us/en/vmware-cis/vsphere/vsphere/8-0/vsphere-virtual-machine-administration-guide-8-0/managing-multi-tiered-applications-with-vsphere-vapp-in-the-vsphere-web-clientvsphere-vm-admin.html

        ## Basic Example

        The example below sets up a vSphere vApp container in a compute cluster which uses
        the default settings for CPU and memory reservations, shares, and limits. The compute cluster
        needs to already exist in vSphere.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        compute_cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        vapp_container = vsphere.VappContainer("vapp_container",
            name="vapp-01",
            parent_resource_pool_id=compute_cluster.resource_pool_id)
        ```

        ### Example with a Virtual Machine

        The example below builds off the basic example, but includes a virtual machine
        in the new vApp container. To accomplish this, the `resource_pool_id` of the
        virtual machine is set to the `id` of the vApp container.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        compute_cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        datastore = vsphere.get_datastore(name="datastore-01",
            datacenter_id=datacenter.id)
        network = vsphere.get_network(name="VM Network",
            datacenter_id=datacenter.id)
        vapp_container = vsphere.VappContainer("vapp_container",
            name="vapp-01",
            parent_resource_pool_id=compute_cluster.resource_pool_id)
        vm = vsphere.VirtualMachine("vm",
            name="foo",
            resource_pool_id=vapp_container_vsphere_vapp_container["id"],
            datastore_id=datastore.id,
            num_cpus=1,
            memory=1024,
            guest_id="ubuntu64Guest",
            network_interfaces=[{
                "network_id": network.id,
            }],
            disks=[{
                "label": "disk0",
                "size": 20,
            }])
        ```

        ## Import

        An existing vApp container can be imported into this resource via

        the path to the vApp container, using the following command:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        Example:

        ```sh
        $ pulumi import vsphere:index/vappContainer:VappContainer vapp_container /dc-01/host/cluster-01/Resources/resource-pool-01/vapp-01
        ```

        The example above would import the vApp container named `vapp-01` that is

        located in the resource pool `resource-pool-01` that is part of the host cluster

        `cluster-01` in the `dc-01` datacenter.

        :param str resource_name: The name of the resource.
        :param VappContainerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VappContainerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cpu_expandable: Optional[pulumi.Input[builtins.bool]] = None,
                 cpu_limit: Optional[pulumi.Input[builtins.int]] = None,
                 cpu_reservation: Optional[pulumi.Input[builtins.int]] = None,
                 cpu_share_level: Optional[pulumi.Input[builtins.str]] = None,
                 cpu_shares: Optional[pulumi.Input[builtins.int]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 memory_expandable: Optional[pulumi.Input[builtins.bool]] = None,
                 memory_limit: Optional[pulumi.Input[builtins.int]] = None,
                 memory_reservation: Optional[pulumi.Input[builtins.int]] = None,
                 memory_share_level: Optional[pulumi.Input[builtins.str]] = None,
                 memory_shares: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent_folder_id: Optional[pulumi.Input[builtins.str]] = None,
                 parent_resource_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VappContainerArgs.__new__(VappContainerArgs)

            __props__.__dict__["cpu_expandable"] = cpu_expandable
            __props__.__dict__["cpu_limit"] = cpu_limit
            __props__.__dict__["cpu_reservation"] = cpu_reservation
            __props__.__dict__["cpu_share_level"] = cpu_share_level
            __props__.__dict__["cpu_shares"] = cpu_shares
            __props__.__dict__["custom_attributes"] = custom_attributes
            __props__.__dict__["memory_expandable"] = memory_expandable
            __props__.__dict__["memory_limit"] = memory_limit
            __props__.__dict__["memory_reservation"] = memory_reservation
            __props__.__dict__["memory_share_level"] = memory_share_level
            __props__.__dict__["memory_shares"] = memory_shares
            __props__.__dict__["name"] = name
            __props__.__dict__["parent_folder_id"] = parent_folder_id
            if parent_resource_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'parent_resource_pool_id'")
            __props__.__dict__["parent_resource_pool_id"] = parent_resource_pool_id
            __props__.__dict__["tags"] = tags
        super(VappContainer, __self__).__init__(
            'vsphere:index/vappContainer:VappContainer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cpu_expandable: Optional[pulumi.Input[builtins.bool]] = None,
            cpu_limit: Optional[pulumi.Input[builtins.int]] = None,
            cpu_reservation: Optional[pulumi.Input[builtins.int]] = None,
            cpu_share_level: Optional[pulumi.Input[builtins.str]] = None,
            cpu_shares: Optional[pulumi.Input[builtins.int]] = None,
            custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            memory_expandable: Optional[pulumi.Input[builtins.bool]] = None,
            memory_limit: Optional[pulumi.Input[builtins.int]] = None,
            memory_reservation: Optional[pulumi.Input[builtins.int]] = None,
            memory_share_level: Optional[pulumi.Input[builtins.str]] = None,
            memory_shares: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent_folder_id: Optional[pulumi.Input[builtins.str]] = None,
            parent_resource_pool_id: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'VappContainer':
        """
        Get an existing VappContainer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] cpu_expandable: Determines if the reservation on a vApp
               container can grow beyond the specified value if the parent resource pool has
               unreserved resources. Default: `true`
        :param pulumi.Input[builtins.int] cpu_limit: The CPU utilization of a vApp container will not
               exceed this limit, even if there are available resources. Set to `-1` for
               unlimited.
               Default: `-1`
        :param pulumi.Input[builtins.int] cpu_reservation: Amount of CPU (MHz) that is guaranteed
               available to the vApp container. Default: `0`
        :param pulumi.Input[builtins.str] cpu_share_level: The CPU allocation level. The level is a
               simplified view of shares. Levels map to a pre-determined set of numeric
               values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
               `low`, `normal`, or `high` are specified values in `cpu_shares` will be
               ignored.  Default: `normal`
        :param pulumi.Input[builtins.int] cpu_shares: The number of shares allocated for CPU. Used to
               determine resource allocation in case of resource contention. If this is set,
               `cpu_share_level` must be `custom`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: A list of custom attributes to set on this resource.
        :param pulumi.Input[builtins.bool] memory_expandable: Determines if the reservation on a vApp
               container can grow beyond the specified value if the parent resource pool has
               unreserved resources. Default: `true`
        :param pulumi.Input[builtins.int] memory_limit: The CPU utilization of a vApp container will not
               exceed this limit, even if there are available resources. Set to `-1` for
               unlimited. Default: `-1`
        :param pulumi.Input[builtins.int] memory_reservation: Amount of CPU (MHz) that is guaranteed
               available to the vApp container. Default: `0`
        :param pulumi.Input[builtins.str] memory_share_level: The CPU allocation level. The level is a
               simplified view of shares. Levels map to a pre-determined set of numeric
               values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
               `low`, `normal`, or `high` are specified values in `memory_shares` will be
               ignored.  Default: `normal`
        :param pulumi.Input[builtins.int] memory_shares: The number of shares allocated for CPU. Used to
               determine resource allocation in case of resource contention. If this is set,
               `memory_share_level` must be `custom`.
        :param pulumi.Input[builtins.str] name: The name of the vApp container.
        :param pulumi.Input[builtins.str] parent_folder_id: The managed object ID of
               the vApp container's parent folder.
        :param pulumi.Input[builtins.str] parent_resource_pool_id: The managed object ID
               of the parent resource pool. This can be the root resource pool for a cluster
               or standalone host, or a resource pool itself. When moving a vApp container
               from one parent resource pool to another, both must share a common root
               resource pool or the move will fail.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VappContainerState.__new__(_VappContainerState)

        __props__.__dict__["cpu_expandable"] = cpu_expandable
        __props__.__dict__["cpu_limit"] = cpu_limit
        __props__.__dict__["cpu_reservation"] = cpu_reservation
        __props__.__dict__["cpu_share_level"] = cpu_share_level
        __props__.__dict__["cpu_shares"] = cpu_shares
        __props__.__dict__["custom_attributes"] = custom_attributes
        __props__.__dict__["memory_expandable"] = memory_expandable
        __props__.__dict__["memory_limit"] = memory_limit
        __props__.__dict__["memory_reservation"] = memory_reservation
        __props__.__dict__["memory_share_level"] = memory_share_level
        __props__.__dict__["memory_shares"] = memory_shares
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_folder_id"] = parent_folder_id
        __props__.__dict__["parent_resource_pool_id"] = parent_resource_pool_id
        __props__.__dict__["tags"] = tags
        return VappContainer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cpuExpandable")
    def cpu_expandable(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Determines if the reservation on a vApp
        container can grow beyond the specified value if the parent resource pool has
        unreserved resources. Default: `true`
        """
        return pulumi.get(self, "cpu_expandable")

    @property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The CPU utilization of a vApp container will not
        exceed this limit, even if there are available resources. Set to `-1` for
        unlimited.
        Default: `-1`
        """
        return pulumi.get(self, "cpu_limit")

    @property
    @pulumi.getter(name="cpuReservation")
    def cpu_reservation(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Amount of CPU (MHz) that is guaranteed
        available to the vApp container. Default: `0`
        """
        return pulumi.get(self, "cpu_reservation")

    @property
    @pulumi.getter(name="cpuShareLevel")
    def cpu_share_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The CPU allocation level. The level is a
        simplified view of shares. Levels map to a pre-determined set of numeric
        values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
        `low`, `normal`, or `high` are specified values in `cpu_shares` will be
        ignored.  Default: `normal`
        """
        return pulumi.get(self, "cpu_share_level")

    @property
    @pulumi.getter(name="cpuShares")
    def cpu_shares(self) -> pulumi.Output[builtins.int]:
        """
        The number of shares allocated for CPU. Used to
        determine resource allocation in case of resource contention. If this is set,
        `cpu_share_level` must be `custom`.
        """
        return pulumi.get(self, "cpu_shares")

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A list of custom attributes to set on this resource.
        """
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="memoryExpandable")
    def memory_expandable(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Determines if the reservation on a vApp
        container can grow beyond the specified value if the parent resource pool has
        unreserved resources. Default: `true`
        """
        return pulumi.get(self, "memory_expandable")

    @property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The CPU utilization of a vApp container will not
        exceed this limit, even if there are available resources. Set to `-1` for
        unlimited. Default: `-1`
        """
        return pulumi.get(self, "memory_limit")

    @property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Amount of CPU (MHz) that is guaranteed
        available to the vApp container. Default: `0`
        """
        return pulumi.get(self, "memory_reservation")

    @property
    @pulumi.getter(name="memoryShareLevel")
    def memory_share_level(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The CPU allocation level. The level is a
        simplified view of shares. Levels map to a pre-determined set of numeric
        values for shares. Can be one of `low`, `normal`, `high`, or `custom`. When
        `low`, `normal`, or `high` are specified values in `memory_shares` will be
        ignored.  Default: `normal`
        """
        return pulumi.get(self, "memory_share_level")

    @property
    @pulumi.getter(name="memoryShares")
    def memory_shares(self) -> pulumi.Output[builtins.int]:
        """
        The number of shares allocated for CPU. Used to
        determine resource allocation in case of resource contention. If this is set,
        `memory_share_level` must be `custom`.
        """
        return pulumi.get(self, "memory_shares")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the vApp container.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentFolderId")
    def parent_folder_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The managed object ID of
        the vApp container's parent folder.
        """
        return pulumi.get(self, "parent_folder_id")

    @property
    @pulumi.getter(name="parentResourcePoolId")
    def parent_resource_pool_id(self) -> pulumi.Output[builtins.str]:
        """
        The managed object ID
        of the parent resource pool. This can be the root resource pool for a cluster
        or standalone host, or a resource pool itself. When moving a vApp container
        from one parent resource pool to another, both must share a common root
        resource pool or the move will fail.
        """
        return pulumi.get(self, "parent_resource_pool_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The IDs of any tags to attach to this resource.
        """
        return pulumi.get(self, "tags")

