# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VmfsDatastoreArgs', 'VmfsDatastore']

@pulumi.input_type
class VmfsDatastoreArgs:
    def __init__(__self__, *,
                 disks: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 host_system_id: pulumi.Input[builtins.str],
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datastore_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a VmfsDatastore resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] disks: The disks to use with the datastore.
        :param pulumi.Input[builtins.str] host_system_id: The managed object ID of
               the host to set the datastore up on. Note that this is not necessarily the
               only host that the datastore will be set up on - see
               here for more info. Forces a
               new resource if changed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: Map of custom attribute ids to attribute 
               value string to set on datastore resource.
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[builtins.str] datastore_cluster_id: The managed object
               ID of a datastore cluster to put this datastore in.
               Conflicts with `folder`.
        :param pulumi.Input[builtins.str] folder: The relative path to a folder to put this datastore in.
               This is a path relative to the datacenter you are deploying the datastore to.
               Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
               The provider will place a datastore named `test` in a datastore folder
               located at `/dc1/datastore/foo/bar`, with the final inventory path being
               `/dc1/datastore/foo/bar/test`. Conflicts with
               `datastore_cluster_id`.
        :param pulumi.Input[builtins.str] name: The name of the datastore. Forces a new resource if
               changed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource. 
               
               > **NOTE:** Tagging support is unsupported on direct ESXi connections and
               requires vCenter 6.0 or higher.
        """
        pulumi.set(__self__, "disks", disks)
        pulumi.set(__self__, "host_system_id", host_system_id)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if datastore_cluster_id is not None:
            pulumi.set(__self__, "datastore_cluster_id", datastore_cluster_id)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def disks(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The disks to use with the datastore.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter(name="hostSystemId")
    def host_system_id(self) -> pulumi.Input[builtins.str]:
        """
        The managed object ID of
        the host to set the datastore up on. Note that this is not necessarily the
        only host that the datastore will be set up on - see
        here for more info. Forces a
        new resource if changed.
        """
        return pulumi.get(self, "host_system_id")

    @host_system_id.setter
    def host_system_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host_system_id", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of custom attribute ids to attribute 
        value string to set on datastore resource.

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="datastoreClusterId")
    def datastore_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The managed object
        ID of a datastore cluster to put this datastore in.
        Conflicts with `folder`.
        """
        return pulumi.get(self, "datastore_cluster_id")

    @datastore_cluster_id.setter
    def datastore_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "datastore_cluster_id", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative path to a folder to put this datastore in.
        This is a path relative to the datacenter you are deploying the datastore to.
        Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
        The provider will place a datastore named `test` in a datastore folder
        located at `/dc1/datastore/foo/bar`, with the final inventory path being
        `/dc1/datastore/foo/bar/test`. Conflicts with
        `datastore_cluster_id`.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the datastore. Forces a new resource if
        changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of any tags to attach to this resource. 

        > **NOTE:** Tagging support is unsupported on direct ESXi connections and
        requires vCenter 6.0 or higher.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VmfsDatastoreState:
    def __init__(__self__, *,
                 accessible: Optional[pulumi.Input[builtins.bool]] = None,
                 capacity: Optional[pulumi.Input[builtins.int]] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datastore_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 free_space: Optional[pulumi.Input[builtins.int]] = None,
                 host_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_mode: Optional[pulumi.Input[builtins.str]] = None,
                 multiple_host_access: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 uncommitted_space: Optional[pulumi.Input[builtins.int]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering VmfsDatastore resources.
        :param pulumi.Input[builtins.bool] accessible: The connectivity status of the datastore. If this is `false`,
               some other computed attributes may be out of date.
        :param pulumi.Input[builtins.int] capacity: Maximum capacity of the datastore, in megabytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: Map of custom attribute ids to attribute 
               value string to set on datastore resource.
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[builtins.str] datastore_cluster_id: The managed object
               ID of a datastore cluster to put this datastore in.
               Conflicts with `folder`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] disks: The disks to use with the datastore.
        :param pulumi.Input[builtins.str] folder: The relative path to a folder to put this datastore in.
               This is a path relative to the datacenter you are deploying the datastore to.
               Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
               The provider will place a datastore named `test` in a datastore folder
               located at `/dc1/datastore/foo/bar`, with the final inventory path being
               `/dc1/datastore/foo/bar/test`. Conflicts with
               `datastore_cluster_id`.
        :param pulumi.Input[builtins.int] free_space: Available space of this datastore, in megabytes.
        :param pulumi.Input[builtins.str] host_system_id: The managed object ID of
               the host to set the datastore up on. Note that this is not necessarily the
               only host that the datastore will be set up on - see
               here for more info. Forces a
               new resource if changed.
        :param pulumi.Input[builtins.str] maintenance_mode: The current maintenance mode state of the datastore.
        :param pulumi.Input[builtins.bool] multiple_host_access: If `true`, more than one host in the datacenter has
               been configured with access to the datastore.
        :param pulumi.Input[builtins.str] name: The name of the datastore. Forces a new resource if
               changed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource. 
               
               > **NOTE:** Tagging support is unsupported on direct ESXi connections and
               requires vCenter 6.0 or higher.
        :param pulumi.Input[builtins.int] uncommitted_space: Total additional storage space, in megabytes,
               potentially used by all virtual machines on this datastore.
        :param pulumi.Input[builtins.str] url: The unique locator for the datastore.
        """
        if accessible is not None:
            pulumi.set(__self__, "accessible", accessible)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if custom_attributes is not None:
            pulumi.set(__self__, "custom_attributes", custom_attributes)
        if datastore_cluster_id is not None:
            pulumi.set(__self__, "datastore_cluster_id", datastore_cluster_id)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if free_space is not None:
            pulumi.set(__self__, "free_space", free_space)
        if host_system_id is not None:
            pulumi.set(__self__, "host_system_id", host_system_id)
        if maintenance_mode is not None:
            pulumi.set(__self__, "maintenance_mode", maintenance_mode)
        if multiple_host_access is not None:
            pulumi.set(__self__, "multiple_host_access", multiple_host_access)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if uncommitted_space is not None:
            pulumi.set(__self__, "uncommitted_space", uncommitted_space)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def accessible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The connectivity status of the datastore. If this is `false`,
        some other computed attributes may be out of date.
        """
        return pulumi.get(self, "accessible")

    @accessible.setter
    def accessible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "accessible", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Maximum capacity of the datastore, in megabytes.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of custom attribute ids to attribute 
        value string to set on datastore resource.

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter.
        """
        return pulumi.get(self, "custom_attributes")

    @custom_attributes.setter
    def custom_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "custom_attributes", value)

    @property
    @pulumi.getter(name="datastoreClusterId")
    def datastore_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The managed object
        ID of a datastore cluster to put this datastore in.
        Conflicts with `folder`.
        """
        return pulumi.get(self, "datastore_cluster_id")

    @datastore_cluster_id.setter
    def datastore_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "datastore_cluster_id", value)

    @property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The disks to use with the datastore.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative path to a folder to put this datastore in.
        This is a path relative to the datacenter you are deploying the datastore to.
        Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
        The provider will place a datastore named `test` in a datastore folder
        located at `/dc1/datastore/foo/bar`, with the final inventory path being
        `/dc1/datastore/foo/bar/test`. Conflicts with
        `datastore_cluster_id`.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "folder", value)

    @property
    @pulumi.getter(name="freeSpace")
    def free_space(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Available space of this datastore, in megabytes.
        """
        return pulumi.get(self, "free_space")

    @free_space.setter
    def free_space(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "free_space", value)

    @property
    @pulumi.getter(name="hostSystemId")
    def host_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The managed object ID of
        the host to set the datastore up on. Note that this is not necessarily the
        only host that the datastore will be set up on - see
        here for more info. Forces a
        new resource if changed.
        """
        return pulumi.get(self, "host_system_id")

    @host_system_id.setter
    def host_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_system_id", value)

    @property
    @pulumi.getter(name="maintenanceMode")
    def maintenance_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current maintenance mode state of the datastore.
        """
        return pulumi.get(self, "maintenance_mode")

    @maintenance_mode.setter
    def maintenance_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maintenance_mode", value)

    @property
    @pulumi.getter(name="multipleHostAccess")
    def multiple_host_access(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If `true`, more than one host in the datacenter has
        been configured with access to the datastore.
        """
        return pulumi.get(self, "multiple_host_access")

    @multiple_host_access.setter
    def multiple_host_access(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multiple_host_access", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the datastore. Forces a new resource if
        changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The IDs of any tags to attach to this resource. 

        > **NOTE:** Tagging support is unsupported on direct ESXi connections and
        requires vCenter 6.0 or higher.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="uncommittedSpace")
    def uncommitted_space(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total additional storage space, in megabytes,
        potentially used by all virtual machines on this datastore.
        """
        return pulumi.get(self, "uncommitted_space")

    @uncommitted_space.setter
    def uncommitted_space(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "uncommitted_space", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique locator for the datastore.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("vsphere:index/vmfsDatastore:VmfsDatastore")
class VmfsDatastore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datastore_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 host_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        The `VmfsDatastore` resource can be used to create and manage VMFS
        datastores on an ESXi host or a set of hosts. The resource supports using any
        SCSI device that can generally be used in a datastore, such as local disks, or
        disks presented to a host or multiple hosts over Fibre Channel or iSCSI.
        Devices can be specified manually, or discovered using the
        [`get_vmfs_disks`][data-source-vmfs-disks] data source.

        [data-source-vmfs-disks]: /docs/providers/vsphere/d/vmfs_disks.html

        ## Auto-Mounting of Datastores Within vCenter

        Note that the current behavior of this resource will auto-mount any created
        datastores to any other host within vCenter that has access to the same disk.

        Example: You want to create a datastore with a iSCSI LUN that is visible on 3
        hosts in a single vSphere cluster (`esxi1`, `esxi2` and `esxi3`). When you
        create the datastore on `esxi1`, the datastore will be automatically mounted on
        `esxi2` and `esxi3`, without the need to configure the resource on either of
        those two hosts.

        Future versions of this resource may allow you to control the hosts that a
        datastore is mounted to, but currently, this automatic behavior cannot be
        changed, so keep this in mind when writing your configurations and deploying
        your disks.

        ## Increasing Datastore Size

        To increase the size of a datastore, you must add additional disks to the
        `disks` attribute. Expanding the size of a datastore by increasing the size of
        an already provisioned disk is currently not supported (but may be in future
        versions of this resource).

        > **NOTE:** You cannot decrease the size of a datastore. If the resource
        detects disks removed from the configuration, the provider will give an error.

        [cmd-taint]: /docs/commands/taint.html

        ## Example Usage

        ### Addition of local disks on a single host

        The following example uses the default datacenter and default host to add a
        datastore with local disks to a single ESXi server.

        > **NOTE:** There are some situations where datastore creation will not work
        when working through vCenter (usually when trying to create a datastore on a
        single host with local disks). If you experience trouble creating the datastore
        you need through vCenter, break the datastore off into a different configuration
        and deploy it using the ESXi server as the provider endpoint, using a similar
        configuration to what is below.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter()
        host = vsphere.get_host(datacenter_id=datacenter.id)
        datastore = vsphere.VmfsDatastore("datastore",
            name="test",
            host_system_id=esxi_host["id"],
            disks=[
                "mpx.vmhba1:C0:T1:L0",
                "mpx.vmhba1:C0:T2:L0",
                "mpx.vmhba1:C0:T2:L0",
            ])
        ```

        ### Auto-detection of disks via `get_vmfs_disks`

        The following example makes use of the
        `get_vmfs_disks` data source to auto-detect
        exported iSCSI LUNS matching a certain NAA vendor ID (in this case, LUNs
        exported from a [NetApp][ext-netapp]). These discovered disks are then loaded
        into `VmfsDatastore`. The datastore is also placed in the
        `datastore-folder` folder afterwards.

        [ext-netapp]: https://kb.netapp.com/support/s/article/ka31A0000000rLRQAY/how-to-match-a-lun-s-naa-number-to-its-serial-number?language=en_US

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        host = vsphere.get_host(name="esxi-01.example.com",
            datacenter_id=datacenter.id)
        available = vsphere.get_vmfs_disks(host_system_id=host.id,
            rescan=True,
            filter="naa.60a98000")
        datastore = vsphere.VmfsDatastore("datastore",
            name="test",
            host_system_id=esxi_host["id"],
            folder="datastore-folder",
            disks=[available.disks])
        ```

        ## Import

        An existing VMFS datastore can be imported into this resource

        via its managed object ID, via the command below. You also need the host system

        ID.

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/vmfsDatastore:VmfsDatastore datastore datastore-123:host-10
        ```

        You need a tool like [`govc`][ext-govc] that can display managed object IDs.

        [ext-govc]: https://github.com/vmware/govmomi/tree/master/govc

        In the case of govc, you can locate a managed object ID from an inventory path

        by doing the following:

        $ govc ls -i /dc/datastore/terraform-test

        Datastore:datastore-123

        To locate host IDs, it might be a good idea to supply the `-l` flag as well so

        that you can line up the names with the IDs:

        $ govc ls -l -i /dc/host/cluster1

        ResourcePool:resgroup-10 /dc/host/cluster1/Resources

        HostSystem:host-10 /dc/host/cluster1/esxi1

        HostSystem:host-11 /dc/host/cluster1/esxi2

        HostSystem:host-12 /dc/host/cluster1/esxi3

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: Map of custom attribute ids to attribute 
               value string to set on datastore resource.
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[builtins.str] datastore_cluster_id: The managed object
               ID of a datastore cluster to put this datastore in.
               Conflicts with `folder`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] disks: The disks to use with the datastore.
        :param pulumi.Input[builtins.str] folder: The relative path to a folder to put this datastore in.
               This is a path relative to the datacenter you are deploying the datastore to.
               Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
               The provider will place a datastore named `test` in a datastore folder
               located at `/dc1/datastore/foo/bar`, with the final inventory path being
               `/dc1/datastore/foo/bar/test`. Conflicts with
               `datastore_cluster_id`.
        :param pulumi.Input[builtins.str] host_system_id: The managed object ID of
               the host to set the datastore up on. Note that this is not necessarily the
               only host that the datastore will be set up on - see
               here for more info. Forces a
               new resource if changed.
        :param pulumi.Input[builtins.str] name: The name of the datastore. Forces a new resource if
               changed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource. 
               
               > **NOTE:** Tagging support is unsupported on direct ESXi connections and
               requires vCenter 6.0 or higher.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VmfsDatastoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `VmfsDatastore` resource can be used to create and manage VMFS
        datastores on an ESXi host or a set of hosts. The resource supports using any
        SCSI device that can generally be used in a datastore, such as local disks, or
        disks presented to a host or multiple hosts over Fibre Channel or iSCSI.
        Devices can be specified manually, or discovered using the
        [`get_vmfs_disks`][data-source-vmfs-disks] data source.

        [data-source-vmfs-disks]: /docs/providers/vsphere/d/vmfs_disks.html

        ## Auto-Mounting of Datastores Within vCenter

        Note that the current behavior of this resource will auto-mount any created
        datastores to any other host within vCenter that has access to the same disk.

        Example: You want to create a datastore with a iSCSI LUN that is visible on 3
        hosts in a single vSphere cluster (`esxi1`, `esxi2` and `esxi3`). When you
        create the datastore on `esxi1`, the datastore will be automatically mounted on
        `esxi2` and `esxi3`, without the need to configure the resource on either of
        those two hosts.

        Future versions of this resource may allow you to control the hosts that a
        datastore is mounted to, but currently, this automatic behavior cannot be
        changed, so keep this in mind when writing your configurations and deploying
        your disks.

        ## Increasing Datastore Size

        To increase the size of a datastore, you must add additional disks to the
        `disks` attribute. Expanding the size of a datastore by increasing the size of
        an already provisioned disk is currently not supported (but may be in future
        versions of this resource).

        > **NOTE:** You cannot decrease the size of a datastore. If the resource
        detects disks removed from the configuration, the provider will give an error.

        [cmd-taint]: /docs/commands/taint.html

        ## Example Usage

        ### Addition of local disks on a single host

        The following example uses the default datacenter and default host to add a
        datastore with local disks to a single ESXi server.

        > **NOTE:** There are some situations where datastore creation will not work
        when working through vCenter (usually when trying to create a datastore on a
        single host with local disks). If you experience trouble creating the datastore
        you need through vCenter, break the datastore off into a different configuration
        and deploy it using the ESXi server as the provider endpoint, using a similar
        configuration to what is below.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter()
        host = vsphere.get_host(datacenter_id=datacenter.id)
        datastore = vsphere.VmfsDatastore("datastore",
            name="test",
            host_system_id=esxi_host["id"],
            disks=[
                "mpx.vmhba1:C0:T1:L0",
                "mpx.vmhba1:C0:T2:L0",
                "mpx.vmhba1:C0:T2:L0",
            ])
        ```

        ### Auto-detection of disks via `get_vmfs_disks`

        The following example makes use of the
        `get_vmfs_disks` data source to auto-detect
        exported iSCSI LUNS matching a certain NAA vendor ID (in this case, LUNs
        exported from a [NetApp][ext-netapp]). These discovered disks are then loaded
        into `VmfsDatastore`. The datastore is also placed in the
        `datastore-folder` folder afterwards.

        [ext-netapp]: https://kb.netapp.com/support/s/article/ka31A0000000rLRQAY/how-to-match-a-lun-s-naa-number-to-its-serial-number?language=en_US

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        host = vsphere.get_host(name="esxi-01.example.com",
            datacenter_id=datacenter.id)
        available = vsphere.get_vmfs_disks(host_system_id=host.id,
            rescan=True,
            filter="naa.60a98000")
        datastore = vsphere.VmfsDatastore("datastore",
            name="test",
            host_system_id=esxi_host["id"],
            folder="datastore-folder",
            disks=[available.disks])
        ```

        ## Import

        An existing VMFS datastore can be imported into this resource

        via its managed object ID, via the command below. You also need the host system

        ID.

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/vmfsDatastore:VmfsDatastore datastore datastore-123:host-10
        ```

        You need a tool like [`govc`][ext-govc] that can display managed object IDs.

        [ext-govc]: https://github.com/vmware/govmomi/tree/master/govc

        In the case of govc, you can locate a managed object ID from an inventory path

        by doing the following:

        $ govc ls -i /dc/datastore/terraform-test

        Datastore:datastore-123

        To locate host IDs, it might be a good idea to supply the `-l` flag as well so

        that you can line up the names with the IDs:

        $ govc ls -l -i /dc/host/cluster1

        ResourcePool:resgroup-10 /dc/host/cluster1/Resources

        HostSystem:host-10 /dc/host/cluster1/esxi1

        HostSystem:host-11 /dc/host/cluster1/esxi2

        HostSystem:host-12 /dc/host/cluster1/esxi3

        :param str resource_name: The name of the resource.
        :param VmfsDatastoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VmfsDatastoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 datastore_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 folder: Optional[pulumi.Input[builtins.str]] = None,
                 host_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VmfsDatastoreArgs.__new__(VmfsDatastoreArgs)

            __props__.__dict__["custom_attributes"] = custom_attributes
            __props__.__dict__["datastore_cluster_id"] = datastore_cluster_id
            if disks is None and not opts.urn:
                raise TypeError("Missing required property 'disks'")
            __props__.__dict__["disks"] = disks
            __props__.__dict__["folder"] = folder
            if host_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'host_system_id'")
            __props__.__dict__["host_system_id"] = host_system_id
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["accessible"] = None
            __props__.__dict__["capacity"] = None
            __props__.__dict__["free_space"] = None
            __props__.__dict__["maintenance_mode"] = None
            __props__.__dict__["multiple_host_access"] = None
            __props__.__dict__["uncommitted_space"] = None
            __props__.__dict__["url"] = None
        super(VmfsDatastore, __self__).__init__(
            'vsphere:index/vmfsDatastore:VmfsDatastore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessible: Optional[pulumi.Input[builtins.bool]] = None,
            capacity: Optional[pulumi.Input[builtins.int]] = None,
            custom_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            datastore_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            disks: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            folder: Optional[pulumi.Input[builtins.str]] = None,
            free_space: Optional[pulumi.Input[builtins.int]] = None,
            host_system_id: Optional[pulumi.Input[builtins.str]] = None,
            maintenance_mode: Optional[pulumi.Input[builtins.str]] = None,
            multiple_host_access: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            uncommitted_space: Optional[pulumi.Input[builtins.int]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None) -> 'VmfsDatastore':
        """
        Get an existing VmfsDatastore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] accessible: The connectivity status of the datastore. If this is `false`,
               some other computed attributes may be out of date.
        :param pulumi.Input[builtins.int] capacity: Maximum capacity of the datastore, in megabytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] custom_attributes: Map of custom attribute ids to attribute 
               value string to set on datastore resource.
               
               > **NOTE:** Custom attributes are unsupported on direct ESXi connections
               and require vCenter.
        :param pulumi.Input[builtins.str] datastore_cluster_id: The managed object
               ID of a datastore cluster to put this datastore in.
               Conflicts with `folder`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] disks: The disks to use with the datastore.
        :param pulumi.Input[builtins.str] folder: The relative path to a folder to put this datastore in.
               This is a path relative to the datacenter you are deploying the datastore to.
               Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
               The provider will place a datastore named `test` in a datastore folder
               located at `/dc1/datastore/foo/bar`, with the final inventory path being
               `/dc1/datastore/foo/bar/test`. Conflicts with
               `datastore_cluster_id`.
        :param pulumi.Input[builtins.int] free_space: Available space of this datastore, in megabytes.
        :param pulumi.Input[builtins.str] host_system_id: The managed object ID of
               the host to set the datastore up on. Note that this is not necessarily the
               only host that the datastore will be set up on - see
               here for more info. Forces a
               new resource if changed.
        :param pulumi.Input[builtins.str] maintenance_mode: The current maintenance mode state of the datastore.
        :param pulumi.Input[builtins.bool] multiple_host_access: If `true`, more than one host in the datacenter has
               been configured with access to the datastore.
        :param pulumi.Input[builtins.str] name: The name of the datastore. Forces a new resource if
               changed.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The IDs of any tags to attach to this resource. 
               
               > **NOTE:** Tagging support is unsupported on direct ESXi connections and
               requires vCenter 6.0 or higher.
        :param pulumi.Input[builtins.int] uncommitted_space: Total additional storage space, in megabytes,
               potentially used by all virtual machines on this datastore.
        :param pulumi.Input[builtins.str] url: The unique locator for the datastore.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VmfsDatastoreState.__new__(_VmfsDatastoreState)

        __props__.__dict__["accessible"] = accessible
        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["custom_attributes"] = custom_attributes
        __props__.__dict__["datastore_cluster_id"] = datastore_cluster_id
        __props__.__dict__["disks"] = disks
        __props__.__dict__["folder"] = folder
        __props__.__dict__["free_space"] = free_space
        __props__.__dict__["host_system_id"] = host_system_id
        __props__.__dict__["maintenance_mode"] = maintenance_mode
        __props__.__dict__["multiple_host_access"] = multiple_host_access
        __props__.__dict__["name"] = name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["uncommitted_space"] = uncommitted_space
        __props__.__dict__["url"] = url
        return VmfsDatastore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accessible(self) -> pulumi.Output[builtins.bool]:
        """
        The connectivity status of the datastore. If this is `false`,
        some other computed attributes may be out of date.
        """
        return pulumi.get(self, "accessible")

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output[builtins.int]:
        """
        Maximum capacity of the datastore, in megabytes.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="customAttributes")
    def custom_attributes(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Map of custom attribute ids to attribute 
        value string to set on datastore resource.

        > **NOTE:** Custom attributes are unsupported on direct ESXi connections
        and require vCenter.
        """
        return pulumi.get(self, "custom_attributes")

    @property
    @pulumi.getter(name="datastoreClusterId")
    def datastore_cluster_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The managed object
        ID of a datastore cluster to put this datastore in.
        Conflicts with `folder`.
        """
        return pulumi.get(self, "datastore_cluster_id")

    @property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The disks to use with the datastore.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The relative path to a folder to put this datastore in.
        This is a path relative to the datacenter you are deploying the datastore to.
        Example: for the `dc1` datacenter, and a provided `folder` of `foo/bar`,
        The provider will place a datastore named `test` in a datastore folder
        located at `/dc1/datastore/foo/bar`, with the final inventory path being
        `/dc1/datastore/foo/bar/test`. Conflicts with
        `datastore_cluster_id`.
        """
        return pulumi.get(self, "folder")

    @property
    @pulumi.getter(name="freeSpace")
    def free_space(self) -> pulumi.Output[builtins.int]:
        """
        Available space of this datastore, in megabytes.
        """
        return pulumi.get(self, "free_space")

    @property
    @pulumi.getter(name="hostSystemId")
    def host_system_id(self) -> pulumi.Output[builtins.str]:
        """
        The managed object ID of
        the host to set the datastore up on. Note that this is not necessarily the
        only host that the datastore will be set up on - see
        here for more info. Forces a
        new resource if changed.
        """
        return pulumi.get(self, "host_system_id")

    @property
    @pulumi.getter(name="maintenanceMode")
    def maintenance_mode(self) -> pulumi.Output[builtins.str]:
        """
        The current maintenance mode state of the datastore.
        """
        return pulumi.get(self, "maintenance_mode")

    @property
    @pulumi.getter(name="multipleHostAccess")
    def multiple_host_access(self) -> pulumi.Output[builtins.bool]:
        """
        If `true`, more than one host in the datacenter has
        been configured with access to the datastore.
        """
        return pulumi.get(self, "multiple_host_access")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the datastore. Forces a new resource if
        changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The IDs of any tags to attach to this resource. 

        > **NOTE:** Tagging support is unsupported on direct ESXi connections and
        requires vCenter 6.0 or higher.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="uncommittedSpace")
    def uncommitted_space(self) -> pulumi.Output[builtins.int]:
        """
        Total additional storage space, in megabytes,
        potentially used by all virtual machines on this datastore.
        """
        return pulumi.get(self, "uncommitted_space")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        The unique locator for the datastore.
        """
        return pulumi.get(self, "url")

