# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNgwafVirtualPatchesResult',
    'AwaitableGetNgwafVirtualPatchesResult',
    'get_ngwaf_virtual_patches',
    'get_ngwaf_virtual_patches_output',
]

@pulumi.output_type
class GetNgwafVirtualPatchesResult:
    """
    A collection of values returned by getNgwafVirtualPatches.
    """
    def __init__(__self__, id=None, virtual_patches=None, workspace_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if virtual_patches and not isinstance(virtual_patches, list):
            raise TypeError("Expected argument 'virtual_patches' to be a list")
        pulumi.set(__self__, "virtual_patches", virtual_patches)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="virtualPatches")
    def virtual_patches(self) -> Sequence['outputs.GetNgwafVirtualPatchesVirtualPatchResult']:
        """
        List of all virtual patches for a given workspace.
        """
        return pulumi.get(self, "virtual_patches")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> _builtins.str:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")


class AwaitableGetNgwafVirtualPatchesResult(GetNgwafVirtualPatchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNgwafVirtualPatchesResult(
            id=self.id,
            virtual_patches=self.virtual_patches,
            workspace_id=self.workspace_id)


def get_ngwaf_virtual_patches(workspace_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNgwafVirtualPatchesResult:
    """
    Use this data source to get a list of [Fastly Next-Gen WAF Virtual Patches][1] for a given workspace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    list_patches = fastly.get_ngwaf_virtual_patches(workspace_id=test_virtual_patches_workspace["id"])
    pulumi.export("fastlyNgwafVirtualPatchesAll", list_patches)
    ```

    [1]: https://www.fastly.com/documentation/reference/api/ngwaf/virtual-patches/


    :param _builtins.str workspace_id: The ID of the workspace.
    """
    __args__ = dict()
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('fastly:index/getNgwafVirtualPatches:getNgwafVirtualPatches', __args__, opts=opts, typ=GetNgwafVirtualPatchesResult).value

    return AwaitableGetNgwafVirtualPatchesResult(
        id=pulumi.get(__ret__, 'id'),
        virtual_patches=pulumi.get(__ret__, 'virtual_patches'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_ngwaf_virtual_patches_output(workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNgwafVirtualPatchesResult]:
    """
    Use this data source to get a list of [Fastly Next-Gen WAF Virtual Patches][1] for a given workspace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    list_patches = fastly.get_ngwaf_virtual_patches(workspace_id=test_virtual_patches_workspace["id"])
    pulumi.export("fastlyNgwafVirtualPatchesAll", list_patches)
    ```

    [1]: https://www.fastly.com/documentation/reference/api/ngwaf/virtual-patches/


    :param _builtins.str workspace_id: The ID of the workspace.
    """
    __args__ = dict()
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('fastly:index/getNgwafVirtualPatches:getNgwafVirtualPatches', __args__, opts=opts, typ=GetNgwafVirtualPatchesResult)
    return __ret__.apply(lambda __response__: GetNgwafVirtualPatchesResult(
        id=pulumi.get(__response__, 'id'),
        virtual_patches=pulumi.get(__response__, 'virtual_patches'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
