# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServiceDictionaryItemsArgs', 'ServiceDictionaryItems']

@pulumi.input_type
class ServiceDictionaryItemsArgs:
    def __init__(__self__, *,
                 dictionary_id: pulumi.Input[_builtins.str],
                 service_id: pulumi.Input[_builtins.str],
                 items: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 manage_items: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ServiceDictionaryItems resource.
        :param pulumi.Input[_builtins.str] dictionary_id: The ID of the dictionary that the items belong to
        :param pulumi.Input[_builtins.str] service_id: The ID of the service that the dictionary belongs to
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] items: A map representing an entry in the dictionary, (key/value)
        :param pulumi.Input[_builtins.bool] manage_items: Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        """
        pulumi.set(__self__, "dictionary_id", dictionary_id)
        pulumi.set(__self__, "service_id", service_id)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if manage_items is not None:
            pulumi.set(__self__, "manage_items", manage_items)

    @_builtins.property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the dictionary that the items belong to
        """
        return pulumi.get(self, "dictionary_id")

    @dictionary_id.setter
    def dictionary_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dictionary_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the service that the dictionary belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_id", value)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map representing an entry in the dictionary, (key/value)
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "items", value)

    @_builtins.property
    @pulumi.getter(name="manageItems")
    def manage_items(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        """
        return pulumi.get(self, "manage_items")

    @manage_items.setter
    def manage_items(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "manage_items", value)


@pulumi.input_type
class _ServiceDictionaryItemsState:
    def __init__(__self__, *,
                 dictionary_id: Optional[pulumi.Input[_builtins.str]] = None,
                 items: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 manage_items: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceDictionaryItems resources.
        :param pulumi.Input[_builtins.str] dictionary_id: The ID of the dictionary that the items belong to
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] items: A map representing an entry in the dictionary, (key/value)
        :param pulumi.Input[_builtins.bool] manage_items: Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        :param pulumi.Input[_builtins.str] service_id: The ID of the service that the dictionary belongs to
        """
        if dictionary_id is not None:
            pulumi.set(__self__, "dictionary_id", dictionary_id)
        if items is not None:
            pulumi.set(__self__, "items", items)
        if manage_items is not None:
            pulumi.set(__self__, "manage_items", manage_items)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)

    @_builtins.property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dictionary that the items belong to
        """
        return pulumi.get(self, "dictionary_id")

    @dictionary_id.setter
    def dictionary_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dictionary_id", value)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map representing an entry in the dictionary, (key/value)
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "items", value)

    @_builtins.property
    @pulumi.getter(name="manageItems")
    def manage_items(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        """
        return pulumi.get(self, "manage_items")

    @manage_items.setter
    def manage_items(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "manage_items", value)

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the service that the dictionary belongs to
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_id", value)


@pulumi.type_token("fastly:index/serviceDictionaryItems:ServiceDictionaryItems")
class ServiceDictionaryItems(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dictionary_id: Optional[pulumi.Input[_builtins.str]] = None,
                 items: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 manage_items: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_dictionary_items.items`

        The resource ID is a combined value of the `service_id` and `dictionary_id` separated by a forward slash.

        ```sh
        $ pulumi import fastly:index/serviceDictionaryItems:ServiceDictionaryItems items xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

        If Terraform is already managing remote dictionary items against a resource being imported then the user will be asked to remove it from the existing Terraform state.

        The following is an example of the Terraform state command to remove the resource named `fastly_service_dictionary_items.items` from the Terraform state file.

        $ terraform state rm fastly_service_dictionary_items.items

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dictionary_id: The ID of the dictionary that the items belong to
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] items: A map representing an entry in the dictionary, (key/value)
        :param pulumi.Input[_builtins.bool] manage_items: Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        :param pulumi.Input[_builtins.str] service_id: The ID of the service that the dictionary belongs to
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceDictionaryItemsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_dictionary_items.items`

        The resource ID is a combined value of the `service_id` and `dictionary_id` separated by a forward slash.

        ```sh
        $ pulumi import fastly:index/serviceDictionaryItems:ServiceDictionaryItems items xxxxxxxxxxxxxxxxxxxx/xxxxxxxxxxxxxxxxxxxx
        ```

        If Terraform is already managing remote dictionary items against a resource being imported then the user will be asked to remove it from the existing Terraform state.

        The following is an example of the Terraform state command to remove the resource named `fastly_service_dictionary_items.items` from the Terraform state file.

        $ terraform state rm fastly_service_dictionary_items.items

        :param str resource_name: The name of the resource.
        :param ServiceDictionaryItemsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceDictionaryItemsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dictionary_id: Optional[pulumi.Input[_builtins.str]] = None,
                 items: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 manage_items: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceDictionaryItemsArgs.__new__(ServiceDictionaryItemsArgs)

            if dictionary_id is None and not opts.urn:
                raise TypeError("Missing required property 'dictionary_id'")
            __props__.__dict__["dictionary_id"] = dictionary_id
            __props__.__dict__["items"] = items
            __props__.__dict__["manage_items"] = manage_items
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
        super(ServiceDictionaryItems, __self__).__init__(
            'fastly:index/serviceDictionaryItems:ServiceDictionaryItems',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dictionary_id: Optional[pulumi.Input[_builtins.str]] = None,
            items: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            manage_items: Optional[pulumi.Input[_builtins.bool]] = None,
            service_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceDictionaryItems':
        """
        Get an existing ServiceDictionaryItems resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dictionary_id: The ID of the dictionary that the items belong to
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] items: A map representing an entry in the dictionary, (key/value)
        :param pulumi.Input[_builtins.bool] manage_items: Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        :param pulumi.Input[_builtins.str] service_id: The ID of the service that the dictionary belongs to
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceDictionaryItemsState.__new__(_ServiceDictionaryItemsState)

        __props__.__dict__["dictionary_id"] = dictionary_id
        __props__.__dict__["items"] = items
        __props__.__dict__["manage_items"] = manage_items
        __props__.__dict__["service_id"] = service_id
        return ServiceDictionaryItems(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dictionary that the items belong to
        """
        return pulumi.get(self, "dictionary_id")

    @_builtins.property
    @pulumi.getter
    def items(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map representing an entry in the dictionary, (key/value)
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter(name="manageItems")
    def manage_items(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to reapply changes if the state of the items drifts, i.e. if items are managed externally
        """
        return pulumi.get(self, "manage_items")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the service that the dictionary belongs to
        """
        return pulumi.get(self, "service_id")

