<p align="center">
    <b>
        <h1 align="center">📊 VizPool 📊</h1>
    </b>
</p>
<p align="center">
    <em>A Python Library Having Low-Code Support for Basic to Advance Static & Interactive Data Visualization</em>
</p>

<p align="center">
    <a href="https://pypi.org/project/vizpool">
        <img alt="PyPI Version" src="https://img.shields.io/pypi/v/vizpool?color=g">
    </a>
    <a href="https://pypi.org/project/vizpool">
        <img alt="Python Version" src="https://img.shields.io/pypi/pyversions/vizpool?color=g">
    </a>
    <a href="https://pepy.tech/project/vizpool">
        <img alt="Downloads" src="https://static.pepy.tech/personalized-badge/vizpool?period=total&units=international_system&left_color=grey&right_color=brightgreen&left_text=Downloads">
    </a>
    <a href="https://github.com/hassi34/vizpool">
        <img alt="Last Commit" src="https://img.shields.io/github/last-commit/hassi34/vizpool/main?color=g">
    </a>
    <a href="https://github.com/Hassi34/vizpool/blob/main/LICENSE">
        <img alt="License" src="https://img.shields.io/github/license/hassi34/vizpool?color=g">
    </a>
    <a href="https://github.com/hassi34/vizpool/issues">
        <img alt="Issue Tracking" src="https://img.shields.io/badge/issue_tracking-github-brightgreen.svg">
    </a>
    <a href="https://github.com/hassi34/vizpool/issues">
        <img alt="Open Issues" src="https://img.shields.io/github/issues/hassi34/vizpool">
    </a>
    <a href="https://pypi.org/project/vizpool">
        <img alt="Github Actions Status" src="https://img.shields.io/github/actions/workflow/status/hassi34/vizpool/cicd.yml?branch=main">
    </a>
    <a href="https://pypi.org/project/vizpool">
        <img alt="Code Size" src="https://img.shields.io/github/languages/code-size/hassi34/vizpool?color=g">
    </a>
    <a href="https://pypi.org/project/vizpool">
        <img alt="Repo Size" src="https://img.shields.io/github/repo-size/hassi34/vizpool?color=g">
    </a>
</p>

## Overview
VizPool enables you to create impressive static and interactive visuals with just one line of code while also providing the higher standards of customization. You will be introduced to a number of class methods to choose from. You can call these methods with specific keyword or positional arguments to generate amazing static and interactive visuals.<br>
Following are the major contents to follow, you can jump to any section:

>   1. [Installation](#install-)
>   2. [Usage](#use-)
>   3. [Getting Started with VizPool (Tutorials)](#tutorials-)
>   4. [Contributing](#contributing-)
### 🔗 Project Link
**``VizPool``** is being distributed through PyPI. Check out the PyPI Package [here](https://pypi.org/project/vizpool/)


### Installation<a id='install-'></a>
Install via Pip!
```bash
pip install vizpool
```
### Usage<a id='use-'></a>
Import the components and use it like any other python package
* Static Visuals
```bash
from vizpool.static import EDA
from vizpool.static import Evaluation
```
* Interactive Visuals
```bash
from vizpool.interactive import EDA
```
### Quickstart<a id='tutorials-'></a>

* Ensure you have [Python 3.7+](https://www.python.org/downloads/) installed.

* Create a new Python conda environment for the vizpool:

```
$ conda create -n venv  # create venv
$ conda activate venv  # activate venv
$ pip install vizpool # install vizpool
```

* Create a new Python virtual environment with pip for the vizpool:
```
$ python3 -m venv venv  # create venv
$ . venv/bin/activate   # activate venv
$ pip install vizpool # install vizpool
```
👉 PLease follow the links below to get the complete interactive tutorials on **getting stated with VizPool**:<br>
    1)- [VizPool Static API](https://jovian.ai/hasnainmehmood3435/vizpool-static-api)<br>
    2)- [VizPool Interactive API](https://jovian.ai/hasnainmehmood3435/vizpool-interactive-api)<br><br>
👉 PDF versions of the tutorials are available at the following links:<br>
    1)- [VizPool Static API](https://github.com/Hassi34/vizpool/blob/master/vizpool-static-api.pdf)<br>
    2)- [VizPool Interactive API](https://github.com/Hassi34/vizpool/blob/master/vizpool-interactive-api.pdf)<br>
### Contributing<a id='contributing-'></a>
Yes, Please!  We believe that there is alot of oportunity to make even the most complex visuals available for data comunity, so let's make it more efficient, let's go with low-code!!

#### **Please give this repository a star if you find our work useful, Thank you! 🙏**<br><br>

**Copyright &copy; 2022 VizPool** <br>
Let's connect on **[``LinkedIn``](https://www.linkedin.com/in/hasanain-mehmood-a37a4116b/)** <br>

