# Zlogger Python Client

Ein einfacher und effizienter Python-Client für den Zlogger Service.

## Installation

```bash
pip install zlogger
```

## Schnellstart

```python
from zlogger import ZloggerClient

# Client initialisieren
logger = ZloggerClient(
    endpoint="https://zlogger.ch/api/logs",
    api_key="your-api-key",
    app_name="my-app"
)

# Logs senden
logger.info("Application started", {"version": "1.0.0"})
logger.warn("High memory usage", {"memory": "90%"})
logger.error("Database connection failed", {"db": "primary"})
logger.debug("Processing user request", {"user_id": 123})
```

## API

### ZloggerClient(endpoint, api_key, app_name)

Erstellt einen neuen Zlogger-Client.

**Parameter:**
- `endpoint` (str): Zlogger API Endpoint
- `api_key` (str): Ihr Zlogger API-Schlüssel
- `app_name` (str): Name Ihrer Anwendung

### Log-Methoden

Alle Log-Methoden akzeptieren:
- `message` (str): Die Log-Nachricht
- `context` (dict, optional): Zusätzliche Kontext-Daten

**Verfügbare Methoden:**
- `logger.debug(message, context=None)`
- `logger.info(message, context=None)`
- `logger.warn(message, context=None)`
- `logger.error(message, context=None)`

## Beispiel mit Kontext

```python
logger.error("Payment failed", {
    "transaction_id": "txn_123",
    "amount": 99.99,
    "currency": "USD",
    "error_code": "INSUFFICIENT_FUNDS"
})
```

## Lizenz

MIT License