from numpy import array, float64

SPACE_GROUP_INFO = {
    1: {"bravais_lattice": "aP", "crystal_system": "triclinic", "pointgroup": "1"},
    2: {"bravais_lattice": "aP", "crystal_system": "triclinic", "pointgroup": "-1"},
    3: {"bravais_lattice": "mP", "crystal_system": "monoclinic", "pointgroup": "2"},
    4: {"bravais_lattice": "mP", "crystal_system": "monoclinic", "pointgroup": "2"},
    5: {"bravais_lattice": "mC", "crystal_system": "monoclinic", "pointgroup": "2"},
    6: {"bravais_lattice": "mP", "crystal_system": "monoclinic", "pointgroup": "m"},
    7: {"bravais_lattice": "mP", "crystal_system": "monoclinic", "pointgroup": "m"},
    8: {"bravais_lattice": "mC", "crystal_system": "monoclinic", "pointgroup": "m"},
    9: {"bravais_lattice": "mC", "crystal_system": "monoclinic", "pointgroup": "m"},
    10: {"bravais_lattice": "mP", "crystal_system": "monoclinic", "pointgroup": "2/m"},
    11: {"bravais_lattice": "mP", "crystal_system": "monoclinic", "pointgroup": "2/m"},
    12: {"bravais_lattice": "mC", "crystal_system": "monoclinic", "pointgroup": "2/m"},
    13: {"bravais_lattice": "mP", "crystal_system": "monoclinic", "pointgroup": "2/m"},
    14: {"bravais_lattice": "mP", "crystal_system": "monoclinic", "pointgroup": "2/m"},
    15: {"bravais_lattice": "mC", "crystal_system": "monoclinic", "pointgroup": "2/m"},
    16: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "222",
    },
    17: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "222",
    },
    18: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "222",
    },
    19: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "222",
    },
    20: {
        "bravais_lattice": "oB",
        "crystal_system": "orthorhombic",
        "pointgroup": "222",
    },
    21: {
        "bravais_lattice": "oB",
        "crystal_system": "orthorhombic",
        "pointgroup": "222",
    },
    22: {
        "bravais_lattice": "oF",
        "crystal_system": "orthorhombic",
        "pointgroup": "222",
    },
    23: {
        "bravais_lattice": "oI",
        "crystal_system": "orthorhombic",
        "pointgroup": "222",
    },
    24: {
        "bravais_lattice": "oI",
        "crystal_system": "orthorhombic",
        "pointgroup": "222",
    },
    25: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    26: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    27: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    28: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    29: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    30: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    31: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    32: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    33: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    34: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    35: {
        "bravais_lattice": "oB",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    36: {
        "bravais_lattice": "oB",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    37: {
        "bravais_lattice": "oB",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    38: {
        "bravais_lattice": "oA",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    39: {
        "bravais_lattice": "oA",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    40: {
        "bravais_lattice": "oA",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    41: {
        "bravais_lattice": "oA",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    42: {
        "bravais_lattice": "oF",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    43: {
        "bravais_lattice": "oF",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    44: {
        "bravais_lattice": "oI",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    45: {
        "bravais_lattice": "oI",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    46: {
        "bravais_lattice": "oI",
        "crystal_system": "orthorhombic",
        "pointgroup": "mm2",
    },
    47: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    48: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    49: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    50: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    51: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    52: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    53: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    54: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    55: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    56: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    57: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    58: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    59: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    60: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    61: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    62: {
        "bravais_lattice": "oP",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    63: {
        "bravais_lattice": "oB",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    64: {
        "bravais_lattice": "oB",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    65: {
        "bravais_lattice": "oB",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    66: {
        "bravais_lattice": "oB",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    67: {
        "bravais_lattice": "oB",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    68: {
        "bravais_lattice": "oB",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    69: {
        "bravais_lattice": "oF",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    70: {
        "bravais_lattice": "oF",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    71: {
        "bravais_lattice": "oI",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    72: {
        "bravais_lattice": "oI",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    73: {
        "bravais_lattice": "oI",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    74: {
        "bravais_lattice": "oI",
        "crystal_system": "orthorhombic",
        "pointgroup": "mmm",
    },
    75: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4"},
    76: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4"},
    77: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4"},
    78: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4"},
    79: {"bravais_lattice": "tI", "crystal_system": "tetragonal", "pointgroup": "4"},
    80: {"bravais_lattice": "tI", "crystal_system": "tetragonal", "pointgroup": "4"},
    81: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "-4"},
    82: {"bravais_lattice": "tI", "crystal_system": "tetragonal", "pointgroup": "-4"},
    83: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4/m"},
    84: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4/m"},
    85: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4/m"},
    86: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4/m"},
    87: {"bravais_lattice": "tI", "crystal_system": "tetragonal", "pointgroup": "4/m"},
    88: {"bravais_lattice": "tI", "crystal_system": "tetragonal", "pointgroup": "4/m"},
    89: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "422"},
    90: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "422"},
    91: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "422"},
    92: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "422"},
    93: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "422"},
    94: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "422"},
    95: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "422"},
    96: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "422"},
    97: {"bravais_lattice": "tI", "crystal_system": "tetragonal", "pointgroup": "422"},
    98: {"bravais_lattice": "tI", "crystal_system": "tetragonal", "pointgroup": "422"},
    99: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4mm"},
    100: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4mm"},
    101: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4mm"},
    102: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4mm"},
    103: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4mm"},
    104: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4mm"},
    105: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4mm"},
    106: {"bravais_lattice": "tP", "crystal_system": "tetragonal", "pointgroup": "4mm"},
    107: {"bravais_lattice": "tI", "crystal_system": "tetragonal", "pointgroup": "4mm"},
    108: {"bravais_lattice": "tI", "crystal_system": "tetragonal", "pointgroup": "4mm"},
    109: {"bravais_lattice": "tI", "crystal_system": "tetragonal", "pointgroup": "4mm"},
    110: {"bravais_lattice": "tI", "crystal_system": "tetragonal", "pointgroup": "4mm"},
    111: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "-42m",
    },
    112: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "-42m",
    },
    113: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "-42m",
    },
    114: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "-42m",
    },
    115: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "-42m",
    },
    116: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "-42m",
    },
    117: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "-42m",
    },
    118: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "-42m",
    },
    119: {
        "bravais_lattice": "tI",
        "crystal_system": "tetragonal",
        "pointgroup": "-42m",
    },
    120: {
        "bravais_lattice": "tI",
        "crystal_system": "tetragonal",
        "pointgroup": "-42m",
    },
    121: {
        "bravais_lattice": "tI",
        "crystal_system": "tetragonal",
        "pointgroup": "-42m",
    },
    122: {
        "bravais_lattice": "tI",
        "crystal_system": "tetragonal",
        "pointgroup": "-42m",
    },
    123: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    124: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    125: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    126: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    127: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    128: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    129: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    130: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    131: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    132: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    133: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    134: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    135: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    136: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    137: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    138: {
        "bravais_lattice": "tP",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    139: {
        "bravais_lattice": "tI",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    140: {
        "bravais_lattice": "tI",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    141: {
        "bravais_lattice": "tI",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    142: {
        "bravais_lattice": "tI",
        "crystal_system": "tetragonal",
        "pointgroup": "4/mmm",
    },
    143: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "3"},
    144: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "3"},
    145: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "3"},
    146: {"bravais_lattice": "hR", "crystal_system": "trigonal", "pointgroup": "3"},
    147: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "-3"},
    148: {"bravais_lattice": "hR", "crystal_system": "trigonal", "pointgroup": "-3"},
    149: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "32"},
    150: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "32"},
    151: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "32"},
    152: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "32"},
    153: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "32"},
    154: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "32"},
    155: {"bravais_lattice": "hR", "crystal_system": "trigonal", "pointgroup": "32"},
    156: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "3m"},
    157: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "3m"},
    158: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "3m"},
    159: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "3m"},
    160: {"bravais_lattice": "hR", "crystal_system": "trigonal", "pointgroup": "3m"},
    161: {"bravais_lattice": "hR", "crystal_system": "trigonal", "pointgroup": "3m"},
    162: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "-3m"},
    163: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "-3m"},
    164: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "-3m"},
    165: {"bravais_lattice": "hP", "crystal_system": "trigonal", "pointgroup": "-3m"},
    166: {"bravais_lattice": "hR", "crystal_system": "trigonal", "pointgroup": "-3m"},
    167: {"bravais_lattice": "hR", "crystal_system": "trigonal", "pointgroup": "-3m"},
    168: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "6"},
    169: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "6"},
    170: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "6"},
    171: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "6"},
    172: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "6"},
    173: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "6"},
    174: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "-6"},
    175: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "6/m"},
    176: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "6/m"},
    177: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "622"},
    178: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "622"},
    179: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "622"},
    180: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "622"},
    181: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "622"},
    182: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "622"},
    183: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "6mm"},
    184: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "6mm"},
    185: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "6mm"},
    186: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "6mm"},
    187: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "-6m2"},
    188: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "-6m2"},
    189: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "-6m2"},
    190: {"bravais_lattice": "hP", "crystal_system": "hexagonal", "pointgroup": "-6m2"},
    191: {
        "bravais_lattice": "hP",
        "crystal_system": "hexagonal",
        "pointgroup": "6/mmm",
    },
    192: {
        "bravais_lattice": "hP",
        "crystal_system": "hexagonal",
        "pointgroup": "6/mmm",
    },
    193: {
        "bravais_lattice": "hP",
        "crystal_system": "hexagonal",
        "pointgroup": "6/mmm",
    },
    194: {
        "bravais_lattice": "hP",
        "crystal_system": "hexagonal",
        "pointgroup": "6/mmm",
    },
    195: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "23"},
    196: {"bravais_lattice": "cF", "crystal_system": "cubic", "pointgroup": "23"},
    197: {"bravais_lattice": "cI", "crystal_system": "cubic", "pointgroup": "23"},
    198: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "23"},
    199: {"bravais_lattice": "cI", "crystal_system": "cubic", "pointgroup": "23"},
    200: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "m-3"},
    201: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "m-3"},
    202: {"bravais_lattice": "cF", "crystal_system": "cubic", "pointgroup": "m-3"},
    203: {"bravais_lattice": "cF", "crystal_system": "cubic", "pointgroup": "m-3"},
    204: {"bravais_lattice": "cI", "crystal_system": "cubic", "pointgroup": "m-3"},
    205: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "m-3"},
    206: {"bravais_lattice": "cI", "crystal_system": "cubic", "pointgroup": "m-3"},
    207: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "432"},
    208: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "432"},
    209: {"bravais_lattice": "cF", "crystal_system": "cubic", "pointgroup": "432"},
    210: {"bravais_lattice": "cF", "crystal_system": "cubic", "pointgroup": "432"},
    211: {"bravais_lattice": "cI", "crystal_system": "cubic", "pointgroup": "432"},
    212: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "432"},
    213: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "432"},
    214: {"bravais_lattice": "cI", "crystal_system": "cubic", "pointgroup": "432"},
    215: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "-43m"},
    216: {"bravais_lattice": "cF", "crystal_system": "cubic", "pointgroup": "-43m"},
    217: {"bravais_lattice": "cI", "crystal_system": "cubic", "pointgroup": "-43m"},
    218: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "-43m"},
    219: {"bravais_lattice": "cF", "crystal_system": "cubic", "pointgroup": "-43m"},
    220: {"bravais_lattice": "cI", "crystal_system": "cubic", "pointgroup": "-43m"},
    221: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "m-3m"},
    222: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "m-3m"},
    223: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "m-3m"},
    224: {"bravais_lattice": "cP", "crystal_system": "cubic", "pointgroup": "m-3m"},
    225: {"bravais_lattice": "cF", "crystal_system": "cubic", "pointgroup": "m-3m"},
    226: {"bravais_lattice": "cF", "crystal_system": "cubic", "pointgroup": "m-3m"},
    227: {"bravais_lattice": "cF", "crystal_system": "cubic", "pointgroup": "m-3m"},
    228: {"bravais_lattice": "cF", "crystal_system": "cubic", "pointgroup": "m-3m"},
    229: {"bravais_lattice": "cI", "crystal_system": "cubic", "pointgroup": "m-3m"},
    230: {"bravais_lattice": "cI", "crystal_system": "cubic", "pointgroup": "m-3m"},
}

WYCKOFF_SETS = {
    1: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["x", "y", "z"]],
            "matrices": array([[[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    2: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "h": {
            "constants": array([[0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "i": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "y", "z"], ["-x", "-y", "-z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    3: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": {"y"},
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "y", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": {"y"},
        },
        "c": {
            "constants": array([[0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "y", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": {"y"},
        },
        "d": {
            "constants": array([[0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "y", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": {"y"},
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "y", "z"], ["-x", "y", "-z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    4: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["x", "y", "z"], ["-x", "y+1/2", "-z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    5: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": {"y"},
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "y", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": {"y"},
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "y", "z"], ["-x", "y", "-z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    6: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "z"]],
            "matrices": array([[[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z", "x"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0]]),
            "expressions": [["x", "1/2", "z"]],
            "matrices": array([[[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z", "x"},
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "y", "z"], ["x", "-y", "z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    7: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["x", "y", "z"], ["x", "-y", "z+1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    8: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "z"]],
            "matrices": array([[[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z", "x"},
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "y", "z"], ["x", "-y", "z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    9: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["x", "y", "z"], ["x", "-y", "z+1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    10: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.0, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "h": {
            "constants": array([[0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "i": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "0"], ["0", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "j": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "y", "0"], ["1/2", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "k": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "y", "1/2"], ["0", "-y", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "l": {
            "constants": array([[0.5, 0.0, 0.5], [0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "y", "1/2"], ["1/2", "-y", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "m": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "z"], ["-x", "0", "-z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "n": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["x", "1/2", "z"], ["-x", "1/2", "-z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "o": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "y", "-z"],
                ["-x", "-y", "-z"],
                ["x", "-y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    11: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["0", "0", "0"], ["0", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "0", "1/2"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.0, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "0", "1/2"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.25, 0.0], [0.0, 0.75, 0.0]]),
            "expressions": [["x", "1/4", "z"], ["-x", "3/4", "-z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.5, 0.0], [0.0, 0.0, 0.0], [0.0, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "y+1/2", "-z"],
                ["-x", "-y", "-z"],
                ["x", "-y+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    12: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.25, 0.25, 0.0], [0.75, 0.25, 0.0]]),
            "expressions": [["1/4", "1/4", "0"], ["3/4", "1/4", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.25, 0.25, 0.5], [0.75, 0.25, 0.5]]),
            "expressions": [["1/4", "1/4", "1/2"], ["3/4", "1/4", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "0"], ["0", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "h": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "y", "1/2"], ["0", "-y", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "i": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "z"], ["-x", "0", "-z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "y", "-z"],
                ["-x", "-y", "-z"],
                ["x", "-y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    13: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "0"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "0", "0"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "y", "1/4"], ["0", "-y", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "f": {
            "constants": array([[0.5, 0.0, 0.25], [0.5, 0.0, 0.75]]),
            "expressions": [["1/2", "y", "1/4"], ["1/2", "-y", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "y", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x", "-y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    14: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "0", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.5, 0.0]]),
            "expressions": [["0", "0", "1/2"], ["0", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.0, 0.5], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "1/2"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.5, 0.5], [0.0, 0.0, 0.0], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "y+1/2", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x", "-y+1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    15: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "0"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.25, 0.25, 0.0], [0.75, 0.25, 0.5]]),
            "expressions": [["1/4", "1/4", "0"], ["3/4", "1/4", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.25, 0.25, 0.5], [0.75, 0.25, 0.0]]),
            "expressions": [["1/4", "1/4", "1/2"], ["3/4", "1/4", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "y", "1/4"], ["0", "-y", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "y", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x", "-y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    16: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "h": {
            "constants": array([[0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "i": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "0"], ["-x", "0", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["x", "0", "1/2"], ["-x", "0", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["x", "1/2", "0"], ["-x", "1/2", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "l": {
            "constants": array([[0.0, 0.5, 0.5], [0.0, 0.5, 0.5]]),
            "expressions": [["x", "1/2", "1/2"], ["-x", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "m": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "0"], ["0", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "n": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "y", "1/2"], ["0", "-y", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "o": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "y", "0"], ["1/2", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "p": {
            "constants": array([[0.5, 0.0, 0.5], [0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "y", "1/2"], ["1/2", "-y", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "q": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "r": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "0", "z"], ["1/2", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "s": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["0", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "t": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "z"], ["1/2", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "translations": array([]),
        "u": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
    },
    17: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["x", "0", "0"], ["-x", "0", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["x", "1/2", "0"], ["-x", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "y", "1/4"], ["0", "-y", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "d": {
            "constants": array([[0.5, 0.0, 0.25], [0.5, 0.0, 0.75]]),
            "expressions": [["1/2", "y", "1/4"], ["1/2", "-y", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["-x", "y", "-z+1/2"],
                ["x", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    18: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "z"], ["1/2", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x+1/2", "y+1/2", "-z"],
                ["x+1/2", "-y+1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    19: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y", "z+1/2"],
                ["-x", "y+1/2", "-z+1/2"],
                ["x+1/2", "-y+1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    20: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["x", "0", "0"], ["-x", "0", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "y", "1/4"], ["0", "-y", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["-x", "y", "-z+1/2"],
                ["x", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    21: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "0"], ["-x", "0", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["x", "0", "1/2"], ["-x", "0", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "0"], ["0", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "h": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "y", "1/2"], ["0", "-y", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "i": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["0", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "k": {
            "constants": array([[0.25, 0.25, 0.0], [0.75, 0.25, 0.0]]),
            "expressions": [["1/4", "1/4", "z"], ["3/4", "1/4", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "l": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    22: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.25, 0.25, 0.25]]),
            "expressions": [["1/4", "1/4", "1/4"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.25, 0.25, 0.75]]),
            "expressions": [["1/4", "1/4", "3/4"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "0"], ["-x", "0", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "0"], ["0", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array([[0.25, 0.25, 0.0], [0.75, 0.25, 0.0]]),
            "expressions": [["1/4", "1/4", "z"], ["3/4", "1/4", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array([[0.25, 0.0, 0.25], [0.75, 0.0, 0.25]]),
            "expressions": [["1/4", "y", "1/4"], ["3/4", "-y", "1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "j": {
            "constants": array([[0.0, 0.25, 0.25], [0.0, 0.75, 0.25]]),
            "expressions": [["x", "1/4", "1/4"], ["-x", "3/4", "1/4"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.5], [0.5, 0.5, 0.0]]),
    },
    23: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "0"], ["-x", "0", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["x", "0", "1/2"], ["-x", "0", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "0"], ["0", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "h": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "y", "0"], ["1/2", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "i": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["0", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "k": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    24: {
        "a": {
            "constants": array([[0.0, 0.0, 0.25], [0.5, 0.0, 0.75]]),
            "expressions": [["x", "0", "1/4"], ["-x+1/2", "0", "3/4"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "b": {
            "constants": array([[0.25, 0.0, 0.0], [0.25, 0.0, 0.5]]),
            "expressions": [["1/4", "y", "0"], ["1/4", "-y", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "c": {
            "constants": array([[0.0, 0.25, 0.0], [0.0, 0.75, 0.5]]),
            "expressions": [["0", "1/4", "z"], ["0", "3/4", "-z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y", "z+1/2"],
                ["-x", "y+1/2", "-z+1/2"],
                ["x+1/2", "-y+1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    25: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "d": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "z"], ["-x", "0", "z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "f": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["x", "1/2", "z"], ["-x", "1/2", "z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "z"], ["0", "-y", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "h": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "y", "z"], ["1/2", "-y", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    26: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "y", "z"], ["0", "-y", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "y", "z"], ["1/2", "-y", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    27: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "z"], ["0", "1/2", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "0", "z"], ["1/2", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "z"], ["1/2", "1/2", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    28: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["1/2", "0", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "1/2", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.25, 0.0, 0.0], [0.75, 0.0, 0.0]]),
            "expressions": [["1/4", "y", "z"], ["3/4", "-y", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x+1/2", "-y", "z"],
                ["-x+1/2", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    29: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.5, 0.0, 0.0], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["x+1/2", "-y", "z"],
                ["-x+1/2", "y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    30: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "1/2", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "0", "z"], ["1/2", "1/2", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.5, 0.5], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x", "-y+1/2", "z+1/2"],
                ["-x", "y+1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    31: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "y", "z"], ["1/2", "-y", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.0, 0.5], [0.5, 0.0, 0.5], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y", "z+1/2"],
                ["x+1/2", "-y", "z+1/2"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    32: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "z"], ["1/2", "1/2", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x+1/2", "-y+1/2", "z"],
                ["-x+1/2", "y+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    33: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["x+1/2", "-y+1/2", "z"],
                ["-x+1/2", "y+1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    34: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "z"], ["1/2", "1/2", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x+1/2", "-y+1/2", "z+1/2"],
                ["-x+1/2", "y+1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    35: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.25, 0.25, 0.0], [0.25, 0.75, 0.0]]),
            "expressions": [["1/4", "1/4", "z"], ["1/4", "3/4", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "z"], ["-x", "0", "z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "z"], ["0", "-y", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    36: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "y", "z"], ["0", "-y", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    37: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "z"], ["0", "1/2", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.25, 0.25, 0.0], [0.25, 0.75, 0.5]]),
            "expressions": [["1/4", "1/4", "z"], ["1/4", "3/4", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    38: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "z"], ["-x", "0", "z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "d": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "z"], ["0", "-y", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "e": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "y", "z"], ["1/2", "-y", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.0, 0.5, 0.5]]),
    },
    39: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "1/2", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "z"], ["1/2", "1/2", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.0, 0.25, 0.0], [0.0, 0.75, 0.0]]),
            "expressions": [["x", "1/4", "z"], ["-x", "3/4", "z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.5, 0.0], [0.0, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x", "-y+1/2", "z"],
                ["-x", "y+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.0, 0.5, 0.5]]),
    },
    40: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["1/2", "0", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.25, 0.0, 0.0], [0.75, 0.0, 0.0]]),
            "expressions": [["1/4", "y", "z"], ["3/4", "-y", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x+1/2", "-y", "z"],
                ["-x+1/2", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.0, 0.5, 0.5]]),
    },
    41: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "z"], ["1/2", "1/2", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x+1/2", "-y+1/2", "z"],
                ["-x+1/2", "y+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.0, 0.5, 0.5]]),
    },
    42: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.25, 0.25, 0.0], [0.25, 0.75, 0.0]]),
            "expressions": [["1/4", "1/4", "z"], ["1/4", "3/4", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "z"], ["0", "-y", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "d": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "z"], ["-x", "0", "z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.5], [0.5, 0.5, 0.0]]),
    },
    43: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.25, 0.25, 0.25]]),
            "expressions": [["0", "0", "z"], ["1/4", "1/4", "z+1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.25, 0.25, 0.25],
                    [0.25, 0.25, 0.25],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x+1/4", "-y+1/4", "z+1/4"],
                ["-x+1/4", "y+1/4", "z+1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.5, 0.0]]),
    },
    44: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "z"], ["-x", "0", "z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "d": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "z"], ["0", "-y", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    45: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "z"], ["1/2", "1/2", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x+1/2", "-y+1/2", "z"],
                ["-x+1/2", "y+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    46: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["1/2", "0", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.25, 0.0, 0.0], [0.75, 0.0, 0.0]]),
            "expressions": [["1/4", "y", "z"], ["3/4", "-y", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["x+1/2", "-y", "z"],
                ["-x+1/2", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    47: {
        "A": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "h": {
            "constants": array([[0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "i": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "0"], ["-x", "0", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["x", "0", "1/2"], ["-x", "0", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["x", "1/2", "0"], ["-x", "1/2", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "l": {
            "constants": array([[0.0, 0.5, 0.5], [0.0, 0.5, 0.5]]),
            "expressions": [["x", "1/2", "1/2"], ["-x", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "m": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "0"], ["0", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "n": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "y", "1/2"], ["0", "-y", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "o": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "y", "0"], ["1/2", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "p": {
            "constants": array([[0.5, 0.0, 0.5], [0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "y", "1/2"], ["1/2", "-y", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "q": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "r": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["0", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "s": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "0", "z"], ["1/2", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "t": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "z"], ["1/2", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "translations": array([]),
        "u": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "y", "z"],
                ["0", "-y", "z"],
                ["0", "y", "-z"],
                ["0", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "v": {
            "constants": array(
                [[0.5, 0.0, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["1/2", "y", "z"],
                ["1/2", "-y", "z"],
                ["1/2", "y", "-z"],
                ["1/2", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "w": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["-x", "0", "z"],
                ["-x", "0", "-z"],
                ["x", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "x": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.0, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "1/2", "z"],
                ["-x", "1/2", "z"],
                ["-x", "1/2", "-z"],
                ["x", "1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "y": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-x", "y", "0"],
                ["x", "-y", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "z": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "y", "1/2"],
                ["-x", "-y", "1/2"],
                ["-x", "y", "1/2"],
                ["x", "-y", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
    },
    48: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["1/2", "0", "0"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.75, 0.25, 0.75],
                    [0.25, 0.75, 0.75],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "1/4"],
                ["3/4", "3/4", "1/4"],
                ["3/4", "1/4", "3/4"],
                ["1/4", "3/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                ]
            ),
            "expressions": [
                ["3/4", "3/4", "3/4"],
                ["1/4", "1/4", "3/4"],
                ["1/4", "3/4", "1/4"],
                ["3/4", "1/4", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [[0.75, 0.0, 0.0], [0.25, 0.0, 0.0], [0.75, 0.5, 0.5], [0.25, 0.5, 0.5]]
            ),
            "expressions": [
                ["x+3/4", "0", "0"],
                ["-x+1/4", "0", "0"],
                ["-x+3/4", "1/2", "1/2"],
                ["x+1/4", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [[0.75, 0.0, 0.5], [0.25, 0.0, 0.5], [0.75, 0.5, 0.0], [0.25, 0.5, 0.0]]
            ),
            "expressions": [
                ["x+3/4", "0", "1/2"],
                ["-x+1/4", "0", "1/2"],
                ["-x+3/4", "1/2", "0"],
                ["x+1/4", "1/2", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.75, 0.0], [0.0, 0.25, 0.0], [0.5, 0.75, 0.5], [0.5, 0.25, 0.5]]
            ),
            "expressions": [
                ["0", "y+3/4", "0"],
                ["0", "-y+1/4", "0"],
                ["1/2", "-y+3/4", "1/2"],
                ["1/2", "y+1/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "j": {
            "constants": array(
                [[0.5, 0.75, 0.0], [0.5, 0.25, 0.0], [0.0, 0.75, 0.5], [0.0, 0.25, 0.5]]
            ),
            "expressions": [
                ["1/2", "y+3/4", "0"],
                ["1/2", "-y+1/4", "0"],
                ["0", "-y+3/4", "1/2"],
                ["0", "y+1/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "k": {
            "constants": array(
                [[0.0, 0.0, 0.75], [0.0, 0.0, 0.25], [0.5, 0.5, 0.75], [0.5, 0.5, 0.25]]
            ),
            "expressions": [
                ["0", "0", "z+3/4"],
                ["0", "0", "-z+1/4"],
                ["1/2", "1/2", "-z+3/4"],
                ["1/2", "1/2", "z+1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "l": {
            "constants": array(
                [[0.0, 0.5, 0.75], [0.0, 0.5, 0.25], [0.5, 0.0, 0.75], [0.5, 0.0, 0.25]]
            ),
            "expressions": [
                ["0", "1/2", "z+3/4"],
                ["0", "1/2", "-z+1/4"],
                ["1/2", "0", "-z+3/4"],
                ["1/2", "0", "z+1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "m": {
            "constants": array(
                [
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                ]
            ),
            "expressions": [
                ["x+3/4", "y+3/4", "z+3/4"],
                ["-x+1/4", "-y+1/4", "z+3/4"],
                ["-x+1/4", "y+3/4", "-z+1/4"],
                ["x+3/4", "-y+1/4", "-z+1/4"],
                ["-x+3/4", "-y+3/4", "-z+3/4"],
                ["x+1/4", "y+1/4", "-z+3/4"],
                ["x+1/4", "-y+3/4", "z+1/4"],
                ["-x+3/4", "y+1/4", "z+1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    49: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "0"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "0", "0"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.5, 0.0, 0.25], [0.5, 0.0, 0.75]]),
            "expressions": [["1/2", "0", "1/4"], ["1/2", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.5, 0.25], [0.0, 0.5, 0.75]]),
            "expressions": [["0", "1/2", "1/4"], ["0", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "h": {
            "constants": array([[0.5, 0.5, 0.25], [0.5, 0.5, 0.75]]),
            "expressions": [["1/2", "1/2", "1/4"], ["1/2", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "i": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "0", "1/4"],
                ["-x", "0", "1/4"],
                ["-x", "0", "3/4"],
                ["x", "0", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.5, 0.25], [0.0, 0.5, 0.25], [0.0, 0.5, 0.75], [0.0, 0.5, 0.75]]
            ),
            "expressions": [
                ["x", "1/2", "1/4"],
                ["-x", "1/2", "1/4"],
                ["-x", "1/2", "3/4"],
                ["x", "1/2", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "y", "1/4"],
                ["0", "-y", "1/4"],
                ["0", "-y", "3/4"],
                ["0", "y", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "l": {
            "constants": array(
                [[0.5, 0.0, 0.25], [0.5, 0.0, 0.25], [0.5, 0.0, 0.75], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["1/2", "y", "1/4"],
                ["1/2", "-y", "1/4"],
                ["1/2", "-y", "3/4"],
                ["1/2", "y", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "m": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z+1/2"],
                ["0", "0", "-z"],
                ["0", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "n": {
            "constants": array(
                [[0.5, 0.5, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "-z+1/2"],
                ["1/2", "1/2", "-z"],
                ["1/2", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "o": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.5], [0.0, 0.5, 0.0], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["0", "1/2", "-z+1/2"],
                ["0", "1/2", "-z"],
                ["0", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "p": {
            "constants": array(
                [[0.5, 0.0, 0.0], [0.5, 0.0, 0.5], [0.5, 0.0, 0.0], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["1/2", "0", "z"],
                ["1/2", "0", "-z+1/2"],
                ["1/2", "0", "-z"],
                ["1/2", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "q": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-x", "y", "1/2"],
                ["x", "-y", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "r": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x", "y", "-z+1/2"],
                ["x", "-y", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    50: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "0"], ["0", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.0, 0.5], [0.0, 0.5, 0.5]]),
            "expressions": [["1/2", "0", "1/2"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                ]
            ),
            "expressions": [
                ["3/4", "3/4", "0"],
                ["1/4", "1/4", "0"],
                ["1/4", "3/4", "0"],
                ["3/4", "1/4", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [
                    [0.75, 0.75, 0.5],
                    [0.25, 0.25, 0.5],
                    [0.25, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                ]
            ),
            "expressions": [
                ["3/4", "3/4", "1/2"],
                ["1/4", "1/4", "1/2"],
                ["1/4", "3/4", "1/2"],
                ["3/4", "1/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [[0.75, 0.0, 0.0], [0.25, 0.0, 0.0], [0.75, 0.5, 0.0], [0.25, 0.5, 0.0]]
            ),
            "expressions": [
                ["x+3/4", "0", "0"],
                ["-x+1/4", "0", "0"],
                ["-x+3/4", "1/2", "0"],
                ["x+1/4", "1/2", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [[0.75, 0.0, 0.5], [0.25, 0.0, 0.5], [0.75, 0.5, 0.5], [0.25, 0.5, 0.5]]
            ),
            "expressions": [
                ["x+3/4", "0", "1/2"],
                ["-x+1/4", "0", "1/2"],
                ["-x+3/4", "1/2", "1/2"],
                ["x+1/4", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.75, 0.0], [0.0, 0.25, 0.0], [0.5, 0.75, 0.0], [0.5, 0.25, 0.0]]
            ),
            "expressions": [
                ["0", "y+3/4", "0"],
                ["0", "-y+1/4", "0"],
                ["1/2", "-y+3/4", "0"],
                ["1/2", "y+1/4", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.75, 0.5], [0.0, 0.25, 0.5], [0.5, 0.75, 0.5], [0.5, 0.25, 0.5]]
            ),
            "expressions": [
                ["0", "y+3/4", "1/2"],
                ["0", "-y+1/4", "1/2"],
                ["1/2", "-y+3/4", "1/2"],
                ["1/2", "y+1/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "k": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z"],
                ["1/2", "1/2", "-z"],
                ["1/2", "1/2", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "l": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z"],
                ["1/2", "0", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "m": {
            "constants": array(
                [
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                ]
            ),
            "expressions": [
                ["x+3/4", "y+3/4", "z"],
                ["-x+1/4", "-y+1/4", "z"],
                ["-x+1/4", "y+3/4", "-z"],
                ["x+3/4", "-y+1/4", "-z"],
                ["-x+3/4", "-y+3/4", "-z"],
                ["x+1/4", "y+1/4", "-z"],
                ["x+1/4", "-y+3/4", "z"],
                ["-x+3/4", "y+1/4", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    51: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "1/2"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.25, 0.0, 0.0], [0.75, 0.0, 0.0]]),
            "expressions": [["1/4", "0", "z"], ["3/4", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array([[0.25, 0.5, 0.0], [0.75, 0.5, 0.0]]),
            "expressions": [["1/4", "1/2", "z"], ["3/4", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "y", "0"],
                ["1/2", "-y", "0"],
                ["0", "-y", "0"],
                ["1/2", "y", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.5, 0.0, 0.5], [0.0, 0.0, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "y", "1/2"],
                ["1/2", "-y", "1/2"],
                ["0", "-y", "1/2"],
                ["1/2", "y", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["-x+1/2", "0", "z"],
                ["-x", "0", "-z"],
                ["x+1/2", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "1/2", "z"],
                ["-x+1/2", "1/2", "z"],
                ["-x", "1/2", "-z"],
                ["x+1/2", "1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "k": {
            "constants": array(
                [[0.25, 0.0, 0.0], [0.25, 0.0, 0.0], [0.75, 0.0, 0.0], [0.75, 0.0, 0.0]]
            ),
            "expressions": [
                ["1/4", "y", "z"],
                ["1/4", "-y", "z"],
                ["3/4", "y", "-z"],
                ["3/4", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y", "z"],
                ["-x", "y", "-z"],
                ["x+1/2", "-y", "-z"],
                ["-x", "-y", "-z"],
                ["x+1/2", "y", "-z"],
                ["x", "-y", "z"],
                ["-x+1/2", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    52: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.0, 0.0], [0.5, 0.5, 0.5], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "0", "0"],
                ["1/2", "0", "0"],
                ["1/2", "1/2", "1/2"],
                ["0", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.5, 0.0, 0.5], [0.5, 0.5, 0.0], [0.0, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "0", "1/2"],
                ["1/2", "0", "1/2"],
                ["1/2", "1/2", "0"],
                ["0", "1/2", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.25, 0.0, 0.0], [0.25, 0.5, 0.5], [0.75, 0.0, 0.0], [0.75, 0.5, 0.5]]
            ),
            "expressions": [
                ["1/4", "0", "z"],
                ["1/4", "1/2", "-z+1/2"],
                ["3/4", "0", "-z"],
                ["3/4", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.25, 0.25],
                    [0.5, 0.75, 0.25],
                    [0.0, 0.75, 0.75],
                    [0.5, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["x", "1/4", "1/4"],
                ["-x+1/2", "3/4", "1/4"],
                ["-x", "3/4", "3/4"],
                ["x+1/2", "1/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y", "z"],
                ["-x+1/2", "y+1/2", "-z+1/2"],
                ["x", "-y+1/2", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x+1/2", "y", "-z"],
                ["x+1/2", "-y+1/2", "z+1/2"],
                ["-x", "y+1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    53: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["1/2", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.5, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "0"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.0, 0.5], [0.0, 0.0, 0.0], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x+1/2", "0", "1/2"],
                ["-x", "0", "0"],
                ["x+1/2", "0", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.5, 0.5], [0.0, 0.5, 0.0], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "1/2", "0"],
                ["-x+1/2", "1/2", "1/2"],
                ["-x", "1/2", "0"],
                ["x+1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [
                    [0.25, 0.0, 0.25],
                    [0.25, 0.0, 0.75],
                    [0.75, 0.0, 0.75],
                    [0.75, 0.0, 0.25],
                ]
            ),
            "expressions": [
                ["1/4", "y", "1/4"],
                ["1/4", "-y", "3/4"],
                ["3/4", "-y", "3/4"],
                ["3/4", "y", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.0, 0.5], [0.5, 0.0, 0.5], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "y", "z"],
                ["1/2", "-y", "z+1/2"],
                ["1/2", "y", "-z+1/2"],
                ["0", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y", "z+1/2"],
                ["-x+1/2", "y", "-z+1/2"],
                ["x", "-y", "-z"],
                ["-x", "-y", "-z"],
                ["x+1/2", "y", "-z+1/2"],
                ["x+1/2", "-y", "z+1/2"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    54: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.0, 0.0], [0.0, 0.0, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "0"],
                ["1/2", "0", "0"],
                ["0", "0", "1/2"],
                ["1/2", "0", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.5, 0.0], [0.0, 0.5, 0.5], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "0"],
                ["1/2", "1/2", "0"],
                ["0", "1/2", "1/2"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.5, 0.0, 0.25], [0.0, 0.0, 0.75], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "y", "1/4"],
                ["1/2", "-y", "1/4"],
                ["0", "-y", "3/4"],
                ["1/2", "y", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "d": {
            "constants": array(
                [[0.25, 0.0, 0.0], [0.75, 0.0, 0.5], [0.75, 0.0, 0.0], [0.25, 0.0, 0.5]]
            ),
            "expressions": [
                ["1/4", "0", "z"],
                ["3/4", "0", "-z+1/2"],
                ["3/4", "0", "-z"],
                ["1/4", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "e": {
            "constants": array(
                [[0.25, 0.5, 0.0], [0.75, 0.5, 0.5], [0.75, 0.5, 0.0], [0.25, 0.5, 0.5]]
            ),
            "expressions": [
                ["1/4", "1/2", "z"],
                ["3/4", "1/2", "-z+1/2"],
                ["3/4", "1/2", "-z"],
                ["1/4", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y", "z"],
                ["-x", "y", "-z+1/2"],
                ["x+1/2", "-y", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x+1/2", "y", "-z"],
                ["x", "-y", "z+1/2"],
                ["-x+1/2", "y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    55: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "1/2"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["1/2", "1/2", "-z"],
                ["0", "0", "-z"],
                ["1/2", "1/2", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "-z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-x+1/2", "y+1/2", "0"],
                ["x+1/2", "-y+1/2", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "y", "1/2"],
                ["-x", "-y", "1/2"],
                ["-x+1/2", "y+1/2", "1/2"],
                ["x+1/2", "-y+1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x+1/2", "y+1/2", "-z"],
                ["x+1/2", "-y+1/2", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["x+1/2", "-y+1/2", "z"],
                ["-x+1/2", "y+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    56: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "0"],
                ["1/2", "1/2", "0"],
                ["0", "1/2", "1/2"],
                ["1/2", "0", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.5, 0.5, 0.5], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "0", "1/2"],
                ["1/2", "1/2", "1/2"],
                ["0", "1/2", "0"],
                ["1/2", "0", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.5],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.5],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "z"],
                ["3/4", "3/4", "-z+1/2"],
                ["3/4", "3/4", "-z"],
                ["1/4", "1/4", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.5],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.5],
                ]
            ),
            "expressions": [
                ["1/4", "3/4", "z"],
                ["3/4", "1/4", "-z+1/2"],
                ["3/4", "1/4", "-z"],
                ["1/4", "3/4", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y+1/2", "z"],
                ["-x", "y+1/2", "-z+1/2"],
                ["x+1/2", "-y", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x+1/2", "y+1/2", "-z"],
                ["x", "-y+1/2", "z+1/2"],
                ["-x+1/2", "y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    57: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.5, 0.5], [0.0, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "0", "0"],
                ["0", "0", "1/2"],
                ["0", "1/2", "1/2"],
                ["0", "1/2", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.5, 0.0, 0.0], [0.5, 0.0, 0.5], [0.5, 0.5, 0.5], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["1/2", "0", "0"],
                ["1/2", "0", "1/2"],
                ["1/2", "1/2", "1/2"],
                ["1/2", "1/2", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.25, 0.0], [0.0, 0.75, 0.5], [0.0, 0.75, 0.0], [0.0, 0.25, 0.5]]
            ),
            "expressions": [
                ["x", "1/4", "0"],
                ["-x", "3/4", "1/2"],
                ["-x", "3/4", "0"],
                ["x", "1/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.0, 0.5, 0.25], [0.0, 0.5, 0.75]]
            ),
            "expressions": [
                ["x", "y", "1/4"],
                ["-x", "-y", "3/4"],
                ["-x", "y+1/2", "1/4"],
                ["x", "-y+1/2", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.0, 0.5, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.0, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["-x", "y+1/2", "-z+1/2"],
                ["x", "-y+1/2", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z+1/2"],
                ["x", "-y+1/2", "z+1/2"],
                ["-x", "y+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    58: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "1/2"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.0, 0.0, 0.0], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["1/2", "1/2", "-z+1/2"],
                ["0", "0", "-z"],
                ["1/2", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.0], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "-z+1/2"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-x+1/2", "y+1/2", "1/2"],
                ["x+1/2", "-y+1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "h": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x+1/2", "y+1/2", "-z+1/2"],
                ["x+1/2", "-y+1/2", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["x+1/2", "-y+1/2", "z+1/2"],
                ["-x+1/2", "y+1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    59: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "z"], ["1/2", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["3/4", "3/4", "0"],
                ["1/4", "1/4", "0"],
                ["3/4", "1/4", "0"],
                ["1/4", "3/4", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [
                    [0.75, 0.75, 0.5],
                    [0.25, 0.25, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.25, 0.75, 0.5],
                ]
            ),
            "expressions": [
                ["3/4", "3/4", "1/2"],
                ["1/4", "1/4", "1/2"],
                ["3/4", "1/4", "1/2"],
                ["1/4", "3/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.75, 0.0], [0.0, 0.25, 0.0], [0.5, 0.25, 0.0], [0.5, 0.75, 0.0]]
            ),
            "expressions": [
                ["0", "y+3/4", "z"],
                ["0", "-y+1/4", "z"],
                ["1/2", "y+1/4", "-z"],
                ["1/2", "-y+3/4", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "f": {
            "constants": array(
                [[0.75, 0.0, 0.0], [0.25, 0.0, 0.0], [0.75, 0.5, 0.0], [0.25, 0.5, 0.0]]
            ),
            "expressions": [
                ["x+3/4", "0", "z"],
                ["-x+1/4", "0", "z"],
                ["-x+3/4", "1/2", "-z"],
                ["x+1/4", "1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "g": {
            "constants": array(
                [
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["x+3/4", "y+3/4", "z"],
                ["-x+1/4", "-y+1/4", "z"],
                ["-x+3/4", "y+1/4", "-z"],
                ["x+1/4", "-y+3/4", "-z"],
                ["-x+3/4", "-y+3/4", "-z"],
                ["x+1/4", "y+1/4", "-z"],
                ["x+3/4", "-y+1/4", "z"],
                ["-x+1/4", "y+3/4", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    60: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.0, 0.0, 0.5], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "0", "0"],
                ["1/2", "1/2", "1/2"],
                ["0", "0", "1/2"],
                ["1/2", "1/2", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "0"],
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/2"],
                ["1/2", "0", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.5, 0.5, 0.75], [0.0, 0.0, 0.75], [0.5, 0.5, 0.25]]
            ),
            "expressions": [
                ["0", "y", "1/4"],
                ["1/2", "-y+1/2", "3/4"],
                ["0", "-y", "3/4"],
                ["1/2", "y+1/2", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y+1/2", "z+1/2"],
                ["-x", "y", "-z+1/2"],
                ["x+1/2", "-y+1/2", "-z"],
                ["-x", "-y", "-z"],
                ["x+1/2", "y+1/2", "-z+1/2"],
                ["x", "-y", "z+1/2"],
                ["-x+1/2", "y+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    61: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "0", "0"],
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/2"],
                ["1/2", "1/2", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "0", "1/2"],
                ["1/2", "0", "0"],
                ["0", "1/2", "0"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y", "z+1/2"],
                ["-x", "y+1/2", "-z+1/2"],
                ["x+1/2", "-y+1/2", "-z"],
                ["-x", "-y", "-z"],
                ["x+1/2", "y", "-z+1/2"],
                ["x", "-y+1/2", "z+1/2"],
                ["-x+1/2", "y+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    62: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.0], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "0", "0"],
                ["1/2", "0", "1/2"],
                ["0", "1/2", "0"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.5, 0.0, 0.0], [0.0, 0.5, 0.5], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "0", "1/2"],
                ["1/2", "0", "0"],
                ["0", "1/2", "1/2"],
                ["1/2", "1/2", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.25, 0.0], [0.5, 0.75, 0.5], [0.0, 0.75, 0.0], [0.5, 0.25, 0.5]]
            ),
            "expressions": [
                ["x", "1/4", "z"],
                ["-x+1/2", "3/4", "z+1/2"],
                ["-x", "3/4", "-z"],
                ["x+1/2", "1/4", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y", "z+1/2"],
                ["-x", "y+1/2", "-z"],
                ["x+1/2", "-y+1/2", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x+1/2", "y", "-z+1/2"],
                ["x", "-y+1/2", "z"],
                ["-x+1/2", "y+1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    63: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "0"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "y", "1/4"], ["0", "-y", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "d": {
            "constants": array(
                [
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.25, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "0"],
                ["3/4", "3/4", "1/2"],
                ["3/4", "1/4", "1/2"],
                ["1/4", "3/4", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x", "0", "1/2"],
                ["-x", "0", "0"],
                ["x", "0", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "y", "z"],
                ["0", "-y", "z+1/2"],
                ["0", "y", "-z+1/2"],
                ["0", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "y", "1/4"],
                ["-x", "-y", "3/4"],
                ["-x", "y", "1/4"],
                ["x", "-y", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "h": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["-x", "y", "-z+1/2"],
                ["x", "-y", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z+1/2"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    64: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "0", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [
                    [0.25, 0.25, 0.0],
                    [0.75, 0.25, 0.5],
                    [0.75, 0.75, 0.5],
                    [0.25, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "0"],
                ["3/4", "1/4", "1/2"],
                ["3/4", "3/4", "1/2"],
                ["1/4", "3/4", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.5, 0.5], [0.0, 0.0, 0.0], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x", "1/2", "1/2"],
                ["-x", "0", "0"],
                ["x", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "e": {
            "constants": array(
                [
                    [0.25, 0.0, 0.25],
                    [0.75, 0.5, 0.75],
                    [0.75, 0.0, 0.75],
                    [0.25, 0.5, 0.25],
                ]
            ),
            "expressions": [
                ["1/4", "y", "1/4"],
                ["3/4", "-y+1/2", "3/4"],
                ["3/4", "-y", "3/4"],
                ["1/4", "y+1/2", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.5, 0.5], [0.0, 0.5, 0.5], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "y", "z"],
                ["0", "-y+1/2", "z+1/2"],
                ["0", "y+1/2", "-z+1/2"],
                ["0", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y+1/2", "z+1/2"],
                ["-x", "y+1/2", "-z+1/2"],
                ["x", "-y", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y+1/2", "-z+1/2"],
                ["x", "-y+1/2", "z+1/2"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    65: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.25, 0.25, 0.0], [0.75, 0.25, 0.0]]),
            "expressions": [["1/4", "1/4", "0"], ["3/4", "1/4", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.25, 0.25, 0.5], [0.75, 0.25, 0.5]]),
            "expressions": [["1/4", "1/4", "1/2"], ["3/4", "1/4", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "0"], ["-x", "0", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["x", "0", "1/2"], ["-x", "0", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "0"], ["0", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "j": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "y", "1/2"], ["0", "-y", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "k": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "l": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["0", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "m": {
            "constants": array(
                [
                    [0.25, 0.25, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "z"],
                ["3/4", "1/4", "-z"],
                ["3/4", "3/4", "-z"],
                ["1/4", "3/4", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "n": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "y", "z"],
                ["0", "-y", "z"],
                ["0", "y", "-z"],
                ["0", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "o": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["-x", "0", "z"],
                ["-x", "0", "-z"],
                ["x", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "p": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-x", "y", "0"],
                ["x", "-y", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "q": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "y", "1/2"],
                ["-x", "-y", "1/2"],
                ["-x", "y", "1/2"],
                ["x", "-y", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "r": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    66: {
        "a": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.25], [0.0, 0.5, 0.75]]),
            "expressions": [["0", "1/2", "1/4"], ["0", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "0"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.25, 0.25, 0.0], [0.75, 0.25, 0.5]]),
            "expressions": [["1/4", "1/4", "0"], ["3/4", "1/4", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.25, 0.75, 0.0], [0.75, 0.75, 0.5]]),
            "expressions": [["1/4", "3/4", "0"], ["3/4", "3/4", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "0", "1/4"],
                ["-x", "0", "1/4"],
                ["-x", "0", "3/4"],
                ["x", "0", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "y", "1/4"],
                ["0", "-y", "1/4"],
                ["0", "-y", "3/4"],
                ["0", "y", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z+1/2"],
                ["0", "0", "-z"],
                ["0", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.5], [0.0, 0.5, 0.0], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["0", "1/2", "-z+1/2"],
                ["0", "1/2", "-z"],
                ["0", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "k": {
            "constants": array(
                [
                    [0.25, 0.25, 0.0],
                    [0.75, 0.25, 0.5],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.75, 0.5],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "z"],
                ["3/4", "1/4", "-z+1/2"],
                ["3/4", "3/4", "-z"],
                ["1/4", "3/4", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "l": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-x", "y", "1/2"],
                ["x", "-y", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "m": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x", "y", "-z+1/2"],
                ["x", "-y", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    67: {
        "a": {
            "constants": array([[0.25, 0.0, 0.0], [0.75, 0.0, 0.0]]),
            "expressions": [["1/4", "0", "0"], ["3/4", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.25, 0.0, 0.5], [0.75, 0.0, 0.5]]),
            "expressions": [["1/4", "0", "1/2"], ["3/4", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["0", "0", "0"], ["0", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "0", "1/2"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.25, 0.25, 0.0], [0.75, 0.25, 0.0]]),
            "expressions": [["1/4", "1/4", "0"], ["3/4", "1/4", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.25, 0.25, 0.5], [0.75, 0.25, 0.5]]),
            "expressions": [["1/4", "1/4", "1/2"], ["3/4", "1/4", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.25, 0.0], [0.0, 0.75, 0.0]]),
            "expressions": [["0", "1/4", "z"], ["0", "3/4", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.5, 0.0], [0.0, 0.0, 0.0], [0.0, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x", "1/2", "0"],
                ["-x", "0", "0"],
                ["x", "1/2", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.5, 0.5], [0.0, 0.0, 0.5], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "0", "1/2"],
                ["-x", "1/2", "1/2"],
                ["-x", "0", "1/2"],
                ["x", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [[0.25, 0.0, 0.0], [0.75, 0.5, 0.0], [0.75, 0.0, 0.0], [0.25, 0.5, 0.0]]
            ),
            "expressions": [
                ["1/4", "y", "0"],
                ["3/4", "-y+1/2", "0"],
                ["3/4", "-y", "0"],
                ["1/4", "y+1/2", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "k": {
            "constants": array(
                [[0.25, 0.0, 0.5], [0.75, 0.5, 0.5], [0.75, 0.0, 0.5], [0.25, 0.5, 0.5]]
            ),
            "expressions": [
                ["1/4", "y", "1/2"],
                ["3/4", "-y+1/2", "1/2"],
                ["3/4", "-y", "1/2"],
                ["1/4", "y+1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "l": {
            "constants": array(
                [[0.25, 0.0, 0.0], [0.75, 0.5, 0.0], [0.75, 0.0, 0.0], [0.25, 0.5, 0.0]]
            ),
            "expressions": [
                ["1/4", "0", "z"],
                ["3/4", "1/2", "-z"],
                ["3/4", "0", "-z"],
                ["1/4", "1/2", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "m": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "y", "z"],
                ["0", "-y+1/2", "z"],
                ["0", "y+1/2", "-z"],
                ["0", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "n": {
            "constants": array(
                [[0.0, 0.25, 0.0], [0.0, 0.25, 0.0], [0.0, 0.75, 0.0], [0.0, 0.75, 0.0]]
            ),
            "expressions": [
                ["x", "1/4", "z"],
                ["-x", "1/4", "z"],
                ["-x", "3/4", "-z"],
                ["x", "3/4", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "o": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y+1/2", "z"],
                ["-x", "y+1/2", "-z"],
                ["x", "-y", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y+1/2", "-z"],
                ["x", "-y+1/2", "z"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    68: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.5, 0.0]]),
            "expressions": [["0", "0", "1/2"], ["0", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [
                    [0.25, 0.5, 0.75],
                    [0.25, 0.0, 0.75],
                    [0.75, 0.5, 0.25],
                    [0.75, 0.0, 0.25],
                ]
            ),
            "expressions": [
                ["1/4", "1/2", "3/4"],
                ["1/4", "0", "3/4"],
                ["3/4", "1/2", "1/4"],
                ["3/4", "0", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.75, 0.75],
                    [0.5, 0.75, 0.75],
                    [0.0, 0.75, 0.25],
                    [0.5, 0.75, 0.25],
                ]
            ),
            "expressions": [
                ["0", "3/4", "3/4"],
                ["1/2", "3/4", "3/4"],
                ["0", "3/4", "1/4"],
                ["1/2", "3/4", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x+1/2", "1/2", "0"],
                ["-x", "1/2", "1/2"],
                ["x+1/2", "0", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.75, 0.0], [0.5, 0.75, 0.0], [0.0, 0.75, 0.5], [0.5, 0.75, 0.5]]
            ),
            "expressions": [
                ["0", "y+3/4", "0"],
                ["1/2", "-y+3/4", "0"],
                ["0", "-y+3/4", "1/2"],
                ["1/2", "y+3/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.75], [0.0, 0.0, 0.25], [0.0, 0.5, 0.75], [0.0, 0.5, 0.25]]
            ),
            "expressions": [
                ["0", "0", "z+3/4"],
                ["0", "0", "-z+1/4"],
                ["0", "1/2", "-z+3/4"],
                ["0", "1/2", "z+1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [
                    [0.25, 0.75, 0.75],
                    [0.75, 0.75, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.75, 0.25],
                ]
            ),
            "expressions": [
                ["1/4", "3/4", "z+3/4"],
                ["3/4", "3/4", "-z+1/4"],
                ["3/4", "3/4", "-z+3/4"],
                ["1/4", "3/4", "z+1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.75, 0.75],
                    [0.5, 0.75, 0.75],
                    [0.0, 0.75, 0.25],
                    [0.5, 0.75, 0.25],
                    [0.0, 0.75, 0.75],
                    [0.5, 0.75, 0.75],
                    [0.0, 0.75, 0.25],
                    [0.5, 0.75, 0.25],
                ]
            ),
            "expressions": [
                ["x", "y+3/4", "z+3/4"],
                ["-x+1/2", "-y+3/4", "z+3/4"],
                ["-x", "y+3/4", "-z+1/4"],
                ["x+1/2", "-y+3/4", "-z+1/4"],
                ["-x", "-y+3/4", "-z+3/4"],
                ["x+1/2", "y+3/4", "-z+3/4"],
                ["x", "-y+3/4", "z+1/4"],
                ["-x+1/2", "y+3/4", "z+1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.0]]),
    },
    69: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.25, 0.25], [0.0, 0.75, 0.25]]),
            "expressions": [["0", "1/4", "1/4"], ["0", "3/4", "1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.25, 0.0, 0.25], [0.75, 0.0, 0.25]]),
            "expressions": [["1/4", "0", "1/4"], ["3/4", "0", "1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.25, 0.25, 0.0], [0.75, 0.25, 0.0]]),
            "expressions": [["1/4", "1/4", "0"], ["3/4", "1/4", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.25, 0.25, 0.25], [0.75, 0.75, 0.75]]),
            "expressions": [["1/4", "1/4", "1/4"], ["3/4", "3/4", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "0"], ["-x", "0", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "0"], ["0", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "i": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array(
                [
                    [0.25, 0.25, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "z"],
                ["3/4", "1/4", "-z"],
                ["3/4", "3/4", "-z"],
                ["1/4", "3/4", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "k": {
            "constants": array(
                [
                    [0.25, 0.0, 0.25],
                    [0.75, 0.0, 0.25],
                    [0.75, 0.0, 0.75],
                    [0.25, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["1/4", "y", "1/4"],
                ["3/4", "-y", "1/4"],
                ["3/4", "-y", "3/4"],
                ["1/4", "y", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.25, 0.25],
                    [0.0, 0.75, 0.25],
                    [0.0, 0.75, 0.75],
                    [0.0, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["x", "1/4", "1/4"],
                ["-x", "3/4", "1/4"],
                ["-x", "3/4", "3/4"],
                ["x", "1/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "m": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "y", "z"],
                ["0", "-y", "z"],
                ["0", "y", "-z"],
                ["0", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "n": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["-x", "0", "z"],
                ["-x", "0", "-z"],
                ["x", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "o": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-x", "y", "0"],
                ["x", "-y", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "p": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.5], [0.5, 0.5, 0.0]]),
    },
    70: {
        "a": {
            "constants": array([[0.25, 0.25, 0.25], [0.0, 0.0, 0.0]]),
            "expressions": [["1/4", "1/4", "1/4"], ["0", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.25, 0.25, 0.75], [0.0, 0.0, 0.5]]),
            "expressions": [["1/4", "1/4", "3/4"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [
                    [0.125, 0.125, 0.125],
                    [0.875, 0.875, 0.125],
                    [0.875, 0.125, 0.875],
                    [0.125, 0.875, 0.875],
                ]
            ),
            "expressions": [
                ["1/8", "1/8", "1/8"],
                ["7/8", "7/8", "1/8"],
                ["7/8", "1/8", "7/8"],
                ["1/8", "7/8", "7/8"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [
                    [0.625, 0.625, 0.625],
                    [0.375, 0.375, 0.625],
                    [0.375, 0.625, 0.375],
                    [0.625, 0.375, 0.375],
                ]
            ),
            "expressions": [
                ["5/8", "5/8", "5/8"],
                ["3/8", "3/8", "5/8"],
                ["3/8", "5/8", "3/8"],
                ["5/8", "3/8", "3/8"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.125, 0.25, 0.25],
                    [0.875, 0.75, 0.25],
                    [0.125, 0.0, 0.0],
                    [0.375, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["x+1/8", "1/4", "1/4"],
                ["-x+7/8", "3/4", "1/4"],
                ["-x+1/8", "0", "0"],
                ["x+3/8", "1/2", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array(
                [
                    [0.25, 0.125, 0.25],
                    [0.75, 0.875, 0.25],
                    [0.0, 0.125, 0.0],
                    [0.5, 0.375, 0.0],
                ]
            ),
            "expressions": [
                ["1/4", "y+1/8", "1/4"],
                ["3/4", "-y+7/8", "1/4"],
                ["0", "-y+1/8", "0"],
                ["1/2", "y+3/8", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "g": {
            "constants": array(
                [
                    [0.25, 0.25, 0.125],
                    [0.75, 0.25, 0.875],
                    [0.0, 0.0, 0.125],
                    [0.5, 0.0, 0.375],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "z+1/8"],
                ["3/4", "1/4", "-z+7/8"],
                ["0", "0", "-z+1/8"],
                ["1/2", "0", "z+3/8"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [
                    [0.125, 0.125, 0.125],
                    [0.875, 0.875, 0.125],
                    [0.875, 0.125, 0.875],
                    [0.125, 0.875, 0.875],
                    [0.125, 0.125, 0.125],
                    [0.375, 0.375, 0.125],
                    [0.375, 0.125, 0.375],
                    [0.125, 0.375, 0.375],
                ]
            ),
            "expressions": [
                ["x+1/8", "y+1/8", "z+1/8"],
                ["-x+7/8", "-y+7/8", "z+1/8"],
                ["-x+7/8", "y+1/8", "-z+7/8"],
                ["x+1/8", "-y+7/8", "-z+7/8"],
                ["-x+1/8", "-y+1/8", "-z+1/8"],
                ["x+3/8", "y+3/8", "-z+1/8"],
                ["x+3/8", "-y+1/8", "z+3/8"],
                ["-x+1/8", "y+3/8", "z+3/8"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.5], [0.5, 0.5, 0.0]]),
    },
    71: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.0, 0.5]]),
            "expressions": [["1/2", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "0"], ["-x", "0", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array([[0.0, 0.5, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["x", "1/2", "0"], ["-x", "1/2", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "y", "0"], ["0", "-y", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "h": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "y", "1/2"], ["0", "-y", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "i": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array([[0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["1/2", "0", "z"], ["1/2", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "k": {
            "constants": array(
                [
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.75, 0.25, 0.75],
                    [0.25, 0.75, 0.75],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "1/4"],
                ["3/4", "3/4", "1/4"],
                ["3/4", "1/4", "3/4"],
                ["1/4", "3/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "l": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "y", "z"],
                ["0", "-y", "z"],
                ["0", "y", "-z"],
                ["0", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "m": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["-x", "0", "z"],
                ["-x", "0", "-z"],
                ["x", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "n": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-x", "y", "0"],
                ["x", "-y", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "o": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    72: {
        "a": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.25], [0.5, 0.0, 0.75]]),
            "expressions": [["1/2", "0", "1/4"], ["1/2", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "0"], ["0", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "1/4"],
                ["3/4", "3/4", "1/4"],
                ["1/4", "3/4", "3/4"],
                ["3/4", "1/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "0", "1/4"],
                ["-x", "0", "1/4"],
                ["-x", "0", "3/4"],
                ["x", "0", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "y", "1/4"],
                ["0", "-y", "1/4"],
                ["0", "-y", "3/4"],
                ["0", "y", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["1/2", "1/2", "-z"],
                ["0", "0", "-z"],
                ["1/2", "1/2", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "-z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-x+1/2", "y+1/2", "0"],
                ["x+1/2", "-y+1/2", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-x+1/2", "y+1/2", "-z"],
                ["x+1/2", "-y+1/2", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["x+1/2", "-y+1/2", "z"],
                ["-x+1/2", "y+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    73: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "0", "0"],
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/2"],
                ["1/2", "1/2", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [
                    [0.25, 0.25, 0.25],
                    [0.25, 0.75, 0.75],
                    [0.75, 0.75, 0.25],
                    [0.75, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "1/4"],
                ["1/4", "3/4", "3/4"],
                ["3/4", "3/4", "1/4"],
                ["3/4", "1/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.5, 0.0, 0.75], [0.0, 0.0, 0.75], [0.5, 0.0, 0.25]]
            ),
            "expressions": [
                ["x", "0", "1/4"],
                ["-x+1/2", "0", "3/4"],
                ["-x", "0", "3/4"],
                ["x+1/2", "0", "1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "d": {
            "constants": array(
                [[0.25, 0.0, 0.0], [0.25, 0.0, 0.5], [0.75, 0.0, 0.0], [0.75, 0.0, 0.5]]
            ),
            "expressions": [
                ["1/4", "y", "0"],
                ["1/4", "-y", "1/2"],
                ["3/4", "-y", "0"],
                ["3/4", "y", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "e": {
            "constants": array(
                [[0.0, 0.25, 0.0], [0.0, 0.75, 0.5], [0.0, 0.75, 0.0], [0.0, 0.25, 0.5]]
            ),
            "expressions": [
                ["0", "1/4", "z"],
                ["0", "3/4", "-z+1/2"],
                ["0", "3/4", "-z"],
                ["0", "1/4", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y", "z+1/2"],
                ["-x", "y+1/2", "-z+1/2"],
                ["x+1/2", "-y+1/2", "-z"],
                ["-x", "-y", "-z"],
                ["x+1/2", "y", "-z+1/2"],
                ["x", "-y+1/2", "z+1/2"],
                ["-x+1/2", "y+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    74: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["0", "0", "0"], ["0", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.5, 0.5]]),
            "expressions": [["0", "0", "1/2"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.25, 0.25, 0.25], [0.75, 0.25, 0.25]]),
            "expressions": [["1/4", "1/4", "1/4"], ["3/4", "1/4", "1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.25, 0.25, 0.75], [0.75, 0.25, 0.75]]),
            "expressions": [["1/4", "1/4", "3/4"], ["3/4", "1/4", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.25, 0.0], [0.0, 0.75, 0.0]]),
            "expressions": [["0", "1/4", "z"], ["0", "3/4", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.5, 0.0], [0.0, 0.0, 0.0], [0.0, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x", "1/2", "0"],
                ["-x", "0", "0"],
                ["x", "1/2", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [
                    [0.25, 0.0, 0.25],
                    [0.75, 0.5, 0.25],
                    [0.75, 0.0, 0.75],
                    [0.25, 0.5, 0.75],
                ]
            ),
            "expressions": [
                ["1/4", "y", "1/4"],
                ["3/4", "-y+1/2", "1/4"],
                ["3/4", "-y", "3/4"],
                ["1/4", "y+1/2", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "y", "z"],
                ["0", "-y+1/2", "z"],
                ["0", "y+1/2", "-z"],
                ["0", "-y", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.25, 0.0], [0.0, 0.25, 0.0], [0.0, 0.75, 0.0], [0.0, 0.75, 0.0]]
            ),
            "expressions": [
                ["x", "1/4", "z"],
                ["-x", "1/4", "z"],
                ["-x", "3/4", "-z"],
                ["x", "3/4", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y+1/2", "z"],
                ["-x", "y+1/2", "-z"],
                ["x", "-y", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y+1/2", "-z"],
                ["x", "-y+1/2", "z"],
                ["-x", "y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    75: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    76: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["-y", "x", "z+1/4"],
                ["y", "-x", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    77: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "z"], ["1/2", "1/2", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z+1/2"],
                ["y", "-x", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    78: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.75], [0.0, 0.0, 0.25]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["-y", "x", "z+3/4"],
                ["y", "-x", "z+1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    79: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    80: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.5, 0.25]]),
            "expressions": [["0", "0", "z"], ["0", "1/2", "z+1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.0, 0.5, 0.25], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y+1/2", "z+1/2"],
                ["-y", "x+1/2", "z+1/4"],
                ["y+1/2", "-x", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    81: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "z"], ["1/2", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    82: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.25]]),
            "expressions": [["0", "1/2", "1/4"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.75]]),
            "expressions": [["0", "1/2", "3/4"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    83: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "1/2"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "z"], ["1/2", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-y", "x", "0"],
                ["y", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "k": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "y", "1/2"],
                ["-x", "-y", "1/2"],
                ["-y", "x", "1/2"],
                ["y", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    84: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "1/2"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.5, 0.5, 0.25], [0.5, 0.5, 0.75]]),
            "expressions": [["1/2", "1/2", "1/4"], ["1/2", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "z+1/2"],
                ["0", "0", "-z"],
                ["0", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.5, 0.5, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "z+1/2"],
                ["1/2", "1/2", "-z"],
                ["1/2", "1/2", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.0], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z+1/2"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-y", "x", "1/2"],
                ["y", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z+1/2"],
                ["y", "-x", "z+1/2"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["y", "-x", "-z+1/2"],
                ["-y", "x", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    85: {
        "a": {
            "constants": array([[0.5, 0.5, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["1/2", "1/2", "0"], ["0", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["1/2", "1/2", "1/2"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "z"], ["0", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                ]
            ),
            "expressions": [
                ["1/4", "3/4", "0"],
                ["3/4", "1/4", "0"],
                ["3/4", "3/4", "0"],
                ["1/4", "1/4", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.25, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.75, 0.75, 0.5],
                    [0.25, 0.25, 0.5],
                ]
            ),
            "expressions": [
                ["1/4", "3/4", "1/2"],
                ["3/4", "1/4", "1/2"],
                ["3/4", "3/4", "1/2"],
                ["1/4", "1/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [[0.5, 0.5, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["1/2", "1/2", "z"],
                ["0", "0", "z"],
                ["0", "0", "-z"],
                ["1/2", "1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                ]
            ),
            "expressions": [
                ["x+1/4", "y+3/4", "z"],
                ["-x+3/4", "-y+1/4", "z"],
                ["-y+3/4", "x+3/4", "z"],
                ["y+1/4", "-x+1/4", "z"],
                ["-x+1/4", "-y+3/4", "-z"],
                ["x+3/4", "y+1/4", "-z"],
                ["y+3/4", "-x+3/4", "-z"],
                ["-y+1/4", "x+1/4", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    86: {
        "a": {
            "constants": array([[0.5, 0.5, 0.5], [0.0, 0.0, 0.0]]),
            "expressions": [["1/2", "1/2", "1/2"], ["0", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["1/2", "1/2", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "1/4"],
                ["3/4", "3/4", "1/4"],
                ["1/4", "3/4", "3/4"],
                ["3/4", "1/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [
                    [0.25, 0.25, 0.75],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "3/4"],
                ["3/4", "3/4", "3/4"],
                ["1/4", "3/4", "1/4"],
                ["3/4", "1/4", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.5, 0.25], [0.0, 0.5, 0.75], [0.5, 0.0, 0.25], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "1/2", "z+1/4"],
                ["0", "1/2", "z+3/4"],
                ["1/2", "0", "-z+1/4"],
                ["1/2", "0", "-z+3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [[0.5, 0.5, 0.25], [0.0, 0.0, 0.75], [0.0, 0.0, 0.25], [0.5, 0.5, 0.75]]
            ),
            "expressions": [
                ["1/2", "1/2", "z+1/4"],
                ["0", "0", "z+3/4"],
                ["0", "0", "-z+1/4"],
                ["1/2", "1/2", "-z+3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["x+1/4", "y+1/4", "z+1/4"],
                ["-x+3/4", "-y+3/4", "z+1/4"],
                ["-y+1/4", "x+3/4", "z+3/4"],
                ["y+3/4", "-x+1/4", "z+3/4"],
                ["-x+1/4", "-y+1/4", "-z+1/4"],
                ["x+3/4", "y+3/4", "-z+1/4"],
                ["y+1/4", "-x+3/4", "-z+3/4"],
                ["-y+3/4", "x+1/4", "-z+3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    87: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.25], [0.5, 0.0, 0.25]]),
            "expressions": [["0", "1/2", "1/4"], ["1/2", "0", "1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.25, 0.75, 0.25],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "1/4"],
                ["3/4", "3/4", "1/4"],
                ["3/4", "1/4", "1/4"],
                ["1/4", "3/4", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-y", "x", "0"],
                ["y", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    88: {
        "a": {
            "constants": array([[0.0, 0.5, 0.25], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "1/4"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.75], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "1/2", "3/4"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.25, 0.125],
                    [0.5, 0.25, 0.625],
                    [0.75, 0.5, 0.375],
                    [0.75, 0.0, 0.875],
                ]
            ),
            "expressions": [
                ["0", "1/4", "1/8"],
                ["1/2", "1/4", "5/8"],
                ["3/4", "1/2", "3/8"],
                ["3/4", "0", "7/8"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.25, 0.625],
                    [0.5, 0.25, 0.125],
                    [0.75, 0.5, 0.875],
                    [0.75, 0.0, 0.375],
                ]
            ),
            "expressions": [
                ["0", "1/4", "5/8"],
                ["1/2", "1/4", "1/8"],
                ["3/4", "1/2", "7/8"],
                ["3/4", "0", "3/8"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.5, 0.125],
                    [0.5, 0.5, 0.375],
                    [0.0, 0.0, 0.125],
                    [0.5, 0.0, 0.875],
                ]
            ),
            "expressions": [
                ["0", "1/2", "z+1/8"],
                ["1/2", "1/2", "z+3/8"],
                ["0", "0", "-z+1/8"],
                ["1/2", "0", "-z+7/8"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.25, 0.125],
                    [0.5, 0.25, 0.625],
                    [0.75, 0.5, 0.375],
                    [0.75, 0.0, 0.875],
                    [0.0, 0.25, 0.125],
                    [0.5, 0.25, 0.625],
                    [0.25, 0.0, 0.875],
                    [0.25, 0.5, 0.375],
                ]
            ),
            "expressions": [
                ["x", "y+1/4", "z+1/8"],
                ["-x+1/2", "-y+1/4", "z+5/8"],
                ["-y+3/4", "x+1/2", "z+3/8"],
                ["y+3/4", "-x", "z+7/8"],
                ["-x", "-y+1/4", "-z+1/8"],
                ["x+1/2", "y+1/4", "-z+5/8"],
                ["y+1/4", "-x", "-z+7/8"],
                ["-y+1/4", "x+1/2", "-z+3/8"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    89: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "0"], ["0", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.5, 0.0, 0.5], [0.0, 0.5, 0.5]]),
            "expressions": [["1/2", "0", "1/2"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "z"], ["1/2", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x", "-x", "0"],
                ["-x", "x", "0"],
                ["x", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "x", "1/2"],
                ["-x", "-x", "1/2"],
                ["-x", "x", "1/2"],
                ["x", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "l": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x", "0", "0"],
                ["0", "x", "0"],
                ["0", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "m": {
            "constants": array(
                [[0.0, 0.5, 0.5], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "1/2", "1/2"],
                ["-x", "1/2", "1/2"],
                ["1/2", "x", "1/2"],
                ["1/2", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "n": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "0", "1/2"],
                ["-x", "0", "1/2"],
                ["0", "x", "1/2"],
                ["0", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "o": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "1/2", "0"],
                ["-x", "1/2", "0"],
                ["1/2", "x", "0"],
                ["1/2", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "p": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
                ["y", "x", "-z"],
                ["-y", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    90: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "-z"],
                ["0", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x", "-x", "0"],
                ["-x+1/2", "x+1/2", "0"],
                ["x+1/2", "-x+1/2", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "x", "1/2"],
                ["-x", "-x", "1/2"],
                ["-x+1/2", "x+1/2", "1/2"],
                ["x+1/2", "-x+1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y+1/2", "x+1/2", "z"],
                ["y+1/2", "-x+1/2", "z"],
                ["-x+1/2", "y+1/2", "-z"],
                ["x+1/2", "-y+1/2", "-z"],
                ["y", "x", "-z"],
                ["-y", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    91: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "y", "0"],
                ["0", "-y", "1/2"],
                ["-y", "0", "1/4"],
                ["y", "0", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "b": {
            "constants": array(
                [[0.5, 0.0, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.25], [0.0, 0.5, 0.75]]
            ),
            "expressions": [
                ["1/2", "y", "0"],
                ["1/2", "-y", "1/2"],
                ["-y", "1/2", "1/4"],
                ["y", "1/2", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.375],
                    [0.0, 0.0, 0.875],
                    [0.0, 0.0, 0.625],
                    [0.0, 0.0, 0.125],
                ]
            ),
            "expressions": [
                ["x", "x", "3/8"],
                ["-x", "-x", "7/8"],
                ["-x", "x", "5/8"],
                ["x", "-x", "1/8"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.25],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["-y", "x", "z+1/4"],
                ["y", "-x", "z+3/4"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z+1/2"],
                ["y", "x", "-z+3/4"],
                ["-y", "-x", "-z+1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    92: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.5, 0.5, 0.25], [0.5, 0.5, 0.75]]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x", "-x", "1/2"],
                ["-x+1/2", "x+1/2", "1/4"],
                ["x+1/2", "-x+1/2", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "b": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.25],
                    [0.5, 0.5, 0.75],
                    [0.5, 0.5, 0.25],
                    [0.5, 0.5, 0.75],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["-y+1/2", "x+1/2", "z+1/4"],
                ["y+1/2", "-x+1/2", "z+3/4"],
                ["-x+1/2", "y+1/2", "-z+1/4"],
                ["x+1/2", "-y+1/2", "-z+3/4"],
                ["y", "x", "-z"],
                ["-y", "-x", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    93: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "1/2"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.5, 0.5, 0.25], [0.5, 0.5, 0.75]]),
            "expressions": [["1/2", "1/2", "1/4"], ["1/2", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "z+1/2"],
                ["0", "0", "-z"],
                ["0", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.5, 0.5, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "z+1/2"],
                ["1/2", "1/2", "-z"],
                ["1/2", "1/2", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.0], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z+1/2"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x", "0", "0"],
                ["0", "x", "1/2"],
                ["0", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [[0.0, 0.5, 0.5], [0.0, 0.5, 0.5], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "1/2", "1/2"],
                ["-x", "1/2", "1/2"],
                ["1/2", "x", "0"],
                ["1/2", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "l": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "1/2"],
                ["-x", "0", "1/2"],
                ["0", "x", "0"],
                ["0", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "m": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "1/2", "0"],
                ["-x", "1/2", "0"],
                ["1/2", "x", "1/2"],
                ["1/2", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "n": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "x", "1/4"],
                ["-x", "-x", "1/4"],
                ["-x", "x", "3/4"],
                ["x", "-x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "o": {
            "constants": array(
                [[0.0, 0.0, 0.75], [0.0, 0.0, 0.75], [0.0, 0.0, 0.25], [0.0, 0.0, 0.25]]
            ),
            "expressions": [
                ["x", "x", "3/4"],
                ["-x", "-x", "3/4"],
                ["-x", "x", "1/4"],
                ["x", "-x", "1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "p": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z+1/2"],
                ["y", "-x", "z+1/2"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
                ["y", "x", "-z+1/2"],
                ["-y", "-x", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    94: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["1/2", "1/2", "z+1/2"],
                ["1/2", "1/2", "-z+1/2"],
                ["0", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["0", "1/2", "z+1/2"],
                ["1/2", "0", "-z+1/2"],
                ["1/2", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x", "-x", "0"],
                ["-x+1/2", "x+1/2", "1/2"],
                ["x+1/2", "-x+1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["x", "x", "1/2"],
                ["-x", "-x", "1/2"],
                ["-x+1/2", "x+1/2", "0"],
                ["x+1/2", "-x+1/2", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y+1/2", "x+1/2", "z+1/2"],
                ["y+1/2", "-x+1/2", "z+1/2"],
                ["-x+1/2", "y+1/2", "-z+1/2"],
                ["x+1/2", "-y+1/2", "-z+1/2"],
                ["y", "x", "-z"],
                ["-y", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    95: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.75], [0.0, 0.0, 0.25]]
            ),
            "expressions": [
                ["0", "y", "0"],
                ["0", "-y", "1/2"],
                ["-y", "0", "3/4"],
                ["y", "0", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "b": {
            "constants": array(
                [[0.5, 0.0, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.75], [0.0, 0.5, 0.25]]
            ),
            "expressions": [
                ["1/2", "y", "0"],
                ["1/2", "-y", "1/2"],
                ["-y", "1/2", "3/4"],
                ["y", "1/2", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.625],
                    [0.0, 0.0, 0.125],
                    [0.0, 0.0, 0.375],
                    [0.0, 0.0, 0.875],
                ]
            ),
            "expressions": [
                ["x", "x", "5/8"],
                ["-x", "-x", "1/8"],
                ["-x", "x", "3/8"],
                ["x", "-x", "7/8"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["-y", "x", "z+3/4"],
                ["y", "-x", "z+1/4"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z+1/2"],
                ["y", "x", "-z+1/4"],
                ["-y", "-x", "-z+3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    96: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.5, 0.5, 0.75], [0.5, 0.5, 0.25]]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x", "-x", "1/2"],
                ["-x+1/2", "x+1/2", "3/4"],
                ["x+1/2", "-x+1/2", "1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "b": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.75],
                    [0.5, 0.5, 0.25],
                    [0.5, 0.5, 0.75],
                    [0.5, 0.5, 0.25],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z+1/2"],
                ["-y+1/2", "x+1/2", "z+3/4"],
                ["y+1/2", "-x+1/2", "z+1/4"],
                ["-x+1/2", "y+1/2", "-z+3/4"],
                ["x+1/2", "-y+1/2", "-z+1/4"],
                ["y", "x", "-z"],
                ["-y", "-x", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    97: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.25], [0.5, 0.0, 0.25]]),
            "expressions": [["0", "1/2", "1/4"], ["1/2", "0", "1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x", "-x", "0"],
                ["-x", "x", "0"],
                ["x", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x", "0", "0"],
                ["0", "x", "0"],
                ["0", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "0", "1/2"],
                ["-x", "0", "1/2"],
                ["0", "x", "1/2"],
                ["0", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.5, 0.25], [0.0, 0.5, 0.25], [0.5, 0.0, 0.25], [0.5, 0.0, 0.25]]
            ),
            "expressions": [
                ["x", "x+1/2", "1/4"],
                ["-x", "-x+1/2", "1/4"],
                ["-x+1/2", "x", "1/4"],
                ["x+1/2", "-x", "1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
                ["y", "x", "-z"],
                ["-y", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    98: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.5, 0.25]]),
            "expressions": [["0", "0", "0"], ["0", "1/2", "1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.5, 0.75]]),
            "expressions": [["0", "0", "1/2"], ["0", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.5, 0.25], [0.5, 0.0, 0.75], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "1/2", "z+1/4"],
                ["1/2", "0", "-z+3/4"],
                ["1/2", "1/2", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.0, 0.5, 0.25], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x+1/2", "-x+1/2", "1/2"],
                ["-x", "x+1/2", "1/4"],
                ["x+1/2", "-x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.0, 0.5, 0.25], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["-x", "x", "0"],
                ["x+1/2", "-x+1/2", "1/2"],
                ["-x", "-x+1/2", "1/4"],
                ["x+1/2", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.25, 0.125],
                    [0.5, 0.25, 0.625],
                    [0.75, 0.5, 0.375],
                    [0.75, 0.0, 0.875],
                ]
            ),
            "expressions": [
                ["x", "1/4", "1/8"],
                ["-x+1/2", "1/4", "5/8"],
                ["3/4", "x+1/2", "3/8"],
                ["3/4", "-x", "7/8"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.0, 0.75],
                    [0.5, 0.0, 0.75],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y+1/2", "z+1/2"],
                ["-y", "x+1/2", "z+1/4"],
                ["y+1/2", "-x", "z+3/4"],
                ["-x+1/2", "y", "-z+3/4"],
                ["x", "-y+1/2", "-z+1/4"],
                ["y+1/2", "x+1/2", "-z+1/2"],
                ["-y", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    99: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "z"], ["0", "1/2", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x", "z"],
                ["-x", "-x", "z"],
                ["-x", "x", "z"],
                ["x", "-x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["-x", "0", "z"],
                ["0", "x", "z"],
                ["0", "-x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "1/2", "z"],
                ["-x", "1/2", "z"],
                ["1/2", "x", "z"],
                ["1/2", "-x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
                ["-y", "-x", "z"],
                ["y", "x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    100: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "z"], ["1/2", "1/2", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "z"], ["0", "1/2", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x+1/2", "z"],
                ["-x", "-x+1/2", "z"],
                ["-x+1/2", "x", "z"],
                ["x+1/2", "-x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["x+1/2", "-y+1/2", "z"],
                ["-x+1/2", "y+1/2", "z"],
                ["-y+1/2", "-x+1/2", "z"],
                ["y+1/2", "x+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    101: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "z"], ["1/2", "1/2", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z+1/2"],
                ["0", "1/2", "z+1/2"],
                ["1/2", "0", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "x", "z"],
                ["-x", "-x", "z"],
                ["-x", "x", "z+1/2"],
                ["x", "-x", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z+1/2"],
                ["y", "-x", "z+1/2"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z+1/2"],
                ["-y", "-x", "z"],
                ["y", "x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    102: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "z"], ["1/2", "1/2", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["0", "1/2", "z+1/2"],
                ["1/2", "0", "z+1/2"],
                ["1/2", "0", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "x", "z"],
                ["-x", "-x", "z"],
                ["-x+1/2", "x+1/2", "z+1/2"],
                ["x+1/2", "-x+1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y+1/2", "x+1/2", "z+1/2"],
                ["y+1/2", "-x+1/2", "z+1/2"],
                ["x+1/2", "-y+1/2", "z+1/2"],
                ["-x+1/2", "y+1/2", "z+1/2"],
                ["-y", "-x", "z"],
                ["y", "x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    103: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "z"], ["1/2", "1/2", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z"],
                ["0", "1/2", "z+1/2"],
                ["1/2", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z+1/2"],
                ["-y", "-x", "z+1/2"],
                ["y", "x", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    104: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "z"], ["1/2", "1/2", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z"],
                ["1/2", "0", "z+1/2"],
                ["0", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["x+1/2", "-y+1/2", "z+1/2"],
                ["-x+1/2", "y+1/2", "z+1/2"],
                ["-y+1/2", "-x+1/2", "z+1/2"],
                ["y+1/2", "x+1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    105: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "z"], ["1/2", "1/2", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["-x", "0", "z"],
                ["0", "x", "z+1/2"],
                ["0", "-x", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "e": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "1/2", "z"],
                ["-x", "1/2", "z"],
                ["1/2", "x", "z+1/2"],
                ["1/2", "-x", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z+1/2"],
                ["y", "-x", "z+1/2"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
                ["-y", "-x", "z+1/2"],
                ["y", "x", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    106: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "z+1/2"],
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.5], [0.5, 0.0, 0.0], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z+1/2"],
                ["1/2", "0", "z"],
                ["0", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z+1/2"],
                ["y", "-x", "z+1/2"],
                ["x+1/2", "-y+1/2", "z"],
                ["-x+1/2", "y+1/2", "z"],
                ["-y+1/2", "-x+1/2", "z+1/2"],
                ["y+1/2", "x+1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    107: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x", "z"],
                ["-x", "-x", "z"],
                ["-x", "x", "z"],
                ["x", "-x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["-x", "0", "z"],
                ["0", "x", "z"],
                ["0", "-x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
                ["-y", "-x", "z"],
                ["y", "x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    108: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "z"], ["0", "1/2", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x+1/2", "z"],
                ["-x", "-x+1/2", "z"],
                ["-x+1/2", "x", "z"],
                ["x+1/2", "-x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z+1/2"],
                ["-y", "-x", "z+1/2"],
                ["y", "x", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    109: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.5, 0.25]]),
            "expressions": [["0", "0", "z"], ["0", "1/2", "z+1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.0, 0.5, 0.25], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "y", "z"],
                ["1/2", "-y+1/2", "z+1/2"],
                ["-y", "1/2", "z+1/4"],
                ["y+1/2", "0", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.0, 0.75],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y+1/2", "z+1/2"],
                ["-y", "x+1/2", "z+1/4"],
                ["y+1/2", "-x", "z+3/4"],
                ["x", "-y", "z"],
                ["-x+1/2", "y+1/2", "z+1/2"],
                ["-y", "-x+1/2", "z+1/4"],
                ["y+1/2", "x", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    110: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.5, 0.25], [0.0, 0.0, 0.5], [0.0, 0.5, 0.75]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "1/2", "z+1/4"],
                ["0", "0", "z+1/2"],
                ["0", "1/2", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.0, 0.75],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.5, 0.75],
                    [0.5, 0.0, 0.25],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x+1/2", "-y+1/2", "z+1/2"],
                ["-y", "x+1/2", "z+1/4"],
                ["y+1/2", "-x", "z+3/4"],
                ["x", "-y", "z+1/2"],
                ["-x+1/2", "y+1/2", "z"],
                ["-y", "-x+1/2", "z+3/4"],
                ["y+1/2", "x", "z+1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    111: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "0"], ["0", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.5, 0.0, 0.5], [0.0, 0.5, 0.5]]),
            "expressions": [["1/2", "0", "1/2"], ["0", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "z"], ["1/2", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x", "0", "0"],
                ["0", "-x", "0"],
                ["0", "x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.5, 0.5], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "1/2", "1/2"],
                ["-x", "1/2", "1/2"],
                ["1/2", "-x", "1/2"],
                ["1/2", "x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "0", "1/2"],
                ["-x", "0", "1/2"],
                ["0", "-x", "1/2"],
                ["0", "x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "l": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "1/2", "0"],
                ["-x", "1/2", "0"],
                ["1/2", "-x", "0"],
                ["1/2", "x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "m": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "-z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "n": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x", "z"],
                ["-x", "-x", "z"],
                ["x", "-x", "-z"],
                ["-x", "x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "o": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
                ["-y", "-x", "z"],
                ["y", "x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    112: {
        "a": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.0, 0.25], [0.0, 0.5, 0.75]]),
            "expressions": [["1/2", "0", "1/4"], ["0", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.5, 0.25], [0.5, 0.5, 0.75]]),
            "expressions": [["1/2", "1/2", "1/4"], ["1/2", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.25], [0.5, 0.0, 0.75]]),
            "expressions": [["0", "1/2", "1/4"], ["1/2", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "0", "1/4"],
                ["-x", "0", "1/4"],
                ["0", "-x", "3/4"],
                ["0", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [[0.5, 0.0, 0.25], [0.5, 0.0, 0.25], [0.0, 0.5, 0.75], [0.0, 0.5, 0.75]]
            ),
            "expressions": [
                ["1/2", "y", "1/4"],
                ["1/2", "-y", "1/4"],
                ["y", "1/2", "3/4"],
                ["-y", "1/2", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.5, 0.25], [0.0, 0.5, 0.25], [0.5, 0.0, 0.75], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "1/2", "1/4"],
                ["-x", "1/2", "1/4"],
                ["1/2", "-x", "3/4"],
                ["1/2", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "y", "1/4"],
                ["0", "-y", "1/4"],
                ["y", "0", "3/4"],
                ["-y", "0", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y"},
        },
        "k": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z"],
                ["0", "0", "-z+1/2"],
                ["0", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "l": {
            "constants": array(
                [[0.5, 0.5, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "-z"],
                ["1/2", "1/2", "-z+1/2"],
                ["1/2", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "m": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "-z"],
                ["0", "1/2", "-z+1/2"],
                ["1/2", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "n": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["-x", "y", "-z+1/2"],
                ["x", "-y", "-z+1/2"],
                ["-y", "-x", "z+1/2"],
                ["y", "x", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    113: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z"],
                ["1/2", "1/2", "-z"],
                ["1/2", "1/2", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "e": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x+1/2", "z"],
                ["-x", "-x+1/2", "z"],
                ["x+1/2", "-x", "-z"],
                ["-x+1/2", "x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["-x+1/2", "y+1/2", "-z"],
                ["x+1/2", "-y+1/2", "-z"],
                ["-y+1/2", "-x+1/2", "z"],
                ["y+1/2", "x+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    114: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z"],
                ["1/2", "1/2", "-z+1/2"],
                ["1/2", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "-z"],
                ["1/2", "0", "-z+1/2"],
                ["0", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["-x+1/2", "y+1/2", "-z+1/2"],
                ["x+1/2", "-y+1/2", "-z+1/2"],
                ["-y+1/2", "-x+1/2", "z+1/2"],
                ["y+1/2", "x+1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    115: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "z"], ["1/2", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x", "-x", "0"],
                ["x", "-x", "0"],
                ["-x", "x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "x", "1/2"],
                ["-x", "-x", "1/2"],
                ["x", "-x", "1/2"],
                ["-x", "x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["-x", "0", "z"],
                ["0", "-x", "-z"],
                ["0", "x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "k": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "1/2", "z"],
                ["-x", "1/2", "z"],
                ["1/2", "-x", "-z"],
                ["1/2", "x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
                ["y", "x", "-z"],
                ["-y", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    116: {
        "a": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.25], [0.5, 0.5, 0.75]]),
            "expressions": [["1/2", "1/2", "1/4"], ["1/2", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "x", "1/4"],
                ["-x", "-x", "1/4"],
                ["x", "-x", "3/4"],
                ["-x", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.75], [0.0, 0.0, 0.75], [0.0, 0.0, 0.25], [0.0, 0.0, 0.25]]
            ),
            "expressions": [
                ["x", "x", "3/4"],
                ["-x", "-x", "3/4"],
                ["x", "-x", "1/4"],
                ["-x", "x", "1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z"],
                ["0", "0", "z+1/2"],
                ["0", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.5, 0.5, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "-z"],
                ["1/2", "1/2", "z+1/2"],
                ["1/2", "1/2", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "-z"],
                ["0", "1/2", "z+1/2"],
                ["1/2", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z+1/2"],
                ["y", "x", "-z+1/2"],
                ["-y", "-x", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    117: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "1/2"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z"],
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "-z"],
                ["1/2", "0", "z"],
                ["0", "1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x+1/2", "0"],
                ["-x", "-x+1/2", "0"],
                ["x+1/2", "-x", "0"],
                ["-x+1/2", "x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.5, 0.5], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "x+1/2", "1/2"],
                ["-x", "-x+1/2", "1/2"],
                ["x+1/2", "-x", "1/2"],
                ["-x+1/2", "x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["x+1/2", "-y+1/2", "z"],
                ["-x+1/2", "y+1/2", "z"],
                ["y+1/2", "x+1/2", "-z"],
                ["-y+1/2", "-x+1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    118: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.25], [0.5, 0.0, 0.75]]),
            "expressions": [["0", "1/2", "1/4"], ["1/2", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.75], [0.5, 0.0, 0.25]]),
            "expressions": [["0", "1/2", "3/4"], ["1/2", "0", "1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z"],
                ["1/2", "1/2", "z+1/2"],
                ["1/2", "1/2", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.5, 0.25], [0.0, 0.5, 0.25], [0.5, 0.0, 0.75], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "-x+1/2", "1/4"],
                ["-x", "x+1/2", "1/4"],
                ["-x+1/2", "-x", "3/4"],
                ["x+1/2", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.5, 0.25], [0.0, 0.5, 0.25], [0.5, 0.0, 0.75], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "x+1/2", "1/4"],
                ["-x", "-x+1/2", "1/4"],
                ["x+1/2", "-x", "3/4"],
                ["-x+1/2", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "-z"],
                ["1/2", "0", "z+1/2"],
                ["0", "1/2", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["x+1/2", "-y+1/2", "z+1/2"],
                ["-x+1/2", "y+1/2", "z+1/2"],
                ["y+1/2", "x+1/2", "-z+1/2"],
                ["-y+1/2", "-x+1/2", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    119: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.25]]),
            "expressions": [["0", "1/2", "1/4"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.75]]),
            "expressions": [["0", "1/2", "3/4"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "z"], ["1/2", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x", "-x", "0"],
                ["x", "-x", "0"],
                ["-x", "x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.5, 0.25], [0.0, 0.5, 0.25], [0.5, 0.0, 0.75], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "x+1/2", "1/4"],
                ["-x", "-x+1/2", "1/4"],
                ["x+1/2", "-x", "3/4"],
                ["-x+1/2", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["-x", "0", "z"],
                ["0", "-x", "-z"],
                ["0", "x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
                ["y", "x", "-z"],
                ["-y", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    120: {
        "a": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.25], [0.0, 0.5, 0.75]]),
            "expressions": [["0", "1/2", "1/4"], ["0", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["x", "x", "1/4"],
                ["-x", "-x", "1/4"],
                ["x", "-x", "3/4"],
                ["-x", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z"],
                ["0", "0", "z+1/2"],
                ["0", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "-z"],
                ["0", "1/2", "z+1/2"],
                ["1/2", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x+1/2", "0"],
                ["-x", "-x+1/2", "0"],
                ["x+1/2", "-x", "0"],
                ["-x+1/2", "x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z+1/2"],
                ["y", "x", "-z+1/2"],
                ["-y", "-x", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    121: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.25], [0.0, 0.5, 0.75]]),
            "expressions": [["0", "1/2", "1/4"], ["0", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x", "0", "0"],
                ["0", "-x", "0"],
                ["0", "x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "0", "1/2"],
                ["-x", "0", "1/2"],
                ["0", "-x", "1/2"],
                ["0", "x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "-z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x", "z"],
                ["-x", "-x", "z"],
                ["x", "-x", "-z"],
                ["-x", "x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
                ["-y", "-x", "z"],
                ["y", "x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    122: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.0, 0.75]]),
            "expressions": [["0", "0", "0"], ["1/2", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.0, 0.25]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "0", "1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.0, 0.75], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z"],
                ["1/2", "0", "-z+3/4"],
                ["1/2", "0", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.25, 0.125],
                    [0.0, 0.75, 0.125],
                    [0.25, 0.0, 0.875],
                    [0.75, 0.0, 0.875],
                ]
            ),
            "expressions": [
                ["x", "1/4", "1/8"],
                ["-x", "3/4", "1/8"],
                ["1/4", "-x", "7/8"],
                ["3/4", "x", "7/8"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.0, 0.75],
                    [0.5, 0.0, 0.75],
                    [0.5, 0.0, 0.75],
                    [0.5, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["-x+1/2", "y", "-z+3/4"],
                ["x+1/2", "-y", "-z+3/4"],
                ["-y+1/2", "-x", "z+3/4"],
                ["y+1/2", "x", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    123: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "1/2"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "1/2", "z"], ["1/2", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x", "-x", "0"],
                ["-x", "x", "0"],
                ["x", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "x", "1/2"],
                ["-x", "-x", "1/2"],
                ["-x", "x", "1/2"],
                ["x", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "l": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x", "0", "0"],
                ["0", "x", "0"],
                ["0", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "m": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "0", "1/2"],
                ["-x", "0", "1/2"],
                ["0", "x", "1/2"],
                ["0", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "n": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "1/2", "0"],
                ["-x", "1/2", "0"],
                ["1/2", "x", "0"],
                ["1/2", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "o": {
            "constants": array(
                [[0.0, 0.5, 0.5], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "1/2", "1/2"],
                ["-x", "1/2", "1/2"],
                ["1/2", "x", "1/2"],
                ["1/2", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "p": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-y", "x", "0"],
                ["y", "-x", "0"],
                ["-x", "y", "0"],
                ["x", "-y", "0"],
                ["y", "x", "0"],
                ["-y", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "q": {
            "constants": array(
                [
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "1/2"],
                ["-x", "-y", "1/2"],
                ["-y", "x", "1/2"],
                ["y", "-x", "1/2"],
                ["-x", "y", "1/2"],
                ["x", "-y", "1/2"],
                ["y", "x", "1/2"],
                ["-y", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "r": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "x", "z"],
                ["-x", "-x", "z"],
                ["-x", "x", "z"],
                ["x", "-x", "z"],
                ["-x", "x", "-z"],
                ["x", "-x", "-z"],
                ["x", "x", "-z"],
                ["-x", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "s": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["-x", "0", "z"],
                ["0", "x", "z"],
                ["0", "-x", "z"],
                ["-x", "0", "-z"],
                ["x", "0", "-z"],
                ["0", "x", "-z"],
                ["0", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "t": {
            "constants": array(
                [
                    [0.0, 0.5, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "1/2", "z"],
                ["-x", "1/2", "z"],
                ["1/2", "x", "z"],
                ["1/2", "-x", "z"],
                ["-x", "1/2", "-z"],
                ["x", "1/2", "-z"],
                ["1/2", "x", "-z"],
                ["1/2", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "translations": array([]),
        "u": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
                ["y", "x", "-z"],
                ["-y", "-x", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
                ["-y", "-x", "z"],
                ["y", "x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
    },
    124: {
        "a": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.5, 0.25], [0.5, 0.5, 0.75]]),
            "expressions": [["1/2", "1/2", "1/4"], ["1/2", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "0"],
                ["1/2", "0", "0"],
                ["0", "1/2", "1/2"],
                ["1/2", "0", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [[0.0, 0.5, 0.25], [0.5, 0.0, 0.25], [0.0, 0.5, 0.75], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "1/2", "1/4"],
                ["1/2", "0", "1/4"],
                ["0", "1/2", "3/4"],
                ["1/2", "0", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z+1/2"],
                ["0", "0", "-z"],
                ["0", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.5, 0.5, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "-z+1/2"],
                ["1/2", "1/2", "-z"],
                ["1/2", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z"],
                ["0", "1/2", "-z+1/2"],
                ["1/2", "0", "-z+1/2"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z"],
                ["0", "1/2", "z+1/2"],
                ["1/2", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "x", "1/4"],
                ["-x", "-x", "1/4"],
                ["-x", "x", "1/4"],
                ["x", "-x", "1/4"],
                ["-x", "-x", "3/4"],
                ["x", "x", "3/4"],
                ["x", "-x", "3/4"],
                ["-x", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "0", "1/4"],
                ["-x", "0", "1/4"],
                ["0", "x", "1/4"],
                ["0", "-x", "1/4"],
                ["-x", "0", "3/4"],
                ["x", "0", "3/4"],
                ["0", "-x", "3/4"],
                ["0", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.5, 0.25],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.0, 0.25],
                    [0.5, 0.0, 0.25],
                    [0.0, 0.5, 0.75],
                    [0.0, 0.5, 0.75],
                    [0.5, 0.0, 0.75],
                    [0.5, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "1/2", "1/4"],
                ["-x", "1/2", "1/4"],
                ["1/2", "x", "1/4"],
                ["1/2", "-x", "1/4"],
                ["-x", "1/2", "3/4"],
                ["x", "1/2", "3/4"],
                ["1/2", "-x", "3/4"],
                ["1/2", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "m": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-y", "x", "0"],
                ["y", "-x", "0"],
                ["-x", "y", "1/2"],
                ["x", "-y", "1/2"],
                ["y", "x", "1/2"],
                ["-y", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "n": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["-x", "y", "-z+1/2"],
                ["x", "-y", "-z+1/2"],
                ["y", "x", "-z+1/2"],
                ["-y", "-x", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z+1/2"],
                ["-y", "-x", "z+1/2"],
                ["y", "x", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    125: {
        "a": {
            "constants": array([[0.5, 0.5, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["1/2", "1/2", "0"], ["0", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["1/2", "1/2", "1/2"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "1/2"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "0"],
                ["3/4", "3/4", "0"],
                ["3/4", "1/4", "0"],
                ["1/4", "3/4", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [
                    [0.25, 0.25, 0.5],
                    [0.75, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.25, 0.75, 0.5],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "1/2"],
                ["3/4", "3/4", "1/2"],
                ["3/4", "1/4", "1/2"],
                ["1/4", "3/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [[0.5, 0.5, 0.0], [0.5, 0.5, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "-z"],
                ["0", "0", "-z"],
                ["0", "0", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["x+1/4", "x+1/4", "0"],
                ["-x+3/4", "-x+3/4", "0"],
                ["-x+3/4", "x+1/4", "0"],
                ["x+1/4", "-x+3/4", "0"],
                ["-x+1/4", "-x+1/4", "0"],
                ["x+3/4", "x+3/4", "0"],
                ["x+3/4", "-x+1/4", "0"],
                ["-x+1/4", "x+3/4", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [
                    [0.25, 0.25, 0.5],
                    [0.75, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.25, 0.75, 0.5],
                    [0.25, 0.25, 0.5],
                    [0.75, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.25, 0.75, 0.5],
                ]
            ),
            "expressions": [
                ["x+1/4", "x+1/4", "1/2"],
                ["-x+3/4", "-x+3/4", "1/2"],
                ["-x+3/4", "x+1/4", "1/2"],
                ["x+1/4", "-x+3/4", "1/2"],
                ["-x+1/4", "-x+1/4", "1/2"],
                ["x+3/4", "x+3/4", "1/2"],
                ["x+3/4", "-x+1/4", "1/2"],
                ["-x+1/4", "x+3/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [
                    [0.25, 0.5, 0.0],
                    [0.75, 0.5, 0.0],
                    [0.5, 0.25, 0.0],
                    [0.5, 0.75, 0.0],
                    [0.25, 0.0, 0.0],
                    [0.75, 0.0, 0.0],
                    [0.0, 0.25, 0.0],
                    [0.0, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["x+1/4", "1/2", "0"],
                ["-x+3/4", "1/2", "0"],
                ["1/2", "x+1/4", "0"],
                ["1/2", "-x+3/4", "0"],
                ["-x+1/4", "0", "0"],
                ["x+3/4", "0", "0"],
                ["0", "-x+1/4", "0"],
                ["0", "x+3/4", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "l": {
            "constants": array(
                [
                    [0.25, 0.5, 0.5],
                    [0.75, 0.5, 0.5],
                    [0.5, 0.25, 0.5],
                    [0.5, 0.75, 0.5],
                    [0.25, 0.0, 0.5],
                    [0.75, 0.0, 0.5],
                    [0.0, 0.25, 0.5],
                    [0.0, 0.75, 0.5],
                ]
            ),
            "expressions": [
                ["x+1/4", "1/2", "1/2"],
                ["-x+3/4", "1/2", "1/2"],
                ["1/2", "x+1/4", "1/2"],
                ["1/2", "-x+3/4", "1/2"],
                ["-x+1/4", "0", "1/2"],
                ["x+3/4", "0", "1/2"],
                ["0", "-x+1/4", "1/2"],
                ["0", "x+3/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "m": {
            "constants": array(
                [
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["x+1/4", "-x+1/4", "z"],
                ["-x+3/4", "x+3/4", "z"],
                ["x+3/4", "x+1/4", "z"],
                ["-x+1/4", "-x+3/4", "z"],
                ["-x+3/4", "-x+1/4", "-z"],
                ["x+1/4", "x+3/4", "-z"],
                ["-x+1/4", "x+1/4", "-z"],
                ["x+3/4", "-x+3/4", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "n": {
            "constants": array(
                [
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["x+1/4", "y+1/4", "z"],
                ["-x+3/4", "-y+3/4", "z"],
                ["-y+3/4", "x+1/4", "z"],
                ["y+1/4", "-x+3/4", "z"],
                ["-x+3/4", "y+1/4", "-z"],
                ["x+1/4", "-y+3/4", "-z"],
                ["y+1/4", "x+1/4", "-z"],
                ["-y+3/4", "-x+3/4", "-z"],
                ["-x+1/4", "-y+1/4", "-z"],
                ["x+3/4", "y+3/4", "-z"],
                ["y+3/4", "-x+1/4", "-z"],
                ["-y+1/4", "x+3/4", "-z"],
                ["x+3/4", "-y+1/4", "z"],
                ["-x+1/4", "y+3/4", "z"],
                ["-y+1/4", "-x+1/4", "z"],
                ["y+3/4", "x+3/4", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    126: {
        "a": {
            "constants": array([[0.5, 0.5, 0.5], [0.0, 0.0, 0.0]]),
            "expressions": [["1/2", "1/2", "1/2"], ["0", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["1/2", "1/2", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["1/2", "0", "0"],
                ["0", "1/2", "0"],
                ["0", "1/2", "1/2"],
                ["1/2", "0", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.5, 0.0, 0.25], [0.0, 0.5, 0.25], [0.5, 0.0, 0.75], [0.0, 0.5, 0.75]]
            ),
            "expressions": [
                ["1/2", "0", "1/4"],
                ["0", "1/2", "1/4"],
                ["1/2", "0", "3/4"],
                ["0", "1/2", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.5, 0.5, 0.25], [0.5, 0.5, 0.75], [0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["1/2", "1/2", "z+1/4"],
                ["1/2", "1/2", "-z+3/4"],
                ["0", "0", "-z+1/4"],
                ["0", "0", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.75],
                    [0.25, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.75, 0.75, 0.75],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "1/4"],
                ["3/4", "3/4", "1/4"],
                ["3/4", "1/4", "1/4"],
                ["1/4", "3/4", "1/4"],
                ["3/4", "1/4", "3/4"],
                ["1/4", "3/4", "3/4"],
                ["1/4", "1/4", "3/4"],
                ["3/4", "3/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [
                    [0.5, 0.0, 0.25],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.0, 0.75],
                    [0.0, 0.5, 0.75],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.0, 0.25],
                    [0.0, 0.5, 0.75],
                    [0.5, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["1/2", "0", "z+1/4"],
                ["0", "1/2", "z+1/4"],
                ["1/2", "0", "-z+3/4"],
                ["0", "1/2", "-z+3/4"],
                ["0", "1/2", "-z+1/4"],
                ["1/2", "0", "-z+1/4"],
                ["0", "1/2", "z+3/4"],
                ["1/2", "0", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [
                    [0.25, 0.25, 0.5],
                    [0.75, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.25, 0.75, 0.5],
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["x+1/4", "x+1/4", "1/2"],
                ["-x+3/4", "-x+3/4", "1/2"],
                ["-x+3/4", "x+1/4", "1/2"],
                ["x+1/4", "-x+3/4", "1/2"],
                ["-x+1/4", "-x+1/4", "0"],
                ["x+3/4", "x+3/4", "0"],
                ["x+3/4", "-x+1/4", "0"],
                ["-x+1/4", "x+3/4", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [
                    [0.25, 0.5, 0.5],
                    [0.75, 0.5, 0.5],
                    [0.5, 0.25, 0.5],
                    [0.5, 0.75, 0.5],
                    [0.25, 0.0, 0.0],
                    [0.75, 0.0, 0.0],
                    [0.0, 0.25, 0.0],
                    [0.0, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["x+1/4", "1/2", "1/2"],
                ["-x+3/4", "1/2", "1/2"],
                ["1/2", "x+1/4", "1/2"],
                ["1/2", "-x+3/4", "1/2"],
                ["-x+1/4", "0", "0"],
                ["x+3/4", "0", "0"],
                ["0", "-x+1/4", "0"],
                ["0", "x+3/4", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [
                    [0.25, 0.0, 0.5],
                    [0.75, 0.0, 0.5],
                    [0.0, 0.25, 0.5],
                    [0.0, 0.75, 0.5],
                    [0.25, 0.5, 0.0],
                    [0.75, 0.5, 0.0],
                    [0.5, 0.25, 0.0],
                    [0.5, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["x+1/4", "0", "1/2"],
                ["-x+3/4", "0", "1/2"],
                ["0", "x+1/4", "1/2"],
                ["0", "-x+3/4", "1/2"],
                ["-x+1/4", "1/2", "0"],
                ["x+3/4", "1/2", "0"],
                ["1/2", "-x+1/4", "0"],
                ["1/2", "x+3/4", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.75],
                    [0.25, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.75],
                    [0.25, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.75, 0.75, 0.75],
                ]
            ),
            "expressions": [
                ["x+1/4", "y+1/4", "z+1/4"],
                ["-x+3/4", "-y+3/4", "z+1/4"],
                ["-y+3/4", "x+1/4", "z+1/4"],
                ["y+1/4", "-x+3/4", "z+1/4"],
                ["-x+3/4", "y+1/4", "-z+3/4"],
                ["x+1/4", "-y+3/4", "-z+3/4"],
                ["y+1/4", "x+1/4", "-z+3/4"],
                ["-y+3/4", "-x+3/4", "-z+3/4"],
                ["-x+1/4", "-y+1/4", "-z+1/4"],
                ["x+3/4", "y+3/4", "-z+1/4"],
                ["y+3/4", "-x+1/4", "-z+1/4"],
                ["-y+1/4", "x+3/4", "-z+1/4"],
                ["x+3/4", "-y+1/4", "z+3/4"],
                ["-x+1/4", "y+3/4", "z+3/4"],
                ["-y+1/4", "-x+1/4", "z+3/4"],
                ["y+3/4", "x+3/4", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    127: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "1/2"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["1/2", "1/2", "-z"],
                ["0", "0", "-z"],
                ["1/2", "1/2", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z"],
                ["1/2", "0", "-z"],
                ["0", "1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x+1/2", "0"],
                ["-x", "-x+1/2", "0"],
                ["-x+1/2", "x", "0"],
                ["x+1/2", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.5, 0.5], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "x+1/2", "1/2"],
                ["-x", "-x+1/2", "1/2"],
                ["-x+1/2", "x", "1/2"],
                ["x+1/2", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-y", "x", "0"],
                ["y", "-x", "0"],
                ["-x+1/2", "y+1/2", "0"],
                ["x+1/2", "-y+1/2", "0"],
                ["y+1/2", "x+1/2", "0"],
                ["-y+1/2", "-x+1/2", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "1/2"],
                ["-x", "-y", "1/2"],
                ["-y", "x", "1/2"],
                ["y", "-x", "1/2"],
                ["-x+1/2", "y+1/2", "1/2"],
                ["x+1/2", "-y+1/2", "1/2"],
                ["y+1/2", "x+1/2", "1/2"],
                ["-y+1/2", "-x+1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.5, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.0, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["x", "x+1/2", "z"],
                ["-x", "-x+1/2", "z"],
                ["-x+1/2", "x", "z"],
                ["x+1/2", "-x", "z"],
                ["-x+1/2", "x", "-z"],
                ["x+1/2", "-x", "-z"],
                ["x", "x+1/2", "-z"],
                ["-x", "-x+1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["-x+1/2", "y+1/2", "-z"],
                ["x+1/2", "-y+1/2", "-z"],
                ["y+1/2", "x+1/2", "-z"],
                ["-y+1/2", "-x+1/2", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["x+1/2", "-y+1/2", "z"],
                ["-x+1/2", "y+1/2", "z"],
                ["-y+1/2", "-x+1/2", "z"],
                ["y+1/2", "x+1/2", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    128: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "0"],
                ["1/2", "0", "0"],
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.0, 0.5, 0.25], [0.5, 0.0, 0.25], [0.0, 0.5, 0.75], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "1/2", "1/4"],
                ["1/2", "0", "1/4"],
                ["0", "1/2", "3/4"],
                ["1/2", "0", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.0, 0.0, 0.0], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["1/2", "1/2", "-z+1/2"],
                ["0", "0", "-z"],
                ["1/2", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z"],
                ["1/2", "0", "-z+1/2"],
                ["0", "1/2", "-z+1/2"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z"],
                ["1/2", "0", "z+1/2"],
                ["0", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.5, 0.25],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.0, 0.25],
                    [0.5, 0.0, 0.25],
                    [0.0, 0.5, 0.75],
                    [0.0, 0.5, 0.75],
                    [0.5, 0.0, 0.75],
                    [0.5, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "x+1/2", "1/4"],
                ["-x", "-x+1/2", "1/4"],
                ["-x+1/2", "x", "1/4"],
                ["x+1/2", "-x", "1/4"],
                ["-x", "-x+1/2", "3/4"],
                ["x", "x+1/2", "3/4"],
                ["x+1/2", "-x", "3/4"],
                ["-x+1/2", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-y", "x", "0"],
                ["y", "-x", "0"],
                ["-x+1/2", "y+1/2", "1/2"],
                ["x+1/2", "-y+1/2", "1/2"],
                ["y+1/2", "x+1/2", "1/2"],
                ["-y+1/2", "-x+1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["-x+1/2", "y+1/2", "-z+1/2"],
                ["x+1/2", "-y+1/2", "-z+1/2"],
                ["y+1/2", "x+1/2", "-z+1/2"],
                ["-y+1/2", "-x+1/2", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["x+1/2", "-y+1/2", "z+1/2"],
                ["-x+1/2", "y+1/2", "z+1/2"],
                ["-y+1/2", "-x+1/2", "z+1/2"],
                ["y+1/2", "x+1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    129: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "z"], ["0", "1/2", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                ]
            ),
            "expressions": [
                ["1/4", "3/4", "0"],
                ["3/4", "1/4", "0"],
                ["3/4", "3/4", "0"],
                ["1/4", "1/4", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.25, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.75, 0.75, 0.5],
                    [0.25, 0.25, 0.5],
                ]
            ),
            "expressions": [
                ["1/4", "3/4", "1/2"],
                ["3/4", "1/4", "1/2"],
                ["3/4", "3/4", "1/2"],
                ["1/4", "1/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "-z"],
                ["0", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                ]
            ),
            "expressions": [
                ["x+1/4", "-x+3/4", "0"],
                ["-x+3/4", "x+1/4", "0"],
                ["x+3/4", "x+3/4", "0"],
                ["-x+1/4", "-x+1/4", "0"],
                ["-x+1/4", "x+3/4", "0"],
                ["x+3/4", "-x+1/4", "0"],
                ["-x+3/4", "-x+3/4", "0"],
                ["x+1/4", "x+1/4", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [
                    [0.25, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.75, 0.75, 0.5],
                    [0.25, 0.25, 0.5],
                    [0.25, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.75, 0.75, 0.5],
                    [0.25, 0.25, 0.5],
                ]
            ),
            "expressions": [
                ["x+1/4", "-x+3/4", "1/2"],
                ["-x+3/4", "x+1/4", "1/2"],
                ["x+3/4", "x+3/4", "1/2"],
                ["-x+1/4", "-x+1/4", "1/2"],
                ["-x+1/4", "x+3/4", "1/2"],
                ["x+3/4", "-x+1/4", "1/2"],
                ["-x+3/4", "-x+3/4", "1/2"],
                ["x+1/4", "x+1/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [
                    [0.5, 0.75, 0.0],
                    [0.5, 0.25, 0.0],
                    [0.75, 0.0, 0.0],
                    [0.25, 0.0, 0.0],
                    [0.0, 0.25, 0.0],
                    [0.0, 0.75, 0.0],
                    [0.75, 0.5, 0.0],
                    [0.25, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["1/2", "y+3/4", "z"],
                ["1/2", "-y+1/4", "z"],
                ["-y+3/4", "0", "z"],
                ["y+1/4", "0", "z"],
                ["0", "y+1/4", "-z"],
                ["0", "-y+3/4", "-z"],
                ["y+3/4", "1/2", "-z"],
                ["-y+1/4", "1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "j": {
            "constants": array(
                [
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["x+1/4", "x+3/4", "z"],
                ["-x+3/4", "-x+1/4", "z"],
                ["-x+3/4", "x+3/4", "z"],
                ["x+1/4", "-x+1/4", "z"],
                ["-x+1/4", "x+1/4", "-z"],
                ["x+3/4", "-x+3/4", "-z"],
                ["x+3/4", "x+1/4", "-z"],
                ["-x+1/4", "-x+3/4", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "k": {
            "constants": array(
                [
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                ]
            ),
            "expressions": [
                ["x+1/4", "y+3/4", "z"],
                ["-x+3/4", "-y+1/4", "z"],
                ["-y+3/4", "x+3/4", "z"],
                ["y+1/4", "-x+1/4", "z"],
                ["-x+1/4", "y+1/4", "-z"],
                ["x+3/4", "-y+3/4", "-z"],
                ["y+3/4", "x+1/4", "-z"],
                ["-y+1/4", "-x+3/4", "-z"],
                ["-x+1/4", "-y+3/4", "-z"],
                ["x+3/4", "y+1/4", "-z"],
                ["y+3/4", "-x+3/4", "-z"],
                ["-y+1/4", "x+1/4", "-z"],
                ["x+1/4", "-y+1/4", "z"],
                ["-x+3/4", "y+3/4", "z"],
                ["-y+3/4", "-x+1/4", "z"],
                ["y+1/4", "x+3/4", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    130: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.5, 0.5, 0.25], [0.5, 0.5, 0.75], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "0", "1/4"],
                ["1/2", "1/2", "1/4"],
                ["1/2", "1/2", "3/4"],
                ["0", "0", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.0], [0.5, 0.5, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "0"],
                ["1/2", "1/2", "0"],
                ["1/2", "1/2", "1/2"],
                ["0", "0", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.5, 0.0, 0.0], [0.0, 0.5, 0.5], [0.0, 0.5, 0.0], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["1/2", "0", "z"],
                ["0", "1/2", "-z+1/2"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.25, 0.25, 0.5],
                    [0.75, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.25, 0.75, 0.5],
                ]
            ),
            "expressions": [
                ["1/4", "3/4", "0"],
                ["3/4", "1/4", "0"],
                ["3/4", "3/4", "0"],
                ["1/4", "1/4", "0"],
                ["1/4", "1/4", "1/2"],
                ["3/4", "3/4", "1/2"],
                ["3/4", "1/4", "1/2"],
                ["1/4", "3/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "-z+1/2"],
                ["0", "0", "-z+1/2"],
                ["1/2", "1/2", "-z"],
                ["0", "0", "-z"],
                ["0", "0", "z+1/2"],
                ["1/2", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.25, 0.25],
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["x+1/4", "-x+3/4", "1/4"],
                ["-x+3/4", "x+1/4", "1/4"],
                ["x+3/4", "x+3/4", "1/4"],
                ["-x+1/4", "-x+1/4", "1/4"],
                ["-x+1/4", "x+3/4", "3/4"],
                ["x+3/4", "-x+1/4", "3/4"],
                ["-x+3/4", "-x+3/4", "3/4"],
                ["x+1/4", "x+1/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.25, 0.25, 0.5],
                    [0.75, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.25, 0.75, 0.5],
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.25, 0.25, 0.5],
                    [0.75, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.25, 0.75, 0.5],
                ]
            ),
            "expressions": [
                ["x+1/4", "y+3/4", "z"],
                ["-x+3/4", "-y+1/4", "z"],
                ["-y+3/4", "x+3/4", "z"],
                ["y+1/4", "-x+1/4", "z"],
                ["-x+1/4", "y+1/4", "-z+1/2"],
                ["x+3/4", "-y+3/4", "-z+1/2"],
                ["y+3/4", "x+1/4", "-z+1/2"],
                ["-y+1/4", "-x+3/4", "-z+1/2"],
                ["-x+1/4", "-y+3/4", "-z"],
                ["x+3/4", "y+1/4", "-z"],
                ["y+3/4", "-x+3/4", "-z"],
                ["-y+1/4", "x+1/4", "-z"],
                ["x+1/4", "-y+1/4", "z+1/2"],
                ["-x+3/4", "y+3/4", "z+1/2"],
                ["-y+3/4", "-x+1/4", "z+1/2"],
                ["y+1/4", "x+3/4", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    131: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.5]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.5], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "1/2"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.5, 0.5, 0.25], [0.5, 0.5, 0.75]]),
            "expressions": [["1/2", "1/2", "1/4"], ["1/2", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "z+1/2"],
                ["0", "0", "-z"],
                ["0", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.5, 0.5, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "z+1/2"],
                ["1/2", "1/2", "-z"],
                ["1/2", "1/2", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.0], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z+1/2"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x", "0", "0"],
                ["0", "x", "1/2"],
                ["0", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [[0.0, 0.5, 0.5], [0.0, 0.5, 0.5], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "1/2", "1/2"],
                ["-x", "1/2", "1/2"],
                ["1/2", "x", "0"],
                ["1/2", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "l": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "1/2"],
                ["-x", "0", "1/2"],
                ["0", "x", "0"],
                ["0", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "m": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "1/2", "0"],
                ["-x", "1/2", "0"],
                ["1/2", "x", "1/2"],
                ["1/2", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "n": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                ]
            ),
            "expressions": [
                ["x", "x", "1/4"],
                ["-x", "-x", "1/4"],
                ["-x", "x", "3/4"],
                ["x", "-x", "3/4"],
                ["-x", "-x", "3/4"],
                ["x", "x", "3/4"],
                ["x", "-x", "1/4"],
                ["-x", "x", "1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "o": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["0", "y", "z"],
                ["0", "-y", "z"],
                ["-y", "0", "z+1/2"],
                ["y", "0", "z+1/2"],
                ["0", "y", "-z"],
                ["0", "-y", "-z"],
                ["y", "0", "-z+1/2"],
                ["-y", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "p": {
            "constants": array(
                [
                    [0.5, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.0, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["1/2", "y", "z"],
                ["1/2", "-y", "z"],
                ["-y", "1/2", "z+1/2"],
                ["y", "1/2", "z+1/2"],
                ["1/2", "y", "-z"],
                ["1/2", "-y", "-z"],
                ["y", "1/2", "-z+1/2"],
                ["-y", "1/2", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "q": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-y", "x", "1/2"],
                ["y", "-x", "1/2"],
                ["-x", "y", "0"],
                ["x", "-y", "0"],
                ["y", "x", "1/2"],
                ["-y", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "r": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z+1/2"],
                ["y", "-x", "z+1/2"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
                ["y", "x", "-z+1/2"],
                ["-y", "-x", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["y", "-x", "-z+1/2"],
                ["-y", "x", "-z+1/2"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
                ["-y", "-x", "z+1/2"],
                ["y", "x", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    132: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["1/2", "1/2", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.5, 0.5, 0.25], [0.5, 0.5, 0.75]]),
            "expressions": [["1/2", "1/2", "1/4"], ["1/2", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.5, 0.25], [0.5, 0.0, 0.75], [0.0, 0.5, 0.75], [0.5, 0.0, 0.25]]
            ),
            "expressions": [
                ["0", "1/2", "1/4"],
                ["1/2", "0", "3/4"],
                ["0", "1/2", "3/4"],
                ["1/2", "0", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "0"],
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/2"],
                ["1/2", "0", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "z+1/2"],
                ["0", "0", "-z+1/2"],
                ["0", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.5, 0.5, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "z+1/2"],
                ["1/2", "1/2", "-z+1/2"],
                ["1/2", "1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x", "-x", "0"],
                ["-x", "x", "1/2"],
                ["x", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x", "1/2"],
                ["-x", "-x", "1/2"],
                ["-x", "x", "0"],
                ["x", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z+1/2"],
                ["0", "1/2", "-z+1/2"],
                ["1/2", "0", "-z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z+1/2"],
                ["0", "1/2", "z+1/2"],
                ["1/2", "0", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                ]
            ),
            "expressions": [
                ["x", "0", "1/4"],
                ["-x", "0", "1/4"],
                ["0", "x", "3/4"],
                ["0", "-x", "3/4"],
                ["-x", "0", "3/4"],
                ["x", "0", "3/4"],
                ["0", "-x", "1/4"],
                ["0", "x", "1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "m": {
            "constants": array(
                [
                    [0.0, 0.5, 0.25],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.0, 0.75],
                    [0.5, 0.0, 0.75],
                    [0.0, 0.5, 0.75],
                    [0.0, 0.5, 0.75],
                    [0.5, 0.0, 0.25],
                    [0.5, 0.0, 0.25],
                ]
            ),
            "expressions": [
                ["x", "1/2", "1/4"],
                ["-x", "1/2", "1/4"],
                ["1/2", "x", "3/4"],
                ["1/2", "-x", "3/4"],
                ["-x", "1/2", "3/4"],
                ["x", "1/2", "3/4"],
                ["1/2", "-x", "1/4"],
                ["1/2", "x", "1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "n": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-y", "x", "1/2"],
                ["y", "-x", "1/2"],
                ["-x", "y", "1/2"],
                ["x", "-y", "1/2"],
                ["y", "x", "0"],
                ["-y", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "o": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "x", "z"],
                ["-x", "-x", "z"],
                ["-x", "x", "z+1/2"],
                ["x", "-x", "z+1/2"],
                ["-x", "x", "-z+1/2"],
                ["x", "-x", "-z+1/2"],
                ["x", "x", "-z"],
                ["-x", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "p": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z+1/2"],
                ["y", "-x", "z+1/2"],
                ["-x", "y", "-z+1/2"],
                ["x", "-y", "-z+1/2"],
                ["y", "x", "-z"],
                ["-y", "-x", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["y", "-x", "-z+1/2"],
                ["-y", "x", "-z+1/2"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z+1/2"],
                ["-y", "-x", "z"],
                ["y", "x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    133: {
        "a": {
            "constants": array(
                [[0.5, 0.0, 0.25], [0.5, 0.0, 0.75], [0.0, 0.5, 0.25], [0.0, 0.5, 0.75]]
            ),
            "expressions": [
                ["1/2", "0", "1/4"],
                ["1/2", "0", "3/4"],
                ["0", "1/2", "1/4"],
                ["0", "1/2", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.5, 0.5, 0.75], [0.5, 0.5, 0.25], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "0", "1/4"],
                ["1/2", "1/2", "3/4"],
                ["1/2", "1/2", "1/4"],
                ["0", "0", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.5, 0.0, 0.5], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["1/2", "0", "1/2"],
                ["1/2", "0", "0"],
                ["0", "1/2", "0"],
                ["0", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.0, 0.0, 0.5], [0.5, 0.5, 0.0]]
            ),
            "expressions": [
                ["0", "0", "0"],
                ["1/2", "1/2", "1/2"],
                ["0", "0", "1/2"],
                ["1/2", "1/2", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.25, 0.25],
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["1/4", "3/4", "1/4"],
                ["3/4", "1/4", "1/4"],
                ["3/4", "3/4", "3/4"],
                ["1/4", "1/4", "3/4"],
                ["3/4", "3/4", "1/4"],
                ["1/4", "1/4", "1/4"],
                ["1/4", "3/4", "3/4"],
                ["3/4", "1/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [
                    [0.5, 0.0, 0.25],
                    [0.5, 0.0, 0.75],
                    [0.5, 0.0, 0.25],
                    [0.5, 0.0, 0.75],
                    [0.0, 0.5, 0.25],
                    [0.0, 0.5, 0.75],
                    [0.0, 0.5, 0.25],
                    [0.0, 0.5, 0.75],
                ]
            ),
            "expressions": [
                ["1/2", "0", "z+1/4"],
                ["1/2", "0", "z+3/4"],
                ["1/2", "0", "-z+1/4"],
                ["1/2", "0", "-z+3/4"],
                ["0", "1/2", "-z+1/4"],
                ["0", "1/2", "-z+3/4"],
                ["0", "1/2", "z+1/4"],
                ["0", "1/2", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.5, 0.5, 0.75],
                    [0.0, 0.0, 0.25],
                    [0.5, 0.5, 0.75],
                    [0.5, 0.5, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.5, 0.5, 0.25],
                    [0.0, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["0", "0", "z+1/4"],
                ["1/2", "1/2", "z+3/4"],
                ["0", "0", "-z+1/4"],
                ["1/2", "1/2", "-z+3/4"],
                ["1/2", "1/2", "-z+1/4"],
                ["0", "0", "-z+3/4"],
                ["1/2", "1/2", "z+1/4"],
                ["0", "0", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [
                    [0.25, 0.0, 0.25],
                    [0.75, 0.0, 0.25],
                    [0.5, 0.75, 0.75],
                    [0.5, 0.25, 0.75],
                    [0.25, 0.5, 0.25],
                    [0.75, 0.5, 0.25],
                    [0.0, 0.75, 0.75],
                    [0.0, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["x+1/4", "0", "1/4"],
                ["-x+3/4", "0", "1/4"],
                ["1/2", "x+3/4", "3/4"],
                ["1/2", "-x+1/4", "3/4"],
                ["-x+1/4", "1/2", "1/4"],
                ["x+3/4", "1/2", "1/4"],
                ["0", "-x+3/4", "3/4"],
                ["0", "x+1/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [
                    [0.25, 0.0, 0.75],
                    [0.75, 0.0, 0.75],
                    [0.5, 0.75, 0.25],
                    [0.5, 0.25, 0.25],
                    [0.25, 0.5, 0.75],
                    [0.75, 0.5, 0.75],
                    [0.0, 0.75, 0.25],
                    [0.0, 0.25, 0.25],
                ]
            ),
            "expressions": [
                ["x+1/4", "0", "3/4"],
                ["-x+3/4", "0", "3/4"],
                ["1/2", "x+3/4", "1/4"],
                ["1/2", "-x+1/4", "1/4"],
                ["-x+1/4", "1/2", "3/4"],
                ["x+3/4", "1/2", "3/4"],
                ["0", "-x+3/4", "1/4"],
                ["0", "x+1/4", "1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [
                    [0.25, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.5],
                    [0.25, 0.25, 0.5],
                ]
            ),
            "expressions": [
                ["x+1/4", "x+3/4", "1/2"],
                ["-x+3/4", "-x+1/4", "1/2"],
                ["-x+3/4", "x+3/4", "0"],
                ["x+1/4", "-x+1/4", "0"],
                ["-x+1/4", "-x+3/4", "0"],
                ["x+3/4", "x+1/4", "0"],
                ["x+3/4", "-x+3/4", "1/2"],
                ["-x+1/4", "x+1/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.25, 0.25],
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.25, 0.25],
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["x+1/4", "y+3/4", "z+1/4"],
                ["-x+3/4", "-y+1/4", "z+1/4"],
                ["-y+3/4", "x+3/4", "z+3/4"],
                ["y+1/4", "-x+1/4", "z+3/4"],
                ["-x+3/4", "y+3/4", "-z+1/4"],
                ["x+1/4", "-y+1/4", "-z+1/4"],
                ["y+1/4", "x+3/4", "-z+3/4"],
                ["-y+3/4", "-x+1/4", "-z+3/4"],
                ["-x+1/4", "-y+3/4", "-z+1/4"],
                ["x+3/4", "y+1/4", "-z+1/4"],
                ["y+3/4", "-x+3/4", "-z+3/4"],
                ["-y+1/4", "x+1/4", "-z+3/4"],
                ["x+3/4", "-y+3/4", "z+1/4"],
                ["-x+1/4", "y+1/4", "z+1/4"],
                ["-y+1/4", "-x+3/4", "z+3/4"],
                ["y+3/4", "x+1/4", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    134: {
        "a": {
            "constants": array([[0.5, 0.5, 0.5], [0.0, 0.0, 0.0]]),
            "expressions": [["1/2", "1/2", "1/2"], ["0", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.5, 0.0, 0.5], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["1/2", "0", "1/2"],
                ["1/2", "0", "0"],
                ["0", "1/2", "0"],
                ["0", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.5, 0.0, 0.25], [0.5, 0.0, 0.75], [0.0, 0.5, 0.25], [0.0, 0.5, 0.75]]
            ),
            "expressions": [
                ["1/2", "0", "1/4"],
                ["1/2", "0", "3/4"],
                ["0", "1/2", "1/4"],
                ["0", "1/2", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.25, 0.25],
                ]
            ),
            "expressions": [
                ["1/4", "3/4", "3/4"],
                ["3/4", "1/4", "3/4"],
                ["3/4", "3/4", "1/4"],
                ["1/4", "1/4", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["1/4", "3/4", "1/4"],
                ["3/4", "1/4", "1/4"],
                ["3/4", "3/4", "3/4"],
                ["1/4", "1/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.5, 0.5, 0.75], [0.0, 0.0, 0.75], [0.5, 0.5, 0.25]]
            ),
            "expressions": [
                ["0", "0", "z+1/4"],
                ["1/2", "1/2", "z+3/4"],
                ["0", "0", "-z+3/4"],
                ["1/2", "1/2", "-z+1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [
                    [0.5, 0.0, 0.25],
                    [0.5, 0.0, 0.75],
                    [0.5, 0.0, 0.75],
                    [0.5, 0.0, 0.25],
                    [0.0, 0.5, 0.25],
                    [0.0, 0.5, 0.75],
                    [0.0, 0.5, 0.75],
                    [0.0, 0.5, 0.25],
                ]
            ),
            "expressions": [
                ["1/2", "0", "z+1/4"],
                ["1/2", "0", "z+3/4"],
                ["1/2", "0", "-z+3/4"],
                ["1/2", "0", "-z+1/4"],
                ["0", "1/2", "-z+1/4"],
                ["0", "1/2", "-z+3/4"],
                ["0", "1/2", "z+3/4"],
                ["0", "1/2", "z+1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [
                    [0.25, 0.0, 0.0],
                    [0.75, 0.0, 0.0],
                    [0.5, 0.75, 0.5],
                    [0.5, 0.25, 0.5],
                    [0.25, 0.5, 0.5],
                    [0.75, 0.5, 0.5],
                    [0.0, 0.75, 0.0],
                    [0.0, 0.25, 0.0],
                ]
            ),
            "expressions": [
                ["x+1/4", "0", "0"],
                ["-x+3/4", "0", "0"],
                ["1/2", "x+3/4", "1/2"],
                ["1/2", "-x+1/4", "1/2"],
                ["-x+1/4", "1/2", "1/2"],
                ["x+3/4", "1/2", "1/2"],
                ["0", "-x+3/4", "0"],
                ["0", "x+1/4", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [
                    [0.25, 0.0, 0.5],
                    [0.75, 0.0, 0.5],
                    [0.5, 0.75, 0.0],
                    [0.5, 0.25, 0.0],
                    [0.25, 0.5, 0.0],
                    [0.75, 0.5, 0.0],
                    [0.0, 0.75, 0.5],
                    [0.0, 0.25, 0.5],
                ]
            ),
            "expressions": [
                ["x+1/4", "0", "1/2"],
                ["-x+3/4", "0", "1/2"],
                ["1/2", "x+3/4", "0"],
                ["1/2", "-x+1/4", "0"],
                ["-x+1/4", "1/2", "0"],
                ["x+3/4", "1/2", "0"],
                ["0", "-x+3/4", "1/2"],
                ["0", "x+1/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["x+1/4", "x+3/4", "1/4"],
                ["-x+3/4", "-x+1/4", "1/4"],
                ["-x+3/4", "x+3/4", "3/4"],
                ["x+1/4", "-x+1/4", "3/4"],
                ["-x+1/4", "-x+3/4", "1/4"],
                ["x+3/4", "x+1/4", "1/4"],
                ["x+3/4", "-x+3/4", "3/4"],
                ["-x+1/4", "x+1/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "l": {
            "constants": array(
                [
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.25, 0.25],
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.25, 0.25],
                ]
            ),
            "expressions": [
                ["x+1/4", "x+3/4", "3/4"],
                ["-x+3/4", "-x+1/4", "3/4"],
                ["-x+3/4", "x+3/4", "1/4"],
                ["x+1/4", "-x+1/4", "1/4"],
                ["-x+1/4", "-x+3/4", "3/4"],
                ["x+3/4", "x+1/4", "3/4"],
                ["x+3/4", "-x+3/4", "1/4"],
                ["-x+1/4", "x+1/4", "1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "m": {
            "constants": array(
                [
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                ]
            ),
            "expressions": [
                ["x+1/4", "-x+3/4", "z+1/4"],
                ["-x+3/4", "x+1/4", "z+1/4"],
                ["x+3/4", "x+3/4", "z+3/4"],
                ["-x+1/4", "-x+1/4", "z+3/4"],
                ["-x+3/4", "-x+3/4", "-z+3/4"],
                ["x+1/4", "x+1/4", "-z+3/4"],
                ["-x+1/4", "x+3/4", "-z+1/4"],
                ["x+3/4", "-x+1/4", "-z+1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "n": {
            "constants": array(
                [
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                ]
            ),
            "expressions": [
                ["x+1/4", "y+3/4", "z+1/4"],
                ["-x+3/4", "-y+1/4", "z+1/4"],
                ["-y+3/4", "x+3/4", "z+3/4"],
                ["y+1/4", "-x+1/4", "z+3/4"],
                ["-x+3/4", "y+3/4", "-z+3/4"],
                ["x+1/4", "-y+1/4", "-z+3/4"],
                ["y+1/4", "x+3/4", "-z+1/4"],
                ["-y+3/4", "-x+1/4", "-z+1/4"],
                ["-x+1/4", "-y+3/4", "-z+1/4"],
                ["x+3/4", "y+1/4", "-z+1/4"],
                ["y+3/4", "-x+3/4", "-z+3/4"],
                ["-y+1/4", "x+1/4", "-z+3/4"],
                ["x+3/4", "-y+3/4", "z+3/4"],
                ["-x+1/4", "y+1/4", "z+3/4"],
                ["-y+1/4", "-x+3/4", "z+1/4"],
                ["y+3/4", "x+1/4", "z+1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    135: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.5, 0.5, 0.0], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "0", "0"],
                ["0", "0", "1/2"],
                ["1/2", "1/2", "0"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.0, 0.75], [0.5, 0.5, 0.75], [0.5, 0.5, 0.25]]
            ),
            "expressions": [
                ["0", "0", "1/4"],
                ["0", "0", "3/4"],
                ["1/2", "1/2", "3/4"],
                ["1/2", "1/2", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.5], [0.5, 0.0, 0.0], [0.0, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "0"],
                ["1/2", "0", "1/2"],
                ["1/2", "0", "0"],
                ["0", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.0, 0.5, 0.25], [0.5, 0.0, 0.75], [0.0, 0.5, 0.75], [0.5, 0.0, 0.25]]
            ),
            "expressions": [
                ["0", "1/2", "1/4"],
                ["1/2", "0", "3/4"],
                ["0", "1/2", "3/4"],
                ["1/2", "0", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "z+1/2"],
                ["1/2", "1/2", "-z"],
                ["1/2", "1/2", "-z+1/2"],
                ["0", "0", "-z"],
                ["0", "0", "-z+1/2"],
                ["1/2", "1/2", "z"],
                ["1/2", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z+1/2"],
                ["1/2", "0", "-z"],
                ["0", "1/2", "-z+1/2"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z+1/2"],
                ["1/2", "0", "z"],
                ["0", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.5, 0.25],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.0, 0.75],
                    [0.5, 0.0, 0.75],
                    [0.0, 0.5, 0.75],
                    [0.0, 0.5, 0.75],
                    [0.5, 0.0, 0.25],
                    [0.5, 0.0, 0.25],
                ]
            ),
            "expressions": [
                ["x", "x+1/2", "1/4"],
                ["-x", "-x+1/2", "1/4"],
                ["-x+1/2", "x", "3/4"],
                ["x+1/2", "-x", "3/4"],
                ["-x", "-x+1/2", "3/4"],
                ["x", "x+1/2", "3/4"],
                ["x+1/2", "-x", "1/4"],
                ["-x+1/2", "x", "1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-y", "x", "1/2"],
                ["y", "-x", "1/2"],
                ["-x+1/2", "y+1/2", "0"],
                ["x+1/2", "-y+1/2", "0"],
                ["y+1/2", "x+1/2", "1/2"],
                ["-y+1/2", "-x+1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z+1/2"],
                ["y", "-x", "z+1/2"],
                ["-x+1/2", "y+1/2", "-z"],
                ["x+1/2", "-y+1/2", "-z"],
                ["y+1/2", "x+1/2", "-z+1/2"],
                ["-y+1/2", "-x+1/2", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["y", "-x", "-z+1/2"],
                ["-y", "x", "-z+1/2"],
                ["x+1/2", "-y+1/2", "z"],
                ["-x+1/2", "y+1/2", "z"],
                ["-y+1/2", "-x+1/2", "z+1/2"],
                ["y+1/2", "x+1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    136: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "0"],
                ["0", "1/2", "1/2"],
                ["1/2", "0", "1/2"],
                ["1/2", "0", "0"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.0, 0.5, 0.25], [0.0, 0.5, 0.75], [0.5, 0.0, 0.25], [0.5, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "1/2", "1/4"],
                ["0", "1/2", "3/4"],
                ["1/2", "0", "1/4"],
                ["1/2", "0", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["1/2", "1/2", "z+1/2"],
                ["1/2", "1/2", "-z+1/2"],
                ["0", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x", "-x", "0"],
                ["-x+1/2", "x+1/2", "1/2"],
                ["x+1/2", "-x+1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["x", "-x", "0"],
                ["-x", "x", "0"],
                ["x+1/2", "x+1/2", "1/2"],
                ["-x+1/2", "-x+1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [
                    [0.0, 0.5, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.5],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.5],
                    [0.5, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["0", "1/2", "z+1/2"],
                ["1/2", "0", "-z+1/2"],
                ["1/2", "0", "-z"],
                ["0", "1/2", "-z"],
                ["0", "1/2", "-z+1/2"],
                ["1/2", "0", "z+1/2"],
                ["1/2", "0", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-y+1/2", "x+1/2", "1/2"],
                ["y+1/2", "-x+1/2", "1/2"],
                ["-x+1/2", "y+1/2", "1/2"],
                ["x+1/2", "-y+1/2", "1/2"],
                ["y", "x", "0"],
                ["-y", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "x", "z"],
                ["-x", "-x", "z"],
                ["-x+1/2", "x+1/2", "z+1/2"],
                ["x+1/2", "-x+1/2", "z+1/2"],
                ["-x+1/2", "x+1/2", "-z+1/2"],
                ["x+1/2", "-x+1/2", "-z+1/2"],
                ["x", "x", "-z"],
                ["-x", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y+1/2", "x+1/2", "z+1/2"],
                ["y+1/2", "-x+1/2", "z+1/2"],
                ["-x+1/2", "y+1/2", "-z+1/2"],
                ["x+1/2", "-y+1/2", "-z+1/2"],
                ["y", "x", "-z"],
                ["-y", "-x", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["y+1/2", "-x+1/2", "-z+1/2"],
                ["-y+1/2", "x+1/2", "-z+1/2"],
                ["x+1/2", "-y+1/2", "z+1/2"],
                ["-x+1/2", "y+1/2", "z+1/2"],
                ["-y", "-x", "z"],
                ["y", "x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    137: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "0", "0"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.5, 0.5, 0.0]]),
            "expressions": [["0", "0", "1/2"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.5, 0.5, 0.75], [0.5, 0.5, 0.25], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "0", "z+1/4"],
                ["1/2", "1/2", "z+3/4"],
                ["1/2", "1/2", "-z+1/4"],
                ["0", "0", "-z+3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.5, 0.0, 0.25], [0.5, 0.0, 0.75], [0.0, 0.5, 0.25], [0.0, 0.5, 0.75]]
            ),
            "expressions": [
                ["1/2", "0", "z+1/4"],
                ["1/2", "0", "z+3/4"],
                ["0", "1/2", "-z+1/4"],
                ["0", "1/2", "-z+3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "e": {
            "constants": array(
                [
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.75, 0.25, 0.75],
                    [0.25, 0.75, 0.75],
                ]
            ),
            "expressions": [
                ["1/4", "3/4", "1/4"],
                ["3/4", "1/4", "1/4"],
                ["3/4", "3/4", "3/4"],
                ["1/4", "1/4", "3/4"],
                ["1/4", "1/4", "1/4"],
                ["3/4", "3/4", "1/4"],
                ["3/4", "1/4", "3/4"],
                ["1/4", "3/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [
                    [0.25, 0.75, 0.5],
                    [0.75, 0.25, 0.5],
                    [0.75, 0.75, 0.0],
                    [0.25, 0.25, 0.0],
                    [0.25, 0.75, 0.0],
                    [0.75, 0.25, 0.0],
                    [0.75, 0.75, 0.5],
                    [0.25, 0.25, 0.5],
                ]
            ),
            "expressions": [
                ["x+1/4", "-x+3/4", "1/2"],
                ["-x+3/4", "x+1/4", "1/2"],
                ["x+3/4", "x+3/4", "0"],
                ["-x+1/4", "-x+1/4", "0"],
                ["-x+1/4", "x+3/4", "0"],
                ["x+3/4", "-x+1/4", "0"],
                ["-x+3/4", "-x+3/4", "1/2"],
                ["x+1/4", "x+1/4", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [
                    [0.5, 0.75, 0.25],
                    [0.5, 0.25, 0.25],
                    [0.75, 0.0, 0.75],
                    [0.25, 0.0, 0.75],
                    [0.0, 0.25, 0.25],
                    [0.0, 0.75, 0.25],
                    [0.75, 0.5, 0.75],
                    [0.25, 0.5, 0.75],
                ]
            ),
            "expressions": [
                ["1/2", "y+3/4", "z+1/4"],
                ["1/2", "-y+1/4", "z+1/4"],
                ["-y+3/4", "0", "z+3/4"],
                ["y+1/4", "0", "z+3/4"],
                ["0", "y+1/4", "-z+1/4"],
                ["0", "-y+3/4", "-z+1/4"],
                ["y+3/4", "1/2", "-z+3/4"],
                ["-y+1/4", "1/2", "-z+3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "h": {
            "constants": array(
                [
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.75, 0.25, 0.75],
                    [0.25, 0.75, 0.75],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.75, 0.25, 0.75],
                    [0.25, 0.75, 0.75],
                ]
            ),
            "expressions": [
                ["x+1/4", "y+3/4", "z+1/4"],
                ["-x+3/4", "-y+1/4", "z+1/4"],
                ["-y+3/4", "x+3/4", "z+3/4"],
                ["y+1/4", "-x+1/4", "z+3/4"],
                ["-x+1/4", "y+1/4", "-z+1/4"],
                ["x+3/4", "-y+3/4", "-z+1/4"],
                ["y+3/4", "x+1/4", "-z+3/4"],
                ["-y+1/4", "-x+3/4", "-z+3/4"],
                ["-x+1/4", "-y+3/4", "-z+1/4"],
                ["x+3/4", "y+1/4", "-z+1/4"],
                ["y+3/4", "-x+3/4", "-z+3/4"],
                ["-y+1/4", "x+1/4", "-z+3/4"],
                ["x+1/4", "-y+1/4", "z+1/4"],
                ["-x+3/4", "y+3/4", "z+1/4"],
                ["-y+3/4", "-x+1/4", "z+3/4"],
                ["y+1/4", "x+3/4", "z+3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    138: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.5, 0.5, 0.75], [0.5, 0.5, 0.25], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "0", "1/4"],
                ["1/2", "1/2", "3/4"],
                ["1/2", "1/2", "1/4"],
                ["0", "0", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.5, 0.5, 0.5], [0.5, 0.5, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "0"],
                ["1/2", "1/2", "1/2"],
                ["1/2", "1/2", "0"],
                ["0", "0", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.25, 0.25],
                ]
            ),
            "expressions": [
                ["1/4", "3/4", "3/4"],
                ["3/4", "1/4", "3/4"],
                ["3/4", "3/4", "1/4"],
                ["1/4", "1/4", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["1/4", "3/4", "1/4"],
                ["3/4", "1/4", "1/4"],
                ["3/4", "3/4", "3/4"],
                ["1/4", "1/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.5, 0.0, 0.25], [0.5, 0.0, 0.75], [0.0, 0.5, 0.75], [0.0, 0.5, 0.25]]
            ),
            "expressions": [
                ["1/2", "0", "z+1/4"],
                ["1/2", "0", "z+3/4"],
                ["0", "1/2", "-z+3/4"],
                ["0", "1/2", "-z+1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.5, 0.5, 0.75],
                    [0.5, 0.5, 0.75],
                    [0.0, 0.0, 0.25],
                    [0.5, 0.5, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.5, 0.5, 0.25],
                ]
            ),
            "expressions": [
                ["0", "0", "z+1/4"],
                ["1/2", "1/2", "z+3/4"],
                ["1/2", "1/2", "-z+3/4"],
                ["0", "0", "-z+1/4"],
                ["1/2", "1/2", "-z+1/4"],
                ["0", "0", "-z+3/4"],
                ["0", "0", "z+3/4"],
                ["1/2", "1/2", "z+1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.25, 0.25],
                    [0.25, 0.75, 0.75],
                    [0.75, 0.25, 0.75],
                    [0.75, 0.75, 0.25],
                    [0.25, 0.25, 0.25],
                ]
            ),
            "expressions": [
                ["x+1/4", "-x+3/4", "3/4"],
                ["-x+3/4", "x+1/4", "3/4"],
                ["x+3/4", "x+3/4", "1/4"],
                ["-x+1/4", "-x+1/4", "1/4"],
                ["-x+1/4", "x+3/4", "3/4"],
                ["x+3/4", "-x+1/4", "3/4"],
                ["-x+3/4", "-x+3/4", "1/4"],
                ["x+1/4", "x+1/4", "1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                ]
            ),
            "expressions": [
                ["x+1/4", "-x+3/4", "1/4"],
                ["-x+3/4", "x+1/4", "1/4"],
                ["x+3/4", "x+3/4", "3/4"],
                ["-x+1/4", "-x+1/4", "3/4"],
                ["-x+1/4", "x+3/4", "1/4"],
                ["x+3/4", "-x+1/4", "1/4"],
                ["-x+3/4", "-x+3/4", "3/4"],
                ["x+1/4", "x+1/4", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.75, 0.75, 0.75],
                    [0.75, 0.25, 0.25],
                    [0.25, 0.75, 0.25],
                ]
            ),
            "expressions": [
                ["x+1/4", "x+3/4", "z+1/4"],
                ["-x+3/4", "-x+1/4", "z+1/4"],
                ["-x+3/4", "x+3/4", "z+3/4"],
                ["x+1/4", "-x+1/4", "z+3/4"],
                ["-x+1/4", "x+1/4", "-z+3/4"],
                ["x+3/4", "-x+3/4", "-z+3/4"],
                ["x+3/4", "x+1/4", "-z+1/4"],
                ["-x+1/4", "-x+3/4", "-z+1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "j": {
            "constants": array(
                [
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.75, 0.75, 0.75],
                    [0.75, 0.25, 0.25],
                    [0.25, 0.75, 0.25],
                    [0.25, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.75, 0.75, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.25, 0.25, 0.75],
                    [0.75, 0.75, 0.75],
                    [0.75, 0.25, 0.25],
                    [0.25, 0.75, 0.25],
                ]
            ),
            "expressions": [
                ["x+1/4", "y+3/4", "z+1/4"],
                ["-x+3/4", "-y+1/4", "z+1/4"],
                ["-y+3/4", "x+3/4", "z+3/4"],
                ["y+1/4", "-x+1/4", "z+3/4"],
                ["-x+1/4", "y+1/4", "-z+3/4"],
                ["x+3/4", "-y+3/4", "-z+3/4"],
                ["y+3/4", "x+1/4", "-z+1/4"],
                ["-y+1/4", "-x+3/4", "-z+1/4"],
                ["-x+1/4", "-y+3/4", "-z+1/4"],
                ["x+3/4", "y+1/4", "-z+1/4"],
                ["y+3/4", "-x+3/4", "-z+3/4"],
                ["-y+1/4", "x+1/4", "-z+3/4"],
                ["x+1/4", "-y+1/4", "z+3/4"],
                ["-x+3/4", "y+3/4", "z+3/4"],
                ["-y+3/4", "-x+1/4", "z+1/4"],
                ["y+1/4", "x+3/4", "z+1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    139: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.25], [0.5, 0.0, 0.25]]),
            "expressions": [["0", "1/2", "1/4"], ["1/2", "0", "1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.25, 0.75, 0.25],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "1/4"],
                ["3/4", "3/4", "1/4"],
                ["3/4", "1/4", "1/4"],
                ["1/4", "3/4", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x", "-x", "0"],
                ["-x", "x", "0"],
                ["x", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["-x", "0", "0"],
                ["0", "x", "0"],
                ["0", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "1/2", "0"],
                ["-x", "1/2", "0"],
                ["1/2", "x", "0"],
                ["1/2", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.5, 0.25],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.0, 0.25],
                    [0.5, 0.0, 0.25],
                    [0.0, 0.5, 0.75],
                    [0.0, 0.5, 0.75],
                    [0.5, 0.0, 0.75],
                    [0.5, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "x+1/2", "1/4"],
                ["-x", "-x+1/2", "1/4"],
                ["-x+1/2", "x", "1/4"],
                ["x+1/2", "-x", "1/4"],
                ["-x", "-x+1/2", "3/4"],
                ["x", "x+1/2", "3/4"],
                ["x+1/2", "-x", "3/4"],
                ["-x+1/2", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-y", "x", "0"],
                ["y", "-x", "0"],
                ["-x", "y", "0"],
                ["x", "-y", "0"],
                ["y", "x", "0"],
                ["-y", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "m": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "x", "z"],
                ["-x", "-x", "z"],
                ["-x", "x", "z"],
                ["x", "-x", "z"],
                ["-x", "x", "-z"],
                ["x", "-x", "-z"],
                ["x", "x", "-z"],
                ["-x", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "n": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["0", "y", "z"],
                ["0", "-y", "z"],
                ["-y", "0", "z"],
                ["y", "0", "z"],
                ["0", "y", "-z"],
                ["0", "-y", "-z"],
                ["y", "0", "-z"],
                ["-y", "0", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "o": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["-x", "y", "-z"],
                ["x", "-y", "-z"],
                ["y", "x", "-z"],
                ["-y", "-x", "-z"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["x", "-y", "z"],
                ["-x", "y", "z"],
                ["-y", "-x", "z"],
                ["y", "x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    140: {
        "a": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.5, 0.25], [0.5, 0.0, 0.25]]),
            "expressions": [["0", "1/2", "1/4"], ["1/2", "0", "1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.0, 0.5, 0.0], [0.5, 0.0, 0.0]]),
            "expressions": [["0", "1/2", "0"], ["1/2", "0", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.25, 0.25, 0.25],
                    [0.75, 0.75, 0.25],
                    [0.75, 0.25, 0.25],
                    [0.25, 0.75, 0.25],
                ]
            ),
            "expressions": [
                ["1/4", "1/4", "1/4"],
                ["3/4", "3/4", "1/4"],
                ["3/4", "1/4", "1/4"],
                ["1/4", "3/4", "1/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z+1/2"],
                ["0", "0", "-z"],
                ["0", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.0, 0.5, 0.5], [0.5, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "1/2", "z"],
                ["1/2", "0", "z"],
                ["0", "1/2", "-z+1/2"],
                ["1/2", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.0, 0.5, 0.0], [0.0, 0.5, 0.0], [0.5, 0.0, 0.0], [0.5, 0.0, 0.0]]
            ),
            "expressions": [
                ["x", "x+1/2", "0"],
                ["-x", "-x+1/2", "0"],
                ["-x+1/2", "x", "0"],
                ["x+1/2", "-x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "x", "1/4"],
                ["-x", "-x", "1/4"],
                ["-x", "x", "1/4"],
                ["x", "-x", "1/4"],
                ["-x", "-x", "3/4"],
                ["x", "x", "3/4"],
                ["x", "-x", "3/4"],
                ["-x", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "0", "1/4"],
                ["-x", "0", "1/4"],
                ["0", "x", "1/4"],
                ["0", "-x", "1/4"],
                ["-x", "0", "3/4"],
                ["x", "0", "3/4"],
                ["0", "-x", "3/4"],
                ["0", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-x", "-y", "0"],
                ["-y", "x", "0"],
                ["y", "-x", "0"],
                ["-x", "y", "1/2"],
                ["x", "-y", "1/2"],
                ["y", "x", "1/2"],
                ["-y", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.5, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.5],
                    [0.5, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "x+1/2", "z"],
                ["-x", "-x+1/2", "z"],
                ["-x+1/2", "x", "z"],
                ["x+1/2", "-x", "z"],
                ["-x", "x+1/2", "-z+1/2"],
                ["x", "-x+1/2", "-z+1/2"],
                ["x+1/2", "x", "-z+1/2"],
                ["-x+1/2", "-x", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "m": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-x", "-y", "z"],
                ["-y", "x", "z"],
                ["y", "-x", "z"],
                ["-x", "y", "-z+1/2"],
                ["x", "-y", "-z+1/2"],
                ["y", "x", "-z+1/2"],
                ["-y", "-x", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["x", "y", "-z"],
                ["y", "-x", "-z"],
                ["-y", "x", "-z"],
                ["x", "-y", "z+1/2"],
                ["-x", "y", "z+1/2"],
                ["-y", "-x", "z+1/2"],
                ["y", "x", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    141: {
        "a": {
            "constants": array([[0.0, 0.5, 0.25], [0.5, 0.5, 0.5]]),
            "expressions": [["0", "1/2", "1/4"], ["1/2", "1/2", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.5, 0.75]]),
            "expressions": [["0", "0", "1/2"], ["0", "1/2", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.75, 0.125],
                    [0.5, 0.75, 0.625],
                    [0.25, 0.5, 0.375],
                    [0.25, 0.0, 0.875],
                ]
            ),
            "expressions": [
                ["0", "3/4", "1/8"],
                ["1/2", "3/4", "5/8"],
                ["1/4", "1/2", "3/8"],
                ["1/4", "0", "7/8"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.75, 0.625],
                    [0.5, 0.75, 0.125],
                    [0.25, 0.5, 0.875],
                    [0.25, 0.0, 0.375],
                ]
            ),
            "expressions": [
                ["0", "3/4", "5/8"],
                ["1/2", "3/4", "1/8"],
                ["1/4", "1/2", "7/8"],
                ["1/4", "0", "3/8"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.125],
                    [0.0, 0.5, 0.375],
                    [0.5, 0.0, 0.625],
                    [0.5, 0.5, 0.375],
                ]
            ),
            "expressions": [
                ["0", "0", "z+1/8"],
                ["0", "1/2", "z+3/8"],
                ["1/2", "0", "-z+5/8"],
                ["1/2", "1/2", "-z+3/8"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.75, 0.125],
                    [0.5, 0.75, 0.625],
                    [0.25, 0.5, 0.375],
                    [0.25, 0.0, 0.875],
                    [0.0, 0.75, 0.125],
                    [0.5, 0.75, 0.625],
                    [0.75, 0.0, 0.875],
                    [0.75, 0.5, 0.375],
                ]
            ),
            "expressions": [
                ["x", "3/4", "1/8"],
                ["-x+1/2", "3/4", "5/8"],
                ["1/4", "x+1/2", "3/8"],
                ["1/4", "-x", "7/8"],
                ["-x", "3/4", "1/8"],
                ["x+1/2", "3/4", "5/8"],
                ["3/4", "-x", "7/8"],
                ["3/4", "x+1/2", "3/8"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.0, 0.75],
                    [0.0, 0.5, 0.25],
                    [0.5, 0.0, 0.75],
                    [0.0, 0.0, 0.0],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["x", "x", "0"],
                ["-x+1/2", "-x+1/2", "1/2"],
                ["-x", "x+1/2", "1/4"],
                ["x+1/2", "-x", "3/4"],
                ["-x", "-x+1/2", "1/4"],
                ["x+1/2", "x", "3/4"],
                ["x", "-x", "0"],
                ["-x+1/2", "x+1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [
                    [0.0, 0.75, 0.125],
                    [0.5, 0.75, 0.625],
                    [0.25, 0.5, 0.375],
                    [0.25, 0.0, 0.875],
                    [0.5, 0.75, 0.625],
                    [0.0, 0.75, 0.125],
                    [0.25, 0.5, 0.375],
                    [0.25, 0.0, 0.875],
                ]
            ),
            "expressions": [
                ["0", "y+3/4", "z+1/8"],
                ["1/2", "-y+3/4", "z+5/8"],
                ["-y+1/4", "1/2", "z+3/8"],
                ["y+1/4", "0", "z+7/8"],
                ["1/2", "y+3/4", "-z+5/8"],
                ["0", "-y+3/4", "-z+1/8"],
                ["y+1/4", "1/2", "-z+3/8"],
                ["-y+1/4", "0", "-z+7/8"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "z"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.75, 0.125],
                    [0.5, 0.75, 0.625],
                    [0.25, 0.5, 0.375],
                    [0.25, 0.0, 0.875],
                    [0.5, 0.75, 0.625],
                    [0.0, 0.75, 0.125],
                    [0.25, 0.5, 0.375],
                    [0.25, 0.0, 0.875],
                    [0.0, 0.75, 0.125],
                    [0.5, 0.75, 0.625],
                    [0.75, 0.0, 0.875],
                    [0.75, 0.5, 0.375],
                    [0.5, 0.75, 0.625],
                    [0.0, 0.75, 0.125],
                    [0.75, 0.0, 0.875],
                    [0.75, 0.5, 0.375],
                ]
            ),
            "expressions": [
                ["x", "y+3/4", "z+1/8"],
                ["-x+1/2", "-y+3/4", "z+5/8"],
                ["-y+1/4", "x+1/2", "z+3/8"],
                ["y+1/4", "-x", "z+7/8"],
                ["-x+1/2", "y+3/4", "-z+5/8"],
                ["x", "-y+3/4", "-z+1/8"],
                ["y+1/4", "x+1/2", "-z+3/8"],
                ["-y+1/4", "-x", "-z+7/8"],
                ["-x", "-y+3/4", "-z+1/8"],
                ["x+1/2", "y+3/4", "-z+5/8"],
                ["y+3/4", "-x", "-z+7/8"],
                ["-y+3/4", "x+1/2", "-z+3/8"],
                ["x+1/2", "-y+3/4", "z+5/8"],
                ["-x", "y+3/4", "z+1/8"],
                ["-y+3/4", "-x", "z+7/8"],
                ["y+3/4", "x+1/2", "z+3/8"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    142: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.5, 0.75], [0.5, 0.0, 0.75], [0.5, 0.5, 0.5]]
            ),
            "expressions": [
                ["0", "0", "1/2"],
                ["0", "1/2", "3/4"],
                ["1/2", "0", "3/4"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.25], [0.0, 0.5, 0.5], [0.0, 0.5, 0.0], [0.0, 0.0, 0.75]]
            ),
            "expressions": [
                ["0", "0", "1/4"],
                ["0", "1/2", "1/2"],
                ["0", "1/2", "0"],
                ["0", "0", "3/4"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.75, 0.125],
                    [0.5, 0.75, 0.625],
                    [0.25, 0.5, 0.375],
                    [0.25, 0.0, 0.875],
                    [0.5, 0.75, 0.125],
                    [0.0, 0.75, 0.625],
                    [0.25, 0.5, 0.875],
                    [0.25, 0.0, 0.375],
                ]
            ),
            "expressions": [
                ["0", "3/4", "1/8"],
                ["1/2", "3/4", "5/8"],
                ["1/4", "1/2", "3/8"],
                ["1/4", "0", "7/8"],
                ["1/2", "3/4", "1/8"],
                ["0", "3/4", "5/8"],
                ["1/4", "1/2", "7/8"],
                ["1/4", "0", "3/8"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.125],
                    [0.0, 0.5, 0.375],
                    [0.5, 0.0, 0.125],
                    [0.5, 0.5, 0.875],
                    [0.0, 0.5, 0.125],
                    [0.0, 0.0, 0.875],
                    [0.5, 0.5, 0.125],
                    [0.5, 0.0, 0.375],
                ]
            ),
            "expressions": [
                ["0", "0", "z+1/8"],
                ["0", "1/2", "z+3/8"],
                ["1/2", "0", "-z+1/8"],
                ["1/2", "1/2", "-z+7/8"],
                ["0", "1/2", "-z+1/8"],
                ["0", "0", "-z+7/8"],
                ["1/2", "1/2", "z+1/8"],
                ["1/2", "0", "z+3/8"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.75, 0.375],
                    [0.5, 0.75, 0.875],
                    [0.25, 0.5, 0.625],
                    [0.25, 0.0, 0.125],
                    [0.0, 0.75, 0.875],
                    [0.5, 0.75, 0.375],
                    [0.75, 0.0, 0.625],
                    [0.75, 0.5, 0.125],
                ]
            ),
            "expressions": [
                ["x", "3/4", "3/8"],
                ["-x+1/2", "3/4", "7/8"],
                ["1/4", "x+1/2", "5/8"],
                ["1/4", "-x", "1/8"],
                ["-x", "3/4", "7/8"],
                ["x+1/2", "3/4", "3/8"],
                ["3/4", "-x", "5/8"],
                ["3/4", "x+1/2", "1/8"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.5, 0.5, 0.75],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.0, 0.75],
                    [0.5, 0.5, 0.25],
                ]
            ),
            "expressions": [
                ["x", "x", "1/4"],
                ["-x+1/2", "-x+1/2", "3/4"],
                ["-x", "x+1/2", "1/2"],
                ["x+1/2", "-x", "0"],
                ["-x", "-x+1/2", "0"],
                ["x+1/2", "x", "1/2"],
                ["x", "-x", "3/4"],
                ["-x+1/2", "x+1/2", "1/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.75, 0.125],
                    [0.5, 0.75, 0.625],
                    [0.25, 0.5, 0.375],
                    [0.25, 0.0, 0.875],
                    [0.5, 0.75, 0.125],
                    [0.0, 0.75, 0.625],
                    [0.25, 0.5, 0.875],
                    [0.25, 0.0, 0.375],
                    [0.0, 0.75, 0.125],
                    [0.5, 0.75, 0.625],
                    [0.75, 0.0, 0.875],
                    [0.75, 0.5, 0.375],
                    [0.5, 0.75, 0.125],
                    [0.0, 0.75, 0.625],
                    [0.75, 0.0, 0.375],
                    [0.75, 0.5, 0.875],
                ]
            ),
            "expressions": [
                ["x", "y+3/4", "z+1/8"],
                ["-x+1/2", "-y+3/4", "z+5/8"],
                ["-y+1/4", "x+1/2", "z+3/8"],
                ["y+1/4", "-x", "z+7/8"],
                ["-x+1/2", "y+3/4", "-z+1/8"],
                ["x", "-y+3/4", "-z+5/8"],
                ["y+1/4", "x+1/2", "-z+7/8"],
                ["-y+1/4", "-x", "-z+3/8"],
                ["-x", "-y+3/4", "-z+1/8"],
                ["x+1/2", "y+3/4", "-z+5/8"],
                ["y+3/4", "-x", "-z+7/8"],
                ["-y+3/4", "x+1/2", "-z+3/8"],
                ["x+1/2", "-y+3/4", "z+1/8"],
                ["-x", "y+3/4", "z+5/8"],
                ["-y+3/4", "-x", "z+3/8"],
                ["y+3/4", "x+1/2", "z+7/8"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([[0.5, 0.5, 0.5]]),
    },
    143: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.33333333, 0.66666667, 0.0]]),
            "expressions": [["1/3", "2/3", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.66666667, 0.33333333, 0.0]]),
            "expressions": [["2/3", "1/3", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "d": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "y", "z"], ["-y", "x-y", "z"], ["-x+y", "-x", "z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    144: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.33333333], [0.0, 0.0, 0.66666667]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+1/3"],
                ["-x+y", "-x", "z+2/3"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    145: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.66666667], [0.0, 0.0, 0.33333333]]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+2/3"],
                ["-x+y", "-x", "z+1/3"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    146: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "y", "z"], ["-y", "x-y", "z"], ["-x+y", "-x", "z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array(
            [[0.66666667, 0.33333333, 0.33333333], [0.33333333, 0.66666667, 0.66666667]]
        ),
    },
    147: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.66666667, 0.33333333, 0.0]]
            ),
            "expressions": [["1/3", "2/3", "z"], ["2/3", "1/3", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "e": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "0"], ["0", "1/2", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/2"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-x", "-y", "-z"],
                ["y", "-x+y", "-z"],
                ["x-y", "x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    148: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array([[0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/2"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "0"], ["0", "1/2", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-x", "-y", "-z"],
                ["y", "-x+y", "-z"],
                ["x-y", "x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array(
            [[0.66666667, 0.33333333, 0.33333333], [0.33333333, 0.66666667, 0.66666667]]
        ),
    },
    149: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.33333333, 0.66666667, 0.0]]),
            "expressions": [["1/3", "2/3", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.33333333, 0.66666667, 0.5]]),
            "expressions": [["1/3", "2/3", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.66666667, 0.33333333, 0.0]]),
            "expressions": [["2/3", "1/3", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.66666667, 0.33333333, 0.5]]),
            "expressions": [["2/3", "1/3", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.33333333, 0.66666667, 0.0]]
            ),
            "expressions": [["1/3", "2/3", "z"], ["1/3", "2/3", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [[0.66666667, 0.33333333, 0.0], [0.66666667, 0.33333333, 0.0]]
            ),
            "expressions": [["2/3", "1/3", "z"], ["2/3", "1/3", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "-x", "0"], ["x", "2x", "0"], ["-2x", "-x", "0"]],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [
                ["x", "-x", "1/2"],
                ["x", "2x", "1/2"],
                ["-2x", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-y", "-x", "-z"],
                ["-x+y", "y", "-z"],
                ["x", "x-y", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    150: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.66666667, 0.33333333, 0.0]]
            ),
            "expressions": [["1/3", "2/3", "z"], ["2/3", "1/3", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "0"], ["0", "x", "0"], ["-x", "-x", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["x", "0", "1/2"], ["0", "x", "1/2"], ["-x", "-x", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["y", "x", "-z"],
                ["x-y", "-y", "-z"],
                ["-x", "-x+y", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    151: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.33333333], [0.0, 0.0, 0.66666667], [0.0, 0.0, 0.0]]
            ),
            "expressions": [["x", "-x", "1/3"], ["x", "2x", "2/3"], ["-2x", "-x", "0"]],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.83333333], [0.0, 0.0, 0.16666667], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "-x", "5/6"],
                ["x", "2x", "1/6"],
                ["-2x", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+1/3"],
                ["-x+y", "-x", "z+2/3"],
                ["-y", "-x", "-z+2/3"],
                ["-x+y", "y", "-z+1/3"],
                ["x", "x-y", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    152: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.33333333], [0.0, 0.0, 0.66666667], [0.0, 0.0, 0.0]]
            ),
            "expressions": [["x", "0", "1/3"], ["0", "x", "2/3"], ["-x", "-x", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.83333333], [0.0, 0.0, 0.16666667], [0.0, 0.0, 0.5]]
            ),
            "expressions": [["x", "0", "5/6"], ["0", "x", "1/6"], ["-x", "-x", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+1/3"],
                ["-x+y", "-x", "z+2/3"],
                ["y", "x", "-z"],
                ["x-y", "-y", "-z+2/3"],
                ["-x", "-x+y", "-z+1/3"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    153: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.66666667], [0.0, 0.0, 0.33333333], [0.0, 0.0, 0.0]]
            ),
            "expressions": [["x", "-x", "2/3"], ["x", "2x", "1/3"], ["-2x", "-x", "0"]],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.16666667], [0.0, 0.0, 0.83333333], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["x", "-x", "1/6"],
                ["x", "2x", "5/6"],
                ["-2x", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+2/3"],
                ["-x+y", "-x", "z+1/3"],
                ["-y", "-x", "-z+1/3"],
                ["-x+y", "y", "-z+2/3"],
                ["x", "x-y", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    154: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.66666667], [0.0, 0.0, 0.33333333], [0.0, 0.0, 0.0]]
            ),
            "expressions": [["x", "0", "2/3"], ["0", "x", "1/3"], ["-x", "-x", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.16666667], [0.0, 0.0, 0.83333333], [0.0, 0.0, 0.5]]
            ),
            "expressions": [["x", "0", "1/6"], ["0", "x", "5/6"], ["-x", "-x", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+2/3"],
                ["-x+y", "-x", "z+1/3"],
                ["y", "x", "-z"],
                ["x-y", "-y", "-z+1/3"],
                ["-x", "-x+y", "-z+2/3"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    155: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "0"], ["0", "x", "0"], ["-x", "-x", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [["x", "0", "1/2"], ["0", "x", "1/2"], ["-x", "-x", "1/2"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["y", "x", "-z"],
                ["x-y", "-y", "-z"],
                ["-x", "-x+y", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array(
            [[0.66666667, 0.33333333, 0.33333333], [0.33333333, 0.66666667, 0.66666667]]
        ),
    },
    156: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.33333333, 0.66666667, 0.0]]),
            "expressions": [["1/3", "2/3", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.66666667, 0.33333333, 0.0]]),
            "expressions": [["2/3", "1/3", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "d": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "-x", "z"], ["x", "2x", "z"], ["-2x", "-x", "z"]],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-y", "-x", "z"],
                ["-x+y", "y", "z"],
                ["x", "x-y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    157: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.66666667, 0.33333333, 0.0]]
            ),
            "expressions": [["1/3", "2/3", "z"], ["2/3", "1/3", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "0", "z"], ["0", "x", "z"], ["-x", "-x", "z"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["y", "x", "z"],
                ["x-y", "-y", "z"],
                ["-x", "-x+y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    158: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.33333333, 0.66666667, 0.5]]
            ),
            "expressions": [["1/3", "2/3", "z"], ["1/3", "2/3", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [[0.66666667, 0.33333333, 0.0], [0.66666667, 0.33333333, 0.5]]
            ),
            "expressions": [["2/3", "1/3", "z"], ["2/3", "1/3", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-y", "-x", "z+1/2"],
                ["-x+y", "y", "z+1/2"],
                ["x", "x-y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    159: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.66666667, 0.33333333, 0.5]]
            ),
            "expressions": [["1/3", "2/3", "z"], ["2/3", "1/3", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["y", "x", "z+1/2"],
                ["x-y", "-y", "z+1/2"],
                ["-x", "-x+y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    160: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "-x", "z"], ["x", "2x", "z"], ["-2x", "-x", "z"]],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-y", "-x", "z"],
                ["-x+y", "y", "z"],
                ["x", "x-y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array(
            [[0.66666667, 0.33333333, 0.33333333], [0.33333333, 0.66666667, 0.66666667]]
        ),
    },
    161: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-y", "-x", "z+1/2"],
                ["-x+y", "y", "z+1/2"],
                ["x", "x-y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array(
            [[0.66666667, 0.33333333, 0.33333333], [0.33333333, 0.66666667, 0.66666667]]
        ),
    },
    162: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.66666667, 0.33333333, 0.0]]
            ),
            "expressions": [["1/3", "2/3", "0"], ["2/3", "1/3", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.5], [0.66666667, 0.33333333, 0.5]]
            ),
            "expressions": [["1/3", "2/3", "1/2"], ["2/3", "1/3", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "0"], ["0", "1/2", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/2"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "h": {
            "constants": array(
                [
                    [0.33333333, 0.66666667, 0.0],
                    [0.33333333, 0.66666667, 0.0],
                    [0.66666667, 0.33333333, 0.0],
                    [0.66666667, 0.33333333, 0.0],
                ]
            ),
            "expressions": [
                ["1/3", "2/3", "z"],
                ["1/3", "2/3", "-z"],
                ["2/3", "1/3", "-z"],
                ["2/3", "1/3", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "-x", "0"],
                ["x", "2x", "0"],
                ["-2x", "-x", "0"],
                ["-x", "x", "0"],
                ["-x", "-2x", "0"],
                ["2x", "x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "-x", "1/2"],
                ["x", "2x", "1/2"],
                ["-2x", "-x", "1/2"],
                ["-x", "x", "1/2"],
                ["-x", "-2x", "1/2"],
                ["2x", "x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["0", "x", "z"],
                ["-x", "-x", "z"],
                ["0", "-x", "-z"],
                ["-x", "0", "-z"],
                ["x", "x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-y", "-x", "-z"],
                ["-x+y", "y", "-z"],
                ["x", "x-y", "-z"],
                ["-x", "-y", "-z"],
                ["y", "-x+y", "-z"],
                ["x-y", "x", "-z"],
                ["y", "x", "z"],
                ["x-y", "-y", "z"],
                ["-x", "-x+y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    163: {
        "a": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.25], [0.66666667, 0.33333333, 0.75]]
            ),
            "expressions": [["1/3", "2/3", "1/4"], ["2/3", "1/3", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.66666667, 0.33333333, 0.25], [0.33333333, 0.66666667, 0.75]]
            ),
            "expressions": [["2/3", "1/3", "1/4"], ["1/3", "2/3", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z+1/2"],
                ["0", "0", "-z"],
                ["0", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.33333333, 0.66666667, 0.0],
                    [0.33333333, 0.66666667, 0.5],
                    [0.66666667, 0.33333333, 0.0],
                    [0.66666667, 0.33333333, 0.5],
                ]
            ),
            "expressions": [
                ["1/3", "2/3", "z"],
                ["1/3", "2/3", "-z+1/2"],
                ["2/3", "1/3", "-z"],
                ["2/3", "1/3", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["1/2", "0", "0"],
                ["0", "1/2", "0"],
                ["1/2", "1/2", "0"],
                ["0", "1/2", "1/2"],
                ["1/2", "0", "1/2"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "h": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "-x", "1/4"],
                ["x", "2x", "1/4"],
                ["-2x", "-x", "1/4"],
                ["-x", "x", "3/4"],
                ["-x", "-2x", "3/4"],
                ["2x", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-y", "-x", "-z+1/2"],
                ["-x+y", "y", "-z+1/2"],
                ["x", "x-y", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["y", "-x+y", "-z"],
                ["x-y", "x", "-z"],
                ["y", "x", "z+1/2"],
                ["x-y", "-y", "z+1/2"],
                ["-x", "-x+y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    164: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.66666667, 0.33333333, 0.0]]
            ),
            "expressions": [["1/3", "2/3", "z"], ["2/3", "1/3", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "e": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "0"], ["0", "1/2", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/2"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["0", "x", "0"],
                ["-x", "-x", "0"],
                ["-x", "0", "0"],
                ["0", "-x", "0"],
                ["x", "x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "0", "1/2"],
                ["0", "x", "1/2"],
                ["-x", "-x", "1/2"],
                ["-x", "0", "1/2"],
                ["0", "-x", "1/2"],
                ["x", "x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "-x", "z"],
                ["x", "2x", "z"],
                ["-2x", "-x", "z"],
                ["-x", "x", "-z"],
                ["2x", "x", "-z"],
                ["-x", "-2x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["y", "x", "-z"],
                ["x-y", "-y", "-z"],
                ["-x", "-x+y", "-z"],
                ["-x", "-y", "-z"],
                ["y", "-x+y", "-z"],
                ["x-y", "x", "-z"],
                ["-y", "-x", "z"],
                ["-x+y", "y", "z"],
                ["x", "x-y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    165: {
        "a": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z+1/2"],
                ["0", "0", "-z"],
                ["0", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [
                    [0.33333333, 0.66666667, 0.0],
                    [0.66666667, 0.33333333, 0.5],
                    [0.66666667, 0.33333333, 0.0],
                    [0.33333333, 0.66666667, 0.5],
                ]
            ),
            "expressions": [
                ["1/3", "2/3", "z"],
                ["2/3", "1/3", "-z+1/2"],
                ["2/3", "1/3", "-z"],
                ["1/3", "2/3", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "e": {
            "constants": array(
                [
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["1/2", "0", "0"],
                ["0", "1/2", "0"],
                ["1/2", "1/2", "0"],
                ["0", "1/2", "1/2"],
                ["1/2", "0", "1/2"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "0", "1/4"],
                ["0", "x", "1/4"],
                ["-x", "-x", "1/4"],
                ["-x", "0", "3/4"],
                ["0", "-x", "3/4"],
                ["x", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["y", "x", "-z+1/2"],
                ["x-y", "-y", "-z+1/2"],
                ["-x", "-x+y", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["y", "-x+y", "-z"],
                ["x-y", "x", "-z"],
                ["-y", "-x", "z+1/2"],
                ["-x+y", "y", "z+1/2"],
                ["x", "x-y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    166: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array([[0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/2"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "0"], ["0", "1/2", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["0", "x", "0"],
                ["-x", "-x", "0"],
                ["-x", "0", "0"],
                ["0", "-x", "0"],
                ["x", "x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "0", "1/2"],
                ["0", "x", "1/2"],
                ["-x", "-x", "1/2"],
                ["-x", "0", "1/2"],
                ["0", "-x", "1/2"],
                ["x", "x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "-x", "z"],
                ["x", "2x", "z"],
                ["-2x", "-x", "z"],
                ["-x", "x", "-z"],
                ["2x", "x", "-z"],
                ["-x", "-2x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["y", "x", "-z"],
                ["x-y", "-y", "-z"],
                ["-x", "-x+y", "-z"],
                ["-x", "-y", "-z"],
                ["y", "-x+y", "-z"],
                ["x-y", "x", "-z"],
                ["-y", "-x", "z"],
                ["-x+y", "y", "z"],
                ["x", "x-y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array(
            [[0.66666667, 0.33333333, 0.33333333], [0.33333333, 0.66666667, 0.66666667]]
        ),
    },
    167: {
        "a": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "-z+1/2"],
                ["0", "0", "-z"],
                ["0", "0", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["1/2", "0", "0"],
                ["0", "1/2", "0"],
                ["1/2", "1/2", "0"],
                ["0", "1/2", "1/2"],
                ["1/2", "0", "1/2"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "0", "1/4"],
                ["0", "x", "1/4"],
                ["-x", "-x", "1/4"],
                ["-x", "0", "3/4"],
                ["0", "-x", "3/4"],
                ["x", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["y", "x", "-z+1/2"],
                ["x-y", "-y", "-z+1/2"],
                ["-x", "-x+y", "-z+1/2"],
                ["-x", "-y", "-z"],
                ["y", "-x+y", "-z"],
                ["x-y", "x", "-z"],
                ["-y", "-x", "z+1/2"],
                ["-x+y", "y", "z+1/2"],
                ["x", "x-y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array(
            [[0.66666667, 0.33333333, 0.33333333], [0.33333333, 0.66666667, 0.66666667]]
        ),
    },
    168: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.66666667, 0.33333333, 0.0]]
            ),
            "expressions": [["1/3", "2/3", "z"], ["2/3", "1/3", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "z"], ["0", "1/2", "z"], ["1/2", "1/2", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-x", "-y", "z"],
                ["y", "-x+y", "z"],
                ["x-y", "x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    169: {
        "a": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.83333333],
                    [0.0, 0.0, 0.16666667],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+1/3"],
                ["-x+y", "-x", "z+2/3"],
                ["-x", "-y", "z+1/2"],
                ["y", "-x+y", "z+5/6"],
                ["x-y", "x", "z+1/6"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    170: {
        "a": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.16666667],
                    [0.0, 0.0, 0.83333333],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+2/3"],
                ["-x+y", "-x", "z+1/3"],
                ["-x", "-y", "z+1/2"],
                ["y", "-x+y", "z+1/6"],
                ["x-y", "x", "z+5/6"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    171: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.66666667], [0.0, 0.0, 0.33333333]]
            ),
            "expressions": [["0", "0", "z"], ["0", "0", "z+2/3"], ["0", "0", "z+1/3"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.5, 0.5, 0.0], [0.5, 0.0, 0.66666667], [0.0, 0.5, 0.33333333]]
            ),
            "expressions": [
                ["1/2", "1/2", "z"],
                ["1/2", "0", "z+2/3"],
                ["0", "1/2", "z+1/3"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+2/3"],
                ["-x+y", "-x", "z+1/3"],
                ["-x", "-y", "z"],
                ["y", "-x+y", "z+2/3"],
                ["x-y", "x", "z+1/3"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    172: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.33333333], [0.0, 0.0, 0.66666667]]
            ),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/3"], ["0", "0", "z+2/3"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.5, 0.5, 0.0], [0.5, 0.0, 0.33333333], [0.0, 0.5, 0.66666667]]
            ),
            "expressions": [
                ["1/2", "1/2", "z"],
                ["1/2", "0", "z+1/3"],
                ["0", "1/2", "z+2/3"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+1/3"],
                ["-x+y", "-x", "z+2/3"],
                ["-x", "-y", "z"],
                ["y", "-x+y", "z+1/3"],
                ["x-y", "x", "z+2/3"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    173: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.66666667, 0.33333333, 0.5]]
            ),
            "expressions": [["1/3", "2/3", "z"], ["2/3", "1/3", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-x", "-y", "z+1/2"],
                ["y", "-x+y", "z+1/2"],
                ["x-y", "x", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    174: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array([[0.33333333, 0.66666667, 0.0]]),
            "expressions": [["1/3", "2/3", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "d": {
            "constants": array([[0.33333333, 0.66666667, 0.5]]),
            "expressions": [["1/3", "2/3", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.66666667, 0.33333333, 0.0]]),
            "expressions": [["2/3", "1/3", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "f": {
            "constants": array([[0.66666667, 0.33333333, 0.5]]),
            "expressions": [["2/3", "1/3", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "h": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.33333333, 0.66666667, 0.0]]
            ),
            "expressions": [["1/3", "2/3", "z"], ["1/3", "2/3", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [[0.66666667, 0.33333333, 0.0], [0.66666667, 0.33333333, 0.0]]
            ),
            "expressions": [["2/3", "1/3", "z"], ["2/3", "1/3", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["x", "y", "0"], ["-y", "x-y", "0"], ["-x+y", "-x", "0"]],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "k": {
            "constants": array([[0.0, 0.0, 0.5], [0.0, 0.0, 0.5], [0.0, 0.0, 0.5]]),
            "expressions": [
                ["x", "y", "1/2"],
                ["-y", "x-y", "1/2"],
                ["-x+y", "-x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["x", "y", "-z"],
                ["-y", "x-y", "-z"],
                ["-x+y", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    175: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.66666667, 0.33333333, 0.0]]
            ),
            "expressions": [["1/3", "2/3", "0"], ["2/3", "1/3", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.5], [0.66666667, 0.33333333, 0.5]]
            ),
            "expressions": [["1/3", "2/3", "1/2"], ["2/3", "1/3", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "0"], ["0", "1/2", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/2"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "h": {
            "constants": array(
                [
                    [0.33333333, 0.66666667, 0.0],
                    [0.66666667, 0.33333333, 0.0],
                    [0.66666667, 0.33333333, 0.0],
                    [0.33333333, 0.66666667, 0.0],
                ]
            ),
            "expressions": [
                ["1/3", "2/3", "z"],
                ["2/3", "1/3", "z"],
                ["2/3", "1/3", "-z"],
                ["1/3", "2/3", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["1/2", "0", "z"],
                ["0", "1/2", "z"],
                ["1/2", "1/2", "z"],
                ["1/2", "0", "-z"],
                ["0", "1/2", "-z"],
                ["1/2", "1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "0"],
                ["-y", "x-y", "0"],
                ["-x+y", "-x", "0"],
                ["-x", "-y", "0"],
                ["y", "-x+y", "0"],
                ["x-y", "x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "1/2"],
                ["-y", "x-y", "1/2"],
                ["-x+y", "-x", "1/2"],
                ["-x", "-y", "1/2"],
                ["y", "-x+y", "1/2"],
                ["x-y", "x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-x", "-y", "z"],
                ["y", "-x+y", "z"],
                ["x-y", "x", "z"],
                ["-x", "-y", "-z"],
                ["y", "-x+y", "-z"],
                ["x-y", "x", "-z"],
                ["x", "y", "-z"],
                ["-y", "x-y", "-z"],
                ["-x+y", "-x", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    176: {
        "a": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.25], [0.66666667, 0.33333333, 0.75]]
            ),
            "expressions": [["1/3", "2/3", "1/4"], ["2/3", "1/3", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.66666667, 0.33333333, 0.25], [0.33333333, 0.66666667, 0.75]]
            ),
            "expressions": [["2/3", "1/3", "1/4"], ["1/3", "2/3", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "z+1/2"],
                ["0", "0", "-z"],
                ["0", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.33333333, 0.66666667, 0.0],
                    [0.66666667, 0.33333333, 0.5],
                    [0.66666667, 0.33333333, 0.0],
                    [0.33333333, 0.66666667, 0.5],
                ]
            ),
            "expressions": [
                ["1/3", "2/3", "z"],
                ["2/3", "1/3", "z+1/2"],
                ["2/3", "1/3", "-z"],
                ["1/3", "2/3", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.5, 0.0, 0.5],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["1/2", "0", "0"],
                ["0", "1/2", "0"],
                ["1/2", "1/2", "0"],
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/2"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "h": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "y", "1/4"],
                ["-y", "x-y", "1/4"],
                ["-x+y", "-x", "1/4"],
                ["-x", "-y", "3/4"],
                ["y", "-x+y", "3/4"],
                ["x-y", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"y", "x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-x", "-y", "z+1/2"],
                ["y", "-x+y", "z+1/2"],
                ["x-y", "x", "z+1/2"],
                ["-x", "-y", "-z"],
                ["y", "-x+y", "-z"],
                ["x-y", "x", "-z"],
                ["x", "y", "-z+1/2"],
                ["-y", "x-y", "-z+1/2"],
                ["-x+y", "-x", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    177: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "0"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "1/2"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]]),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.66666667, 0.33333333, 0.0]]
            ),
            "expressions": [["1/3", "2/3", "0"], ["2/3", "1/3", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.5], [0.66666667, 0.33333333, 0.5]]
            ),
            "expressions": [["1/3", "2/3", "1/2"], ["2/3", "1/3", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"], ["0", "0", "-z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "0"], ["0", "1/2", "0"], ["1/2", "1/2", "0"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "g": {
            "constants": array([[0.5, 0.0, 0.5], [0.0, 0.5, 0.5], [0.5, 0.5, 0.5]]),
            "expressions": [
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/2"],
                ["1/2", "1/2", "1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "h": {
            "constants": array(
                [
                    [0.33333333, 0.66666667, 0.0],
                    [0.66666667, 0.33333333, 0.0],
                    [0.66666667, 0.33333333, 0.0],
                    [0.33333333, 0.66666667, 0.0],
                ]
            ),
            "expressions": [
                ["1/3", "2/3", "z"],
                ["2/3", "1/3", "z"],
                ["2/3", "1/3", "-z"],
                ["1/3", "2/3", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "i": {
            "constants": array(
                [
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.5, 0.0],
                ]
            ),
            "expressions": [
                ["1/2", "0", "z"],
                ["0", "1/2", "z"],
                ["1/2", "1/2", "z"],
                ["0", "1/2", "-z"],
                ["1/2", "0", "-z"],
                ["1/2", "1/2", "-z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["0", "x", "0"],
                ["-x", "-x", "0"],
                ["-x", "0", "0"],
                ["0", "-x", "0"],
                ["x", "x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "0", "1/2"],
                ["0", "x", "1/2"],
                ["-x", "-x", "1/2"],
                ["-x", "0", "1/2"],
                ["0", "-x", "1/2"],
                ["x", "x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "l": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "-x", "0"],
                ["x", "2x", "0"],
                ["-2x", "-x", "0"],
                ["-x", "x", "0"],
                ["-x", "-2x", "0"],
                ["2x", "x", "0"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "m": {
            "constants": array(
                [
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "-x", "1/2"],
                ["x", "2x", "1/2"],
                ["-2x", "-x", "1/2"],
                ["-x", "x", "1/2"],
                ["-x", "-2x", "1/2"],
                ["2x", "x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "n": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-x", "-y", "z"],
                ["y", "-x+y", "z"],
                ["x-y", "x", "z"],
                ["y", "x", "-z"],
                ["x-y", "-y", "-z"],
                ["-x", "-x+y", "-z"],
                ["-y", "-x", "-z"],
                ["-x+y", "y", "-z"],
                ["x", "x-y", "-z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    178: {
        "a": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.83333333],
                    [0.0, 0.0, 0.16666667],
                ]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["0", "x", "1/3"],
                ["-x", "-x", "2/3"],
                ["-x", "0", "1/2"],
                ["0", "-x", "5/6"],
                ["x", "x", "1/6"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "b": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.58333333],
                    [0.0, 0.0, 11.0],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.08333333],
                    [0.0, 0.0, 0.41666667],
                ]
            ),
            "expressions": [
                ["x", "2x", "1/4"],
                ["-2x", "-x", "7/12"],
                ["x", "-x", "11/12"],
                ["-x", "-2x", "3/4"],
                ["2x", "x", "1/12"],
                ["-x", "x", "5/12"],
            ],
            "matrices": array(
                [
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.83333333],
                    [0.0, 0.0, 0.16666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.83333333],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.16666667],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+1/3"],
                ["-x+y", "-x", "z+2/3"],
                ["-x", "-y", "z+1/2"],
                ["y", "-x+y", "z+5/6"],
                ["x-y", "x", "z+1/6"],
                ["y", "x", "-z+1/3"],
                ["x-y", "-y", "-z"],
                ["-x", "-x+y", "-z+2/3"],
                ["-y", "-x", "-z+5/6"],
                ["-x+y", "y", "-z+1/2"],
                ["x", "x-y", "-z+1/6"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    179: {
        "a": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.16666667],
                    [0.0, 0.0, 0.83333333],
                ]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["0", "x", "2/3"],
                ["-x", "-x", "1/3"],
                ["-x", "0", "1/2"],
                ["0", "-x", "1/6"],
                ["x", "x", "5/6"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "b": {
            "constants": array(
                [
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.41666667],
                    [0.0, 0.0, 0.08333333],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 11.0],
                    [0.0, 0.0, 0.58333333],
                ]
            ),
            "expressions": [
                ["x", "2x", "3/4"],
                ["-2x", "-x", "5/12"],
                ["x", "-x", "1/12"],
                ["-x", "-2x", "1/4"],
                ["2x", "x", "11/12"],
                ["-x", "x", "7/12"],
            ],
            "matrices": array(
                [
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.16666667],
                    [0.0, 0.0, 0.83333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.16666667],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.83333333],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+2/3"],
                ["-x+y", "-x", "z+1/3"],
                ["-x", "-y", "z+1/2"],
                ["y", "-x+y", "z+1/6"],
                ["x-y", "x", "z+5/6"],
                ["y", "x", "-z+2/3"],
                ["x-y", "-y", "-z"],
                ["-x", "-x+y", "-z+1/3"],
                ["-y", "-x", "-z+1/6"],
                ["-x+y", "y", "-z+1/2"],
                ["x", "x-y", "-z+5/6"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    180: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.66666667], [0.0, 0.0, 0.33333333]]
            ),
            "expressions": [["0", "0", "0"], ["0", "0", "2/3"], ["0", "0", "1/3"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.16666667], [0.0, 0.0, 0.83333333]]
            ),
            "expressions": [["0", "0", "1/2"], ["0", "0", "1/6"], ["0", "0", "5/6"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.5, 0.0, 0.0], [0.0, 0.5, 0.66666667], [0.5, 0.5, 0.33333333]]
            ),
            "expressions": [
                ["1/2", "0", "0"],
                ["0", "1/2", "2/3"],
                ["1/2", "1/2", "1/3"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.5, 0.0, 0.5], [0.0, 0.5, 0.16666667], [0.5, 0.5, 0.83333333]]
            ),
            "expressions": [
                ["1/2", "0", "1/2"],
                ["0", "1/2", "1/6"],
                ["1/2", "1/2", "5/6"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                ]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "z+2/3"],
                ["0", "0", "z+1/3"],
                ["0", "0", "-z+2/3"],
                ["0", "0", "-z"],
                ["0", "0", "-z+1/3"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.66666667],
                    [0.5, 0.5, 0.33333333],
                    [0.0, 0.5, 0.66666667],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.5, 0.33333333],
                ]
            ),
            "expressions": [
                ["1/2", "0", "z"],
                ["0", "1/2", "z+2/3"],
                ["1/2", "1/2", "z+1/3"],
                ["0", "1/2", "-z+2/3"],
                ["1/2", "0", "-z"],
                ["1/2", "1/2", "-z+1/3"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                ]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["0", "x", "2/3"],
                ["-x", "-x", "1/3"],
                ["-x", "0", "0"],
                ["0", "-x", "2/3"],
                ["x", "x", "1/3"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.16666667],
                    [0.0, 0.0, 0.83333333],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.16666667],
                    [0.0, 0.0, 0.83333333],
                ]
            ),
            "expressions": [
                ["x", "0", "1/2"],
                ["0", "x", "1/6"],
                ["-x", "-x", "5/6"],
                ["-x", "0", "1/2"],
                ["0", "-x", "1/6"],
                ["x", "x", "5/6"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                ]
            ),
            "expressions": [
                ["x", "2x", "0"],
                ["-2x", "-x", "2/3"],
                ["x", "-x", "1/3"],
                ["-x", "-2x", "0"],
                ["2x", "x", "2/3"],
                ["-x", "x", "1/3"],
            ],
            "matrices": array(
                [
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.16666667],
                    [0.0, 0.0, 0.83333333],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.16666667],
                    [0.0, 0.0, 0.83333333],
                ]
            ),
            "expressions": [
                ["x", "2x", "1/2"],
                ["-2x", "-x", "1/6"],
                ["x", "-x", "5/6"],
                ["-x", "-2x", "1/2"],
                ["2x", "x", "1/6"],
                ["-x", "x", "5/6"],
            ],
            "matrices": array(
                [
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+2/3"],
                ["-x+y", "-x", "z+1/3"],
                ["-x", "-y", "z"],
                ["y", "-x+y", "z+2/3"],
                ["x-y", "x", "z+1/3"],
                ["y", "x", "-z+2/3"],
                ["x-y", "-y", "-z"],
                ["-x", "-x+y", "-z+1/3"],
                ["-y", "-x", "-z+2/3"],
                ["-x+y", "y", "-z"],
                ["x", "x-y", "-z+1/3"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    181: {
        "a": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.33333333], [0.0, 0.0, 0.66666667]]
            ),
            "expressions": [["0", "0", "0"], ["0", "0", "1/3"], ["0", "0", "2/3"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array(
                [[0.0, 0.0, 0.5], [0.0, 0.0, 0.83333333], [0.0, 0.0, 0.16666667]]
            ),
            "expressions": [["0", "0", "1/2"], ["0", "0", "5/6"], ["0", "0", "1/6"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.5, 0.0, 0.0], [0.0, 0.5, 0.33333333], [0.5, 0.5, 0.66666667]]
            ),
            "expressions": [
                ["1/2", "0", "0"],
                ["0", "1/2", "1/3"],
                ["1/2", "1/2", "2/3"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.5, 0.0, 0.5], [0.0, 0.5, 0.83333333], [0.5, 0.5, 0.16666667]]
            ),
            "expressions": [
                ["1/2", "0", "1/2"],
                ["0", "1/2", "5/6"],
                ["1/2", "1/2", "1/6"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                ]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "z+1/3"],
                ["0", "0", "z+2/3"],
                ["0", "0", "-z+1/3"],
                ["0", "0", "-z"],
                ["0", "0", "-z+2/3"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.33333333],
                    [0.5, 0.5, 0.66666667],
                    [0.0, 0.5, 0.33333333],
                    [0.5, 0.0, 0.0],
                    [0.5, 0.5, 0.66666667],
                ]
            ),
            "expressions": [
                ["1/2", "0", "z"],
                ["0", "1/2", "z+1/3"],
                ["1/2", "1/2", "z+2/3"],
                ["0", "1/2", "-z+1/3"],
                ["1/2", "0", "-z"],
                ["1/2", "1/2", "-z+2/3"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                ]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["0", "x", "1/3"],
                ["-x", "-x", "2/3"],
                ["-x", "0", "0"],
                ["0", "-x", "1/3"],
                ["x", "x", "2/3"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.83333333],
                    [0.0, 0.0, 0.16666667],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.83333333],
                    [0.0, 0.0, 0.16666667],
                ]
            ),
            "expressions": [
                ["x", "0", "1/2"],
                ["0", "x", "5/6"],
                ["-x", "-x", "1/6"],
                ["-x", "0", "1/2"],
                ["0", "-x", "5/6"],
                ["x", "x", "1/6"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                ]
            ),
            "expressions": [
                ["x", "2x", "0"],
                ["-2x", "-x", "1/3"],
                ["x", "-x", "2/3"],
                ["-x", "-2x", "0"],
                ["2x", "x", "1/3"],
                ["-x", "x", "2/3"],
            ],
            "matrices": array(
                [
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "j": {
            "constants": array(
                [
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.83333333],
                    [0.0, 0.0, 0.16666667],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.83333333],
                    [0.0, 0.0, 0.16666667],
                ]
            ),
            "expressions": [
                ["x", "2x", "1/2"],
                ["-2x", "-x", "5/6"],
                ["x", "-x", "1/6"],
                ["-x", "-2x", "1/2"],
                ["2x", "x", "5/6"],
                ["-x", "x", "1/6"],
            ],
            "matrices": array(
                [
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "k": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                    [0.0, 0.0, 0.33333333],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.66666667],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z+1/3"],
                ["-x+y", "-x", "z+2/3"],
                ["-x", "-y", "z"],
                ["y", "-x+y", "z+1/3"],
                ["x-y", "x", "z+2/3"],
                ["y", "x", "-z+1/3"],
                ["x-y", "-y", "-z"],
                ["-x", "-x+y", "-z+2/3"],
                ["-y", "-x", "-z+1/3"],
                ["-x+y", "y", "-z"],
                ["x", "x-y", "-z+2/3"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    182: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "0"], ["0", "0", "1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "b": {
            "constants": array([[0.0, 0.0, 0.25], [0.0, 0.0, 0.75]]),
            "expressions": [["0", "0", "1/4"], ["0", "0", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "c": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.25], [0.66666667, 0.33333333, 0.75]]
            ),
            "expressions": [["1/3", "2/3", "1/4"], ["2/3", "1/3", "3/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "d": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.75], [0.66666667, 0.33333333, 0.25]]
            ),
            "expressions": [["1/3", "2/3", "3/4"], ["2/3", "1/3", "1/4"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": set(),
        },
        "e": {
            "constants": array(
                [[0.0, 0.0, 0.0], [0.0, 0.0, 0.5], [0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]
            ),
            "expressions": [
                ["0", "0", "z"],
                ["0", "0", "z+1/2"],
                ["0", "0", "-z"],
                ["0", "0", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "f": {
            "constants": array(
                [
                    [0.33333333, 0.66666667, 0.0],
                    [0.66666667, 0.33333333, 0.5],
                    [0.66666667, 0.33333333, 0.0],
                    [0.33333333, 0.66666667, 0.5],
                ]
            ),
            "expressions": [
                ["1/3", "2/3", "z"],
                ["2/3", "1/3", "z+1/2"],
                ["2/3", "1/3", "-z"],
                ["1/3", "2/3", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "g": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "0", "0"],
                ["0", "x", "0"],
                ["-x", "-x", "0"],
                ["-x", "0", "1/2"],
                ["0", "-x", "1/2"],
                ["x", "x", "1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "h": {
            "constants": array(
                [
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.25],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                    [0.0, 0.0, 0.75],
                ]
            ),
            "expressions": [
                ["x", "2x", "1/4"],
                ["-2x", "-x", "1/4"],
                ["x", "-x", "1/4"],
                ["-x", "-2x", "3/4"],
                ["2x", "x", "3/4"],
                ["-x", "x", "3/4"],
            ],
            "matrices": array(
                [
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 0.0]],
                ]
            ),
            "variables": {"x"},
        },
        "i": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-x", "-y", "z+1/2"],
                ["y", "-x+y", "z+1/2"],
                ["x-y", "x", "z+1/2"],
                ["y", "x", "-z"],
                ["x-y", "-y", "-z"],
                ["-x", "-x+y", "-z"],
                ["-y", "-x", "-z+1/2"],
                ["-x+y", "y", "-z+1/2"],
                ["x", "x-y", "-z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, -1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, -1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, -1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    183: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0]]),
            "expressions": [["0", "0", "z"]],
            "matrices": array([[[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]]]),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [[0.33333333, 0.66666667, 0.0], [0.66666667, 0.33333333, 0.0]]
            ),
            "expressions": [["1/3", "2/3", "z"], ["2/3", "1/3", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array([[0.5, 0.0, 0.0], [0.0, 0.5, 0.0], [0.5, 0.5, 0.0]]),
            "expressions": [["1/2", "0", "z"], ["0", "1/2", "z"], ["1/2", "1/2", "z"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["0", "x", "z"],
                ["-x", "-x", "z"],
                ["-x", "0", "z"],
                ["0", "-x", "z"],
                ["x", "x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "e": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "-x", "z"],
                ["x", "2x", "z"],
                ["-2x", "-x", "z"],
                ["-x", "x", "z"],
                ["-x", "-2x", "z"],
                ["2x", "x", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-2.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -2.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[2.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "f": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-x", "-y", "z"],
                ["y", "-x+y", "z"],
                ["x-y", "x", "z"],
                ["-y", "-x", "z"],
                ["-x+y", "y", "z"],
                ["x", "x-y", "z"],
                ["y", "x", "z"],
                ["x-y", "-y", "z"],
                ["-x", "-x+y", "z"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    184: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [
                    [0.33333333, 0.66666667, 0.0],
                    [0.66666667, 0.33333333, 0.0],
                    [0.33333333, 0.66666667, 0.5],
                    [0.66666667, 0.33333333, 0.5],
                ]
            ),
            "expressions": [
                ["1/3", "2/3", "z"],
                ["2/3", "1/3", "z"],
                ["1/3", "2/3", "z+1/2"],
                ["2/3", "1/3", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [
                    [0.5, 0.0, 0.0],
                    [0.0, 0.5, 0.0],
                    [0.5, 0.5, 0.0],
                    [0.0, 0.5, 0.5],
                    [0.5, 0.0, 0.5],
                    [0.5, 0.5, 0.5],
                ]
            ),
            "expressions": [
                ["1/2", "0", "z"],
                ["0", "1/2", "z"],
                ["1/2", "1/2", "z"],
                ["0", "1/2", "z+1/2"],
                ["1/2", "0", "z+1/2"],
                ["1/2", "1/2", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-x", "-y", "z"],
                ["y", "-x+y", "z"],
                ["x-y", "x", "z"],
                ["-y", "-x", "z+1/2"],
                ["-x+y", "y", "z+1/2"],
                ["x", "x-y", "z+1/2"],
                ["y", "x", "z+1/2"],
                ["x-y", "-y", "z+1/2"],
                ["-x", "-x+y", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [-1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [1.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [1.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 0.0, 0.0], [-1.0, -1.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 1.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"y", "x", "z"},
        },
        "translations": array([]),
    },
    185: {
        "a": {
            "constants": array([[0.0, 0.0, 0.0], [0.0, 0.0, 0.5]]),
            "expressions": [["0", "0", "z"], ["0", "0", "z+1/2"]],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "b": {
            "constants": array(
                [
                    [0.33333333, 0.66666667, 0.0],
                    [0.66666667, 0.33333333, 0.5],
                    [0.33333333, 0.66666667, 0.5],
                    [0.66666667, 0.33333333, 0.0],
                ]
            ),
            "expressions": [
                ["1/3", "2/3", "z"],
                ["2/3", "1/3", "z+1/2"],
                ["1/3", "2/3", "z+1/2"],
                ["2/3", "1/3", "z"],
            ],
            "matrices": array(
                [
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z"},
        },
        "c": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                ]
            ),
            "expressions": [
                ["x", "0", "z"],
                ["0", "x", "z"],
                ["-x", "-x", "z"],
                ["-x", "0", "z+1/2"],
                ["0", "-x", "z+1/2"],
                ["x", "x", "z+1/2"],
            ],
            "matrices": array(
                [
                    [[1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[-1.0, 0.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[0.0, -1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                    [[1.0, 1.0, 0.0], [0.0, 0.0, 0.0], [0.0, 0.0, 1.0]],
                ]
            ),
            "variables": {"z", "x"},
        },
        "d": {
            "constants": array(
                [
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.5],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                    [0.0, 0.0, 0.0],
                ]
            ),
            "expressions": [
                ["x", "y", "z"],
                ["-y", "x-y", "z"],
                ["-x+y", "-x", "z"],
                ["-x", "-y", "z+1/2"],
                ["y", "-x+y", "z+1/2"],
                ["x-y", "x", "z+1/2"],
                ["-y", "-x", "z+1/2"],
                ["-x+y", "y", "z+1/2"],
                ["x", "x-y", "z+1/2"],
                ["y", "x", "z"],
                ["x-y", "-y", "z"],
                ["-x", "-x+y", "z"],
            ],
     