# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ApiKeyArgs', 'ApiKey']

@pulumi.input_type
class ApiKeyArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 org_id: pulumi.Input[str],
                 role_names: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a ApiKey resource.
        :param pulumi.Input[str] description: Description of this Organization API key.
        :param pulumi.Input[str] org_id: Unique identifier for the organization whose API keys you want to retrieve. Use the /orgs endpoint to retrieve all organizations to which the authenticated user has access.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_names: Name of the role. This resource returns all the roles the user has in Atlas.
               The following are valid roles:
               * `ORG_OWNER`
               * `ORG_GROUP_CREATOR`
               * `ORG_BILLING_ADMIN`
               * `ORG_READ_ONLY`
               * `ORG_MEMBER`
               
               ## Attributes Reference
               
               In addition to all arguments above, the following attributes are exported:
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "org_id", org_id)
        pulumi.set(__self__, "role_names", role_names)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        Description of this Organization API key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Input[str]:
        """
        Unique identifier for the organization whose API keys you want to retrieve. Use the /orgs endpoint to retrieve all organizations to which the authenticated user has access.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="roleNames")
    def role_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Name of the role. This resource returns all the roles the user has in Atlas.
        The following are valid roles:
        * `ORG_OWNER`
        * `ORG_GROUP_CREATOR`
        * `ORG_BILLING_ADMIN`
        * `ORG_READ_ONLY`
        * `ORG_MEMBER`

        ## Attributes Reference

        In addition to all arguments above, the following attributes are exported:
        """
        return pulumi.get(self, "role_names")

    @role_names.setter
    def role_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "role_names", value)


@pulumi.input_type
class _ApiKeyState:
    def __init__(__self__, *,
                 api_key_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 role_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ApiKey resources.
        :param pulumi.Input[str] api_key_id: Unique identifier for this Organization API key.
        :param pulumi.Input[str] description: Description of this Organization API key.
        :param pulumi.Input[str] org_id: Unique identifier for the organization whose API keys you want to retrieve. Use the /orgs endpoint to retrieve all organizations to which the authenticated user has access.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_names: Name of the role. This resource returns all the roles the user has in Atlas.
               The following are valid roles:
               * `ORG_OWNER`
               * `ORG_GROUP_CREATOR`
               * `ORG_BILLING_ADMIN`
               * `ORG_READ_ONLY`
               * `ORG_MEMBER`
               
               ## Attributes Reference
               
               In addition to all arguments above, the following attributes are exported:
        """
        if api_key_id is not None:
            pulumi.set(__self__, "api_key_id", api_key_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if role_names is not None:
            pulumi.set(__self__, "role_names", role_names)

    @property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for this Organization API key.
        """
        return pulumi.get(self, "api_key_id")

    @api_key_id.setter
    def api_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "api_key_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of this Organization API key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for the organization whose API keys you want to retrieve. Use the /orgs endpoint to retrieve all organizations to which the authenticated user has access.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "org_id", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="roleNames")
    def role_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Name of the role. This resource returns all the roles the user has in Atlas.
        The following are valid roles:
        * `ORG_OWNER`
        * `ORG_GROUP_CREATOR`
        * `ORG_BILLING_ADMIN`
        * `ORG_READ_ONLY`
        * `ORG_MEMBER`

        ## Attributes Reference

        In addition to all arguments above, the following attributes are exported:
        """
        return pulumi.get(self, "role_names")

    @role_names.setter
    def role_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "role_names", value)


class ApiKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 role_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.ApiKey("test",
            description="key-name",
            org_id="<ORG_ID>",
            role_names=["ORG_READ_ONLY"])
        ```

        ## Import

        API Keys must be imported using org ID, API Key ID e.g.

        ```sh
        $ pulumi import mongodbatlas:index/apiKey:ApiKey test 5d09d6a59ccf6445652a444a-6576974933969669
        ```
        See [MongoDB Atlas API - API Key](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Programmatic-API-Keys/operation/createApiKey) Documentation for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of this Organization API key.
        :param pulumi.Input[str] org_id: Unique identifier for the organization whose API keys you want to retrieve. Use the /orgs endpoint to retrieve all organizations to which the authenticated user has access.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_names: Name of the role. This resource returns all the roles the user has in Atlas.
               The following are valid roles:
               * `ORG_OWNER`
               * `ORG_GROUP_CREATOR`
               * `ORG_BILLING_ADMIN`
               * `ORG_READ_ONLY`
               * `ORG_MEMBER`
               
               ## Attributes Reference
               
               In addition to all arguments above, the following attributes are exported:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.ApiKey("test",
            description="key-name",
            org_id="<ORG_ID>",
            role_names=["ORG_READ_ONLY"])
        ```

        ## Import

        API Keys must be imported using org ID, API Key ID e.g.

        ```sh
        $ pulumi import mongodbatlas:index/apiKey:ApiKey test 5d09d6a59ccf6445652a444a-6576974933969669
        ```
        See [MongoDB Atlas API - API Key](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Programmatic-API-Keys/operation/createApiKey) Documentation for more information.

        :param str resource_name: The name of the resource.
        :param ApiKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 org_id: Optional[pulumi.Input[str]] = None,
                 role_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiKeyArgs.__new__(ApiKeyArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if org_id is None and not opts.urn:
                raise TypeError("Missing required property 'org_id'")
            __props__.__dict__["org_id"] = org_id
            if role_names is None and not opts.urn:
                raise TypeError("Missing required property 'role_names'")
            __props__.__dict__["role_names"] = role_names
            __props__.__dict__["api_key_id"] = None
            __props__.__dict__["private_key"] = None
            __props__.__dict__["public_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ApiKey, __self__).__init__(
            'mongodbatlas:index/apiKey:ApiKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            org_id: Optional[pulumi.Input[str]] = None,
            private_key: Optional[pulumi.Input[str]] = None,
            public_key: Optional[pulumi.Input[str]] = None,
            role_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'ApiKey':
        """
        Get an existing ApiKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_key_id: Unique identifier for this Organization API key.
        :param pulumi.Input[str] description: Description of this Organization API key.
        :param pulumi.Input[str] org_id: Unique identifier for the organization whose API keys you want to retrieve. Use the /orgs endpoint to retrieve all organizations to which the authenticated user has access.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_names: Name of the role. This resource returns all the roles the user has in Atlas.
               The following are valid roles:
               * `ORG_OWNER`
               * `ORG_GROUP_CREATOR`
               * `ORG_BILLING_ADMIN`
               * `ORG_READ_ONLY`
               * `ORG_MEMBER`
               
               ## Attributes Reference
               
               In addition to all arguments above, the following attributes are exported:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiKeyState.__new__(_ApiKeyState)

        __props__.__dict__["api_key_id"] = api_key_id
        __props__.__dict__["description"] = description
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["role_names"] = role_names
        return ApiKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> pulumi.Output[str]:
        """
        Unique identifier for this Organization API key.
        """
        return pulumi.get(self, "api_key_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of this Organization API key.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[str]:
        """
        Unique identifier for the organization whose API keys you want to retrieve. Use the /orgs endpoint to retrieve all organizations to which the authenticated user has access.
        """
        return pulumi.get(self, "org_id")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[str]:
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[str]:
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="roleNames")
    def role_names(self) -> pulumi.Output[Sequence[str]]:
        """
        Name of the role. This resource returns all the roles the user has in Atlas.
        The following are valid roles:
        * `ORG_OWNER`
        * `ORG_GROUP_CREATOR`
        * `ORG_BILLING_ADMIN`
        * `ORG_READ_ONLY`
        * `ORG_MEMBER`

        ## Attributes Reference

        In addition to all arguments above, the following attributes are exported:
        """
        return pulumi.get(self, "role_names")

