# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseUserArgs', 'DatabaseUser']

@pulumi.input_type
class DatabaseUserArgs:
    def __init__(__self__, *,
                 auth_database_name: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 username: pulumi.Input[str],
                 aws_iam_type: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserLabelArgs']]]] = None,
                 ldap_auth_type: Optional[pulumi.Input[str]] = None,
                 oidc_auth_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserScopeArgs']]]] = None,
                 x509_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DatabaseUser resource.
        :param pulumi.Input[str] auth_database_name: Database against which Atlas authenticates the user. A user must provide both a username and authentication database to log into MongoDB.
               Accepted values include:
        :param pulumi.Input[str] project_id: The unique ID for the project to create the database user.
        :param pulumi.Input[str] username: Username for authenticating to MongoDB. USER_ARN or ROLE_ARN if `aws_iam_type` is USER or ROLE.
        :param pulumi.Input[str] aws_iam_type: If this value is set, the new database user authenticates with AWS IAM credentials. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
               * `NONE` -	The user does not use AWS IAM credentials.
               * `USER` - New database user has AWS IAM user credentials.
               * `ROLE` -  New database user has credentials associated with an AWS IAM role.
        :param pulumi.Input[str] ldap_auth_type: Method by which the provided `username` is authenticated. If no value is given, Atlas uses the default value of `NONE`.
               * `NONE` -	Atlas authenticates this user through [SCRAM-SHA](https://docs.mongodb.com/manual/core/security-scram/), not LDAP.
               * `USER` - LDAP server authenticates this user through the user's LDAP user. `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
               * `GROUP` - LDAP server authenticates this user using their LDAP user and authorizes this user using their LDAP group. To learn more about LDAP security, see [Set up User Authentication and Authorization with LDAP](https://docs.atlas.mongodb.com/security-ldaps). `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
        :param pulumi.Input[str] oidc_auth_type: Human-readable label that indicates whether the new database user authenticates with OIDC (OpenID Connect) federated authentication. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
               * `NONE` -	The user does not use OIDC federated authentication.
               * `IDP_GROUP` - OIDC Workforce federated authentication group. To learn more about OIDC federated authentication, see [Set up Workforce Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
               * `USER` - OIDC Workload federated authentication user. To learn more about OIDC federated authentication, see [Set up Workload Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]] roles: List of user’s roles and the databases / collections on which the roles apply. A role allows the user to perform particular actions on the specified database. A role on the admin database can include privileges that apply to the other databases as well. See Roles below for more details.
        :param pulumi.Input[str] x509_type: X.509 method by which the provided username is authenticated. If no value is given, Atlas uses the default value of NONE. The accepted types are:
               * `NONE` -	The user does not use X.509 authentication.
               * `MANAGED` - The user is being created for use with Atlas-managed X.509.Externally authenticated users can only be created on the `$external` database.
               * `CUSTOMER` -  The user is being created for use with Self-Managed X.509. Users created with this x509Type require a Common Name (CN) in the username field. Externally authenticated users can only be created on the `$external` database.
        """
        pulumi.set(__self__, "auth_database_name", auth_database_name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "username", username)
        if aws_iam_type is not None:
            pulumi.set(__self__, "aws_iam_type", aws_iam_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if ldap_auth_type is not None:
            pulumi.set(__self__, "ldap_auth_type", ldap_auth_type)
        if oidc_auth_type is not None:
            pulumi.set(__self__, "oidc_auth_type", oidc_auth_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if x509_type is not None:
            pulumi.set(__self__, "x509_type", x509_type)

    @property
    @pulumi.getter(name="authDatabaseName")
    def auth_database_name(self) -> pulumi.Input[str]:
        """
        Database against which Atlas authenticates the user. A user must provide both a username and authentication database to log into MongoDB.
        Accepted values include:
        """
        return pulumi.get(self, "auth_database_name")

    @auth_database_name.setter
    def auth_database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_database_name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The unique ID for the project to create the database user.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Username for authenticating to MongoDB. USER_ARN or ROLE_ARN if `aws_iam_type` is USER or ROLE.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="awsIamType")
    def aws_iam_type(self) -> Optional[pulumi.Input[str]]:
        """
        If this value is set, the new database user authenticates with AWS IAM credentials. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
        * `NONE` -	The user does not use AWS IAM credentials.
        * `USER` - New database user has AWS IAM user credentials.
        * `ROLE` -  New database user has credentials associated with an AWS IAM role.
        """
        return pulumi.get(self, "aws_iam_type")

    @aws_iam_type.setter
    def aws_iam_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_iam_type", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserLabelArgs']]]]:
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="ldapAuthType")
    def ldap_auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        Method by which the provided `username` is authenticated. If no value is given, Atlas uses the default value of `NONE`.
        * `NONE` -	Atlas authenticates this user through [SCRAM-SHA](https://docs.mongodb.com/manual/core/security-scram/), not LDAP.
        * `USER` - LDAP server authenticates this user through the user's LDAP user. `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
        * `GROUP` - LDAP server authenticates this user using their LDAP user and authorizes this user using their LDAP group. To learn more about LDAP security, see [Set up User Authentication and Authorization with LDAP](https://docs.atlas.mongodb.com/security-ldaps). `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
        """
        return pulumi.get(self, "ldap_auth_type")

    @ldap_auth_type.setter
    def ldap_auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ldap_auth_type", value)

    @property
    @pulumi.getter(name="oidcAuthType")
    def oidc_auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable label that indicates whether the new database user authenticates with OIDC (OpenID Connect) federated authentication. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
        * `NONE` -	The user does not use OIDC federated authentication.
        * `IDP_GROUP` - OIDC Workforce federated authentication group. To learn more about OIDC federated authentication, see [Set up Workforce Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
        * `USER` - OIDC Workload federated authentication user. To learn more about OIDC federated authentication, see [Set up Workload Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
        """
        return pulumi.get(self, "oidc_auth_type")

    @oidc_auth_type.setter
    def oidc_auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oidc_auth_type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]]]:
        """
        List of user’s roles and the databases / collections on which the roles apply. A role allows the user to perform particular actions on the specified database. A role on the admin database can include privileges that apply to the other databases as well. See Roles below for more details.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserScopeArgs']]]]:
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserScopeArgs']]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="x509Type")
    def x509_type(self) -> Optional[pulumi.Input[str]]:
        """
        X.509 method by which the provided username is authenticated. If no value is given, Atlas uses the default value of NONE. The accepted types are:
        * `NONE` -	The user does not use X.509 authentication.
        * `MANAGED` - The user is being created for use with Atlas-managed X.509.Externally authenticated users can only be created on the `$external` database.
        * `CUSTOMER` -  The user is being created for use with Self-Managed X.509. Users created with this x509Type require a Common Name (CN) in the username field. Externally authenticated users can only be created on the `$external` database.
        """
        return pulumi.get(self, "x509_type")

    @x509_type.setter
    def x509_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509_type", value)


@pulumi.input_type
class _DatabaseUserState:
    def __init__(__self__, *,
                 auth_database_name: Optional[pulumi.Input[str]] = None,
                 aws_iam_type: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserLabelArgs']]]] = None,
                 ldap_auth_type: Optional[pulumi.Input[str]] = None,
                 oidc_auth_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserScopeArgs']]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 x509_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DatabaseUser resources.
        :param pulumi.Input[str] auth_database_name: Database against which Atlas authenticates the user. A user must provide both a username and authentication database to log into MongoDB.
               Accepted values include:
        :param pulumi.Input[str] aws_iam_type: If this value is set, the new database user authenticates with AWS IAM credentials. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
               * `NONE` -	The user does not use AWS IAM credentials.
               * `USER` - New database user has AWS IAM user credentials.
               * `ROLE` -  New database user has credentials associated with an AWS IAM role.
        :param pulumi.Input[str] ldap_auth_type: Method by which the provided `username` is authenticated. If no value is given, Atlas uses the default value of `NONE`.
               * `NONE` -	Atlas authenticates this user through [SCRAM-SHA](https://docs.mongodb.com/manual/core/security-scram/), not LDAP.
               * `USER` - LDAP server authenticates this user through the user's LDAP user. `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
               * `GROUP` - LDAP server authenticates this user using their LDAP user and authorizes this user using their LDAP group. To learn more about LDAP security, see [Set up User Authentication and Authorization with LDAP](https://docs.atlas.mongodb.com/security-ldaps). `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
        :param pulumi.Input[str] oidc_auth_type: Human-readable label that indicates whether the new database user authenticates with OIDC (OpenID Connect) federated authentication. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
               * `NONE` -	The user does not use OIDC federated authentication.
               * `IDP_GROUP` - OIDC Workforce federated authentication group. To learn more about OIDC federated authentication, see [Set up Workforce Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
               * `USER` - OIDC Workload federated authentication user. To learn more about OIDC federated authentication, see [Set up Workload Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
        :param pulumi.Input[str] project_id: The unique ID for the project to create the database user.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]] roles: List of user’s roles and the databases / collections on which the roles apply. A role allows the user to perform particular actions on the specified database. A role on the admin database can include privileges that apply to the other databases as well. See Roles below for more details.
        :param pulumi.Input[str] username: Username for authenticating to MongoDB. USER_ARN or ROLE_ARN if `aws_iam_type` is USER or ROLE.
        :param pulumi.Input[str] x509_type: X.509 method by which the provided username is authenticated. If no value is given, Atlas uses the default value of NONE. The accepted types are:
               * `NONE` -	The user does not use X.509 authentication.
               * `MANAGED` - The user is being created for use with Atlas-managed X.509.Externally authenticated users can only be created on the `$external` database.
               * `CUSTOMER` -  The user is being created for use with Self-Managed X.509. Users created with this x509Type require a Common Name (CN) in the username field. Externally authenticated users can only be created on the `$external` database.
        """
        if auth_database_name is not None:
            pulumi.set(__self__, "auth_database_name", auth_database_name)
        if aws_iam_type is not None:
            pulumi.set(__self__, "aws_iam_type", aws_iam_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if ldap_auth_type is not None:
            pulumi.set(__self__, "ldap_auth_type", ldap_auth_type)
        if oidc_auth_type is not None:
            pulumi.set(__self__, "oidc_auth_type", oidc_auth_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if x509_type is not None:
            pulumi.set(__self__, "x509_type", x509_type)

    @property
    @pulumi.getter(name="authDatabaseName")
    def auth_database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Database against which Atlas authenticates the user. A user must provide both a username and authentication database to log into MongoDB.
        Accepted values include:
        """
        return pulumi.get(self, "auth_database_name")

    @auth_database_name.setter
    def auth_database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_database_name", value)

    @property
    @pulumi.getter(name="awsIamType")
    def aws_iam_type(self) -> Optional[pulumi.Input[str]]:
        """
        If this value is set, the new database user authenticates with AWS IAM credentials. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
        * `NONE` -	The user does not use AWS IAM credentials.
        * `USER` - New database user has AWS IAM user credentials.
        * `ROLE` -  New database user has credentials associated with an AWS IAM role.
        """
        return pulumi.get(self, "aws_iam_type")

    @aws_iam_type.setter
    def aws_iam_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_iam_type", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserLabelArgs']]]]:
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="ldapAuthType")
    def ldap_auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        Method by which the provided `username` is authenticated. If no value is given, Atlas uses the default value of `NONE`.
        * `NONE` -	Atlas authenticates this user through [SCRAM-SHA](https://docs.mongodb.com/manual/core/security-scram/), not LDAP.
        * `USER` - LDAP server authenticates this user through the user's LDAP user. `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
        * `GROUP` - LDAP server authenticates this user using their LDAP user and authorizes this user using their LDAP group. To learn more about LDAP security, see [Set up User Authentication and Authorization with LDAP](https://docs.atlas.mongodb.com/security-ldaps). `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
        """
        return pulumi.get(self, "ldap_auth_type")

    @ldap_auth_type.setter
    def ldap_auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ldap_auth_type", value)

    @property
    @pulumi.getter(name="oidcAuthType")
    def oidc_auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable label that indicates whether the new database user authenticates with OIDC (OpenID Connect) federated authentication. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
        * `NONE` -	The user does not use OIDC federated authentication.
        * `IDP_GROUP` - OIDC Workforce federated authentication group. To learn more about OIDC federated authentication, see [Set up Workforce Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
        * `USER` - OIDC Workload federated authentication user. To learn more about OIDC federated authentication, see [Set up Workload Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
        """
        return pulumi.get(self, "oidc_auth_type")

    @oidc_auth_type.setter
    def oidc_auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oidc_auth_type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique ID for the project to create the database user.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]]]:
        """
        List of user’s roles and the databases / collections on which the roles apply. A role allows the user to perform particular actions on the specified database. A role on the admin database can include privileges that apply to the other databases as well. See Roles below for more details.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserRoleArgs']]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserScopeArgs']]]]:
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseUserScopeArgs']]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username for authenticating to MongoDB. USER_ARN or ROLE_ARN if `aws_iam_type` is USER or ROLE.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="x509Type")
    def x509_type(self) -> Optional[pulumi.Input[str]]:
        """
        X.509 method by which the provided username is authenticated. If no value is given, Atlas uses the default value of NONE. The accepted types are:
        * `NONE` -	The user does not use X.509 authentication.
        * `MANAGED` - The user is being created for use with Atlas-managed X.509.Externally authenticated users can only be created on the `$external` database.
        * `CUSTOMER` -  The user is being created for use with Self-Managed X.509. Users created with this x509Type require a Common Name (CN) in the username field. Externally authenticated users can only be created on the `$external` database.
        """
        return pulumi.get(self, "x509_type")

    @x509_type.setter
    def x509_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "x509_type", value)


class DatabaseUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_database_name: Optional[pulumi.Input[str]] = None,
                 aws_iam_type: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserLabelArgs']]]]] = None,
                 ldap_auth_type: Optional[pulumi.Input[str]] = None,
                 oidc_auth_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserRoleArgs']]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserScopeArgs']]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 x509_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Resource: DatabaseUser

        `DatabaseUser` provides a Database User resource. This represents a database user which will be applied to all clusters within the project.

        Each user has a set of roles that provide access to the project’s databases. User's roles apply to all the clusters in the project: if two clusters have a `products` database and a user has a role granting `read` access on the products database, the user has that access on both clusters.

        > **NOTE:** Groups and projects are synonymous terms. You may find group_id in the official documentation.

        > **WARNING:** The password argument is required for creation but should be removed after creation if it will be managed externally. More details can be found in the password argument documentation.

        > **IMPORTANT:** All arguments including the password will be stored in the raw state as plain-text. Read more about sensitive data in state.

        ## Example Usage

        ### S

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.DatabaseUser("test",
            username="test-acc-username",
            password="test-acc-password",
            project_id="<PROJECT-ID>",
            auth_database_name="admin",
            roles=[
                mongodbatlas.DatabaseUserRoleArgs(
                    role_name="readWrite",
                    database_name="dbforApp",
                ),
                mongodbatlas.DatabaseUserRoleArgs(
                    role_name="readAnyDatabase",
                    database_name="admin",
                ),
            ],
            labels=[mongodbatlas.DatabaseUserLabelArgs(
                key="My Key",
                value="My Value",
            )],
            scopes=[
                mongodbatlas.DatabaseUserScopeArgs(
                    name="My cluster name",
                    type="CLUSTER",
                ),
                mongodbatlas.DatabaseUserScopeArgs(
                    name="My second cluster name",
                    type="CLUSTER",
                ),
            ])
        ```

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.DatabaseUser("test",
            username="test-acc-username",
            x509_type="MANAGED",
            project_id="<PROJECT-ID>",
            auth_database_name="$external",
            roles=[mongodbatlas.DatabaseUserRoleArgs(
                role_name="readAnyDatabase",
                database_name="admin",
            )],
            labels=[mongodbatlas.DatabaseUserLabelArgs(
                key="%s",
                value="%s",
            )],
            scopes=[mongodbatlas.DatabaseUserScopeArgs(
                name="My cluster name",
                type="CLUSTER",
            )])
        ```

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.DatabaseUser("test",
            username=test_aws_iam_role["arn"],
            project_id="<PROJECT-ID>",
            auth_database_name="$external",
            aws_iam_type="ROLE",
            roles=[mongodbatlas.DatabaseUserRoleArgs(
                role_name="readAnyDatabase",
                database_name="admin",
            )],
            labels=[mongodbatlas.DatabaseUserLabelArgs(
                key="%s",
                value="%s",
            )],
            scopes=[mongodbatlas.DatabaseUserScopeArgs(
                name="My cluster name",
                type="CLUSTER",
            )])
        ```

        ## Example of how to create a OIDC federated authentication user

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.DatabaseUser("test",
            username="64d613677e1ad50839cce4db/testUserOr",
            project_id="6414908c207f4d22f4d8f232",
            auth_database_name="admin",
            oidc_auth_type="IDP_GROUP",
            roles=[mongodbatlas.DatabaseUserRoleArgs(
                role_name="readWriteAnyDatabase",
                database_name="admin",
            )])
        ```
        `username` format: Atlas OIDC IdP ID (found in federation settings), followed by a '/', followed by the IdP group name

        Note: OIDC support is only avalible starting in [MongoDB 7.0](https://www.mongodb.com/evolved#mdbsevenzero) or later. To learn more, see the [MongoDB Atlas documentation](https://www.mongodb.com/docs/atlas/security-oidc/).

        ## Import

        Database users can be imported using project ID and username, in the format `project_id`-`username`-`auth_database_name`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/databaseUser:DatabaseUser my_user 1112222b3bf99403840e8934-my_user-admin
        ```
        ~> __NOTE:__ Terraform will want to change the password after importing the user if a `password` argument is specified.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_database_name: Database against which Atlas authenticates the user. A user must provide both a username and authentication database to log into MongoDB.
               Accepted values include:
        :param pulumi.Input[str] aws_iam_type: If this value is set, the new database user authenticates with AWS IAM credentials. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
               * `NONE` -	The user does not use AWS IAM credentials.
               * `USER` - New database user has AWS IAM user credentials.
               * `ROLE` -  New database user has credentials associated with an AWS IAM role.
        :param pulumi.Input[str] ldap_auth_type: Method by which the provided `username` is authenticated. If no value is given, Atlas uses the default value of `NONE`.
               * `NONE` -	Atlas authenticates this user through [SCRAM-SHA](https://docs.mongodb.com/manual/core/security-scram/), not LDAP.
               * `USER` - LDAP server authenticates this user through the user's LDAP user. `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
               * `GROUP` - LDAP server authenticates this user using their LDAP user and authorizes this user using their LDAP group. To learn more about LDAP security, see [Set up User Authentication and Authorization with LDAP](https://docs.atlas.mongodb.com/security-ldaps). `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
        :param pulumi.Input[str] oidc_auth_type: Human-readable label that indicates whether the new database user authenticates with OIDC (OpenID Connect) federated authentication. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
               * `NONE` -	The user does not use OIDC federated authentication.
               * `IDP_GROUP` - OIDC Workforce federated authentication group. To learn more about OIDC federated authentication, see [Set up Workforce Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
               * `USER` - OIDC Workload federated authentication user. To learn more about OIDC federated authentication, see [Set up Workload Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
        :param pulumi.Input[str] project_id: The unique ID for the project to create the database user.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserRoleArgs']]]] roles: List of user’s roles and the databases / collections on which the roles apply. A role allows the user to perform particular actions on the specified database. A role on the admin database can include privileges that apply to the other databases as well. See Roles below for more details.
        :param pulumi.Input[str] username: Username for authenticating to MongoDB. USER_ARN or ROLE_ARN if `aws_iam_type` is USER or ROLE.
        :param pulumi.Input[str] x509_type: X.509 method by which the provided username is authenticated. If no value is given, Atlas uses the default value of NONE. The accepted types are:
               * `NONE` -	The user does not use X.509 authentication.
               * `MANAGED` - The user is being created for use with Atlas-managed X.509.Externally authenticated users can only be created on the `$external` database.
               * `CUSTOMER` -  The user is being created for use with Self-Managed X.509. Users created with this x509Type require a Common Name (CN) in the username field. Externally authenticated users can only be created on the `$external` database.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: DatabaseUser

        `DatabaseUser` provides a Database User resource. This represents a database user which will be applied to all clusters within the project.

        Each user has a set of roles that provide access to the project’s databases. User's roles apply to all the clusters in the project: if two clusters have a `products` database and a user has a role granting `read` access on the products database, the user has that access on both clusters.

        > **NOTE:** Groups and projects are synonymous terms. You may find group_id in the official documentation.

        > **WARNING:** The password argument is required for creation but should be removed after creation if it will be managed externally. More details can be found in the password argument documentation.

        > **IMPORTANT:** All arguments including the password will be stored in the raw state as plain-text. Read more about sensitive data in state.

        ## Example Usage

        ### S

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.DatabaseUser("test",
            username="test-acc-username",
            password="test-acc-password",
            project_id="<PROJECT-ID>",
            auth_database_name="admin",
            roles=[
                mongodbatlas.DatabaseUserRoleArgs(
                    role_name="readWrite",
                    database_name="dbforApp",
                ),
                mongodbatlas.DatabaseUserRoleArgs(
                    role_name="readAnyDatabase",
                    database_name="admin",
                ),
            ],
            labels=[mongodbatlas.DatabaseUserLabelArgs(
                key="My Key",
                value="My Value",
            )],
            scopes=[
                mongodbatlas.DatabaseUserScopeArgs(
                    name="My cluster name",
                    type="CLUSTER",
                ),
                mongodbatlas.DatabaseUserScopeArgs(
                    name="My second cluster name",
                    type="CLUSTER",
                ),
            ])
        ```

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.DatabaseUser("test",
            username="test-acc-username",
            x509_type="MANAGED",
            project_id="<PROJECT-ID>",
            auth_database_name="$external",
            roles=[mongodbatlas.DatabaseUserRoleArgs(
                role_name="readAnyDatabase",
                database_name="admin",
            )],
            labels=[mongodbatlas.DatabaseUserLabelArgs(
                key="%s",
                value="%s",
            )],
            scopes=[mongodbatlas.DatabaseUserScopeArgs(
                name="My cluster name",
                type="CLUSTER",
            )])
        ```

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.DatabaseUser("test",
            username=test_aws_iam_role["arn"],
            project_id="<PROJECT-ID>",
            auth_database_name="$external",
            aws_iam_type="ROLE",
            roles=[mongodbatlas.DatabaseUserRoleArgs(
                role_name="readAnyDatabase",
                database_name="admin",
            )],
            labels=[mongodbatlas.DatabaseUserLabelArgs(
                key="%s",
                value="%s",
            )],
            scopes=[mongodbatlas.DatabaseUserScopeArgs(
                name="My cluster name",
                type="CLUSTER",
            )])
        ```

        ## Example of how to create a OIDC federated authentication user

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.DatabaseUser("test",
            username="64d613677e1ad50839cce4db/testUserOr",
            project_id="6414908c207f4d22f4d8f232",
            auth_database_name="admin",
            oidc_auth_type="IDP_GROUP",
            roles=[mongodbatlas.DatabaseUserRoleArgs(
                role_name="readWriteAnyDatabase",
                database_name="admin",
            )])
        ```
        `username` format: Atlas OIDC IdP ID (found in federation settings), followed by a '/', followed by the IdP group name

        Note: OIDC support is only avalible starting in [MongoDB 7.0](https://www.mongodb.com/evolved#mdbsevenzero) or later. To learn more, see the [MongoDB Atlas documentation](https://www.mongodb.com/docs/atlas/security-oidc/).

        ## Import

        Database users can be imported using project ID and username, in the format `project_id`-`username`-`auth_database_name`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/databaseUser:DatabaseUser my_user 1112222b3bf99403840e8934-my_user-admin
        ```
        ~> __NOTE:__ Terraform will want to change the password after importing the user if a `password` argument is specified.

        :param str resource_name: The name of the resource.
        :param DatabaseUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_database_name: Optional[pulumi.Input[str]] = None,
                 aws_iam_type: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserLabelArgs']]]]] = None,
                 ldap_auth_type: Optional[pulumi.Input[str]] = None,
                 oidc_auth_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserRoleArgs']]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserScopeArgs']]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 x509_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseUserArgs.__new__(DatabaseUserArgs)

            if auth_database_name is None and not opts.urn:
                raise TypeError("Missing required property 'auth_database_name'")
            __props__.__dict__["auth_database_name"] = auth_database_name
            __props__.__dict__["aws_iam_type"] = aws_iam_type
            __props__.__dict__["labels"] = labels
            __props__.__dict__["ldap_auth_type"] = ldap_auth_type
            __props__.__dict__["oidc_auth_type"] = oidc_auth_type
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["roles"] = roles
            __props__.__dict__["scopes"] = scopes
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["x509_type"] = x509_type
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DatabaseUser, __self__).__init__(
            'mongodbatlas:index/databaseUser:DatabaseUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_database_name: Optional[pulumi.Input[str]] = None,
            aws_iam_type: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserLabelArgs']]]]] = None,
            ldap_auth_type: Optional[pulumi.Input[str]] = None,
            oidc_auth_type: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserRoleArgs']]]]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserScopeArgs']]]]] = None,
            username: Optional[pulumi.Input[str]] = None,
            x509_type: Optional[pulumi.Input[str]] = None) -> 'DatabaseUser':
        """
        Get an existing DatabaseUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_database_name: Database against which Atlas authenticates the user. A user must provide both a username and authentication database to log into MongoDB.
               Accepted values include:
        :param pulumi.Input[str] aws_iam_type: If this value is set, the new database user authenticates with AWS IAM credentials. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
               * `NONE` -	The user does not use AWS IAM credentials.
               * `USER` - New database user has AWS IAM user credentials.
               * `ROLE` -  New database user has credentials associated with an AWS IAM role.
        :param pulumi.Input[str] ldap_auth_type: Method by which the provided `username` is authenticated. If no value is given, Atlas uses the default value of `NONE`.
               * `NONE` -	Atlas authenticates this user through [SCRAM-SHA](https://docs.mongodb.com/manual/core/security-scram/), not LDAP.
               * `USER` - LDAP server authenticates this user through the user's LDAP user. `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
               * `GROUP` - LDAP server authenticates this user using their LDAP user and authorizes this user using their LDAP group. To learn more about LDAP security, see [Set up User Authentication and Authorization with LDAP](https://docs.atlas.mongodb.com/security-ldaps). `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
        :param pulumi.Input[str] oidc_auth_type: Human-readable label that indicates whether the new database user authenticates with OIDC (OpenID Connect) federated authentication. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
               * `NONE` -	The user does not use OIDC federated authentication.
               * `IDP_GROUP` - OIDC Workforce federated authentication group. To learn more about OIDC federated authentication, see [Set up Workforce Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
               * `USER` - OIDC Workload federated authentication user. To learn more about OIDC federated authentication, see [Set up Workload Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
        :param pulumi.Input[str] project_id: The unique ID for the project to create the database user.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatabaseUserRoleArgs']]]] roles: List of user’s roles and the databases / collections on which the roles apply. A role allows the user to perform particular actions on the specified database. A role on the admin database can include privileges that apply to the other databases as well. See Roles below for more details.
        :param pulumi.Input[str] username: Username for authenticating to MongoDB. USER_ARN or ROLE_ARN if `aws_iam_type` is USER or ROLE.
        :param pulumi.Input[str] x509_type: X.509 method by which the provided username is authenticated. If no value is given, Atlas uses the default value of NONE. The accepted types are:
               * `NONE` -	The user does not use X.509 authentication.
               * `MANAGED` - The user is being created for use with Atlas-managed X.509.Externally authenticated users can only be created on the `$external` database.
               * `CUSTOMER` -  The user is being created for use with Self-Managed X.509. Users created with this x509Type require a Common Name (CN) in the username field. Externally authenticated users can only be created on the `$external` database.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseUserState.__new__(_DatabaseUserState)

        __props__.__dict__["auth_database_name"] = auth_database_name
        __props__.__dict__["aws_iam_type"] = aws_iam_type
        __props__.__dict__["labels"] = labels
        __props__.__dict__["ldap_auth_type"] = ldap_auth_type
        __props__.__dict__["oidc_auth_type"] = oidc_auth_type
        __props__.__dict__["password"] = password
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["roles"] = roles
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["username"] = username
        __props__.__dict__["x509_type"] = x509_type
        return DatabaseUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authDatabaseName")
    def auth_database_name(self) -> pulumi.Output[str]:
        """
        Database against which Atlas authenticates the user. A user must provide both a username and authentication database to log into MongoDB.
        Accepted values include:
        """
        return pulumi.get(self, "auth_database_name")

    @property
    @pulumi.getter(name="awsIamType")
    def aws_iam_type(self) -> pulumi.Output[str]:
        """
        If this value is set, the new database user authenticates with AWS IAM credentials. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
        * `NONE` -	The user does not use AWS IAM credentials.
        * `USER` - New database user has AWS IAM user credentials.
        * `ROLE` -  New database user has credentials associated with an AWS IAM role.
        """
        return pulumi.get(self, "aws_iam_type")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.DatabaseUserLabel']]]:
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="ldapAuthType")
    def ldap_auth_type(self) -> pulumi.Output[str]:
        """
        Method by which the provided `username` is authenticated. If no value is given, Atlas uses the default value of `NONE`.
        * `NONE` -	Atlas authenticates this user through [SCRAM-SHA](https://docs.mongodb.com/manual/core/security-scram/), not LDAP.
        * `USER` - LDAP server authenticates this user through the user's LDAP user. `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
        * `GROUP` - LDAP server authenticates this user using their LDAP user and authorizes this user using their LDAP group. To learn more about LDAP security, see [Set up User Authentication and Authorization with LDAP](https://docs.atlas.mongodb.com/security-ldaps). `username` must also be a fully qualified distinguished name, as defined in [RFC-2253](https://tools.ietf.org/html/rfc2253).
        """
        return pulumi.get(self, "ldap_auth_type")

    @property
    @pulumi.getter(name="oidcAuthType")
    def oidc_auth_type(self) -> pulumi.Output[str]:
        """
        Human-readable label that indicates whether the new database user authenticates with OIDC (OpenID Connect) federated authentication. If no value is given, Atlas uses the default value of `NONE`. The accepted types are:
        * `NONE` -	The user does not use OIDC federated authentication.
        * `IDP_GROUP` - OIDC Workforce federated authentication group. To learn more about OIDC federated authentication, see [Set up Workforce Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
        * `USER` - OIDC Workload federated authentication user. To learn more about OIDC federated authentication, see [Set up Workload Identity Federation with OIDC](https://www.mongodb.com/docs/atlas/security-oidc/).
        """
        return pulumi.get(self, "oidc_auth_type")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The unique ID for the project to create the database user.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Optional[Sequence['outputs.DatabaseUserRole']]]:
        """
        List of user’s roles and the databases / collections on which the roles apply. A role allows the user to perform particular actions on the specified database. A role on the admin database can include privileges that apply to the other databases as well. See Roles below for more details.
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Optional[Sequence['outputs.DatabaseUserScope']]]:
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        Username for authenticating to MongoDB. USER_ARN or ROLE_ARN if `aws_iam_type` is USER or ROLE.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="x509Type")
    def x509_type(self) -> pulumi.Output[str]:
        """
        X.509 method by which the provided username is authenticated. If no value is given, Atlas uses the default value of NONE. The accepted types are:
        * `NONE` -	The user does not use X.509 authentication.
        * `MANAGED` - The user is being created for use with Atlas-managed X.509.Externally authenticated users can only be created on the `$external` database.
        * `CUSTOMER` -  The user is being created for use with Self-Managed X.509. Users created with this x509Type require a Common Name (CN) in the username field. Externally authenticated users can only be created on the `$external` database.
        """
        return pulumi.get(self, "x509_type")

