# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FederatedDatabaseInstanceArgs', 'FederatedDatabaseInstance']

@pulumi.input_type
class FederatedDatabaseInstanceArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[str],
                 cloud_provider_config: Optional[pulumi.Input['FederatedDatabaseInstanceCloudProviderConfigArgs']] = None,
                 data_process_region: Optional[pulumi.Input['FederatedDatabaseInstanceDataProcessRegionArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 storage_databases: Optional[pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageDatabaseArgs']]]] = None,
                 storage_stores: Optional[pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageStoreArgs']]]] = None):
        """
        The set of arguments for constructing a FederatedDatabaseInstance resource.
        :param pulumi.Input[str] project_id: The unique ID for the project to create a Federated Database Instance.
        :param pulumi.Input['FederatedDatabaseInstanceCloudProviderConfigArgs'] cloud_provider_config: Cloud provider linked to this data federated instance.
               * `cloud_provider_config.aws` - (Required) AWS provider of the cloud service where the Federated Database Instance can access the S3 Bucket. Note this parameter is only required if using `cloud_provider_config` since AWS is currently the only supported Cloud vendor on this feature at this time.
               * `cloud_provider_config.aws.role_id` - (Required) Unique identifier of the role that the Federated Instance can use to access the data stores. If necessary, use the Atlas [UI](https://docs.atlas.mongodb.com/security/manage-iam-roles/) or [API](https://docs.atlas.mongodb.com/reference/api/cloud-provider-access-get-roles/) to retrieve the role ID. You must also specify the `test_s3_bucket`.
               * `cloud_provider_config.aws.test_s3_bucket` - (Required) Name of the S3 data bucket that the provided role ID is authorized to access. You must also specify the `role_id`.
        :param pulumi.Input['FederatedDatabaseInstanceDataProcessRegionArgs'] data_process_region: The cloud provider region to which the Federated Instance routes client connections for data processing.
               * `data_process_region.cloud_provider` - (Required) Name of the cloud service provider. Atlas Federated Database only supports AWS.
               * `data_process_region.region` - (Required) Name of the region to which the Federanted Instnace routes client connections for data processing. See the [documention](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Data-Federation/operation/createFederatedDatabase) for the available region.
        :param pulumi.Input[str] name: Name of the Atlas Federated Database Instance.
        :param pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageDatabaseArgs']]] storage_databases: Configuration details for mapping each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [databases](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-databases-reference). An empty object indicates that the Federated Database Instance has no mapping configuration for any data store.
               * `storage_databases.#.name` - Name of the database to which the Federated Database Instance maps the data contained in the data store.
               * `storage_databases.#.collections` -     Array of objects where each object represents a collection and data sources that map to a [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#mongodb-datalakeconf-datalakeconf.stores) data store.
               * `storage_databases.#.collections.#.name` - Name of the collection.
               * `storage_databases.#.collections.#.data_sources` -     Array of objects where each object represents a stores data store to map with the collection.
               * `storage_databases.#.collections.#.data_sources.#.store_name` -     Name of a data store to map to the `<collection>`. Must match the name of an object in the stores array.
               * `storage_databases.#.collections.#.data_sources.#.dataset_name` -     Human-readable label that identifies the dataset that Atlas generates for an ingestion pipeline run or Online Archive.
               * `storage_databases.#.collections.#.data_sources.#.default_format` - Default format that Federated Database assumes if it encounters a file without an extension while searching the storeName.
               * `storage_databases.#.collections.#.data_sources.#.path` - File path that controls how MongoDB Cloud searches for and parses files in the storeName before mapping them to a collection. Specify / to capture all files and folders from the prefix path.
               * `storage_databases.#.collections.#.data_sources.#.database` - Human-readable label that identifies the database, which contains the collection in the cluster.
               * `storage_databases.#.collections.#.data_sources.#.allow_insecure` - Flag that validates the scheme in the specified URLs. If true, allows insecure HTTP scheme, doesn't verify the server's certificate chain and hostname, and accepts any certificate with any hostname presented by the server. If false, allows secure HTTPS scheme only.
               * `storage_databases.#.collections.#.data_sources.#.database_regex` - Regex pattern to use for creating the wildcard database.
               * `storage_databases.#.collections.#.data_sources.#.collection` - Human-readable label that identifies the collection in the database.
               * `storage_databases.#.collections.#.data_sources.#.collection_regex` - Regex pattern to use for creating the wildcard (*) collection.
               * `storage_databases.#.collections.#.data_sources.#.provenance_field_name` - Name for the field that includes the provenance of the documents in the results.
               * `storage_databases.#.collections.#.data_sources.#.storeName` - Human-readable label that identifies the data store that MongoDB Cloud maps to the collection.
               * `storage_databases.#.collections.#.data_sources.#.urls` - URLs of the publicly accessible data files. You can't specify URLs that require authentication.
               * `storage_databases.#.views` -     Array of objects where each object represents an [aggregation pipeline](https://docs.mongodb.com/manual/core/aggregation-pipeline/#id1) on a collection. To learn more about views, see [Views](https://docs.mongodb.com/manual/core/views/).
               * `storage_databases.#.views.#.name` - Name of the view.
               * `storage_databases.#.views.#.source` -  Name of the source collection for the view.
               * `storage_databases.#.views.#.pipeline`- Aggregation pipeline stage(s) to apply to the source collection.
        :param pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageStoreArgs']]] storage_stores: Each object in the array represents a data store. Federated Database uses the storage.databases configuration details to map data in each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-stores-reference). An empty object indicates that the Federated Database Instance has no configured data stores.
               * `storage_stores.#.name` - Name of the data store.
               * `storage_stores.#.provider` - Defines where the data is stored.
               * `storage_stores.#.region` - Name of the AWS region in which the S3 bucket is hosted.
               * `storage_stores.#.bucket` - Name of the AWS S3 bucket.
               * `storage_stores.#.prefix` - Prefix the Federated Database Instance applies when searching for files in the S3 bucket.
               * `storage_stores.#.delimiter` - The delimiter that separates `storage_databases.#.collections.#.data_sources.#.path` segments in the data store.
               * `storage_stores.#.include_tags` - Determines whether or not to use S3 tags on the files in the given path as additional partition attributes.
               * `storage_stores.#.cluster_name` - Human-readable label of the MongoDB Cloud cluster on which the store is based.
               * `storage_stores.#.cluster_id` - ID of the Cluster the Online Archive belongs to.
               * `storage_stores.#.allow_insecure` - Flag that validates the scheme in the specified URLs.
               * `storage_stores.#.public` - Flag that indicates whether the bucket is public.
               * `storage_stores.#.default_format` - Default format that Data Lake assumes if it encounters a file without an extension while searching the storeName.
               * `storage_stores.#.urls` - Comma-separated list of publicly accessible HTTP URLs where data is stored.
               * `storage_stores.#.read_preference` - MongoDB Cloud cluster read preference, which describes how to route read requests to the cluster.
               * `storage_stores.#.read_preference.maxStalenessSeconds` - Maximum replication lag, or staleness, for reads from secondaries.
               * `storage_stores.#.read_preference.mode` - Read preference mode that specifies to which replica set member to route the read requests.
               * `storage_stores.#.read_preference.tag_sets` - List that contains tag sets or tag specification documents.
               * `storage_stores.#.read_preference.tags` - List of all tags within a tag set
               * `storage_stores.#.read_preference.tags.name` - Human-readable label of the tag.
               * `storage_stores.#.read_preference.tags.value` - Value of the tag.
        """
        pulumi.set(__self__, "project_id", project_id)
        if cloud_provider_config is not None:
            pulumi.set(__self__, "cloud_provider_config", cloud_provider_config)
        if data_process_region is not None:
            pulumi.set(__self__, "data_process_region", data_process_region)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_databases is not None:
            pulumi.set(__self__, "storage_databases", storage_databases)
        if storage_stores is not None:
            pulumi.set(__self__, "storage_stores", storage_stores)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The unique ID for the project to create a Federated Database Instance.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="cloudProviderConfig")
    def cloud_provider_config(self) -> Optional[pulumi.Input['FederatedDatabaseInstanceCloudProviderConfigArgs']]:
        """
        Cloud provider linked to this data federated instance.
        * `cloud_provider_config.aws` - (Required) AWS provider of the cloud service where the Federated Database Instance can access the S3 Bucket. Note this parameter is only required if using `cloud_provider_config` since AWS is currently the only supported Cloud vendor on this feature at this time.
        * `cloud_provider_config.aws.role_id` - (Required) Unique identifier of the role that the Federated Instance can use to access the data stores. If necessary, use the Atlas [UI](https://docs.atlas.mongodb.com/security/manage-iam-roles/) or [API](https://docs.atlas.mongodb.com/reference/api/cloud-provider-access-get-roles/) to retrieve the role ID. You must also specify the `test_s3_bucket`.
        * `cloud_provider_config.aws.test_s3_bucket` - (Required) Name of the S3 data bucket that the provided role ID is authorized to access. You must also specify the `role_id`.
        """
        return pulumi.get(self, "cloud_provider_config")

    @cloud_provider_config.setter
    def cloud_provider_config(self, value: Optional[pulumi.Input['FederatedDatabaseInstanceCloudProviderConfigArgs']]):
        pulumi.set(self, "cloud_provider_config", value)

    @property
    @pulumi.getter(name="dataProcessRegion")
    def data_process_region(self) -> Optional[pulumi.Input['FederatedDatabaseInstanceDataProcessRegionArgs']]:
        """
        The cloud provider region to which the Federated Instance routes client connections for data processing.
        * `data_process_region.cloud_provider` - (Required) Name of the cloud service provider. Atlas Federated Database only supports AWS.
        * `data_process_region.region` - (Required) Name of the region to which the Federanted Instnace routes client connections for data processing. See the [documention](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Data-Federation/operation/createFederatedDatabase) for the available region.
        """
        return pulumi.get(self, "data_process_region")

    @data_process_region.setter
    def data_process_region(self, value: Optional[pulumi.Input['FederatedDatabaseInstanceDataProcessRegionArgs']]):
        pulumi.set(self, "data_process_region", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Atlas Federated Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="storageDatabases")
    def storage_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageDatabaseArgs']]]]:
        """
        Configuration details for mapping each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [databases](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-databases-reference). An empty object indicates that the Federated Database Instance has no mapping configuration for any data store.
        * `storage_databases.#.name` - Name of the database to which the Federated Database Instance maps the data contained in the data store.
        * `storage_databases.#.collections` -     Array of objects where each object represents a collection and data sources that map to a [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#mongodb-datalakeconf-datalakeconf.stores) data store.
        * `storage_databases.#.collections.#.name` - Name of the collection.
        * `storage_databases.#.collections.#.data_sources` -     Array of objects where each object represents a stores data store to map with the collection.
        * `storage_databases.#.collections.#.data_sources.#.store_name` -     Name of a data store to map to the `<collection>`. Must match the name of an object in the stores array.
        * `storage_databases.#.collections.#.data_sources.#.dataset_name` -     Human-readable label that identifies the dataset that Atlas generates for an ingestion pipeline run or Online Archive.
        * `storage_databases.#.collections.#.data_sources.#.default_format` - Default format that Federated Database assumes if it encounters a file without an extension while searching the storeName.
        * `storage_databases.#.collections.#.data_sources.#.path` - File path that controls how MongoDB Cloud searches for and parses files in the storeName before mapping them to a collection. Specify / to capture all files and folders from the prefix path.
        * `storage_databases.#.collections.#.data_sources.#.database` - Human-readable label that identifies the database, which contains the collection in the cluster.
        * `storage_databases.#.collections.#.data_sources.#.allow_insecure` - Flag that validates the scheme in the specified URLs. If true, allows insecure HTTP scheme, doesn't verify the server's certificate chain and hostname, and accepts any certificate with any hostname presented by the server. If false, allows secure HTTPS scheme only.
        * `storage_databases.#.collections.#.data_sources.#.database_regex` - Regex pattern to use for creating the wildcard database.
        * `storage_databases.#.collections.#.data_sources.#.collection` - Human-readable label that identifies the collection in the database.
        * `storage_databases.#.collections.#.data_sources.#.collection_regex` - Regex pattern to use for creating the wildcard (*) collection.
        * `storage_databases.#.collections.#.data_sources.#.provenance_field_name` - Name for the field that includes the provenance of the documents in the results.
        * `storage_databases.#.collections.#.data_sources.#.storeName` - Human-readable label that identifies the data store that MongoDB Cloud maps to the collection.
        * `storage_databases.#.collections.#.data_sources.#.urls` - URLs of the publicly accessible data files. You can't specify URLs that require authentication.
        * `storage_databases.#.views` -     Array of objects where each object represents an [aggregation pipeline](https://docs.mongodb.com/manual/core/aggregation-pipeline/#id1) on a collection. To learn more about views, see [Views](https://docs.mongodb.com/manual/core/views/).
        * `storage_databases.#.views.#.name` - Name of the view.
        * `storage_databases.#.views.#.source` -  Name of the source collection for the view.
        * `storage_databases.#.views.#.pipeline`- Aggregation pipeline stage(s) to apply to the source collection.
        """
        return pulumi.get(self, "storage_databases")

    @storage_databases.setter
    def storage_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageDatabaseArgs']]]]):
        pulumi.set(self, "storage_databases", value)

    @property
    @pulumi.getter(name="storageStores")
    def storage_stores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageStoreArgs']]]]:
        """
        Each object in the array represents a data store. Federated Database uses the storage.databases configuration details to map data in each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-stores-reference). An empty object indicates that the Federated Database Instance has no configured data stores.
        * `storage_stores.#.name` - Name of the data store.
        * `storage_stores.#.provider` - Defines where the data is stored.
        * `storage_stores.#.region` - Name of the AWS region in which the S3 bucket is hosted.
        * `storage_stores.#.bucket` - Name of the AWS S3 bucket.
        * `storage_stores.#.prefix` - Prefix the Federated Database Instance applies when searching for files in the S3 bucket.
        * `storage_stores.#.delimiter` - The delimiter that separates `storage_databases.#.collections.#.data_sources.#.path` segments in the data store.
        * `storage_stores.#.include_tags` - Determines whether or not to use S3 tags on the files in the given path as additional partition attributes.
        * `storage_stores.#.cluster_name` - Human-readable label of the MongoDB Cloud cluster on which the store is based.
        * `storage_stores.#.cluster_id` - ID of the Cluster the Online Archive belongs to.
        * `storage_stores.#.allow_insecure` - Flag that validates the scheme in the specified URLs.
        * `storage_stores.#.public` - Flag that indicates whether the bucket is public.
        * `storage_stores.#.default_format` - Default format that Data Lake assumes if it encounters a file without an extension while searching the storeName.
        * `storage_stores.#.urls` - Comma-separated list of publicly accessible HTTP URLs where data is stored.
        * `storage_stores.#.read_preference` - MongoDB Cloud cluster read preference, which describes how to route read requests to the cluster.
        * `storage_stores.#.read_preference.maxStalenessSeconds` - Maximum replication lag, or staleness, for reads from secondaries.
        * `storage_stores.#.read_preference.mode` - Read preference mode that specifies to which replica set member to route the read requests.
        * `storage_stores.#.read_preference.tag_sets` - List that contains tag sets or tag specification documents.
        * `storage_stores.#.read_preference.tags` - List of all tags within a tag set
        * `storage_stores.#.read_preference.tags.name` - Human-readable label of the tag.
        * `storage_stores.#.read_preference.tags.value` - Value of the tag.
        """
        return pulumi.get(self, "storage_stores")

    @storage_stores.setter
    def storage_stores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageStoreArgs']]]]):
        pulumi.set(self, "storage_stores", value)


@pulumi.input_type
class _FederatedDatabaseInstanceState:
    def __init__(__self__, *,
                 cloud_provider_config: Optional[pulumi.Input['FederatedDatabaseInstanceCloudProviderConfigArgs']] = None,
                 data_process_region: Optional[pulumi.Input['FederatedDatabaseInstanceDataProcessRegionArgs']] = None,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage_databases: Optional[pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageDatabaseArgs']]]] = None,
                 storage_stores: Optional[pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageStoreArgs']]]] = None):
        """
        Input properties used for looking up and filtering FederatedDatabaseInstance resources.
        :param pulumi.Input['FederatedDatabaseInstanceCloudProviderConfigArgs'] cloud_provider_config: Cloud provider linked to this data federated instance.
               * `cloud_provider_config.aws` - (Required) AWS provider of the cloud service where the Federated Database Instance can access the S3 Bucket. Note this parameter is only required if using `cloud_provider_config` since AWS is currently the only supported Cloud vendor on this feature at this time.
               * `cloud_provider_config.aws.role_id` - (Required) Unique identifier of the role that the Federated Instance can use to access the data stores. If necessary, use the Atlas [UI](https://docs.atlas.mongodb.com/security/manage-iam-roles/) or [API](https://docs.atlas.mongodb.com/reference/api/cloud-provider-access-get-roles/) to retrieve the role ID. You must also specify the `test_s3_bucket`.
               * `cloud_provider_config.aws.test_s3_bucket` - (Required) Name of the S3 data bucket that the provided role ID is authorized to access. You must also specify the `role_id`.
        :param pulumi.Input['FederatedDatabaseInstanceDataProcessRegionArgs'] data_process_region: The cloud provider region to which the Federated Instance routes client connections for data processing.
               * `data_process_region.cloud_provider` - (Required) Name of the cloud service provider. Atlas Federated Database only supports AWS.
               * `data_process_region.region` - (Required) Name of the region to which the Federanted Instnace routes client connections for data processing. See the [documention](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Data-Federation/operation/createFederatedDatabase) for the available region.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: The list of hostnames assigned to the Federated Database Instance. Each string in the array is a hostname assigned to the Federated Database Instance.
        :param pulumi.Input[str] name: Name of the Atlas Federated Database Instance.
        :param pulumi.Input[str] project_id: The unique ID for the project to create a Federated Database Instance.
        :param pulumi.Input[str] state: Current state of the Federated Database Instance:
               * `ACTIVE` - The Federated Database Instance is active and verified. You can query the data stores associated with the Federated Database Instance.
               * `DELETED` - The Federated Database Instance was deleted.
        :param pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageDatabaseArgs']]] storage_databases: Configuration details for mapping each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [databases](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-databases-reference). An empty object indicates that the Federated Database Instance has no mapping configuration for any data store.
               * `storage_databases.#.name` - Name of the database to which the Federated Database Instance maps the data contained in the data store.
               * `storage_databases.#.collections` -     Array of objects where each object represents a collection and data sources that map to a [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#mongodb-datalakeconf-datalakeconf.stores) data store.
               * `storage_databases.#.collections.#.name` - Name of the collection.
               * `storage_databases.#.collections.#.data_sources` -     Array of objects where each object represents a stores data store to map with the collection.
               * `storage_databases.#.collections.#.data_sources.#.store_name` -     Name of a data store to map to the `<collection>`. Must match the name of an object in the stores array.
               * `storage_databases.#.collections.#.data_sources.#.dataset_name` -     Human-readable label that identifies the dataset that Atlas generates for an ingestion pipeline run or Online Archive.
               * `storage_databases.#.collections.#.data_sources.#.default_format` - Default format that Federated Database assumes if it encounters a file without an extension while searching the storeName.
               * `storage_databases.#.collections.#.data_sources.#.path` - File path that controls how MongoDB Cloud searches for and parses files in the storeName before mapping them to a collection. Specify / to capture all files and folders from the prefix path.
               * `storage_databases.#.collections.#.data_sources.#.database` - Human-readable label that identifies the database, which contains the collection in the cluster.
               * `storage_databases.#.collections.#.data_sources.#.allow_insecure` - Flag that validates the scheme in the specified URLs. If true, allows insecure HTTP scheme, doesn't verify the server's certificate chain and hostname, and accepts any certificate with any hostname presented by the server. If false, allows secure HTTPS scheme only.
               * `storage_databases.#.collections.#.data_sources.#.database_regex` - Regex pattern to use for creating the wildcard database.
               * `storage_databases.#.collections.#.data_sources.#.collection` - Human-readable label that identifies the collection in the database.
               * `storage_databases.#.collections.#.data_sources.#.collection_regex` - Regex pattern to use for creating the wildcard (*) collection.
               * `storage_databases.#.collections.#.data_sources.#.provenance_field_name` - Name for the field that includes the provenance of the documents in the results.
               * `storage_databases.#.collections.#.data_sources.#.storeName` - Human-readable label that identifies the data store that MongoDB Cloud maps to the collection.
               * `storage_databases.#.collections.#.data_sources.#.urls` - URLs of the publicly accessible data files. You can't specify URLs that require authentication.
               * `storage_databases.#.views` -     Array of objects where each object represents an [aggregation pipeline](https://docs.mongodb.com/manual/core/aggregation-pipeline/#id1) on a collection. To learn more about views, see [Views](https://docs.mongodb.com/manual/core/views/).
               * `storage_databases.#.views.#.name` - Name of the view.
               * `storage_databases.#.views.#.source` -  Name of the source collection for the view.
               * `storage_databases.#.views.#.pipeline`- Aggregation pipeline stage(s) to apply to the source collection.
        :param pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageStoreArgs']]] storage_stores: Each object in the array represents a data store. Federated Database uses the storage.databases configuration details to map data in each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-stores-reference). An empty object indicates that the Federated Database Instance has no configured data stores.
               * `storage_stores.#.name` - Name of the data store.
               * `storage_stores.#.provider` - Defines where the data is stored.
               * `storage_stores.#.region` - Name of the AWS region in which the S3 bucket is hosted.
               * `storage_stores.#.bucket` - Name of the AWS S3 bucket.
               * `storage_stores.#.prefix` - Prefix the Federated Database Instance applies when searching for files in the S3 bucket.
               * `storage_stores.#.delimiter` - The delimiter that separates `storage_databases.#.collections.#.data_sources.#.path` segments in the data store.
               * `storage_stores.#.include_tags` - Determines whether or not to use S3 tags on the files in the given path as additional partition attributes.
               * `storage_stores.#.cluster_name` - Human-readable label of the MongoDB Cloud cluster on which the store is based.
               * `storage_stores.#.cluster_id` - ID of the Cluster the Online Archive belongs to.
               * `storage_stores.#.allow_insecure` - Flag that validates the scheme in the specified URLs.
               * `storage_stores.#.public` - Flag that indicates whether the bucket is public.
               * `storage_stores.#.default_format` - Default format that Data Lake assumes if it encounters a file without an extension while searching the storeName.
               * `storage_stores.#.urls` - Comma-separated list of publicly accessible HTTP URLs where data is stored.
               * `storage_stores.#.read_preference` - MongoDB Cloud cluster read preference, which describes how to route read requests to the cluster.
               * `storage_stores.#.read_preference.maxStalenessSeconds` - Maximum replication lag, or staleness, for reads from secondaries.
               * `storage_stores.#.read_preference.mode` - Read preference mode that specifies to which replica set member to route the read requests.
               * `storage_stores.#.read_preference.tag_sets` - List that contains tag sets or tag specification documents.
               * `storage_stores.#.read_preference.tags` - List of all tags within a tag set
               * `storage_stores.#.read_preference.tags.name` - Human-readable label of the tag.
               * `storage_stores.#.read_preference.tags.value` - Value of the tag.
        """
        if cloud_provider_config is not None:
            pulumi.set(__self__, "cloud_provider_config", cloud_provider_config)
        if data_process_region is not None:
            pulumi.set(__self__, "data_process_region", data_process_region)
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_databases is not None:
            pulumi.set(__self__, "storage_databases", storage_databases)
        if storage_stores is not None:
            pulumi.set(__self__, "storage_stores", storage_stores)

    @property
    @pulumi.getter(name="cloudProviderConfig")
    def cloud_provider_config(self) -> Optional[pulumi.Input['FederatedDatabaseInstanceCloudProviderConfigArgs']]:
        """
        Cloud provider linked to this data federated instance.
        * `cloud_provider_config.aws` - (Required) AWS provider of the cloud service where the Federated Database Instance can access the S3 Bucket. Note this parameter is only required if using `cloud_provider_config` since AWS is currently the only supported Cloud vendor on this feature at this time.
        * `cloud_provider_config.aws.role_id` - (Required) Unique identifier of the role that the Federated Instance can use to access the data stores. If necessary, use the Atlas [UI](https://docs.atlas.mongodb.com/security/manage-iam-roles/) or [API](https://docs.atlas.mongodb.com/reference/api/cloud-provider-access-get-roles/) to retrieve the role ID. You must also specify the `test_s3_bucket`.
        * `cloud_provider_config.aws.test_s3_bucket` - (Required) Name of the S3 data bucket that the provided role ID is authorized to access. You must also specify the `role_id`.
        """
        return pulumi.get(self, "cloud_provider_config")

    @cloud_provider_config.setter
    def cloud_provider_config(self, value: Optional[pulumi.Input['FederatedDatabaseInstanceCloudProviderConfigArgs']]):
        pulumi.set(self, "cloud_provider_config", value)

    @property
    @pulumi.getter(name="dataProcessRegion")
    def data_process_region(self) -> Optional[pulumi.Input['FederatedDatabaseInstanceDataProcessRegionArgs']]:
        """
        The cloud provider region to which the Federated Instance routes client connections for data processing.
        * `data_process_region.cloud_provider` - (Required) Name of the cloud service provider. Atlas Federated Database only supports AWS.
        * `data_process_region.region` - (Required) Name of the region to which the Federanted Instnace routes client connections for data processing. See the [documention](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Data-Federation/operation/createFederatedDatabase) for the available region.
        """
        return pulumi.get(self, "data_process_region")

    @data_process_region.setter
    def data_process_region(self, value: Optional[pulumi.Input['FederatedDatabaseInstanceDataProcessRegionArgs']]):
        pulumi.set(self, "data_process_region", value)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of hostnames assigned to the Federated Database Instance. Each string in the array is a hostname assigned to the Federated Database Instance.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Atlas Federated Database Instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique ID for the project to create a Federated Database Instance.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Current state of the Federated Database Instance:
        * `ACTIVE` - The Federated Database Instance is active and verified. You can query the data stores associated with the Federated Database Instance.
        * `DELETED` - The Federated Database Instance was deleted.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageDatabases")
    def storage_databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageDatabaseArgs']]]]:
        """
        Configuration details for mapping each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [databases](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-databases-reference). An empty object indicates that the Federated Database Instance has no mapping configuration for any data store.
        * `storage_databases.#.name` - Name of the database to which the Federated Database Instance maps the data contained in the data store.
        * `storage_databases.#.collections` -     Array of objects where each object represents a collection and data sources that map to a [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#mongodb-datalakeconf-datalakeconf.stores) data store.
        * `storage_databases.#.collections.#.name` - Name of the collection.
        * `storage_databases.#.collections.#.data_sources` -     Array of objects where each object represents a stores data store to map with the collection.
        * `storage_databases.#.collections.#.data_sources.#.store_name` -     Name of a data store to map to the `<collection>`. Must match the name of an object in the stores array.
        * `storage_databases.#.collections.#.data_sources.#.dataset_name` -     Human-readable label that identifies the dataset that Atlas generates for an ingestion pipeline run or Online Archive.
        * `storage_databases.#.collections.#.data_sources.#.default_format` - Default format that Federated Database assumes if it encounters a file without an extension while searching the storeName.
        * `storage_databases.#.collections.#.data_sources.#.path` - File path that controls how MongoDB Cloud searches for and parses files in the storeName before mapping them to a collection. Specify / to capture all files and folders from the prefix path.
        * `storage_databases.#.collections.#.data_sources.#.database` - Human-readable label that identifies the database, which contains the collection in the cluster.
        * `storage_databases.#.collections.#.data_sources.#.allow_insecure` - Flag that validates the scheme in the specified URLs. If true, allows insecure HTTP scheme, doesn't verify the server's certificate chain and hostname, and accepts any certificate with any hostname presented by the server. If false, allows secure HTTPS scheme only.
        * `storage_databases.#.collections.#.data_sources.#.database_regex` - Regex pattern to use for creating the wildcard database.
        * `storage_databases.#.collections.#.data_sources.#.collection` - Human-readable label that identifies the collection in the database.
        * `storage_databases.#.collections.#.data_sources.#.collection_regex` - Regex pattern to use for creating the wildcard (*) collection.
        * `storage_databases.#.collections.#.data_sources.#.provenance_field_name` - Name for the field that includes the provenance of the documents in the results.
        * `storage_databases.#.collections.#.data_sources.#.storeName` - Human-readable label that identifies the data store that MongoDB Cloud maps to the collection.
        * `storage_databases.#.collections.#.data_sources.#.urls` - URLs of the publicly accessible data files. You can't specify URLs that require authentication.
        * `storage_databases.#.views` -     Array of objects where each object represents an [aggregation pipeline](https://docs.mongodb.com/manual/core/aggregation-pipeline/#id1) on a collection. To learn more about views, see [Views](https://docs.mongodb.com/manual/core/views/).
        * `storage_databases.#.views.#.name` - Name of the view.
        * `storage_databases.#.views.#.source` -  Name of the source collection for the view.
        * `storage_databases.#.views.#.pipeline`- Aggregation pipeline stage(s) to apply to the source collection.
        """
        return pulumi.get(self, "storage_databases")

    @storage_databases.setter
    def storage_databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageDatabaseArgs']]]]):
        pulumi.set(self, "storage_databases", value)

    @property
    @pulumi.getter(name="storageStores")
    def storage_stores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageStoreArgs']]]]:
        """
        Each object in the array represents a data store. Federated Database uses the storage.databases configuration details to map data in each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-stores-reference). An empty object indicates that the Federated Database Instance has no configured data stores.
        * `storage_stores.#.name` - Name of the data store.
        * `storage_stores.#.provider` - Defines where the data is stored.
        * `storage_stores.#.region` - Name of the AWS region in which the S3 bucket is hosted.
        * `storage_stores.#.bucket` - Name of the AWS S3 bucket.
        * `storage_stores.#.prefix` - Prefix the Federated Database Instance applies when searching for files in the S3 bucket.
        * `storage_stores.#.delimiter` - The delimiter that separates `storage_databases.#.collections.#.data_sources.#.path` segments in the data store.
        * `storage_stores.#.include_tags` - Determines whether or not to use S3 tags on the files in the given path as additional partition attributes.
        * `storage_stores.#.cluster_name` - Human-readable label of the MongoDB Cloud cluster on which the store is based.
        * `storage_stores.#.cluster_id` - ID of the Cluster the Online Archive belongs to.
        * `storage_stores.#.allow_insecure` - Flag that validates the scheme in the specified URLs.
        * `storage_stores.#.public` - Flag that indicates whether the bucket is public.
        * `storage_stores.#.default_format` - Default format that Data Lake assumes if it encounters a file without an extension while searching the storeName.
        * `storage_stores.#.urls` - Comma-separated list of publicly accessible HTTP URLs where data is stored.
        * `storage_stores.#.read_preference` - MongoDB Cloud cluster read preference, which describes how to route read requests to the cluster.
        * `storage_stores.#.read_preference.maxStalenessSeconds` - Maximum replication lag, or staleness, for reads from secondaries.
        * `storage_stores.#.read_preference.mode` - Read preference mode that specifies to which replica set member to route the read requests.
        * `storage_stores.#.read_preference.tag_sets` - List that contains tag sets or tag specification documents.
        * `storage_stores.#.read_preference.tags` - List of all tags within a tag set
        * `storage_stores.#.read_preference.tags.name` - Human-readable label of the tag.
        * `storage_stores.#.read_preference.tags.value` - Value of the tag.
        """
        return pulumi.get(self, "storage_stores")

    @storage_stores.setter
    def storage_stores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FederatedDatabaseInstanceStorageStoreArgs']]]]):
        pulumi.set(self, "storage_stores", value)


class FederatedDatabaseInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_provider_config: Optional[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceCloudProviderConfigArgs']]] = None,
                 data_process_region: Optional[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceDataProcessRegionArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 storage_databases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceStorageDatabaseArgs']]]]] = None,
                 storage_stores: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceStorageStoreArgs']]]]] = None,
                 __props__=None):
        """
        ## # Resource: FederatedDatabaseInstance

        `FederatedDatabaseInstance` provides a Federated Database Instance resource.

        > **NOTE:** Groups and projects are synonymous terms. You may find group_id in the official documentation.

        ## Example Usage

        ### S With MongoDB Atlas Cluster As Storage Database

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.FederatedDatabaseInstance("test",
            project_id="PROJECT ID",
            name="TENANT NAME OF THE FEDERATED DATABASE INSTANCE",
            storage_databases=[mongodbatlas.FederatedDatabaseInstanceStorageDatabaseArgs(
                name="VirtualDatabase0",
                collections=[mongodbatlas.FederatedDatabaseInstanceStorageDatabaseCollectionArgs(
                    name="NAME OF THE COLLECTION",
                    data_sources=[mongodbatlas.FederatedDatabaseInstanceStorageDatabaseCollectionDataSourceArgs(
                        collection="COLLECTION IN THE CLUSTER",
                        database="DB IN THE CLUSTER",
                        store_name="CLUSTER NAME",
                    )],
                )],
            )],
            storage_stores=[mongodbatlas.FederatedDatabaseInstanceStorageStoreArgs(
                name="STORE 1 NAME",
                cluster_name="CLUSTER NAME",
                project_id="PROJECT ID",
                provider="atlas",
                read_preference=mongodbatlas.FederatedDatabaseInstanceStorageStoreReadPreferenceArgs(
                    mode="secondary",
                ),
            )])
        ```

        ### S With Amazon S3 Bucket As Storage Database

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.FederatedDatabaseInstance("test",
            project_id="PROJECT ID",
            name="TENANT NAME OF THE FEDERATED DATABASE INSTANCE",
            cloud_provider_config=mongodbatlas.FederatedDatabaseInstanceCloudProviderConfigArgs(
                aws=mongodbatlas.FederatedDatabaseInstanceCloudProviderConfigAwsArgs(
                    role_id="AWS ROLE ID",
                    test_s3_bucket="S3 BUCKET NAME",
                ),
            ),
            storage_databases=[mongodbatlas.FederatedDatabaseInstanceStorageDatabaseArgs(
                name="VirtualDatabase0",
                collections=[mongodbatlas.FederatedDatabaseInstanceStorageDatabaseCollectionArgs(
                    name="NAME OF THE COLLECTION",
                    data_sources=[
                        mongodbatlas.FederatedDatabaseInstanceStorageDatabaseCollectionDataSourceArgs(
                            collection="COLLECTION IN THE CLUSTER",
                            database="DB IN THE CLUSTER",
                            store_name="CLUSTER NAME",
                        ),
                        mongodbatlas.FederatedDatabaseInstanceStorageDatabaseCollectionDataSourceArgs(
                            store_name="S3 BUCKET NAME",
                            path="S3 BUCKET PATH",
                        ),
                    ],
                )],
            )],
            storage_stores=[
                mongodbatlas.FederatedDatabaseInstanceStorageStoreArgs(
                    name="STORE 1 NAME",
                    cluster_name="CLUSTER NAME",
                    project_id="PROJECT ID",
                    provider="atlas",
                    read_preference=mongodbatlas.FederatedDatabaseInstanceStorageStoreReadPreferenceArgs(
                        mode="secondary",
                    ),
                ),
                mongodbatlas.FederatedDatabaseInstanceStorageStoreArgs(
                    bucket="STORE 2 NAME",
                    delimiter="/",
                    name="S3 BUCKET NAME",
                    prefix="S3 BUCKET PREFIX",
                    provider="s3",
                    region="AWS REGION",
                ),
            ])
        ```

        ## Example specifying data process region and provider

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.FederatedDatabaseInstance("test",
            project_id="PROJECT ID",
            name="NAME OF THE FEDERATED DATABASE INSTANCE",
            data_process_region=mongodbatlas.FederatedDatabaseInstanceDataProcessRegionArgs(
                cloud_provider="AWS",
                region="OREGON_USA",
            ))
        ```

        ## Import

        - The Federated Database Instance can be imported using project ID, name of the instance, in the format `project_id`--`name`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/federatedDatabaseInstance:FederatedDatabaseInstance mongodbatlas_federated_database_instance.example 1112222b3bf99403840e8934--test
        ```

        - The Federated Database Instance can be imported using project ID, name of the instance and name of the AWS S3 bucket, in the format `project_id`--`name`--`aws_test_s3_bucket`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/federatedDatabaseInstance:FederatedDatabaseInstance mongodbatlas_federated_database_instance.example 1112222b3bf99403840e8934--test--s3-test
        ```

        See [MongoDB Atlas API](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Data-Federation) Documentation for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceCloudProviderConfigArgs']] cloud_provider_config: Cloud provider linked to this data federated instance.
               * `cloud_provider_config.aws` - (Required) AWS provider of the cloud service where the Federated Database Instance can access the S3 Bucket. Note this parameter is only required if using `cloud_provider_config` since AWS is currently the only supported Cloud vendor on this feature at this time.
               * `cloud_provider_config.aws.role_id` - (Required) Unique identifier of the role that the Federated Instance can use to access the data stores. If necessary, use the Atlas [UI](https://docs.atlas.mongodb.com/security/manage-iam-roles/) or [API](https://docs.atlas.mongodb.com/reference/api/cloud-provider-access-get-roles/) to retrieve the role ID. You must also specify the `test_s3_bucket`.
               * `cloud_provider_config.aws.test_s3_bucket` - (Required) Name of the S3 data bucket that the provided role ID is authorized to access. You must also specify the `role_id`.
        :param pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceDataProcessRegionArgs']] data_process_region: The cloud provider region to which the Federated Instance routes client connections for data processing.
               * `data_process_region.cloud_provider` - (Required) Name of the cloud service provider. Atlas Federated Database only supports AWS.
               * `data_process_region.region` - (Required) Name of the region to which the Federanted Instnace routes client connections for data processing. See the [documention](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Data-Federation/operation/createFederatedDatabase) for the available region.
        :param pulumi.Input[str] name: Name of the Atlas Federated Database Instance.
        :param pulumi.Input[str] project_id: The unique ID for the project to create a Federated Database Instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceStorageDatabaseArgs']]]] storage_databases: Configuration details for mapping each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [databases](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-databases-reference). An empty object indicates that the Federated Database Instance has no mapping configuration for any data store.
               * `storage_databases.#.name` - Name of the database to which the Federated Database Instance maps the data contained in the data store.
               * `storage_databases.#.collections` -     Array of objects where each object represents a collection and data sources that map to a [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#mongodb-datalakeconf-datalakeconf.stores) data store.
               * `storage_databases.#.collections.#.name` - Name of the collection.
               * `storage_databases.#.collections.#.data_sources` -     Array of objects where each object represents a stores data store to map with the collection.
               * `storage_databases.#.collections.#.data_sources.#.store_name` -     Name of a data store to map to the `<collection>`. Must match the name of an object in the stores array.
               * `storage_databases.#.collections.#.data_sources.#.dataset_name` -     Human-readable label that identifies the dataset that Atlas generates for an ingestion pipeline run or Online Archive.
               * `storage_databases.#.collections.#.data_sources.#.default_format` - Default format that Federated Database assumes if it encounters a file without an extension while searching the storeName.
               * `storage_databases.#.collections.#.data_sources.#.path` - File path that controls how MongoDB Cloud searches for and parses files in the storeName before mapping them to a collection. Specify / to capture all files and folders from the prefix path.
               * `storage_databases.#.collections.#.data_sources.#.database` - Human-readable label that identifies the database, which contains the collection in the cluster.
               * `storage_databases.#.collections.#.data_sources.#.allow_insecure` - Flag that validates the scheme in the specified URLs. If true, allows insecure HTTP scheme, doesn't verify the server's certificate chain and hostname, and accepts any certificate with any hostname presented by the server. If false, allows secure HTTPS scheme only.
               * `storage_databases.#.collections.#.data_sources.#.database_regex` - Regex pattern to use for creating the wildcard database.
               * `storage_databases.#.collections.#.data_sources.#.collection` - Human-readable label that identifies the collection in the database.
               * `storage_databases.#.collections.#.data_sources.#.collection_regex` - Regex pattern to use for creating the wildcard (*) collection.
               * `storage_databases.#.collections.#.data_sources.#.provenance_field_name` - Name for the field that includes the provenance of the documents in the results.
               * `storage_databases.#.collections.#.data_sources.#.storeName` - Human-readable label that identifies the data store that MongoDB Cloud maps to the collection.
               * `storage_databases.#.collections.#.data_sources.#.urls` - URLs of the publicly accessible data files. You can't specify URLs that require authentication.
               * `storage_databases.#.views` -     Array of objects where each object represents an [aggregation pipeline](https://docs.mongodb.com/manual/core/aggregation-pipeline/#id1) on a collection. To learn more about views, see [Views](https://docs.mongodb.com/manual/core/views/).
               * `storage_databases.#.views.#.name` - Name of the view.
               * `storage_databases.#.views.#.source` -  Name of the source collection for the view.
               * `storage_databases.#.views.#.pipeline`- Aggregation pipeline stage(s) to apply to the source collection.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceStorageStoreArgs']]]] storage_stores: Each object in the array represents a data store. Federated Database uses the storage.databases configuration details to map data in each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-stores-reference). An empty object indicates that the Federated Database Instance has no configured data stores.
               * `storage_stores.#.name` - Name of the data store.
               * `storage_stores.#.provider` - Defines where the data is stored.
               * `storage_stores.#.region` - Name of the AWS region in which the S3 bucket is hosted.
               * `storage_stores.#.bucket` - Name of the AWS S3 bucket.
               * `storage_stores.#.prefix` - Prefix the Federated Database Instance applies when searching for files in the S3 bucket.
               * `storage_stores.#.delimiter` - The delimiter that separates `storage_databases.#.collections.#.data_sources.#.path` segments in the data store.
               * `storage_stores.#.include_tags` - Determines whether or not to use S3 tags on the files in the given path as additional partition attributes.
               * `storage_stores.#.cluster_name` - Human-readable label of the MongoDB Cloud cluster on which the store is based.
               * `storage_stores.#.cluster_id` - ID of the Cluster the Online Archive belongs to.
               * `storage_stores.#.allow_insecure` - Flag that validates the scheme in the specified URLs.
               * `storage_stores.#.public` - Flag that indicates whether the bucket is public.
               * `storage_stores.#.default_format` - Default format that Data Lake assumes if it encounters a file without an extension while searching the storeName.
               * `storage_stores.#.urls` - Comma-separated list of publicly accessible HTTP URLs where data is stored.
               * `storage_stores.#.read_preference` - MongoDB Cloud cluster read preference, which describes how to route read requests to the cluster.
               * `storage_stores.#.read_preference.maxStalenessSeconds` - Maximum replication lag, or staleness, for reads from secondaries.
               * `storage_stores.#.read_preference.mode` - Read preference mode that specifies to which replica set member to route the read requests.
               * `storage_stores.#.read_preference.tag_sets` - List that contains tag sets or tag specification documents.
               * `storage_stores.#.read_preference.tags` - List of all tags within a tag set
               * `storage_stores.#.read_preference.tags.name` - Human-readable label of the tag.
               * `storage_stores.#.read_preference.tags.value` - Value of the tag.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FederatedDatabaseInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: FederatedDatabaseInstance

        `FederatedDatabaseInstance` provides a Federated Database Instance resource.

        > **NOTE:** Groups and projects are synonymous terms. You may find group_id in the official documentation.

        ## Example Usage

        ### S With MongoDB Atlas Cluster As Storage Database

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.FederatedDatabaseInstance("test",
            project_id="PROJECT ID",
            name="TENANT NAME OF THE FEDERATED DATABASE INSTANCE",
            storage_databases=[mongodbatlas.FederatedDatabaseInstanceStorageDatabaseArgs(
                name="VirtualDatabase0",
                collections=[mongodbatlas.FederatedDatabaseInstanceStorageDatabaseCollectionArgs(
                    name="NAME OF THE COLLECTION",
                    data_sources=[mongodbatlas.FederatedDatabaseInstanceStorageDatabaseCollectionDataSourceArgs(
                        collection="COLLECTION IN THE CLUSTER",
                        database="DB IN THE CLUSTER",
                        store_name="CLUSTER NAME",
                    )],
                )],
            )],
            storage_stores=[mongodbatlas.FederatedDatabaseInstanceStorageStoreArgs(
                name="STORE 1 NAME",
                cluster_name="CLUSTER NAME",
                project_id="PROJECT ID",
                provider="atlas",
                read_preference=mongodbatlas.FederatedDatabaseInstanceStorageStoreReadPreferenceArgs(
                    mode="secondary",
                ),
            )])
        ```

        ### S With Amazon S3 Bucket As Storage Database

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.FederatedDatabaseInstance("test",
            project_id="PROJECT ID",
            name="TENANT NAME OF THE FEDERATED DATABASE INSTANCE",
            cloud_provider_config=mongodbatlas.FederatedDatabaseInstanceCloudProviderConfigArgs(
                aws=mongodbatlas.FederatedDatabaseInstanceCloudProviderConfigAwsArgs(
                    role_id="AWS ROLE ID",
                    test_s3_bucket="S3 BUCKET NAME",
                ),
            ),
            storage_databases=[mongodbatlas.FederatedDatabaseInstanceStorageDatabaseArgs(
                name="VirtualDatabase0",
                collections=[mongodbatlas.FederatedDatabaseInstanceStorageDatabaseCollectionArgs(
                    name="NAME OF THE COLLECTION",
                    data_sources=[
                        mongodbatlas.FederatedDatabaseInstanceStorageDatabaseCollectionDataSourceArgs(
                            collection="COLLECTION IN THE CLUSTER",
                            database="DB IN THE CLUSTER",
                            store_name="CLUSTER NAME",
                        ),
                        mongodbatlas.FederatedDatabaseInstanceStorageDatabaseCollectionDataSourceArgs(
                            store_name="S3 BUCKET NAME",
                            path="S3 BUCKET PATH",
                        ),
                    ],
                )],
            )],
            storage_stores=[
                mongodbatlas.FederatedDatabaseInstanceStorageStoreArgs(
                    name="STORE 1 NAME",
                    cluster_name="CLUSTER NAME",
                    project_id="PROJECT ID",
                    provider="atlas",
                    read_preference=mongodbatlas.FederatedDatabaseInstanceStorageStoreReadPreferenceArgs(
                        mode="secondary",
                    ),
                ),
                mongodbatlas.FederatedDatabaseInstanceStorageStoreArgs(
                    bucket="STORE 2 NAME",
                    delimiter="/",
                    name="S3 BUCKET NAME",
                    prefix="S3 BUCKET PREFIX",
                    provider="s3",
                    region="AWS REGION",
                ),
            ])
        ```

        ## Example specifying data process region and provider

        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test = mongodbatlas.FederatedDatabaseInstance("test",
            project_id="PROJECT ID",
            name="NAME OF THE FEDERATED DATABASE INSTANCE",
            data_process_region=mongodbatlas.FederatedDatabaseInstanceDataProcessRegionArgs(
                cloud_provider="AWS",
                region="OREGON_USA",
            ))
        ```

        ## Import

        - The Federated Database Instance can be imported using project ID, name of the instance, in the format `project_id`--`name`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/federatedDatabaseInstance:FederatedDatabaseInstance mongodbatlas_federated_database_instance.example 1112222b3bf99403840e8934--test
        ```

        - The Federated Database Instance can be imported using project ID, name of the instance and name of the AWS S3 bucket, in the format `project_id`--`name`--`aws_test_s3_bucket`, e.g.

        ```sh
        $ pulumi import mongodbatlas:index/federatedDatabaseInstance:FederatedDatabaseInstance mongodbatlas_federated_database_instance.example 1112222b3bf99403840e8934--test--s3-test
        ```

        See [MongoDB Atlas API](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Data-Federation) Documentation for more information.

        :param str resource_name: The name of the resource.
        :param FederatedDatabaseInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FederatedDatabaseInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_provider_config: Optional[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceCloudProviderConfigArgs']]] = None,
                 data_process_region: Optional[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceDataProcessRegionArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 storage_databases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceStorageDatabaseArgs']]]]] = None,
                 storage_stores: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceStorageStoreArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FederatedDatabaseInstanceArgs.__new__(FederatedDatabaseInstanceArgs)

            __props__.__dict__["cloud_provider_config"] = cloud_provider_config
            __props__.__dict__["data_process_region"] = data_process_region
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["storage_databases"] = storage_databases
            __props__.__dict__["storage_stores"] = storage_stores
            __props__.__dict__["hostnames"] = None
            __props__.__dict__["state"] = None
        super(FederatedDatabaseInstance, __self__).__init__(
            'mongodbatlas:index/federatedDatabaseInstance:FederatedDatabaseInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_provider_config: Optional[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceCloudProviderConfigArgs']]] = None,
            data_process_region: Optional[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceDataProcessRegionArgs']]] = None,
            hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage_databases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceStorageDatabaseArgs']]]]] = None,
            storage_stores: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceStorageStoreArgs']]]]] = None) -> 'FederatedDatabaseInstance':
        """
        Get an existing FederatedDatabaseInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceCloudProviderConfigArgs']] cloud_provider_config: Cloud provider linked to this data federated instance.
               * `cloud_provider_config.aws` - (Required) AWS provider of the cloud service where the Federated Database Instance can access the S3 Bucket. Note this parameter is only required if using `cloud_provider_config` since AWS is currently the only supported Cloud vendor on this feature at this time.
               * `cloud_provider_config.aws.role_id` - (Required) Unique identifier of the role that the Federated Instance can use to access the data stores. If necessary, use the Atlas [UI](https://docs.atlas.mongodb.com/security/manage-iam-roles/) or [API](https://docs.atlas.mongodb.com/reference/api/cloud-provider-access-get-roles/) to retrieve the role ID. You must also specify the `test_s3_bucket`.
               * `cloud_provider_config.aws.test_s3_bucket` - (Required) Name of the S3 data bucket that the provided role ID is authorized to access. You must also specify the `role_id`.
        :param pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceDataProcessRegionArgs']] data_process_region: The cloud provider region to which the Federated Instance routes client connections for data processing.
               * `data_process_region.cloud_provider` - (Required) Name of the cloud service provider. Atlas Federated Database only supports AWS.
               * `data_process_region.region` - (Required) Name of the region to which the Federanted Instnace routes client connections for data processing. See the [documention](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Data-Federation/operation/createFederatedDatabase) for the available region.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: The list of hostnames assigned to the Federated Database Instance. Each string in the array is a hostname assigned to the Federated Database Instance.
        :param pulumi.Input[str] name: Name of the Atlas Federated Database Instance.
        :param pulumi.Input[str] project_id: The unique ID for the project to create a Federated Database Instance.
        :param pulumi.Input[str] state: Current state of the Federated Database Instance:
               * `ACTIVE` - The Federated Database Instance is active and verified. You can query the data stores associated with the Federated Database Instance.
               * `DELETED` - The Federated Database Instance was deleted.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceStorageDatabaseArgs']]]] storage_databases: Configuration details for mapping each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [databases](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-databases-reference). An empty object indicates that the Federated Database Instance has no mapping configuration for any data store.
               * `storage_databases.#.name` - Name of the database to which the Federated Database Instance maps the data contained in the data store.
               * `storage_databases.#.collections` -     Array of objects where each object represents a collection and data sources that map to a [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#mongodb-datalakeconf-datalakeconf.stores) data store.
               * `storage_databases.#.collections.#.name` - Name of the collection.
               * `storage_databases.#.collections.#.data_sources` -     Array of objects where each object represents a stores data store to map with the collection.
               * `storage_databases.#.collections.#.data_sources.#.store_name` -     Name of a data store to map to the `<collection>`. Must match the name of an object in the stores array.
               * `storage_databases.#.collections.#.data_sources.#.dataset_name` -     Human-readable label that identifies the dataset that Atlas generates for an ingestion pipeline run or Online Archive.
               * `storage_databases.#.collections.#.data_sources.#.default_format` - Default format that Federated Database assumes if it encounters a file without an extension while searching the storeName.
               * `storage_databases.#.collections.#.data_sources.#.path` - File path that controls how MongoDB Cloud searches for and parses files in the storeName before mapping them to a collection. Specify / to capture all files and folders from the prefix path.
               * `storage_databases.#.collections.#.data_sources.#.database` - Human-readable label that identifies the database, which contains the collection in the cluster.
               * `storage_databases.#.collections.#.data_sources.#.allow_insecure` - Flag that validates the scheme in the specified URLs. If true, allows insecure HTTP scheme, doesn't verify the server's certificate chain and hostname, and accepts any certificate with any hostname presented by the server. If false, allows secure HTTPS scheme only.
               * `storage_databases.#.collections.#.data_sources.#.database_regex` - Regex pattern to use for creating the wildcard database.
               * `storage_databases.#.collections.#.data_sources.#.collection` - Human-readable label that identifies the collection in the database.
               * `storage_databases.#.collections.#.data_sources.#.collection_regex` - Regex pattern to use for creating the wildcard (*) collection.
               * `storage_databases.#.collections.#.data_sources.#.provenance_field_name` - Name for the field that includes the provenance of the documents in the results.
               * `storage_databases.#.collections.#.data_sources.#.storeName` - Human-readable label that identifies the data store that MongoDB Cloud maps to the collection.
               * `storage_databases.#.collections.#.data_sources.#.urls` - URLs of the publicly accessible data files. You can't specify URLs that require authentication.
               * `storage_databases.#.views` -     Array of objects where each object represents an [aggregation pipeline](https://docs.mongodb.com/manual/core/aggregation-pipeline/#id1) on a collection. To learn more about views, see [Views](https://docs.mongodb.com/manual/core/views/).
               * `storage_databases.#.views.#.name` - Name of the view.
               * `storage_databases.#.views.#.source` -  Name of the source collection for the view.
               * `storage_databases.#.views.#.pipeline`- Aggregation pipeline stage(s) to apply to the source collection.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FederatedDatabaseInstanceStorageStoreArgs']]]] storage_stores: Each object in the array represents a data store. Federated Database uses the storage.databases configuration details to map data in each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-stores-reference). An empty object indicates that the Federated Database Instance has no configured data stores.
               * `storage_stores.#.name` - Name of the data store.
               * `storage_stores.#.provider` - Defines where the data is stored.
               * `storage_stores.#.region` - Name of the AWS region in which the S3 bucket is hosted.
               * `storage_stores.#.bucket` - Name of the AWS S3 bucket.
               * `storage_stores.#.prefix` - Prefix the Federated Database Instance applies when searching for files in the S3 bucket.
               * `storage_stores.#.delimiter` - The delimiter that separates `storage_databases.#.collections.#.data_sources.#.path` segments in the data store.
               * `storage_stores.#.include_tags` - Determines whether or not to use S3 tags on the files in the given path as additional partition attributes.
               * `storage_stores.#.cluster_name` - Human-readable label of the MongoDB Cloud cluster on which the store is based.
               * `storage_stores.#.cluster_id` - ID of the Cluster the Online Archive belongs to.
               * `storage_stores.#.allow_insecure` - Flag that validates the scheme in the specified URLs.
               * `storage_stores.#.public` - Flag that indicates whether the bucket is public.
               * `storage_stores.#.default_format` - Default format that Data Lake assumes if it encounters a file without an extension while searching the storeName.
               * `storage_stores.#.urls` - Comma-separated list of publicly accessible HTTP URLs where data is stored.
               * `storage_stores.#.read_preference` - MongoDB Cloud cluster read preference, which describes how to route read requests to the cluster.
               * `storage_stores.#.read_preference.maxStalenessSeconds` - Maximum replication lag, or staleness, for reads from secondaries.
               * `storage_stores.#.read_preference.mode` - Read preference mode that specifies to which replica set member to route the read requests.
               * `storage_stores.#.read_preference.tag_sets` - List that contains tag sets or tag specification documents.
               * `storage_stores.#.read_preference.tags` - List of all tags within a tag set
               * `storage_stores.#.read_preference.tags.name` - Human-readable label of the tag.
               * `storage_stores.#.read_preference.tags.value` - Value of the tag.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FederatedDatabaseInstanceState.__new__(_FederatedDatabaseInstanceState)

        __props__.__dict__["cloud_provider_config"] = cloud_provider_config
        __props__.__dict__["data_process_region"] = data_process_region
        __props__.__dict__["hostnames"] = hostnames
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_databases"] = storage_databases
        __props__.__dict__["storage_stores"] = storage_stores
        return FederatedDatabaseInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudProviderConfig")
    def cloud_provider_config(self) -> pulumi.Output['outputs.FederatedDatabaseInstanceCloudProviderConfig']:
        """
        Cloud provider linked to this data federated instance.
        * `cloud_provider_config.aws` - (Required) AWS provider of the cloud service where the Federated Database Instance can access the S3 Bucket. Note this parameter is only required if using `cloud_provider_config` since AWS is currently the only supported Cloud vendor on this feature at this time.
        * `cloud_provider_config.aws.role_id` - (Required) Unique identifier of the role that the Federated Instance can use to access the data stores. If necessary, use the Atlas [UI](https://docs.atlas.mongodb.com/security/manage-iam-roles/) or [API](https://docs.atlas.mongodb.com/reference/api/cloud-provider-access-get-roles/) to retrieve the role ID. You must also specify the `test_s3_bucket`.
        * `cloud_provider_config.aws.test_s3_bucket` - (Required) Name of the S3 data bucket that the provided role ID is authorized to access. You must also specify the `role_id`.
        """
        return pulumi.get(self, "cloud_provider_config")

    @property
    @pulumi.getter(name="dataProcessRegion")
    def data_process_region(self) -> pulumi.Output['outputs.FederatedDatabaseInstanceDataProcessRegion']:
        """
        The cloud provider region to which the Federated Instance routes client connections for data processing.
        * `data_process_region.cloud_provider` - (Required) Name of the cloud service provider. Atlas Federated Database only supports AWS.
        * `data_process_region.region` - (Required) Name of the region to which the Federanted Instnace routes client connections for data processing. See the [documention](https://www.mongodb.com/docs/atlas/reference/api-resources-spec/#tag/Data-Federation/operation/createFederatedDatabase) for the available region.
        """
        return pulumi.get(self, "data_process_region")

    @property
    @pulumi.getter
    def hostnames(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of hostnames assigned to the Federated Database Instance. Each string in the array is a hostname assigned to the Federated Database Instance.
        """
        return pulumi.get(self, "hostnames")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Atlas Federated Database Instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The unique ID for the project to create a Federated Database Instance.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Current state of the Federated Database Instance:
        * `ACTIVE` - The Federated Database Instance is active and verified. You can query the data stores associated with the Federated Database Instance.
        * `DELETED` - The Federated Database Instance was deleted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageDatabases")
    def storage_databases(self) -> pulumi.Output[Sequence['outputs.FederatedDatabaseInstanceStorageDatabase']]:
        """
        Configuration details for mapping each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [databases](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-databases-reference). An empty object indicates that the Federated Database Instance has no mapping configuration for any data store.
        * `storage_databases.#.name` - Name of the database to which the Federated Database Instance maps the data contained in the data store.
        * `storage_databases.#.collections` -     Array of objects where each object represents a collection and data sources that map to a [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#mongodb-datalakeconf-datalakeconf.stores) data store.
        * `storage_databases.#.collections.#.name` - Name of the collection.
        * `storage_databases.#.collections.#.data_sources` -     Array of objects where each object represents a stores data store to map with the collection.
        * `storage_databases.#.collections.#.data_sources.#.store_name` -     Name of a data store to map to the `<collection>`. Must match the name of an object in the stores array.
        * `storage_databases.#.collections.#.data_sources.#.dataset_name` -     Human-readable label that identifies the dataset that Atlas generates for an ingestion pipeline run or Online Archive.
        * `storage_databases.#.collections.#.data_sources.#.default_format` - Default format that Federated Database assumes if it encounters a file without an extension while searching the storeName.
        * `storage_databases.#.collections.#.data_sources.#.path` - File path that controls how MongoDB Cloud searches for and parses files in the storeName before mapping them to a collection. Specify / to capture all files and folders from the prefix path.
        * `storage_databases.#.collections.#.data_sources.#.database` - Human-readable label that identifies the database, which contains the collection in the cluster.
        * `storage_databases.#.collections.#.data_sources.#.allow_insecure` - Flag that validates the scheme in the specified URLs. If true, allows insecure HTTP scheme, doesn't verify the server's certificate chain and hostname, and accepts any certificate with any hostname presented by the server. If false, allows secure HTTPS scheme only.
        * `storage_databases.#.collections.#.data_sources.#.database_regex` - Regex pattern to use for creating the wildcard database.
        * `storage_databases.#.collections.#.data_sources.#.collection` - Human-readable label that identifies the collection in the database.
        * `storage_databases.#.collections.#.data_sources.#.collection_regex` - Regex pattern to use for creating the wildcard (*) collection.
        * `storage_databases.#.collections.#.data_sources.#.provenance_field_name` - Name for the field that includes the provenance of the documents in the results.
        * `storage_databases.#.collections.#.data_sources.#.storeName` - Human-readable label that identifies the data store that MongoDB Cloud maps to the collection.
        * `storage_databases.#.collections.#.data_sources.#.urls` - URLs of the publicly accessible data files. You can't specify URLs that require authentication.
        * `storage_databases.#.views` -     Array of objects where each object represents an [aggregation pipeline](https://docs.mongodb.com/manual/core/aggregation-pipeline/#id1) on a collection. To learn more about views, see [Views](https://docs.mongodb.com/manual/core/views/).
        * `storage_databases.#.views.#.name` - Name of the view.
        * `storage_databases.#.views.#.source` -  Name of the source collection for the view.
        * `storage_databases.#.views.#.pipeline`- Aggregation pipeline stage(s) to apply to the source collection.
        """
        return pulumi.get(self, "storage_databases")

    @property
    @pulumi.getter(name="storageStores")
    def storage_stores(self) -> pulumi.Output[Sequence['outputs.FederatedDatabaseInstanceStorageStore']]:
        """
        Each object in the array represents a data store. Federated Database uses the storage.databases configuration details to map data in each data store to queryable databases and collections. For complete documentation on this object and its nested fields, see [stores](https://docs.mongodb.com/datalake/reference/format/data-lake-configuration#std-label-datalake-stores-reference). An empty object indicates that the Federated Database Instance has no configured data stores.
        * `storage_stores.#.name` - Name of the data store.
        * `storage_stores.#.provider` - Defines where the data is stored.
        * `storage_stores.#.region` - Name of the AWS region in which the S3 bucket is hosted.
        * `storage_stores.#.bucket` - Name of the AWS S3 bucket.
        * `storage_stores.#.prefix` - Prefix the Federated Database Instance applies when searching for files in the S3 bucket.
        * `storage_stores.#.delimiter` - The delimiter that separates `storage_databases.#.collections.#.data_sources.#.path` segments in the data store.
        * `storage_stores.#.include_tags` - Determines whether or not to use S3 tags on the files in the given path as additional partition attributes.
        * `storage_stores.#.cluster_name` - Human-readable label of the MongoDB Cloud cluster on which the store is based.
        * `storage_stores.#.cluster_id` - ID of the Cluster the Online Archive belongs to.
        * `storage_stores.#.allow_insecure` - Flag that validates the scheme in the specified URLs.
        * `storage_stores.#.public` - Flag that indicates whether the bucket is public.
        * `storage_stores.#.default_format` - Default format that Data Lake assumes if it encounters a file without an extension while searching the storeName.
        * `storage_stores.#.urls` - Comma-separated list of publicly accessible HTTP URLs where data is stored.
        * `storage_stores.#.read_preference` - MongoDB Cloud cluster read preference, which describes how to route read requests to the cluster.
        * `storage_stores.#.read_preference.maxStalenessSeconds` - Maximum replication lag, or staleness, for reads from secondaries.
        * `storage_stores.#.read_preference.mode` - Read preference mode that specifies to which replica set member to route the read requests.
        * `storage_stores.#.read_preference.tag_sets` - List that contains tag sets or tag specification documents.
        * `storage_stores.#.read_preference.tags` - List of all tags within a tag set
        * `storage_stores.#.read_preference.tags.name` - Human-readable label of the tag.
        * `storage_stores.#.read_preference.tags.value` - Value of the tag.
        """
        return pulumi.get(self, "storage_stores")

