# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetCustomDnsConfigurationClusterAwsResult',
    'AwaitableGetCustomDnsConfigurationClusterAwsResult',
    'get_custom_dns_configuration_cluster_aws',
    'get_custom_dns_configuration_cluster_aws_output',
]

@pulumi.output_type
class GetCustomDnsConfigurationClusterAwsResult:
    """
    A collection of values returned by getCustomDnsConfigurationClusterAws.
    """
    def __init__(__self__, enabled=None, id=None, project_id=None):
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether the project's clusters deployed to AWS use custom DNS.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        return pulumi.get(self, "project_id")


class AwaitableGetCustomDnsConfigurationClusterAwsResult(GetCustomDnsConfigurationClusterAwsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomDnsConfigurationClusterAwsResult(
            enabled=self.enabled,
            id=self.id,
            project_id=self.project_id)


def get_custom_dns_configuration_cluster_aws(project_id: Optional[str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomDnsConfigurationClusterAwsResult:
    """
    ## # Data Source: CustomDnsConfigurationClusterAws

    `CustomDnsConfigurationClusterAws` describes a Custom DNS Configuration for Atlas Clusters on AWS.

    > **NOTE:** Groups and projects are synonymous terms. You may find **group_id** in the official documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test_custom_dns_configuration_cluster_aws = mongodbatlas.CustomDnsConfigurationClusterAws("test",
        project_id="<project-id>",
        enabled=True)
    test = mongodbatlas.get_custom_dns_configuration_cluster_aws_output(project_id=test_custom_dns_configuration_cluster_aws.id)
    ```


    :param str project_id: Unique identifier for the project.
    """
    __args__ = dict()
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('mongodbatlas:index/getCustomDnsConfigurationClusterAws:getCustomDnsConfigurationClusterAws', __args__, opts=opts, typ=GetCustomDnsConfigurationClusterAwsResult).value

    return AwaitableGetCustomDnsConfigurationClusterAwsResult(
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'))


@_utilities.lift_output_func(get_custom_dns_configuration_cluster_aws)
def get_custom_dns_configuration_cluster_aws_output(project_id: Optional[pulumi.Input[str]] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCustomDnsConfigurationClusterAwsResult]:
    """
    ## # Data Source: CustomDnsConfigurationClusterAws

    `CustomDnsConfigurationClusterAws` describes a Custom DNS Configuration for Atlas Clusters on AWS.

    > **NOTE:** Groups and projects are synonymous terms. You may find **group_id** in the official documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_mongodbatlas as mongodbatlas

    test_custom_dns_configuration_cluster_aws = mongodbatlas.CustomDnsConfigurationClusterAws("test",
        project_id="<project-id>",
        enabled=True)
    test = mongodbatlas.get_custom_dns_configuration_cluster_aws_output(project_id=test_custom_dns_configuration_cluster_aws.id)
    ```


    :param str project_id: Unique identifier for the project.
    """
    ...
