# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SearchDeploymentArgs', 'SearchDeployment']

@pulumi.input_type
class SearchDeploymentArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 specs: pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]],
                 timeouts: Optional[pulumi.Input['SearchDeploymentTimeoutsArgs']] = None):
        """
        The set of arguments for constructing a SearchDeployment resource.
        :param pulumi.Input[str] cluster_name: Label that identifies the cluster to return the search nodes for.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal character string that identifies the project.
        :param pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]] specs: List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "specs", specs)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        Label that identifies the cluster to return the search nodes for.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        Unique 24-hexadecimal character string that identifies the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def specs(self) -> pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]]:
        """
        List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        """
        return pulumi.get(self, "specs")

    @specs.setter
    def specs(self, value: pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]]):
        pulumi.set(self, "specs", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['SearchDeploymentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['SearchDeploymentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


@pulumi.input_type
class _SearchDeploymentState:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]]] = None,
                 state_name: Optional[pulumi.Input[str]] = None,
                 timeouts: Optional[pulumi.Input['SearchDeploymentTimeoutsArgs']] = None):
        """
        Input properties used for looking up and filtering SearchDeployment resources.
        :param pulumi.Input[str] cluster_name: Label that identifies the cluster to return the search nodes for.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal character string that identifies the project.
        :param pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]] specs: List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        :param pulumi.Input[str] state_name: Human-readable label that indicates the current operating condition of this search deployment.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if specs is not None:
            pulumi.set(__self__, "specs", specs)
        if state_name is not None:
            pulumi.set(__self__, "state_name", state_name)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        Label that identifies the cluster to return the search nodes for.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique 24-hexadecimal character string that identifies the project.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]]]:
        """
        List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        """
        return pulumi.get(self, "specs")

    @specs.setter
    def specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SearchDeploymentSpecArgs']]]]):
        pulumi.set(self, "specs", value)

    @property
    @pulumi.getter(name="stateName")
    def state_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable label that indicates the current operating condition of this search deployment.
        """
        return pulumi.get(self, "state_name")

    @state_name.setter
    def state_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_name", value)

    @property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['SearchDeploymentTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['SearchDeploymentTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)


class SearchDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchDeploymentSpecArgs']]]]] = None,
                 timeouts: Optional[pulumi.Input[pulumi.InputType['SearchDeploymentTimeoutsArgs']]] = None,
                 __props__=None):
        """
        ## # Resource: SearchDeployment

        `SearchDeployment` provides a Search Deployment resource. The resource lets you create, edit and delete dedicated search nodes in a cluster.

        > **NOTE:** For details on supported cloud providers and existing limitations you can visit the [Search Node Documentation](https://www.mongodb.com/docs/atlas/cluster-config/multi-cloud-distribution/#search-nodes-for-workload-isolation).

        > **NOTE:** Only a single search deployment resource can be defined for each cluster.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_name: Label that identifies the cluster to return the search nodes for.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal character string that identifies the project.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchDeploymentSpecArgs']]]] specs: List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SearchDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: SearchDeployment

        `SearchDeployment` provides a Search Deployment resource. The resource lets you create, edit and delete dedicated search nodes in a cluster.

        > **NOTE:** For details on supported cloud providers and existing limitations you can visit the [Search Node Documentation](https://www.mongodb.com/docs/atlas/cluster-config/multi-cloud-distribution/#search-nodes-for-workload-isolation).

        > **NOTE:** Only a single search deployment resource can be defined for each cluster.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param SearchDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SearchDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 specs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchDeploymentSpecArgs']]]]] = None,
                 timeouts: Optional[pulumi.Input[pulumi.InputType['SearchDeploymentTimeoutsArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SearchDeploymentArgs.__new__(SearchDeploymentArgs)

            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if specs is None and not opts.urn:
                raise TypeError("Missing required property 'specs'")
            __props__.__dict__["specs"] = specs
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["state_name"] = None
        super(SearchDeployment, __self__).__init__(
            'mongodbatlas:index/searchDeployment:SearchDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            specs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchDeploymentSpecArgs']]]]] = None,
            state_name: Optional[pulumi.Input[str]] = None,
            timeouts: Optional[pulumi.Input[pulumi.InputType['SearchDeploymentTimeoutsArgs']]] = None) -> 'SearchDeployment':
        """
        Get an existing SearchDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_name: Label that identifies the cluster to return the search nodes for.
        :param pulumi.Input[str] project_id: Unique 24-hexadecimal character string that identifies the project.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchDeploymentSpecArgs']]]] specs: List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        :param pulumi.Input[str] state_name: Human-readable label that indicates the current operating condition of this search deployment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SearchDeploymentState.__new__(_SearchDeploymentState)

        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["specs"] = specs
        __props__.__dict__["state_name"] = state_name
        __props__.__dict__["timeouts"] = timeouts
        return SearchDeployment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        Label that identifies the cluster to return the search nodes for.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Unique 24-hexadecimal character string that identifies the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def specs(self) -> pulumi.Output[Sequence['outputs.SearchDeploymentSpec']]:
        """
        List of settings that configure the search nodes for your cluster. This list is currently limited to defining a single element.
        """
        return pulumi.get(self, "specs")

    @property
    @pulumi.getter(name="stateName")
    def state_name(self) -> pulumi.Output[str]:
        """
        Human-readable label that indicates the current operating condition of this search deployment.
        """
        return pulumi.get(self, "state_name")

    @property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.SearchDeploymentTimeouts']]:
        return pulumi.get(self, "timeouts")

