# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SearchIndexArgs', 'SearchIndex']

@pulumi.input_type
class SearchIndexArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[str],
                 collection_name: pulumi.Input[str],
                 database: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 analyzer: Optional[pulumi.Input[str]] = None,
                 analyzers: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[str]] = None,
                 mappings_dynamic: Optional[pulumi.Input[bool]] = None,
                 mappings_fields: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 search_analyzer: Optional[pulumi.Input[str]] = None,
                 stored_source: Optional[pulumi.Input[str]] = None,
                 synonyms: Optional[pulumi.Input[Sequence[pulumi.Input['SearchIndexSynonymArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 wait_for_index_build_completion: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a SearchIndex resource.
        :param pulumi.Input[str] cluster_name: The name of the cluster where you want to create the search index within.
        :param pulumi.Input[str] collection_name: Name of the collection the index is on.
        :param pulumi.Input[str] database: Name of the database the collection is in.
        :param pulumi.Input[str] project_id: The ID of the organization or project you want to create the search index within.
        :param pulumi.Input[str] analyzer: [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when creating the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        :param pulumi.Input[str] analyzers: [Custom analyzers](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/custom/#std-label-custom-analyzers) to use in this index. This is an array of JSON objects.
               ```
               analyzers = <<-EOF
               [{
               "name": "index_analyzer_test_name",
               "charFilters": [{
               "type": "mapping",
               "mappings": {"\\\\" : "/"}
               }],
               "tokenizer": {
               "type": "nGram",
               "minGram": 2,
               "maxGram": 5
               },
               "tokenFilters": [{
               "type": "length",
               "min": 20,
               "max": 33
               }]
               }]
               EOF
               ```
        :param pulumi.Input[str] fields: Array of [Fields](https://www.mongodb.com/docs/atlas/atlas-search/field-types/knn-vector/#std-label-fts-data-types-knn-vector) to configure this `vectorSearch` index. It is mandatory for vector searches and it must contain at least one `vector` type field. This field needs to be a JSON string in order to be decoded correctly.
        :param pulumi.Input[bool] mappings_dynamic: Indicates whether the search index uses dynamic or static mapping. For dynamic mapping, set the value to `true`. For static mapping, specify the fields to index using `mappings_fields`
        :param pulumi.Input[str] mappings_fields: attribute is required in search indexes when `mappings_dynamic` is false. This field needs to be a JSON string in order to be decoded correctly.
        :param pulumi.Input[str] name: The name of the search index you want to create.
        :param pulumi.Input[str] search_analyzer: [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when searching the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        :param pulumi.Input[str] stored_source: String that can be "true" (store all fields), "false" (default, don't store any field), or a JSON string that contains the list of fields to store (include) or not store (exclude) on Atlas Search. To learn more, see [Stored Source Fields](https://www.mongodb.com/docs/atlas/atlas-search/stored-source-definition/).
        :param pulumi.Input[Sequence[pulumi.Input['SearchIndexSynonymArgs']]] synonyms: Synonyms mapping definition to use in this index.
        :param pulumi.Input[str] type: Type of index: `search` or `vectorSearch`. Default type is `search`.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "collection_name", collection_name)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "project_id", project_id)
        if analyzer is not None:
            pulumi.set(__self__, "analyzer", analyzer)
        if analyzers is not None:
            pulumi.set(__self__, "analyzers", analyzers)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if mappings_dynamic is not None:
            pulumi.set(__self__, "mappings_dynamic", mappings_dynamic)
        if mappings_fields is not None:
            pulumi.set(__self__, "mappings_fields", mappings_fields)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if search_analyzer is not None:
            pulumi.set(__self__, "search_analyzer", search_analyzer)
        if stored_source is not None:
            pulumi.set(__self__, "stored_source", stored_source)
        if synonyms is not None:
            pulumi.set(__self__, "synonyms", synonyms)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if wait_for_index_build_completion is not None:
            pulumi.set(__self__, "wait_for_index_build_completion", wait_for_index_build_completion)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        The name of the cluster where you want to create the search index within.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> pulumi.Input[str]:
        """
        Name of the collection the index is on.
        """
        return pulumi.get(self, "collection_name")

    @collection_name.setter
    def collection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "collection_name", value)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        Name of the database the collection is in.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of the organization or project you want to create the search index within.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def analyzer(self) -> Optional[pulumi.Input[str]]:
        """
        [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when creating the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        """
        return pulumi.get(self, "analyzer")

    @analyzer.setter
    def analyzer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analyzer", value)

    @property
    @pulumi.getter
    def analyzers(self) -> Optional[pulumi.Input[str]]:
        """
        [Custom analyzers](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/custom/#std-label-custom-analyzers) to use in this index. This is an array of JSON objects.
        ```
        analyzers = <<-EOF
        [{
        "name": "index_analyzer_test_name",
        "charFilters": [{
        "type": "mapping",
        "mappings": {"\\\\" : "/"}
        }],
        "tokenizer": {
        "type": "nGram",
        "minGram": 2,
        "maxGram": 5
        },
        "tokenFilters": [{
        "type": "length",
        "min": 20,
        "max": 33
        }]
        }]
        EOF
        ```
        """
        return pulumi.get(self, "analyzers")

    @analyzers.setter
    def analyzers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analyzers", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[str]]:
        """
        Array of [Fields](https://www.mongodb.com/docs/atlas/atlas-search/field-types/knn-vector/#std-label-fts-data-types-knn-vector) to configure this `vectorSearch` index. It is mandatory for vector searches and it must contain at least one `vector` type field. This field needs to be a JSON string in order to be decoded correctly.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="mappingsDynamic")
    def mappings_dynamic(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the search index uses dynamic or static mapping. For dynamic mapping, set the value to `true`. For static mapping, specify the fields to index using `mappings_fields`
        """
        return pulumi.get(self, "mappings_dynamic")

    @mappings_dynamic.setter
    def mappings_dynamic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mappings_dynamic", value)

    @property
    @pulumi.getter(name="mappingsFields")
    def mappings_fields(self) -> Optional[pulumi.Input[str]]:
        """
        attribute is required in search indexes when `mappings_dynamic` is false. This field needs to be a JSON string in order to be decoded correctly.
        """
        return pulumi.get(self, "mappings_fields")

    @mappings_fields.setter
    def mappings_fields(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mappings_fields", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the search index you want to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="searchAnalyzer")
    def search_analyzer(self) -> Optional[pulumi.Input[str]]:
        """
        [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when searching the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        """
        return pulumi.get(self, "search_analyzer")

    @search_analyzer.setter
    def search_analyzer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_analyzer", value)

    @property
    @pulumi.getter(name="storedSource")
    def stored_source(self) -> Optional[pulumi.Input[str]]:
        """
        String that can be "true" (store all fields), "false" (default, don't store any field), or a JSON string that contains the list of fields to store (include) or not store (exclude) on Atlas Search. To learn more, see [Stored Source Fields](https://www.mongodb.com/docs/atlas/atlas-search/stored-source-definition/).
        """
        return pulumi.get(self, "stored_source")

    @stored_source.setter
    def stored_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stored_source", value)

    @property
    @pulumi.getter
    def synonyms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SearchIndexSynonymArgs']]]]:
        """
        Synonyms mapping definition to use in this index.
        """
        return pulumi.get(self, "synonyms")

    @synonyms.setter
    def synonyms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SearchIndexSynonymArgs']]]]):
        pulumi.set(self, "synonyms", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of index: `search` or `vectorSearch`. Default type is `search`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="waitForIndexBuildCompletion")
    def wait_for_index_build_completion(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "wait_for_index_build_completion")

    @wait_for_index_build_completion.setter
    def wait_for_index_build_completion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_index_build_completion", value)


@pulumi.input_type
class _SearchIndexState:
    def __init__(__self__, *,
                 analyzer: Optional[pulumi.Input[str]] = None,
                 analyzers: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 collection_name: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[str]] = None,
                 index_id: Optional[pulumi.Input[str]] = None,
                 mappings_dynamic: Optional[pulumi.Input[bool]] = None,
                 mappings_fields: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 search_analyzer: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stored_source: Optional[pulumi.Input[str]] = None,
                 synonyms: Optional[pulumi.Input[Sequence[pulumi.Input['SearchIndexSynonymArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 wait_for_index_build_completion: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering SearchIndex resources.
        :param pulumi.Input[str] analyzer: [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when creating the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        :param pulumi.Input[str] analyzers: [Custom analyzers](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/custom/#std-label-custom-analyzers) to use in this index. This is an array of JSON objects.
               ```
               analyzers = <<-EOF
               [{
               "name": "index_analyzer_test_name",
               "charFilters": [{
               "type": "mapping",
               "mappings": {"\\\\" : "/"}
               }],
               "tokenizer": {
               "type": "nGram",
               "minGram": 2,
               "maxGram": 5
               },
               "tokenFilters": [{
               "type": "length",
               "min": 20,
               "max": 33
               }]
               }]
               EOF
               ```
        :param pulumi.Input[str] cluster_name: The name of the cluster where you want to create the search index within.
        :param pulumi.Input[str] collection_name: Name of the collection the index is on.
        :param pulumi.Input[str] database: Name of the database the collection is in.
        :param pulumi.Input[str] fields: Array of [Fields](https://www.mongodb.com/docs/atlas/atlas-search/field-types/knn-vector/#std-label-fts-data-types-knn-vector) to configure this `vectorSearch` index. It is mandatory for vector searches and it must contain at least one `vector` type field. This field needs to be a JSON string in order to be decoded correctly.
        :param pulumi.Input[str] index_id: The unique identifier of the Atlas Search index.
        :param pulumi.Input[bool] mappings_dynamic: Indicates whether the search index uses dynamic or static mapping. For dynamic mapping, set the value to `true`. For static mapping, specify the fields to index using `mappings_fields`
        :param pulumi.Input[str] mappings_fields: attribute is required in search indexes when `mappings_dynamic` is false. This field needs to be a JSON string in order to be decoded correctly.
        :param pulumi.Input[str] name: The name of the search index you want to create.
        :param pulumi.Input[str] project_id: The ID of the organization or project you want to create the search index within.
        :param pulumi.Input[str] search_analyzer: [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when searching the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        :param pulumi.Input[str] status: Current status of the index.
        :param pulumi.Input[str] stored_source: String that can be "true" (store all fields), "false" (default, don't store any field), or a JSON string that contains the list of fields to store (include) or not store (exclude) on Atlas Search. To learn more, see [Stored Source Fields](https://www.mongodb.com/docs/atlas/atlas-search/stored-source-definition/).
        :param pulumi.Input[Sequence[pulumi.Input['SearchIndexSynonymArgs']]] synonyms: Synonyms mapping definition to use in this index.
        :param pulumi.Input[str] type: Type of index: `search` or `vectorSearch`. Default type is `search`.
        """
        if analyzer is not None:
            pulumi.set(__self__, "analyzer", analyzer)
        if analyzers is not None:
            pulumi.set(__self__, "analyzers", analyzers)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if collection_name is not None:
            pulumi.set(__self__, "collection_name", collection_name)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if index_id is not None:
            pulumi.set(__self__, "index_id", index_id)
        if mappings_dynamic is not None:
            pulumi.set(__self__, "mappings_dynamic", mappings_dynamic)
        if mappings_fields is not None:
            pulumi.set(__self__, "mappings_fields", mappings_fields)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if search_analyzer is not None:
            pulumi.set(__self__, "search_analyzer", search_analyzer)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stored_source is not None:
            pulumi.set(__self__, "stored_source", stored_source)
        if synonyms is not None:
            pulumi.set(__self__, "synonyms", synonyms)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if wait_for_index_build_completion is not None:
            pulumi.set(__self__, "wait_for_index_build_completion", wait_for_index_build_completion)

    @property
    @pulumi.getter
    def analyzer(self) -> Optional[pulumi.Input[str]]:
        """
        [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when creating the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        """
        return pulumi.get(self, "analyzer")

    @analyzer.setter
    def analyzer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analyzer", value)

    @property
    @pulumi.getter
    def analyzers(self) -> Optional[pulumi.Input[str]]:
        """
        [Custom analyzers](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/custom/#std-label-custom-analyzers) to use in this index. This is an array of JSON objects.
        ```
        analyzers = <<-EOF
        [{
        "name": "index_analyzer_test_name",
        "charFilters": [{
        "type": "mapping",
        "mappings": {"\\\\" : "/"}
        }],
        "tokenizer": {
        "type": "nGram",
        "minGram": 2,
        "maxGram": 5
        },
        "tokenFilters": [{
        "type": "length",
        "min": 20,
        "max": 33
        }]
        }]
        EOF
        ```
        """
        return pulumi.get(self, "analyzers")

    @analyzers.setter
    def analyzers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "analyzers", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster where you want to create the search index within.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the collection the index is on.
        """
        return pulumi.get(self, "collection_name")

    @collection_name.setter
    def collection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection_name", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database the collection is in.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[str]]:
        """
        Array of [Fields](https://www.mongodb.com/docs/atlas/atlas-search/field-types/knn-vector/#std-label-fts-data-types-knn-vector) to configure this `vectorSearch` index. It is mandatory for vector searches and it must contain at least one `vector` type field. This field needs to be a JSON string in order to be decoded correctly.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the Atlas Search index.
        """
        return pulumi.get(self, "index_id")

    @index_id.setter
    def index_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "index_id", value)

    @property
    @pulumi.getter(name="mappingsDynamic")
    def mappings_dynamic(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the search index uses dynamic or static mapping. For dynamic mapping, set the value to `true`. For static mapping, specify the fields to index using `mappings_fields`
        """
        return pulumi.get(self, "mappings_dynamic")

    @mappings_dynamic.setter
    def mappings_dynamic(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mappings_dynamic", value)

    @property
    @pulumi.getter(name="mappingsFields")
    def mappings_fields(self) -> Optional[pulumi.Input[str]]:
        """
        attribute is required in search indexes when `mappings_dynamic` is false. This field needs to be a JSON string in order to be decoded correctly.
        """
        return pulumi.get(self, "mappings_fields")

    @mappings_fields.setter
    def mappings_fields(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mappings_fields", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the search index you want to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the organization or project you want to create the search index within.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="searchAnalyzer")
    def search_analyzer(self) -> Optional[pulumi.Input[str]]:
        """
        [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when searching the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        """
        return pulumi.get(self, "search_analyzer")

    @search_analyzer.setter
    def search_analyzer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_analyzer", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Current status of the index.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storedSource")
    def stored_source(self) -> Optional[pulumi.Input[str]]:
        """
        String that can be "true" (store all fields), "false" (default, don't store any field), or a JSON string that contains the list of fields to store (include) or not store (exclude) on Atlas Search. To learn more, see [Stored Source Fields](https://www.mongodb.com/docs/atlas/atlas-search/stored-source-definition/).
        """
        return pulumi.get(self, "stored_source")

    @stored_source.setter
    def stored_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stored_source", value)

    @property
    @pulumi.getter
    def synonyms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SearchIndexSynonymArgs']]]]:
        """
        Synonyms mapping definition to use in this index.
        """
        return pulumi.get(self, "synonyms")

    @synonyms.setter
    def synonyms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SearchIndexSynonymArgs']]]]):
        pulumi.set(self, "synonyms", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of index: `search` or `vectorSearch`. Default type is `search`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="waitForIndexBuildCompletion")
    def wait_for_index_build_completion(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "wait_for_index_build_completion")

    @wait_for_index_build_completion.setter
    def wait_for_index_build_completion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_index_build_completion", value)


class SearchIndex(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analyzer: Optional[pulumi.Input[str]] = None,
                 analyzers: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 collection_name: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[str]] = None,
                 mappings_dynamic: Optional[pulumi.Input[bool]] = None,
                 mappings_fields: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 search_analyzer: Optional[pulumi.Input[str]] = None,
                 stored_source: Optional[pulumi.Input[str]] = None,
                 synonyms: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchIndexSynonymArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 wait_for_index_build_completion: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## # Resource: SearchIndex

        `SearchIndex` provides a Search Index resource. This allows indexes to be created.

        ## Example Usage

        ### Basic search index
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test_basic_search_index = mongodbatlas.SearchIndex("test-basic-search-index",
            name="test-basic-search-index",
            project_id="<PROJECT_ID>",
            cluster_name="<CLUSTER_NAME>",
            analyzer="lucene.standard",
            collection_name="collection_test",
            database="database_test",
            mappings_dynamic=True,
            search_analyzer="lucene.standard")
        ```

        ### Basic vector index
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test_basic_search_vector = mongodbatlas.SearchIndex("test-basic-search-vector",
            project_id="<PROJECT_ID>",
            cluster_name="<CLUSTER_NAME>",
            collection_name="collection_test",
            database="database_test",
            type="vectorSearch",
            fields=\"\"\"[{
              "type": "vector",
              "path": "plot_embedding",
              "numDimensions": 1536,
              "similarity": "euclidean"
        }]
        \"\"\")
        ```

        ### Advanced search index (with custom analyzers)
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test_advanced_search_index = mongodbatlas.SearchIndex("test-advanced-search-index",
            project_id="<PROJECT_ID>",
            cluster_name="<CLUSTER_NAME>",
            analyzer="lucene.standard",
            collection_name="collection_test",
            database="database_test",
            mappings_dynamic=False,
            mappings_fields=\"\"\"{
              "address": {
                "type": "document",
                "fields": {
                  "city": {
                    "type": "string",
                    "analyzer": "lucene.simple",
                    "ignoreAbove": 255
                  },
                  "state": {
                    "type": "string",
                    "analyzer": "lucene.english"
                  }
                }
              },
              "company": {
                "type": "string",
                "analyzer": "lucene.whitespace",
                "multi": {
                  "mySecondaryAnalyzer": {
                    "type": "string",
                    "analyzer": "lucene.french"
                  }
                }
              },
              "employees": {
                "type": "string",
                "analyzer": "lucene.standard"
              }
        }
        \"\"\",
            name="test-advanced-search-index",
            search_analyzer="lucene.standard",
            analyzers=\"\"\" [{
         "name": "index_analyzer_test_name",
         "charFilters": [{
        "type": "mapping",
        "mappings": {"\\\\" : "/"}
           \\x09}],
         "tokenizer": {
         "type": "nGram",
         "minGram": 2,
         "maxGram": 5
        \\x09},
         "tokenFilters": [{
        "type": "length",
        "min": 20,
        "max": 33
           \\x09}]
         }]
        \"\"\",
            synonyms=[mongodbatlas.SearchIndexSynonymArgs(
                analyzer="lucene.simple",
                name="synonym_test",
                source_collection="collection_test",
            )])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] analyzer: [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when creating the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        :param pulumi.Input[str] analyzers: [Custom analyzers](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/custom/#std-label-custom-analyzers) to use in this index. This is an array of JSON objects.
               ```
               analyzers = <<-EOF
               [{
               "name": "index_analyzer_test_name",
               "charFilters": [{
               "type": "mapping",
               "mappings": {"\\\\" : "/"}
               }],
               "tokenizer": {
               "type": "nGram",
               "minGram": 2,
               "maxGram": 5
               },
               "tokenFilters": [{
               "type": "length",
               "min": 20,
               "max": 33
               }]
               }]
               EOF
               ```
        :param pulumi.Input[str] cluster_name: The name of the cluster where you want to create the search index within.
        :param pulumi.Input[str] collection_name: Name of the collection the index is on.
        :param pulumi.Input[str] database: Name of the database the collection is in.
        :param pulumi.Input[str] fields: Array of [Fields](https://www.mongodb.com/docs/atlas/atlas-search/field-types/knn-vector/#std-label-fts-data-types-knn-vector) to configure this `vectorSearch` index. It is mandatory for vector searches and it must contain at least one `vector` type field. This field needs to be a JSON string in order to be decoded correctly.
        :param pulumi.Input[bool] mappings_dynamic: Indicates whether the search index uses dynamic or static mapping. For dynamic mapping, set the value to `true`. For static mapping, specify the fields to index using `mappings_fields`
        :param pulumi.Input[str] mappings_fields: attribute is required in search indexes when `mappings_dynamic` is false. This field needs to be a JSON string in order to be decoded correctly.
        :param pulumi.Input[str] name: The name of the search index you want to create.
        :param pulumi.Input[str] project_id: The ID of the organization or project you want to create the search index within.
        :param pulumi.Input[str] search_analyzer: [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when searching the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        :param pulumi.Input[str] stored_source: String that can be "true" (store all fields), "false" (default, don't store any field), or a JSON string that contains the list of fields to store (include) or not store (exclude) on Atlas Search. To learn more, see [Stored Source Fields](https://www.mongodb.com/docs/atlas/atlas-search/stored-source-definition/).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchIndexSynonymArgs']]]] synonyms: Synonyms mapping definition to use in this index.
        :param pulumi.Input[str] type: Type of index: `search` or `vectorSearch`. Default type is `search`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SearchIndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: SearchIndex

        `SearchIndex` provides a Search Index resource. This allows indexes to be created.

        ## Example Usage

        ### Basic search index
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test_basic_search_index = mongodbatlas.SearchIndex("test-basic-search-index",
            name="test-basic-search-index",
            project_id="<PROJECT_ID>",
            cluster_name="<CLUSTER_NAME>",
            analyzer="lucene.standard",
            collection_name="collection_test",
            database="database_test",
            mappings_dynamic=True,
            search_analyzer="lucene.standard")
        ```

        ### Basic vector index
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test_basic_search_vector = mongodbatlas.SearchIndex("test-basic-search-vector",
            project_id="<PROJECT_ID>",
            cluster_name="<CLUSTER_NAME>",
            collection_name="collection_test",
            database="database_test",
            type="vectorSearch",
            fields=\"\"\"[{
              "type": "vector",
              "path": "plot_embedding",
              "numDimensions": 1536,
              "similarity": "euclidean"
        }]
        \"\"\")
        ```

        ### Advanced search index (with custom analyzers)
        ```python
        import pulumi
        import pulumi_mongodbatlas as mongodbatlas

        test_advanced_search_index = mongodbatlas.SearchIndex("test-advanced-search-index",
            project_id="<PROJECT_ID>",
            cluster_name="<CLUSTER_NAME>",
            analyzer="lucene.standard",
            collection_name="collection_test",
            database="database_test",
            mappings_dynamic=False,
            mappings_fields=\"\"\"{
              "address": {
                "type": "document",
                "fields": {
                  "city": {
                    "type": "string",
                    "analyzer": "lucene.simple",
                    "ignoreAbove": 255
                  },
                  "state": {
                    "type": "string",
                    "analyzer": "lucene.english"
                  }
                }
              },
              "company": {
                "type": "string",
                "analyzer": "lucene.whitespace",
                "multi": {
                  "mySecondaryAnalyzer": {
                    "type": "string",
                    "analyzer": "lucene.french"
                  }
                }
              },
              "employees": {
                "type": "string",
                "analyzer": "lucene.standard"
              }
        }
        \"\"\",
            name="test-advanced-search-index",
            search_analyzer="lucene.standard",
            analyzers=\"\"\" [{
         "name": "index_analyzer_test_name",
         "charFilters": [{
        "type": "mapping",
        "mappings": {"\\\\" : "/"}
           \\x09}],
         "tokenizer": {
         "type": "nGram",
         "minGram": 2,
         "maxGram": 5
        \\x09},
         "tokenFilters": [{
        "type": "length",
        "min": 20,
        "max": 33
           \\x09}]
         }]
        \"\"\",
            synonyms=[mongodbatlas.SearchIndexSynonymArgs(
                analyzer="lucene.simple",
                name="synonym_test",
                source_collection="collection_test",
            )])
        ```

        :param str resource_name: The name of the resource.
        :param SearchIndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SearchIndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analyzer: Optional[pulumi.Input[str]] = None,
                 analyzers: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 collection_name: Optional[pulumi.Input[str]] = None,
                 database: Optional[pulumi.Input[str]] = None,
                 fields: Optional[pulumi.Input[str]] = None,
                 mappings_dynamic: Optional[pulumi.Input[bool]] = None,
                 mappings_fields: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 search_analyzer: Optional[pulumi.Input[str]] = None,
                 stored_source: Optional[pulumi.Input[str]] = None,
                 synonyms: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchIndexSynonymArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 wait_for_index_build_completion: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SearchIndexArgs.__new__(SearchIndexArgs)

            __props__.__dict__["analyzer"] = analyzer
            __props__.__dict__["analyzers"] = analyzers
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            if collection_name is None and not opts.urn:
                raise TypeError("Missing required property 'collection_name'")
            __props__.__dict__["collection_name"] = collection_name
            if database is None and not opts.urn:
                raise TypeError("Missing required property 'database'")
            __props__.__dict__["database"] = database
            __props__.__dict__["fields"] = fields
            __props__.__dict__["mappings_dynamic"] = mappings_dynamic
            __props__.__dict__["mappings_fields"] = mappings_fields
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["search_analyzer"] = search_analyzer
            __props__.__dict__["stored_source"] = stored_source
            __props__.__dict__["synonyms"] = synonyms
            __props__.__dict__["type"] = type
            __props__.__dict__["wait_for_index_build_completion"] = wait_for_index_build_completion
            __props__.__dict__["index_id"] = None
            __props__.__dict__["status"] = None
        super(SearchIndex, __self__).__init__(
            'mongodbatlas:index/searchIndex:SearchIndex',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            analyzer: Optional[pulumi.Input[str]] = None,
            analyzers: Optional[pulumi.Input[str]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            collection_name: Optional[pulumi.Input[str]] = None,
            database: Optional[pulumi.Input[str]] = None,
            fields: Optional[pulumi.Input[str]] = None,
            index_id: Optional[pulumi.Input[str]] = None,
            mappings_dynamic: Optional[pulumi.Input[bool]] = None,
            mappings_fields: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            search_analyzer: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            stored_source: Optional[pulumi.Input[str]] = None,
            synonyms: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchIndexSynonymArgs']]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            wait_for_index_build_completion: Optional[pulumi.Input[bool]] = None) -> 'SearchIndex':
        """
        Get an existing SearchIndex resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] analyzer: [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when creating the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        :param pulumi.Input[str] analyzers: [Custom analyzers](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/custom/#std-label-custom-analyzers) to use in this index. This is an array of JSON objects.
               ```
               analyzers = <<-EOF
               [{
               "name": "index_analyzer_test_name",
               "charFilters": [{
               "type": "mapping",
               "mappings": {"\\\\" : "/"}
               }],
               "tokenizer": {
               "type": "nGram",
               "minGram": 2,
               "maxGram": 5
               },
               "tokenFilters": [{
               "type": "length",
               "min": 20,
               "max": 33
               }]
               }]
               EOF
               ```
        :param pulumi.Input[str] cluster_name: The name of the cluster where you want to create the search index within.
        :param pulumi.Input[str] collection_name: Name of the collection the index is on.
        :param pulumi.Input[str] database: Name of the database the collection is in.
        :param pulumi.Input[str] fields: Array of [Fields](https://www.mongodb.com/docs/atlas/atlas-search/field-types/knn-vector/#std-label-fts-data-types-knn-vector) to configure this `vectorSearch` index. It is mandatory for vector searches and it must contain at least one `vector` type field. This field needs to be a JSON string in order to be decoded correctly.
        :param pulumi.Input[str] index_id: The unique identifier of the Atlas Search index.
        :param pulumi.Input[bool] mappings_dynamic: Indicates whether the search index uses dynamic or static mapping. For dynamic mapping, set the value to `true`. For static mapping, specify the fields to index using `mappings_fields`
        :param pulumi.Input[str] mappings_fields: attribute is required in search indexes when `mappings_dynamic` is false. This field needs to be a JSON string in order to be decoded correctly.
        :param pulumi.Input[str] name: The name of the search index you want to create.
        :param pulumi.Input[str] project_id: The ID of the organization or project you want to create the search index within.
        :param pulumi.Input[str] search_analyzer: [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when searching the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        :param pulumi.Input[str] status: Current status of the index.
        :param pulumi.Input[str] stored_source: String that can be "true" (store all fields), "false" (default, don't store any field), or a JSON string that contains the list of fields to store (include) or not store (exclude) on Atlas Search. To learn more, see [Stored Source Fields](https://www.mongodb.com/docs/atlas/atlas-search/stored-source-definition/).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SearchIndexSynonymArgs']]]] synonyms: Synonyms mapping definition to use in this index.
        :param pulumi.Input[str] type: Type of index: `search` or `vectorSearch`. Default type is `search`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SearchIndexState.__new__(_SearchIndexState)

        __props__.__dict__["analyzer"] = analyzer
        __props__.__dict__["analyzers"] = analyzers
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["collection_name"] = collection_name
        __props__.__dict__["database"] = database
        __props__.__dict__["fields"] = fields
        __props__.__dict__["index_id"] = index_id
        __props__.__dict__["mappings_dynamic"] = mappings_dynamic
        __props__.__dict__["mappings_fields"] = mappings_fields
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["search_analyzer"] = search_analyzer
        __props__.__dict__["status"] = status
        __props__.__dict__["stored_source"] = stored_source
        __props__.__dict__["synonyms"] = synonyms
        __props__.__dict__["type"] = type
        __props__.__dict__["wait_for_index_build_completion"] = wait_for_index_build_completion
        return SearchIndex(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def analyzer(self) -> pulumi.Output[Optional[str]]:
        """
        [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when creating the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        """
        return pulumi.get(self, "analyzer")

    @property
    @pulumi.getter
    def analyzers(self) -> pulumi.Output[Optional[str]]:
        """
        [Custom analyzers](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/custom/#std-label-custom-analyzers) to use in this index. This is an array of JSON objects.
        ```
        analyzers = <<-EOF
        [{
        "name": "index_analyzer_test_name",
        "charFilters": [{
        "type": "mapping",
        "mappings": {"\\\\" : "/"}
        }],
        "tokenizer": {
        "type": "nGram",
        "minGram": 2,
        "maxGram": 5
        },
        "tokenFilters": [{
        "type": "length",
        "min": 20,
        "max": 33
        }]
        }]
        EOF
        ```
        """
        return pulumi.get(self, "analyzers")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        The name of the cluster where you want to create the search index within.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="collectionName")
    def collection_name(self) -> pulumi.Output[str]:
        """
        Name of the collection the index is on.
        """
        return pulumi.get(self, "collection_name")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output[str]:
        """
        Name of the database the collection is in.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter
    def fields(self) -> pulumi.Output[Optional[str]]:
        """
        Array of [Fields](https://www.mongodb.com/docs/atlas/atlas-search/field-types/knn-vector/#std-label-fts-data-types-knn-vector) to configure this `vectorSearch` index. It is mandatory for vector searches and it must contain at least one `vector` type field. This field needs to be a JSON string in order to be decoded correctly.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="indexId")
    def index_id(self) -> pulumi.Output[str]:
        """
        The unique identifier of the Atlas Search index.
        """
        return pulumi.get(self, "index_id")

    @property
    @pulumi.getter(name="mappingsDynamic")
    def mappings_dynamic(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the search index uses dynamic or static mapping. For dynamic mapping, set the value to `true`. For static mapping, specify the fields to index using `mappings_fields`
        """
        return pulumi.get(self, "mappings_dynamic")

    @property
    @pulumi.getter(name="mappingsFields")
    def mappings_fields(self) -> pulumi.Output[Optional[str]]:
        """
        attribute is required in search indexes when `mappings_dynamic` is false. This field needs to be a JSON string in order to be decoded correctly.
        """
        return pulumi.get(self, "mappings_fields")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the search index you want to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the organization or project you want to create the search index within.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="searchAnalyzer")
    def search_analyzer(self) -> pulumi.Output[Optional[str]]:
        """
        [Analyzer](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/#std-label-analyzers-ref) to use when searching the index. Defaults to [lucene.standard](https://docs.atlas.mongodb.com/reference/atlas-search/analyzers/standard/#std-label-ref-standard-analyzer)
        """
        return pulumi.get(self, "search_analyzer")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Current status of the index.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storedSource")
    def stored_source(self) -> pulumi.Output[Optional[str]]:
        """
        String that can be "true" (store all fields), "false" (default, don't store any field), or a JSON string that contains the list of fields to store (include) or not store (exclude) on Atlas Search. To learn more, see [Stored Source Fields](https://www.mongodb.com/docs/atlas/atlas-search/stored-source-definition/).
        """
        return pulumi.get(self, "stored_source")

    @property
    @pulumi.getter
    def synonyms(self) -> pulumi.Output[Optional[Sequence['outputs.SearchIndexSynonym']]]:
        """
        Synonyms mapping definition to use in this index.
        """
        return pulumi.get(self, "synonyms")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of index: `search` or `vectorSearch`. Default type is `search`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="waitForIndexBuildCompletion")
    def wait_for_index_build_completion(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "wait_for_index_build_completion")

