from enum import Enum

class GS1ApplicationIdentifier(Enum):
    SSCC = "00"
    GTIN = "01"
    CONTENT = "02"
    MTO_GTIN = "03"
    BATCH_LOT = "10"
    PROD_DATE = "11"
    DUE_DATE = "12"
    PACK_DATE = "13"
    BEST_BEFORE_OR_BEST_BY = "15"
    SELL_BY = "16"
    USE_BY_OR_EXPIRY = "17"
    VARIANT = "20"
    SERIAL = "21"
    CPV = "22"
    VAR_COUNT = "30"
    COUNT = "37"
    INTERNAL = "90"
    TPX = "235"
    ADDITIONAL_ID = "240"
    CUST_PART_NO = "241"
    MTO_VARIANT = "242"
    PCN = "243"
    SECONDARY_SERIAL = "250"
    REF_TO_SOURCE = "251"
    GDTI = "253"
    GLN_EXTENSION_COMPONENT = "254"
    GCN = "255"
    ORDER_NUMBER = "400"
    GINC = "401"
    GSIN = "402"
    ROUTE = "403"
    SHIP_TO_LOC = "410"
    BILL_TO = "411"
    PURCHASE_FROM = "412"
    SHIP_FOR_LOC = "413"
    LOC_NO = "414"
    PAY_TO = "415"
    PROD_SERV_LOC = "416"
    PARTY = "417"
    SHIP_TO_POST = "420"
    ORIGIN = "422"
    COUNTRY___INITIAL_PROCESS = "423"
    COUNTRY___PROCESS = "424"
    COUNTRY___DISASSEMBLY = "425"
    COUNTRY___FULL_PROCESS = "426"
    ORIGIN_SUBDIVISION = "427"
    NHRN_PZN = "710"
    NHRN_CIP = "711"
    NHRN_CN = "712"
    NHRN_DRN = "713"
    NHRN_AIM = "714"
    NHRN_NDC = "715"
    NHRN_AIC = "716"
    
    def as_url(self) -> str:
        # prefix the enum’s name to point to the description in the web
        return f"ref.gs1.org/ai/{self.name}"
  
