# THIS FILE HAS BEEN AUTOGENERATED
from __future__ import annotations

import typing as t
from abc import ABC, abstractmethod
from dataclasses import dataclass

from pylox.protocols.visitor import VisitorProtocol
from pylox.tokens import LITERAL_T, Token


class Expr(ABC):  # pragma: no cover
    pass

    @abstractmethod
    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return NotImplemented


@dataclass(slots=True, eq=False)
class Assign(Expr):
    name: Token
    value: Expr

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Assign(self)


@dataclass(slots=True, eq=False)
class Binary(Expr):
    expr_left: Expr
    token_operator: Token
    expr_right: Expr

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Binary(self)


@dataclass(slots=True, eq=False)
class Call(Expr):
    callee: Expr
    closing_paren: Token
    arguments: list[Expr]

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Call(self)


@dataclass(slots=True, eq=False)
class Get(Expr):
    object_: Expr
    name: Token

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Get(self)


@dataclass(slots=True, eq=False)
class Grouping(Expr):
    expr_expression: Expr

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Grouping(self)


@dataclass(slots=True, eq=False)
class Literal(Expr):
    object_value: LITERAL_T

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Literal(self)


@dataclass(slots=True, eq=False)
class Logical(Expr):
    expr_left: Expr
    token_operator: Token
    expr_right: Expr

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Logical(self)


@dataclass(slots=True, eq=False)
class Set(Expr):
    object_: Expr
    name: Token
    value: Expr

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Set(self)


@dataclass(slots=True, eq=False)
class Super(Expr):
    keyword: Token
    method: Token

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Super(self)


@dataclass(slots=True, eq=False)
class This(Expr):
    keyword: Token

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_This(self)


@dataclass(slots=True, eq=False)
class Unary(Expr):
    token_operator: Token
    expr_right: Expr

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Unary(self)


@dataclass(slots=True, eq=False)
class Variable(Expr):
    name: Token

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Variable(self)


class Stmt(ABC):  # pragma: no cover
    pass

    @abstractmethod
    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return NotImplemented


@dataclass(slots=True, eq=False)
class Block(Stmt):
    statements: list[Stmt]

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Block(self)


@dataclass(slots=True, eq=False)
class Class(Stmt):
    name: Token
    superclass: t.Optional[Variable]
    methods: list[Function]

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Class(self)


@dataclass(slots=True, eq=False)
class Expression(Stmt):
    expr_expression: Expr

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Expression(self)


@dataclass(slots=True, eq=False)
class Function(Stmt):
    name: Token
    params: list[Token]
    body: list[Stmt]

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Function(self)


@dataclass(slots=True, eq=False)
class If(Stmt):
    condition: Expr
    then_branch: Stmt
    else_branch: t.Optional[Stmt]

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_If(self)


@dataclass(slots=True, eq=False)
class Var(Stmt):
    name: Token
    initializer: t.Optional[Expr]

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Var(self)


@dataclass(slots=True, eq=False)
class Return(Stmt):
    keyword: Token
    value: t.Optional[Expr]

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Return(self)


@dataclass(slots=True, eq=False)
class Print(Stmt):
    expr_expression: Expr

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Print(self)


@dataclass(slots=True, eq=False)
class While(Stmt):
    condition: Expr
    body: Stmt

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_While(self)


@dataclass(slots=True, eq=False)
class Break(Stmt):
    keyword: Token

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Break(self)


@dataclass(slots=True, eq=False)
class Continue(Stmt):
    keyword: Token

    def accept(self, visitor: VisitorProtocol) -> t.Any:
        return visitor.visit_Continue(self)
