# [명령어 이름] 명령어

> 💡 **빠른 시작**: `cli-onprem [command] [args] [options]`

## 📋 목차

- [개요](#개요)
- [사용 시나리오](#사용-시나리오)
- [사용법](#사용법)
- [옵션](#옵션)
- [예제](#예제)
- [고급 기능](#고급-기능)
- [문제 해결](#문제-해결)
- [관련 명령어](#관련-명령어)

## 개요

[명령어의 주요 기능과 목적을 2-3문장으로 설명]

### 주요 특징

- ✨ 특징 1
- ✨ 특징 2
- ✨ 특징 3

## 사용 시나리오

이 명령어는 다음과 같은 상황에서 유용합니다:

1. **시나리오 1**: [설명]
2. **시나리오 2**: [설명]
3. **시나리오 3**: [설명]

## 사용법

### 기본 문법

```bash
cli-onprem [command] <필수인자> [선택인자] [OPTIONS]
```

### 빠른 예제

```bash
# 가장 기본적인 사용법
cli-onprem [command] [example]
```

## 옵션

### 필수 인자

| 인자 | 설명 | 형식 | 예시 |
|------|------|------|------|
| `<arg1>` | 설명 | 형식 | `example` |

### 선택 옵션

| 옵션 | 약어 | 설명 | 기본값 | 예시 |
|------|------|------|--------|------|
| `--option1` | `-o` | 옵션 설명 | `default` | `--option1 value` |
| `--option2` | `-p` | 옵션 설명 | `default` | `--option2 value` |
| `--flag` | `-f` | 플래그 설명 | `false` | `--flag` |

### 고급 옵션

| 옵션 | 설명 | 사용 시 주의사항 |
|------|------|-----------------|
| `--advanced1` | 고급 기능 설명 | 주의사항 |

## 예제

### 🎯 기본 사용 예제

```bash
# 예제 1: 기본 사용
cli-onprem [command] [args]
# 결과: [예상 결과 설명]

# 예제 2: 옵션 사용
cli-onprem [command] [args] --option value
# 결과: [예상 결과 설명]
```

### 🚀 실무 활용 예제

#### 1. [시나리오 제목]

```bash
# 실제 사용 상황 설명
cli-onprem [command] [complex-example]

# 결과 확인
ls -la [output]
```

#### 2. [시나리오 제목]

```bash
# 파이프라인과 함께 사용
cli-onprem [command] [args] | another-command

# 스크립트에서 사용
#!/bin/bash
result=$(cli-onprem [command] [args])
echo "결과: $result"
```

### 📝 출력 예시

```
[실제 출력 예시를 여기에 표시]
```

## 고급 기능

### [고급 기능 1]

[고급 기능에 대한 상세 설명]

```bash
# 고급 기능 사용 예제
cli-onprem [command] [advanced-usage]
```

### [고급 기능 2]

[설명 및 사용 방법]

## 문제 해결

### 자주 발생하는 문제

#### ❌ 오류: [오류 메시지]

**원인**: [오류 원인 설명]

**해결 방법**:
```bash
# 해결 명령어
cli-onprem [solution]
```

#### ❌ 오류: [오류 메시지]

**원인**: [오류 원인 설명]

**해결 방법**:
1. 단계 1
2. 단계 2
3. 단계 3

### 디버깅 팁

- 💡 `--verbose` 옵션을 사용하여 상세 로그 확인
- 💡 `--dry-run` 옵션으로 실제 실행 전 테스트
- 💡 환경 변수 `DEBUG=1` 설정으로 디버그 모드 활성화

## 관련 명령어

- 📌 [`[related-command1]`](./related1.md) - 관련 기능 설명
- 📌 [`[related-command2]`](./related2.md) - 관련 기능 설명
- 📌 [`[related-command3]`](./related3.md) - 관련 기능 설명

---

<details>
<summary>📚 추가 참고 자료</summary>

- [공식 문서 링크]()
- [관련 블로그 포스트]()
- [동영상 튜토리얼]()

</details>

<details>
<summary>🔄 변경 이력</summary>

- v0.11.0: 기능 추가
- v0.10.0: 초기 릴리즈

</details>