# 버전 관리 방식

이 문서는 CLI-ONPREM 프로젝트의 버전 관리 방식을 설명합니다.

## 시맨틱 버저닝

CLI-ONPREM은 [시맨틱 버저닝(SemVer)](https://semver.org/lang/ko/) 규칙을 따릅니다:

- **메이저 버전(X.y.z)**: 호환성이 깨지는 변경사항
- **마이너 버전(x.Y.z)**: 호환성을 유지하는 기능 추가
- **패치 버전(x.y.Z)**: 버그 수정

## 커밋 메시지 기반 자동 버전 관리

CLI-ONPREM은 [Conventional Commits](https://www.conventionalcommits.org/) 형식의 커밋 메시지를 사용하여 자동으로 버전을 관리합니다.

### 커밋 메시지 형식

```
<타입>[!]: <설명>

[본문]

[꼬리말]
```

### 주요 커밋 타입

- `feat`: 새로운 기능 추가 (마이너 버전 증가)
- `fix`: 버그 수정 (패치 버전 증가)
- `docs`: 문서 변경
- `style`: 코드 스타일 변경 (포맷팅, 세미콜론 누락 등)
- `refactor`: 코드 리팩토링
- `perf`: 성능 개선
- `test`: 테스트 추가 또는 수정
- `build`: 빌드 시스템 변경
- `ci`: CI 설정 변경
- `chore`: 기타 변경사항

### 버전 증가 규칙

- **메이저 버전 증가**: 
  - `feat!:` 또는 `fix!:` 등 타입 뒤에 `!`가 붙은 경우
  - 커밋 메시지 본문에 `BREAKING CHANGE:`가 포함된 경우
  - **주의**: `major_on_zero = true` 설정으로 인해 0.x.x 버전에서 BREAKING CHANGE가 발생하면 0.(x+1).0이 아닌 1.0.0으로 바로 올라갑니다

- **마이너 버전 증가**:
  - `feat:` 타입의 커밋이 있는 경우

- **패치 버전 증가**:
  - `fix:` 타입의 커밋이 있는 경우

### BREAKING CHANGE 감지 방식

`python-semantic-release`는 Angular 커밋 파서(`AngularCommitParser`)를 사용하여 자동으로 BREAKING CHANGE를 감지합니다:

1. **커밋 메시지 footer**: 커밋 메시지 본문 아래에 `BREAKING CHANGE:` 텍스트가 포함되면 자동으로 메이저 버전 증가로 인식
2. **느낌표(!) 표기**: 커밋 타입 뒤에 `!`를 붙이면 (예: `feat!:`, `fix!:`) 메이저 버전 증가로 인식

이 감지는 `pyproject.toml`의 다음 설정에 의해 작동합니다:
```toml
commit_parser = "semantic_release.commit_parser.angular:AngularCommitParser"
```

### 예시

```bash
# 마이너 버전 증가 (0.1.0 → 0.2.0)
git commit -m "feat: 새로운 명령어 추가"

# 패치 버전 증가 (0.1.0 → 0.1.1)
git commit -m "fix: 오류 수정"

# 메이저 버전 증가 (0.1.0 → 1.0.0)
git commit -m "feat!: 호환성이 깨지는 변경사항"
# 또는
git commit -m "feat: 새 기능 추가

BREAKING CHANGE: API 변경"
```

## 버전 관리 설정

버전 관리는 `python-semantic-release` 패키지를 사용하여 자동화됩니다. 설정은 `pyproject.toml` 파일에 정의되어 있습니다:

```toml
[semantic_release]
version_toml = ["pyproject.toml:project.version"]
commit_message = "{version}\n\nAutomatically generated by python-semantic-release"
commit_parser = "conventional"
tag_format = "v{version}"

[semantic_release.branches.main]
match = "(main|master)"
prerelease_token = "rc"
prerelease = false

[semantic_release.commit_parser_options]
minor_tags = ["feat"]
patch_tags = ["fix", "perf"]
other_allowed_tags = [
  "build",
  "chore",
  "ci",
  "docs",
  "style",
  "refactor",
  "test",
]

[semantic_release.publish]
dist_glob_patterns = ["dist/*"]
upload_to_vcs_release = true
```

## 변경 이력 관리

모든 변경 사항은 `CHANGELOG.md` 파일에 자동으로 기록됩니다. 이 파일은 `python-semantic-release`에 의해 자동으로 업데이트됩니다.

## 릴리스 프로세스

1. 개발 브랜치에서 작업 수행
2. Conventional Commits 형식으로 커밋
3. PR 생성 및 main 브랜치에 병합
4. GitHub Actions에서 `semantic-release version` 명령을 실행하여 새 태그 생성 여부를 확인합니다. 새 태그가 없으면 이후 빌드와 배포 단계가 실행되지 않습니다.
5. 새 태그가 생성되면 패키지를 빌드하여 PyPI에 자동 배포합니다.
