import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataDatadogMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of monitor tags to limit the search. This filters on the tags set on the monitor itself.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitor.html#monitor_tags_filter DataDatadogMonitor#monitor_tags_filter}
     *
     * @stability stable
     */
    readonly monitorTagsFilter?: string[];
    /**
     * A monitor name to limit the search.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitor.html#name_filter DataDatadogMonitor#name_filter}
     *
     * @stability stable
     */
    readonly nameFilter?: string;
    /**
     * A list of tags to limit the search. This filters on the monitor scope.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitor.html#tags_filter DataDatadogMonitor#tags_filter}
     *
     * @stability stable
     */
    readonly tagsFilter?: string[];
}
/**
 * @stability stable
 */
export declare class DataDatadogMonitorMonitorThresholdWindows extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get recoveryWindow(): string;
    /**
     * @stability stable
     */
    get triggerWindow(): string;
}
/**
 * @stability stable
 */
export declare class DataDatadogMonitorMonitorThresholds extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get critical(): string;
    /**
     * @stability stable
     */
    get criticalRecovery(): string;
    /**
     * @stability stable
     */
    get ok(): string;
    /**
     * @stability stable
     */
    get unknown(): string;
    /**
     * @stability stable
     */
    get warning(): string;
    /**
     * @stability stable
     */
    get warningRecovery(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/d/monitor.html datadog_monitor}.
 *
 * @stability stable
 */
export declare class DataDatadogMonitor extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/monitor.html datadog_monitor} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataDatadogMonitorConfig);
    /**
     * @stability stable
     */
    get enableLogsSample(): any;
    /**
     * @stability stable
     */
    get escalationMessage(): string;
    /**
     * @stability stable
     */
    get evaluationDelay(): number;
    /**
     * @stability stable
     */
    get groupbySimpleMonitor(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get includeTags(): any;
    /**
     * @stability stable
     */
    get locked(): any;
    /**
     * @stability stable
     */
    get message(): string;
    private _monitorTagsFilter?;
    /**
     * @stability stable
     */
    get monitorTagsFilter(): string[] | undefined;
    /**
     * @stability stable
     */
    set monitorTagsFilter(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetMonitorTagsFilter(): void;
    /**
     * @stability stable
     */
    get monitorTagsFilterInput(): string[] | undefined;
    /**
     * @stability stable
     */
    monitorThresholdWindows(index: string): DataDatadogMonitorMonitorThresholdWindows;
    /**
     * @stability stable
     */
    monitorThresholds(index: string): DataDatadogMonitorMonitorThresholds;
    /**
     * @stability stable
     */
    get name(): string;
    private _nameFilter?;
    /**
     * @stability stable
     */
    get nameFilter(): string | undefined;
    /**
     * @stability stable
     */
    set nameFilter(value: string | undefined);
    /**
     * @stability stable
     */
    resetNameFilter(): void;
    /**
     * @stability stable
     */
    get nameFilterInput(): string | undefined;
    /**
     * @stability stable
     */
    get newGroupDelay(): number;
    /**
     * @stability stable
     */
    get newHostDelay(): number;
    /**
     * @stability stable
     */
    get noDataTimeframe(): number;
    /**
     * @stability stable
     */
    get notifyAudit(): any;
    /**
     * @stability stable
     */
    get notifyNoData(): any;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    get renotifyInterval(): number;
    /**
     * @stability stable
     */
    get renotifyOccurrences(): number;
    /**
     * @stability stable
     */
    get renotifyStatuses(): string[];
    /**
     * @stability stable
     */
    get requireFullWindow(): any;
    /**
     * @stability stable
     */
    get restrictedRoles(): string[];
    /**
     * @stability stable
     */
    get tags(): string[];
    private _tagsFilter?;
    /**
     * @stability stable
     */
    get tagsFilter(): string[] | undefined;
    /**
     * @stability stable
     */
    set tagsFilter(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTagsFilter(): void;
    /**
     * @stability stable
     */
    get tagsFilterInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get timeoutH(): number;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
