import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataDatadogMonitorsConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of monitor tags to limit the search. This filters on the tags set on the monitor itself.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitors.html#monitor_tags_filter DataDatadogMonitors#monitor_tags_filter}
     *
     * @stability stable
     */
    readonly monitorTagsFilter?: string[];
    /**
     * A monitor name to limit the search.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitors.html#name_filter DataDatadogMonitors#name_filter}
     *
     * @stability stable
     */
    readonly nameFilter?: string;
    /**
     * A list of tags to limit the search. This filters on the monitor scope.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/monitors.html#tags_filter DataDatadogMonitors#tags_filter}
     *
     * @stability stable
     */
    readonly tagsFilter?: string[];
}
/**
 * @stability stable
 */
export declare class DataDatadogMonitorsMonitors extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): number;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/d/monitors.html datadog_monitors}.
 *
 * @stability stable
 */
export declare class DataDatadogMonitors extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/monitors.html datadog_monitors} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataDatadogMonitorsConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _monitorTagsFilter?;
    /**
     * @stability stable
     */
    get monitorTagsFilter(): string[] | undefined;
    /**
     * @stability stable
     */
    set monitorTagsFilter(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetMonitorTagsFilter(): void;
    /**
     * @stability stable
     */
    get monitorTagsFilterInput(): string[] | undefined;
    /**
     * @stability stable
     */
    monitors(index: string): DataDatadogMonitorsMonitors;
    private _nameFilter?;
    /**
     * @stability stable
     */
    get nameFilter(): string | undefined;
    /**
     * @stability stable
     */
    set nameFilter(value: string | undefined);
    /**
     * @stability stable
     */
    resetNameFilter(): void;
    /**
     * @stability stable
     */
    get nameFilterInput(): string | undefined;
    private _tagsFilter?;
    /**
     * @stability stable
     */
    get tagsFilter(): string[] | undefined;
    /**
     * @stability stable
     */
    set tagsFilter(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTagsFilter(): void;
    /**
     * @stability stable
     */
    get tagsFilterInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
