import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataDatadogRoleConfig extends cdktf.TerraformMetaArguments {
    /**
     * A string on which to filter the roles.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/role.html#filter DataDatadogRole#filter}
     *
     * @stability stable
     */
    readonly filter: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/d/role.html datadog_role}.
 *
 * @stability stable
 */
export declare class DataDatadogRole extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/role.html datadog_role} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataDatadogRoleConfig);
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get userCount(): number;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
