import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataDatadogServiceLevelObjectivesConfig extends cdktf.TerraformMetaArguments {
    /**
     * An array of SLO IDs to limit the search.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objectives.html#ids DataDatadogServiceLevelObjectives#ids}
     *
     * @stability stable
     */
    readonly ids?: string[];
    /**
     * Filter results based on SLO numerator and denominator.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objectives.html#metrics_query DataDatadogServiceLevelObjectives#metrics_query}
     *
     * @stability stable
     */
    readonly metricsQuery?: string;
    /**
     * Filter results based on SLO names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objectives.html#name_query DataDatadogServiceLevelObjectives#name_query}
     *
     * @stability stable
     */
    readonly nameQuery?: string;
    /**
     * Filter results based on a single SLO tag.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objectives.html#tags_query DataDatadogServiceLevelObjectives#tags_query}
     *
     * @stability stable
     */
    readonly tagsQuery?: string;
}
/**
 * @stability stable
 */
export declare class DataDatadogServiceLevelObjectivesSlos extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objectives.html datadog_service_level_objectives}.
 *
 * @stability stable
 */
export declare class DataDatadogServiceLevelObjectives extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/d/service_level_objectives.html datadog_service_level_objectives} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataDatadogServiceLevelObjectivesConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _ids?;
    /**
     * @stability stable
     */
    get ids(): string[] | undefined;
    /**
     * @stability stable
     */
    set ids(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetIds(): void;
    /**
     * @stability stable
     */
    get idsInput(): string[] | undefined;
    private _metricsQuery?;
    /**
     * @stability stable
     */
    get metricsQuery(): string | undefined;
    /**
     * @stability stable
     */
    set metricsQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetMetricsQuery(): void;
    /**
     * @stability stable
     */
    get metricsQueryInput(): string | undefined;
    private _nameQuery?;
    /**
     * @stability stable
     */
    get nameQuery(): string | undefined;
    /**
     * @stability stable
     */
    set nameQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetNameQuery(): void;
    /**
     * @stability stable
     */
    get nameQueryInput(): string | undefined;
    /**
     * @stability stable
     */
    slos(index: string): DataDatadogServiceLevelObjectivesSlos;
    private _tagsQuery?;
    /**
     * @stability stable
     */
    get tagsQuery(): string | undefined;
    /**
     * @stability stable
     */
    set tagsQuery(value: string | undefined);
    /**
     * @stability stable
     */
    resetTagsQuery(): void;
    /**
     * @stability stable
     */
    get tagsQueryInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
