import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IntegrationGcpConfig extends cdktf.TerraformMetaArguments {
    /**
     * Silence monitors for expected GCE instance shutdowns.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp.html#automute IntegrationGcp#automute}
     *
     * @stability stable
     */
    readonly automute?: boolean | cdktf.IResolvable;
    /**
     * Your email found in your JSON service account key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp.html#client_email IntegrationGcp#client_email}
     *
     * @stability stable
     */
    readonly clientEmail: string;
    /**
     * Your ID found in your JSON service account key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp.html#client_id IntegrationGcp#client_id}
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Limit the GCE instances that are pulled into Datadog by using tags.
     *
     * Only hosts that match one of the defined tags are imported into Datadog.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp.html#host_filters IntegrationGcp#host_filters}
     *
     * @stability stable
     */
    readonly hostFilters?: string;
    /**
     * Your private key name found in your JSON service account key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp.html#private_key IntegrationGcp#private_key}
     *
     * @stability stable
     */
    readonly privateKey: string;
    /**
     * Your private key ID found in your JSON service account key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp.html#private_key_id IntegrationGcp#private_key_id}
     *
     * @stability stable
     */
    readonly privateKeyId: string;
    /**
     * Your Google Cloud project ID found in your JSON service account key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp.html#project_id IntegrationGcp#project_id}
     *
     * @stability stable
     */
    readonly projectId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp.html datadog_integration_gcp}.
 *
 * @stability stable
 */
export declare class IntegrationGcp extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/integration_gcp.html datadog_integration_gcp} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IntegrationGcpConfig);
    private _automute?;
    /**
     * @stability stable
     */
    get automute(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set automute(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAutomute(): void;
    /**
     * @stability stable
     */
    get automuteInput(): boolean | cdktf.IResolvable | undefined;
    private _clientEmail?;
    /**
     * @stability stable
     */
    get clientEmail(): string;
    /**
     * @stability stable
     */
    set clientEmail(value: string);
    /**
     * @stability stable
     */
    get clientEmailInput(): string | undefined;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _hostFilters?;
    /**
     * @stability stable
     */
    get hostFilters(): string | undefined;
    /**
     * @stability stable
     */
    set hostFilters(value: string | undefined);
    /**
     * @stability stable
     */
    resetHostFilters(): void;
    /**
     * @stability stable
     */
    get hostFiltersInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _privateKey?;
    /**
     * @stability stable
     */
    get privateKey(): string;
    /**
     * @stability stable
     */
    set privateKey(value: string);
    /**
     * @stability stable
     */
    get privateKeyInput(): string | undefined;
    private _privateKeyId?;
    /**
     * @stability stable
     */
    get privateKeyId(): string;
    /**
     * @stability stable
     */
    set privateKeyId(value: string);
    /**
     * @stability stable
     */
    get privateKeyIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    set projectId(value: string);
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
