import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LogsCustomPipelineConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}.
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#filter LogsCustomPipeline#filter}
     *
     * @stability stable
     */
    readonly filter: LogsCustomPipelineFilter[];
    /**
     * processor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#processor LogsCustomPipeline#processor}
     *
     * @stability stable
     */
    readonly processor?: LogsCustomPipelineProcessor[];
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineFilter {
    /**
     * Filter criteria of the category.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#query LogsCustomPipeline#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorArithmeticProcessor {
    /**
     * Arithmetic operation between one or more log attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#expression LogsCustomPipeline#expression}
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Boolean value to enable your pipeline.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * If true, it replaces all missing attributes of expression by 0, false skips the operation if an attribute is missing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_replace_missing LogsCustomPipeline#is_replace_missing}
     *
     * @stability stable
     */
    readonly isReplaceMissing?: boolean | cdktf.IResolvable;
    /**
     * Your pipeline name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Name of the attribute that contains the result of the arithmetic operation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorArithmeticProcessorOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isReplaceMissing?;
    /**
     * @stability stable
     */
    get isReplaceMissing(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isReplaceMissing(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsReplaceMissing(): void;
    /**
     * @stability stable
     */
    get isReplaceMissingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorAttributeRemapper {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Override the target element if already set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#override_on_conflict LogsCustomPipeline#override_on_conflict}
     *
     * @stability stable
     */
    readonly overrideOnConflict?: boolean | cdktf.IResolvable;
    /**
     * Remove or preserve the remapped source element.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#preserve_source LogsCustomPipeline#preserve_source}
     *
     * @stability stable
     */
    readonly preserveSource?: boolean | cdktf.IResolvable;
    /**
     * Defines where the sources are from (log `attribute` or `tag`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#source_type LogsCustomPipeline#source_type}
     *
     * @stability stable
     */
    readonly sourceType: string;
    /**
     * List of source attributes or tags.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
    /**
     * Final attribute or tag name to remap the sources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * If the `target_type` of the remapper is `attribute`, try to cast the value to a new specific type.
     *
     * If the cast is not possible, the original type is kept. `string`, `integer`, or `double` are the possible types. If the `target_type` is `tag`, this parameter may not be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target_format LogsCustomPipeline#target_format}
     *
     * @stability stable
     */
    readonly targetFormat?: string;
    /**
     * Defines if the target is a log `attribute` or `tag`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target_type LogsCustomPipeline#target_type}
     *
     * @stability stable
     */
    readonly targetType: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorAttributeRemapperOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _overrideOnConflict?;
    /**
     * @stability stable
     */
    get overrideOnConflict(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set overrideOnConflict(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetOverrideOnConflict(): void;
    /**
     * @stability stable
     */
    get overrideOnConflictInput(): boolean | cdktf.IResolvable | undefined;
    private _preserveSource?;
    /**
     * @stability stable
     */
    get preserveSource(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set preserveSource(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetPreserveSource(): void;
    /**
     * @stability stable
     */
    get preserveSourceInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceType?;
    /**
     * @stability stable
     */
    get sourceType(): string;
    /**
     * @stability stable
     */
    set sourceType(value: string);
    /**
     * @stability stable
     */
    get sourceTypeInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
    private _targetFormat?;
    /**
     * @stability stable
     */
    get targetFormat(): string | undefined;
    /**
     * @stability stable
     */
    set targetFormat(value: string | undefined);
    /**
     * @stability stable
     */
    resetTargetFormat(): void;
    /**
     * @stability stable
     */
    get targetFormatInput(): string | undefined;
    private _targetType?;
    /**
     * @stability stable
     */
    get targetType(): string;
    /**
     * @stability stable
     */
    set targetType(value: string);
    /**
     * @stability stable
     */
    get targetTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorCategoryProcessorCategoryFilter {
    /**
     * Filter criteria of the category.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#query LogsCustomPipeline#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorCategoryProcessorCategoryFilterOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorCategoryProcessorCategory {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#filter LogsCustomPipeline#filter}
     *
     * @stability stable
     */
    readonly filter: LogsCustomPipelineProcessorCategoryProcessorCategoryFilter;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorCategoryProcessor {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the category.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Name of the target attribute whose value is defined by the matching category.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * category block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#category LogsCustomPipeline#category}
     *
     * @stability stable
     */
    readonly category: LogsCustomPipelineProcessorCategoryProcessorCategory[];
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorCategoryProcessorOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
    private _category?;
    /**
     * @stability stable
     */
    get category(): LogsCustomPipelineProcessorCategoryProcessorCategory[];
    /**
     * @stability stable
     */
    set category(value: LogsCustomPipelineProcessorCategoryProcessorCategory[]);
    /**
     * @stability stable
     */
    get categoryInput(): LogsCustomPipelineProcessorCategoryProcessorCategory[] | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorDateRemapper {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorDateRemapperOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorGeoIpParser {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
    /**
     * Name of the parent attribute that contains all the extracted details from the sources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorGeoIpParserOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorGrokParserGrok {
    /**
     * Match rules for your grok parser.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#match_rules LogsCustomPipeline#match_rules}
     *
     * @stability stable
     */
    readonly matchRules: string;
    /**
     * Support rules for your grok parser.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#support_rules LogsCustomPipeline#support_rules}
     *
     * @stability stable
     */
    readonly supportRules: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorGrokParserGrokOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _matchRules?;
    /**
     * @stability stable
     */
    get matchRules(): string;
    /**
     * @stability stable
     */
    set matchRules(value: string);
    /**
     * @stability stable
     */
    get matchRulesInput(): string | undefined;
    private _supportRules?;
    /**
     * @stability stable
     */
    get supportRules(): string;
    /**
     * @stability stable
     */
    set supportRules(value: string);
    /**
     * @stability stable
     */
    get supportRulesInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorGrokParser {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of sample logs for this parser.
     *
     * It can save up to 5 samples. Each sample takes up to 5000 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#samples LogsCustomPipeline#samples}
     *
     * @stability stable
     */
    readonly samples?: string[];
    /**
     * Name of the log attribute to parse.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#source LogsCustomPipeline#source}
     *
     * @stability stable
     */
    readonly source: string;
    /**
     * grok block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#grok LogsCustomPipeline#grok}
     *
     * @stability stable
     */
    readonly grok: LogsCustomPipelineProcessorGrokParserGrok;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorGrokParserOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _samples?;
    /**
     * @stability stable
     */
    get samples(): string[] | undefined;
    /**
     * @stability stable
     */
    set samples(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSamples(): void;
    /**
     * @stability stable
     */
    get samplesInput(): string[] | undefined;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    set source(value: string);
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    private _grok?;
    private __grokOutput;
    /**
     * @stability stable
     */
    get grok(): LogsCustomPipelineProcessorGrokParserGrokOutputReference;
    /**
     * @stability stable
     */
    putGrok(value: LogsCustomPipelineProcessorGrokParserGrok): void;
    /**
     * @stability stable
     */
    get grokInput(): LogsCustomPipelineProcessorGrokParserGrok | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorLookupProcessor {
    /**
     * Default lookup value to use if there is no entry in the lookup table for the value of the source attribute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#default_lookup LogsCustomPipeline#default_lookup}
     *
     * @stability stable
     */
    readonly defaultLookup?: string;
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * List of entries of the lookup table using `key,value` format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#lookup_table LogsCustomPipeline#lookup_table}
     *
     * @stability stable
     */
    readonly lookupTable: string[];
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Name of the source attribute used to do the lookup.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#source LogsCustomPipeline#source}
     *
     * @stability stable
     */
    readonly source: string;
    /**
     * Name of the attribute that contains the result of the lookup.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorLookupProcessorOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _defaultLookup?;
    /**
     * @stability stable
     */
    get defaultLookup(): string | undefined;
    /**
     * @stability stable
     */
    set defaultLookup(value: string | undefined);
    /**
     * @stability stable
     */
    resetDefaultLookup(): void;
    /**
     * @stability stable
     */
    get defaultLookupInput(): string | undefined;
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _lookupTable?;
    /**
     * @stability stable
     */
    get lookupTable(): string[];
    /**
     * @stability stable
     */
    set lookupTable(value: string[]);
    /**
     * @stability stable
     */
    get lookupTableInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    set source(value: string);
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorMessageRemapper {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorMessageRemapperOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineFilter {
    /**
     * Filter criteria of the category.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#query LogsCustomPipeline#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorArithmeticProcessor {
    /**
     * Arithmetic operation between one or more log attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#expression LogsCustomPipeline#expression}
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Boolean value to enable your pipeline.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * If true, it replaces all missing attributes of expression by 0, false skips the operation if an attribute is missing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_replace_missing LogsCustomPipeline#is_replace_missing}
     *
     * @stability stable
     */
    readonly isReplaceMissing?: boolean | cdktf.IResolvable;
    /**
     * Your pipeline name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Name of the attribute that contains the result of the arithmetic operation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorArithmeticProcessorOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isReplaceMissing?;
    /**
     * @stability stable
     */
    get isReplaceMissing(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isReplaceMissing(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsReplaceMissing(): void;
    /**
     * @stability stable
     */
    get isReplaceMissingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorAttributeRemapper {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Override the target element if already set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#override_on_conflict LogsCustomPipeline#override_on_conflict}
     *
     * @stability stable
     */
    readonly overrideOnConflict?: boolean | cdktf.IResolvable;
    /**
     * Remove or preserve the remapped source element.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#preserve_source LogsCustomPipeline#preserve_source}
     *
     * @stability stable
     */
    readonly preserveSource?: boolean | cdktf.IResolvable;
    /**
     * Defines where the sources are from (log `attribute` or `tag`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#source_type LogsCustomPipeline#source_type}
     *
     * @stability stable
     */
    readonly sourceType: string;
    /**
     * List of source attributes or tags.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
    /**
     * Final attribute or tag name to remap the sources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * If the `target_type` of the remapper is `attribute`, try to cast the value to a new specific type.
     *
     * If the cast is not possible, the original type is kept. `string`, `integer`, or `double` are the possible types. If the `target_type` is `tag`, this parameter may not be specified.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target_format LogsCustomPipeline#target_format}
     *
     * @stability stable
     */
    readonly targetFormat?: string;
    /**
     * Defines if the target is a log `attribute` or `tag`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target_type LogsCustomPipeline#target_type}
     *
     * @stability stable
     */
    readonly targetType: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorAttributeRemapperOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _overrideOnConflict?;
    /**
     * @stability stable
     */
    get overrideOnConflict(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set overrideOnConflict(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetOverrideOnConflict(): void;
    /**
     * @stability stable
     */
    get overrideOnConflictInput(): boolean | cdktf.IResolvable | undefined;
    private _preserveSource?;
    /**
     * @stability stable
     */
    get preserveSource(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set preserveSource(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetPreserveSource(): void;
    /**
     * @stability stable
     */
    get preserveSourceInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceType?;
    /**
     * @stability stable
     */
    get sourceType(): string;
    /**
     * @stability stable
     */
    set sourceType(value: string);
    /**
     * @stability stable
     */
    get sourceTypeInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
    private _targetFormat?;
    /**
     * @stability stable
     */
    get targetFormat(): string | undefined;
    /**
     * @stability stable
     */
    set targetFormat(value: string | undefined);
    /**
     * @stability stable
     */
    resetTargetFormat(): void;
    /**
     * @stability stable
     */
    get targetFormatInput(): string | undefined;
    private _targetType?;
    /**
     * @stability stable
     */
    get targetType(): string;
    /**
     * @stability stable
     */
    set targetType(value: string);
    /**
     * @stability stable
     */
    get targetTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilter {
    /**
     * Filter criteria of the category.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#query LogsCustomPipeline#query}
     *
     * @stability stable
     */
    readonly query: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilterOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategory {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#filter LogsCustomPipeline#filter}
     *
     * @stability stable
     */
    readonly filter: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategoryFilter;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorCategoryProcessor {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the category.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Name of the target attribute whose value is defined by the matching category.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * category block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#category LogsCustomPipeline#category}
     *
     * @stability stable
     */
    readonly category: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategory[];
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
    private _category?;
    /**
     * @stability stable
     */
    get category(): LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategory[];
    /**
     * @stability stable
     */
    set category(value: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategory[]);
    /**
     * @stability stable
     */
    get categoryInput(): LogsCustomPipelineProcessorPipelineProcessorCategoryProcessorCategory[] | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorDateRemapper {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorDateRemapperOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorGeoIpParser {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
    /**
     * Name of the parent attribute that contains all the extracted details from the sources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorGeoIpParserOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorGrokParserGrok {
    /**
     * Match rules for your grok parser.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#match_rules LogsCustomPipeline#match_rules}
     *
     * @stability stable
     */
    readonly matchRules: string;
    /**
     * Support rules for your grok parser.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#support_rules LogsCustomPipeline#support_rules}
     *
     * @stability stable
     */
    readonly supportRules: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorGrokParserGrokOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _matchRules?;
    /**
     * @stability stable
     */
    get matchRules(): string;
    /**
     * @stability stable
     */
    set matchRules(value: string);
    /**
     * @stability stable
     */
    get matchRulesInput(): string | undefined;
    private _supportRules?;
    /**
     * @stability stable
     */
    get supportRules(): string;
    /**
     * @stability stable
     */
    set supportRules(value: string);
    /**
     * @stability stable
     */
    get supportRulesInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorGrokParser {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of sample logs for this parser.
     *
     * It can save up to 5 samples. Each sample takes up to 5000 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#samples LogsCustomPipeline#samples}
     *
     * @stability stable
     */
    readonly samples?: string[];
    /**
     * Name of the log attribute to parse.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#source LogsCustomPipeline#source}
     *
     * @stability stable
     */
    readonly source: string;
    /**
     * grok block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#grok LogsCustomPipeline#grok}
     *
     * @stability stable
     */
    readonly grok: LogsCustomPipelineProcessorPipelineProcessorGrokParserGrok;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorGrokParserOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _samples?;
    /**
     * @stability stable
     */
    get samples(): string[] | undefined;
    /**
     * @stability stable
     */
    set samples(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSamples(): void;
    /**
     * @stability stable
     */
    get samplesInput(): string[] | undefined;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    set source(value: string);
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    private _grok?;
    private __grokOutput;
    /**
     * @stability stable
     */
    get grok(): LogsCustomPipelineProcessorPipelineProcessorGrokParserGrokOutputReference;
    /**
     * @stability stable
     */
    putGrok(value: LogsCustomPipelineProcessorPipelineProcessorGrokParserGrok): void;
    /**
     * @stability stable
     */
    get grokInput(): LogsCustomPipelineProcessorPipelineProcessorGrokParserGrok | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorLookupProcessor {
    /**
     * Default lookup value to use if there is no entry in the lookup table for the value of the source attribute.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#default_lookup LogsCustomPipeline#default_lookup}
     *
     * @stability stable
     */
    readonly defaultLookup?: string;
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * List of entries of the lookup table using `key,value` format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#lookup_table LogsCustomPipeline#lookup_table}
     *
     * @stability stable
     */
    readonly lookupTable: string[];
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Name of the source attribute used to do the lookup.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#source LogsCustomPipeline#source}
     *
     * @stability stable
     */
    readonly source: string;
    /**
     * Name of the attribute that contains the result of the lookup.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorLookupProcessorOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _defaultLookup?;
    /**
     * @stability stable
     */
    get defaultLookup(): string | undefined;
    /**
     * @stability stable
     */
    set defaultLookup(value: string | undefined);
    /**
     * @stability stable
     */
    resetDefaultLookup(): void;
    /**
     * @stability stable
     */
    get defaultLookupInput(): string | undefined;
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _lookupTable?;
    /**
     * @stability stable
     */
    get lookupTable(): string[];
    /**
     * @stability stable
     */
    set lookupTable(value: string[]);
    /**
     * @stability stable
     */
    get lookupTableInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _source?;
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    set source(value: string);
    /**
     * @stability stable
     */
    get sourceInput(): string | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorMessageRemapper {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorMessageRemapperOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorServiceRemapper {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorServiceRemapperOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorStatusRemapper {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorStatusRemapperOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorStringBuilderProcessor {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * If it replaces all missing attributes of template by an empty string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_replace_missing LogsCustomPipeline#is_replace_missing}
     *
     * @stability stable
     */
    readonly isReplaceMissing?: boolean | cdktf.IResolvable;
    /**
     * The name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * The name of the attribute that contains the result of the template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * The formula with one or more attributes and raw text.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#template LogsCustomPipeline#template}
     *
     * @stability stable
     */
    readonly template: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorStringBuilderProcessorOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isReplaceMissing?;
    /**
     * @stability stable
     */
    get isReplaceMissing(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isReplaceMissing(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsReplaceMissing(): void;
    /**
     * @stability stable
     */
    get isReplaceMissingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
    private _template?;
    /**
     * @stability stable
     */
    get template(): string;
    /**
     * @stability stable
     */
    set template(value: string);
    /**
     * @stability stable
     */
    get templateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorTraceIdRemapper {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorTraceIdRemapperOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorUrlParser {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Normalize the ending slashes or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#normalize_ending_slashes LogsCustomPipeline#normalize_ending_slashes}
     *
     * @stability stable
     */
    readonly normalizeEndingSlashes?: boolean | cdktf.IResolvable;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
    /**
     * Name of the parent attribute that contains all the extracted details from the sources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorUrlParserOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _normalizeEndingSlashes?;
    /**
     * @stability stable
     */
    get normalizeEndingSlashes(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set normalizeEndingSlashes(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetNormalizeEndingSlashes(): void;
    /**
     * @stability stable
     */
    get normalizeEndingSlashesInput(): boolean | cdktf.IResolvable | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessorUserAgentParser {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * If the source attribute is URL encoded or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_encoded LogsCustomPipeline#is_encoded}
     *
     * @stability stable
     */
    readonly isEncoded?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
    /**
     * Name of the parent attribute that contains all the extracted details from the sources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineProcessorUserAgentParserOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isEncoded?;
    /**
     * @stability stable
     */
    get isEncoded(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEncoded(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEncoded(): void;
    /**
     * @stability stable
     */
    get isEncodedInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipelineProcessor {
    /**
     * arithmetic_processor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#arithmetic_processor LogsCustomPipeline#arithmetic_processor}
     *
     * @stability stable
     */
    readonly arithmeticProcessor?: LogsCustomPipelineProcessorPipelineProcessorArithmeticProcessor;
    /**
     * attribute_remapper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#attribute_remapper LogsCustomPipeline#attribute_remapper}
     *
     * @stability stable
     */
    readonly attributeRemapper?: LogsCustomPipelineProcessorPipelineProcessorAttributeRemapper;
    /**
     * category_processor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#category_processor LogsCustomPipeline#category_processor}
     *
     * @stability stable
     */
    readonly categoryProcessor?: LogsCustomPipelineProcessorPipelineProcessorCategoryProcessor;
    /**
     * date_remapper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#date_remapper LogsCustomPipeline#date_remapper}
     *
     * @stability stable
     */
    readonly dateRemapper?: LogsCustomPipelineProcessorPipelineProcessorDateRemapper;
    /**
     * geo_ip_parser block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#geo_ip_parser LogsCustomPipeline#geo_ip_parser}
     *
     * @stability stable
     */
    readonly geoIpParser?: LogsCustomPipelineProcessorPipelineProcessorGeoIpParser;
    /**
     * grok_parser block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#grok_parser LogsCustomPipeline#grok_parser}
     *
     * @stability stable
     */
    readonly grokParser?: LogsCustomPipelineProcessorPipelineProcessorGrokParser;
    /**
     * lookup_processor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#lookup_processor LogsCustomPipeline#lookup_processor}
     *
     * @stability stable
     */
    readonly lookupProcessor?: LogsCustomPipelineProcessorPipelineProcessorLookupProcessor;
    /**
     * message_remapper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#message_remapper LogsCustomPipeline#message_remapper}
     *
     * @stability stable
     */
    readonly messageRemapper?: LogsCustomPipelineProcessorPipelineProcessorMessageRemapper;
    /**
     * service_remapper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#service_remapper LogsCustomPipeline#service_remapper}
     *
     * @stability stable
     */
    readonly serviceRemapper?: LogsCustomPipelineProcessorPipelineProcessorServiceRemapper;
    /**
     * status_remapper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#status_remapper LogsCustomPipeline#status_remapper}
     *
     * @stability stable
     */
    readonly statusRemapper?: LogsCustomPipelineProcessorPipelineProcessorStatusRemapper;
    /**
     * string_builder_processor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#string_builder_processor LogsCustomPipeline#string_builder_processor}
     *
     * @stability stable
     */
    readonly stringBuilderProcessor?: LogsCustomPipelineProcessorPipelineProcessorStringBuilderProcessor;
    /**
     * trace_id_remapper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#trace_id_remapper LogsCustomPipeline#trace_id_remapper}
     *
     * @stability stable
     */
    readonly traceIdRemapper?: LogsCustomPipelineProcessorPipelineProcessorTraceIdRemapper;
    /**
     * url_parser block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#url_parser LogsCustomPipeline#url_parser}
     *
     * @stability stable
     */
    readonly urlParser?: LogsCustomPipelineProcessorPipelineProcessorUrlParser;
    /**
     * user_agent_parser block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#user_agent_parser LogsCustomPipeline#user_agent_parser}
     *
     * @stability stable
     */
    readonly userAgentParser?: LogsCustomPipelineProcessorPipelineProcessorUserAgentParser;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorPipeline {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}.
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#filter LogsCustomPipeline#filter}
     *
     * @stability stable
     */
    readonly filter: LogsCustomPipelineProcessorPipelineFilter[];
    /**
     * processor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#processor LogsCustomPipeline#processor}
     *
     * @stability stable
     */
    readonly processor?: LogsCustomPipelineProcessorPipelineProcessor[];
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorPipelineOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): LogsCustomPipelineProcessorPipelineFilter[];
    /**
     * @stability stable
     */
    set filter(value: LogsCustomPipelineProcessorPipelineFilter[]);
    /**
     * @stability stable
     */
    get filterInput(): LogsCustomPipelineProcessorPipelineFilter[] | undefined;
    private _processor?;
    /**
     * @stability stable
     */
    get processor(): LogsCustomPipelineProcessorPipelineProcessor[] | undefined;
    /**
     * @stability stable
     */
    set processor(value: LogsCustomPipelineProcessorPipelineProcessor[] | undefined);
    /**
     * @stability stable
     */
    resetProcessor(): void;
    /**
     * @stability stable
     */
    get processorInput(): LogsCustomPipelineProcessorPipelineProcessor[] | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorServiceRemapper {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorServiceRemapperOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorStatusRemapper {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorStatusRemapperOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorStringBuilderProcessor {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * If it replaces all missing attributes of template by an empty string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_replace_missing LogsCustomPipeline#is_replace_missing}
     *
     * @stability stable
     */
    readonly isReplaceMissing?: boolean | cdktf.IResolvable;
    /**
     * The name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * The name of the attribute that contains the result of the template.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * The formula with one or more attributes and raw text.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#template LogsCustomPipeline#template}
     *
     * @stability stable
     */
    readonly template: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorStringBuilderProcessorOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isReplaceMissing?;
    /**
     * @stability stable
     */
    get isReplaceMissing(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isReplaceMissing(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsReplaceMissing(): void;
    /**
     * @stability stable
     */
    get isReplaceMissingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
    private _template?;
    /**
     * @stability stable
     */
    get template(): string;
    /**
     * @stability stable
     */
    set template(value: string);
    /**
     * @stability stable
     */
    get templateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorTraceIdRemapper {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorTraceIdRemapperOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorUrlParser {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Normalize the ending slashes or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#normalize_ending_slashes LogsCustomPipeline#normalize_ending_slashes}
     *
     * @stability stable
     */
    readonly normalizeEndingSlashes?: boolean | cdktf.IResolvable;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
    /**
     * Name of the parent attribute that contains all the extracted details from the sources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorUrlParserOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _normalizeEndingSlashes?;
    /**
     * @stability stable
     */
    get normalizeEndingSlashes(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set normalizeEndingSlashes(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetNormalizeEndingSlashes(): void;
    /**
     * @stability stable
     */
    get normalizeEndingSlashesInput(): boolean | cdktf.IResolvable | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessorUserAgentParser {
    /**
     * If the processor is enabled or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_enabled LogsCustomPipeline#is_enabled}
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * If the source attribute is URL encoded or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#is_encoded LogsCustomPipeline#is_encoded}
     *
     * @stability stable
     */
    readonly isEncoded?: boolean | cdktf.IResolvable;
    /**
     * Name of the processor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#name LogsCustomPipeline#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * List of source attributes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#sources LogsCustomPipeline#sources}
     *
     * @stability stable
     */
    readonly sources: string[];
    /**
     * Name of the parent attribute that contains all the extracted details from the sources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#target LogsCustomPipeline#target}
     *
     * @stability stable
     */
    readonly target: string;
}
/**
 * @stability stable
 */
export declare class LogsCustomPipelineProcessorUserAgentParserOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _isEncoded?;
    /**
     * @stability stable
     */
    get isEncoded(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEncoded(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEncoded(): void;
    /**
     * @stability stable
     */
    get isEncodedInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): string[];
    /**
     * @stability stable
     */
    set sources(value: string[]);
    /**
     * @stability stable
     */
    get sourcesInput(): string[] | undefined;
    private _target?;
    /**
     * @stability stable
     */
    get target(): string;
    /**
     * @stability stable
     */
    set target(value: string);
    /**
     * @stability stable
     */
    get targetInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface LogsCustomPipelineProcessor {
    /**
     * arithmetic_processor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#arithmetic_processor LogsCustomPipeline#arithmetic_processor}
     *
     * @stability stable
     */
    readonly arithmeticProcessor?: LogsCustomPipelineProcessorArithmeticProcessor;
    /**
     * attribute_remapper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#attribute_remapper LogsCustomPipeline#attribute_remapper}
     *
     * @stability stable
     */
    readonly attributeRemapper?: LogsCustomPipelineProcessorAttributeRemapper;
    /**
     * category_processor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#category_processor LogsCustomPipeline#category_processor}
     *
     * @stability stable
     */
    readonly categoryProcessor?: LogsCustomPipelineProcessorCategoryProcessor;
    /**
     * date_remapper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#date_remapper LogsCustomPipeline#date_remapper}
     *
     * @stability stable
     */
    readonly dateRemapper?: LogsCustomPipelineProcessorDateRemapper;
    /**
     * geo_ip_parser block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#geo_ip_parser LogsCustomPipeline#geo_ip_parser}
     *
     * @stability stable
     */
    readonly geoIpParser?: LogsCustomPipelineProcessorGeoIpParser;
    /**
     * grok_parser block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#grok_parser LogsCustomPipeline#grok_parser}
     *
     * @stability stable
     */
    readonly grokParser?: LogsCustomPipelineProcessorGrokParser;
    /**
     * lookup_processor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#lookup_processor LogsCustomPipeline#lookup_processor}
     *
     * @stability stable
     */
    readonly lookupProcessor?: LogsCustomPipelineProcessorLookupProcessor;
    /**
     * message_remapper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#message_remapper LogsCustomPipeline#message_remapper}
     *
     * @stability stable
     */
    readonly messageRemapper?: LogsCustomPipelineProcessorMessageRemapper;
    /**
     * pipeline block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#pipeline LogsCustomPipeline#pipeline}
     *
     * @stability stable
     */
    readonly pipeline?: LogsCustomPipelineProcessorPipeline;
    /**
     * service_remapper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#service_remapper LogsCustomPipeline#service_remapper}
     *
     * @stability stable
     */
    readonly serviceRemapper?: LogsCustomPipelineProcessorServiceRemapper;
    /**
     * status_remapper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#status_remapper LogsCustomPipeline#status_remapper}
     *
     * @stability stable
     */
    readonly statusRemapper?: LogsCustomPipelineProcessorStatusRemapper;
    /**
     * string_builder_processor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#string_builder_processor LogsCustomPipeline#string_builder_processor}
     *
     * @stability stable
     */
    readonly stringBuilderProcessor?: LogsCustomPipelineProcessorStringBuilderProcessor;
    /**
     * trace_id_remapper block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#trace_id_remapper LogsCustomPipeline#trace_id_remapper}
     *
     * @stability stable
     */
    readonly traceIdRemapper?: LogsCustomPipelineProcessorTraceIdRemapper;
    /**
     * url_parser block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#url_parser LogsCustomPipeline#url_parser}
     *
     * @stability stable
     */
    readonly urlParser?: LogsCustomPipelineProcessorUrlParser;
    /**
     * user_agent_parser block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html#user_agent_parser LogsCustomPipeline#user_agent_parser}
     *
     * @stability stable
     */
    readonly userAgentParser?: LogsCustomPipelineProcessorUserAgentParser;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html datadog_logs_custom_pipeline}.
 *
 * @stability stable
 */
export declare class LogsCustomPipeline extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/logs_custom_pipeline.html datadog_logs_custom_pipeline} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LogsCustomPipelineConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): LogsCustomPipelineFilter[];
    /**
     * @stability stable
     */
    set filter(value: LogsCustomPipelineFilter[]);
    /**
     * @stability stable
     */
    get filterInput(): LogsCustomPipelineFilter[] | undefined;
    private _processor?;
    /**
     * @stability stable
     */
    get processor(): LogsCustomPipelineProcessor[] | undefined;
    /**
     * @stability stable
     */
    set processor(value: LogsCustomPipelineProcessor[] | undefined);
    /**
     * @stability stable
     */
    resetProcessor(): void;
    /**
     * @stability stable
     */
    get processorInput(): LogsCustomPipelineProcessor[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
