import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SyntheticsTestConfig extends cdktf.TerraformMetaArguments {
    /**
     * Required if `type = "browser"`.
     *
     * Array with the different device IDs used to run the test. Valid values are `laptop_large`, `tablet`, `mobile_small`, `chrome.laptop_large`, `chrome.tablet`, `chrome.mobile_small`, `firefox.laptop_large`, `firefox.tablet`, `firefox.mobile_small`, `edge.laptop_large`, `edge.tablet`, `edge.mobile_small`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#device_ids SyntheticsTest#device_ids}
     *
     * @stability stable
     */
    readonly deviceIds?: string[];
    /**
     * Array of locations used to run the test. Refer to [Datadog documentation](https://docs.datadoghq.com/synthetics/api_test/#request) for available locations (e.g. `aws:eu-central-1`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#locations SyntheticsTest#locations}
     *
     * @stability stable
     */
    readonly locations: string[];
    /**
     * A message to include with notifications for this synthetics test.
     *
     * Email notifications can be sent to specific users by using the same `@username` notation as events.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#message SyntheticsTest#message}
     *
     * @stability stable
     */
    readonly message?: string;
    /**
     * Name of Datadog synthetics test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#name SyntheticsTest#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Header name and value map.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#request_headers SyntheticsTest#request_headers}
     *
     * @stability stable
     */
    readonly requestHeaders?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Query arguments name and value map.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#request_query SyntheticsTest#request_query}
     *
     * @stability stable
     */
    readonly requestQuery?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Cookies to be used for a browser test request, using the [Set-Cookie](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#set_cookie SyntheticsTest#set_cookie}
     *
     * @stability stable
     */
    readonly setCookie?: string;
    /**
     * Define whether you want to start (`live`) or pause (`paused`) a Synthetic test. Valid values are `live`, `paused`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#status SyntheticsTest#status}
     *
     * @stability stable
     */
    readonly status: string;
    /**
     * The subtype of the Synthetic API test. Defaults to `http`. Valid values are `http`, `ssl`, `tcp`, `dns`, `multi`, `icmp`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#subtype SyntheticsTest#subtype}
     *
     * @stability stable
     */
    readonly subtype?: string;
    /**
     * A list of tags to associate with your synthetics test.
     *
     * This can help you categorize and filter tests in the manage synthetics page of the UI. Default is an empty list (`[]`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#tags SyntheticsTest#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * Synthetics test type. Valid values are `api`, `browser`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * api_step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#api_step SyntheticsTest#api_step}
     *
     * @stability stable
     */
    readonly apiStep?: SyntheticsTestApiStep[];
    /**
     * assertion block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#assertion SyntheticsTest#assertion}
     *
     * @stability stable
     */
    readonly assertion?: SyntheticsTestAssertion[];
    /**
     * browser_step block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#browser_step SyntheticsTest#browser_step}
     *
     * @stability stable
     */
    readonly browserStep?: SyntheticsTestBrowserStep[];
    /**
     * browser_variable block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#browser_variable SyntheticsTest#browser_variable}
     *
     * @stability stable
     */
    readonly browserVariable?: SyntheticsTestBrowserVariable[];
    /**
     * config_variable block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#config_variable SyntheticsTest#config_variable}
     *
     * @stability stable
     */
    readonly configVariable?: SyntheticsTestConfigVariable[];
    /**
     * options_list block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#options_list SyntheticsTest#options_list}
     *
     * @stability stable
     */
    readonly optionsList?: SyntheticsTestOptionsList;
    /**
     * request_basicauth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#request_basicauth SyntheticsTest#request_basicauth}
     *
     * @stability stable
     */
    readonly requestBasicauth?: SyntheticsTestRequestBasicauth;
    /**
     * request_client_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#request_client_certificate SyntheticsTest#request_client_certificate}
     *
     * @stability stable
     */
    readonly requestClientCertificate?: SyntheticsTestRequestClientCertificate;
    /**
     * request_definition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#request_definition SyntheticsTest#request_definition}
     *
     * @stability stable
     */
    readonly requestDefinition?: SyntheticsTestRequestDefinition;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepAssertionTargetjsonpath {
    /**
     * The JSON path to assert.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#jsonpath SyntheticsTest#jsonpath}
     *
     * @stability stable
     */
    readonly jsonpath: string;
    /**
     * The specific operator to use on the path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#operator SyntheticsTest#operator}
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Expected matching value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#targetvalue SyntheticsTest#targetvalue}
     *
     * @stability stable
     */
    readonly targetvalue: string;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepAssertionTargetjsonpathOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _jsonpath?;
    /**
     * @stability stable
     */
    get jsonpath(): string;
    /**
     * @stability stable
     */
    set jsonpath(value: string);
    /**
     * @stability stable
     */
    get jsonpathInput(): string | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _targetvalue?;
    /**
     * @stability stable
     */
    get targetvalue(): string;
    /**
     * @stability stable
     */
    set targetvalue(value: string);
    /**
     * @stability stable
     */
    get targetvalueInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepAssertion {
    /**
     * Assertion operator. **Note** Only some combinations of `type` and `operator` are valid (please refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#operator SyntheticsTest#operator}
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * If assertion type is `header`, this is the header name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#property SyntheticsTest#property}
     *
     * @stability stable
     */
    readonly property?: string;
    /**
     * Expected value. Depends on the assertion type, refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test) for details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#target SyntheticsTest#target}
     *
     * @stability stable
     */
    readonly target?: string;
    /**
     * Type of assertion.
     *
     * **Note** Only some combinations of `type` and `operator` are valid (please refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test)). Valid values are `body`, `header`, `statusCode`, `certificate`, `responseTime`, `property`, `recordEvery`, `recordSome`, `tlsVersion`, `minTlsVersion`, `latency`, `packetLossPercentage`, `packetsReceived`, `networkHop`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * targetjsonpath block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#targetjsonpath SyntheticsTest#targetjsonpath}
     *
     * @stability stable
     */
    readonly targetjsonpath?: SyntheticsTestApiStepAssertionTargetjsonpath;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepExtractedValueParser {
    /**
     * Type of parser for a Synthetics global variable from a synthetics test. Valid values are `raw`, `json_path`, `regex`, `x_path`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Regex or JSON path used for the parser. Not used with type `raw`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#value SyntheticsTest#value}
     *
     * @stability stable
     */
    readonly value?: string;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepExtractedValueParserOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string | undefined;
    /**
     * @stability stable
     */
    set value(value: string | undefined);
    /**
     * @stability stable
     */
    resetValue(): void;
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepExtractedValue {
    /**
     * When type is `http_header`, name of the header to use to extract the value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#field SyntheticsTest#field}
     *
     * @stability stable
     */
    readonly field?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#name SyntheticsTest#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Property of the Synthetics Test Response to use for the variable. Valid values are `http_body`, `http_header`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * parser block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#parser SyntheticsTest#parser}
     *
     * @stability stable
     */
    readonly parser: SyntheticsTestApiStepExtractedValueParser;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepRequestBasicauth {
    /**
     * Password for authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#password SyntheticsTest#password}
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Username for authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#username SyntheticsTest#username}
     *
     * @stability stable
     */
    readonly username: string;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepRequestBasicauthOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepRequestClientCertificateCert {
    /**
     * Content of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#content SyntheticsTest#content}
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * File name for the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#filename SyntheticsTest#filename}
     *
     * @stability stable
     */
    readonly filename?: string;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepRequestClientCertificateCertOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string | undefined;
    /**
     * @stability stable
     */
    set filename(value: string | undefined);
    /**
     * @stability stable
     */
    resetFilename(): void;
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepRequestClientCertificateKey {
    /**
     * Content of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#content SyntheticsTest#content}
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * File name for the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#filename SyntheticsTest#filename}
     *
     * @stability stable
     */
    readonly filename?: string;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepRequestClientCertificateKeyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string | undefined;
    /**
     * @stability stable
     */
    set filename(value: string | undefined);
    /**
     * @stability stable
     */
    resetFilename(): void;
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepRequestClientCertificate {
    /**
     * cert block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#cert SyntheticsTest#cert}
     *
     * @stability stable
     */
    readonly cert: SyntheticsTestApiStepRequestClientCertificateCert;
    /**
     * key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#key SyntheticsTest#key}
     *
     * @stability stable
     */
    readonly key: SyntheticsTestApiStepRequestClientCertificateKey;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepRequestClientCertificateOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cert?;
    private __certOutput;
    /**
     * @stability stable
     */
    get cert(): SyntheticsTestApiStepRequestClientCertificateCertOutputReference;
    /**
     * @stability stable
     */
    putCert(value: SyntheticsTestApiStepRequestClientCertificateCert): void;
    /**
     * @stability stable
     */
    get certInput(): SyntheticsTestApiStepRequestClientCertificateCert | undefined;
    private _key?;
    private __keyOutput;
    /**
     * @stability stable
     */
    get key(): SyntheticsTestApiStepRequestClientCertificateKeyOutputReference;
    /**
     * @stability stable
     */
    putKey(value: SyntheticsTestApiStepRequestClientCertificateKey): void;
    /**
     * @stability stable
     */
    get keyInput(): SyntheticsTestApiStepRequestClientCertificateKey | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStepRequestDefinition {
    /**
     * Allows loading insecure content for an HTTP test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#allow_insecure SyntheticsTest#allow_insecure}
     *
     * @stability stable
     */
    readonly allowInsecure?: boolean | cdktf.IResolvable;
    /**
     * The request body.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#body SyntheticsTest#body}
     *
     * @stability stable
     */
    readonly body?: string;
    /**
     * DNS server to use for DNS tests (`subtype = "dns"`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#dns_server SyntheticsTest#dns_server}
     *
     * @stability stable
     */
    readonly dnsServer?: string;
    /**
     * DNS server port to use for DNS tests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#dns_server_port SyntheticsTest#dns_server_port}
     *
     * @stability stable
     */
    readonly dnsServerPort?: number;
    /**
     * Determines whether or not the API HTTP test should follow redirects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#follow_redirects SyntheticsTest#follow_redirects}
     *
     * @stability stable
     */
    readonly followRedirects?: boolean | cdktf.IResolvable;
    /**
     * Host name to perform the test with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#host SyntheticsTest#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * The HTTP method. Valid values are `GET`, `POST`, `PATCH`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#method SyntheticsTest#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Determines whether or not to save the response body.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#no_saving_response_body SyntheticsTest#no_saving_response_body}
     *
     * @stability stable
     */
    readonly noSavingResponseBody?: boolean | cdktf.IResolvable;
    /**
     * Number of pings to use per test for ICMP tests (`subtype = "icmp"`) between 0 and 10.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#number_of_packets SyntheticsTest#number_of_packets}
     *
     * @stability stable
     */
    readonly numberOfPackets?: number;
    /**
     * Port to use when performing the test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#port SyntheticsTest#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * For SSL tests, it specifies on which server you want to initiate the TLS handshake, allowing the server to present one of multiple possible certificates on the same IP address and TCP port number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#servername SyntheticsTest#servername}
     *
     * @stability stable
     */
    readonly servername?: string;
    /**
     * This will turn on a traceroute probe to discover all gateways along the path to the host destination.
     *
     * For ICMP tests (`subtype = "icmp"`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#should_track_hops SyntheticsTest#should_track_hops}
     *
     * @stability stable
     */
    readonly shouldTrackHops?: boolean | cdktf.IResolvable;
    /**
     * Timeout in seconds for the test. Defaults to `60`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#timeout SyntheticsTest#timeout}
     *
     * @stability stable
     */
    readonly timeout?: number;
    /**
     * The URL to send the request to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#url SyntheticsTest#url}
     *
     * @stability stable
     */
    readonly url?: string;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestApiStepRequestDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _allowInsecure?;
    /**
     * @stability stable
     */
    get allowInsecure(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set allowInsecure(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAllowInsecure(): void;
    /**
     * @stability stable
     */
    get allowInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _body?;
    /**
     * @stability stable
     */
    get body(): string | undefined;
    /**
     * @stability stable
     */
    set body(value: string | undefined);
    /**
     * @stability stable
     */
    resetBody(): void;
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    private _dnsServer?;
    /**
     * @stability stable
     */
    get dnsServer(): string | undefined;
    /**
     * @stability stable
     */
    set dnsServer(value: string | undefined);
    /**
     * @stability stable
     */
    resetDnsServer(): void;
    /**
     * @stability stable
     */
    get dnsServerInput(): string | undefined;
    private _dnsServerPort?;
    /**
     * @stability stable
     */
    get dnsServerPort(): number | undefined;
    /**
     * @stability stable
     */
    set dnsServerPort(value: number | undefined);
    /**
     * @stability stable
     */
    resetDnsServerPort(): void;
    /**
     * @stability stable
     */
    get dnsServerPortInput(): number | undefined;
    private _followRedirects?;
    /**
     * @stability stable
     */
    get followRedirects(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set followRedirects(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetFollowRedirects(): void;
    /**
     * @stability stable
     */
    get followRedirectsInput(): boolean | cdktf.IResolvable | undefined;
    private _host?;
    /**
     * @stability stable
     */
    get host(): string | undefined;
    /**
     * @stability stable
     */
    set host(value: string | undefined);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _method?;
    /**
     * @stability stable
     */
    get method(): string | undefined;
    /**
     * @stability stable
     */
    set method(value: string | undefined);
    /**
     * @stability stable
     */
    resetMethod(): void;
    /**
     * @stability stable
     */
    get methodInput(): string | undefined;
    private _noSavingResponseBody?;
    /**
     * @stability stable
     */
    get noSavingResponseBody(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set noSavingResponseBody(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetNoSavingResponseBody(): void;
    /**
     * @stability stable
     */
    get noSavingResponseBodyInput(): boolean | cdktf.IResolvable | undefined;
    private _numberOfPackets?;
    /**
     * @stability stable
     */
    get numberOfPackets(): number | undefined;
    /**
     * @stability stable
     */
    set numberOfPackets(value: number | undefined);
    /**
     * @stability stable
     */
    resetNumberOfPackets(): void;
    /**
     * @stability stable
     */
    get numberOfPacketsInput(): number | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _servername?;
    /**
     * @stability stable
     */
    get servername(): string | undefined;
    /**
     * @stability stable
     */
    set servername(value: string | undefined);
    /**
     * @stability stable
     */
    resetServername(): void;
    /**
     * @stability stable
     */
    get servernameInput(): string | undefined;
    private _shouldTrackHops?;
    /**
     * @stability stable
     */
    get shouldTrackHops(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set shouldTrackHops(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetShouldTrackHops(): void;
    /**
     * @stability stable
     */
    get shouldTrackHopsInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): number | undefined;
    /**
     * @stability stable
     */
    set timeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): number | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string | undefined;
    /**
     * @stability stable
     */
    set url(value: string | undefined);
    /**
     * @stability stable
     */
    resetUrl(): void;
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestApiStep {
    /**
     * Determines whether or not to continue with test if this step fails.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#allow_failure SyntheticsTest#allow_failure}
     *
     * @stability stable
     */
    readonly allowFailure?: boolean | cdktf.IResolvable;
    /**
     * Determines whether or not to consider the entire test as failed if this step fails.
     *
     * Can be used only if `allow_failure` is `true`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#is_critical SyntheticsTest#is_critical}
     *
     * @stability stable
     */
    readonly isCritical?: boolean | cdktf.IResolvable;
    /**
     * The name of the step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#name SyntheticsTest#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Header name and value map.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#request_headers SyntheticsTest#request_headers}
     *
     * @stability stable
     */
    readonly requestHeaders?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Query arguments name and value map.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#request_query SyntheticsTest#request_query}
     *
     * @stability stable
     */
    readonly requestQuery?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The subtype of the Synthetic multistep API test step. Valid values are `http`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#subtype SyntheticsTest#subtype}
     *
     * @stability stable
     */
    readonly subtype?: string;
    /**
     * assertion block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#assertion SyntheticsTest#assertion}
     *
     * @stability stable
     */
    readonly assertion?: SyntheticsTestApiStepAssertion[];
    /**
     * extracted_value block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#extracted_value SyntheticsTest#extracted_value}
     *
     * @stability stable
     */
    readonly extractedValue?: SyntheticsTestApiStepExtractedValue[];
    /**
     * request_basicauth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#request_basicauth SyntheticsTest#request_basicauth}
     *
     * @stability stable
     */
    readonly requestBasicauth?: SyntheticsTestApiStepRequestBasicauth;
    /**
     * request_client_certificate block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#request_client_certificate SyntheticsTest#request_client_certificate}
     *
     * @stability stable
     */
    readonly requestClientCertificate?: SyntheticsTestApiStepRequestClientCertificate;
    /**
     * request_definition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#request_definition SyntheticsTest#request_definition}
     *
     * @stability stable
     */
    readonly requestDefinition?: SyntheticsTestApiStepRequestDefinition;
}
/**
 * @stability stable
 */
export interface SyntheticsTestAssertionTargetjsonpath {
    /**
     * The JSON path to assert.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#jsonpath SyntheticsTest#jsonpath}
     *
     * @stability stable
     */
    readonly jsonpath: string;
    /**
     * The specific operator to use on the path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#operator SyntheticsTest#operator}
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Expected matching value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#targetvalue SyntheticsTest#targetvalue}
     *
     * @stability stable
     */
    readonly targetvalue: string;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestAssertionTargetjsonpathOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _jsonpath?;
    /**
     * @stability stable
     */
    get jsonpath(): string;
    /**
     * @stability stable
     */
    set jsonpath(value: string);
    /**
     * @stability stable
     */
    get jsonpathInput(): string | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _targetvalue?;
    /**
     * @stability stable
     */
    get targetvalue(): string;
    /**
     * @stability stable
     */
    set targetvalue(value: string);
    /**
     * @stability stable
     */
    get targetvalueInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestAssertion {
    /**
     * Assertion operator. **Note** Only some combinations of `type` and `operator` are valid (please refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test)).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#operator SyntheticsTest#operator}
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * If assertion type is `header`, this is the header name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#property SyntheticsTest#property}
     *
     * @stability stable
     */
    readonly property?: string;
    /**
     * Expected value. Depends on the assertion type, refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test) for details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#target SyntheticsTest#target}
     *
     * @stability stable
     */
    readonly target?: string;
    /**
     * Type of assertion.
     *
     * **Note** Only some combinations of `type` and `operator` are valid (please refer to [Datadog documentation](https://docs.datadoghq.com/api/latest/synthetics/#create-a-test)). Valid values are `body`, `header`, `statusCode`, `certificate`, `responseTime`, `property`, `recordEvery`, `recordSome`, `tlsVersion`, `minTlsVersion`, `latency`, `packetLossPercentage`, `packetsReceived`, `networkHop`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * targetjsonpath block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#targetjsonpath SyntheticsTest#targetjsonpath}
     *
     * @stability stable
     */
    readonly targetjsonpath?: SyntheticsTestAssertionTargetjsonpath;
}
/**
 * @stability stable
 */
export interface SyntheticsTestBrowserStepParamsVariable {
    /**
     * Example of the extracted variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#example SyntheticsTest#example}
     *
     * @stability stable
     */
    readonly example?: string;
    /**
     * Name of the extracted variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#name SyntheticsTest#name}
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestBrowserStepParamsVariableOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _example?;
    /**
     * @stability stable
     */
    get example(): string | undefined;
    /**
     * @stability stable
     */
    set example(value: string | undefined);
    /**
     * @stability stable
     */
    resetExample(): void;
    /**
     * @stability stable
     */
    get exampleInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestBrowserStepParams {
    /**
     * Name of the attribute to use for an "assert attribute" step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#attribute SyntheticsTest#attribute}
     *
     * @stability stable
     */
    readonly attribute?: string;
    /**
     * Check type to use for an assertion step.
     *
     * Valid values are `equals`, `notEquals`, `contains`, `notContains`, `startsWith`, `notStartsWith`, `greater`, `lower`, `greaterEquals`, `lowerEquals`, `matchRegex`, `between`, `isEmpty`, `notIsEmpty`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#check SyntheticsTest#check}
     *
     * @stability stable
     */
    readonly check?: string;
    /**
     * Type of click to use for a "click" step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#click_type SyntheticsTest#click_type}
     *
     * @stability stable
     */
    readonly clickType?: string;
    /**
     * Javascript code to use for the step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#code SyntheticsTest#code}
     *
     * @stability stable
     */
    readonly code?: string;
    /**
     * Delay between each key stroke for a "type test" step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#delay SyntheticsTest#delay}
     *
     * @stability stable
     */
    readonly delay?: number;
    /**
     * Element to use for the step, json encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#element SyntheticsTest#element}
     *
     * @stability stable
     */
    readonly element?: string;
    /**
     * Details of the email for an "assert email" step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#email SyntheticsTest#email}
     *
     * @stability stable
     */
    readonly email?: string;
    /**
     * For an "assert download" step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#file SyntheticsTest#file}
     *
     * @stability stable
     */
    readonly file?: string;
    /**
     * Details of the files for an "upload files" step, json encoded string.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#files SyntheticsTest#files}
     *
     * @stability stable
     */
    readonly files?: string;
    /**
     * Modifier to use for a "press key" step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#modifiers SyntheticsTest#modifiers}
     *
     * @stability stable
     */
    readonly modifiers?: string[];
    /**
     * ID of the tab to play the subtest.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#playing_tab_id SyntheticsTest#playing_tab_id}
     *
     * @stability stable
     */
    readonly playingTabId?: string;
    /**
     * Request for an API step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#request SyntheticsTest#request}
     *
     * @stability stable
     */
    readonly request?: string;
    /**
     * ID of the Synthetics test to use as subtest.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#subtest_public_id SyntheticsTest#subtest_public_id}
     *
     * @stability stable
     */
    readonly subtestPublicId?: string;
    /**
     * Value of the step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#value SyntheticsTest#value}
     *
     * @stability stable
     */
    readonly value?: string;
    /**
     * For "file upload" steps.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#with_click SyntheticsTest#with_click}
     *
     * @stability stable
     */
    readonly withClick?: boolean | cdktf.IResolvable;
    /**
     * X coordinates for a "scroll step".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#x SyntheticsTest#x}
     *
     * @stability stable
     */
    readonly x?: number;
    /**
     * Y coordinates for a "scroll step".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#y SyntheticsTest#y}
     *
     * @stability stable
     */
    readonly y?: number;
    /**
     * variable block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#variable SyntheticsTest#variable}
     *
     * @stability stable
     */
    readonly variable?: SyntheticsTestBrowserStepParamsVariable;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestBrowserStepParamsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _attribute?;
    /**
     * @stability stable
     */
    get attribute(): string | undefined;
    /**
     * @stability stable
     */
    set attribute(value: string | undefined);
    /**
     * @stability stable
     */
    resetAttribute(): void;
    /**
     * @stability stable
     */
    get attributeInput(): string | undefined;
    private _check?;
    /**
     * @stability stable
     */
    get check(): string | undefined;
    /**
     * @stability stable
     */
    set check(value: string | undefined);
    /**
     * @stability stable
     */
    resetCheck(): void;
    /**
     * @stability stable
     */
    get checkInput(): string | undefined;
    private _clickType?;
    /**
     * @stability stable
     */
    get clickType(): string | undefined;
    /**
     * @stability stable
     */
    set clickType(value: string | undefined);
    /**
     * @stability stable
     */
    resetClickType(): void;
    /**
     * @stability stable
     */
    get clickTypeInput(): string | undefined;
    private _code?;
    /**
     * @stability stable
     */
    get code(): string | undefined;
    /**
     * @stability stable
     */
    set code(value: string | undefined);
    /**
     * @stability stable
     */
    resetCode(): void;
    /**
     * @stability stable
     */
    get codeInput(): string | undefined;
    private _delay?;
    /**
     * @stability stable
     */
    get delay(): number | undefined;
    /**
     * @stability stable
     */
    set delay(value: number | undefined);
    /**
     * @stability stable
     */
    resetDelay(): void;
    /**
     * @stability stable
     */
    get delayInput(): number | undefined;
    private _element?;
    /**
     * @stability stable
     */
    get element(): string | undefined;
    /**
     * @stability stable
     */
    set element(value: string | undefined);
    /**
     * @stability stable
     */
    resetElement(): void;
    /**
     * @stability stable
     */
    get elementInput(): string | undefined;
    private _email?;
    /**
     * @stability stable
     */
    get email(): string | undefined;
    /**
     * @stability stable
     */
    set email(value: string | undefined);
    /**
     * @stability stable
     */
    resetEmail(): void;
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    private _file?;
    /**
     * @stability stable
     */
    get file(): string | undefined;
    /**
     * @stability stable
     */
    set file(value: string | undefined);
    /**
     * @stability stable
     */
    resetFile(): void;
    /**
     * @stability stable
     */
    get fileInput(): string | undefined;
    private _files?;
    /**
     * @stability stable
     */
    get files(): string | undefined;
    /**
     * @stability stable
     */
    set files(value: string | undefined);
    /**
     * @stability stable
     */
    resetFiles(): void;
    /**
     * @stability stable
     */
    get filesInput(): string | undefined;
    private _modifiers?;
    /**
     * @stability stable
     */
    get modifiers(): string[] | undefined;
    /**
     * @stability stable
     */
    set modifiers(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetModifiers(): void;
    /**
     * @stability stable
     */
    get modifiersInput(): string[] | undefined;
    private _playingTabId?;
    /**
     * @stability stable
     */
    get playingTabId(): string | undefined;
    /**
     * @stability stable
     */
    set playingTabId(value: string | undefined);
    /**
     * @stability stable
     */
    resetPlayingTabId(): void;
    /**
     * @stability stable
     */
    get playingTabIdInput(): string | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): string | undefined;
    /**
     * @stability stable
     */
    set request(value: string | undefined);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): string | undefined;
    private _subtestPublicId?;
    /**
     * @stability stable
     */
    get subtestPublicId(): string | undefined;
    /**
     * @stability stable
     */
    set subtestPublicId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSubtestPublicId(): void;
    /**
     * @stability stable
     */
    get subtestPublicIdInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string | undefined;
    /**
     * @stability stable
     */
    set value(value: string | undefined);
    /**
     * @stability stable
     */
    resetValue(): void;
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
    private _withClick?;
    /**
     * @stability stable
     */
    get withClick(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set withClick(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetWithClick(): void;
    /**
     * @stability stable
     */
    get withClickInput(): boolean | cdktf.IResolvable | undefined;
    private _x?;
    /**
     * @stability stable
     */
    get x(): number | undefined;
    /**
     * @stability stable
     */
    set x(value: number | undefined);
    /**
     * @stability stable
     */
    resetX(): void;
    /**
     * @stability stable
     */
    get xInput(): number | undefined;
    private _y?;
    /**
     * @stability stable
     */
    get y(): number | undefined;
    /**
     * @stability stable
     */
    set y(value: number | undefined);
    /**
     * @stability stable
     */
    resetY(): void;
    /**
     * @stability stable
     */
    get yInput(): number | undefined;
    private _variable?;
    private __variableOutput;
    /**
     * @stability stable
     */
    get variable(): SyntheticsTestBrowserStepParamsVariableOutputReference;
    /**
     * @stability stable
     */
    putVariable(value: SyntheticsTestBrowserStepParamsVariable | undefined): void;
    /**
     * @stability stable
     */
    resetVariable(): void;
    /**
     * @stability stable
     */
    get variableInput(): SyntheticsTestBrowserStepParamsVariable | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestBrowserStep {
    /**
     * Determines if the step should be allowed to fail.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#allow_failure SyntheticsTest#allow_failure}
     *
     * @stability stable
     */
    readonly allowFailure?: boolean | cdktf.IResolvable;
    /**
     * Force update of the "element" parameter for the step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#force_element_update SyntheticsTest#force_element_update}
     *
     * @stability stable
     */
    readonly forceElementUpdate?: boolean | cdktf.IResolvable;
    /**
     * Name of the step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#name SyntheticsTest#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Used to override the default timeout of a step.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#timeout SyntheticsTest#timeout}
     *
     * @stability stable
     */
    readonly timeout?: number;
    /**
     * Type of the step.
     *
     * Valid values are `assertCurrentUrl`, `assertElementAttribute`, `assertElementContent`, `assertElementPresent`, `assertEmail`, `assertFileDownload`, `assertFromJavascript`, `assertPageContains`, `assertPageLacks`, `click`, `extractFromJavascript`, `extractVariable`, `goToEmailLink`, `goToUrl`, `goToUrlAndMeasureTti`, `hover`, `playSubTest`, `pressKey`, `refresh`, `runApiTest`, `scroll`, `selectOption`, `typeText`, `uploadFiles`, `wait`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * params block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#params SyntheticsTest#params}
     *
     * @stability stable
     */
    readonly params: SyntheticsTestBrowserStepParams;
}
/**
 * @stability stable
 */
export interface SyntheticsTestBrowserVariable {
    /**
     * Example for the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#example SyntheticsTest#example}
     *
     * @stability stable
     */
    readonly example?: string;
    /**
     * ID of the global variable to use.
     *
     * This is actually only used (and required) in the case of using a variable of type `global`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#id SyntheticsTest#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Name of the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#name SyntheticsTest#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Pattern of the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#pattern SyntheticsTest#pattern}
     *
     * @stability stable
     */
    readonly pattern?: string;
    /**
     * Type of browser test variable. Valid values are `element`, `email`, `global`, `javascript`, `text`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface SyntheticsTestConfigVariable {
    /**
     * Example for the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#example SyntheticsTest#example}
     *
     * @stability stable
     */
    readonly example?: string;
    /**
     * When type = `global`, ID of the global variable to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#id SyntheticsTest#id}
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Name of the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#name SyntheticsTest#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Pattern of the variable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#pattern SyntheticsTest#pattern}
     *
     * @stability stable
     */
    readonly pattern?: string;
    /**
     * Type of test configuration variable. Valid values are `global`, `text`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#type SyntheticsTest#type}
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface SyntheticsTestOptionsListMonitorOptions {
    /**
     * Specify a renotification frequency.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#renotify_interval SyntheticsTest#renotify_interval}
     *
     * @stability stable
     */
    readonly renotifyInterval?: number;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestOptionsListMonitorOptionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _renotifyInterval?;
    /**
     * @stability stable
     */
    get renotifyInterval(): number | undefined;
    /**
     * @stability stable
     */
    set renotifyInterval(value: number | undefined);
    /**
     * @stability stable
     */
    resetRenotifyInterval(): void;
    /**
     * @stability stable
     */
    get renotifyIntervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestOptionsListRetry {
    /**
     * Number of retries needed to consider a location as failed before sending a notification alert.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#count SyntheticsTest#count}
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * Interval between a failed test and the next retry in milliseconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#interval SyntheticsTest#interval}
     *
     * @stability stable
     */
    readonly interval?: number;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestOptionsListRetryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number | undefined;
    /**
     * @stability stable
     */
    set count(value: number | undefined);
    /**
     * @stability stable
     */
    resetCount(): void;
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number | undefined;
    /**
     * @stability stable
     */
    set interval(value: number | undefined);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestOptionsList {
    /**
     * For SSL test, whether or not the test should allow self signed certificates.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#accept_self_signed SyntheticsTest#accept_self_signed}
     *
     * @stability stable
     */
    readonly acceptSelfSigned?: boolean | cdktf.IResolvable;
    /**
     * Allows loading insecure content for an HTTP test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#allow_insecure SyntheticsTest#allow_insecure}
     *
     * @stability stable
     */
    readonly allowInsecure?: boolean | cdktf.IResolvable;
    /**
     * Determines whether or not the API HTTP test should follow redirects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#follow_redirects SyntheticsTest#follow_redirects}
     *
     * @stability stable
     */
    readonly followRedirects?: boolean | cdktf.IResolvable;
    /**
     * Minimum amount of time in failure required to trigger an alert. Default is `0`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#min_failure_duration SyntheticsTest#min_failure_duration}
     *
     * @stability stable
     */
    readonly minFailureDuration?: number;
    /**
     * Minimum number of locations in failure required to trigger an alert. Default is `1`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#min_location_failed SyntheticsTest#min_location_failed}
     *
     * @stability stable
     */
    readonly minLocationFailed?: number;
    /**
     * The monitor name is used for the alert title as well as for all monitor dashboard widgets and SLOs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#monitor_name SyntheticsTest#monitor_name}
     *
     * @stability stable
     */
    readonly monitorName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#monitor_priority SyntheticsTest#monitor_priority}.
     *
     * @stability stable
     */
    readonly monitorPriority?: number;
    /**
     * Prevents saving screenshots of the steps.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#no_screenshot SyntheticsTest#no_screenshot}
     *
     * @stability stable
     */
    readonly noScreenshot?: boolean | cdktf.IResolvable;
    /**
     * How often the test should run (in seconds).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#tick_every SyntheticsTest#tick_every}
     *
     * @stability stable
     */
    readonly tickEvery: number;
    /**
     * monitor_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#monitor_options SyntheticsTest#monitor_options}
     *
     * @stability stable
     */
    readonly monitorOptions?: SyntheticsTestOptionsListMonitorOptions;
    /**
     * retry block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#retry SyntheticsTest#retry}
     *
     * @stability stable
     */
    readonly retry?: SyntheticsTestOptionsListRetry;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestOptionsListOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _acceptSelfSigned?;
    /**
     * @stability stable
     */
    get acceptSelfSigned(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set acceptSelfSigned(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAcceptSelfSigned(): void;
    /**
     * @stability stable
     */
    get acceptSelfSignedInput(): boolean | cdktf.IResolvable | undefined;
    private _allowInsecure?;
    /**
     * @stability stable
     */
    get allowInsecure(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set allowInsecure(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAllowInsecure(): void;
    /**
     * @stability stable
     */
    get allowInsecureInput(): boolean | cdktf.IResolvable | undefined;
    private _followRedirects?;
    /**
     * @stability stable
     */
    get followRedirects(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set followRedirects(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetFollowRedirects(): void;
    /**
     * @stability stable
     */
    get followRedirectsInput(): boolean | cdktf.IResolvable | undefined;
    private _minFailureDuration?;
    /**
     * @stability stable
     */
    get minFailureDuration(): number | undefined;
    /**
     * @stability stable
     */
    set minFailureDuration(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinFailureDuration(): void;
    /**
     * @stability stable
     */
    get minFailureDurationInput(): number | undefined;
    private _minLocationFailed?;
    /**
     * @stability stable
     */
    get minLocationFailed(): number | undefined;
    /**
     * @stability stable
     */
    set minLocationFailed(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinLocationFailed(): void;
    /**
     * @stability stable
     */
    get minLocationFailedInput(): number | undefined;
    private _monitorName?;
    /**
     * @stability stable
     */
    get monitorName(): string | undefined;
    /**
     * @stability stable
     */
    set monitorName(value: string | undefined);
    /**
     * @stability stable
     */
    resetMonitorName(): void;
    /**
     * @stability stable
     */
    get monitorNameInput(): string | undefined;
    private _monitorPriority?;
    /**
     * @stability stable
     */
    get monitorPriority(): number | undefined;
    /**
     * @stability stable
     */
    set monitorPriority(value: number | undefined);
    /**
     * @stability stable
     */
    resetMonitorPriority(): void;
    /**
     * @stability stable
     */
    get monitorPriorityInput(): number | undefined;
    private _noScreenshot?;
    /**
     * @stability stable
     */
    get noScreenshot(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set noScreenshot(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetNoScreenshot(): void;
    /**
     * @stability stable
     */
    get noScreenshotInput(): boolean | cdktf.IResolvable | undefined;
    private _tickEvery?;
    /**
     * @stability stable
     */
    get tickEvery(): number;
    /**
     * @stability stable
     */
    set tickEvery(value: number);
    /**
     * @stability stable
     */
    get tickEveryInput(): number | undefined;
    private _monitorOptions?;
    private __monitorOptionsOutput;
    /**
     * @stability stable
     */
    get monitorOptions(): SyntheticsTestOptionsListMonitorOptionsOutputReference;
    /**
     * @stability stable
     */
    putMonitorOptions(value: SyntheticsTestOptionsListMonitorOptions | undefined): void;
    /**
     * @stability stable
     */
    resetMonitorOptions(): void;
    /**
     * @stability stable
     */
    get monitorOptionsInput(): SyntheticsTestOptionsListMonitorOptions | undefined;
    private _retry?;
    private __retryOutput;
    /**
     * @stability stable
     */
    get retry(): SyntheticsTestOptionsListRetryOutputReference;
    /**
     * @stability stable
     */
    putRetry(value: SyntheticsTestOptionsListRetry | undefined): void;
    /**
     * @stability stable
     */
    resetRetry(): void;
    /**
     * @stability stable
     */
    get retryInput(): SyntheticsTestOptionsListRetry | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestRequestBasicauth {
    /**
     * Password for authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#password SyntheticsTest#password}
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Username for authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#username SyntheticsTest#username}
     *
     * @stability stable
     */
    readonly username: string;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestRequestBasicauthOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestRequestClientCertificateCert {
    /**
     * Content of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#content SyntheticsTest#content}
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * File name for the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#filename SyntheticsTest#filename}
     *
     * @stability stable
     */
    readonly filename?: string;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestRequestClientCertificateCertOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string | undefined;
    /**
     * @stability stable
     */
    set filename(value: string | undefined);
    /**
     * @stability stable
     */
    resetFilename(): void;
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestRequestClientCertificateKey {
    /**
     * Content of the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#content SyntheticsTest#content}
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * File name for the certificate.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#filename SyntheticsTest#filename}
     *
     * @stability stable
     */
    readonly filename?: string;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestRequestClientCertificateKeyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string | undefined;
    /**
     * @stability stable
     */
    set filename(value: string | undefined);
    /**
     * @stability stable
     */
    resetFilename(): void;
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestRequestClientCertificate {
    /**
     * cert block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#cert SyntheticsTest#cert}
     *
     * @stability stable
     */
    readonly cert: SyntheticsTestRequestClientCertificateCert;
    /**
     * key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#key SyntheticsTest#key}
     *
     * @stability stable
     */
    readonly key: SyntheticsTestRequestClientCertificateKey;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestRequestClientCertificateOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _cert?;
    private __certOutput;
    /**
     * @stability stable
     */
    get cert(): SyntheticsTestRequestClientCertificateCertOutputReference;
    /**
     * @stability stable
     */
    putCert(value: SyntheticsTestRequestClientCertificateCert): void;
    /**
     * @stability stable
     */
    get certInput(): SyntheticsTestRequestClientCertificateCert | undefined;
    private _key?;
    private __keyOutput;
    /**
     * @stability stable
     */
    get key(): SyntheticsTestRequestClientCertificateKeyOutputReference;
    /**
     * @stability stable
     */
    putKey(value: SyntheticsTestRequestClientCertificateKey): void;
    /**
     * @stability stable
     */
    get keyInput(): SyntheticsTestRequestClientCertificateKey | undefined;
}
/**
 * @stability stable
 */
export interface SyntheticsTestRequestDefinition {
    /**
     * The request body.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#body SyntheticsTest#body}
     *
     * @stability stable
     */
    readonly body?: string;
    /**
     * DNS server to use for DNS tests (`subtype = "dns"`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#dns_server SyntheticsTest#dns_server}
     *
     * @stability stable
     */
    readonly dnsServer?: string;
    /**
     * DNS server port to use for DNS tests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#dns_server_port SyntheticsTest#dns_server_port}
     *
     * @stability stable
     */
    readonly dnsServerPort?: number;
    /**
     * Host name to perform the test with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#host SyntheticsTest#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * The HTTP method. Valid values are `GET`, `POST`, `PATCH`, `PUT`, `DELETE`, `HEAD`, `OPTIONS`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#method SyntheticsTest#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Determines whether or not to save the response body.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#no_saving_response_body SyntheticsTest#no_saving_response_body}
     *
     * @stability stable
     */
    readonly noSavingResponseBody?: boolean | cdktf.IResolvable;
    /**
     * Number of pings to use per test for ICMP tests (`subtype = "icmp"`) between 0 and 10.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#number_of_packets SyntheticsTest#number_of_packets}
     *
     * @stability stable
     */
    readonly numberOfPackets?: number;
    /**
     * Port to use when performing the test.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#port SyntheticsTest#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * For SSL tests, it specifies on which server you want to initiate the TLS handshake, allowing the server to present one of multiple possible certificates on the same IP address and TCP port number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#servername SyntheticsTest#servername}
     *
     * @stability stable
     */
    readonly servername?: string;
    /**
     * This will turn on a traceroute probe to discover all gateways along the path to the host destination.
     *
     * For ICMP tests (`subtype = "icmp"`).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#should_track_hops SyntheticsTest#should_track_hops}
     *
     * @stability stable
     */
    readonly shouldTrackHops?: boolean | cdktf.IResolvable;
    /**
     * Timeout in seconds for the test. Defaults to `60`.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#timeout SyntheticsTest#timeout}
     *
     * @stability stable
     */
    readonly timeout?: number;
    /**
     * The URL to send the request to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html#url SyntheticsTest#url}
     *
     * @stability stable
     */
    readonly url?: string;
}
/**
 * @stability stable
 */
export declare class SyntheticsTestRequestDefinitionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _body?;
    /**
     * @stability stable
     */
    get body(): string | undefined;
    /**
     * @stability stable
     */
    set body(value: string | undefined);
    /**
     * @stability stable
     */
    resetBody(): void;
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    private _dnsServer?;
    /**
     * @stability stable
     */
    get dnsServer(): string | undefined;
    /**
     * @stability stable
     */
    set dnsServer(value: string | undefined);
    /**
     * @stability stable
     */
    resetDnsServer(): void;
    /**
     * @stability stable
     */
    get dnsServerInput(): string | undefined;
    private _dnsServerPort?;
    /**
     * @stability stable
     */
    get dnsServerPort(): number | undefined;
    /**
     * @stability stable
     */
    set dnsServerPort(value: number | undefined);
    /**
     * @stability stable
     */
    resetDnsServerPort(): void;
    /**
     * @stability stable
     */
    get dnsServerPortInput(): number | undefined;
    private _host?;
    /**
     * @stability stable
     */
    get host(): string | undefined;
    /**
     * @stability stable
     */
    set host(value: string | undefined);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _method?;
    /**
     * @stability stable
     */
    get method(): string | undefined;
    /**
     * @stability stable
     */
    set method(value: string | undefined);
    /**
     * @stability stable
     */
    resetMethod(): void;
    /**
     * @stability stable
     */
    get methodInput(): string | undefined;
    private _noSavingResponseBody?;
    /**
     * @stability stable
     */
    get noSavingResponseBody(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set noSavingResponseBody(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetNoSavingResponseBody(): void;
    /**
     * @stability stable
     */
    get noSavingResponseBodyInput(): boolean | cdktf.IResolvable | undefined;
    private _numberOfPackets?;
    /**
     * @stability stable
     */
    get numberOfPackets(): number | undefined;
    /**
     * @stability stable
     */
    set numberOfPackets(value: number | undefined);
    /**
     * @stability stable
     */
    resetNumberOfPackets(): void;
    /**
     * @stability stable
     */
    get numberOfPacketsInput(): number | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number | undefined;
    /**
     * @stability stable
     */
    set port(value: number | undefined);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _servername?;
    /**
     * @stability stable
     */
    get servername(): string | undefined;
    /**
     * @stability stable
     */
    set servername(value: string | undefined);
    /**
     * @stability stable
     */
    resetServername(): void;
    /**
     * @stability stable
     */
    get servernameInput(): string | undefined;
    private _shouldTrackHops?;
    /**
     * @stability stable
     */
    get shouldTrackHops(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set shouldTrackHops(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetShouldTrackHops(): void;
    /**
     * @stability stable
     */
    get shouldTrackHopsInput(): boolean | cdktf.IResolvable | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): number | undefined;
    /**
     * @stability stable
     */
    set timeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): number | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string | undefined;
    /**
     * @stability stable
     */
    set url(value: string | undefined);
    /**
     * @stability stable
     */
    resetUrl(): void;
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html datadog_synthetics_test}.
 *
 * @stability stable
 */
export declare class SyntheticsTest extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/datadog/r/synthetics_test.html datadog_synthetics_test} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SyntheticsTestConfig);
    private _deviceIds?;
    /**
     * @stability stable
     */
    get deviceIds(): string[] | undefined;
    /**
     * @stability stable
     */
    set deviceIds(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetDeviceIds(): void;
    /**
     * @stability stable
     */
    get deviceIdsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _locations?;
    /**
     * @stability stable
     */
    get locations(): string[];
    /**
     * @stability stable
     */
    set locations(value: string[]);
    /**
     * @stability stable
     */
    get locationsInput(): string[] | undefined;
    private _message?;
    /**
     * @stability stable
     */
    get message(): string | undefined;
    /**
     * @stability stable
     */
    set message(value: string | undefined);
    /**
     * @stability stable
     */
    resetMessage(): void;
    /**
     * @stability stable
     */
    get messageInput(): string | undefined;
    /**
     * @stability stable
     */
    get monitorId(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _requestHeaders?;
    /**
     * @stability stable
     */
    get requestHeaders(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set requestHeaders(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetRequestHeaders(): void;
    /**
     * @stability stable
     */
    get requestHeadersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _requestQuery?;
    /**
     * @stability stable
     */
    get requestQuery(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set requestQuery(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetRequestQuery(): void;
    /**
     * @stability stable
     */
    get requestQueryInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _setCookie?;
    /**
     * @stability stable
     */
    get setCookie(): string | undefined;
    /**
     * @stability stable
     */
    set setCookie(value: string | undefined);
    /**
     * @stability stable
     */
    resetSetCookie(): void;
    /**
     * @stability stable
     */
    get setCookieInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    set status(value: string);
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _subtype?;
    /**
     * @stability stable
     */
    get subtype(): string | undefined;
    /**
     * @stability stable
     */
    set subtype(value: string | undefined);
    /**
     * @stability stable
     */
    resetSubtype(): void;
    /**
     * @stability stable
     */
    get subtypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[] | undefined;
    /**
     * @stability stable
     */
    set tags(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _apiStep?;
    /**
     * @stability stable
     */
    get apiStep(): SyntheticsTestApiStep[] | undefined;
    /**
     * @stability stable
     */
    set apiStep(value: SyntheticsTestApiStep[] | undefined);
    /**
     * @stability stable
     */
    resetApiStep(): void;
    /**
     * @stability stable
     */
    get apiStepInput(): SyntheticsTestApiStep[] | undefined;
    private _assertion?;
    /**
     * @stability stable
     */
    get assertion(): SyntheticsTestAssertion[] | undefined;
    /**
     * @stability stable
     */
    set assertion(value: SyntheticsTestAssertion[] | undefined);
    /**
     * @stability stable
     */
    resetAssertion(): void;
    /**
     * @stability stable
     */
    get assertionInput(): SyntheticsTestAssertion[] | undefined;
    private _browserStep?;
    /**
     * @stability stable
     */
    get browserStep(): SyntheticsTestBrowserStep[] | undefined;
    /**
     * @stability stable
     */
    set browserStep(value: SyntheticsTestBrowserStep[] | undefined);
    /**
     * @stability stable
     */
    resetBrowserStep(): void;
    /**
     * @stability stable
     */
    get browserStepInput(): SyntheticsTestBrowserStep[] | undefined;
    private _browserVariable?;
    /**
     * @stability stable
     */
    get browserVariable(): SyntheticsTestBrowserVariable[] | undefined;
    /**
     * @stability stable
     */
    set browserVariable(value: SyntheticsTestBrowserVariable[] | undefined);
    /**
     * @stability stable
     */
    resetBrowserVariable(): void;
    /**
     * @stability stable
     */
    get browserVariableInput(): SyntheticsTestBrowserVariable[] | undefined;
    private _configVariable?;
    /**
     * @stability stable
     */
    get configVariable(): SyntheticsTestConfigVariable[] | undefined;
    /**
     * @stability stable
     */
    set configVariable(value: SyntheticsTestConfigVariable[] | undefined);
    /**
     * @stability stable
     */
    resetConfigVariable(): void;
    /**
     * @stability stable
     */
    get configVariableInput(): SyntheticsTestConfigVariable[] | undefined;
    private _optionsList?;
    private __optionsListOutput;
    /**
     * @stability stable
     */
    get optionsList(): SyntheticsTestOptionsListOutputReference;
    /**
     * @stability stable
     */
    putOptionsList(value: SyntheticsTestOptionsList | undefined): void;
    /**
     * @stability stable
     */
    resetOptionsList(): void;
    /**
     * @stability stable
     */
    get optionsListInput(): SyntheticsTestOptionsList | undefined;
    private _requestBasicauth?;
    private __requestBasicauthOutput;
    /**
     * @stability stable
     */
    get requestBasicauth(): SyntheticsTestRequestBasicauthOutputReference;
    /**
     * @stability stable
     */
    putRequestBasicauth(value: SyntheticsTestRequestBasicauth | undefined): void;
    /**
     * @stability stable
     */
    resetRequestBasicauth(): void;
    /**
     * @stability stable
     */
    get requestBasicauthInput(): SyntheticsTestRequestBasicauth | undefined;
    private _requestClientCertificate?;
    private __requestClientCertificateOutput;
    /**
     * @stability stable
     */
    get requestClientCertificate(): SyntheticsTestRequestClientCertificateOutputReference;
    /**
     * @stability stable
     */
    putRequestClientCertificate(value: SyntheticsTestRequestClientCertificate | undefined): void;
    /**
     * @stability stable
     */
    resetRequestClientCertificate(): void;
    /**
     * @stability stable
     */
    get requestClientCertificateInput(): SyntheticsTestRequestClientCertificate | undefined;
    private _requestDefinition?;
    private __requestDefinitionOutput;
    /**
     * @stability stable
     */
    get requestDefinition(): SyntheticsTestRequestDefinitionOutputReference;
    /**
     * @stability stable
     */
    putRequestDefinition(value: SyntheticsTestRequestDefinition | undefined): void;
    /**
     * @stability stable
     */
    resetRequestDefinition(): void;
    /**
     * @stability stable
     */
    get requestDefinitionInput(): SyntheticsTestRequestDefinition | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
