"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _LicenseType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LicenseTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LicenseType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    STREAMING: _LicenseType.ValueType  # 1
    OFFLINE: _LicenseType.ValueType  # 2
    AUTOMATIC: _LicenseType.ValueType  # 3
    """License type decision is left to provider."""

class LicenseType(_LicenseType, metaclass=_LicenseTypeEnumTypeWrapper):
    """----------------------------------------------------------------------------
    license_protocol.proto
    ----------------------------------------------------------------------------
    Description of section:
      Definitions of the protocol buffer messages used in the Widevine license
      exchange protocol, described in Widevine license exchange protocol document
    """

STREAMING: LicenseType.ValueType  # 1
OFFLINE: LicenseType.ValueType  # 2
AUTOMATIC: LicenseType.ValueType  # 3
"""License type decision is left to provider."""
global___LicenseType = LicenseType

class _ProtocolVersion:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ProtocolVersionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ProtocolVersion.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    VERSION_2_0: _ProtocolVersion.ValueType  # 20
    VERSION_2_1: _ProtocolVersion.ValueType  # 21
    VERSION_2_2: _ProtocolVersion.ValueType  # 22

class ProtocolVersion(_ProtocolVersion, metaclass=_ProtocolVersionEnumTypeWrapper): ...

VERSION_2_0: ProtocolVersion.ValueType  # 20
VERSION_2_1: ProtocolVersion.ValueType  # 21
VERSION_2_2: ProtocolVersion.ValueType  # 22
global___ProtocolVersion = ProtocolVersion

class _HashAlgorithmProto:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _HashAlgorithmProtoEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_HashAlgorithmProto.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    HASH_ALGORITHM_UNSPECIFIED: _HashAlgorithmProto.ValueType  # 0
    """Unspecified hash algorithm: SHA_256 shall be used for ECC based algorithms
    and SHA_1 shall be used otherwise.
    """
    HASH_ALGORITHM_SHA_1: _HashAlgorithmProto.ValueType  # 1
    HASH_ALGORITHM_SHA_256: _HashAlgorithmProto.ValueType  # 2
    HASH_ALGORITHM_SHA_384: _HashAlgorithmProto.ValueType  # 3

class HashAlgorithmProto(_HashAlgorithmProto, metaclass=_HashAlgorithmProtoEnumTypeWrapper):
    """----------------------------------------------------------------------------
    hash_algorithm.proto
    ----------------------------------------------------------------------------
    Description of section:
      Public protocol buffer definitions for Widevine Hash Algorithm protocol.
    """

HASH_ALGORITHM_UNSPECIFIED: HashAlgorithmProto.ValueType  # 0
"""Unspecified hash algorithm: SHA_256 shall be used for ECC based algorithms
and SHA_1 shall be used otherwise.
"""
HASH_ALGORITHM_SHA_1: HashAlgorithmProto.ValueType  # 1
HASH_ALGORITHM_SHA_256: HashAlgorithmProto.ValueType  # 2
HASH_ALGORITHM_SHA_384: HashAlgorithmProto.ValueType  # 3
global___HashAlgorithmProto = HashAlgorithmProto

@typing.final
class LicenseIdentification(google.protobuf.message.Message):
    """LicenseIdentification is propagated from LicenseRequest to License,
    incrementing version with each iteration.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_ID_FIELD_NUMBER: builtins.int
    SESSION_ID_FIELD_NUMBER: builtins.int
    PURCHASE_ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    PROVIDER_SESSION_TOKEN_FIELD_NUMBER: builtins.int
    ORIGINAL_RENTAL_DURATION_SECONDS_FIELD_NUMBER: builtins.int
    ORIGINAL_PLAYBACK_DURATION_SECONDS_FIELD_NUMBER: builtins.int
    ORIGINAL_START_TIME_SECONDS_FIELD_NUMBER: builtins.int
    request_id: builtins.bytes
    session_id: builtins.bytes
    purchase_id: builtins.bytes
    type: global___LicenseType.ValueType
    version: builtins.int
    provider_session_token: builtins.bytes
    original_rental_duration_seconds: builtins.int
    original_playback_duration_seconds: builtins.int
    original_start_time_seconds: builtins.int
    def __init__(
        self,
        *,
        request_id: builtins.bytes | None = ...,
        session_id: builtins.bytes | None = ...,
        purchase_id: builtins.bytes | None = ...,
        type: global___LicenseType.ValueType | None = ...,
        version: builtins.int | None = ...,
        provider_session_token: builtins.bytes | None = ...,
        original_rental_duration_seconds: builtins.int | None = ...,
        original_playback_duration_seconds: builtins.int | None = ...,
        original_start_time_seconds: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["original_playback_duration_seconds", b"original_playback_duration_seconds", "original_rental_duration_seconds", b"original_rental_duration_seconds", "original_start_time_seconds", b"original_start_time_seconds", "provider_session_token", b"provider_session_token", "purchase_id", b"purchase_id", "request_id", b"request_id", "session_id", b"session_id", "type", b"type", "version", b"version"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["original_playback_duration_seconds", b"original_playback_duration_seconds", "original_rental_duration_seconds", b"original_rental_duration_seconds", "original_start_time_seconds", b"original_start_time_seconds", "provider_session_token", b"provider_session_token", "purchase_id", b"purchase_id", "request_id", b"request_id", "session_id", b"session_id", "type", b"type", "version", b"version"]) -> None: ...

global___LicenseIdentification = LicenseIdentification

@typing.final
class LicenseRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _RequestType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RequestTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[LicenseRequest._RequestType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NEW: LicenseRequest._RequestType.ValueType  # 1
        RENEWAL: LicenseRequest._RequestType.ValueType  # 2
        RELEASE: LicenseRequest._RequestType.ValueType  # 3

    class RequestType(_RequestType, metaclass=_RequestTypeEnumTypeWrapper): ...
    NEW: LicenseRequest.RequestType.ValueType  # 1
    RENEWAL: LicenseRequest.RequestType.ValueType  # 2
    RELEASE: LicenseRequest.RequestType.ValueType  # 3

    @typing.final
    class ContentIdentification(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing.final
        class WidevinePsshData(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            PSSH_DATA_FIELD_NUMBER: builtins.int
            LICENSE_TYPE_FIELD_NUMBER: builtins.int
            REQUEST_ID_FIELD_NUMBER: builtins.int
            license_type: global___LicenseType.ValueType
            request_id: builtins.bytes
            """Opaque, client-specified."""
            @property
            def pssh_data(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bytes]:
                """repeated WidevinePsshData pssh_data = 1;"""

            def __init__(
                self,
                *,
                pssh_data: collections.abc.Iterable[builtins.bytes] | None = ...,
                license_type: global___LicenseType.ValueType | None = ...,
                request_id: builtins.bytes | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["license_type", b"license_type", "request_id", b"request_id"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["license_type", b"license_type", "pssh_data", b"pssh_data", "request_id", b"request_id"]) -> None: ...

        @typing.final
        class WebmKeyId(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            HEADER_FIELD_NUMBER: builtins.int
            LICENSE_TYPE_FIELD_NUMBER: builtins.int
            REQUEST_ID_FIELD_NUMBER: builtins.int
            header: builtins.bytes
            license_type: global___LicenseType.ValueType
            request_id: builtins.bytes
            """Opaque, client-specified."""
            def __init__(
                self,
                *,
                header: builtins.bytes | None = ...,
                license_type: global___LicenseType.ValueType | None = ...,
                request_id: builtins.bytes | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["header", b"header", "license_type", b"license_type", "request_id", b"request_id"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["header", b"header", "license_type", b"license_type", "request_id", b"request_id"]) -> None: ...

        @typing.final
        class ExistingLicense(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            LICENSE_ID_FIELD_NUMBER: builtins.int
            SECONDS_SINCE_STARTED_FIELD_NUMBER: builtins.int
            SECONDS_SINCE_LAST_PLAYED_FIELD_NUMBER: builtins.int
            SESSION_USAGE_TABLE_ENTRY_FIELD_NUMBER: builtins.int
            seconds_since_started: builtins.int
            seconds_since_last_played: builtins.int
            session_usage_table_entry: builtins.bytes
            @property
            def license_id(self) -> global___LicenseIdentification: ...
            def __init__(
                self,
                *,
                license_id: global___LicenseIdentification | None = ...,
                seconds_since_started: builtins.int | None = ...,
                seconds_since_last_played: builtins.int | None = ...,
                session_usage_table_entry: builtins.bytes | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["license_id", b"license_id", "seconds_since_last_played", b"seconds_since_last_played", "seconds_since_started", b"seconds_since_started", "session_usage_table_entry", b"session_usage_table_entry"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["license_id", b"license_id", "seconds_since_last_played", b"seconds_since_last_played", "seconds_since_started", b"seconds_since_started", "session_usage_table_entry", b"session_usage_table_entry"]) -> None: ...

        @typing.final
        class InitData(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class _InitDataType:
                ValueType = typing.NewType("ValueType", builtins.int)
                V: typing_extensions.TypeAlias = ValueType

            class _InitDataTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[LicenseRequest.ContentIdentification.InitData._InitDataType.ValueType], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                CENC: LicenseRequest.ContentIdentification.InitData._InitDataType.ValueType  # 1
                WEBM: LicenseRequest.ContentIdentification.InitData._InitDataType.ValueType  # 2

            class InitDataType(_InitDataType, metaclass=_InitDataTypeEnumTypeWrapper): ...
            CENC: LicenseRequest.ContentIdentification.InitData.InitDataType.ValueType  # 1
            WEBM: LicenseRequest.ContentIdentification.InitData.InitDataType.ValueType  # 2

            INIT_DATA_TYPE_FIELD_NUMBER: builtins.int
            INIT_DATA_FIELD_NUMBER: builtins.int
            LICENSE_TYPE_FIELD_NUMBER: builtins.int
            REQUEST_ID_FIELD_NUMBER: builtins.int
            init_data_type: global___LicenseRequest.ContentIdentification.InitData.InitDataType.ValueType
            init_data: builtins.bytes
            license_type: global___LicenseType.ValueType
            request_id: builtins.bytes
            def __init__(
                self,
                *,
                init_data_type: global___LicenseRequest.ContentIdentification.InitData.InitDataType.ValueType | None = ...,
                init_data: builtins.bytes | None = ...,
                license_type: global___LicenseType.ValueType | None = ...,
                request_id: builtins.bytes | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing.Literal["init_data", b"init_data", "init_data_type", b"init_data_type", "license_type", b"license_type", "request_id", b"request_id"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing.Literal["init_data", b"init_data", "init_data_type", b"init_data_type", "license_type", b"license_type", "request_id", b"request_id"]) -> None: ...

        WIDEVINE_PSSH_DATA_FIELD_NUMBER: builtins.int
        WEBM_KEY_ID_FIELD_NUMBER: builtins.int
        EXISTING_LICENSE_FIELD_NUMBER: builtins.int
        INIT_DATA_FIELD_NUMBER: builtins.int
        @property
        def widevine_pssh_data(self) -> global___LicenseRequest.ContentIdentification.WidevinePsshData:
            """Exactly one of these must be present."""

        @property
        def webm_key_id(self) -> global___LicenseRequest.ContentIdentification.WebmKeyId: ...
        @property
        def existing_license(self) -> global___LicenseRequest.ContentIdentification.ExistingLicense: ...
        @property
        def init_data(self) -> global___LicenseRequest.ContentIdentification.InitData: ...
        def __init__(
            self,
            *,
            widevine_pssh_data: global___LicenseRequest.ContentIdentification.WidevinePsshData | None = ...,
            webm_key_id: global___LicenseRequest.ContentIdentification.WebmKeyId | None = ...,
            existing_license: global___LicenseRequest.ContentIdentification.ExistingLicense | None = ...,
            init_data: global___LicenseRequest.ContentIdentification.InitData | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["content_id_variant", b"content_id_variant", "existing_license", b"existing_license", "init_data", b"init_data", "webm_key_id", b"webm_key_id", "widevine_pssh_data", b"widevine_pssh_data"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["content_id_variant", b"content_id_variant", "existing_license", b"existing_license", "init_data", b"init_data", "webm_key_id", b"webm_key_id", "widevine_pssh_data", b"widevine_pssh_data"]) -> None: ...
        def WhichOneof(self, oneof_group: typing.Literal["content_id_variant", b"content_id_variant"]) -> typing.Literal["widevine_pssh_data", "webm_key_id", "existing_license", "init_data"] | None: ...

    @typing.final
    class SubSessionData(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        SUB_SESSION_KEY_ID_FIELD_NUMBER: builtins.int
        NONCE_FIELD_NUMBER: builtins.int
        TRACK_LABEL_FIELD_NUMBER: builtins.int
        sub_session_key_id: builtins.str
        """Required. The key ID for the corresponding SUB_SESSION_KEY. The
        value must match the sub_session_key_id field for a
        corresponding SubLicense message from the PSSH.
        """
        nonce: builtins.int
        """Required. The nonce for the track."""
        track_label: builtins.str
        """Required for initial license request used for each CONTENT key_container
        to know which nonce to use for building its key control block.
        Not needed for renewal license request.
        """
        def __init__(
            self,
            *,
            sub_session_key_id: builtins.str | None = ...,
            nonce: builtins.int | None = ...,
            track_label: builtins.str | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["nonce", b"nonce", "sub_session_key_id", b"sub_session_key_id", "track_label", b"track_label"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["nonce", b"nonce", "sub_session_key_id", b"sub_session_key_id", "track_label", b"track_label"]) -> None: ...

    CLIENT_ID_FIELD_NUMBER: builtins.int
    CONTENT_ID_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    REQUEST_TIME_FIELD_NUMBER: builtins.int
    KEY_CONTROL_NONCE_DEPRECATED_FIELD_NUMBER: builtins.int
    PROTOCOL_VERSION_FIELD_NUMBER: builtins.int
    KEY_CONTROL_NONCE_FIELD_NUMBER: builtins.int
    ENCRYPTED_CLIENT_ID_FIELD_NUMBER: builtins.int
    CLIENT_VERSION_FIELD_NUMBER: builtins.int
    type: global___LicenseRequest.RequestType.ValueType
    request_time: builtins.int
    """Time of the request in seconds (UTC) as set by the client."""
    key_control_nonce_deprecated: builtins.bytes
    """Old-style decimal-encoded string key control nonce."""
    protocol_version: global___ProtocolVersion.ValueType
    key_control_nonce: builtins.int
    """New-style uint32 key control nonce, please use instead of
    key_control_nonce_deprecated.
    """
    client_version: builtins.str
    """Optional sub session context information. Required for using
    SubLicenses from the PSSH.
    repeated SubSessionData sub_session_data = 9;
    """
    @property
    def client_id(self) -> global___ClientIdentification:
        """The client_id provides information authenticating the calling device.  It
        contains the Widevine keybox token that was installed on the device at the
        factory.  This field or encrypted_client_id below is required for a valid
        license request, but both should never be present in the same request.
        """

    @property
    def content_id(self) -> global___LicenseRequest.ContentIdentification: ...
    @property
    def encrypted_client_id(self) -> global___EncryptedClientIdentification:
        """Encrypted ClientIdentification message, used for privacy purposes."""

    def __init__(
        self,
        *,
        client_id: global___ClientIdentification | None = ...,
        content_id: global___LicenseRequest.ContentIdentification | None = ...,
        type: global___LicenseRequest.RequestType.ValueType | None = ...,
        request_time: builtins.int | None = ...,
        key_control_nonce_deprecated: builtins.bytes | None = ...,
        protocol_version: global___ProtocolVersion.ValueType | None = ...,
        key_control_nonce: builtins.int | None = ...,
        encrypted_client_id: global___EncryptedClientIdentification | None = ...,
        client_version: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["client_id", b"client_id", "client_version", b"client_version", "content_id", b"content_id", "encrypted_client_id", b"encrypted_client_id", "key_control_nonce", b"key_control_nonce", "key_control_nonce_deprecated", b"key_control_nonce_deprecated", "protocol_version", b"protocol_version", "request_time", b"request_time", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["client_id", b"client_id", "client_version", b"client_version", "content_id", b"content_id", "encrypted_client_id", b"encrypted_client_id", "key_control_nonce", b"key_control_nonce", "key_control_nonce_deprecated", b"key_control_nonce_deprecated", "protocol_version", b"protocol_version", "request_time", b"request_time", "type", b"type"]) -> None: ...

global___LicenseRequest = LicenseRequest

@typing.final
class MetricData(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _MetricType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MetricTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[MetricData._MetricType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LATENCY: MetricData._MetricType.ValueType  # 1
        """The time spent in the 'stage', specified in microseconds."""
        TIMESTAMP: MetricData._MetricType.ValueType  # 2
        """The UNIX epoch timestamp at which the 'stage' was first accessed in
        microseconds.
        """

    class MetricType(_MetricType, metaclass=_MetricTypeEnumTypeWrapper): ...
    LATENCY: MetricData.MetricType.ValueType  # 1
    """The time spent in the 'stage', specified in microseconds."""
    TIMESTAMP: MetricData.MetricType.ValueType  # 2
    """The UNIX epoch timestamp at which the 'stage' was first accessed in
    microseconds.
    """

    @typing.final
    class TypeValue(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TYPE_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        type: global___MetricData.MetricType.ValueType
        value: builtins.int
        """The value associated with 'type'.  For example if type == LATENCY, the
        value would be the time in microseconds spent in this 'stage'.
        """
        def __init__(
            self,
            *,
            type: global___MetricData.MetricType.ValueType | None = ...,
            value: builtins.int | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["type", b"type", "value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["type", b"type", "value", b"value"]) -> None: ...

    STAGE_NAME_FIELD_NUMBER: builtins.int
    METRIC_DATA_FIELD_NUMBER: builtins.int
    stage_name: builtins.str
    """'stage' that is currently processing the SignedMessage.  Required."""
    @property
    def metric_data(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MetricData.TypeValue]:
        """metric and associated value."""

    def __init__(
        self,
        *,
        stage_name: builtins.str | None = ...,
        metric_data: collections.abc.Iterable[global___MetricData.TypeValue] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["stage_name", b"stage_name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["metric_data", b"metric_data", "stage_name", b"stage_name"]) -> None: ...

global___MetricData = MetricData

@typing.final
class VersionInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LICENSE_SDK_VERSION_FIELD_NUMBER: builtins.int
    LICENSE_SERVICE_VERSION_FIELD_NUMBER: builtins.int
    license_sdk_version: builtins.str
    """License SDK version reported by the Widevine License SDK. This field
    is populated automatically by the SDK.
    """
    license_service_version: builtins.str
    """Version of the service hosting the license SDK. This field is optional.
    It may be provided by the hosting service.
    """
    def __init__(
        self,
        *,
        license_sdk_version: builtins.str | None = ...,
        license_service_version: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["license_sdk_version", b"license_sdk_version", "license_service_version", b"license_service_version"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["license_sdk_version", b"license_sdk_version", "license_service_version", b"license_service_version"]) -> None: ...

global___VersionInfo = VersionInfo

@typing.final
class SignedMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _MessageType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MessageTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SignedMessage._MessageType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        LICENSE_REQUEST: SignedMessage._MessageType.ValueType  # 1
        LICENSE: SignedMessage._MessageType.ValueType  # 2
        ERROR_RESPONSE: SignedMessage._MessageType.ValueType  # 3
        SERVICE_CERTIFICATE_REQUEST: SignedMessage._MessageType.ValueType  # 4
        SERVICE_CERTIFICATE: SignedMessage._MessageType.ValueType  # 5
        SUB_LICENSE: SignedMessage._MessageType.ValueType  # 6
        CAS_LICENSE_REQUEST: SignedMessage._MessageType.ValueType  # 7
        CAS_LICENSE: SignedMessage._MessageType.ValueType  # 8
        EXTERNAL_LICENSE_REQUEST: SignedMessage._MessageType.ValueType  # 9
        EXTERNAL_LICENSE: SignedMessage._MessageType.ValueType  # 10

    class MessageType(_MessageType, metaclass=_MessageTypeEnumTypeWrapper): ...
    LICENSE_REQUEST: SignedMessage.MessageType.ValueType  # 1
    LICENSE: SignedMessage.MessageType.ValueType  # 2
    ERROR_RESPONSE: SignedMessage.MessageType.ValueType  # 3
    SERVICE_CERTIFICATE_REQUEST: SignedMessage.MessageType.ValueType  # 4
    SERVICE_CERTIFICATE: SignedMessage.MessageType.ValueType  # 5
    SUB_LICENSE: SignedMessage.MessageType.ValueType  # 6
    CAS_LICENSE_REQUEST: SignedMessage.MessageType.ValueType  # 7
    CAS_LICENSE: SignedMessage.MessageType.ValueType  # 8
    EXTERNAL_LICENSE_REQUEST: SignedMessage.MessageType.ValueType  # 9
    EXTERNAL_LICENSE: SignedMessage.MessageType.ValueType  # 10

    class _SessionKeyType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _SessionKeyTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SignedMessage._SessionKeyType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNDEFINED: SignedMessage._SessionKeyType.ValueType  # 0
        WRAPPED_AES_KEY: SignedMessage._SessionKeyType.ValueType  # 1
        EPHERMERAL_ECC_PUBLIC_KEY: SignedMessage._SessionKeyType.ValueType  # 2

    class SessionKeyType(_SessionKeyType, metaclass=_SessionKeyTypeEnumTypeWrapper): ...
    UNDEFINED: SignedMessage.SessionKeyType.ValueType  # 0
    WRAPPED_AES_KEY: SignedMessage.SessionKeyType.ValueType  # 1
    EPHERMERAL_ECC_PUBLIC_KEY: SignedMessage.SessionKeyType.ValueType  # 2

    TYPE_FIELD_NUMBER: builtins.int
    MSG_FIELD_NUMBER: builtins.int
    SIGNATURE_FIELD_NUMBER: builtins.int
    SESSION_KEY_FIELD_NUMBER: builtins.int
    REMOTE_ATTESTATION_FIELD_NUMBER: builtins.int
    METRIC_DATA_FIELD_NUMBER: builtins.int
    SERVICE_VERSION_INFO_FIELD_NUMBER: builtins.int
    SESSION_KEY_TYPE_FIELD_NUMBER: builtins.int
    OEMCRYPTO_CORE_MESSAGE_FIELD_NUMBER: builtins.int
    USING_SECONDARY_KEY_FIELD_NUMBER: builtins.int
    type: global___SignedMessage.MessageType.ValueType
    msg: builtins.bytes
    signature: builtins.bytes
    """Required field that contains the signature of the bytes of msg.
    For license requests, the signing algorithm is determined by the
    certificate contained in the request.
    For license responses, the signing algorithm is HMAC with signing key based
    on |session_key|.
    """
    session_key: builtins.bytes
    """If populated, the contents of this field will be signaled by the
    |session_key_type| type. If the |session_key_type| is WRAPPED_AES_KEY the
    key is the bytes of an encrypted AES key. If the |session_key_type| is
    EPHERMERAL_ECC_PUBLIC_KEY the field contains the bytes of an RFC5208 ASN1
    serialized ECC public key.
    """
    remote_attestation: builtins.bytes
    """Remote attestation data which will be present in the initial license
    request for ChromeOS client devices operating in verified mode. Remote
    attestation challenge data is |msg| field above. Optional.
    """
    session_key_type: global___SignedMessage.SessionKeyType.ValueType
    """Optional field that contains the algorithm type used to generate the
    session_key and signature in a LICENSE message.
    """
    oemcrypto_core_message: builtins.bytes
    """The core message is the simple serialization of fields used by OEMCrypto.
    This field was introduced in OEMCrypto API v16.
    """
    using_secondary_key: builtins.bool
    @property
    def metric_data(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MetricData]: ...
    @property
    def service_version_info(self) -> global___VersionInfo:
        """Version information from the SDK and license service. This information is
        provided in the license response.
        """

    def __init__(
        self,
        *,
        type: global___SignedMessage.MessageType.ValueType | None = ...,
        msg: builtins.bytes | None = ...,
        signature: builtins.bytes | None = ...,
        session_key: builtins.bytes | None = ...,
        remote_attestation: builtins.bytes | None = ...,
        metric_data: collections.abc.Iterable[global___MetricData] | None = ...,
        service_version_info: global___VersionInfo | None = ...,
        session_key_type: global___SignedMessage.SessionKeyType.ValueType | None = ...,
        oemcrypto_core_message: builtins.bytes | None = ...,
        using_secondary_key: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["msg", b"msg", "oemcrypto_core_message", b"oemcrypto_core_message", "remote_attestation", b"remote_attestation", "service_version_info", b"service_version_info", "session_key", b"session_key", "session_key_type", b"session_key_type", "signature", b"signature", "type", b"type", "using_secondary_key", b"using_secondary_key"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["metric_data", b"metric_data", "msg", b"msg", "oemcrypto_core_message", b"oemcrypto_core_message", "remote_attestation", b"remote_attestation", "service_version_info", b"service_version_info", "session_key", b"session_key", "session_key_type", b"session_key_type", "signature", b"signature", "type", b"type", "using_secondary_key", b"using_secondary_key"]) -> None: ...

global___SignedMessage = SignedMessage

@typing.final
class ProvisioningResponse(google.protobuf.message.Message):
    """----------------------------------------------------------------------------
    certificate_provisioning.proto
    ----------------------------------------------------------------------------
    Description of section:
      Public protocol buffer definitions for Widevine Device Certificate
      Provisioning protocol.

    Provisioning response sent by the provisioning server to client devices.
    This message is used for both regular Widevine DRM certificates and for
    application-specific X.509 certificates.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ProvisioningStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ProvisioningStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ProvisioningResponse._ProvisioningStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NO_ERROR: ProvisioningResponse._ProvisioningStatus.ValueType  # 0
        """Indicates a valid provisioning response"""
        REVOKED_DEVICE_CREDENTIALS: ProvisioningResponse._ProvisioningStatus.ValueType  # 1
        """The device credentials have been revoked. Provisioning is not possible."""
        REVOKED_DEVICE_SERIES: ProvisioningResponse._ProvisioningStatus.ValueType  # 2
        """Devices in this series have been revoked. Provisioning is not possible."""

    class ProvisioningStatus(_ProvisioningStatus, metaclass=_ProvisioningStatusEnumTypeWrapper): ...
    NO_ERROR: ProvisioningResponse.ProvisioningStatus.ValueType  # 0
    """Indicates a valid provisioning response"""
    REVOKED_DEVICE_CREDENTIALS: ProvisioningResponse.ProvisioningStatus.ValueType  # 1
    """The device credentials have been revoked. Provisioning is not possible."""
    REVOKED_DEVICE_SERIES: ProvisioningResponse.ProvisioningStatus.ValueType  # 2
    """Devices in this series have been revoked. Provisioning is not possible."""

    @typing.final
    class OtaKeybox(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        DEVICE_KEY_ENCRYPTION_IV_FIELD_NUMBER: builtins.int
        ENCRYPTED_DEVICE_KEY_FIELD_NUMBER: builtins.int
        DEVICE_CA_TOKEN_FIELD_NUMBER: builtins.int
        device_key_encryption_iv: builtins.bytes
        """Iv used along with SessionKeys.encryption_key for encrypting device key."""
        encrypted_device_key: builtins.bytes
        """Device key component of the keybox, encrypted using the
        SessionKeys.encryption_key in the request and |device_key_encryption_iv|
        above.
        """
        device_ca_token: builtins.bytes
        """Device CA token component of the keybox."""
        def __init__(
            self,
            *,
            device_key_encryption_iv: builtins.bytes | None = ...,
            encrypted_device_key: builtins.bytes | None = ...,
            device_ca_token: builtins.bytes | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["device_ca_token", b"device_ca_token", "device_key_encryption_iv", b"device_key_encryption_iv", "encrypted_device_key", b"encrypted_device_key"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["device_ca_token", b"device_ca_token", "device_key_encryption_iv", b"device_key_encryption_iv", "encrypted_device_key", b"encrypted_device_key"]) -> None: ...

    DEVICE_RSA_KEY_FIELD_NUMBER: builtins.int
    DEVICE_RSA_KEY_IV_FIELD_NUMBER: builtins.int
    DEVICE_CERTIFICATE_FIELD_NUMBER: builtins.int
    NONCE_FIELD_NUMBER: builtins.int
    WRAPPING_KEY_FIELD_NUMBER: builtins.int
    OTA_KEYBOX_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    device_rsa_key: builtins.bytes
    """AES-128 encrypted device private RSA key. PKCS#1 ASN.1 DER-encoded.
    Required. For X.509 certificates, the private RSA key may also include
    a prefix as specified by private_key_prefix in the X509CertificateMetadata
    proto message.
    """
    device_rsa_key_iv: builtins.bytes
    """Initialization vector used to encrypt device_rsa_key. Required."""
    device_certificate: builtins.bytes
    """For Widevine DRM certificates, this contains the serialized
    SignedDrmCertificate. For X.509 certificates, this contains the PEM
    encoded X.509 certificate. Required.
    """
    nonce: builtins.bytes
    """Nonce value matching nonce in ProvisioningRequest. Required."""
    wrapping_key: builtins.bytes
    """Key used to wrap device_rsa_key when DRM provisioning an OEM factory
    provisioned device. Encrypted with the device OEM public key using
    RSA-OAEP.
    """
    status: global___ProvisioningResponse.ProvisioningStatus.ValueType
    """The provisioning service may return a ProvisioningStatus. Fields other
    than |status| may be empty and should be ignored if the |status|
    is present and not NO_ERROR
    """
    @property
    def ota_keybox(self) -> global___ProvisioningResponse.OtaKeybox:
        """Only populated in OTA keybox provisioning response."""

    def __init__(
        self,
        *,
        device_rsa_key: builtins.bytes | None = ...,
        device_rsa_key_iv: builtins.bytes | None = ...,
        device_certificate: builtins.bytes | None = ...,
        nonce: builtins.bytes | None = ...,
        wrapping_key: builtins.bytes | None = ...,
        ota_keybox: global___ProvisioningResponse.OtaKeybox | None = ...,
        status: global___ProvisioningResponse.ProvisioningStatus.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["device_certificate", b"device_certificate", "device_rsa_key", b"device_rsa_key", "device_rsa_key_iv", b"device_rsa_key_iv", "nonce", b"nonce", "ota_keybox", b"ota_keybox", "status", b"status", "wrapping_key", b"wrapping_key"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["device_certificate", b"device_certificate", "device_rsa_key", b"device_rsa_key", "device_rsa_key_iv", b"device_rsa_key_iv", "nonce", b"nonce", "ota_keybox", b"ota_keybox", "status", b"status", "wrapping_key", b"wrapping_key"]) -> None: ...

global___ProvisioningResponse = ProvisioningResponse

@typing.final
class SignedProvisioningContext(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVISIONING_CONTEXT_FIELD_NUMBER: builtins.int
    SIGNATURE_FIELD_NUMBER: builtins.int
    provisioning_context: builtins.bytes
    """ProvisioningContext in bytes."""
    signature: builtins.bytes
    """RSASSA-PSS signature of provisioning_context. Signed with service private
    key.
    """
    def __init__(
        self,
        *,
        provisioning_context: builtins.bytes | None = ...,
        signature: builtins.bytes | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["provisioning_context", b"provisioning_context", "signature", b"signature"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["provisioning_context", b"provisioning_context", "signature", b"signature"]) -> None: ...

global___SignedProvisioningContext = SignedProvisioningContext

@typing.final
class SignedProvisioningMessage(google.protobuf.message.Message):
    """Serialized ProvisioningRequest or ProvisioningResponse signed with
    The message authentication key.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ProvisioningProtocolVersion:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ProvisioningProtocolVersionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SignedProvisioningMessage._ProvisioningProtocolVersion.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        VERSION_UNSPECIFIED: SignedProvisioningMessage._ProvisioningProtocolVersion.ValueType  # 0
        VERSION_1: SignedProvisioningMessage._ProvisioningProtocolVersion.ValueType  # 1
        VERSION_1_1: SignedProvisioningMessage._ProvisioningProtocolVersion.ValueType  # 2
        """Version 1.1 changed error handling. Some errors are returned as a field
        in a response message rather than being handled as errors via the API
        implementation. E.g. embedded in the ProvisioningResponse rather than
        returning a 400 error to the caller.
        """
        VERSION_2: SignedProvisioningMessage._ProvisioningProtocolVersion.ValueType  # 3
        """Version 2 will implement a larger change of the protocol definition
        in protobufs. This will provide a cleaner separation between protocols.
        """

    class ProvisioningProtocolVersion(_ProvisioningProtocolVersion, metaclass=_ProvisioningProtocolVersionEnumTypeWrapper): ...
    VERSION_UNSPECIFIED: SignedProvisioningMessage.ProvisioningProtocolVersion.ValueType  # 0
    VERSION_1: SignedProvisioningMessage.ProvisioningProtocolVersion.ValueType  # 1
    VERSION_1_1: SignedProvisioningMessage.ProvisioningProtocolVersion.ValueType  # 2
    """Version 1.1 changed error handling. Some errors are returned as a field
    in a response message rather than being handled as errors via the API
    implementation. E.g. embedded in the ProvisioningResponse rather than
    returning a 400 error to the caller.
    """
    VERSION_2: SignedProvisioningMessage.ProvisioningProtocolVersion.ValueType  # 3
    """Version 2 will implement a larger change of the protocol definition
    in protobufs. This will provide a cleaner separation between protocols.
    """

    class _ProvisioningType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ProvisioningTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SignedProvisioningMessage._ProvisioningType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PROVISIONING_TYPE_UNSPECIFIED: SignedProvisioningMessage._ProvisioningType.ValueType  # 0
        SERVICE_CERTIFICATE_REQUEST: SignedProvisioningMessage._ProvisioningType.ValueType  # 1
        """Service certificate request."""
        PROVISIONING_20: SignedProvisioningMessage._ProvisioningType.ValueType  # 2
        """Keybox factory-provisioned devices."""
        PROVISIONING_30: SignedProvisioningMessage._ProvisioningType.ValueType  # 3
        """OEM certificate factory-provisioned devices."""
        ARCPP_PROVISIONING: SignedProvisioningMessage._ProvisioningType.ValueType  # 4
        """ChromeOS/Arc++ devices."""
        INTEL_SIGMA_101: SignedProvisioningMessage._ProvisioningType.ValueType  # 101
        """Intel Sigma 1.0.1 protocol."""

    class ProvisioningType(_ProvisioningType, metaclass=_ProvisioningTypeEnumTypeWrapper):
        """This enum was renamed to avoid confusion"""

    PROVISIONING_TYPE_UNSPECIFIED: SignedProvisioningMessage.ProvisioningType.ValueType  # 0
    SERVICE_CERTIFICATE_REQUEST: SignedProvisioningMessage.ProvisioningType.ValueType  # 1
    """Service certificate request."""
    PROVISIONING_20: SignedProvisioningMessage.ProvisioningType.ValueType  # 2
    """Keybox factory-provisioned devices."""
    PROVISIONING_30: SignedProvisioningMessage.ProvisioningType.ValueType  # 3
    """OEM certificate factory-provisioned devices."""
    ARCPP_PROVISIONING: SignedProvisioningMessage.ProvisioningType.ValueType  # 4
    """ChromeOS/Arc++ devices."""
    INTEL_SIGMA_101: SignedProvisioningMessage.ProvisioningType.ValueType  # 101
    """Intel Sigma 1.0.1 protocol."""

    MESSAGE_FIELD_NUMBER: builtins.int
    SIGNATURE_FIELD_NUMBER: builtins.int
    PROVISIONING_TYPE_FIELD_NUMBER: builtins.int
    SIGNED_PROVISIONING_CONTEXT_FIELD_NUMBER: builtins.int
    REMOTE_ATTESTATION_FIELD_NUMBER: builtins.int
    OEMCRYPTO_CORE_MESSAGE_FIELD_NUMBER: builtins.int
    HASH_ALGORITHM_FIELD_NUMBER: builtins.int
    PROTOCOL_VERSION_FIELD_NUMBER: builtins.int
    message: builtins.bytes
    """Serialized protobuf message for the corresponding protocol and stage of
    the provisioning exchange. ProvisioningRequest or ProvisioningResponse
    in the case of Provisioning 2.0, 3.0 and ARCPP_PROVISIONING. Required.
    """
    signature: builtins.bytes
    """HMAC-SHA256 (Keybox) or RSASSA-PSS (OEM) signature of message. Required
    for provisioning 2.0 and 3.0. For ARCPP_PROVISIONING, only used in
    response.
    """
    provisioning_type: global___SignedProvisioningMessage.ProvisioningType.ValueType
    """Version number of provisioning protocol."""
    remote_attestation: builtins.bytes
    """Remote attestation data to authenticate that the ChromeOS client device
    is operating in verified mode. Remote attestation challenge data is
    |message| field above. Required for ARCPP_PROVISIONING request.
    It contains signature of |message|.
    """
    oemcrypto_core_message: builtins.bytes
    """The core message is the simple serialization of fields used by OEMCrypto.
    This field was introduced in OEMCrypto API v16. The core message format is
    documented in the "Widevine Core Message Serialization".
    """
    hash_algorithm: global___HashAlgorithmProto.ValueType
    """Optional field that indicates the hash algorithm used in signature scheme."""
    protocol_version: global___SignedProvisioningMessage.ProvisioningProtocolVersion.ValueType
    """Indicates which version of the protocol is in use."""
    @property
    def signed_provisioning_context(self) -> global___SignedProvisioningContext:
        """Protocol-specific context / state information for multiple-exchange,
        stateful provisioning protocols.  Optional.
        """

    def __init__(
        self,
        *,
        message: builtins.bytes | None = ...,
        signature: builtins.bytes | None = ...,
        provisioning_type: global___SignedProvisioningMessage.ProvisioningType.ValueType | None = ...,
        signed_provisioning_context: global___SignedProvisioningContext | None = ...,
        remote_attestation: builtins.bytes | None = ...,
        oemcrypto_core_message: builtins.bytes | None = ...,
        hash_algorithm: global___HashAlgorithmProto.ValueType | None = ...,
        protocol_version: global___SignedProvisioningMessage.ProvisioningProtocolVersion.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["hash_algorithm", b"hash_algorithm", "message", b"message", "oemcrypto_core_message", b"oemcrypto_core_message", "protocol_version", b"protocol_version", "provisioning_type", b"provisioning_type", "remote_attestation", b"remote_attestation", "signature", b"signature", "signed_provisioning_context", b"signed_provisioning_context"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["hash_algorithm", b"hash_algorithm", "message", b"message", "oemcrypto_core_message", b"oemcrypto_core_message", "protocol_version", b"protocol_version", "provisioning_type", b"provisioning_type", "remote_attestation", b"remote_attestation", "signature", b"signature", "signed_provisioning_context", b"signed_provisioning_context"]) -> None: ...

global___SignedProvisioningMessage = SignedProvisioningMessage

@typing.final
class ClientIdentification(google.protobuf.message.Message):
    """----------------------------------------------------------------------------
    client_identification.proto
    ----------------------------------------------------------------------------
    Description of section:
      ClientIdentification messages used by provisioning and license protocols.

    ClientIdentification message used to authenticate the client device.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _TokenType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TokenTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ClientIdentification._TokenType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        KEYBOX: ClientIdentification._TokenType.ValueType  # 0
        DRM_DEVICE_CERTIFICATE: ClientIdentification._TokenType.ValueType  # 1
        REMOTE_ATTESTATION_CERTIFICATE: ClientIdentification._TokenType.ValueType  # 2
        OEM_DEVICE_CERTIFICATE: ClientIdentification._TokenType.ValueType  # 3

    class TokenType(_TokenType, metaclass=_TokenTypeEnumTypeWrapper): ...
    KEYBOX: ClientIdentification.TokenType.ValueType  # 0
    DRM_DEVICE_CERTIFICATE: ClientIdentification.TokenType.ValueType  # 1
    REMOTE_ATTESTATION_CERTIFICATE: ClientIdentification.TokenType.ValueType  # 2
    OEM_DEVICE_CERTIFICATE: ClientIdentification.TokenType.ValueType  # 3

    @typing.final
    class NameValue(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        name: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            name: builtins.str | None = ...,
            value: builtins.str | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["name", b"name", "value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["name", b"name", "value", b"value"]) -> None: ...

    @typing.final
    class ClientCapabilities(google.protobuf.message.Message):
        """Capabilities which not all clients may support. Used for the license
        exchange protocol only.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _HdcpVersion:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _HdcpVersionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ClientIdentification.ClientCapabilities._HdcpVersion.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            HDCP_NONE: ClientIdentification.ClientCapabilities._HdcpVersion.ValueType  # 0
            HDCP_V1: ClientIdentification.ClientCapabilities._HdcpVersion.ValueType  # 1
            HDCP_V2: ClientIdentification.ClientCapabilities._HdcpVersion.ValueType  # 2
            HDCP_V2_1: ClientIdentification.ClientCapabilities._HdcpVersion.ValueType  # 3
            HDCP_V2_2: ClientIdentification.ClientCapabilities._HdcpVersion.ValueType  # 4
            HDCP_V2_3: ClientIdentification.ClientCapabilities._HdcpVersion.ValueType  # 5
            HDCP_NO_DIGITAL_OUTPUT: ClientIdentification.ClientCapabilities._HdcpVersion.ValueType  # 255

        class HdcpVersion(_HdcpVersion, metaclass=_HdcpVersionEnumTypeWrapper): ...
        HDCP_NONE: ClientIdentification.ClientCapabilities.HdcpVersion.ValueType  # 0
        HDCP_V1: ClientIdentification.ClientCapabilities.HdcpVersion.ValueType  # 1
        HDCP_V2: ClientIdentification.ClientCapabilities.HdcpVersion.ValueType  # 2
        HDCP_V2_1: ClientIdentification.ClientCapabilities.HdcpVersion.ValueType  # 3
        HDCP_V2_2: ClientIdentification.ClientCapabilities.HdcpVersion.ValueType  # 4
        HDCP_V2_3: ClientIdentification.ClientCapabilities.HdcpVersion.ValueType  # 5
        HDCP_NO_DIGITAL_OUTPUT: ClientIdentification.ClientCapabilities.HdcpVersion.ValueType  # 255

        class _CertificateKeyType:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _CertificateKeyTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ClientIdentification.ClientCapabilities._CertificateKeyType.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            RSA_2048: ClientIdentification.ClientCapabilities._CertificateKeyType.ValueType  # 0
            RSA_3072: ClientIdentification.ClientCapabilities._CertificateKeyType.ValueType  # 1
            ECC_SECP256R1: ClientIdentification.ClientCapabilities._CertificateKeyType.ValueType  # 2
            ECC_SECP384R1: ClientIdentification.ClientCapabilities._CertificateKeyType.ValueType  # 3
            ECC_SECP521R1: ClientIdentification.ClientCapabilities._CertificateKeyType.ValueType  # 4

        class CertificateKeyType(_CertificateKeyType, metaclass=_CertificateKeyTypeEnumTypeWrapper): ...
        RSA_2048: ClientIdentification.ClientCapabilities.CertificateKeyType.ValueType  # 0
        RSA_3072: ClientIdentification.ClientCapabilities.CertificateKeyType.ValueType  # 1
        ECC_SECP256R1: ClientIdentification.ClientCapabilities.CertificateKeyType.ValueType  # 2
        ECC_SECP384R1: ClientIdentification.ClientCapabilities.CertificateKeyType.ValueType  # 3
        ECC_SECP521R1: ClientIdentification.ClientCapabilities.CertificateKeyType.ValueType  # 4

        class _AnalogOutputCapabilities:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _AnalogOutputCapabilitiesEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ClientIdentification.ClientCapabilities._AnalogOutputCapabilities.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            ANALOG_OUTPUT_UNKNOWN: ClientIdentification.ClientCapabilities._AnalogOutputCapabilities.ValueType  # 0
            ANALOG_OUTPUT_NONE: ClientIdentification.ClientCapabilities._AnalogOutputCapabilities.ValueType  # 1
            ANALOG_OUTPUT_SUPPORTED: ClientIdentification.ClientCapabilities._AnalogOutputCapabilities.ValueType  # 2
            ANALOG_OUTPUT_SUPPORTS_CGMS_A: ClientIdentification.ClientCapabilities._AnalogOutputCapabilities.ValueType  # 3

        class AnalogOutputCapabilities(_AnalogOutputCapabilities, metaclass=_AnalogOutputCapabilitiesEnumTypeWrapper): ...
        ANALOG_OUTPUT_UNKNOWN: ClientIdentification.ClientCapabilities.AnalogOutputCapabilities.ValueType  # 0
        ANALOG_OUTPUT_NONE: ClientIdentification.ClientCapabilities.AnalogOutputCapabilities.ValueType  # 1
        ANALOG_OUTPUT_SUPPORTED: ClientIdentification.ClientCapabilities.AnalogOutputCapabilities.ValueType  # 2
        ANALOG_OUTPUT_SUPPORTS_CGMS_A: ClientIdentification.ClientCapabilities.AnalogOutputCapabilities.ValueType  # 3

        class _WatermarkingSupport:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _WatermarkingSupportEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ClientIdentification.ClientCapabilities._WatermarkingSupport.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            WATERMARKING_SUPPORT_UNKNOWN: ClientIdentification.ClientCapabilities._WatermarkingSupport.ValueType  # 0
            WATERMARKING_NOT_SUPPORTED: ClientIdentification.ClientCapabilities._WatermarkingSupport.ValueType  # 1
            WATERMARKING_CONFIGURABLE: ClientIdentification.ClientCapabilities._WatermarkingSupport.ValueType  # 2
            WATERMARKING_ALWAYS_ON: ClientIdentification.ClientCapabilities._WatermarkingSupport.ValueType  # 3

        class WatermarkingSupport(_WatermarkingSupport, metaclass=_WatermarkingSupportEnumTypeWrapper): ...
        WATERMARKING_SUPPORT_UNKNOWN: ClientIdentification.ClientCapabilities.WatermarkingSupport.ValueType  # 0
        WATERMARKING_NOT_SUPPORTED: ClientIdentification.ClientCapabilities.WatermarkingSupport.ValueType  # 1
        WATERMARKING_CONFIGURABLE: ClientIdentification.ClientCapabilities.WatermarkingSupport.ValueType  # 2
        WATERMARKING_ALWAYS_ON: ClientIdentification.ClientCapabilities.WatermarkingSupport.ValueType  # 3

        CLIENT_TOKEN_FIELD_NUMBER: builtins.int
        SESSION_TOKEN_FIELD_NUMBER: builtins.int
        VIDEO_RESOLUTION_CONSTRAINTS_FIELD_NUMBER: builtins.int
        MAX_HDCP_VERSION_FIELD_NUMBER: builtins.int
        OEM_CRYPTO_API_VERSION_FIELD_NUMBER: builtins.int
        ANTI_ROLLBACK_USAGE_TABLE_FIELD_NUMBER: builtins.int
        SRM_VERSION_FIELD_NUMBER: builtins.int
        CAN_UPDATE_SRM_FIELD_NUMBER: builtins.int
        SUPPORTED_CERTIFICATE_KEY_TYPE_FIELD_NUMBER: builtins.int
        ANALOG_OUTPUT_CAPABILITIES_FIELD_NUMBER: builtins.int
        CAN_DISABLE_ANALOG_OUTPUT_FIELD_NUMBER: builtins.int
        RESOURCE_RATING_TIER_FIELD_NUMBER: builtins.int
        WATERMARKING_SUPPORT_FIELD_NUMBER: builtins.int
        INITIAL_RENEWAL_DELAY_BASE_FIELD_NUMBER: builtins.int
        client_token: builtins.bool
        session_token: builtins.bool
        video_resolution_constraints: builtins.bool
        max_hdcp_version: global___ClientIdentification.ClientCapabilities.HdcpVersion.ValueType
        oem_crypto_api_version: builtins.int
        anti_rollback_usage_table: builtins.bool
        """Client has hardware support for protecting the usage table, such as
        storing the generation number in secure memory.  For Details, see:
        Widevine Modular DRM Security Integration Guide for CENC
        """
        srm_version: builtins.int
        """The client shall report |srm_version| if available."""
        can_update_srm: builtins.bool
        """A device may have SRM data, and report a version, but may not be capable
        of updating SRM data.
        """
        analog_output_capabilities: global___ClientIdentification.ClientCapabilities.AnalogOutputCapabilities.ValueType
        can_disable_analog_output: builtins.bool
        resource_rating_tier: builtins.int
        """Clients can indicate a performance level supported by OEMCrypto.
        This will allow applications and providers to choose an appropriate
        quality of content to serve. Currently defined tiers are
        1 (low), 2 (medium) and 3 (high). Any other value indicates that
        the resource rating is unavailable or reporting erroneous values
        for that device. For details see,
        Widevine Modular DRM Security Integration Guide for CENC
        """
        watermarking_support: global___ClientIdentification.ClientCapabilities.WatermarkingSupport.ValueType
        initial_renewal_delay_base: builtins.bool
        @property
        def supported_certificate_key_type(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___ClientIdentification.ClientCapabilities.CertificateKeyType.ValueType]: ...
        def __init__(
            self,
            *,
            client_token: builtins.bool | None = ...,
            session_token: builtins.bool | None = ...,
            video_resolution_constraints: builtins.bool | None = ...,
            max_hdcp_version: global___ClientIdentification.ClientCapabilities.HdcpVersion.ValueType | None = ...,
            oem_crypto_api_version: builtins.int | None = ...,
            anti_rollback_usage_table: builtins.bool | None = ...,
            srm_version: builtins.int | None = ...,
            can_update_srm: builtins.bool | None = ...,
            supported_certificate_key_type: collections.abc.Iterable[global___ClientIdentification.ClientCapabilities.CertificateKeyType.ValueType] | None = ...,
            analog_output_capabilities: global___ClientIdentification.ClientCapabilities.AnalogOutputCapabilities.ValueType | None = ...,
            can_disable_analog_output: builtins.bool | None = ...,
            resource_rating_tier: builtins.int | None = ...,
            watermarking_support: global___ClientIdentification.ClientCapabilities.WatermarkingSupport.ValueType | None = ...,
            initial_renewal_delay_base: builtins.bool | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["analog_output_capabilities", b"analog_output_capabilities", "anti_rollback_usage_table", b"anti_rollback_usage_table", "can_disable_analog_output", b"can_disable_analog_output", "can_update_srm", b"can_update_srm", "client_token", b"client_token", "initial_renewal_delay_base", b"initial_renewal_delay_base", "max_hdcp_version", b"max_hdcp_version", "oem_crypto_api_version", b"oem_crypto_api_version", "resource_rating_tier", b"resource_rating_tier", "session_token", b"session_token", "srm_version", b"srm_version", "video_resolution_constraints", b"video_resolution_constraints", "watermarking_support", b"watermarking_support"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["analog_output_capabilities", b"analog_output_capabilities", "anti_rollback_usage_table", b"anti_rollback_usage_table", "can_disable_analog_output", b"can_disable_analog_output", "can_update_srm", b"can_update_srm", "client_token", b"client_token", "initial_renewal_delay_base", b"initial_renewal_delay_base", "max_hdcp_version", b"max_hdcp_version", "oem_crypto_api_version", b"oem_crypto_api_version", "resource_rating_tier", b"resource_rating_tier", "session_token", b"session_token", "srm_version", b"srm_version", "supported_certificate_key_type", b"supported_certificate_key_type", "video_resolution_constraints", b"video_resolution_constraints", "watermarking_support", b"watermarking_support"]) -> None: ...

    @typing.final
    class ClientCredentials(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        TYPE_FIELD_NUMBER: builtins.int
        TOKEN_FIELD_NUMBER: builtins.int
        type: global___ClientIdentification.TokenType.ValueType
        token: builtins.bytes
        def __init__(
            self,
            *,
            type: global___ClientIdentification.TokenType.ValueType | None = ...,
            token: builtins.bytes | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["token", b"token", "type", b"type"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["token", b"token", "type", b"type"]) -> None: ...

    TYPE_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    CLIENT_INFO_FIELD_NUMBER: builtins.int
    PROVIDER_CLIENT_TOKEN_FIELD_NUMBER: builtins.int
    LICENSE_COUNTER_FIELD_NUMBER: builtins.int
    CLIENT_CAPABILITIES_FIELD_NUMBER: builtins.int
    VMP_DATA_FIELD_NUMBER: builtins.int
    DEVICE_CREDENTIALS_FIELD_NUMBER: builtins.int
    type: global___ClientIdentification.TokenType.ValueType
    """Type of factory-provisioned device root of trust. Optional."""
    token: builtins.bytes
    """Factory-provisioned device root of trust. Required."""
    provider_client_token: builtins.bytes
    """Client token generated by the content provider. Optional."""
    license_counter: builtins.int
    """Number of licenses received by the client to which the token above belongs.
    Only present if client_token is specified.
    """
    vmp_data: builtins.bytes
    """Serialized VmpData message. Optional."""
    @property
    def client_info(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ClientIdentification.NameValue]:
        """Optional client information name/value pairs."""

    @property
    def client_capabilities(self) -> global___ClientIdentification.ClientCapabilities:
        """List of non-baseline client capabilities."""

    @property
    def device_credentials(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ClientIdentification.ClientCredentials]:
        """Optional field that may contain additional provisioning credentials."""

    def __init__(
        self,
        *,
        type: global___ClientIdentification.TokenType.ValueType | None = ...,
        token: builtins.bytes | None = ...,
        client_info: collections.abc.Iterable[global___ClientIdentification.NameValue] | None = ...,
        provider_client_token: builtins.bytes | None = ...,
        license_counter: builtins.int | None = ...,
        client_capabilities: global___ClientIdentification.ClientCapabilities | None = ...,
        vmp_data: builtins.bytes | None = ...,
        device_credentials: collections.abc.Iterable[global___ClientIdentification.ClientCredentials] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["client_capabilities", b"client_capabilities", "license_counter", b"license_counter", "provider_client_token", b"provider_client_token", "token", b"token", "type", b"type", "vmp_data", b"vmp_data"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["client_capabilities", b"client_capabilities", "client_info", b"client_info", "device_credentials", b"device_credentials", "license_counter", b"license_counter", "provider_client_token", b"provider_client_token", "token", b"token", "type", b"type", "vmp_data", b"vmp_data"]) -> None: ...

global___ClientIdentification = ClientIdentification

@typing.final
class EncryptedClientIdentification(google.protobuf.message.Message):
    """EncryptedClientIdentification message used to hold ClientIdentification
    messages encrypted for privacy purposes.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROVIDER_ID_FIELD_NUMBER: builtins.int
    SERVICE_CERTIFICATE_SERIAL_NUMBER_FIELD_NUMBER: builtins.int
    ENCRYPTED_CLIENT_ID_FIELD_NUMBER: builtins.int
    ENCRYPTED_CLIENT_ID_IV_FIELD_NUMBER: builtins.int
    ENCRYPTED_PRIVACY_KEY_FIELD_NUMBER: builtins.int
    provider_id: builtins.str
    """Provider ID for which the ClientIdentifcation is encrypted (owner of
    service certificate).
    """
    service_certificate_serial_number: builtins.bytes
    """Serial number for the service certificate for which ClientIdentification is
    encrypted.
    """
    encrypted_client_id: builtins.bytes
    """Serialized ClientIdentification message, encrypted with the privacy key
    using AES-128-CBC with PKCS#5 padding.
    """
    encrypted_client_id_iv: builtins.bytes
    """Initialization vector needed to decrypt encrypted_client_id."""
    encrypted_privacy_key: builtins.bytes
    """AES-128 privacy key, encrypted with the service public key using RSA-OAEP."""
    def __init__(
        self,
        *,
        provider_id: builtins.str | None = ...,
        service_certificate_serial_number: builtins.bytes | None = ...,
        encrypted_client_id: builtins.bytes | None = ...,
        encrypted_client_id_iv: builtins.bytes | None = ...,
        encrypted_privacy_key: builtins.bytes | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["encrypted_client_id", b"encrypted_client_id", "encrypted_client_id_iv", b"encrypted_client_id_iv", "encrypted_privacy_key", b"encrypted_privacy_key", "provider_id", b"provider_id", "service_certificate_serial_number", b"service_certificate_serial_number"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["encrypted_client_id", b"encrypted_client_id", "encrypted_client_id_iv", b"encrypted_client_id_iv", "encrypted_privacy_key", b"encrypted_privacy_key", "provider_id", b"provider_id", "service_certificate_serial_number", b"service_certificate_serial_number"]) -> None: ...

global___EncryptedClientIdentification = EncryptedClientIdentification

@typing.final
class DrmCertificate(google.protobuf.message.Message):
    """----------------------------------------------------------------------------
    drm_certificate.proto
    ----------------------------------------------------------------------------
    Description of section:
    Definition of the root of trust identifier proto. The proto message contains
    the EC-IES encrypted identifier (e.g. keybox unique id) for a device and
    an associated hash. These can be used by Widevine to identify the root of
    trust that was used to acquire a DRM certificate.

    In addition to the encrypted part and the hash, the proto contains the
    version of the root of trust id which implies the EC key algorithm that was
    used.

    DRM certificate definition for user devices, intermediate, service, and root
    certificates.
    Next id: 13
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Type:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DrmCertificate._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ROOT: DrmCertificate._Type.ValueType  # 0
        """ProtoBestPractices: ignore."""
        DEVICE_MODEL: DrmCertificate._Type.ValueType  # 1
        DEVICE: DrmCertificate._Type.ValueType  # 2
        SERVICE: DrmCertificate._Type.ValueType  # 3
        PROVISIONER: DrmCertificate._Type.ValueType  # 4

    class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
    ROOT: DrmCertificate.Type.ValueType  # 0
    """ProtoBestPractices: ignore."""
    DEVICE_MODEL: DrmCertificate.Type.ValueType  # 1
    DEVICE: DrmCertificate.Type.ValueType  # 2
    SERVICE: DrmCertificate.Type.ValueType  # 3
    PROVISIONER: DrmCertificate.Type.ValueType  # 4

    class _ServiceType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ServiceTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DrmCertificate._ServiceType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN_SERVICE_TYPE: DrmCertificate._ServiceType.ValueType  # 0
        LICENSE_SERVER_SDK: DrmCertificate._ServiceType.ValueType  # 1
        LICENSE_SERVER_PROXY_SDK: DrmCertificate._ServiceType.ValueType  # 2
        PROVISIONING_SDK: DrmCertificate._ServiceType.ValueType  # 3
        CAS_PROXY_SDK: DrmCertificate._ServiceType.ValueType  # 4

    class ServiceType(_ServiceType, metaclass=_ServiceTypeEnumTypeWrapper): ...
    UNKNOWN_SERVICE_TYPE: DrmCertificate.ServiceType.ValueType  # 0
    LICENSE_SERVER_SDK: DrmCertificate.ServiceType.ValueType  # 1
    LICENSE_SERVER_PROXY_SDK: DrmCertificate.ServiceType.ValueType  # 2
    PROVISIONING_SDK: DrmCertificate.ServiceType.ValueType  # 3
    CAS_PROXY_SDK: DrmCertificate.ServiceType.ValueType  # 4

    class _Algorithm:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _AlgorithmEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DrmCertificate._Algorithm.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        UNKNOWN_ALGORITHM: DrmCertificate._Algorithm.ValueType  # 0
        RSA: DrmCertificate._Algorithm.ValueType  # 1
        ECC_SECP256R1: DrmCertificate._Algorithm.ValueType  # 2
        ECC_SECP384R1: DrmCertificate._Algorithm.ValueType  # 3
        ECC_SECP521R1: DrmCertificate._Algorithm.ValueType  # 4

    class Algorithm(_Algorithm, metaclass=_AlgorithmEnumTypeWrapper): ...
    UNKNOWN_ALGORITHM: DrmCertificate.Algorithm.ValueType  # 0
    RSA: DrmCertificate.Algorithm.ValueType  # 1
    ECC_SECP256R1: DrmCertificate.Algorithm.ValueType  # 2
    ECC_SECP384R1: DrmCertificate.Algorithm.ValueType  # 3
    ECC_SECP521R1: DrmCertificate.Algorithm.ValueType  # 4

    @typing.final
    class EncryptionKey(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        PUBLIC_KEY_FIELD_NUMBER: builtins.int
        ALGORITHM_FIELD_NUMBER: builtins.int
        public_key: builtins.bytes
        """Device public key. PKCS#1 ASN.1 DER-encoded. Required."""
        algorithm: global___DrmCertificate.Algorithm.ValueType
        """Required. The algorithm field contains the curve used to create the
        |public_key| if algorithm is one of the ECC types.
        The |algorithm| is used for both to determine the if the certificate is
        ECC or RSA. The |algorithm| also specifies the parameters that were used
        to create |public_key| and are used to create an ephemeral session key.
        """
        def __init__(
            self,
            *,
            public_key: builtins.bytes | None = ...,
            algorithm: global___DrmCertificate.Algorithm.ValueType | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing.Literal["algorithm", b"algorithm", "public_key", b"public_key"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing.Literal["algorithm", b"algorithm", "public_key", b"public_key"]) -> None: ...

    TYPE_FIELD_NUMBER: builtins.int
    SERIAL_NUMBER_FIELD_NUMBER: builtins.int
    CREATION_TIME_SECONDS_FIELD_NUMBER: builtins.int
    EXPIRATION_TIME_SECONDS_FIELD_NUMBER: builtins.int
    PUBLIC_KEY_FIELD_NUMBER: builtins.int
    SYSTEM_ID_FIELD_NUMBER: builtins.int
    TEST_DEVICE_DEPRECATED_FIELD_NUMBER: builtins.int
    PROVIDER_ID_FIELD_NUMBER: builtins.int
    SERVICE_TYPES_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    ROT_ID_FIELD_NUMBER: builtins.int
    ENCRYPTION_KEY_FIELD_NUMBER: builtins.int
    type: global___DrmCertificate.Type.ValueType
    """Type of certificate. Required."""
    serial_number: builtins.bytes
    """128-bit globally unique serial number of certificate.
    Value is 0 for root certificate. Required.
    """
    creation_time_seconds: builtins.int
    """POSIX time, in seconds, when the certificate was created. Required."""
    expiration_time_seconds: builtins.int
    """POSIX time, in seconds, when the certificate should expire. Value of zero
    denotes indefinite expiry time. For more information on limited lifespan
    DRM certificates see (go/limited-lifespan-drm-certificates).
    """
    public_key: builtins.bytes
    """Device public key. PKCS#1 ASN.1 DER-encoded. Required."""
    system_id: builtins.int
    """Widevine system ID for the device. Required for intermediate and
    user device certificates.
    """
    test_device_deprecated: builtins.bool
    """Deprecated field, which used to indicate whether the device was a test
    (non-production) device. The test_device field in ProvisionedDeviceInfo
    below should be observed instead.
    """
    provider_id: builtins.str
    """Service identifier (web origin) for the provider which owns the
    certificate. Required for service and provisioner certificates.
    """
    algorithm: global___DrmCertificate.Algorithm.ValueType
    """Required. The algorithm field contains the curve used to create the
    |public_key| if algorithm is one of the ECC types.
    The |algorithm| is used for both to determine the if the certificate is ECC
    or RSA. The |algorithm| also specifies the parameters that were used to
    create |public_key| and are used to create an ephemeral session key.
    """
    rot_id: builtins.bytes
    """Optional. May be present in DEVICE certificate types. This is the root
    of trust identifier that holds an encrypted value that identifies the
    keybox or other root of trust that was used to provision a DEVICE drm
    certificate.
    """
    @property
    def service_types(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[global___DrmCertificate.ServiceType.ValueType]:
        """This field is used only when type = SERVICE to specify which SDK uses
        service certificate. This repeated field is treated as a set. A certificate
        may be used for the specified service SDK if the appropriate ServiceType
        is specified in this field.
        """

    @property
    def encryption_key(self) -> global___DrmCertificate.EncryptionKey:
        """Optional. May be present in devices that explicitly support dual keys. When
        present the |public_key| is used for verification of received license
        request messages.
        """

    def __init__(
        self,
        *,
        type: global___DrmCertificate.Type.ValueType | None = ...,
        serial_number: builtins.bytes | None = ...,
        creation_time_seconds: builtins.int | None = ...,
        expiration_time_seconds: builtins.int | None = ...,
        public_key: builtins.bytes | None = ...,
        system_id: builtins.int | None = ...,
        test_device_deprecated: builtins.bool | None = ...,
        provider_id: builtins.str | None = ...,
        service_types: collections.abc.Iterable[global___DrmCertificate.ServiceType.ValueType] | None = ...,
        algorithm: global___DrmCertificate.Algorithm.ValueType | None = ...,
        rot_id: builtins.bytes | None = ...,
        encryption_key: global___DrmCertificate.EncryptionKey | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["algorithm", b"algorithm", "creation_time_seconds", b"creation_time_seconds", "encryption_key", b"encryption_key", "expiration_time_seconds", b"expiration_time_seconds", "provider_id", b"provider_id", "public_key", b"public_key", "rot_id", b"rot_id", "serial_number", b"serial_number", "system_id", b"system_id", "test_device_deprecated", b"test_device_deprecated", "type", b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["algorithm", b"algorithm", "creation_time_seconds", b"creation_time_seconds", "encryption_key", b"encryption_key", "expiration_time_seconds", b"expiration_time_seconds", "provider_id", b"provider_id", "public_key", b"public_key", "rot_id", b"rot_id", "serial_number", b"serial_number", "service_types", b"service_types", "system_id", b"system_id", "test_device_deprecated", b"test_device_deprecated", "type", b"type"]) -> None: ...

global___DrmCertificate = DrmCertificate

@typing.final
class SignedDrmCertificate(google.protobuf.message.Message):
    """----------------------------------------------------------------------------
    signed_drm_certificate.proto
    ----------------------------------------------------------------------------
    Description of section:
    DrmCertificate signed by a higher (CA) DRM certificate.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DRM_CERTIFICATE_FIELD_NUMBER: builtins.int
    SIGNATURE_FIELD_NUMBER: builtins.int
    SIGNER_FIELD_NUMBER: builtins.int
    HASH_ALGORITHM_FIELD_NUMBER: builtins.int
    drm_certificate: builtins.bytes
    """Serialized certificate. Required."""
    signature: builtins.bytes
    """Signature of certificate. Signed with root or intermediate
    certificate specified below. Required.
    """
    hash_algorithm: global___HashAlgorithmProto.ValueType
    """Optional field that indicates the hash algorithm used in signature scheme."""
    @property
    def signer(self) -> global___SignedDrmCertificate:
        """SignedDrmCertificate used to sign this certificate."""

    def __init__(
        self,
        *,
        drm_certificate: builtins.bytes | None = ...,
        signature: builtins.bytes | None = ...,
        signer: global___SignedDrmCertificate | None = ...,
        hash_algorithm: global___HashAlgorithmProto.ValueType | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["drm_certificate", b"drm_certificate", "hash_algorithm", b"hash_algorithm", "signature", b"signature", "signer", b"signer"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["drm_certificate", b"drm_certificate", "hash_algorithm", b"hash_algorithm", "signature", b"signature", "signer", b"signer"]) -> None: ...

global___SignedDrmCertificate = SignedDrmCertificate
