# @documentation

Project documentation for tunacode.

## Directory Structure

```
documentation/
├── agent/                  # Agent architecture and workflows
│   ├── TOOLS_WORKFLOW.md
│   ├── agent-inspo.md
│   └── main-agent-architecture.md
├── configuration/         # System configuration docs
│   ├── config-file-example.md
│   └── logging-configuration.md
└── development/          # Development practices
    ├── codebase-hygiene.md
    ├── hatch-build-system.md
    ├── performance-optimizations.md
    └── prompt-principles.md
```

## Purpose

General project documentation for features, architecture, and best practices.

## Quick Links

- [Hatch Build System](development/hatch-build-system.md) - Complete guide to using Hatch for development and building.
- [Configuration File Example](configuration/config-file-example.md) - Complete example of `~/.config/tunacode.json` with all available settings.
- [Performance Optimizations](development/performance-optimizations.md) - Major performance improvements and optimization strategies.
