"""Utilities for implementing choices."""

from nautobot.circuits.choices import CircuitTerminationSideChoices
from nautobot.core.choices import (
    ButtonActionColorChoices,
    ButtonActionIconChoices,
    ChoiceSet,
    ColorChoices,
    unpack_grouped_choices,
)
from nautobot.dcim.choices import (
    CableLengthUnitChoices,
    CableTypeChoices,
    ConsolePortTypeChoices,
    DeviceFaceChoices,
    DeviceRedundancyGroupFailoverStrategyChoices,
    InterfaceModeChoices,
    InterfaceRedundancyGroupProtocolChoices,
    InterfaceTypeChoices,
    PortTypeChoices,
    PowerFeedPhaseChoices,
    PowerFeedSupplyChoices,
    PowerFeedTypeChoices,
    PowerOutletFeedLegChoices,
    PowerOutletTypeChoices,
    PowerPortTypeChoices,
    RackDimensionUnitChoices,
    RackElevationDetailRenderChoices,
    RackTypeChoices,
    RackWidthChoices,
    SubdeviceRoleChoices,
)
from nautobot.extras.choices import (
    BannerClassChoices,
    ButtonClassChoices,
    CustomFieldFilterLogicChoices,
    CustomFieldTypeChoices,
    CustomLinkButtonClassChoices,
    DynamicGroupOperatorChoices,
    JobExecutionType,
    JobResultStatusChoices,
    JobSourceChoices,
    LogLevelChoices,
    ObjectChangeActionChoices,
    ObjectChangeEventContextChoices,
    RelationshipRequiredSideChoices,
    RelationshipSideChoices,
    RelationshipTypeChoices,
    SecretsGroupAccessTypeChoices,
    SecretsGroupSecretTypeChoices,
    WebhookHttpMethodChoices,
)
from nautobot.ipam.choices import (
    IPAddressRoleChoices,
    IPAddressTypeChoices,
    IPAddressVersionChoices,
    PrefixTypeChoices,
    ServiceProtocolChoices,
)


__all__ = (
    "BannerClassChoices",
    "ButtonActionColorChoices",
    "ButtonActionIconChoices",
    "ButtonClassChoices",
    "CableLengthUnitChoices",
    "CableTypeChoices",
    "ChoiceSet",
    "CircuitTerminationSideChoices",
    "ColorChoices",
    "ConsolePortTypeChoices",
    "CustomFieldFilterLogicChoices",
    "CustomFieldTypeChoices",
    "CustomLinkButtonClassChoices",
    "DeviceFaceChoices",
    "DeviceRedundancyGroupFailoverStrategyChoices",
    "DynamicGroupOperatorChoices",
    "InterfaceModeChoices",
    "InterfaceRedundancyGroupProtocolChoices",
    "InterfaceTypeChoices",
    "IPAddressRoleChoices",
    "IPAddressTypeChoices",
    "IPAddressVersionChoices",
    "JobExecutionType",
    "JobResultStatusChoices",
    "JobSourceChoices",
    "LogLevelChoices",
    "ObjectChangeActionChoices",
    "ObjectChangeEventContextChoices",
    "PortTypeChoices",
    "PowerFeedPhaseChoices",
    "PowerFeedSupplyChoices",
    "PowerFeedTypeChoices",
    "PowerOutletFeedLegChoices",
    "PowerOutletTypeChoices",
    "PowerPortTypeChoices",
    "PrefixTypeChoices",
    "RackDimensionUnitChoices",
    "RackElevationDetailRenderChoices",
    "RackTypeChoices",
    "RackWidthChoices",
    "RelationshipRequiredSideChoices",
    "RelationshipSideChoices",
    "RelationshipTypeChoices",
    "SecretsGroupAccessTypeChoices",
    "SecretsGroupSecretTypeChoices",
    "ServiceProtocolChoices",
    "SubdeviceRoleChoices",
    "unpack_grouped_choices",
    "WebhookHttpMethodChoices",
)
