# Generated by Django 3.1.7 on 2021-04-01 06:35

from django.db import migrations, models
import django.db.models.deletion
import nautobot.extras.models.statuses
import taggit.managers


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("tenancy", "0001_initial"),
        ("extras", "0001_initial_part_1"),
        ("circuits", "0001_initial_part_1"),
        ("dcim", "0001_initial_part_1"),
    ]

    operations = [
        migrations.AddField(
            model_name="provider",
            name="tags",
            field=taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag"),
        ),
        migrations.AddField(
            model_name="circuittermination",
            name="_cable_peer_type",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="+",
                to="contenttypes.contenttype",
            ),
        ),
        migrations.AddField(
            model_name="circuittermination",
            name="_path",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="dcim.cablepath"
            ),
        ),
        migrations.AddField(
            model_name="circuittermination",
            name="cable",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name="+", to="dcim.cable"
            ),
        ),
        migrations.AddField(
            model_name="circuittermination",
            name="circuit",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, related_name="terminations", to="circuits.circuit"
            ),
        ),
        migrations.AddField(
            model_name="circuittermination",
            name="site",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, related_name="circuit_terminations", to="dcim.site"
            ),
        ),
        migrations.AddField(
            model_name="circuit",
            name="provider",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, related_name="circuits", to="circuits.provider"
            ),
        ),
        migrations.AddField(
            model_name="circuit",
            name="status",
            field=nautobot.extras.models.statuses.StatusField(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="circuits_circuit_related",
                to="extras.status",
            ),
        ),
        migrations.AddField(
            model_name="circuit",
            name="tags",
            field=taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag"),
        ),
        migrations.AddField(
            model_name="circuit",
            name="tenant",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="circuits",
                to="tenancy.tenant",
            ),
        ),
        migrations.AddField(
            model_name="circuit",
            name="type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, related_name="circuits", to="circuits.circuittype"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="circuittermination",
            unique_together={("circuit", "term_side")},
        ),
        migrations.AlterUniqueTogether(
            name="circuit",
            unique_together={("provider", "cid")},
        ),
    ]
