# Generated by Django 3.2.16 on 2022-11-23 12:27

from django.db import migrations
from nautobot.extras.utils import migrate_role_data
from nautobot.ipam.choices import IPAddressRoleChoices


def migrate_data_from_legacy_role_to_new_role(apps, schema):
    """Migrate VLAN/Prefix/IPAddress data from legacy_role to new_role."""
    to_role_model = apps.get_model("extras", "Role")
    ipam_role_model = apps.get_model("ipam", "Role")
    for model_to_migrate, from_role_model, from_role_choiceset in [
        (apps.get_model("ipam", "VLAN"), ipam_role_model, None),
        (apps.get_model("ipam", "Prefix"), ipam_role_model, None),
        (apps.get_model("ipam", "IPAddress"), None, IPAddressRoleChoices),
    ]:
        migrate_role_data(
            model_to_migrate=model_to_migrate,
            from_role_field_name="legacy_role",
            from_role_model=from_role_model,
            to_role_field_name="new_role",
            from_role_choiceset=from_role_choiceset,
            to_role_model=to_role_model,
        )


def migrate_data_from_new_role_to_legacy_role(apps, schema):
    """Migrate VLAN/Prefix/IPAddress data from new_role to legacy_role."""
    to_role_model = apps.get_model("extras", "Role")
    ipam_role_model = apps.get_model("ipam", "Role")
    for model_to_migrate, from_role_model, from_role_choiceset in [
        (apps.get_model("ipam", "VLAN"), ipam_role_model, None),
        (apps.get_model("ipam", "Prefix"), ipam_role_model, None),
        (apps.get_model("ipam", "IPAddress"), None, IPAddressRoleChoices),
    ]:
        migrate_role_data(
            model_to_migrate=model_to_migrate,
            from_role_field_name="new_role",
            from_role_model=to_role_model,
            to_role_field_name="legacy_role",
            to_role_model=from_role_model,
            to_role_choiceset=from_role_choiceset,
        )


class Migration(migrations.Migration):
    dependencies = [
        ("ipam", "0010_alter_ipam_role_add_new_role"),
    ]

    operations = [
        migrations.RunPython(migrate_data_from_legacy_role_to_new_role, migrate_data_from_new_role_to_legacy_role),
    ]
