import os
import sys
sys.path.append(os.path.abspath('../..'))  # Adjust the path to the hinteval module

from dataclasses import asdict
from sphinxawesome_theme import ThemeOptions

# -- Project information -----------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#project-information

project = "hinteval"
copyright = "2024, Data Science Group of University of Innsbruck"
author = "Jamshid Mozafari"
release = "0.0.3"
print("HINTEVAL VERSION", "0.0.3")

# -- General configuration ---------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#general-configuration

html_title = "HintEval"
html_theme = "sphinxawesome_theme"
html_static_path = ["_static"]
html_css_files = [
    "css/hinteval.css",
    "css/highlight_python_dark.css",
    "css/highlight_ipython3_dark.css",
]
html_favicon = "./_static/favicon.ico"

extensions = [
    "sphinx.ext.doctest",
    "sphinx.ext.autodoc",
    "sphinx.ext.napoleon",
    "sphinx.ext.autosummary",
    "sphinx_design",
    "sphinxawesome_theme.highlighting",
    # "sphinxawesome_theme.docsearch",
    "myst_nb",
]

source_suffix = [".rst", ".md"]
templates_path = ["_templates"]
exclude_patterns = ["_build"]
myst_number_code_blocks = ["typescript"]

# algolia search
# docsearch_app_id = os.getenv("DOCSEARCH_APP_ID")
# docsearch_api_key = os.getenv("DOCSEARCH_API_KEY")
# docsearch_index_name = os.getenv("DOCSEARCH_INDEX_NAME")

# -- Options for HTML output -------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-html-output

# enable extensions
# https://myst-parser.readthedocs.io/en/latest/syntax/optional.html#syntax-admonitions
myst_enable_extensions = [
    "amsmath",
    "colon_fence",
    "deflist",
    "dollarmath",
    "fieldlist",
    "html_admonition",
    "html_image",
    "linkify",
    "replacements",
    "smartquotes",
    "strikethrough",
    "substitution",
    "tasklist",
    # "attrs_block",
]

theme_options = ThemeOptions(
    logo_light="./_static/imgs/hinteval-logo.png",
    logo_dark="./_static/imgs/hinteval-logo.png",
    extra_header_link_icons={
        "github": {
            "link": "https://github.com/my-unknown-account/HintEval",
            "icon": (
                '<svg height="26px" style="margin-top:-2px;display:inline" '
                'viewBox="0 0 45 44" '
                'fill="currentColor" xmlns="http://www.w3.org/2000/svg">'
                '<path fill-rule="evenodd" clip-rule="evenodd" '
                'd="M22.477.927C10.485.927.76 10.65.76 22.647c0 9.596 6.223 17.736 '
                "14.853 20.608 1.087.2 1.483-.47 1.483-1.047 "
                "0-.516-.019-1.881-.03-3.693-6.04 "
                "1.312-7.315-2.912-7.315-2.912-.988-2.51-2.412-3.178-2.412-3.178-1.972-1.346.149-1.32.149-1.32 "  # noqa
                "2.18.154 3.327 2.24 3.327 2.24 1.937 3.318 5.084 2.36 6.321 "
                "1.803.197-1.403.759-2.36 "
                "1.379-2.903-4.823-.548-9.894-2.412-9.894-10.734 "
                "0-2.37.847-4.31 2.236-5.828-.224-.55-.969-2.759.214-5.748 0 0 "
                "1.822-.584 5.972 2.226 "
                "1.732-.482 3.59-.722 5.437-.732 1.845.01 3.703.25 5.437.732 "
                "4.147-2.81 5.967-2.226 "
                "5.967-2.226 1.185 2.99.44 5.198.217 5.748 1.392 1.517 2.232 3.457 "
                "2.232 5.828 0 "
                "8.344-5.078 10.18-9.916 10.717.779.67 1.474 1.996 1.474 4.021 0 "
                "2.904-.027 5.247-.027 "
                "5.96 0 .58.392 1.256 1.493 1.044C37.981 40.375 44.2 32.24 44.2 "
                '22.647c0-11.996-9.726-21.72-21.722-21.72" '
                'fill="currentColor"/></svg>'
            ),
        },
    },
)

html_theme_options = asdict(theme_options)

# -- Myst NB Config -------------------------------------------------
nb_execution_mode = "off"
nb_execute_in_temp = True
