import unittest
from src.DLMS_SPODES.types import cdt, cst, ut
from src.DLMS_SPODES.cosem_interface_classes import collection, overview
from src.DLMS_SPODES.cosem_interface_classes.association_ln.authentication_mechanism_name import AuthenticationMechanismName
from src.DLMS_SPODES.cosem_interface_classes.association_ln import mechanism_id
from src.DLMS_SPODES.cosem_interface_classes.association_ln.ver0 import AssociatedPartnersType, AssociationLN, AttributeAccessDescriptor


class TestType(unittest.TestCase):

    def test_is_writable(self):
        ass = collection.AssociationLNVer1("00 00 28 00 03 ff")
        ass.set_attr(
            index=2,
            value=bytes.fromhex('0120020412000f110109060000280000ff0202010902030f0116010002030f0216010002030f0316010002030f0416010002030f0516010002030f0616010002030f0716010002030f0816010002030f09160100010402020f01160002020f02160002020f03160002020f0416000204120008110009060000010000ff0202010902030f0116010002030f0216030002030f0316030002030f0416010002030f0516030002030f0616030002030f0716030002030f0816030002030f09160300010602020f01160202020f02160002020f03160202020f04160202020f05160202020f0616010204120008110009060003010000ff0202010902030f0116010002030f0216010002030f0316010002030f0416010002030f0516010002030f0616010002030f0716010002030f0816010002030f09160100010602020f01160002020f02160002020f03160002020f04160002020f05160002020f061600020412000f110109060000280001ff0202010902030f0116010002030f0216010002030f0316010002030f0416010002030f0516010002030f0616010002030f0716010002030f0816010002030f09160100010402020f01160002020f02160002020f03160002020f04160002041200011100090600002a0000ff0202010202030f0116010002030f0216010001000204120001110009060000600100ff0202010202030f0116010002030f0216010001000204120001110009060000600101ff0202010202030f0116010002030f0216010001000204120001110009060000600102ff0202010202030f0116010002030f0216010001000204120001110009060000600103ff0202010202030f0116010002030f0216010001000204120001110009060000600104ff0202010202030f0116010002030f0216030001000204120001110009060000600106ff0202010202030f0116010002030f0216010001000204120001110009060000600107ff0202010202030f0116010002030f0216010001000204120001110009060000600108ff0202010202030f0116010002030f021601000100020412000111000906000060010aff0202010202030f0116010002030f0216010001000204120001110009060000000200ff0202010202030f0116010002030f0216010001000204120001110009060000000201ff0202010202030f0116010002030f0216010001000204120001110009060000000208ff0202010202030f0116010002030f0216010001000204120001110009060100000200ff0202010202030f0116010002030f0216010001000204120001110009060100000208ff0202010202030f0116010002030f0216010001000204120001110009060100000303ff0202010202030f0116010002030f0216010001000204120001110009060100000304ff0202010202030f0116010002030f0216010001000204120001110009060100000402ff0202010202030f0116010002030f0216030001000204120001110009060100000403ff0202010202030f0116010002030f0216010001000204120001110009060100000804ff0202010202030f0116010002030f0216030001000204120001110009060100000805ff0202010202030f0116010002030f0216030001000204120017110109060000160000ff0202010902030f0116010002030f0216030002030f0316010002030f0416010002030f0516010002030f0616010002030f0716010002030f0816010002030f0916010001000204120017110109060001160000ff0202010902030f0116010002030f0216030002030f0316010002030f0416010002030f0516010002030f0616010002030f0716010002030f0816010002030f0916030001000204120017110109060002160000ff0202010902030f0116010002030f0216010002030f0316010002030f0416010002030f0516010002030f0616010002030f0716010002030f0816010002030f0916010001000204120017110109060003160000ff0202010902030f0116010002030f0216010002030f0316010002030f0416010002030f0516010002030f0616010002030f0716010002030f0816010002030f0916010001000204120001110009060000600c04ff0202010202030f0116010002030f0216010001000204120001110009060080600c00ff0202010202030f0116010002030f02160100010002041200011100090600002b0102ff0202010202030f0116010002030f021601000100'))
        ln = cst.LogicalName.from_obis("0.0.1.0.0.255")
        res = ass.is_writable(
            ln=cst.LogicalName.from_obis("0.0.1.0.0.255"),
            index=1)
        self.assertEqual(False, ass.is_writable(ln, 1), "logical_name write access")
        self.assertEqual(True, ass.is_writable(ln, 2), "time write access")

    def test_authentication_name(self):
        auth_name = AuthenticationMechanismName.get_AARQ_mechanism_name(3, 2)
        self.assertEqual(auth_name, b'\x60\x85\x74\x05\x08\x03\x02')

    def test_MechanismIdElement(self):
        m_id_el = mechanism_id.MechanismIdElement(0)
        m_id_el2 = mechanism_id.MechanismIdElement(1)
        m_id_el3 = mechanism_id.LOW
        m_id_el4 = mechanism_id.LOW
        self.assertEqual(m_id_el>m_id_el2, False, "comparing")
        self.assertEqual(m_id_el3==m_id_el2, True, "comparing")
        self.assertEqual(m_id_el3>=m_id_el4, True, "comparing")

    def test_AssociatedPartnersType(self):
        a_p_t = AssociatedPartnersType()
        print(a_p_t)

    def test_init(self):
        ass = AssociationLN("00 00 28 00 00 ff")
        col = collection.Collection()
        ass = col.add(
            class_id=overview.ClassID.ASSOCIATION_LN,
            version=overview.VERSION_1,
            logical_name=cst.LogicalName("00 00 28 00 00 ff")
        )
        print(ass)

    def test_set_access_right(self):
        desc = AttributeAccessDescriptor()
        desc.set_read_access(cdt.Integer(1))
        print(desc)