from typing import Any, Callable, Mapping, Iterator
from abc import ABC, abstractmethod


class BaseModelContext(ABC, Mapping):
    @abstractmethod
    def __setitem__(self, key, value): ...
    @abstractmethod
    def __getitem__(self, key): ...
    @abstractmethod
    def __delitem__(self, key): ...
    @abstractmethod
    def __contains__(self, key) -> bool: ...
    @abstractmethod
    def __iter__(self) -> Iterator[Any]: ...
    @abstractmethod
    def __len__(self) -> int: ...
    @abstractmethod
    def run(self, model: Callable | str, _depth: int = 0, **kwargs): ...
    @abstractmethod
    def resource(self, name: str | dict[str, Any], *, attrs: Mapping[str, Any] = {}, **kwargs) -> Any: ...
