"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const path_1 = require("path");
const aws_redshift_1 = require("aws-cdk-lib/aws-redshift");
const nag_rules_1 = require("../../nag-rules");
/**
 * Redshift clusters have version upgrades enabled, automated snapshot retention periods enabled, and explicit maintenance windows configured
 * @param node the CfnResource to check
 */
exports.default = Object.defineProperty((node) => {
    if (node instanceof aws_redshift_1.CfnCluster) {
        const allowVersionUpgrade = nag_rules_1.NagRules.resolveIfPrimitive(node, node.allowVersionUpgrade);
        const automatedSnapshotRetentionPeriod = nag_rules_1.NagRules.resolveIfPrimitive(node, node.automatedSnapshotRetentionPeriod);
        if ((automatedSnapshotRetentionPeriod != undefined &&
            automatedSnapshotRetentionPeriod == 0) ||
            node.preferredMaintenanceWindow == undefined ||
            allowVersionUpgrade === false) {
            return nag_rules_1.NagRuleCompliance.NON_COMPLIANT;
        }
        return nag_rules_1.NagRuleCompliance.COMPLIANT;
    }
    else {
        return nag_rules_1.NagRuleCompliance.NOT_APPLICABLE;
    }
}, 'name', { value: (0, path_1.parse)(__filename).name });
//# sourceMappingURL=data:application/json;base64,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