% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateqs.R
\name{calculate_qs}
\alias{calculate_qs}
\title{Calculate Quality Score (QS) metrics for SVG detection methods}
\usage{
calculate_qs(
  gene_list,
  sample_ids,
  colors = NULL,
  top_k_values = seq(1000, 6000, by = 1000),
  org_db = org.Hs.eg.db,
  ont = "BP",
  method_labels = NULL
)
}
\arguments{
\item{gene_list}{A dataframe containing ranked gene lists from multiple methods and samples.
Required columns: gene, sample, method, rank, pred (prediction status)}

\item{sample_ids}{Character vector of sample IDs to include in analysis}

\item{colors}{Optional vector of colors for each method (will use default if NULL)}

\item{top_k_values}{Numeric vector of top K values to evaluate (default: seq(1000, 6000, by=1000))}

\item{org_db}{Organism database for GO enrichment (default: org.Hs.eg.db)}

\item{ont}{Ontology for GO enrichment (default: "BP")}

\item{method_labels}{Optional named vector of display names for methods}
}
\value{
A list containing:
        - metrics_df: Long-form dataframe with all calculated metrics
        - key_metrics: Wide-form summary table
        - plots: List of ggplot objects for visualization
        - method_colors: Colors used for each method
        - method_labels: Labels used for each method
}
\description{
Calculate Quality Score (QS) metrics for SVG detection methods
}
