# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic.v1 import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic.v1 import Field, StrictInt, StrictStr

from edgeimpulse_api.models.get_integration_session_status_response import GetIntegrationSessionStatusResponse
from edgeimpulse_api.models.start_integration_session_response import StartIntegrationSessionResponse
from edgeimpulse_api.models.start_tensor_board_session_request import StartTensorBoardSessionRequest

from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class IntegrationsApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def get_tensor_board_session_status(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], resource_id : Annotated[StrictStr, Field(..., description="Unique resource ID for an integration session. When an integration is launched we create a new session for it. Each session is uniquely identifiable by the project ID and resource ID. ")], **kwargs) -> GetIntegrationSessionStatusResponse:  # noqa: E501
        """Get TensorBoard session status

        Get the status of a TensorBoard session

        :param project_id: Project ID (required)
        :type project_id: int
        :param resource_id: Unique resource ID for an integration session. When an integration is launched we create a new session for it. Each session is uniquely identifiable by the project ID and resource ID.  (required)
        :type resource_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetIntegrationSessionStatusResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_tensor_board_session_status_with_http_info(project_id, resource_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_tensor_board_session_status_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], resource_id : Annotated[StrictStr, Field(..., description="Unique resource ID for an integration session. When an integration is launched we create a new session for it. Each session is uniquely identifiable by the project ID and resource ID. ")], **kwargs):  # noqa: E501
        """Get TensorBoard session status

        Get the status of a TensorBoard session

        :param project_id: Project ID (required)
        :type project_id: int
        :param resource_id: Unique resource ID for an integration session. When an integration is launched we create a new session for it. Each session is uniquely identifiable by the project ID and resource ID.  (required)
        :type resource_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetIntegrationSessionStatusResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'resource_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tensor_board_session_status" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['resource_id']:
            _path_params['resourceId'] = _params['resource_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetIntegrationSessionStatusResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/integrations/tensorboard/{resourceId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_tensor_board_session(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], start_tensor_board_session_request : StartTensorBoardSessionRequest, **kwargs) -> StartIntegrationSessionResponse:  # noqa: E501
        """Start TensorBoard integration

        Start a TensorBoard session for the requested learn blocks

        :param project_id: Project ID (required)
        :type project_id: int
        :param start_tensor_board_session_request: (required)
        :type start_tensor_board_session_request: StartTensorBoardSessionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartIntegrationSessionResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_tensor_board_session_with_http_info(project_id, start_tensor_board_session_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_tensor_board_session_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], start_tensor_board_session_request : StartTensorBoardSessionRequest, **kwargs):  # noqa: E501
        """Start TensorBoard integration

        Start a TensorBoard session for the requested learn blocks

        :param project_id: Project ID (required)
        :type project_id: int
        :param start_tensor_board_session_request: (required)
        :type start_tensor_board_session_request: StartTensorBoardSessionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartIntegrationSessionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'start_tensor_board_session_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_tensor_board_session" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['start_tensor_board_session_request']:
            _body_params = _params['start_tensor_board_session_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartIntegrationSessionResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/integrations/tensorboard/start', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
