# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic.v1 import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictInt

from edgeimpulse_api.models.add_organization_data_campaign_dashboard_request import AddOrganizationDataCampaignDashboardRequest
from edgeimpulse_api.models.add_organization_data_campaign_dashboard_response import AddOrganizationDataCampaignDashboardResponse
from edgeimpulse_api.models.add_organization_data_campaign_request import AddOrganizationDataCampaignRequest
from edgeimpulse_api.models.add_organization_data_campaign_response import AddOrganizationDataCampaignResponse
from edgeimpulse_api.models.generic_api_response import GenericApiResponse
from edgeimpulse_api.models.get_organization_data_campaign_dashboard_response import GetOrganizationDataCampaignDashboardResponse
from edgeimpulse_api.models.get_organization_data_campaign_dashboards_response import GetOrganizationDataCampaignDashboardsResponse
from edgeimpulse_api.models.get_organization_data_campaign_response import GetOrganizationDataCampaignResponse
from edgeimpulse_api.models.get_organization_data_campaigns_response import GetOrganizationDataCampaignsResponse
from edgeimpulse_api.models.organization_data_campaign_diff_request import OrganizationDataCampaignDiffRequest
from edgeimpulse_api.models.organization_data_campaign_diff_response import OrganizationDataCampaignDiffResponse
from edgeimpulse_api.models.update_organization_data_campaign_dashboard_request import UpdateOrganizationDataCampaignDashboardRequest
from edgeimpulse_api.models.update_organization_data_campaign_request import UpdateOrganizationDataCampaignRequest

from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class OrganizationDataCampaignsApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def add_organization_data_campaign(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_data_campaign_request : AddOrganizationDataCampaignRequest, **kwargs) -> AddOrganizationDataCampaignResponse:  # noqa: E501
        """Add a data campaign

        Add a new data campaign to a data campaign dashboard

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_data_campaign_request: (required)
        :type add_organization_data_campaign_request: AddOrganizationDataCampaignRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AddOrganizationDataCampaignResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._add_organization_data_campaign_with_http_info(organization_id, add_organization_data_campaign_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _add_organization_data_campaign_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_data_campaign_request : AddOrganizationDataCampaignRequest, **kwargs):  # noqa: E501
        """Add a data campaign

        Add a new data campaign to a data campaign dashboard

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_data_campaign_request: (required)
        :type add_organization_data_campaign_request: AddOrganizationDataCampaignRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AddOrganizationDataCampaignResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'add_organization_data_campaign_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_data_campaign" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['add_organization_data_campaign_request']:
            _body_params = _params['add_organization_data_campaign_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "AddOrganizationDataCampaignResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/campaigns', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def add_organization_data_campaign_dashboard(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_data_campaign_dashboard_request : AddOrganizationDataCampaignDashboardRequest, **kwargs) -> AddOrganizationDataCampaignDashboardResponse:  # noqa: E501
        """Add data campaign dashboard

        Add a new data campaign dashboard

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_data_campaign_dashboard_request: (required)
        :type add_organization_data_campaign_dashboard_request: AddOrganizationDataCampaignDashboardRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AddOrganizationDataCampaignDashboardResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._add_organization_data_campaign_dashboard_with_http_info(organization_id, add_organization_data_campaign_dashboard_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _add_organization_data_campaign_dashboard_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], add_organization_data_campaign_dashboard_request : AddOrganizationDataCampaignDashboardRequest, **kwargs):  # noqa: E501
        """Add data campaign dashboard

        Add a new data campaign dashboard

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param add_organization_data_campaign_dashboard_request: (required)
        :type add_organization_data_campaign_dashboard_request: AddOrganizationDataCampaignDashboardRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AddOrganizationDataCampaignDashboardResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'add_organization_data_campaign_dashboard_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_data_campaign_dashboard" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['add_organization_data_campaign_dashboard_request']:
            _body_params = _params['add_organization_data_campaign_dashboard_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "AddOrganizationDataCampaignDashboardResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/campaign-dashboards', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organization_data_campaign(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_id : StrictInt, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete data campaign

        Delete a data campaign

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_id: (required)
        :type campaign_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_organization_data_campaign_with_http_info(organization_id, campaign_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_organization_data_campaign_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_id : StrictInt, **kwargs):  # noqa: E501
        """Delete data campaign

        Delete a data campaign

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_id: (required)
        :type campaign_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'campaign_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization_data_campaign" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['campaign_id']:
            _path_params['campaignId'] = _params['campaign_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/campaigns/{campaignId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_organization_data_campaign_dashboard(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_dashboard_id : StrictInt, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete data campaign dashboard

        Delete a data campaign dashboard

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_dashboard_id: (required)
        :type campaign_dashboard_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_organization_data_campaign_dashboard_with_http_info(organization_id, campaign_dashboard_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_organization_data_campaign_dashboard_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_dashboard_id : StrictInt, **kwargs):  # noqa: E501
        """Delete data campaign dashboard

        Delete a data campaign dashboard

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_dashboard_id: (required)
        :type campaign_dashboard_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'campaign_dashboard_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_organization_data_campaign_dashboard" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['campaign_dashboard_id']:
            _path_params['campaignDashboardId'] = _params['campaign_dashboard_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/campaign-dashboard/{campaignDashboardId}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_data_campaign(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_id : StrictInt, **kwargs) -> GetOrganizationDataCampaignResponse:  # noqa: E501
        """Get data campaign

        Get a data campaign

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_id: (required)
        :type campaign_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetOrganizationDataCampaignResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_data_campaign_with_http_info(organization_id, campaign_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_data_campaign_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_id : StrictInt, **kwargs):  # noqa: E501
        """Get data campaign

        Get a data campaign

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_id: (required)
        :type campaign_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetOrganizationDataCampaignResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'campaign_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_data_campaign" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['campaign_id']:
            _path_params['campaignId'] = _params['campaign_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetOrganizationDataCampaignResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/campaigns/{campaignId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_data_campaign_dashboard(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_dashboard_id : StrictInt, **kwargs) -> GetOrganizationDataCampaignDashboardResponse:  # noqa: E501
        """Get data campaign dashboard

        Get a data campaign dashboard

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_dashboard_id: (required)
        :type campaign_dashboard_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetOrganizationDataCampaignDashboardResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_data_campaign_dashboard_with_http_info(organization_id, campaign_dashboard_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_data_campaign_dashboard_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_dashboard_id : StrictInt, **kwargs):  # noqa: E501
        """Get data campaign dashboard

        Get a data campaign dashboard

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_dashboard_id: (required)
        :type campaign_dashboard_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetOrganizationDataCampaignDashboardResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'campaign_dashboard_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_data_campaign_dashboard" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['campaign_dashboard_id']:
            _path_params['campaignDashboardId'] = _params['campaign_dashboard_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetOrganizationDataCampaignDashboardResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/campaign-dashboard/{campaignDashboardId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_data_campaign_dashboards(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs) -> GetOrganizationDataCampaignDashboardsResponse:  # noqa: E501
        """Get data campaign dashboards

        List all data campaign dashboards

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetOrganizationDataCampaignDashboardsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_data_campaign_dashboards_with_http_info(organization_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_data_campaign_dashboards_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], **kwargs):  # noqa: E501
        """Get data campaign dashboards

        List all data campaign dashboards

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetOrganizationDataCampaignDashboardsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_data_campaign_dashboards" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetOrganizationDataCampaignDashboardsResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/campaign-dashboards', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_data_campaign_diff(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_id : StrictInt, organization_data_campaign_diff_request : OrganizationDataCampaignDiffRequest, **kwargs) -> OrganizationDataCampaignDiffResponse:  # noqa: E501
        """Get diff for data campaign

        Get which items have changed for a data campaign. You post the data points and we'll return which data items are different in the past day.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_id: (required)
        :type campaign_id: int
        :param organization_data_campaign_diff_request: (required)
        :type organization_data_campaign_diff_request: OrganizationDataCampaignDiffRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OrganizationDataCampaignDiffResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_data_campaign_diff_with_http_info(organization_id, campaign_id, organization_data_campaign_diff_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_data_campaign_diff_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_id : StrictInt, organization_data_campaign_diff_request : OrganizationDataCampaignDiffRequest, **kwargs):  # noqa: E501
        """Get diff for data campaign

        Get which items have changed for a data campaign. You post the data points and we'll return which data items are different in the past day.

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_id: (required)
        :type campaign_id: int
        :param organization_data_campaign_diff_request: (required)
        :type organization_data_campaign_diff_request: OrganizationDataCampaignDiffRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OrganizationDataCampaignDiffResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'campaign_id',
            'organization_data_campaign_diff_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_data_campaign_diff" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['campaign_id']:
            _path_params['campaignId'] = _params['campaign_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['organization_data_campaign_diff_request']:
            _body_params = _params['organization_data_campaign_diff_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "OrganizationDataCampaignDiffResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/campaigns/{campaignId}/diff', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_organization_data_campaigns_for_dashboard(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_dashboard_id : StrictInt, **kwargs) -> GetOrganizationDataCampaignsResponse:  # noqa: E501
        """Get data campaigns

        Get a list of all data campaigns for a dashboard

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_dashboard_id: (required)
        :type campaign_dashboard_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetOrganizationDataCampaignsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_organization_data_campaigns_for_dashboard_with_http_info(organization_id, campaign_dashboard_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_organization_data_campaigns_for_dashboard_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_dashboard_id : StrictInt, **kwargs):  # noqa: E501
        """Get data campaigns

        Get a list of all data campaigns for a dashboard

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_dashboard_id: (required)
        :type campaign_dashboard_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetOrganizationDataCampaignsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'campaign_dashboard_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_data_campaigns_for_dashboard" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['campaign_dashboard_id']:
            _path_params['campaignDashboardId'] = _params['campaign_dashboard_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetOrganizationDataCampaignsResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/campaign-dashboard/{campaignDashboardId}/campaigns', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_organization_data_campaign(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_id : StrictInt, update_organization_data_campaign_request : UpdateOrganizationDataCampaignRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update data campaign

        Update a data campaign

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_id: (required)
        :type campaign_id: int
        :param update_organization_data_campaign_request: (required)
        :type update_organization_data_campaign_request: UpdateOrganizationDataCampaignRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._update_organization_data_campaign_with_http_info(organization_id, campaign_id, update_organization_data_campaign_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _update_organization_data_campaign_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_id : StrictInt, update_organization_data_campaign_request : UpdateOrganizationDataCampaignRequest, **kwargs):  # noqa: E501
        """Update data campaign

        Update a data campaign

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_id: (required)
        :type campaign_id: int
        :param update_organization_data_campaign_request: (required)
        :type update_organization_data_campaign_request: UpdateOrganizationDataCampaignRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'campaign_id',
            'update_organization_data_campaign_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization_data_campaign" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['campaign_id']:
            _path_params['campaignId'] = _params['campaign_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['update_organization_data_campaign_request']:
            _body_params = _params['update_organization_data_campaign_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/campaigns/{campaignId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_organization_data_campaign_dashboard(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_dashboard_id : StrictInt, update_organization_data_campaign_dashboard_request : UpdateOrganizationDataCampaignDashboardRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update data campaign dashboard

        Update a data campaign dashboard

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_dashboard_id: (required)
        :type campaign_dashboard_id: int
        :param update_organization_data_campaign_dashboard_request: (required)
        :type update_organization_data_campaign_dashboard_request: UpdateOrganizationDataCampaignDashboardRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._update_organization_data_campaign_dashboard_with_http_info(organization_id, campaign_dashboard_id, update_organization_data_campaign_dashboard_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _update_organization_data_campaign_dashboard_with_http_info(self, organization_id : Annotated[StrictInt, Field(..., description="Organization ID")], campaign_dashboard_id : StrictInt, update_organization_data_campaign_dashboard_request : UpdateOrganizationDataCampaignDashboardRequest, **kwargs):  # noqa: E501
        """Update data campaign dashboard

        Update a data campaign dashboard

        :param organization_id: Organization ID (required)
        :type organization_id: int
        :param campaign_dashboard_id: (required)
        :type campaign_dashboard_id: int
        :param update_organization_data_campaign_dashboard_request: (required)
        :type update_organization_data_campaign_dashboard_request: UpdateOrganizationDataCampaignDashboardRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'organization_id',
            'campaign_dashboard_id',
            'update_organization_data_campaign_dashboard_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization_data_campaign_dashboard" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['organization_id']:
            _path_params['organizationId'] = _params['organization_id']
        if _params['campaign_dashboard_id']:
            _path_params['campaignDashboardId'] = _params['campaign_dashboard_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['update_organization_data_campaign_dashboard_request']:
            _body_params = _params['update_organization_data_campaign_dashboard_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/organizations/{organizationId}/campaign-dashboard/{campaignDashboardId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
