# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr
from edgeimpulse_api.models.daily_metrics_record import DailyMetricsRecord
from edgeimpulse_api.models.entitlement_limits import EntitlementLimits

class AdminOrganizationInfoResponse(BaseModel):
    success: StrictBool = Field(..., description="Whether the operation succeeded")
    error: Optional[StrictStr] = Field(None, description="Optional error description (set if 'success' was false)")
    cpu_compute_time: Optional[float] = Field(None, alias="cpuComputeTime", description="CPU compute time in seconds of all jobs in the organization (including organizational project jobs).")
    gpu_compute_time: Optional[float] = Field(None, alias="gpuComputeTime", description="GPU compute time in seconds of all jobs in the organization (including organizational project jobs).")
    total_compute_time: Optional[float] = Field(None, alias="totalComputeTime", description="Total compute time is the amount of computation time spent in jobs, in minutes used by an organization over the given period, calculated as CPU + GPU minutes.")
    billable: Optional[StrictBool] = None
    entitlement_limits: Optional[EntitlementLimits] = Field(None, alias="entitlementLimits")
    compute_time_current_contract_since: Optional[datetime] = Field(None, alias="computeTimeCurrentContractSince", description="The date from which the compute time for the running contract is calculated.")
    total_storage: Optional[float] = Field(None, alias="totalStorage", description="Total storage used by the organization.")
    daily_metrics: Optional[List[DailyMetricsRecord]] = Field(None, alias="dailyMetrics", description="Metrics for the last 365 days")
    __properties = ["success", "error", "cpuComputeTime", "gpuComputeTime", "totalComputeTime", "billable", "entitlementLimits", "computeTimeCurrentContractSince", "totalStorage", "dailyMetrics"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> AdminOrganizationInfoResponse:
        """Create an instance of AdminOrganizationInfoResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of entitlement_limits
        if self.entitlement_limits:
            _dict['entitlementLimits'] = self.entitlement_limits.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in daily_metrics (list)
        _items = []
        if self.daily_metrics:
            for _item in self.daily_metrics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dailyMetrics'] = _items
        # set to None if daily_metrics (nullable) is None
        if self.daily_metrics is None:
            _dict['dailyMetrics'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AdminOrganizationInfoResponse:
        """Create an instance of AdminOrganizationInfoResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AdminOrganizationInfoResponse.construct(**obj)

        _obj = AdminOrganizationInfoResponse.construct(**{
            "success": obj.get("success"),
            "error": obj.get("error"),
            "cpu_compute_time": obj.get("cpuComputeTime"),
            "gpu_compute_time": obj.get("gpuComputeTime"),
            "total_compute_time": obj.get("totalComputeTime"),
            "billable": obj.get("billable"),
            "entitlement_limits": EntitlementLimits.from_dict(obj.get("entitlementLimits")) if obj.get("entitlementLimits") is not None else None,
            "compute_time_current_contract_since": obj.get("computeTimeCurrentContractSince"),
            "total_storage": obj.get("totalStorage"),
            "daily_metrics": [DailyMetricsRecord.from_dict(_item) for _item in obj.get("dailyMetrics")] if obj.get("dailyMetrics") is not None else None
        })
        return _obj

