# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.ai_action_last_preview_state import AIActionLastPreviewState
from edgeimpulse_api.models.ai_action_set_metadata_after_running_inner import AIActionSetMetadataAfterRunningInner
from edgeimpulse_api.models.ai_actions_config import AIActionsConfig

class AIAction(BaseModel):
    id: StrictInt = ...
    name: Optional[StrictStr] = Field(None, description="Manually set name (optional)")
    display_name: StrictStr = Field(..., alias="displayName", description="Name to show to the user when interacting with this action (e.g. in a table, or when running the action). Will return either \"name\" (if present), or a name derived from the transformation block.")
    config: AIActionsConfig = ...
    preview_config: AIActionsConfig = Field(..., alias="previewConfig")
    max_data_preview_count: StrictInt = Field(..., alias="maxDataPreviewCount", description="When rendering preview items, the max amount of items to show (pass this into the previewAIActionsSamples)")
    grid_column_count: StrictInt = Field(..., alias="gridColumnCount", description="Number of grid columns to use during preview.")
    last_preview_state: Optional[AIActionLastPreviewState] = Field(None, alias="lastPreviewState")
    set_metadata_after_running: List[AIActionSetMetadataAfterRunningInner] = Field(..., alias="setMetadataAfterRunning", description="After the action runs, add this key/value pair as metadata on the affected samples.")
    cache_unchanged_steps: StrictBool = Field(..., alias="cacheUnchangedSteps", description="If enabled, will load cached results from the previous preview job for unchanged jobs. Disable this if you're developing your own custom AI Labeling job, and want to always re-run all steps.")
    __properties = ["id", "name", "displayName", "config", "previewConfig", "maxDataPreviewCount", "gridColumnCount", "lastPreviewState", "setMetadataAfterRunning", "cacheUnchangedSteps"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> AIAction:
        """Create an instance of AIAction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of config
        if self.config:
            _dict['config'] = self.config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of preview_config
        if self.preview_config:
            _dict['previewConfig'] = self.preview_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of last_preview_state
        if self.last_preview_state:
            _dict['lastPreviewState'] = self.last_preview_state.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in set_metadata_after_running (list)
        _items = []
        if self.set_metadata_after_running:
            for _item in self.set_metadata_after_running:
                if _item:
                    _items.append(_item.to_dict())
            _dict['setMetadataAfterRunning'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AIAction:
        """Create an instance of AIAction from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AIAction.construct(**obj)

        _obj = AIAction.construct(**{
            "id": obj.get("id"),
            "name": obj.get("name"),
            "display_name": obj.get("displayName"),
            "config": AIActionsConfig.from_dict(obj.get("config")) if obj.get("config") is not None else None,
            "preview_config": AIActionsConfig.from_dict(obj.get("previewConfig")) if obj.get("previewConfig") is not None else None,
            "max_data_preview_count": obj.get("maxDataPreviewCount"),
            "grid_column_count": obj.get("gridColumnCount"),
            "last_preview_state": AIActionLastPreviewState.from_dict(obj.get("lastPreviewState")) if obj.get("lastPreviewState") is not None else None,
            "set_metadata_after_running": [AIActionSetMetadataAfterRunningInner.from_dict(_item) for _item in obj.get("setMetadataAfterRunning")] if obj.get("setMetadataAfterRunning") is not None else None,
            "cache_unchanged_steps": obj.get("cacheUnchangedSteps")
        })
        return _obj

