# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field
from edgeimpulse_api.models.bounding_box_with_score import BoundingBoxWithScore

class AnomalyResult(BaseModel):
    boxes: Optional[List[BoundingBoxWithScore]] = Field(None, description="For visual anomaly detection. An array of bounding box objects, (x, y, width, height, score, label), one per detection in the image. Filtered by the minimum confidence rating of the learn block.")
    scores: Optional[List[List[float]]] = Field(None, description="2D array of shape (n, n) with raw anomaly scores for visual anomaly detection, where n can be calculated as ((1/8 of image input size)/2 - 1). The scores corresponds to each grid cell in the image's spatial matrix.")
    mean_score: Optional[float] = Field(None, alias="meanScore", description="Mean value of the scores.")
    max_score: Optional[float] = Field(None, alias="maxScore", description="Maximum value of the scores.")
    __properties = ["boxes", "scores", "meanScore", "maxScore"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> AnomalyResult:
        """Create an instance of AnomalyResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in boxes (list)
        _items = []
        if self.boxes:
            for _item in self.boxes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['boxes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AnomalyResult:
        """Create an instance of AnomalyResult from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AnomalyResult.construct(**obj)

        _obj = AnomalyResult.construct(**{
            "boxes": [BoundingBoxWithScore.from_dict(_item) for _item in obj.get("boxes")] if obj.get("boxes") is not None else None,
            "scores": obj.get("scores"),
            "mean_score": obj.get("meanScore"),
            "max_score": obj.get("maxScore")
        })
        return _obj

