# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic.v1 import BaseModel, Field, StrictStr

class BlockThreshold(BaseModel):
    key: StrictStr = Field(..., description="Identifier to reference the threshold. You'll need to refer to the threshold by this key when you set the threshold).")
    description: StrictStr = Field(..., description="User-friendly description of the threshold.")
    help_text: StrictStr = Field(..., alias="helpText", description="Additional help text (shown in the UI under a \"?\" icon)")
    suggested_value: Optional[float] = Field(None, alias="suggestedValue", description="If the threshold has a suggested value, e.g. a max. absolute error for regression projects; or the min. anomaly score for visual anomaly detection, then this is the numeric value of that threshold.")
    suggested_value_text: Optional[StrictStr] = Field(None, alias="suggestedValueText", description="If the threshold has a suggested value, e.g. a max. absolute error for regression projects; or the min. anomaly score for visual anomaly detection, then this is the stringified value of that threshold.")
    value: float = Field(..., description="Current value of the threshold")
    __properties = ["key", "description", "helpText", "suggestedValue", "suggestedValueText", "value"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> BlockThreshold:
        """Create an instance of BlockThreshold from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BlockThreshold:
        """Create an instance of BlockThreshold from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BlockThreshold.construct(**obj)

        _obj = BlockThreshold.construct(**{
            "key": obj.get("key"),
            "description": obj.get("description"),
            "help_text": obj.get("helpText"),
            "suggested_value": obj.get("suggestedValue"),
            "suggested_value_text": obj.get("suggestedValueText"),
            "value": obj.get("value")
        })
        return _obj

