# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic.v1 import BaseModel, Field, StrictBool, StrictStr

class CreateDeviceRequest(BaseModel):
    device_id: StrictStr = Field(..., alias="deviceId", description="Globally unique device identifier (e.g. MAC address)")
    device_type: StrictStr = Field(..., alias="deviceType", description="Device type, for example the exact model of the device. Should be the same for all similar devices")
    if_not_exists: StrictBool = Field(..., alias="ifNotExists", description="Whether to throw an error when this device already exists.")
    __properties = ["deviceId", "deviceType", "ifNotExists"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> CreateDeviceRequest:
        """Create an instance of CreateDeviceRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateDeviceRequest:
        """Create an instance of CreateDeviceRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CreateDeviceRequest.construct(**obj)

        _obj = CreateDeviceRequest.construct(**{
            "device_id": obj.get("deviceId"),
            "device_type": obj.get("deviceType"),
            "if_not_exists": obj.get("ifNotExists")
        })
        return _obj

