# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic.v1 import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.block_type import BlockType
from edgeimpulse_api.models.dsp_named_axis import DSPNamedAxis

class DSPBlock(BaseModel):
    type: StrictStr = ...
    title: StrictStr = ...
    author: StrictStr = ...
    description: StrictStr = ...
    name: StrictStr = ...
    recommended: StrictBool = ...
    experimental: StrictBool = ...
    latest_implementation_version: StrictInt = Field(..., alias="latestImplementationVersion")
    organization_id: Optional[StrictInt] = Field(None, alias="organizationId")
    organization_dsp_id: Optional[StrictInt] = Field(None, alias="organizationDspId")
    block_type: BlockType = Field(..., alias="blockType")
    named_axes: Optional[List[DSPNamedAxis]] = Field(None, alias="namedAxes")
    supported_targets: Optional[List[StrictStr]] = Field(None, alias="supportedTargets", description="List of target devices that support this DSP block. If undefined this block works on all targets.")
    __properties = ["type", "title", "author", "description", "name", "recommended", "experimental", "latestImplementationVersion", "organizationId", "organizationDspId", "blockType", "namedAxes", "supportedTargets"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> DSPBlock:
        """Create an instance of DSPBlock from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in named_axes (list)
        _items = []
        if self.named_axes:
            for _item in self.named_axes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['namedAxes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DSPBlock:
        """Create an instance of DSPBlock from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DSPBlock.construct(**obj)

        _obj = DSPBlock.construct(**{
            "type": obj.get("type"),
            "title": obj.get("title"),
            "author": obj.get("author"),
            "description": obj.get("description"),
            "name": obj.get("name"),
            "recommended": obj.get("recommended"),
            "experimental": obj.get("experimental"),
            "latest_implementation_version": obj.get("latestImplementationVersion"),
            "organization_id": obj.get("organizationId"),
            "organization_dsp_id": obj.get("organizationDspId"),
            "block_type": obj.get("blockType"),
            "named_axes": [DSPNamedAxis.from_dict(_item) for _item in obj.get("namedAxes")] if obj.get("namedAxes") is not None else None,
            "supported_targets": obj.get("supportedTargets")
        })
        return _obj

